#include "../cmain.f"
#include "chookHybAS.f"
#include "../ctemplCeren.f"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"

 
c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.

c            namelist output
      call cwriteParam(ErrorOut, 1)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)
      end


c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "Zprivate2.h"
      stored = 0
      end
  

c     ************************************ hook for observation
c     *  One particle information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zprivate2.h"

      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
c                                below call will be realized only if
c                                DETAILED_TRACKINg == 1
c                                the enrgy can be changed  to discard
c                                the particle
c                           4 ==> ptcl is going to interact at this
c                                 point
c                           5 ==> ptcl is going to die at this point
c                           6 ==> ptcl is being discarded because path >
c                                 limit.  
c                           7 ==> ptcl angle relative to the parent is
c                                 to large (see BackAnglLimit)
c                             (Ondimentional mode dose not invoke this)
c                           8 ===>ptcl moved a step.
      record /track/ aTrack  ! input.  concerned track.
                             ! input/output. for id>3.  The use may
                             !     give very low energy to discard this
                             !     particle.
c
c
c
c        take memo of charged particles which have passed
c        the top surfarce (380km) once or more
      
      if( aTrack.p.charge .ne. 0 .and. aTrack.info .gt. 0 
     *     .and. id .le. 7 ) then
c           store typical quantities
         stored = stored + 1
         if( stored .gt. nstore ) then
            call cerrorMsg('nstore is too small',0)
         endif
         if(id .ge. 4) then
            where(stored) = -id
         else
            where(stored) = aTrack.where
         endif
         code(stored) = aTrack.p.code
         charge(stored) = aTrack.p.charge
         label(stored) = aTrack.label
         kenergy(stored) = aTrack.p.fm.p(4)-aTrack.p.mass
         x(stored) = aTrack.pos.xyz.r(1)
         y(stored) = aTrack.pos.xyz.r(2)
         z(stored) = aTrack.pos.xyz.r(3)
         wx(stored) = aTrack.vec.w.r(1)
         wy(stored) = aTrack.vec.w.r(2)
         wz(stored) = aTrack.vec.w.r(3)
         zenith(stored) = aTrack.vec.coszenith
         time(stored) = aTrack.t
      elseif( id .eq. 8 ) then
         if(aTrack.p.charge .eq. 0) then
            if(aTrack.p.code .eq. kphoton .or.
     *        aTrack.p.code .eq. knuc ) then
               if( aTrack.pos.height .gt. 70.0d3 .and.
     *              aTrack.vec.coszenith .lt. 0.) then
c                       photons and nutrons going upwards at
c                       very high altitudes, discarde it by giving
c                       very low energy
                  aTrack.p.fm.p(4) = 1.d-5 + aTrack.p.mass
                  aTrack.p.subcode = regptcl ! make it ordinary ptcl
                                           ! anti n can anihilate and
                                           ! not discarded even 0 energy
                                           !  so make it reg. ptcl.
               endif
            endif
         endif
      endif
c         you may need in some case other information such as
c       aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
                           ! ThinSampling =T)
c       aTrack.p.fm.p(1)      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.p(2)      !          y
c       aTrack.p.fm.p(3)      !          z

      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Zglobalc.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zprivate2.h"

      record /track/ inci
      record /coord/ angle
      integer i, j, jmax
      real maxt

      call cqIncident(inci, angle)
      write(*,'(i7,2i4,g13.4,3g14.3,4f9.5,i6)') 
     * EventNo, inci.p.code, inci.p.charge, 
     * sngl(inci.p.fm.e-inci.p.mass),
     * sngl(inci.pos.xyz.x), sngl(inci.pos.xyz.y), 
     * sngl(inci.pos.xyz.z), sngl(inci.vec.w.x), 
     * sngl(inci.vec.w.y),  sngl(inci.vec.w.z),
     * sngl(inci.vec.coszenith), stored


c      if(ObserveAS) then
c                   electron size in B approx.
c         write(*, *) (ASObsSites(i).esize, i=1, NoOfASSites)
c                   size weighted age
c         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites) 
c      endif

      i = 1
      do while ( i .le. stored )
         maxt = time(i)
         maxtime(i) = maxt
         do j = i+1, stored
            if(label(i) .eq. label(j)) then
               maxt = max(maxt, time(j))
            else
               jmax = j -1
               goto 10
            endif
         enddo
         jmax = stored
 10      continue
         do j = i, jmax
            maxtime(j) = maxt
         enddo
         i = jmax + 1
      enddo

      do i = 1, stored
        write(*,
     *  '(i2, i3, i3, i8, g13.4, 6g14.4, f9.5, 2f10.3)')
     *  where(i),   !  observation level.
     *  code(i),    !  ptcl code.  integer*2.
     *  charge(i),  !  charge, 
     *  label(i),   ! label; if this is the same, same ptcl
     *  kenergy(i),  ! kinetic energy in GeV
     *  x(i), y(i), z(i), wx(i), wy(i), wz(i), ! pos. and dir.
     *  zenith(i),   time(i)/c, maxtime(i)/c   !  zenith
      enddo
      write(*,*) '0 0 0 0 0 0 0 0 0 0 0 0 0 0'
      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
#include "Ztrack.h"
#include "Ztrackp.h"
      integer klena
      character*24  tracefile
      character*1  qm/"'"/
      if(Trace .gt. 0 )then
         tracefile = TraceDir(1:klena(TraceDir))//'/trace1'
        write(*, *)
     * '****** Congratulations: Cosmos is now your friend *******'
        write(*, *)
     * '       particle trace data has been created'//
     *     ' in '//tracefile
        write(*, *)
     * '       you can see it by gnuplot: For that, in gnuplot do'
        write(*, *)
     * '       set para'
        write(*, *)
     * '       splot "',tracefile(1:klena(tracefile)),'" w  l'
        write(*, *)
     * '   To see charged particles only, use following '
        write(*, *)  '      splot  "< awk ',qm,' $6 != 0 ; \ '
        write(*, *)  '           NF == 0 ',qm, ' \ '
        write(*, *)  '         ',tracefile(1:klena(tracefile)),
     *       ' " w l '
#ifdef sun4
        write(*, *) ' The last 3 lines should be on 1 line or',
     *  ' you need contination backslash'
#endif
       
        write(*, *)
     * '************      Have a nice day !!      **************'
        endif
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 60
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

      real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 60. 
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat',or  'anihi'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' or 'photop'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c     
      integer i, n
c      drop neutrinos
      n = 0

      do i = 1, Nproduced
         if(Pwork(i).code .eq. kneue) then
         elseif(Pwork(i).code .eq. kneumu) then
         else
            n = n + 1
            if(n .ne. i) then
               Pwork(n) = Pwork(i)
            endif
         endif
      enddo
      never = 0
      Nproduced = n
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
      end

      


