       subroutine cifXObsSite(nextwhere)
c         see if MovedTrack crosses an observation depth.
c         or go out of boundry.
c        if to be observed, reset MovedTrack information
      implicit none
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zearth.h"
c     
      integer nextwhere  ! output next where. to be used when ptcl
                         !  crosses an  observation  level. spherical case.
      integer loc
      real*8  leng, dedt, cosfromaxis
      real*8  clen2thick

      logical cross, ok
      integer  mustbe
      record /coord/ xyz1, xyz2, dircos, diffvec
      real*8 dummylen, r0, r0r, d, obsrl, height
c
c     ObsPlane == horizontal:
c                 Although the observation plane is horizontal (tangential at a
c                 sphere surface), we regard it as the sphere at the observation
c                 depth when we judge that a particle crosses the observation 
c                 level.  When we compute (x,y) at the observation level, we
c                 regards it completely flat surface.  
c             == perpendicular:
c                 This is exactly treated.
c             == spherical. 
c                  The same as horizontal case.  When the observation routine
c                 is called, (x,y) in E-xyz is used.  This latter point is
c                 diff. from horizontal case.
c
c                  
c
      cross = .false.

      if(ObsPlane .ne. notUsed ) then
         loc = MovedTrack.where 
         if(abs(ObsPlane) .eq. horizontal) then
c                  horizontal  ; old original def.
c            call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
c     *                  MovedTrack.pos.xyz, xyz2)
c            call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
c     *                  TrackBefMove.pos.xyz, xyz1)
c            if(TrackBefMove.vec.coszenith .gt. 0.) then
c               if( xyz2.r(3) .le. ObsSites(loc).zpl .and.
c     *             xyz1.r(3) .gt. ObsSites(loc).zpl ) then
            if(TrackBefMove.vec.coszenith .gt. 0.) then
               if(MovedTrack.pos.radiallen .le.
     *                 ObsSites(loc).pos.radiallen  .and.
     *           TrackBefMove.pos.radiallen  .gt.
     *                 ObsSites(loc).pos.radiallen ) then
                  cross = .true.
               elseif(loc .lt. NoOfSites) then 
c                  if( xyz1.r(3) .gt. ObsSites(loc+1).zpl  .and. 
c     *                xyz2.r(3) .le. ObsSites(loc+1).zpl) then
c                     cross =.true.
                  if( TrackBefMove.pos.radiallen .gt. 
     *                    ObsSites(loc+1).pos.radiallen
     *                 .and.
     *                MovedTrack.pos.radiallen .le.
     *                    ObsSites(loc+1).pos.radiallen ) then
                     cross =.true.
                     loc = loc + 1
                     MovedTrack.where = loc 
                     TrackBefMove.where = loc
                  endif
               endif
            else
c               if(xyz1.r(3) .lt.  ObsSites(loc).zpl .and.
c     *              xyz2.r(3) .ge.  ObsSites(loc).zpl) then
               if(TrackBefMove.pos.radiallen .lt. 
     *              ObsSites(loc).pos.radiallen .and.
     *            MovedTrack.pos.radiallen .ge.
     *              ObsSites(loc).pos.radiallen ) then
                  cross = .true.
               elseif(loc .gt. 1) then
c                  if(xyz1.r(3) .lt.  ObsSites(loc-1).zpl .and.
c     *               xyz2.r(3) .ge.  ObsSites(loc-1).zpl) then
                  if(TrackBefMove.pos.radiallen .lt.
     *                 ObsSites(loc-1).pos.radiallen .and.
     *               MovedTrack.pos.radiallen .ge. 
     *                 ObsSites(loc-1).pos.radiallen ) then
                     cross = .true.
                     loc = loc -1
                     MovedTrack.where = loc
                     TrackBefMove.where = loc
                  endif
               endif
            endif
         elseif(abs(ObsPlane) .eq. perpendicular) then
c           observation plane is perpendicular to primary
c           convert coord into 1ry system
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  TrackBefMove.pos.xyz, xyz1)
            call cscalerProd(TrackBefMove.vec.w, DcAtObsXyz, 
     *       cosfromaxis)
            if(cosfromaxis .gt. 0.) then
               if(xyz1.r(3) .gt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .le. ObsSites(loc).zpl) then
                  cross = .true.
               elseif(loc .lt. NoOfSites) then
                  if(xyz1.r(3) .gt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .le. ObsSites(loc+1).zpl) then
                     cross = .true.
                     loc = loc + 1
                     MovedTrack.where = loc
                     TrackBefMove.where = loc
                  endif
               endif
            else
               if(xyz1.r(3) .lt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .ge. ObsSites(loc).zpl ) then
                  cross = .true.
               elseif(loc .gt. 1) then
                  if(xyz1.r(3) .lt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .ge. ObsSites(loc-1).zpl) then
                     cross = .true.
                     loc = loc - 1
                     MovedTrack.where = loc
                     TrackBefMove.where = loc
                  endif
               endif
            endif
         elseif(ObsPlane .eq. spherical) then
            if( TrackBefMove.pos.height .ge. 
     *            ObsSites(loc).pos.height  .and.
     *            MovedTrack.pos.height .lt. 
     *            ObsSites(loc).pos.height ) then
               cross = .true.
               height = ObsSites(loc).pos.height
               mustbe = -1
c               MovedTrack.where =loc
               if(TrackBefMove.vec.coszenith .ge. 0.) then
                  nextwhere = min(loc+1, NoOfSites)
               else
                  nextwhere = max(loc-1, 1)
               endif
            elseif( TrackBefMove.pos.height .le. 
     *            ObsSites(loc).pos.height  .and.
     *            MovedTrack.pos.height .gt. 
     *            ObsSites(loc).pos.height ) then
               cross = .true.
               height = ObsSites(loc).pos.height
               mustbe = 1
c               MovedTrack.where = loc
               if(TrackBefMove.vec.coszenith .le. 0.) then
                  nextwhere = max(loc-1, 1)
               else
                  nextwhere = min(loc+1, NoOfSites)
               endif
            elseif(loc .gt. 1) then
               if( TrackBefMove.pos.height .le.
     *                    ObsSites(loc-1).pos.height .and.
     *                MovedTrack.pos.height .gt.
     *                    ObsSites(loc-1).pos.height ) then
                  cross =.true.
                  height = ObsSites(loc-1).pos.height
                  mustbe = 1 
                  loc = loc-1
                  MovedTrack.where = loc
c                  TrackBefMove.where = loc
                  nextwhere = max(loc-1,1)
               endif
            elseif(loc .lt. NoOfSites) then
               if(TrackBefMove.pos.height .ge.  
     *                ObsSites(loc+1).pos.height .and.
     *            MovedTrack.pos.height .lt. 
     *                ObsSites(loc+1).pos.height ) then
                  cross = .true.
                  height = ObsSites(loc+1).pos.height 
                  mustbe = -1
                  loc = loc +1
                  MovedTrack.where = loc 
                  nextwhere = min(loc+1, NoOfSites)
               endif
            endif
c            if(.not. cross .and.  loc .eq. NoOfSites) then
            if(.not. cross ) then
               if(TrackBefMove.pos.height .ge. BorderHeightL .and.
     *               MovedTrack.pos.height .lt. BorderHeightL)  then
c                   don't set cross
                  MovedTrack.where = -1 
                  MoveStat = BorderL
               endif
            endif
c            if(.not. cross .and. MoveStat .ne.
c     *                   BorderL .and. loc .eq. 1) then
            if(.not. cross .and. MoveStat .ne. BorderL ) then
               if(TrackBefMove.pos.height .le. BorderHeightH .and.
     *            MovedTrack.pos.height .gt. BorderHeightH ) then
c                    don't set cross
                  MovedTrack.where = 0 
                  MoveStat = BorderH
               endif
            endif
            if(.not. Cross .and. (MoveStat .ne. BorderL) .and.
     *          (MoveStat .ne. BorderH) ) then
c               this will happen, for example, the starting
c               depth is lower than BorderL(by epsilon due to
c               numerical innaccuracy). assume the ptcl crossed
c               the border
               if( TrackBefMove.pos.height .ge. BorderHeightH .and. 
     *             MovedTrack.pos.height .ge. BorderHeightH )  then
                  MoveStat = BorderH
                  MovedTrack.where = 0
               elseif( TrackBefMove.pos.height .le. BorderHeightL
     *                 .and. 
     *              MovedTrack.pos.height .le. BorderHeightL) then
                  MoveStat = BorderL
                  MovedTrack.where = -1
               endif
            endif
         endif
c//////////
c         write(*,*) 'corss=',cross, ' Move=',MoveStat,
c     *          ' MovedTrack.pos.height=',MovedTrack.pos.height,
c     *          ' TrackBefMove.pos.height', TrackBefMove.pos.height
c/////////
         if(cross) then
            MoveStat = ToBeObserved
c            write(*,*)' loc=',loc, ' h1=', TrackBefMove.pos.height,
c     *    ' obsh=',  ObsSites(loc).pos.height, 
c     *    ' h2=',  MovedTrack.pos.height
         endif
         if(cross .or. MoveStat .eq. BorderH .or. 
     *       MoveStat .eq. BorderL) then
c             get length, leng, from the starting point to
c             the observation depth
            call cdiffvec(TrackBefMove.pos.xyz, 
     *                    MovedTrack.pos.xyz, diffvec)
            call c3DV2DDCos(diffvec, diffvec, dummylen)

            if(abs(ObsPlane) .eq. horizontal) then
c                direction cos in det system
c               call cxyz2detD(diffvec, dircos)
c               leng = (ObsSites(loc).zpl - xyz1.r(3))/dircos.r(3)
c               leng = (0.d0 - xyz1.r(3))/dircos.r(3)
c                 0.01 (=1cm) is make sure that the ptcl crosses the plane.
c               the crossing point is made to be 1 cm apart from the real level
c               leng = leng + abs(0.01d0/dircos.r(3))
c                                   r0                 r  
               call cscalerProd(TrackBefMove.pos.xyz, diffvec,
     *               r0r)
               r0 = TrackBefMove.pos.radiallen
               d= r0r**2 -
     *             (r0**2 - ObsSites(loc).pos.radiallen**2)
               if(d .lt. 0.d0) then
                  write(*,*) ' d=',d
                  write(*,*) ' loc=',loc, ' r0=',r0, ' r0r=',r0r
                  write(*,*) ' diffvec=', diffvec.r(1), diffvec.r(2),
     *                       diffvec.r(3)
                  write(*,*) 'code=',TrackBefMove.p.code, ' E=',
     *                TrackBefMove.p.fm.p(4)
               endif
               if(r0 .le. ObsSites(loc).pos.radiallen) then
                  leng = -r0r + sqrt(d)
               else
                  leng = -r0r - sqrt(d)
               endif
               if(leng .lt. 0.) then
                  write(*,*) ' leng=',leng
                  write(*,*) ' d=',d
                  write(*,*) ' r0=', r0, ' r0r=',r0r, 'raidallen=',
     *            ObsSites(loc).pos.radiallen
               endif
               leng = leng + 0.01d0
            elseif(abs(ObsPlane) .eq. perpendicular) then
c                direction cos in 1ry system
               call cxyz2primD(diffvec, dircos)
               leng = (ObsSites(loc).zpl - xyz1.r(3))/dircos.r(3)
               leng = leng + abs(0.01d0/dircos.r(3))
            else         
c                 spherical
c                                   r0                 r  
               call cscalerProd(TrackBefMove.pos.xyz, diffvec,
     *               r0r)
               r0 = TrackBefMove.pos.radiallen
               if( MovedTrack.where .gt. 0) then
                  obsrl =  ObsSites(loc).pos.radiallen
               elseif(MovedTrack.where .eq. 0) then
                  obsrl = BorderHeightH + Eradius
               else
                  obsrl = BorderHeightL + Eradius
               endif
               if(r0 .le. obsrl ) then
                  leng = -r0r + sqrt(r0r**2 -
     *             (r0**2 - obsrl**2))
               else
                  leng = -r0r - sqrt(r0r**2 -
     *              (r0**2-obsrl**2))
               endif
               leng = leng + 0.01d0
            endif

c   

            IntInfArray(ProcessNo).length = leng
            IntInfArray(ProcessNo).thickness = clen2thick(
     *           TrackBefMove.pos.radiallen - Eradius,
     *           TrackBefMove.vec.coszenith, leng)

c
c            call ccompPathEnd  ! this call produce some error
c                                 on the crossing coordinate so we
c                          use straight line approximation here.
c             reset MovedTrack
c            MovedTrack = TrackBefMove   !  not needed
            call cmoveStreight(leng, diffvec)
            if(ObsPlane .eq. spherical) then
c                  confirm that ptcl crosses the plane
               if(MoveStat .ne. BorderH .and.
     *            MoveStat .ne. BorderL) then
                  ok = .false.
                  do while (.not. ok)
                     if(mustbe .eq. 1) then
                        ok = MovedTrack.pos.height .gt. height
                     else
                        ok = MovedTrack.pos.height .lt. height
                     endif
                     if(.not. ok) then
                        leng = leng*1.0001d0
                        call cmoveStreight(leng, diffvec)
                     endif
                  enddo
               endif
            endif

            if(MovedTrack.p.charge .ne. 0) then
               call cqElossRate(dedt) ! get de/dx computed previously
               MovedTrack.p.fm.p(4) =max( TrackBefMove.p.fm.p(4) -
     *          dedt * IntInfArray(ProcessNo).thickness,
     *          MovedTrack.p.mass)   ! max is for safety. we neg. 
                                     ! syncrotron loss
            endif
c               ** next produces error due the curvature of earth
c            if(ObsPlane .eq. horizontal) then
c                if det system, below is exact.
c               MovedTrack.pos.height = ObsSites(loc).pos.height
c               MovedTrack.pos.radiallen = ObsSites(loc).pos.radiallen
c               MovedTrack.pos.depth = ObsSites(loc).pos.depth
c            endif
         endif
      endif
      if(.not. cross .or. ObsPlane .eq. notUsed) then
c        
         if(BackAngLimit .gt. -1.0) then
            call cscalerProd(MovedTrack.vec.w, DcAtObsXyz, cosfromaxis)
            if(cosfromaxis .lt. BackAngLimit) then
c                discard it
               MoveStat = AngleLimit
            endif
         endif
      endif
      end
      subroutine cdiffvec(r1, r2, diff)
c        get diff= r2-r1 as 3 D vector
#include      "Zcoord.h"
      record /coord/ r1,  r2  ! input 
      record /coord/ diff     ! output.  

      integer i

      do i = 1, 3
         diff.r(i) = r2.r(i) - r1.r(i)
      enddo
      end




