c      include '../../KKlib/rnd.f'
c      include '../../KKlib/kcossn.f'
c      include 'cpxyzp.f'
c      include 'cmkptc.f'
cc  ----------------------------------
cc       to test cnbdcy
c      include '../Zptcl.h'
c      include '../Zcode.h'
c      implicit none
c      integer  n, i, j, icon
c      parameter(n = 10)
c      record /ptcl/ p(n)
c      real *8  ecm/5./, w, sumx, sumy, sumz, sume
c      j = 1
c      do i=1, 3
c         call cmkptc(kpion, 0, 1,  p(j))
c         call cmkptc(kkaon, k0s, 0, p(j+1))
c         call cmkptc(kpion, 0, 0, p(j+2))
c         j = j+3
c      enddo
c      call cmkptc(komega, 0, 0,  p(n))
c      do j=1, 100
c            call cnbdcy(n, ecm,  p, 0,  w, icon)
c            if(icon .ne. 0) stop 111
c            sumx=0.
c            sumy=0.
c            sumz=0.
c            sume=0.
c            write(*, *) ' ----------w=', w
c            do i=1, n
cc             ---------------------- to draw momentum balance graph
cc                 write(*,*) 0., 0.
cc                 write(*,*) sngl(p(i).fm.p(1)), sngl(p(i).fm.p(3))
cc                 write(*,*)
cc            --------------------------
cc                /////////// to see momentum conservation
c               sumx=sumx + p(i).fm.p(1)
c               sumy=sumy + p(i).fm.p(2)
c               sumz=sumz + p(i).fm.p(3)
c               sume=sume + p(i).fm.p(4)
cc              ///////////////////////
c           enddo
c           write(*,*) sumx, sumy, sumz, sume
c       enddo
c      end
c      ***********************************************************
       subroutine cnbdcy(n, ecm, p, jw,  w, icon)
       implicit none
c      ***********************************************************
c
c        ref:  CPC.  40(1986)p359.  Kleiss, Stirling and Ellis
c
c       n: input.  number of ptcls >=2 (see however, for n=2,
c                  c2bdcy and for n=3, c3bdcy)
c     ecm: input.  cms energy.
c       p: input.  /ptcl/ p(i).mass gives the mass of the i-th ptcl
c                  in the same unit of ecm.
c         output.  /ptcl/ p(i).fm.p(1)
c                                 py
c                                 pz
c                                 e   of the i-th ptcl
c      jw: input.  0--->unweighted event (w=1) obtained. the event
c                  generated need not be discarded.
c                  1--> weighted event( w changes event to event )
c                  the event must be discarded according to the
c                  acceptance probability of w=weight/wax weight).
c      w: output.  see jw
c   icon: output.  0-->event generated successfully
c                  1-->ecm < sum of mass
c                  2-->could not generate (weight problem)
c
c
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n, jw, icon
       record /ptcl/ p(n)
       real*8 ecm, w
c      ------------------
       real*8 mu(1, 1)/0.d0/, wx, w0, wmax, gzai, u
c
       logical ok
       integer nc
c
	nc = 0    ! counter to break inf. loop
c       *** until loop*** 
       do while (.true.)
c            generate massless ptcls isotropically without conservation
           call cnbdc1(n, p)
c             conformal transformation to conserve 4-momentum
           call cnbdc2(n, ecm, p)
c$$$$$$$$$$$
c          call cnbdct(n, p)
c$$$$$$$$$$
c             get gzai to transform massive case
           call cnbdc3(n, ecm, p, mu, 0,  gzai, icon)
c          **********************
           if(icon .ne. 0) return
c          **********************
c             tranform to massive case
           call cnbdc4(n, p,  mu, 0, gzai)
c$$$$$$$$$$$
c          call cnbdct(n, p)
c$$$$$$$$$$
c             compute weight for massive  case
           call cnbdc5(n, ecm,p, wx)
c             compute weight for massless case
           call cnbdc6(n, ecm, w0)
c$$$$$$$$$$$$$$
c          write(*,*) ' wx=',wx,' w0=',w0
c$$$$$$$$$$$
           w=wx*w0
c                compute max possible weight
           call cnbdc7(n, ecm, p,  wmax)
           wmax=wmax*w0
           if(jw .eq. 0) then
c$$$$$$$$$$$$$$
c          write(*,*) ' wmax=',wmax
c$$$$$$$$$$$
c                judge if the event is to be accepted
              call rndc(u)
              if(wmax .eq. 0.d0) then
                 ok=.true.
              else
                 ok = u .lt. w/wmax
              endif
              w=1.
           else
              if(wmax .eq. 0.d0) then
                 w=1.d0
              else
                 w=w/wmax
              endif
              ok=.true.
           endif
           if(ok) goto 100
	   nc = nc +1
	   if(nc .gt. 20) then
	      icon = 2
	      goto 100
           endif
       enddo
  100  continue
       end
       subroutine cnbdct(n, p)
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ p(n)
c
       real*8 sumx, sumy, sumz, sume
       integer i
c
           sumx=0.d0
           sumy=0.d0
           sumz=0.d0
           sume=0.d0
           do   i=1, n
              sumx=sumx+p(i).fm.p(1)
              sumy=sumy+p(i).fm.p(2)
              sumz=sumz+p(i).fm.p(3)
              sume=sume+p(i).fm.p(4)
           enddo
           write(*,*) ' sumx,y,z=',sumx, sumy, sumz, ' sume=',sume
       end
       subroutine cnbdc1(n, p)
       implicit none
c            generate massless ptcls isotropically without conservation
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ p(n)
c
       integer i
       real*8 u1, u2, u, cs, sn, cst, snt
       do   i=1, n
c             *** until loop*** 
             do while (.true.)
                 call rndc(u1)
                 call rndc(u2)
                 u=u1*u2
                if(u .gt. 0.) goto 10
             enddo
   10        continue
             p(i).fm.p(4) = -log(u)
             call kcossn(cs, sn)
             call rndc(u)
             cst=2*u-1.d0
             snt=sqrt(1. - cst**2)
             p(i).fm.p(1) = p(i).fm.p(4)*snt*cs
             p(i).fm.p(2) = p(i).fm.p(4)*snt*sn
             p(i).fm.p(3) = p(i).fm.p(4)*cst
           enddo
       end
       subroutine cnbdc2(n, ecm, p)
c             conformal transformation to conserve 4-momentum
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ p(n)
       real*8 ecm
c
       real*8 sumx, sumy, sumz, sume, em, g
       real*8 a, x, bx, by, bz, bq, pe, tmp, px, py, pz
       integer i
c
       sumx=0.d0
       sumy=0.d0
       sumz=0.d0
       sume=0.d0
       do   i=1, n
          sumx=sumx+p(i).fm.p(1)
          sumy=sumy+p(i).fm.p(2)
          sumz=sumz+p(i).fm.p(3)
          sume=sume+p(i).fm.p(4)
       enddo
       em=sqrt( sume**2 - (sumx**2+sumy**2+sumz**2) )
       g=sume/em

       a=1.d0/(1.d0+g)
       x=ecm/em
       bx=-sumx/em
       by=-sumy/em
       bz=-sumz/em
c
       do   i=1, n
          bq=bx*p(i).fm.p(1) + by*p(i).fm.p(2) + bz*p(i).fm.p(3)
          pe=x*(g*p(i).fm.p(4) +bq)
          tmp=p(i).fm.p(4)+a*bq
          px=x*(p(i).fm.p(1) +   tmp*bx)
          py=x*(p(i).fm.p(2) +   tmp*by)
          pz=x*(p(i).fm.p(3) +   tmp*bz)
          p(i).fm.p(1)=px
          p(i).fm.p(2)=py
          p(i).fm.p(3)=pz
          p(i).fm.p(4)=pe
        enddo
       end
c      ***********************************************
       subroutine  cnbdc3(n, ecm, p, mu, inm, gzai, icon)
c             get gzai to transform massive case
c             put inm=0 if all mu are the same.
c      ***********************************************
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n, inm, icon
       record /ptcl/ p(n)
       real*8 ecm, mu(inm, n), gzai
c
       real*8 eps/1.d-3/, f, fp, fow
       integer nr
c           initial guess of gzai
       gzai=.85d0
       nr=0
c          *** until loop*** 
       do while (.true.)
               call cnbdcf(n, ecm, p,  mu, inm,  gzai, f, fp)
               gzai=  gzai - f/fp
               fow=f
               nr=nr+1
c$$$$$$$$$$$$
c              write(*,*) ' fow=',fow
c$$$$$$$$$$$$
              if(abs(fow) .lt. eps .or. nr .gt. 15) goto 100
       enddo
  100  continue
       if(nr .gt. 15) then
           icon=1
       else
           icon=0
       endif
       end
c      *********************************************
       subroutine cnbdcf(n, ecm, p, 
     *            mu, inm, gzai, f, fp)
c      *********************************************
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n, inm
       record /ptcl/ p(n)
       real*8 gzai, f, fp, mu(inm, n)
c
       real*8 mux, fx, tmp, ecm
       integer i
c
       fx=0.d0
       fp=0.d0
       do   i=1, n
c                  if compiler is good, we can use mu(1,i)
c                  even for inm=0; next is for safty.
              if(inm .eq. 0) then
c                 mux=mu(1,1)
                  mux=0.d0
              else
                  mux=mu(1,i)
              endif

              tmp=  sqrt(p(i).mass**2+
     *        gzai**2 *( p(i).fm.p(4)**2 -mux**2 ) )
              fx=fx + tmp
              fp=fp + ( p(i).fm.p(4)**2- mux**2)/ tmp
           enddo
          f=log(fx/ecm)
          fp=fp*gzai/fx
       end
c      *********************************************
       subroutine  cnbdc4(n, p, mu, inm,  gzai)
c             tranform to massive case
c      *********************************************
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n, inm
       record /ptcl/ p(n)
       real*8 mu(inm, n), gzai

       real*8 mux
       integer i
       do   i=1,n
             p(i).fm.p(1) = gzai*p(i).fm.p(1)
             p(i).fm.p(2) = gzai*p(i).fm.p(2)
             p(i).fm.p(3) = gzai*p(i).fm.p(3)
c                next treatment is for safty
             if(inm .eq. 0) then
c                mux=mu(1,1)
                 mux=0.
             else
                 mux=mu(1,i)
             endif
             p(i).fm.p(4) = sqrt(p(i).mass**2 +
     *       gzai**2*( p(i).fm.p(4)**2-mux**2 ) )
           enddo
       end
       subroutine  cnbdc5(n, ecm, p, wx)
c            compute weig.p(4) for massive case
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ p(n)
       real*8 ecm, wx
c
       real*8 sum1, pro2, sum3, pab
       integer i
c
          sum1=0.
          pro2=1.
          sum3=0.
          do   i=1, n
             call cpxyzp(p(i).fm,  pab)
             sum1=sum1+pab
             pro2=pro2* pab/p(i).fm.p(4)
             sum3=sum3+pab**2/p(i).fm.p(4)
          enddo
          wx=(sum1/ecm)**(2*n-3)*pro2 /sum3
       end
       subroutine cnbdc6(n, ecm, w0)
c             compute weig.p(4) for massless case
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       real*8 ecm, w0
c
       real*8 pi, hpi, gn1
       integer i
       parameter (pi=3.14159265d0, hpi=pi/2)
c
          gn1=1.
          do   i=1, n-2
             gn1=gn1*i
          enddo
          w0=  hpi**(n-1) * ecm**(2*n-4)/(n-1)/gn1/gn1
       end
       subroutine cnbdc7(n, ecm, p,  wmax)
c                compute max possible weig.p(4)
       implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       integer n
       record /ptcl/ p(n)
       real*8 ecm, wmax

       integer idx(2), nm, i
       real*8 summ, en, beta
c          count massive ptcls
         nm=0
         do   i=1,n
            if(p(i).mass .gt. 0.d0) then
               nm=nm+1
               if(nm .le. 2) then
                  idx(nm)=i
               endif
            endif
         enddo
         if(nm .eq. 1) then
             wmax=(1. - p(idx(1)).mass/ecm)**(2*n-3)
         elseif(nm .eq. 2)  then
             wmax=
     *        (1. + (p(idx(1)).mass/ecm)**2 -
     *        (p(idx(2)).mass/ecm)**2 )**2
     *       -4*(p(idx(1)).mass/ecm)**2
             if(wmax .le. 0.d0)then
                wmax=1.d-30
             else
                wmax= wmax**(n-1.5d0)
             endif
         else
             summ=0.d0
             do   i=1, n
                 if(p(i).mass .gt. 0.d0) then
                    en=p(i).mass/ecm
                    summ=summ+en
                 endif
             enddo
             beta=1. - summ**2
             if(beta .le. 0.d0) then
                wmax=1.d-30
             else
                wmax=sqrt(beta)**(2*n+nm-5)
             endif
         endif
       end
