c         test caslantdep
c
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
      real*8 z1, cost, caslantdep
      do z1 = 0., 11.d3, .5d3
           do cost = 1.d0, -1.d-15, -0.001d0
              write(*, *) sngl( cost), ' ',
     *              sngl( caslantdep(z1, cost)*Togpcm2 )
           enddo
           write(*, *)
      enddo
      end
c    *************************************
      real*8 function caslantdep(z1, cost)
c    *************************************
c           caslantdep:  compute approximate slant depth
c        at a given height to a given zenith angle direction.
c
c      z1:  given height (m) from the earth surface.
c    cost:  zenith angle to which the slant depth is
c           computed.
c   function value. slant depth in kg/m2.
c  -----------------------------------------------------
c    Suppose an exponential atmospher of which the
c  air density is expressed  as
c
c       RHO = RHO0 * exp(- z/z0)
c  where z is the vertical height, z0 the scale height.
c 
c  the slant depth at height z1 directed to the zenith angle 
c  of theta is, for small theta,
c
c       slant dep = RHO0*z0 exp(-z1/z0)/cos(theta)
c
c    for large theta, we replace this cos value by effective
c  one.   As the effective cos, we use the zenith angle at
c    a vertical height z1+z0/2.  
c  Another approach, which is more mathematical one, but 
c  little bit slower one is given in caslantdep.f
c
c  --------------------------------------------------------------
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 z1, cost

      real*8 rho0, z0, efz
      parameter (z0 = 6.33d3, rho0 = 1030.d0*Tokgpm2/z0, 
     *   efz=z0/3.)
      real*8 sint
      real*8 efcos, len, h


      if(cost .ge.  0.4) then
c          this is good even at cost=0.4 on the graph
c          actuall accuracy is not so important for the
c          ratio of exact / approx.
c          but at very high altitude, be carefull.
c        so the inteplation formula should be made for cos =0 to .39999
c        and .4 and above, separately.
         caslantdep = rho0 * z0 * exp(-z1/z0)/cost
      else
         h = z1+Eradius
         sint = sqrt(1.d0 - cost**2)
c         if(cost**2/(efz/4.d0/h) .gt. 100.d0) then
c            len =efz/cost
c         else
            len = h/sint**2 *( -cost +
     *            sqrt(cost**2 + 2*efz*sint**2/h))
c         endif
         efcos = h/(h+efz) * cost + len/(h+efz)
         caslantdep = rho0 * z0 * exp(-z1/z0)/efcos
      endif
      end


