c         test caheight: get approximate height from 
c         cosz and slant depth. to height
c
c      implicit none
c      include '../../Zglobalc.h'
c      real*8 sdep, cost, caheight, temp
c      do cost = 0.d0, .80001d0, 0.1d0
c         do sdep = 10000.d0, 360000.d0, 1000.d0
c              temp = caheight(sdep, cost)
cc              if(temp .lt. 0.) goto 10
c              write(*, *) sngl( cost), sngl(sdep), 
c     *          sngl(temp)
c
c           enddo
c10         continue
c           write(*, *)
c      enddo
c      end
c    *************************************
      real*8 function caheight(sdep, cost)
c    *************************************
c           caheight:  compute approximate vertical height
c        for a  given slant depth  to a given zenith angle direction.
c
c    sdep:  given slant depth (kg/m2) above a some height
c    cost:  zenith angle to which the slant depth is
c           computed.
c   function value. vertical height m
c  -----------------------------------------------------
c    Suppose an exponential atmospher of which the
c  air density is expressed  as
c
c       RHO = RHO0 * exp(- z/z0)
c  where z is the vertical height, z0 the scale height.
c 
c  the slant depth at height z1 directed to the zenith angle 
c  of theta is
c
c      slant depth = I(0:inf){RHO(l)}dl
c  where l is the length along the theta. At point l,
c  the vertical height is
c
c   z =   sqrt(l**2 + H**2 +2Hlcos(t)) - H + z1
c  where 
c      H = Re + z1, cos(t) = cos(theta)
c  and Re is the earth radius.
c  Therefore we may substitute this expression into
c  RHO.
c  For the approximate integration, we can approximate
c  the vertical height at l to be
c
c      z1 + l cos(t) + sin(t)**2/2/H * l**2
c  Then, for the exponential atmosphere, we get,
c
c    slant depth =
c
c        RHO0 I(0:inf){exp(-(z1/z0 + l/z0 cos(t)
c                            
c                           sin(t)**2
c                           ~~~~~~~~~   (l/z0)**2))} dl
c                           (Re+z1)/z0
c
c         = RHO0 *z0 *I(0:inf){exp(-(z1/z0 + cos(t)x +
c 
c                          sin(t)**2
c                          ~~~~~~~~~~ x**2))} dx
c                          (Re+z1)/z0
c
c         = RHO0*z0*exp(-z1/z0)I(0:inf){exp(-(cos(t)x +
c
c                          sin(t)**2
c                          ~~~~~~~~~~ x**2))} dx
c                          (Re+z1)/z0
c
c                                 1
c         = RHO0*z0* exp(-z1/z0) ---sqrt(pi/a) exp((Re+z1)/z0 * cot(t)**2/4 )
c                                 2 
c
c                       *  kerfc(cot(t)sqrt(Re+z1)/z0))
c
c               where a is sin(t)**2/(Re+z1)/z0
c
c  if sin(t)~0, this is, of course,
c
c         = RHO0*z0*exp(-z1/z0)/cos(t)
c  We furuther neglect the z1 in Re + z1, then
c  we can solve the above equation for z1, i.e.,
c
c  z1 = - z0 log(s.d/I)
c  
c
c  where  I is
c
c                   1
c    I = RHO0*z0*  ---sqrt(pi/a) exp(Re/z0 * cot(t)**2/4 )
c                   2 
c
c                       *  kerfc(cot(t) * sqrt(Re/z0)
c  --------------------------------------------------------------
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 sdep, cost

      real*8 rho0, z0, hbyz0
      parameter (z0 = 6.33d3, rho0 = 1030.d0*Tokgpm2/z0, 
     *hbyz0 =2*Eradius/z0)
      real*8 sint, cott, sqrthbyz0, kerfc, erfarg
      real*8 experfc, temp, z1


      if(cost .ge.  0.6) then
c          this is good even at cost=0.4 on the graph
c          actuall accuracy is not so important for the
c          ratio of exact / approx.
c          but at very high altitude, be carefull.
c        so the inteplation formula should be made for cos =0 to .39999
c        and .4 and above, separately.
         z1 = - log( (sdep*cost)/(rho0 * z0 )) *z0
      else
         sint = sqrt(1.d0 - cost**2)
         cott = cost/sint

         sqrthbyz0 = sqrt(hbyz0)
         erfarg = cott*sqrthbyz0/2
         if(erfarg .gt. 20.d0) then
            temp = 2*erfarg**2
c              exp(z**2)erfc(z)=            
            experfc =
     *       (1.d0 - 1.d0/temp + 3.d0/temp**2 - 15.d0/temp**3)
     *       /sqrtpi/erfarg
         else
            experfc =exp(hbyz0*cott**2/4)* kerfc(cott/2*sqrthbyz0)
         endif
         z1 =-log(sdep/ (rho0*z0)/(experfc*
     *                sqrtpi* sqrthbyz0/sint/2))* z0
      endif
      caheight = z1
      end

