#include "../cmain.f"
#include "chookHybAS.f"
#include "../ctemplCeren.f"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Zprivate.h"

 
c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.

c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
c      call cprintObs(ErrorOut)


      end


c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "Zprivate.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"

      record /track/ inci
      record /coord/ angle

c      call cqIncident(inci, angle)
c      write(*,'(i7,i4,g13.4,3g14.3,4f8.5)')
c     * EventNo, inci.p.code, inci.p.fm.e,
c     * inci.pos.xyz.x, inci.pos.xyz.y, inci.pos.xyz.z,
c     * inci.vec.w.x, inci.vec.w.y, inci.vec.w.z, inci.vec.coszenith



      Cutoff =  10

      end
  

c     ************************************ hook for observation
c     *  One particle information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Ztrack.h"
#include "Zprivate.h"
      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c
c

      if(id .eq. 1) then
c               goes thru upper bound
         Cutoff = 0
      elseif(id .eq. 2) then
c             crash  to the atmosphere
         Cutoff = 1
      else
c             crash  to the lower bound
         Cutoff = 2
      endif

      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none

#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zprivate.h"


      record /track/ inci
      record /coord/ angle

      if(Cutoff .eq. 0) then
c          record if the primary can come from  space
         call cwriteSeed
      endif
c         record cutt off information;get primary info.
      call cqIncident(inci, angle)
c            For ObsPlane angle has nosense.

c     ************************************8
c          output 
c       cutoff     ! 0 --> not cutoff
c                    !=0 --> cutoffed
c       particle code
c       particle kinetic energy
c       incident point, x, y, z (m; E-xyz coord)
c       incident direction ; Since in reverse mode
c                            we have to revert them
c       cos of incident zentih anlgle: //


c          character output

        write(*, '(i7,i4,g13.5, 3g14.5, 4f9.5)')
     *  Cutoff, inci.p.code, sngl(inci.p.fm.e-inci.p.mass),
     *  sngl(inci.pos.xyz.x), sngl(inci.pos.xyz.y), 
     *  sngl(inci.pos.xyz.z),
     *  sngl(-inci.vec.w.x), sngl(-inci.vec.w.y),
     *  sngl(-inci.vec.w.z), 
     *  sngl(-inci.vec.coszenith)
          


      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun
      implicit none

#include "Zprivate.h"
      close(iodev)

      end
c     ********************************* hook for trace
c     *  This is called only when trace > 60
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

      real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 60. 
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat',or  'anihi'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' or 'photop'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
      end

      
