	subroutine ciP5F1S35C80(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 3.5cm
c    Cos=0.80
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 0.95e-2 GeV
c

	cs = 0.80
	e1 = 1.d-3
	e2 = 1.
	desingle = 0.95e-2
      end
      subroutine cemP5F1S35C80(e, de)   	
      implicit none
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=12)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f


      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101), bp065(101), bp0464(101),
     * bp0316(101), bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
      equivalence (b(1,ne-11), bp001(1))
      equivalence (b(1,ne-10), bp0021(1))
      equivalence (b(1,ne-9), bp0046(1))
      equivalence (b(1,ne-8), bp01(1))
      equivalence (b(1,ne-7), bp0215(1))
      equivalence (b(1,ne-6), bp0316(1))
      equivalence (b(1,ne-5), bp0464(1))
      equivalence (b(1,ne-4), bp065(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))
c
	data hx/0.01d0/, hy/0.3333333333d0/
c
      data (b1    (i),i=   1,  72)/
     1-5.2950,-2.2625,-2.2189,-2.2040,-2.1898,-2.1772,-2.1651,-2.1535,
     2-2.1409,-2.1273,-2.1162,-2.1019,-2.0885,-2.0752,-2.0585,-2.0416,
     3-2.0275,-2.0117,-1.9921,-1.9734,-1.9540,-1.9371,-1.9189,-1.9029,
     4-1.8872,-1.8744,-1.8617,-1.8493,-1.8366,-1.8241,-1.8120,-1.7984,
     5-1.7850,-1.7736,-1.7610,-1.7488,-1.7380,-1.7269,-1.7171,-1.7083,
     6-1.6999,-1.6917,-1.6837,-1.6759,-1.6685,-1.6617,-1.6554,-1.6488,
     7-1.6414,-1.6343,-1.6278,-1.6212,-1.6130,-1.6050,-1.5976,-1.5903,
     8-1.5828,-1.5751,-1.5683,-1.5618,-1.5548,-1.5477,-1.5403,-1.5326,
     9-1.5257,-1.5191,-1.5122,-1.5046,-1.4970,-1.4892,-1.4816,-1.4741/
      data (b1    (i),i=  73, 101)/
     1-1.4673,-1.4615,-1.4551,-1.4484,-1.4413,-1.4338,-1.4259,-1.4179,
     2-1.4097,-1.4014,-1.3929,-1.3846,-1.3758,-1.3665,-1.3572,-1.3478,
     3-1.3383,-1.3279,-1.3166,-1.3046,-1.2915,-1.2767,-1.2621,-1.2447,
     4-1.2261,-1.2071,-1.1728,-1.1298,-0.9600/
c
      data (bp4640(i),i=   1,  72)/
     1-5.7750,-2.8582,-2.3422,-2.2395,-2.2229,-2.2110,-2.2019,-2.1931,
     2-2.1842,-2.1755,-2.1678,-2.1605,-2.1526,-2.1446,-2.1368,-2.1284,
     3-2.1192,-2.1092,-2.0991,-2.0899,-2.0804,-2.0705,-2.0602,-2.0488,
     4-2.0363,-2.0233,-2.0111,-1.9953,-1.9820,-1.9666,-1.9533,-1.9411,
     5-1.9284,-1.9154,-1.9040,-1.8913,-1.8800,-1.8700,-1.8603,-1.8500,
     6-1.8400,-1.8301,-1.8213,-1.8121,-1.8026,-1.7929,-1.7831,-1.7735,
     7-1.7643,-1.7556,-1.7471,-1.7391,-1.7316,-1.7244,-1.7175,-1.7107,
     8-1.7038,-1.6970,-1.6902,-1.6836,-1.6767,-1.6695,-1.6625,-1.6556,
     9-1.6488,-1.6424,-1.6359,-1.6287,-1.6213,-1.6137,-1.6061,-1.5988/
      data (bp4640(i),i=  73, 101)/
     1-1.5920,-1.5845,-1.5767,-1.5684,-1.5597,-1.5523,-1.5458,-1.5372,
     2-1.5289,-1.5217,-1.5139,-1.5057,-1.4963,-1.4860,-1.4780,-1.4690,
     3-1.4562,-1.4471,-1.4367,-1.4248,-1.4121,-1.3979,-1.3830,-1.3652,
     4-1.3479,-1.3252,-1.2948,-1.2528,-1.0650/
c
      data (bp2154(i),i=   1,  72)/
     1-5.3100,-3.5000,-3.0816,-2.7402,-2.5168,-2.3765,-2.2931,-2.2596,
     2-2.2426,-2.2297,-2.2223,-2.2137,-2.2051,-2.1974,-2.1904,-2.1842,
     3-2.1785,-2.1725,-2.1664,-2.1604,-2.1543,-2.1484,-2.1424,-2.1362,
     4-2.1301,-2.1240,-2.1182,-2.1116,-2.1045,-2.0974,-2.0901,-2.0829,
     5-2.0759,-2.0687,-2.0612,-2.0537,-2.0462,-2.0386,-2.0307,-2.0225,
     6-2.0136,-2.0049,-1.9963,-1.9865,-1.9770,-1.9689,-1.9603,-1.9514,
     7-1.9418,-1.9324,-1.9237,-1.9144,-1.9044,-1.8959,-1.8880,-1.8804,
     8-1.8726,-1.8642,-1.8563,-1.8492,-1.8417,-1.8339,-1.8259,-1.8177,
     9-1.8093,-1.8007,-1.7920,-1.7829,-1.7729,-1.7644,-1.7570,-1.7487/
      data (bp2154(i),i=  73, 101)/
     1-1.7403,-1.7323,-1.7243,-1.7156,-1.7072,-1.6989,-1.6905,-1.6823,
     2-1.6730,-1.6635,-1.6536,-1.6451,-1.6373,-1.6279,-1.6183,-1.6092,
     3-1.5997,-1.5891,-1.5766,-1.5647,-1.5530,-1.5406,-1.5265,-1.5115,
     4-1.4929,-1.4728,-1.4376,-1.3936,-1.1700/
c
      data (bp1   (i),i=   1,  72)/
     1-5.5650,-4.0341,-3.7015,-3.4646,-3.3049,-3.1509,-3.0192,-2.9201,
     2-2.7892,-2.6863,-2.5903,-2.5252,-2.4668,-2.4045,-2.3546,-2.3148,
     3-2.2920,-2.2765,-2.2649,-2.2554,-2.2457,-2.2358,-2.2286,-2.2232,
     4-2.2170,-2.2105,-2.2043,-2.1984,-2.1927,-2.1869,-2.1812,-2.1755,
     5-2.1698,-2.1642,-2.1587,-2.1533,-2.1481,-2.1427,-2.1369,-2.1313,
     6-2.1258,-2.1205,-2.1150,-2.1092,-2.1033,-2.0976,-2.0921,-2.0866,
     7-2.0806,-2.0744,-2.0681,-2.0617,-2.0554,-2.0491,-2.0427,-2.0365,
     8-2.0303,-2.0240,-2.0177,-2.0113,-2.0049,-1.9988,-1.9919,-1.9841,
     9-1.9766,-1.9692,-1.9616,-1.9537,-1.9456,-1.9371,-1.9297,-1.9226/
      data (bp1   (i),i=  73, 101)/
     1-1.9149,-1.9064,-1.8976,-1.8888,-1.8801,-1.8712,-1.8621,-1.8539,
     2-1.8472,-1.8380,-1.8284,-1.8186,-1.8077,-1.7967,-1.7860,-1.7739,
     3-1.7629,-1.7525,-1.7408,-1.7285,-1.7155,-1.7014,-1.6844,-1.6674,
     4-1.6491,-1.6249,-1.5983,-1.5533,-1.2900/
c
      data (bp065 (i),i=   1,  72)/
     1-5.7750,-4.3481,-4.0227,-3.8086,-3.6670,-3.5363,-3.4506,-3.3375,
     2-3.2416,-3.1469,-3.0675,-2.9944,-2.9352,-2.8703,-2.8250,-2.7704,
     3-2.7159,-2.6659,-2.6179,-2.5761,-2.5281,-2.4828,-2.4528,-2.4197,
     4-2.3881,-2.3591,-2.3336,-2.3115,-2.2992,-2.2892,-2.2793,-2.2703,
     5-2.2621,-2.2544,-2.2470,-2.2396,-2.2327,-2.2266,-2.2207,-2.2148,
     6-2.2090,-2.2030,-2.1966,-2.1903,-2.1844,-2.1788,-2.1731,-2.1675,
     7-2.1619,-2.1565,-2.1515,-2.1463,-2.1406,-2.1347,-2.1286,-2.1222,
     8-2.1160,-2.1099,-2.1042,-2.0980,-2.0913,-2.0847,-2.0783,-2.0720,
     9-2.0658,-2.0599,-2.0535,-2.0463,-2.0393,-2.0324,-2.0257,-2.0190/
      data (bp065 (i),i=  73, 101)/
     1-2.0126,-2.0059,-1.9990,-1.9915,-1.9835,-1.9758,-1.9685,-1.9605,
     2-1.9517,-1.9427,-1.9333,-1.9233,-1.9131,-1.9028,-1.8932,-1.8832,
     3-1.8726,-1.8610,-1.8496,-1.8376,-1.8224,-1.8073,-1.7930,-1.7745,
     4-1.7546,-1.7243,-1.6942,-1.6519,-1.4850/
c
      data (bp0464(i),i=   1,  72)/
     1-5.0000,-4.4699,-4.1813,-4.0184,-3.9033,-3.8072,-3.7131,-3.6395,
     2-3.5705,-3.5113,-3.4566,-3.4008,-3.3402,-3.2867,-3.2431,-3.1960,
     3-3.1459,-3.1014,-3.0580,-3.0128,-2.9624,-2.9238,-2.8867,-2.8525,
     4-2.8184,-2.7827,-2.7447,-2.7091,-2.6761,-2.6399,-2.6070,-2.5762,
     5-2.5487,-2.5206,-2.4951,-2.4683,-2.4431,-2.4175,-2.3927,-2.3679,
     6-2.3466,-2.3269,-2.3098,-2.2974,-2.2883,-2.2796,-2.2715,-2.2646,
     7-2.2585,-2.2516,-2.2444,-2.2375,-2.2315,-2.2252,-2.2188,-2.2122,
     8-2.2062,-2.2006,-2.1948,-2.1889,-2.1828,-2.1768,-2.1706,-2.1646,
     9-2.1586,-2.1529,-2.1470,-2.1409,-2.1346,-2.1276,-2.1207,-2.1139/
      data (bp0464(i),i=  73, 101)/
     1-2.1072,-2.1005,-2.0938,-2.0866,-2.0787,-2.0711,-2.0636,-2.0556,
     2-2.0473,-2.0392,-2.0311,-2.0228,-2.0138,-2.0032,-1.9930,-1.9829,
     3-1.9715,-1.9603,-1.9484,-1.9357,-1.9221,-1.9056,-1.8901,-1.8720,
     4-1.8514,-1.8251,-1.7940,-1.7498,-1.5800/
c
      data (bp0316(i),i=   1,  72)/
     1-5.9700,-4.7845,-4.5117,-4.3358,-4.1958,-4.0868,-4.0190,-3.9485,
     2-3.8875,-3.8124,-3.7652,-3.7282,-3.6850,-3.6476,-3.6066,-3.5666,
     3-3.5256,-3.4801,-3.4471,-3.4096,-3.3790,-3.3511,-3.3216,-3.2908,
     4-3.2603,-3.2310,-3.2074,-3.1812,-3.1543,-3.1191,-3.0945,-3.0631,
     5-3.0360,-3.0098,-2.9830,-2.9557,-2.9295,-2.9046,-2.8807,-2.8593,
     6-2.8381,-2.8168,-2.7941,-2.7668,-2.7462,-2.7271,-2.7054,-2.6853,
     7-2.6624,-2.6358,-2.6122,-2.5890,-2.5664,-2.5444,-2.5234,-2.5006,
     8-2.4808,-2.4567,-2.4420,-2.4236,-2.4063,-2.3849,-2.3642,-2.3465,
     9-2.3295,-2.3152,-2.3025,-2.2914,-2.2835,-2.2749,-2.2661,-2.2562/
      data (bp0316(i),i=  73, 101)/
     1-2.2469,-2.2394,-2.2310,-2.2221,-2.2129,-2.2037,-2.1965,-2.1887,
     2-2.1805,-2.1724,-2.1651,-2.1569,-2.1477,-2.1383,-2.1287,-2.1190,
     3-2.1082,-2.0970,-2.0869,-2.0731,-2.0608,-2.0453,-2.0293,-2.0139,
     4-1.9958,-1.9719,-1.9412,-1.8965,-1.7550/
c
      data (bp0215(i),i=   1,  72)/
     1-5.9850,-5.0384,-4.7547,-4.5831,-4.4469,-4.3416,-4.2554,-4.1776,
     2-4.1242,-4.0727,-4.0259,-3.9809,-3.9379,-3.9025,-3.8636,-3.8256,
     3-3.7934,-3.7614,-3.7251,-3.7015,-3.6745,-3.6449,-3.6194,-3.5926,
     4-3.5641,-3.5367,-3.5138,-3.4905,-3.4678,-3.4466,-3.4260,-3.4060,
     5-3.3869,-3.3687,-3.3484,-3.3299,-3.3088,-3.2876,-3.2669,-3.2479,
     6-3.2289,-3.2079,-3.1893,-3.1720,-3.1539,-3.1335,-3.1150,-3.0944,
     7-3.0721,-3.0547,-3.0352,-3.0188,-2.9978,-2.9813,-2.9635,-2.9466,
     8-2.9271,-2.9094,-2.8929,-2.8731,-2.8544,-2.8361,-2.8160,-2.7957,
     9-2.7734,-2.7560,-2.7367,-2.7147,-2.6973,-2.6800,-2.6595,-2.6408/
      data (bp0215(i),i=  73, 101)/
     1-2.6238,-2.6029,-2.5813,-2.5606,-2.5429,-2.5232,-2.5027,-2.4822,
     2-2.4604,-2.4422,-2.4240,-2.4057,-2.3840,-2.3653,-2.3472,-2.3291,
     3-2.3119,-2.2949,-2.2795,-2.2635,-2.2478,-2.2307,-2.2118,-2.1919,
     4-2.1719,-2.1499,-2.1200,-2.0781,-1.8450/
c
      data (bp01  (i),i=   1,  72)/
     1-6.0000,-5.0969,-5.0149,-4.8459,-4.6959,-4.5941,-4.4997,-4.4462,
     2-4.3885,-4.3377,-4.2891,-4.2422,-4.1957,-4.1585,-4.1333,-4.0999,
     3-4.0703,-4.0421,-4.0169,-3.9896,-3.9647,-3.9425,-3.9243,-3.9023,
     4-3.8805,-3.8600,-3.8377,-3.8200,-3.8036,-3.7889,-3.7702,-3.7537,
     5-3.7387,-3.7258,-3.7082,-3.6890,-3.6712,-3.6561,-3.6416,-3.6265,
     6-3.6117,-3.5963,-3.5814,-3.5668,-3.5525,-3.5394,-3.5263,-3.5091,
     7-3.4961,-3.4811,-3.4663,-3.4508,-3.4362,-3.4220,-3.4061,-3.3896,
     8-3.3747,-3.3609,-3.3489,-3.3341,-3.3210,-3.3061,-3.2916,-3.2742,
     9-3.2600,-3.2476,-3.2281,-3.2112,-3.1964,-3.1810,-3.1660,-3.1514/
      data (bp01  (i),i=  73, 101)/
     1-3.1358,-3.1196,-3.1023,-3.0874,-3.0716,-3.0569,-3.0420,-3.0254,
     2-3.0032,-2.9889,-2.9717,-2.9550,-2.9367,-2.9155,-2.8953,-2.8782,
     3-2.8590,-2.8288,-2.8065,-2.7769,-2.7445,-2.7131,-2.6808,-2.6404,
     4-2.5907,-2.5479,-2.5031,-2.4182,-2.1950/
c
      data (bp0046(i),i=   1,  72)/
     1-5.8800,-5.3439,-5.0824,-4.8749,-4.7448,-4.6438,-4.5422,-4.4903,
     2-4.4457,-4.3910,-4.3486,-4.3159,-4.2778,-4.2359,-4.1979,-4.1746,
     3-4.1445,-4.1121,-4.0860,-4.0691,-4.0405,-4.0224,-4.0029,-3.9867,
     4-3.9699,-3.9523,-3.9321,-3.9198,-3.8965,-3.8792,-3.8646,-3.8495,
     5-3.8365,-3.8244,-3.8118,-3.7992,-3.7822,-3.7665,-3.7496,-3.7320,
     6-3.7195,-3.7008,-3.6933,-3.6813,-3.6700,-3.6594,-3.6481,-3.6367,
     7-3.6237,-3.6102,-3.5987,-3.5878,-3.5701,-3.5560,-3.5384,-3.5286,
     8-3.5167,-3.5051,-3.4951,-3.4853,-3.4756,-3.4660,-3.4555,-3.4444,
     9-3.4323,-3.4192,-3.4093,-3.3984,-3.3836,-3.3682,-3.3554,-3.3421/
      data (bp0046(i),i=  73, 101)/
     1-3.3278,-3.3167,-3.3010,-3.2888,-3.2759,-3.2592,-3.2439,-3.2315,
     2-3.2192,-3.2063,-3.1928,-3.1802,-3.1673,-3.1521,-3.1353,-3.1171,
     3-3.1050,-3.0824,-3.0637,-3.0377,-3.0067,-2.9795,-2.9550,-2.9208,
     4-2.8960,-2.8565,-2.8138,-2.7277,-2.5800/
c
      data (bp0021(i),i=   1,  72)/
     1-5.7000,-5.4045,-5.0898,-4.9155,-4.8695,-4.6931,-4.6379,-4.6245,
     2-4.5630,-4.5013,-4.4550,-4.4297,-4.4010,-4.3826,-4.3690,-4.3282,
     3-4.2958,-4.2559,-4.2427,-4.1890,-4.1750,-4.1579,-4.1523,-4.1298,
     4-4.0829,-4.0658,-4.0590,-4.0369,-4.0210,-3.9970,-3.9865,-3.9712,
     5-3.9619,-3.9538,-3.9435,-3.9282,-3.9216,-3.9158,-3.9034,-3.8960,
     6-3.8776,-3.8597,-3.8544,-3.8389,-3.8290,-3.8188,-3.8085,-3.7983,
     7-3.7891,-3.7864,-3.7800,-3.7721,-3.7647,-3.7578,-3.7510,-3.7436,
     8-3.7357,-3.7290,-3.7239,-3.7169,-3.7085,-3.6933,-3.6814,-3.6718,
     9-3.6616,-3.6505,-3.6320,-3.6202,-3.6131,-3.6027,-3.5943,-3.5868/
      data (bp0021(i),i=  73, 101)/
     1-3.5778,-3.5652,-3.5500,-3.5447,-3.5407,-3.5347,-3.5257,-3.5103,
     2-3.5025,-3.4934,-3.4652,-3.4586,-3.4527,-3.4453,-3.4560,-3.3945,
     3-3.3908,-3.3707,-3.3571,-3.3898,-3.3420,-3.2989,-3.2836,-3.2715,
     4-3.2637,-3.2360,-3.1888,-3.1365,-3.0000/
      data bp001/5*-6., 6*-5.,90*-4.5/
c

       data zr/1.00, .995, .968,.875, .711, .43,
     *          .192, .078, .049, .025, .01, 0., 0./
c

         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de = 10.d0**f
         endif
      end
      subroutine cepP5F1S35C80(e, de)
	implicit none
	real*8 e, de
c            e+
          call cemP5F1S35C80(e, de)
          if(e .lt. .021) then
c                correction;  4% increase at 10 mev
               de=de* (1. + (.021-e)* 4.)
          endif
      end
      subroutine cgP5F1S35C80(e, de)
      implicit none
c           this is for g  incident
c
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne = 12)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)
c
c

      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101),bp065(101), bp0464(101),
     * bp0316(101), bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
      equivalence (b(1,ne-11), bp001(1))
      equivalence (b(1,ne-10), bp0021(1))
      equivalence (b(1,ne-9), bp0046(1))
      equivalence (b(1,ne-8), bp01(1))
      equivalence (b(1,ne-7), bp0215(1))
      equivalence (b(1,ne-6), bp0316(1))
      equivalence (b(1,ne-5), bp0464(1))
      equivalence (b(1,ne-4), bp065(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))
c
	data hx/0.01d0/, hy/0.333333333333d0/

      data (b1    (i),i=   1,  72)/
     1-4.3950,-2.5845,-2.2720,-2.1849,-2.1287,-2.0786,-2.0240,-1.9867,
     2-1.9437,-1.9192,-1.9136,-1.9064,-1.9013,-1.8952,-1.8915,-1.8870,
     3-1.8830,-1.8789,-1.8747,-1.8700,-1.8651,-1.8605,-1.8560,-1.8518,
     4-1.8475,-1.8432,-1.8389,-1.8347,-1.8302,-1.8254,-1.8204,-1.8153,
     5-1.8101,-1.8047,-1.7992,-1.7933,-1.7874,-1.7815,-1.7759,-1.7692,
     6-1.7607,-1.7526,-1.7448,-1.7368,-1.7286,-1.7208,-1.7137,-1.7057,
     7-1.6970,-1.6886,-1.6802,-1.6712,-1.6623,-1.6532,-1.6447,-1.6367,
     8-1.6288,-1.6211,-1.6127,-1.6039,-1.5964,-1.5892,-1.5820,-1.5743,
     9-1.5657,-1.5575,-1.5507,-1.5438,-1.5373,-1.5304,-1.5218,-1.5135/
      data (b1    (i),i=  73, 101)/
     1-1.5057,-1.4978,-1.4899,-1.4822,-1.4748,-1.4666,-1.4577,-1.4496,
     2-1.4422,-1.4341,-1.4256,-1.4171,-1.4080,-1.3980,-1.3884,-1.3794,
     3-1.3695,-1.3590,-1.3466,-1.3322,-1.3196,-1.3035,-1.2848,-1.2683,
     4-1.2442,-1.2247,-1.1919,-1.1450,-0.9300/
c
      data (bp4640(i),i=   1,  72)/
     1-5.3250,-2.7136,-2.2935,-2.2078,-2.1786,-2.1563,-2.1349,-2.0953,
     2-2.0697,-2.0373,-2.0080,-1.9824,-1.9565,-1.9383,-1.9294,-1.9208,
     3-1.9150,-1.9088,-1.9039,-1.8991,-1.8950,-1.8906,-1.8862,-1.8819,
     4-1.8777,-1.8736,-1.8697,-1.8660,-1.8621,-1.8582,-1.8543,-1.8503,
     5-1.8464,-1.8426,-1.8387,-1.8351,-1.8313,-1.8272,-1.8230,-1.8188,
     6-1.8146,-1.8103,-1.8063,-1.8019,-1.7970,-1.7918,-1.7863,-1.7803,
     7-1.7740,-1.7678,-1.7617,-1.7555,-1.7493,-1.7432,-1.7369,-1.7305,
     8-1.7242,-1.7180,-1.7117,-1.7054,-1.6991,-1.6927,-1.6864,-1.6795,
     9-1.6711,-1.6634,-1.6562,-1.6494,-1.6428,-1.6360,-1.6274,-1.6192/
      data (bp4640(i),i=  73, 101)/
     1-1.6115,-1.6038,-1.5962,-1.5884,-1.5803,-1.5723,-1.5645,-1.5572,
     2-1.5502,-1.5431,-1.5355,-1.5273,-1.5184,-1.5094,-1.5003,-1.4922,
     3-1.4833,-1.4723,-1.4610,-1.4465,-1.4325,-1.4197,-1.4028,-1.3833,
     4-1.3620,-1.3365,-1.3045,-1.2503,-1.1100/
c
      data (bp2154(i),i=   1,  72)/
     1-4.5600,-2.8787,-2.5029,-2.3158,-2.2410,-2.2152,-2.1973,-2.1819,
     2-2.1658,-2.1526,-2.1381,-2.1229,-2.1084,-2.0942,-2.0801,-2.0644,
     3-2.0496,-2.0357,-2.0215,-2.0065,-1.9924,-1.9792,-1.9664,-1.9548,
     4-1.9447,-1.9363,-1.9288,-1.9217,-1.9157,-1.9112,-1.9071,-1.9026,
     5-1.8981,-1.8937,-1.8895,-1.8854,-1.8815,-1.8777,-1.8740,-1.8705,
     6-1.8671,-1.8639,-1.8604,-1.8569,-1.8534,-1.8499,-1.8462,-1.8426,
     7-1.8388,-1.8349,-1.8309,-1.8267,-1.8222,-1.8179,-1.8136,-1.8094,
     8-1.8053,-1.8011,-1.7969,-1.7928,-1.7885,-1.7839,-1.7789,-1.7738,
     9-1.7685,-1.7631,-1.7577,-1.7524,-1.7476,-1.7425,-1.7369,-1.7310/
      data (bp2154(i),i=  73, 101)/
     1-1.7246,-1.7176,-1.7107,-1.7039,-1.6971,-1.6904,-1.6838,-1.6769,
     2-1.6698,-1.6623,-1.6543,-1.6461,-1.6376,-1.6287,-1.6193,-1.6094,
     3-1.5992,-1.5883,-1.5762,-1.5640,-1.5510,-1.5373,-1.5212,-1.5033,
     4-1.4822,-1.4603,-1.4312,-1.3855,-1.1700/
c
      data (bp1   (i),i=   1,  72)/
     1-5.8500,-3.5428,-3.1318,-2.8814,-2.6859,-2.5618,-2.4604,-2.3760,
     2-2.3197,-2.2829,-2.2606,-2.2439,-2.2339,-2.2239,-2.2135,-2.2029,
     3-2.1928,-2.1840,-2.1762,-2.1683,-2.1604,-2.1521,-2.1437,-2.1351,
     4-2.1265,-2.1176,-2.1094,-2.1016,-2.0933,-2.0848,-2.0765,-2.0677,
     5-2.0582,-2.0489,-2.0400,-2.0325,-2.0248,-2.0151,-2.0061,-1.9978,
     6-1.9898,-1.9819,-1.9738,-1.9655,-1.9580,-1.9508,-1.9439,-1.9373,
     7-1.9312,-1.9260,-1.9209,-1.9158,-1.9108,-1.9059,-1.9010,-1.8962,
     8-1.8915,-1.8872,-1.8832,-1.8794,-1.8753,-1.8711,-1.8668,-1.8625,
     9-1.8580,-1.8534,-1.8487,-1.8442,-1.8396,-1.8352,-1.8307,-1.8258/
      data (bp1   (i),i=  73, 101)/
     1-1.8207,-1.8158,-1.8109,-1.8065,-1.8017,-1.7958,-1.7895,-1.7836,
     2-1.7781,-1.7725,-1.7652,-1.7575,-1.7504,-1.7441,-1.7366,-1.7280,
     3-1.7196,-1.7113,-1.7034,-1.6938,-1.6809,-1.6692,-1.6574,-1.6425,
     4-1.6216,-1.6017,-1.5720,-1.5326,-1.3350/
c
      data (bp065 (i),i=   1,  72)/
     1-5.4900,-3.9005,-3.5830,-3.3969,-3.2047,-3.0620,-2.9279,-2.8213,
     2-2.7261,-2.6668,-2.5877,-2.5248,-2.4768,-2.4340,-2.3905,-2.3478,
     3-2.3140,-2.2924,-2.2775,-2.2670,-2.2569,-2.2475,-2.2393,-2.2309,
     4-2.2224,-2.2144,-2.2069,-2.1996,-2.1925,-2.1853,-2.1778,-2.1710,
     5-2.1647,-2.1582,-2.1518,-2.1451,-2.1382,-2.1309,-2.1243,-2.1179,
     6-2.1114,-2.1051,-2.0982,-2.0903,-2.0828,-2.0754,-2.0679,-2.0601,
     7-2.0524,-2.0448,-2.0369,-2.0285,-2.0208,-2.0135,-2.0056,-1.9970,
     8-1.9890,-1.9814,-1.9743,-1.9675,-1.9606,-1.9536,-1.9471,-1.9412,
     9-1.9352,-1.9292,-1.9233,-1.9173,-1.9112,-1.9052,-1.8995,-1.8941/
      data (bp065 (i),i=  73, 101)/
     1-1.8888,-1.8837,-1.8787,-1.8735,-1.8683,-1.8629,-1.8571,-1.8510,
     2-1.8450,-1.8390,-1.8331,-1.8269,-1.8204,-1.8137,-1.8073,-1.8003,
     3-1.7921,-1.7838,-1.7757,-1.7667,-1.7564,-1.7437,-1.7291,-1.7138,
     4-1.6998,-1.6794,-1.6529,-1.6132,-1.4250/
c
      data (bp0464(i),i=   1,  72)/
     1-5.8800,-4.1957,-3.8776,-3.7283,-3.5659,-3.4561,-3.3576,-3.2746,
     2-3.1878,-3.1026,-3.0324,-2.9708,-2.8958,-2.8413,-2.7875,-2.7289,
     3-2.6808,-2.6324,-2.5893,-2.5468,-2.5130,-2.4769,-2.4424,-2.4078,
     4-2.3785,-2.3489,-2.3233,-2.3037,-2.2901,-2.2780,-2.2696,-2.2619,
     5-2.2538,-2.2469,-2.2415,-2.2351,-2.2278,-2.2205,-2.2143,-2.2086,
     6-2.2023,-2.1956,-2.1892,-2.1829,-2.1770,-2.1703,-2.1633,-2.1566,
     7-2.1504,-2.1439,-2.1374,-2.1307,-2.1240,-2.1170,-2.1095,-2.1018,
     8-2.0946,-2.0875,-2.0804,-2.0734,-2.0657,-2.0576,-2.0502,-2.0430,
     9-2.0353,-2.0270,-2.0194,-2.0121,-2.0044,-1.9962,-1.9881,-1.9797/
      data (bp0464(i),i=  73, 101)/
     1-1.9707,-1.9625,-1.9560,-1.9487,-1.9410,-1.9335,-1.9268,-1.9199,
     2-1.9116,-1.9035,-1.8970,-1.8897,-1.8814,-1.8734,-1.8663,-1.8578,
     3-1.8472,-1.8364,-1.8260,-1.8192,-1.8068,-1.7941,-1.7811,-1.7656,
     4-1.7507,-1.7316,-1.7064,-1.6613,-1.5150/
c
      data (bp0316(i),i=   1,  72)/
     1-5.0000,-4.5556,-4.2274,-4.0432,-3.9227,-3.8264,-3.7326,-3.6612,
     2-3.5834,-3.5101,-3.4457,-3.3783,-3.3207,-3.2692,-3.2244,-3.1710,
     3-3.1304,-3.0792,-3.0328,-2.9863,-2.9503,-2.9134,-2.8772,-2.8516,
     4-2.8019,-2.7676,-2.7377,-2.7021,-2.6696,-2.6399,-2.6093,-2.5768,
     5-2.5488,-2.5232,-2.4957,-2.4720,-2.4471,-2.4198,-2.3942,-2.3789,
     6-2.3568,-2.3387,-2.3202,-2.3084,-2.2995,-2.2884,-2.2784,-2.2697,
     7-2.2613,-2.2534,-2.2464,-2.2397,-2.2334,-2.2273,-2.2209,-2.2144,
     8-2.2078,-2.2010,-2.1941,-2.1872,-2.1801,-2.1729,-2.1655,-2.1581,
     9-2.1505,-2.1429,-2.1351,-2.1278,-2.1206,-2.1129,-2.1051,-2.0971/
      data (bp0316(i),i=  73, 101)/
     1-2.0891,-2.0811,-2.0733,-2.0657,-2.0580,-2.0506,-2.0419,-2.0316,
     2-2.0218,-2.0116,-2.0003,-1.9889,-1.9778,-1.9669,-1.9551,-1.9441,
     3-1.9331,-1.9218,-1.9095,-1.8962,-1.8846,-1.8695,-1.8546,-1.8406,
     4-1.8197,-1.8026,-1.7769,-1.7396,-1.6100/
c
      data (bp0215(i),i=   1,  72)/
     1-5.9550,-4.8537,-4.5367,-4.3320,-4.1850,-4.0785,-3.9881,-3.9384,
     2-3.8772,-3.8062,-3.7464,-3.6973,-3.6479,-3.6066,-3.5652,-3.5195,
     3-3.4749,-3.4275,-3.3905,-3.3618,-3.3229,-3.2879,-3.2568,-3.2256,
     4-3.1921,-3.1666,-3.1242,-3.0857,-3.0561,-3.0235,-2.9956,-2.9696,
     5-2.9424,-2.9072,-2.8730,-2.8483,-2.8158,-2.7942,-2.7636,-2.7383,
     6-2.7082,-2.6816,-2.6600,-2.6324,-2.6075,-2.5764,-2.5548,-2.5335,
     7-2.5113,-2.4890,-2.4668,-2.4457,-2.4238,-2.4070,-2.3902,-2.3734,
     8-2.3572,-2.3432,-2.3302,-2.3172,-2.3051,-2.2953,-2.2839,-2.2736,
     9-2.2649,-2.2569,-2.2486,-2.2392,-2.2299,-2.2208,-2.2131,-2.2058/
      data (bp0215(i),i=  73, 101)/
     1-2.1977,-2.1892,-2.1821,-2.1744,-2.1663,-2.1576,-2.1485,-2.1389,
     2-2.1290,-2.1189,-2.1089,-2.0991,-2.0882,-2.0776,-2.0672,-2.0566,
     3-2.0442,-2.0324,-2.0188,-2.0032,-1.9881,-1.9740,-1.9557,-1.9386,
     4-1.9200,-1.8933,-1.8693,-1.8459,-1.7550/
c
      data (bp01  (i),i=   1,  72)/
     1-6.0000,-5.1549,-4.7280,-4.5095,-4.4001,-4.2908,-4.2173,-4.1408,
     2-4.0818,-4.0239,-3.9782,-3.9229,-3.8766,-3.8258,-3.7835,-3.7503,
     3-3.7136,-3.6660,-3.6355,-3.5968,-3.5675,-3.5437,-3.5117,-3.4810,
     4-3.4526,-3.4272,-3.4020,-3.3670,-3.3285,-3.3014,-3.2691,-3.2383,
     5-3.2085,-3.1816,-3.1525,-3.1189,-3.0936,-3.0722,-3.0433,-3.0176,
     6-2.9896,-2.9701,-2.9475,-2.9235,-2.8988,-2.8742,-2.8547,-2.8325,
     7-2.8095,-2.7782,-2.7569,-2.7355,-2.7153,-2.6955,-2.6753,-2.6569,
     8-2.6347,-2.6184,-2.5958,-2.5782,-2.5630,-2.5474,-2.5305,-2.5130,
     9-2.4974,-2.4835,-2.4717,-2.4608,-2.4494,-2.4361,-2.4253,-2.4105/
      data (bp01  (i),i=  73, 101)/
     1-2.3966,-2.3846,-2.3716,-2.3614,-2.3455,-2.3355,-2.3248,-2.3137,
     2-2.3036,-2.2929,-2.2819,-2.2720,-2.2616,-2.2514,-2.2434,-2.2325,
     3-2.2219,-2.2127,-2.2017,-2.1866,-2.1722,-2.1613,-2.1508,-2.1384,
     4-2.1262,-2.1146,-2.1040,-2.0956,-2.0900/
c
      data (bp0046(i),i=   1,  72)/
     1-6.0000,-4.8114,-4.5588,-4.3925,-4.2616,-4.1358,-4.0397,-3.9845,
     2-3.9247,-3.8704,-3.8115,-3.7577,-3.7157,-3.6789,-3.6395,-3.6003,
     3-3.5657,-3.5127,-3.4778,-3.4403,-3.4043,-3.3633,-3.3322,-3.3003,
     4-3.2774,-3.2570,-3.2349,-3.2106,-3.1864,-3.1613,-3.1341,-3.1155,
     5-3.0942,-3.0712,-3.0523,-3.0334,-3.0154,-2.9947,-2.9781,-2.9597,
     6-2.9466,-2.9242,-2.9060,-2.8946,-2.8798,-2.8641,-2.8513,-2.8349,
     7-2.8185,-2.8058,-2.7923,-2.7794,-2.7671,-2.7555,-2.7432,-2.7295,
     8-2.7158,-2.7046,-2.6922,-2.6824,-2.6736,-2.6630,-2.6528,-2.6428,
     9-2.6346,-2.6260,-2.6174,-2.6078,-2.5977,-2.5892,-2.5801,-2.5709/
      data (bp0046(i),i=  73, 101)/
     1-2.5621,-2.5538,-2.5462,-2.5392,-2.5328,-2.5263,-2.5190,-2.5109,
     2-2.5045,-2.4992,-2.4937,-2.4882,-2.4828,-2.4779,-2.4735,-2.4702,
     3-2.4669,-2.4638,-2.4606,-2.4601,-2.4577,-2.4569,-2.4512,-2.4445,
     4-2.4386,-2.4325,-2.4271,-2.4228,-2.4200/
c
      data (bp0021(i),i=   1,  72)/
     1-5.9700,-4.8858,-4.5839,-4.4405,-4.3191,-4.2074,-4.1232,-4.0605,
     2-4.0099,-3.9631,-3.9153,-3.8755,-3.8314,-3.7934,-3.7572,-3.7169,
     3-3.6882,-3.6613,-3.6337,-3.6051,-3.5809,-3.5551,-3.5279,-3.5065,
     4-3.4873,-3.4683,-3.4483,-3.4282,-3.4096,-3.3916,-3.3713,-3.3542,
     5-3.3369,-3.3214,-3.3071,-3.2923,-3.2776,-3.2640,-3.2499,-3.2345,
     6-3.2208,-3.2068,-3.1940,-3.1825,-3.1709,-3.1587,-3.1462,-3.1348,
     7-3.1226,-3.1117,-3.1008,-3.0897,-3.0773,-3.0664,-3.0549,-3.0427,
     8-3.0337,-3.0237,-3.0134,-3.0031,-2.9928,-2.9825,-2.9729,-2.9622,
     9-2.9516,-2.9416,-2.9329,-2.9250,-2.9169,-2.9089,-2.9018,-2.8950/
      data (bp0021(i),i=  73, 101)/
     1-2.8882,-2.8818,-2.8758,-2.8706,-2.8655,-2.8607,-2.8558,-2.8512,
     2-2.8469,-2.8430,-2.8392,-2.8357,-2.8324,-2.8293,-2.8264,-2.8238,
     3-2.8210,-2.8182,-2.8155,-2.8136,-2.8116,-2.8086,-2.8055,-2.8016,
     4-2.8132,-2.8039,-2.7896,-2.7738,-2.7600/
c
      data (bp001 (i),i=   1,  72)/
     1-5.9850,-5.1585,-4.8676,-4.6999,-4.6095,-4.5029,-4.4219,-4.3495,
     2-4.2856,-4.2315,-4.1810,-4.1344,-4.1010,-4.0680,-4.0346,-4.0083,
     3-3.9802,-3.9577,-3.9373,-3.9150,-3.8927,-3.8709,-3.8516,-3.8329,
     4-3.8109,-3.7892,-3.7702,-3.7535,-3.7373,-3.7210,-3.7072,-3.6920,
     5-3.6761,-3.6588,-3.6420,-3.6288,-3.6150,-3.6016,-3.5880,-3.5738,
     6-3.5582,-3.5441,-3.5322,-3.5189,-3.5042,-3.4917,-3.4800,-3.4684,
     7-3.4566,-3.4449,-3.4328,-3.4183,-3.4074,-3.3982,-3.3893,-3.3785,
     8-3.3681,-3.3581,-3.3501,-3.3421,-3.3342,-3.3264,-3.3187,-3.3112,
     9-3.3039,-3.2967,-3.2897,-3.2829,-3.2766,-3.2704,-3.2643,-3.2581/
      data (bp001 (i),i=  73, 101)/
     1-3.2524,-3.2476,-3.2429,-3.2383,-3.2336,-3.2292,-3.2250,-3.2210,
     2-3.2173,-3.2141,-3.2109,-3.2079,-3.2051,-3.2046,-3.2025,-3.2019,
     3-3.1977,-3.1927,-3.1875,-3.1824,-3.1773,-3.1726,-3.1677,-3.1647,
     4-3.1604,-3.1514,-3.1351,-3.1203,-3.0900/

       data zr/.78, .79, .82, .830, .792, .705,
     *       .595, .520, .467, .435,.420, .398, .390/
c

         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
