c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file that exists already
c  *     for formatted mode. If it doen not
c  *     exist or cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenf(io, fn, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fn: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fn
         logical opn, ex
         integer io, ios, icon, klena
         character*300 msg

c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
#ifdef ACTION_READ
c                     for non-writable file action ='read'
c                      is needed.
                 open(io, file=fn(1:klena(fn)), 
     *           iostat=ios, access='sequential',
     *           form='formatted', action='read') 
#else
                 open(io, file=fn(1:klena(fn)), 
     *           iostat=ios, access='sequential',
     *           form='formatted') 
#endif
                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                 write(msg, *) ' file=', fn(1:klena(fn)),' not exist'
                 call cerrorMsg(msg, 1)
                 icon = 1
             endif    
         end
c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file 
c  *     for formatted i/o mode. If it
c  *     cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenfw(io, fn, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fn: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fn
         logical opn, ex
         integer io, ios, icon, klena
         character*100 msg

c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
                open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted') 

                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted') 
                if(ios .eq. 0) then
                   icon = 0
                else
                   icon = 3
                endif
             endif    
         end
      subroutine cskiptoEOF(iodev)
      implicit none
      integer iodev

c          skip to the end of previous write
       do while(.true.)
          read(iodev, *, end=100)
       enddo
 100   continue
       end
c  ***********************************************************
c  *     open a sequential disk file.( upgraded verson of
c  *     copenfw:
c  *     This is intended to open a file
c  *     for formatted or unformatted i/o mode.
c  ***********************************************************
         subroutine copenfw2(io, fn,  form, icon)
         implicit none
c
         integer  io ! input.  Fortran logical device number
         character*(*)  fn !  input. Disk file name to be openend.
         integer  form !  input. if 1--> formatted file
                       !            2--> binary file
         integer  icon !. output. 0  file is newly created and  opened
                       !          1  file exists and  opened
                       !          2  file has been already opened
                       !          3  file cannot be opened.
         logical opn, ex
         integer  ios,  klena
         character*11 format

         if(form .eq. 1) then
            format='formatted'
         elseif(form .eq. 2) then
            format='unformatted'
         else
            call cerrorMsg(
     *      'form input to chookopenfw is  invalid',0)
         endif

c                  see if already opened.
         inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
         if(opn) then
            icon = 2
         elseif(ex) then
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format)
            if(ios .eq. 0) then
               icon = 1
            else
               call cerrorMsg(fn, 1)
               call cerrorMsg(
     *         'exists but cannot be opened', 1) 
               icon =3
            endif
         else
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format, status='new' )
            if(ios .eq. 0) then
               icon = 0
            else
               icon = 3
            endif
         endif
         end
c           upgraded version of cskiptoEOF
      subroutine cskiptoEOF2(iodev, form)
      implicit none
      integer iodev  ! input  dev. no
      integer form   ! input  1--> ascii file
                     !        2--> binary file

c          skip to the end of previous write
       do while(.true.)
          if(form .eq. 1) then
             read(iodev, *, end=100)
          elseif(form .eq. 2) then
             read(iodev, end=100)
          endif
       enddo
 100      continue
       end
