c            treat interaction of MovedTrack for non e,g
c
      subroutine cinteNEP
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
c
c          used to judge if user hook should be called 
c          after MovedTrack interacted.
c
c
      character*80 msg
c
c   **  ptcl stacking is done in each subroutine; should be changed
c           (except for hadronic interactions)


      if(IntInfArray(ProcessNo).process .eq. 'knock') then
         call csetKnock
      else
         if(MovedTrack.p.code .eq. kpion) then
            call cintePion
         elseif(MovedTrack.p.code .eq. kkaon) then
            call cinteKaon
         elseif(MovedTrack.p.code .eq. knuc) then
            call cinteNuc
         elseif(MovedTrack.p.code .eq. kmuon) then
            call cinteMuon
         elseif(MovedTrack.p.code .ge. kdeut .and.
     *           MovedTrack.p.code .le. khvymax  ) then
            call cinteHeavy
         elseif(MovedTrack.p.code .eq. ktriton) then
            call cinteHeavy
         elseif(MovedTrack.p.code .eq. kdmes ) then
            call cinteDmes
         elseif(MovedTrack.p.code .eq. knnb) then
            call cintennb
         elseif(MovedTrack.p.code .eq. kddb) then
            call cinteddb
         elseif(MovedTrack.p.code .eq. keta) then
            call cinteEta
         else
            write(msg, *) ' ptcl =', MovedTrack.p.code,
     *        ' interaction=', 
     *         IntInfArray(ProcessNo).process,
     *        ' should not occure'
            call cerrorMsg(msg, 0)
         endif
      endif
      end     
      subroutine csetKnock
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

       real*8 e1, er, tmp, cos1, cosr,  cs, sn, sinr, sine
       record /coord/dc, dc1, dcr
c
       record /track/ aTrack

       integer idx   ! 
 
       aTrack = MovedTrack
c                                surv  elec  surv   elec
       call  cKnockea(aTrack.p,  e1,   er,  cos1,   cosr)
c        we must put recoil electron into Pwork first and
c        then survival high energy ptcl.  This order will
c        be reversed when particles in Pwork are stacked.
c      (this inversion is to manage nuclear interactions where
c       the leading particle is put last in Pwork).
c        Therefore the low energy electron is first extracted.
c  Otherwise, stack overflow may take place for inclinde muons
c     (<= v5.33)
c         idx is to resolve the problem with a minumum effort.
c
c          survival paticle angle negligible always so
c          you may  put dc.r = (0, 0, 1)
       tmp=1.d0-cos1*cos1
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cos1=1.d0
       endif
       sine=sqrt(tmp)

       call kcossn(cs, sn)
       dc.r(1) = cs*sine
       dc.r(2) = sn*sine
       dc.r(3) = cos1
c           convert angle
       call ctransVectZ(MovedTrack.vec.w, dc, dc1)

       aTrack.p.fm.p(4) = e1
       call csetDirCos(dc1, aTrack)
       call ce2p(aTrack)
c           Nproduced = Nproduced + 1 
       idx = Nproduced + 2
c           Pwork(Nproduced) = aTrack.p
       Pwork(idx) = aTrack.p
c            knock on electron
       tmp=1.d0-cosr*cosr

       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cosr=1.d0
       endif
       sinr=sqrt(tmp)
       dc.r(1) = -cs*sinr
       dc.r(2) = -sn*sinr
       dc.r(3) = cosr
       call ctransVectZ(MovedTrack.vec.w, dc, dcr)
       aTrack.p.fm.p(4) = er
       call csetDirCos(dcr, aTrack)
c
       call cmkptc(kelec,  0,  -1,  aTrack.p)

       call ce2p(aTrack)
c            Nproduced = Nproduced + 1
       idx =  Nproduced + 1
       Pwork(idx) = aTrack.p

       Nproduced = Nproduced + 2
      end



