c           test csdepang2h: get height form a slant depth and angle.
c
c     for compilation, use:

c     use make csdepang2h
c
c
c      implicit none
c      real*8  csdepang2h, z, cosz, sdepl, chang2sdep
c      real*8  sdepmin, sdepmax
c
c      do cosz = 0.00d0, .5385533200001d0, .00313d0
c         sdepmin = log10( chang2sdep(50.d3, cosz) )
c         sdepmax = log10( chang2sdep(-400.d0, cosz )   )
c         do sdepl = sdepmin, sdepmax+1.d-6, (sdepmax - sdepmin)/100.d0
c            z = csdepang2h(10.d0**sdepl, cosz)
c            if(sdepl .gt. sdepmin+.1 .and. sdepl .lt. sdepmax - .1) then
c               write(*,*) sngl(cosz), sngl(z),  sngl(10.**sdepl)/
c     *        chang2sdep(z,cosz)
c            endif
c         enddo
c         write(*,*)
c      enddo
c      end
c     **********************************
      real*8 function csdepang2h(sdep,  cosz)
c     **********************************
c        slant depth and angle to vertical height
c
c      real*8 sdep.  input.  slant detph in kg/m2
c      real*8 cosz. input. cos of zenith angle at the point
c      real*8 function value.  vertical heihgt in m
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 sdep, cosz

      logical first/.true./
      save first


      integer row1, col1, row2, col2, row3, col3, row4, col4

      integer maxn    ! max # of points to be used for interploation 
                      !  in x and y direction (3x3 is default)
      parameter (maxn = 3)   ! almost no change if we put 5 or 7
      parameter (row1 = 304, col1 = 17, row2 = 446, col2 =15,
     *   row3 = 313,  col3 = 15,  row4 = 114, col4 = 11)

      real*8 htbl1(row1, col1), sdeptbl1(row1), costbl1(col1)
      real*8 htbl2(row2, col2), sdeptbl2(row2), costbl2(col2)
      real*8 htbl3(row3, col3), sdeptbl3(row3), costbl3(col3)
      real*8 htbl4(row4, col4), sdeptbl4(row4), costbl4(col4)

      real*8 dsdep1, dsdep2, dsdep3, dsdep4, 
     * dcos1, dcos2, dcos3, dcos4

      save dsdep1, dsdep2, dsdep3, dsdep4, 
     * dcos1, dcos2, dcos3, dcos4

      real*8  deprange(5)/5.58419, 4.00, 2.30, -1.10, -10.0/

      real*8 ans, error, caheight, cz2height, logsdep, coszs


c     -----------------------
c      if first, this reads 4 tables:
c 
c table 1    cos  cos**.50   log10(slantdepth/Kg/m2)     h m
c table 2    cos  cos**.25   log10(slantdepth/Kg/m2)     ratio   
c table 3    cos  cos**.5    log10(slantdepth/Kg/m2)     ratio   
c table 4    cos  cos**.5    log10(slantdepth/Kg/m2)     ratio   
c
      if(first) then
c            read data   (exact height)/(approx one) or height itself
         call csdepang2haux(1, 'sdep2htbl1.d', htbl1, row1, col1, 
     *        sdeptbl1, costbl1, dsdep1, dcos1)

         call csdepang2haux(2, 'sdep2htbl2.d', htbl2, row2, col2, 
     *        sdeptbl2, costbl2, dsdep2, dcos2)

         call csdepang2haux(3, 'sdep2htbl3.d', htbl3, row3, col3, 
     *        sdeptbl3, costbl3, dsdep3, dcos3)

         call csdepang2haux(4, 'sdep2htbl4.d', htbl4, row4, col4, 
     *        sdeptbl4, costbl4, dsdep4, dcos4)

         first =.false.
      endif
      if(cosz .gt. .575) then
c              inf radius of earth.
         csdepang2h = cz2height(sdep*cosz)
         return        ! ******************
      else
         logsdep = log10(sdep)
         if(logsdep .gt. deprange(1)) then
            csdepang2h = Minheight
            return  ! ******************

         elseif(logsdep .gt. deprange(2) ) then
            coszs = cosz** 0.50
            call kpolintp2(sdeptbl1, 1, dsdep1, costbl1, 1, dcos1,
     *           htbl1, row1, row1, col1, maxn, maxn, logsdep, 
     *           coszs, ans, error)
            csdepang2h = ans
            return ! *********
         elseif(logsdep .gt. deprange(3)) then
            coszs = cosz** 0.25
            call kpolintp2(sdeptbl2, 1, dsdep2, costbl2, 1, dcos2,
     *           htbl2, row2, row2, col2, maxn, maxn, logsdep, 
     *           coszs, ans, error)

         elseif(logsdep .gt. deprange(4)) then
            coszs = sqrt( cosz )
            call kpolintp2(sdeptbl3, 1, dsdep3, costbl3, 1, dcos3,
     *           htbl3, row3, row3, col3, maxn, maxn, logsdep, 
     *           coszs, ans, error)

         elseif(logsdep .gt. deprange(5)) then
            coszs = sqrt( cosz )
            call kpolintp2(sdeptbl4, 1, dsdep4, costbl4, 1, dcos4,
     *           htbl4, row4, row4, col4, maxn, maxn, logsdep, 
     *           coszs, ans, error)
         else
            csdepang2h = Maxheight
            return ! **********

         endif
         csdepang2h = ans * caheight(sdep, cosz)

      endif
      end
c     -----------------------------------------------------------
      subroutine csdepang2haux(nth, fname,  htbl, maxrow, maxcol,
     *       sdeptble, costble, dsdep, dcosz)
c     -----------------------------------------------------------
c           read  sdep2htbl1,2,..4.d and make
c           2-dim array htbl with row= sdepth  and  col= cosz**pow
c       nth: n-th call to this routine
c     fname: file name
c     htbl(maxrow, maxcol)
c     sdeptble(maxrow)
c     costble(maxcol)
c     dsdep:                step of sdepth in sdeptble
c     dcosz:             step of dcosz in costble.
c
      implicit none
#include  "Zmanager.h"
      integer maxrow, maxcol, nth
      real*8  htbl(maxrow, maxcol), dsdep, dcosz,
     *    dscos,   sdeptble(maxrow), costble(maxcol)
      character*(*) fname

      integer icon, i, colc, rowc, ios
      real*8 cost, sdept, coszt, ratio, height
      character*80 buf

         call copenf(TempDev, fname, icon)
         if(icon .ne. 0) stop 9999
         call cskipComment(TempDev, icon)
         if(icon .ne. 0) stop 9999
         i = 0
         cost = -3145.
         colc = 0
         do while (1)
            read(TempDev, '(a)', iostat=ios) buf
            if(ios .ne. 0) goto 10
            if(buf(1:1) .eq. '#') goto 9  ! next
            if(buf .ne. "                  ") then 
               read(buf, *) coszt, dscos, sdept, ratio, height
               i = i +1
               if(cost .ne. coszt) then    ! change of cos
                  cost = coszt
                  colc = colc + 1
                  if(colc .gt. maxcol)then
                     write(*, *) " # of cos data >", maxcol
                     stop 9999
                  endif
                  costble(colc)= dscos   ! cosz**.5 or  cosz**.25
                  rowc = 0
               endif   
               rowc = rowc + 1
               if(rowc .gt. maxrow) then
                  write(*, *) " # of height data >", maxrow
                  stop 9999
               endif
               if(nth .eq. 1) then
                  htbl(rowc, colc) = height
               else
                  htbl(rowc, colc) = ratio
               endif
               sdeptble(rowc) = sdept
            endif
 9          continue
         enddo
 10      continue
       dsdep = sdeptble(2)-sdeptble(1)
       dcosz =  costble(2) - costble(1)
c       write(*, *) " rowc =", rowc, " colc=", colc
c       write(*, *) (htbl(3, 3)), sdeptble(3), costble(3)
  
c       write(*, *) " sdep step =", dsdep, " cos step =", dcosz
       close(TempDev)
      end
