c     ******************************************************************
c     *
c     *  mfcopy:  copy specified events of mf2 results
c     *
c     ******************************************************************
c
c  /usage/
c        ft07f001: input namelist    old
c        ft07f002: input main data   old
c        ft08f001: output namelist   new or old
c        ft08f002: output main data  new or mod
c
c   contcp                    ft08f001 ft08f002
c     f         first copy.     new      new
c     t          cont           old      mod
c
c        select specified incident families and copy them
c              or
c        copy all events
c        to select all give sel='all'
c        to select specific 1ry give sel='p' etc
c        to select by event no. give sel='by#' and event no. in
c        list=.... (up to 50)
c        to drop events by #, give sel='by^#' and the events # in list=.
c
      program mfcopy
c
c
c       -inc $mfparm
c       -inc $mfci
c       -inc $mfco
c       -inc $mfch
       -inc $mfparm
       -inc $mfci
       -inc $mfco
       -inc $mfch
c
c
      logical contcp
      character*8 fdate/'00.01.00'/, ftime/'23.59.59'/
      data jobtcp/55/, nfin/500000/, nlast/0/
      common /$mfcpy/ sel, ncopy, nuncpy, ncpyev, list(50), nlist
      character*4 sel
c
      namelist /parmcp/ sel, nfin, nlast, contcp, jobtcp, ftime,
     *                  fdate, ncopy, nuncpy, list
c
      sel='p'
      read(5, parmcp, end=9000)
      write(6, parmcp)
c
c         init timer
      call timei(fdate, ftime, jobtcp)
      ncpyev=0
      if(.not. contcp) then
          ncopy=0
          nuncpy=0
c            first time
          call mfname(7, 'r', jcon)
          if(jcon .ne. 0) then
               write(6,'('' mfname err'')')
               stop
          endif
          call mfnam2(7, 'r', jcon)
          if(jcon .ne. 0) then
               write(6,'('' mfnam2 err'')')
               stop
          endif
          call mfmin1(7, 'r', jcon)
          if(jcon .ne. 0) then
               write(6,'('' mfmin1 err'')')
               stop
          endif
c            copy to output tape
          call mfname(8, 'w', jcon)
          call mfnam2(8, 'w', jcon)
          call mfmin1(8, 'w', jcon)
c            print
          call mfname(6, 'w', jcon)
          call mfnam2(6, 'w', jcon)
          call mfmin1(6, 'w', jcon)
c            skip to ft07f002
c          *** until loop*** 
          do while (.true.)
             call mfname(7, 'r', jcon)
          if         (jcon .ne. 0)
     *                       goto 100
          enddo
  100     continue
c            skip to ft08f002
          endfile 8
      else
          write(6, '('' this is cont job of mfcopy'')')
c           cont job
          call mfname(7, 'r', jcon)
          call mfnam2(7, 'r', jcon)
          call mfmin1(7, 'r', jcon)
c          *** until loop*** 
          do while (.true.)
c               read namelist and skip to ft07f002
              call mfname(7, 'r', jcon)
          if         (jcon .ne. 0)
     *                       goto 200
          enddo
  200     continue
          call mfname(8, 'r', jcon)
          call mfnam2(8, 'r', jcon)
          call mfmin1(8, 'r', jcon)
c          *** until loop*** 
          do while (.true.)
c               read namelist and skip to ft08f002
              call mfname(8, 'r', jcon)
          if         (jcon .ne. 0)
     *                       goto 300
          enddo
  300     continue
      endif
      if(sel .eq. 'by#' .or. sel .eq. 'by^#') then
          call fdskey(list, 1, 4, 4, 50, 0, 1, nd, nlist, jcon)
          if(jcon .eq. 0) then
             nlist=nlist-1
          else
             nlist=50
          endif
      endif
c
c      *** until loop*** 
      do while (.true.)
c             skip to next shower
          call mfstns(7, jfin)
          if(jfin .ne. 0) goto 1000
c             read heading of 1 shower
          call mfmh1s(7, 'r', jfin)
          if(jfin .eq. 0 .and. nshwno .le. nfin) then
              nshwnx=nshwno
              if(nshwno .gt. nlast) then
c                   copy 1 shower  if selected
                  call mfcp1s
              endif
              call timec(1, jcon)
              if(jcon .ne. 0 .and. nshwno .lt. nfin) then
                  jfin=3
              endif
          endif
      if         (nshwno .ge. nfin .or. jfin .ne. 0)
     *                   goto 1000
      enddo
 1000 continue
c
      write(6,'('' end condition='',i2)') jfin
      write(6,'(''              =0 -->copy upto specified final one'',
     *'' completed'')')
      write(6,'(''              =1 -->e.o.f apperaed before specified'',
     *'' final one appeares:  all input tape copied. ok'')')
      write(6,'(''              =2 -->the last shower has no right'',
     *'' end mark: but copy ok'')')
      write(6,'(''              =3 -->time lacks. '')')
c
      write(6, '('' the last shower # copied is'',i7)') ncpyev
      write(6, '('' the last shower # processed in input is'',i7)')
     *      nshwnx
      write(6, '('' no. of showers copied is '',i7)') ncopy
      write(6, '('' no. of showers not copied is'',i7)') nuncpy
      write(6,'('' use above for nlast, ncopy, nuncpy, if cont run'',
     * '' is needed'')')
      stop
 9000 continue
      write(6,'('' no parmcp given'')')
      stop
      end
c     ******************************************************************
c     *
c     *  mfcp1s:  copy 1 shower:  assume heading has been read already
c     *
c     ******************************************************************
c
c
      subroutine mfcp1s
c
c       -inc $mfparm
c       -inc $mfci
c       -inc $mfco
c       -inc $mfch
       -inc $mfparm
       -inc $mfci
       -inc $mfco
       -inc $mfch
c
      common /$mfcpy/ sel, ncopy, nuncpy, ncpyev, list(50), nlist
      character*4 sel
c
      if(sel .eq. 'by#' .or. sel .eq. 'by^#') then
c            find same # in list
          call fdskey(list,1,4,4, nlist, nshwno, 1, nd, ld, jcon)
          if(sel .eq. 'by^#') then
              if(jcon .eq. 0) then
                  jcon=1
              else
                  jcon=0
              endif
          endif
      elseif(sel .eq. 'all'  .or.  ( sel .eq. k1ry) ) then
          jcon=0
      else
          jcon=1
      endif
c
      if(jcon .eq. 0) then
          ncpyev=nshwno
c            write start mark
          call mfwstt(8)
c            copy heding
          w3inps=w3inp
          call mfmh1s(8, 'w', jcon)
c                   output a.s results
          if(obas) call mfoas
c                   output ec2-type results
          if(obec2) call mfoec2
          if(ttrcor) call mfotrc
          if(trecor) call mforec
          if(arvtm) call mfoart
c                   output ec1-type results
          if(obec1) call mfoec1
          ncopy=ncopy+1
      else
c              not triggered. count such events
          nuncpy=nuncpy+1
      endif
      return
      end
c     ******************************************************************
c     *                                                                *
c     * mfoec1: output data concerning each ptcl observation by ec1    *
c     *                                                                *
c     ******************************************************************
c
c
c
c
      subroutine mfoec1
c
c       -inc $mfparm
c       -inc $mfch
c       -inc $mfci
c       -inc $mfco
       -inc $mfparm
       -inc $mfch
       -inc $mfci
       -inc $mfco
c
c
       do   l=1,nlvl
         if(ec1(l)) then
             call mfcp1l(l)
         endif
       enddo
      return
c     ******************************************************************
c     *                                                                *
c     * mfoec2: output data concerning neblous (hallo) observation     *
c     *                                                                *
c     ******************************************************************
c
c
c
c                          1000********
                           entry mfoec2
c                          ************
c
c             skip to ec2 rec
      call mfsec2(7,      jcon)
      if(jcon .ne. 0) then
           write(6,'(''0***err: unexpected eof during ec2 data'',
     *     '' search in 7  current event # is'',i10)') nshwno
           stop
      else
           call mftec2(8)
            do   l=1,nlvl
              if(ec2(l)) then
c                    level index for hallo
                 ll=lvlneb(l)
                 z=depth(l)
                 call mfmhal(7, 'r', z, ll)
                 call mfmhal(8, 'w', z, ll)
              endif
            enddo
      endif
      return
      end
c     ******************************************************************
c     *                                                                *
c     * mfoas: output results for a.s. observation                     *
c     *                                                                *
c     ******************************************************************
c
c
c
                            subroutine mfoas
c
c
       -inc $mfparm
       -inc $mfch
       -inc $mfco
       -inc $mfci
c
c
c            skip to the top of a.s data
      call mfsas(7, jcon)
      if(jcon .ne. 0) then
          write(6,'(''0*** unexpected eof during'',
     *    '' a.s data search in 7, current shower #='',
     *    i10)') nshwno
          stop
      else
c            top mark
          call mftas(8)
c            read size and copy
          call mfmtsz(7, 'r', ncola)
          call mfmtsz(8, 'w', ncola)
c                     write three dimensional quantities on mt
           do   l=1,nlvla
             if(latas(l)) then
c                   at this level, lateral has been taken
                ld=lvllt(l)
                call mfmlat(7,  'r', l, ld)
                call mfmlat(8,  'w', l, ld)
             endif
           enddo
      endif
      return
      end
      subroutine mfotrc
       -inc $mfparm
       -inc $mfch
       -inc $mfco
       -inc $mfci
        dimension
     1  recor(nrbin, nebin),
     2  trcor(ntbin, nrbin),
     3 atimed(ntmbin, nrbint)
c          top mark
      call mfstrc(7, icon)
      if(icon .ne. 0) then
          write(*,*) ' ttr data missing'
          stop
      endif
c          output t-r correlation
       do   k=1, mxptct
         if(trcork(k)) then
              do   l=1, nlvl
                 call mfwtrc(7,  'r', ntbin, nrbin, trcor,
     *            k, l)
                 call mfwtrc(8,  'w', ntbin, nrbin, trcor,
     *           k, l)
              enddo
         endif
       enddo
      return
c     ***************
      entry mforec
c     ***************
      call mfsrec(7, icon)
      if(icon .ne. 0) then
          write(*,*) ' rec data missing'
          stop
      endif
      call mftrec(8)
c          output r-e correlation
       do   k=1, mxptct
         if(recork(k)) then
              do   l=1, nlvl
                 call mfwrec(7,  'r', nrbin, nebin, recor,
     *           k, l)
                 call mfwrec(8,  'w', nrbin, nebin, recor,
     *           k, l)
              enddo
         endif
       enddo
      return
c     **************
      entry mfoart
c     ************
      call mfstim(7, icon)
      if(icon .ne. 0) then
          write(*,*) ' art data missing'
          stop
      endif
      call mfttim(8)
c          output arrival time distribution
       do   k=1, mxptct
         if(arvtmk(k)) then
              do   l=1, nlvl
                 call mfwatm(7,  'r', ntmbin,nrbint, atimed,
     *           k, l)
                 call mfwatm(8,  'w', ntmbin,nrbint, atimed,
     *           k, l)
              enddo
         endif
       enddo
      return
      end
c     ******************************************************************
c     *
c     *  mfcp1l:  copy 1 level of ec1 data
c     *
c     ******************************************************************
c
c
      subroutine mfcp1l(l)
c
c
c       -inc $mfparm
c       -inc $mfch
c       -inc $mfci
c       -inc $mfco
       -inc $mfparm
       -inc $mfch
       -inc $mfci
       -inc $mfco
c
      dimension oba(nwpp, mobp), aoba(nwpp, mobp)
      dimension toba(mobp)
      real*8 toba
      logical ok
c
c             skip to the ec1 data of the specified level
c             and read data
      call mfssl(7, l, kcon)
      if(kcon .ne. 0) then
c             unexpected e.o.f
           write(6, '(''0***err: unexpected eof during ec1 level'',
     *     '' search '')')
           write(6, '('' current event# and level='', 2i10)')
     *     nshwno, l
           stop
      endif
c         write heading of 1 level
       call mfmh1l(8, 'w', l)
c         read ptcl data and copy
        do   kk=1,kindmx
          if(obeck(kk)) then
             nc=0
             ok=.false.
c             *** until loop*** 
             do while (.true.)
c                  read data
                call mfmobr(7, 'r', oba, aoba, toba, np, k, l,
     *          ncum, nk, anobp,npg, ntpg)
                nc=nc+np
                call mfmobr(8, 'w', oba, aoba, toba, np, k, l,
     *          ncum, nk, anobp, npg, ntpg)
c
                if(nc .eq. nk      .and.  ntpg .eq. 1) then
                   ok=.true.
                elseif(np .eq. 0) then
                   ok=.true.
                endif
             if         ( ok )
     *                          goto 1000
             enddo
 1000        continue
          endif
        enddo
      return
      end
       -inc mfcsub
       -inc mfcsub2
