c
c     for compilation, use:

c   f77 read.f ../../Sysdep/copenf.f ../../KKlib/cskipComment.f \
c    ../../KKlib/kpolintp2.f ../../KKlib/kpolintp.f ../../KKlib/kdwhereis.f\
c     caslantdep.f ../../KKlib//kerfc.f catmos0.f

      real*8 dummy
      dummy = csdepang2h(100.d0, .1d0)
      end
c     **********************************
      real*8 function csdepang2h(sdep, cosz)
c     **********************************
c        slant depth and angle to vertical height
c      real*8 sdep.  input.  slant detph in kg/m2
c      real*8 cosz. input. cos of zenith angle at the point
c      real*8 function value.  vertical heihgt in m
c
      implicit none

      real*8 sdep, cosz

      logical first/.true./
      save first


      integer row1, col1

      parameter (row1=1800, col1 = 30)
      real*8 htbl1(row1, col1), sdeptbl1(row1), costbl1(col1)

      real*8 dsdep1,
     *     dcos1



      if(first) then
c            read data   (exact height)/(approx one)
         call csdepang2haux('sdep2htbl1.d', htbl1, row1, col1, 
     *        sdeptbl1, costbl1, dsdep1, dcos1)
         call csdepang2haux('sdep2htbl2.d', htbl1, row1, col1, 
     *        sdeptbl1, costbl1, dsdep1, dcos1)
         call csdepang2haux('sdep2htbl3.d', htbl1, row1, col1, 
     *        sdeptbl1, costbl1, dsdep1, dcos1)
         call csdepang2haux('sdep2htbl4.d', htbl1, row1, col1, 
     *        sdeptbl1, costbl1, dsdep1, dcos1)
         first =.false.
      endif
      csdepang2h = 0.
      end
c     -----------------------------------------------------------
      subroutine csdepang2haux(fname,  htbl, maxrow, maxcol,
     *       sdeptble, costble, dsdep, dcosz)
c     -----------------------------------------------------------
c           read  ratio of (exact heightt delpth)/approx one
c           from specified file and set 2-dim array htbl
c           with row= height 
c           and  col= cosz
c     fname: file name
c     htbl(maxrow, maxcol)
c     sdeptble(maxrow)
c     costble(maxcol)
c     dsdep:                step of sdepth in sdeptble
c     dcosz:             step of dcosz in costble.
c
      implicit none
#include  "Zmanager.h
      integer maxrow, maxcol
      real*8  htbl(maxrow, maxcol), dsdep, dcosz,
     *        sdeptble(maxrow), costble(maxcol)
      character*(*) fname

      integer icon, i, colc, rowc, ios
      real*8 cost, sdept, coszt, ratio, dscos
      character*80 buf
         write(*,*) ' max row=', maxrow
         call copenf(TempDev, fname, icon)
         if(icon .ne. 0) stop 9999
         call cskipComment(TempDev, icon)
         if(icon .ne. 0) stop 9999
         i = 0
         cost = -3145.
         colc = 0
         do while (1)
            read(TempDev, '(a)', iostat=ios) buf
            if(ios .ne. 0) goto 10
            if(buf(1:1) .eq. '#') goto 9  ! next
            if(buf .ne. "                  ") then 
               read(buf, *) coszt, dscos,  sdept, ratio
               i = i +1
               if(cost .ne. coszt) then    ! change of cos
                  cost = coszt
                  colc = colc + 1
                  if(colc .gt. maxcol)then
                     write(*, *) " # of cos data >", maxcol
                     stop 9999
                  endif
                  costble(colc)= dscos
                  rowc = 0
               endif   
               rowc = rowc + 1
               if(rowc .gt. maxrow) then
                  write(*, *) " # of height data >", maxrow
                  stop 9999
               endif
               htbl(rowc, colc) = ratio
               sdeptble(rowc) = sdept
            endif
 9          continue
         enddo
 10      continue
       dsdep = sdeptble(2)-sdeptble(1)
       dcosz =  costble(2) - costble(1)
       write(*, *) " rowc =", rowc, " colc=", colc
       write(*, *) (htbl(3, 3)), sdeptble(3), costble(3)
  
       write(*, *) " sdep step =", dsdep, " cos step =", dcosz
       close(TempDev)
      end

