c         test cbremsPath, cbremsEnerg
c      implicit none
c      real*8  ee, eg, t
c      integer i
c      write(0, *) " Enter electron energy in GeV"
c      read(*, *)  ee
c      do i =1, 10000
c         call cbremsPath(ee, t)
c         call cbremsEnergy(ee, eg)
c         write(*, *) sngl(t), sngl(eg), sngl(eg/ee),
c     *   sngl(log10(eg/ee))
c      enddo
c      end
c     ****************************************************************
c     *                                                              *
c     *      brems and pair in air.   Energy in GeV. path in r.l     *
c     *                                                              *
c     *  cbremsPath:  samples path for brems                         *
c     *  cbremsEnergy:  samples energy of brems gamma                *
c     *                                                              *
c     ************ this is version for Egcut= .1 MeV in air **********
c                  without Landau effect.
c
c
c
c   ********************************************************************
c
c         sampling table for brems
c
c     Egcut of brems gamma ray is .1 MeV.  that is brems gamma less than
c     .1 MeV is not generated by this table. 
c
c
c
c   /usage/          call cbremsPath(ee, t)
c                    call cbremsEnergy(ee, beg)
c
c      ee:  electron energy  GeV
c       t:  sampled path     r.l
c     beg:  sampled gamma energy  GeV
c
c          To call cbremsEnergy,cbremsPath must be called
c
c
      subroutine cbremsPath(ee, t)
      implicit none
      real*8 ee, t
c
c            table of total cross section of bremsing (eg > .1MeV
c     /r.l.   energy is from 2MeV to 200gev in step .3333 (log10 scale)
c
      integer i
      real*8 tcb(20)
c
c        let v be energy of produced ptcl/energy of incident ptcl
c        let u be uniform random no. in (0, 1).
c
c         2 dimen.  table of   ln(v/vmin)/ (1-u)  for brems
c      for u=0.05 to 1. step .05 and log10(e)=log10(1.e-3/GeV) to log10(200
c      /GeV)  step .2790    dimension is vb1(20,  20)
c                                            !for u    !for log10(e)
c
c      to sample eg by electron brems, 1st sample uniform random no. u.
c      if u>.1 use this table.  take log10(e) and use two dimensional
c      interpolation to get value(=y) of vb1 at given (u,log10(e)) and
c      set eg= e * vmin * exp((1-u)*y)= 1.e-4 * exp( (1.-u) * y)
c      (in gev)  (vmin =1.e-4/e;    1.e-4 = egcut in gev).
c
c
      real*8 emass/0.511e-3/

      real*8  vb1(400)
      real*8  evb1(20, 20)
      equivalence (evb1(1, 1), vb1(1))
c
c
c       2 deim. brems sampling table.
c      value of  ln(v/vmin)  from sqrt(u)=0 to sqrt(.05) step sqrt(.01)
c       and e=1.e-3 gev   to 200gev as in vb1 (log10 scale).
c         use this table if u<.05
c         eg=e * vmin * exp(y) = 1.e-4 * exp(y)   (in gev)
c
      real*8 vb2(400)
      real*8 evb2(20, 20)
      equivalence(evb2(1,1),  vb2(1))
      real*8 us
c
c
c        ecut:   predetermined cut-off energy for bremsung gamma=.1 MeV.
      real*8  ecut/1.d-4/
c
c
      logical screen, scorec/.true./
c
c                 log 1d-3
      real*8  ebmni/-3.d0/

      real*8 escb/10.d0/
c
      real*8 rx0/0.98d0/
      real*8 u, alu, eesv, vc, tp, a, v, beg, ans, ale

      data ( tcb(i), i=  1,   20)/
     1   1.0605, 2.0565, 3.1238, 4.1982, 5.2493, 6.2668, 7.2504, 8.2043,
     2   9.1338,10.0448,10.9425,11.8305,12.7124,13.5902,14.4653,15.3389,
     3   16.2116,17.0838,17.9557,18.8275/
     
       data ( vb1(i), i=  1,   119)/
     1  1.4842,  1.4128,  1.3591,  1.3150,  1.2766,  1.2461,  1.2173,
     2  1.1905,  1.1691,  1.1465,  1.1289,  1.1107,  1.0936,  1.0802,
     3  1.0644,  1.0536,  1.0358,  1.0194,  1.0183,  1.0054,  2.3441,
     4  2.2096,  2.1150,  2.0421,  1.9826,  1.9330,  1.8898,  1.8510,
     5  1.8181,  1.7874,  1.7601,  1.7329,  1.7117,  1.6891,  1.6719,
     6  1.6570,  1.6351,  1.6177,  1.6178,  1.5925,  3.0693,  2.9111,
     7  2.8029,  2.7196,  2.6535,  2.5985,  2.5529,  2.5126,  2.4812,
     8  2.4515,  2.4303,  2.4065,  2.3883,  2.3693,  2.3513,  2.3395,
     9  2.3236,  2.3061,  2.3003,  2.2876,  3.7774,  3.6143,  3.5042,
     a  3.4214,  3.3595,  3.3081,  3.2666,  3.2346,  3.2041,  3.1788,
     b  3.1554,  3.1351,  3.1171,  3.1043,  3.0867,  3.0788,  3.0647,
     c  3.0615,  3.0586,  3.0393,  4.4794,  4.3214,  4.2175,  4.1396,
     d  4.0815,  4.0350,  3.9956,  3.9652,  3.9393,  3.9155,  3.8972,
     e  3.8835,  3.8712,  3.8593,  3.8478,  3.8348,  3.8294,  3.8282,
     f  3.8113,  3.8148,  5.1762,  5.0286,  4.9267,  4.8523,  4.7968,
     g  4.7532,  4.7183,  4.6908,  4.6693,  4.6511,  4.6373,  4.6261,
     h  4.6167,  4.6064,  4.6025,  4.5935,  4.5953,  4.5816,  4.5870
     * /
         data ( vb1(i), i=  120,   238)/
     1  4.5786,  5.8668,  5.7208,  5.6222,  5.5501,  5.4986,  5.4577,
     2  5.4286,  5.4053,  5.3875,  5.3710,  5.3608,  5.3505,  5.3416,
     3  5.3358,  5.3302,  5.3300,  5.3202,  5.3240,  5.3217,  5.3173,
     4  6.5458,  6.4010,  6.3005,  6.2317,  6.1825,  6.1457,  6.1202,
     5  6.0990,  6.0838,  6.0715,  6.0611,  6.0535,  6.0500,  6.0445,
     6  6.0394,  6.0365,  6.0389,  6.0320,  6.0431,  6.0305,  7.2116,
     7  7.0652,  6.9668,  6.8988,  6.8528,  6.8195,  6.7948,  6.7768,
     8  6.7623,  6.7517,  6.7449,  6.7388,  6.7360,  6.7299,  6.7264,
     9  6.7237,  6.7267,  6.7201,  6.7244,  6.7222,  7.8685,  7.7192,
     a  7.6191,  7.5535,  7.5084,  7.4778,  7.4570,  7.4395,  7.4302,
     b  7.4217,  7.4163,  7.4085,  7.4069,  7.4041,  7.4038,  7.4001,
     c  7.3972,  7.3931,  7.3885,  7.3978,  8.5167,  8.3620,  8.2624,
     d  8.1995,  8.1576,  8.1289,  8.1079,  8.0963,  8.0852,  8.0786,
     e  8.0731,  8.0698,  8.0696,  8.0648,  8.0676,  8.0625,  8.0653,
     f  8.0563,  8.0811,  8.0618,  9.1578,  8.9996,  8.9005,  8.8388,
     g  8.7980,  8.7736,  8.7552,  8.7448,  8.7364,  8.7296,  8.7262,
     h  8.7227,  8.7214,  8.7203,  8.7214,  8.7206,  8.7143,  8.7234
     * /
        data ( vb1(i), i=  239,   357)/
     1  8.7148,  8.7177,  9.7953,  9.6314,  9.5333,  9.4745,  9.4379,
     2  9.4144,  9.3991,  9.3889,  9.3823,  9.3768,  9.3743,  9.3748,
     3  9.3698,  9.3701,  9.3700,  9.3654,  9.3710,  9.3702,  9.3531,
     4  9.3686, 10.4286, 10.2606, 10.1646, 10.1084, 10.0752, 10.0545,
     5 10.0406, 10.0315, 10.0273, 10.0222, 10.0223, 10.0189, 10.0192,
     6 10.0188, 10.0191, 10.0197, 10.0152, 10.0228, 10.0174, 10.0160,
     7 11.0595, 10.8893, 10.7962, 10.7434, 10.7105, 10.6933, 10.6804,
     8 10.6728, 10.6683, 10.6654, 10.6638, 10.6624, 10.6617, 10.6600,
     9 10.6616, 10.6624, 10.6635, 10.6586, 10.6648, 10.6613, 11.6894,
     a 11.5189, 11.4272, 11.3767, 11.3477, 11.3307, 11.3211, 11.3153,
     b 11.3102, 11.3091, 11.3066, 11.3056, 11.3051, 11.3050, 11.3066,
     c 11.3024, 11.3029, 11.3035, 11.3164, 11.3053, 12.3185, 12.1472,
     d 12.0582, 12.0112, 11.9845, 11.9704, 11.9610, 11.9547, 11.9538,
     e 11.9517, 11.9508, 11.9488, 11.9490, 11.9462, 11.9477, 11.9509,
     f 11.9463, 11.9424, 11.9386, 11.9486, 12.9492, 12.7760, 12.6909,
     g 12.6470, 12.6229, 12.6090, 12.6017, 12.5973, 12.5957, 12.5942,
     h 12.5912, 12.5910, 12.5932, 12.5922, 12.5905, 12.5902, 12.5920
     * /
         data ( vb1(i), i=  358,   400)/
     1   12.5881, 12.5953, 12.5915, 13.5779, 13.4060, 13.3239, 13.2825,
     2   13.2604, 13.2479, 13.2419, 13.2386, 13.2361, 13.2347, 13.2353,
     3   13.2336, 13.2357, 13.2352, 13.2352, 13.2356, 13.2363, 13.2365,
     4   13.2295, 13.2342, 14.2085, 14.0380, 13.9589, 13.9190, 13.8988,
     5   13.8884, 13.8820, 13.8807, 13.8794, 13.8784, 13.8781, 13.8756,
     6   13.8779, 13.8754, 13.8734, 13.8740, 13.8721, 13.8787, 13.8654,
     7   13.8767
     * /
                                                               
          data ( vb2(i), i=  1,   119)/
     1   1.5872,  1.5850,  1.5844,  1.5813,  1.5781,  1.5719,  1.5655,
     2   1.5592,  1.5512,  1.5415,  1.5317,  1.5202,  1.5085,  1.4967,
     3   1.4831,  1.4692,  1.4551,  1.4409,  1.4246,  1.4099,  2.6320,
     4   2.6297,  2.6224,  2.6114,  2.5965,  2.5795,  2.5621,  2.5406,
     5   2.5190,  2.4954,  2.4713,  2.4465,  2.4212,  2.3940,  2.3672,
     6   2.3397,  2.3127,  2.2836,  2.2550,  2.2269,  3.4350,  3.4291,
     7   3.4157,  3.3982,  3.3765,  3.3527,  3.3277,  3.3011,  3.2738,
     8   3.2445,  3.2156,  3.1845,  3.1537,  3.1220,  3.0892,  3.0552,
     9   3.0216,  2.9867,  2.9506,  2.9147,  4.1526,  4.1447,  4.1272,
     a   4.1068,  4.0844,  4.0605,  4.0349,  4.0075,  3.9794,  3.9492,
     b   3.9182,  3.8849,  3.8517,  3.8174,  3.7805,  3.7436,  3.7068,
     c   3.6686,  3.6288,  3.5891,  4.8324,  4.8226,  4.8068,  4.7873,
     d   4.7658,  4.7428,  4.7181,  4.6917,  4.6635,  4.6332,  4.6021,
     e   4.5686,  4.5340,  4.4981,  4.4610,  4.4223,  4.3822,  4.3419,
     f   4.2999,  4.2561,  5.4939,  5.4841,  5.4703,  5.4527,  5.4333,
     g   5.4114,  5.3879,  5.3627,  5.3346,  5.3057,  5.2748,  5.2416,
     h   5.2059,  5.1703,  5.1320,  5.0922,  5.0506,  5.0073,  4.9637
     * /
        data ( vb2(i), i=  120,   238)/
     1  4.9181,  6.1463,  6.1384,  6.1246,  6.1090,  6.0917,  6.0709,
     2  6.0497,  6.0247,  5.9980,  5.9694,  5.9387,  5.9058,  5.8705,
     3  5.8340,  5.7946,  5.7537,  5.7110,  5.6663,  5.6213,  5.5741,
     4  6.7938,  6.7860,  6.7741,  6.7606,  6.7444,  6.7258,  6.7047,
     5  6.6810,  6.6556,  6.6272,  6.5968,  6.5642,  6.5280,  6.4905,
     6  6.4514,  6.4094,  6.3640,  6.3180,  6.2682,  6.2192,  7.4390,
     7  7.4331,  7.4232,  7.4098,  7.3946,  7.3771,  7.3562,  7.3337,
     8  7.3084,  7.2803,  7.2489,  7.2166,  7.1793,  7.1407,  7.0991,
     9  7.0543,  7.0074,  6.9581,  6.9063,  6.8517,  8.0828,  8.0769,
     a  8.0691,  8.0566,  8.0425,  8.0251,  8.0053,  7.9829,  7.9567,
     b  7.9286,  7.8974,  7.8628,  7.8244,  7.7831,  7.7401,  7.6923,
     c  7.6420,  7.5891,  7.5332,  7.4759,  8.7260,  8.7221,  8.7122,
     d  8.7023,  8.6877,  8.6714,  8.6516,  8.6282,  8.6020,  8.5729,
     e  8.5406,  8.5035,  8.4637,  8.4196,  8.3735,  8.3238,  8.2698,
     f  8.2128,  8.1541,  8.0917,  9.3688,  9.3649,  9.3570,  9.3471,
     g  9.3325,  9.3162,  9.2954,  9.2721,  9.2448,  9.2134,  9.1787,
     h  9.1402,  9.0976,  9.0518,  9.0024,  8.9474,  8.8908,  8.8308
     * /
       data ( vb2(i), i=  239,   357)/
     1  8.7670,  8.7008, 10.0115, 10.0075,  9.9997,  9.9897,  9.9762,
     2  9.9589,  9.9381,  9.9136,  9.8853,  9.8515,  9.8154,  9.7742,
     3  9.7286,  9.6796,  9.6265,  9.5690,  9.5079,  9.4429,  9.3752,
     4  9.3046, 10.6540, 10.6501, 10.6442, 10.6343, 10.6197, 10.6014,
     5 10.5796, 10.5529, 10.5222, 10.4883, 10.4484, 10.4055, 10.3568,
     6 10.3042, 10.2473, 10.1869, 10.1210, 10.0539,  9.9821,  9.9062,
     7 11.2965, 11.2925, 11.2866, 11.2767, 11.2612, 11.2428, 11.2189,
     8 11.1922, 11.1591, 11.1227, 11.0812, 11.0341, 10.9834, 10.9272,
     9 10.8675, 10.8026, 10.7331, 10.6620, 10.5856, 10.5066, 11.9389,
     a 11.9369, 11.9291, 11.9172, 11.9026, 11.8832, 11.8582, 11.8292,
     b 11.7949, 11.7558, 11.7115, 11.6625, 11.6084, 11.5496, 11.4857,
     c 11.4175, 11.3442, 11.2670, 11.1880, 11.1051, 12.5814, 12.5794,
     d 12.5715, 12.5596, 12.5441, 12.5226, 12.4974, 12.4662, 12.4305,
     e 12.3888, 12.3428, 12.2907, 12.2330, 12.1703, 12.1017, 12.0299,
     f 11.9543, 11.8744, 11.7904, 11.7028, 13.2238, 13.2218, 13.2140,
     g 13.2021, 13.1845, 13.1629, 13.1356, 13.1031, 13.0650, 13.0217,
     h 12.9716, 12.9174, 12.8559, 12.7904, 12.7186, 12.6431, 12.5633
     * /
       data ( vb2(i), i=  358,   400)/
     1 12.4791, 12.3922, 12.3008, 13.8662, 13.8643, 13.8564, 13.8425,
     2 13.8259, 13.8023, 13.7738, 13.7400, 13.6994, 13.6534, 13.6013,
     3 13.5438, 13.4798, 13.4100, 13.3365, 13.2572, 13.1731, 13.0849,
     4 12.9935, 12.8993, 14.5087, 14.5067, 14.4988, 14.4849, 14.4663,
     5 14.4416, 14.4119, 14.3758, 14.3337, 14.2849, 14.2310, 14.1699,
     6 14.1034, 14.0306, 13.9521, 13.8687, 13.7823, 13.6915, 13.5966,
     7 13.4984
     * /
                                    
                                                      

      save tp, screen, ale

c
c       rx0=x0(true)/x0(in nishimura text)
c
      if(.not. scorec  .or.  ee .gt. escb) then
c            complete screening cross-section
          screen=.false.
          vc=ecut/ee
          tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
      else
c             partial screening: for low energy e, use 1MeV x-section
          if(ee .gt. 1.d-3) then
               screen=.true.
               eesv=ee
          else
               screen=.true.
               eesv=max(.6d-3, ee)
          endif
          ale=log10(eesv)
          call kintp3(tcb, 1, 20,  ebmni, 0.2790d0,  ale, tp)
          if( tp .le. 0.) then
             write(0, *) ' tp=' ,tp, ' ee=',ee
          endif
       endif
      call rndc(u)
      alu=-log(u)
      t= alu/tp
      return
c
c     ************
      entry cbremsEnergy(ee, beg)
c     ************
c
      call rndc(u)
      if(.not. screen) then
c            complete screening
          a=u*tp
          if(a .lt. 1.) then
              v=exp(-a)
              if(a  .gt. .1) then
                  v=((.06366*a-.1447407)*a+1.014176)*v
              endif
          else
              v=exp(-(a+0.8603)/1.3603)
              if(a .lt. 6.) then
                   v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a
     *             -.684076)*a +1.841734)*v
              endif
          endif
          beg=ee*v
      else
c            partial screening
          if(u .gt. 0.05) then
               call  k4ptdi(evb1, 20, 20, 20, 0.05d0, ebmni,.05d0, 
     *         .2790d0,  u, ale, ans)
               beg=exp(ans*(1.-u))* ecut 
          else
               us = sqrt(u)
               call  k4ptdi(evb2, 20, 20, 20, 0.d0, ebmni, 
     *         1.176884211d-02, .2790d0,   us, ale, ans)
               beg =exp( ans  ) * ecut
          endif
      endif
      if(ee - beg .le. emass) then
         beg =( ee -emass )* 0.9999
      endif
      end

