c
c                              =   =   =   =
c
      real*8  function cdep2len0(cosz, z1, z2)
c             near vertical cosz case.
c
c       cosz: input. real*8.cos(zenith angle) at a vertical depth z1.
c         z1: input. real*8. slant depth in (kg/m2) along cosz
c         z2: input. real*8. slant depth in //       along cosz.
c      function value is the slant distance between z1 and z2 (m)
c                             
c                             |/
c                             /   slant depth
c                            /| z1           
c   slant length cdep2len   /*|
c                          / cosz 
c                         /
c                        z2
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"


      real*8  cosz, z1, z2


      real*8  zc, za 

      include 'cstandatmos.h'  ! standard atoms. vertical

      if(cosz .ne. 1.d0) then
c             convert to vertical depths
          zc = z2*cosz
          za = z1*cosz
      else      
          zc = z2
          za = z1
      endif
c          convert to g/cm2
      zc = zc * Togpcm2
      za = za * Togpcm2
c
      if( zc .lt. z0 ) then
c              za < zc < z0       cz2height1(za) - cz2height1(zc) is:
            cdep2len0 = log(zc/za) * hn
      else
            if(za .gt. z0) then
c                      zc > za > z0
                 cdep2len0 = cz2height2 (za) -cz2height2 (zc)
            else
c                      za < z0 < zc
                 cdep2len0 =  cz2height1(za) - cz2height2 (zc)
            endif
c
      endif
c
      if(cosz .ne. 1.) then
c            convert to dist along incident
          cdep2len0 = cdep2len0/cosz
      endif
c       convert to m
      cdep2len0 = cdep2len0 * Tom
      end
c
c             give air density at z
c     ************
      real*8 function cdenair(z)
c     ************
c     z: input real*8.  vertical depth in kg/cm2
c     function value: density of air at z in kg/cm3

      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"

c     
      real*8 z
c
      real*8 za
      include 'cstandatmos.h'

      za = z * Togpcm2
      if(za .lt. z0) then
           cdenair =  za/hn
      else
           cdenair= crhover(za)
      endif
      cdenair = cdenair * Tokgpm3
      end
c
c     ************gives height from sea level at vertical depth z 
      real*8 function cz2height(z)
c     ************
c          z: input. real*8.  kg/m2
c     function value:   height from the sealevel in m

      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
      real*8 z
 
c
      real*8 za
      include 'cstandatmos.h'

      za = z * Togpcm2
      if(za .lt. z0) then
          cz2height = cz2height1( za )
      else
          cz2height = cz2height2 ( za )
      endif
      cz2height = cz2height * Tom
      end
c             gives scale height at z
c     ************
      real*8 function cz2scaleh( z )
c     ************
c      z: input. real*8.  vertical depth in kg/m2.
c      function value.  scale height in m
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"


c
      real*8  z

      real*8 za
      include 'cstandatmos.h'

      za = z * Togpcm2
      if(za .lt. z0) then
          cz2scaleh =  hn
      else
          cz2scaleh = za/ crhover( za  )
      endif
      cz2scaleh = cz2scaleh * Tom
      end

c             gives depth from height
c     ************
      real*8 function  ch2dep( h )
c     ************
c        h: input. real*8. vertical height in  m.
c    function value.  verticaldepth in kg/m2
c
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"

c
      real*8 h
c
      real*8 hr
      include 'cstandatmos.h'

      hr=h * Tocm
      if(hr .gt. hc) then
          ch2dep =  ch2dep1(hr)
      else
          ch2dep=   ch2dep2(hr)
      endif
      ch2dep = ch2dep * Tokgpm2
      end
c
c             gives slant depth at distance path (m) from z1
c             (kg/m**2) along cosz
c     ************
      real*8 function cpath2dep0(cosz, z1, path)
c     ************
c           cosz: input. real*8.  cos(zenith angle)  at  z1
c           z1  : input. real*8   slant depth along cosz in kg/m2
c           path: input. real*8.  length along cosz in m
c
c
c                    |/ z1(slant)
c                    /
c                   /|
c      path        /*|
c                 / cosz
c                /
c          cpath2dep0
c
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"

c
      real*8 cosz, z1, path
c
      real*8 zv, h1, pathv, h2, ztmp

      include 'cstandatmos.h'

c         convert z1 to vertical one
      zv = z1* cosz* Togpcm2
c        height at zv
      if( zv .lt. z0) then
          h1=cz2height1(zv)
      else
          h1=cz2height2(zv)
      endif
c        convert path to vertical
      pathv=path * cosz * Tocm
c        height at path end
      h2= h1 - pathv
c        depth at h2
      if( h2 .gt. hc ) then
        ztmp=ch2dep1(h2)
      else
        ztmp=ch2dep2(h2)
      endif
c        convert ztmp to slant one
      cpath2dep0 = ztmp * Tokgpm2 /cosz
      end
