c           test chang2sdep: get slant depth from height and angle.
c         for all angles and heights. 
c
c     for compilation, use: make chang2sdep

c      real*8 sdep, chang2sdep, z, cosz
c      do cosz = 0., .0650001d0, .031d0
c         do z = 10.5d3, 30.d3, 100.d0
c            sdep = chang2sdep(z, cosz)
c            write(*,*) sngl(z),  sngl(cosz), sngl(sdep)
c         enddo
c         write(*,*)
c      enddo
c      end
c     **********************************
      real*8 function chang2sdep(z, cosz)
c     **********************************
c        height and angle to slant depth conversion.
c      real*8 z.  input.  vertical height in m
c      real*8 cosz. input. cos of zenith angle at the point
c      real*8 function value.  slant depth at the point to 
c            the cosz direction.  in kg/m2.
c
      implicit none

      real*8 z, cosz

      logical first/.true./
      save first


      integer row1, col1, row2, col2
      integer maxn    ! max # of points to be used for interploation 
                      !  in x and y direction (5x5 is default)
      parameter (maxn = 5)
      parameter (row1 = 63, col1 = 15, row2 = 64, col2 =12)

      real*8 sdeptbl1(row1, col1), htbl1(row1), costbl1(col1)
      real*8 sdeptbl2(row2, col2), htbl2(row2), costbl2(col2)
      real*8 dh1, dh2,  dcos1, dcos2, cosx
      save  dh1, dh2,  dcos1, dcos2

      real*8 ans, error, caslantdep, ch2dep, zlog
      if(first) then
c            read data   (exact slant depth)/(approx one)
         call chang2sdepaux('sdepratio1.d', sdeptbl1, row1, col1, 
     *        htbl1, costbl1, dh1, dcos1)
         call chang2sdepaux('sdepratio2.d', sdeptbl2, row2, col2, 
     *        htbl2, costbl2, dh2, dcos2)
         first =.false.
      endif
      if(cosz .gt. .55) then
c              inf radius of earth.
         chang2sdep = ch2dep(z)/cosz 
         return        ! ******************
      elseif(z .lt. 11.d3) then
            cosx = cosz**0.25
            call kpolintp2(htbl1, 1, dh1, costbl1, 1, dcos1,
     *      sdeptbl1, row1, row1, col1, maxn, maxn, z, cosx, 
     *      ans, error)
      else            !   >  11 km
            cosx =sqrt(cosz)
            zlog = log10(z)
            call kpolintp2(htbl2, 1, dh2, costbl2, 1, dcos2,
     *      sdeptbl2, row2, row2, col2, maxn, maxn, zlog, cosx,
     *      ans, error)
      endif
      chang2sdep = ans * caslantdep(z, cosz)
      end
c     -----------------------------------------------------------
      subroutine chang2sdepaux(fname,  sdeptbl, maxrow, maxcol,
     *       htble, costble, dh, dcosz)
c     -----------------------------------------------------------
c           read  ratio of (exact slant delpth)/approx one
c           from specified file and set 2-dim array sdeptbl
c           with row= height 
c           and  col= cosz
c     fname: file name
c     sdeptbl(maxrow, maxcol)
c     htble(maxrow)
c     costble(maxcol)
c     dh:                step of hheight in htble
c     dcosz:             step of dcosz in costble.
c
      implicit none
#include  "Zmanager.h"
      integer maxrow, maxcol
      real*8  sdeptbl(maxrow, maxcol), dh, dcosz,
     *        htble(maxrow), costble(maxcol)
      character*(*) fname

      integer icon, i, colc, rowc, ios
      real*8 cost, heightt, sdept, coszt, coszx
      character*80 buf

         call copenf(TempDev, fname, icon)
         if(icon .ne. 0) stop 9999
         call cskipComment(TempDev, icon)
         if(icon .ne. 0) stop 9999
         i = 0
         cost = -3145.
         colc = 0
         do while (1)
            read(TempDev, '(a)', iostat=ios) buf
            if(ios .ne. 0) goto 10
            if(buf .ne. "                  ") then 
               read(buf, *) coszt, coszx,  heightt,  sdept
               i = i +1
               if(cost .ne. coszt) then    ! change of cos
                  cost = coszt
                  colc = colc + 1
                  if(colc .gt. maxcol)then
                     write(*, *) " # of cos data >", maxcol
                     stop 9999
                  endif
                  costble(colc)= coszx
                  rowc = 0
               endif   
               rowc = rowc + 1
               if(rowc .gt. maxrow) then
                  write(*, *) " # of height data >", maxrow
                  stop 9999
               endif
               sdeptbl(rowc, colc) = sdept
               htble(rowc) = heightt
            endif
         enddo
 10      continue
        dh = htble(2)-htble(1)
       dcosz =  costble(2) - costble(1)
c       write(*, *) " rowc =", rowc, " colc=", colc
  
c       write(*, *) " hstep =", dh, " cos step =", dcosz
      close(TempDev)
      end

