c#include "cblkdedx.h"
c      implicit none
c      real*8 e, dedt, ek
c      integer i
c      call cdedxEleci(225.d-6,  .true.)
c      do i=1, 300
c        ek=1.e-9*10.**( (i-1) /20.) 
c        e = ek + 0.511e-3
c        call cdedxElec(e, -1, dedt)
c        write(*, *)sngl(ek), sngl(dedt)
c      enddo
c      end
     
c     ****************************************************************
c     *                                                              *
c     * cdedxElec:  gives -de/dx  (gev/(g/cm2) of e+/e-
c     *        if knock-on process is not to be included,            *
c     *        -de/dx by sternheimer is computed else                *
c     *        -de/dx by sternheimer - (-de/dx(recoil k.e > w) )     *
c     *        is computed.                                          *
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call cdedxElec(e, ic, dedt)

c -- input--
c        e: total energy of electron in GeV
c       ic: charge. -1 if electron. 1 if positron
c
c  *** note ***
c      Before calling this, cdedxEleci must have been called.
c
c
c
      subroutine cdedxElec(eini, ic, dedt)
       implicit none
c
c
#include  "ZdedxAir.h"
c
      real*8 eini, dedt
      integer ic
c      external cblkdedx

      real*8 emass, emassg
      real*8 ek, ein, e, gi, Beta2, x, a, b, c, cb, x0, x1
      real*8 dltx, wm, wlg
c
      real*8 peake/2.3d-7/, peak/0.858d0/
      data emass/0.511d0/, emassg/0.511d-3/


c
       if(jdef .eq. 0) then
          write(*, *) ' cdedxEleci must be called'
          stop 9999
       endif

       ek=eini-emassg
       ein=eini

       if( ek .lt. peake) then
              dedt=peak*sqrt(ek/peake)
       else
c                  energy in mev unit
              e=ein*1000.d0
              gi=emass/e
              Beta2= 1.d0 - gi**2
c                  x=log10(p/mc)
              x=log10(e**2 - 0.2611d0)/2.0d0 + 0.29d0
              a=stha
              b=sthb
              c=sthc
              cb=-c
              x0=sthx0
              x1=sthx1
              if(x .lt. x0) then
c                    4.605x - dlt
                  dltx=4.605d0*x
              elseif(x .lt. x1) then
                  dltx=cb - (x1-x)**3 * sthsa
              else
                  dltx=cb
              endif
              wm=e- emass
c              if(Knckon) then
c                Now we don't use Knckon, since big wm can do
c               the equivalent
                   if(wm .gt. w0) then
                       wlg=wlg0
                   else
                       wlg=log(wm)
                   endif
c              else
c                   wlg=log(wm)
c              endif
              if(ic .eq. -1) then
                  dedt=a/Beta2 * (b + 1.12d0 + wlg-Beta2 +dltx)
              else
                  dedt=a/Beta2 *( b+0.693d0 + wlg -2*Beta2 + dltx)
              endif
c                            convert it to gev/(g/cm^2)
              dedt=dedt *1.d-3
          endif
        end
