c//c2s5001 job fritiof,class=a
c// exec fortclg
c//fort.sysin dd *
c    this is to write   x y eta pt code charge mult.
caathfritio version 1.6.   interactions between hadrons and nuclei: the
c1   lund monte carlo-fritio version 1.6.   b. nilsson-almqvist,
c2   e. stenlund.
cref. in comp. phys. commun. 43 (1987) 387
ccomp fritio-1-6,1,fritio-1-6
c           to generate 1000 tev p-air collistion. 3sec is needed
c      program fritio
c-----------------------------------------------------------------------
#include  "Zptcl.h"
#include  "Zcode.h"

      character*120 msg
      integer charge, nevent, ia, iz, icon
      integer code, pc,kin
      real*8 energy, pt, x, y, eta, pti
      logical lroots
      integer sumc
      record /ptcl/ pj, tgt, cmsptcl, sp
      logical totale, ptcl
c
      common /indataC/ elab,rots,nap,nzp,r0p,nat,nzt,r0t,iflspv,bmin,
     *                bmax,neve,iproty,ifermi,iflout
      common /evevecC/ nevent,isppp,isppn,isptp,isptn,bimp,
     *                idi(2000),ipr(2000)
      common /lujetsC/ n,k(2000,2),p(2000,5)
c$$$$$$$$$$$$$$$
      common/ludat3C/dpar(20),idb(120),cbr(400),kdp(1600)
      common/ludat1C/mst(40),par(80)
c$$$$$$$$$$$$$$$
c
c-----------------------------------------------------------------------
c     these data statements fully describe a normal run
c     consequently this is the only place where the user
c     has to make the necessary adjustements
c-----------------------------------------------------------------------
c
c     data elab,rots,neve/200.,0.,1/
c     data elab,rots,neve/1.e7,   0.,2000/
c     data nap,nzp,r0p/14,7,.68/
      data nap,nzp,r0p/1,1, 1./
c     data nat,nzt,r0t/14,7, .68/
c     data nat,nzt,r0t/1, 1, 1./
      data iflspv,bmin,bmax/0,0.,0./
      data iproty/-42/
      data ifermi/0/
c     data iflout/0/
      data iflout/-1/
c $$$$$$$$$$$$$$$$make pi0 and k0s , j/psi stable or not
c      1  g   2 z0  3 w+  4 higss0 5 g/z0  6   ?  7  e-   8 ve
c      9 mu-  10 vmu  11 tau-   12  vtau   13 x-  14  vx  15 p.s
c     16 ?  17 pi+  18 k+  19  k0   20  d0  21 d+  22 f+  23 pi0
c     24 eta  25 eta'  26 etac  27 rho+  28  k*+  29 k*0 30 d*0
c     33  rho0  34 omega(w)   35 fai  36  j/psai  37  k0s  38 k0l
c     41 p 42 n  43 sigma+ 44 sigma0  45 sigma-  46 gsai0 47 gzai-
c     57 lamda  58 lamda+  63 dlt0  64 dlt-
c          tale only charged ptcl
      idb(23)=0
      idb(37)=0
      idb(38)=0
c     idb(36)=0
c     idb(20)=0
c     idb(21)=0
c     idb(22)=0
c     idb(11)=0
c     idb(33)=0
c     idb(34)=0
c     idb(35)=0
c     idb(43)=0
c     idb(44)=0
c     idb(45)=0
c     idb(57)=0
c     idb(24)=0
c         no header write by lund
      mst(19)=0
c $$$$$$$$$$$$$$$$$$
c-----------------------------------------------------------------------
c elab is the total relativistic energy per nucleon for the projectile
c in a system where the target is at rest.
c rots is the total energy per nucleon-nucleon collision in the n-n cms.
c the output will be given in the chosen system.
c note! if rots is used elab must be set to 0. and vice versa.
c neve is the number of events in the simulation.
c nap,nzp,r0p are parameters describing the projectile.
c nat,nzt,r0t are parameters describing the target.
c iflspv=0  all interactions recorded.
c iflspv=1  only interactions where all projectile have participated are
c           recorded.
c iflspv=2  only interactions with an impact-parameter between bmin and
c           bmax are recorded.
c iflspv=3  combines the options 1 and 2
c iproty=0  for proton or nucleus projectiles
c iproty=i  for ptcle code in jetset 6.2/6.3.  negative is antiptcl
c ifermi=0  if no fermi-motion inside the nuclei
c ifermi=1  if fermi-motion inside the nuclei
c iflout=0  all particles produced in the interaction are recorded
c           together with all their decay products
c iflout=1  all directly produced particles are recorded but not
c           their decay products
c iflout=2  only stable particles recorded
c iflout=3  only charged, stable particles recorded
c iflout=-1 gives the user the freedom to chose the jetset62 options
c           when determining the particles to be recorded
c           this is done by a call to luedit after the routine
c           ingebo is executed
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c the following parameters should be used for different targets (t) and
c projectiles (p).
c-----------------------------------------------------------------------
c                                               r0 when used as target
c                                                   together with
c                    na    nz      r0             meson projectile
c     neutron         1     0    1.0    n               1.0
c     proton          1     1    1.0    p               1.0
c     deuterum        2     1     .69   d
c     helium          4     2     .81   he
c     bor            11     5     .62   b
c     carbon         12     6     .64   c                .54
c     oxygen         16     8     .72   o
c     aluminum       27    13     .86   al               .77
c     silicon        28    14     .87   si
c     argon          40    18     .94   ar
c     calcium        40    20     .94   ca
c     copper         64    29    1.01   cu               .92
c     silver        108    47    1.06   ag              1.00
c     xenon         131    54    1.08   xe
c     gold          197    79    1.12   au
c     lead          207    82    1.12   pb
c     uranium       238    92    1.13   u               1.07
c-----------------------------------------------------------------------
c$$$$$$$$ at a>=11 these can be approximated by
c         r0=-0.3664+1.196x-0.2396x**2 (x=log10(a))
c         r0=-0.4515+1.158x-0.2184x**2 (meson projectile)
c$$$$$$$$$
c-----------------------------------------------------------------------
c the following parameters should be used for projectiles only
c-----------------------------------------------------------------------
c     antiproton      1    -1    1.0    p-bar
c     pion (positive) 1     1    1.0    pi+
c     pion (negative) 1    -1    1.0    pi-
c     kaon (positive) 1     1    1.0    k+
c     kaon (negative) 1    -1    1.0    k-
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c histogramme booking and opening of neccesary files.-------------------
c the default number of the output-file is 6. the default is changed
c by setting mst(20) to the new number. mst is stored in the common-
c block ludat1 of jetset62.
c-----------------------------------------------------------------------
c
c     open(6,file='data:data',access='write',status='new')
c     cap1='ptcl code'
c     cap2='x=(e*/e*max)'
c   41:p   42:n   17:pi+  23:pi0  18:k+   38: k0l    37:k0s
c     data nat,nzt,r0t/1, 1, 1./
c     data nat,nzt,r0t/14,7, .68/
c     data elab,rots,neve/1.e7,   0.,2000/

      msg = 'hp or hAir collisions: Enter following'
      call cerrorMsg(msg, 1)
      msg = ' 1) Incident code &  Charge; 2) Target Z & A'
     * //' 3) Lab(F) or roots(T); 4) Energy(GeV); 5) # of Events'
     * //' 6) x in totale'
      call cerrorMsg(msg, 1)
      read(*, *) kin,  charge, iz, ia, lroots, energy, nevent, totale
      write(*, 
     * '( a, i3, i3, a, 2i4,a, g12.3,a,g12.3,a,i5,a,l2)')
     * '# Lund. incident code & charge=',kin,
     *     charge, 
     * ' target Z, A=',iz, ia, ' root s=',lroots, 
     * ' E=',energy, ' events=', nevent, ' x in totalE(t/f)', totale 
      write(*,'(a)' )
     * '#  "x" "y" "eta" "pt" "code" "charge" "mul"  "1/pt"'
      msg=' is it particle (t) or anti particle(f)?'
      call cerrorMsg(msg, 1)
      read(*,*) ptcl
      if(ptcl) then
         call cmkptc(kin, regptcl, charge, pj)
      else
         call cmkptc(kin, antip, charge, pj)
      endif
      if(lroots) then
         energy = energy**2/2/pj.mass - pj.mass
      endif
      elab = energy
      pj.fm.px = 0.
      pj.fm.py = 0.
      pj.fm.e = energy
      pj.fm.pz = sqrt(pj.fm.e**2 - pj.mass**2)
c
      rots=0.
      if(kin .eq. knuc) then
         if(charge .eq. 1) then
            iproty=41
         elseif( charge .eq. 0) then
            iproty=42
         elseif(charge .eq. -1) then
            iproty = -41
         else
            call cerrorMsg('incident charge error', 0)
         endif
      elseif(kin .eq. kpion) then
         if(charge .eq. 1) then
            iproty = 17
         elseif(charge .eq. -1) then
            iproty = -17
         else
            call cerrorMsg('incident charge error', 0)
         endif
      endif             
      nat=ia
      nzt=iz
      if(ia .eq. 14) then
         if(kin .ne. knuc) then
            r0t=.588
         else
            r0t=.689
         endif
      elseif(ia .eq. 16) then
c                oxigen
         if(kin .ne. knuc) then
            r0t=.658
         else
            r0t=.72
         endif
      elseif(ia .eq. 1)then
c               nucleon (comes here if used in our model)
         r0t=1.
      elseif(ia .eq. 40) then
c               argon
         if(kin .ne. knuc) then
            r0t=.843
         else
            r0t=.94
         endif
      elseif(ia .ge. 11) then
         x=log10(float(ia))
         if(kin .eq. knuc) then
            r0t=-0.3664+1.196*x-0.2396*x**2
         else
            r0t=-0.4515+1.158*x-0.2184*x**2
         endif
      elseif(ia .eq. 4) then
         if(kin .eq. knuc) then
            r0t=.81
         else
            r0t=.65
         endif
      elseif(ia .ge. 5) then
         r0t = (5-ia)*0.04   + .8
      else
         write(msg,*) ' target mass=',ia, ' for cfritiof invalid'
         call cerrorMsg(msg, 0)
      endif

c             make proton target 
      call cmkptc(knuc, 0, 1, tgt)
      tgt.fm.px = 0.
      tgt.fm.py = 0.
      tgt.fm.pz = 0.
      tgt.fm.e = tgt.mass
c          fomr cms
      call cgeqm(pj, tgt, cmsptcl, icon)
c
      do   i=1, nevent
 5       continue
         sumc = 0
             call ingeboC
             call lueditC(1)
c-----------------------------------------------------------------------
c ingebo creates an event and fills the commonblocks evevec and lujetsaa
c-----------------------------------------------------------------------
c evevec : nevent => event number (consecutive numbering)
c          isppp  => number of non-interacting protons associated with
c                    the projectile
c          isppn  => number of non-interacting neutrons associated with
c                    the projectile
c          isptp  => number of non-interacting protons associated with
c                    the target
c          isptn  => number of non-interacting neutrons associated with
c                    the target
c          bimp   => impact parameter given in fermi
c          idi    => =1 if a diffractively produced particle
c                    =0 otherwise
c          ipr    => =1 if the produced particle comes from a
c                       projectile string.
c                    =0 if it comes from a target string.
c          note!     the validity of idi and ipr are not kept if calls
c                    to luedit are made
c
c-----------------------------------------------------------------------
c lujets : n      => number of entries in the lujets arrays
c          p      => array containing the three momentum components
c                    (x, y and z, where z is the component along the
c                    beam-axis), total relativistic energy, and the
c                    invariant mass of the particle
c          k      => k(j,1) contains the history of the j:th particle
c                    k(j,2) contains the kf flavour code of the j:th
c                    particle
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c histogramme filling---------------------------------------------------
c-----------------------------------------------------------------------
c
c        call ellida
c        write(*,*) ' -------- n=',n
         do   l=1, n

            kkk=k(l,2)
            if(kkk .eq. 17) then
               code = kpion
               pc = 1
            elseif(kkk .eq. -17) then
               code = kpion
               pc = -1
            elseif(kkk .eq. 23) then
               code = kpion
               pc = 0
            elseif(kkk .eq. 18) then
               code = kkaon
               pc = 1
            elseif(kkk .eq. -18) then
               code = kkaon
               pc = -1
            elseif(abs(kkk) .eq. 41) then
               code = knuc
               pc = sign(1, kkk)
            elseif(abs(kkk) .eq. 42) then
               code = knuc
               pc =0
            elseif(abs(kkk) .eq. 37 .or. abs(kkk) .eq. 38) then
               code = kkaon
               pc = 0
            elseif(kkk .eq. 1) then
c               goto 5
               code = kphoton
               pc = 0
            elseif(kkk .eq. -1) then
c               goto 5
               code = -1
               pc = 0
            else
               jj=10
c               write(*,*) ' ptcl=',k(l,2)
c               goto 10
            endif

            sumc = sumc + pc

            sp.fm.px = p(l,1)
            sp.fm.py = p(l,2)
            sp.fm.pz = p(l,3)
            sp.fm.e = p(l,4)
            sp.mass = p(l,5)
            pt= sqrt(sp.fm.px**2+ sp.fm.py**2)
            pti = 1./pt
            if(totale) then
               x = sp.fm.e / pj.fm.e
            else
               x = (sp.fm.e- sp.mass)/ (pj.fm.e-pj.mass)
            endif

            call cbst1(l, cmsptcl, sp, sp)
            call cyeta(sp, y, eta)
c            write(*, '(f10.6, 2i3)') sngl(x), code, pc
            write(*, '(4g13.3,i3,i3,i5,g12.3,i4)')
     *           sngl(x), sngl(y), sngl(eta),
     *           sngl(pt), code, pc,  n, sngl(pti), sumc
 10         continue
         enddo
         write(*, *)
c-----------------------------------------------------------------------
c ellida lists the event. the first time it is called it also gives-----
c some general information about the run. the use of ellida is optional.
c-----------------------------------------------------------------------
c
          enddo
c     write(14)1.e50, 1.e50, 1.e50, 1.e50, 1.e50
c     write(13)1.e50, 1.e50, 1.e50, 1.e50, 1.e50
c     elab=elab*10.
c1000 continue
c
c-----------------------------------------------------------------------
c histogramme display---------------------------------------------------
c and closing of opened files-------------------------------------------
c-----------------------------------------------------------------------
c
      end
