/* aath.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "/usr/local/include/f2c.h"

/* Common Block Declarations */

struct {
    real elab, rots;
    integer nap, nzp;
    real r0p;
    integer nat, nzt;
    real r0t;
    integer iflspv;
    real bmin, bmax;
    integer neve, iproty, ifermi, iflout;
} indata_;

#define indata_1 indata_

struct evevec_1_ {
    integer nevent, isppp, isppn, isptp, isptn;
    real bimp;
    integer idi[2000], ipr[2000];
};

#define evevec_1 (*(struct evevec_1_ *) &evevec_)

struct {
    integer n, k[4000]	/* was [2000][2] */;
    real p[10000]	/* was [2000][5] */;
} lujets_;

#define lujets_1 lujets_

struct {
    integer mst[40];
    real par[80];
} ludat1_;

#define ludat1_1 ludat1_

struct {
    real win[40], wta[200];
} frstma_;

#define frstma_1 frstma_

struct {
    integer idp[40], idt[250];
} frstty_;

#define frstty_1 frstty_

union {
    struct {
	real bipa;
	integer nwp, nwt, ny, ni[500], nt[500];
    } _1;
    struct {
	real bipa;
	integer nwp, nwt, ny, nucp[500], nuct[500];
    } _2;
    struct {
	real bipa;
	integer ninkol, ntakol, nkoll, ni[500], nt[500];
    } _3;
} frnynu_;

#define frnynu_1 (frnynu_._1)
#define frnynu_2 (frnynu_._2)
#define frnynu_3 (frnynu_._3)

struct {
    real pxsp[40], pysp[40], pxst[200], pyst[200];
} frstpt_;

#define frstpt_1 frstpt_

struct {
    real ppin[40], pmin[40], ppta[200], pmta[200];
} frstpm_;

#define frstpm_1 frstpm_

/* Initialized data */

struct {
    integer e_1;
    integer fill_2[4005];
    real e_3;
    } evevec_ = { 0, {0}, (float)0. };


/* Table of constant values */

static integer c__1 = 1;
static real c_b8 = (float)0.;
static integer c__0 = 0;
static integer c__3 = 3;
static integer c__2 = 2;
static integer c__13 = 13;
static integer c__9 = 9;
static doublereal c_b89 = .3333333333333333;
static integer c__11 = 11;

/* the user is advised to store the following subroutines on a separate */
/* file in order to avoid unnecessary long compilation times */
/* $$$$$$$$$$$$$$$$$$$$$$$ */
/*       input parameter usage changed: */
/*             iproty=0 for nucleus is unchanded */
/*             iproty>0 is particle code listed in jetset6.2/6.3 */
/*             iproty<0 is antiptcl                // */
/* $$$$$$$$$$$$$$$$$$$$$$$ */
/* *********************************************************************** */
/* Subroutine */ int ingebo_()
{

    /* System generated locals */
    integer i__1, i__2;
    real r__1;

    /* Builtin functions */
    double atan2(), sin(), cos(), atan();

    /* Local variables */
    extern /* Subroutine */ int bele_();
    static integer ifla, iflb;
    extern /* Subroutine */ int ring_();
    static integer iori, nsav;
    static real vink, thet3;
    static integer i, j;
    static real betax, betay, beinx, beiny;
    static integer jcopp, jcotp;
    static real x1, x2, x3;
    extern /* Subroutine */ int lu2jet_(), lu3jet_();
    static real th, embeta;
    static integer kt;
    static real embein, epbeta;
    extern /* Subroutine */ int hildin_(), angant_();
    static integer lastje;
    extern /* Subroutine */ int luexec_(), luedit_();
    static integer nlines;
    extern /* Subroutine */ int angurv_(), lurobo_(), lurota_(), luroin_(), 
	    torste_();
    static real thp, psi, tht;
    extern doublereal plu_(), rlu_();

/* -----------------------------------------------------------------------
 */
/* -----administrates one event-------------------------------------------
 */
/* -----------------------------------------------------------------------
 */
/* -----setting vectors to zero-------------------------------------------
 */
/* $$$$$$$$$ need not be cleared */
/* $$   do 1 i=1,2000 */
/* $$     ipr(i)=0 */
/* $$ 1 continue */
    for (i = 1; i <= 40; ++i) {
	frstpt_1.pxsp[i - 1] = (float)0.;
	frstpt_1.pysp[i - 1] = (float)0.;
/* L5: */
    }
    for (i = 1; i <= 200; ++i) {
	frstpt_1.pxst[i - 1] = (float)0.;
	frstpt_1.pyst[i - 1] = (float)0.;
/* L6: */
    }
    lujets_1.n = 0;
    ludat1_1.mst[11] = 0;
    ludat1_1.mst[22] = 0;
    if (indata_1.iflout == 1) {
	ludat1_1.mst[6] = 0;
    }
/* $    if(iflw.eq.0) then */
/* $    write(mst(20),770) 'the lund monte carlo - fritio version 1.6' */
/* $    write(mst(20),771) 'last date of change : 10 june  1986' */
/* $    iflw=1 */
/* $770 format(' ',19x,a) */
/* $771 format(' ',22x,a) */
/* $    endif */
/* -----hildin for identification of the participating nucleons----------a
 */
    hildin_();
/* -----angant for creation of the nuclei and the subsequent nucleon----aa
 */
/* -----collisions--------------------------------------------------------
 */
    angant_();
/* -----ring for giving the excited nucleons masses-----------------------
 */
    ring_();
/* -----updating of the event number, recording of impact parameter and---
 */
/* -----counting of spectators--------------------------------------------
 */
    ++evevec_1.nevent;
    evevec_1.bimp = frnynu_1.bipa;
    jcopp = 0;
    i__1 = frnynu_1.nwp;
    for (i = 1; i <= i__1; ++i) {
	if (frstty_1.idp[i - 1] == 41) {
	    ++jcopp;
	}
/* L3: */
    }
    jcotp = 0;
    i__1 = frnynu_1.nwt;
    for (i = 1; i <= i__1; ++i) {
	if (frstty_1.idt[i - 1] == 41) {
	    ++jcotp;
	}
/* L4: */
    }
    evevec_1.isppp = indata_1.nzp - jcopp;
    evevec_1.isppn = indata_1.nap - frnynu_1.nwp - evevec_1.isppp;
    evevec_1.isptp = indata_1.nzt - jcotp;
    evevec_1.isptn = indata_1.nat - frnynu_1.nwt - evevec_1.isptp;
    if (indata_1.iproty != 0 || indata_1.nzp <= -1) {
	evevec_1.isppp = 0;
	evevec_1.isppn = 0;
    }
/* -----------------------------------------------------------------------
 */
/* -----projectile loop. bele:quarkflavours in string ends.---------------
 */
/* ----------------------torste:pt for the gluon & way of fragmentation--a
 */
    i__1 = frnynu_1.nwp;
    for (j = 1; j <= i__1; ++j) {
	bele_(&ifla, &iflb, &frstty_1.idp[j - 1]);
	torste_(&frstma_1.win[j - 1], &frstty_1.idp[j - 1], &iflb, &ifla, &x1,
		 &x3, &kt);
	nsav = lujets_1.n;
	if (kt == 1) {
	    angurv_(&c__1, &j);
	    goto L100;
	} else if (kt == 2) {
	    i__2 = nsav + 1;
	    lu2jet_(&i__2, &iflb, &ifla, &frstma_1.win[j - 1]);
	    luexec_();
	    ludat1_1.mst[0] = nsav + 1;
	} else if (kt == 3) {
	    i__2 = nsav + 1;
	    lu3jet_(&i__2, &iflb, &ifla, &frstma_1.win[j - 1], &x1, &x3);
	    luexec_();
	    ludat1_1.mst[0] = nsav + 1;
/* -------pt-----------------------------------------------------
--------- */
/* -------orientation of the threejet event----------------------
--------- */
	    x2 = (float)2. - x1 - x3;
/* -------quarkjet axis minimizing pt ---------------------------
--------- */
	    th = atan2(lujets_1.p[nsav + 2], lujets_1.p[nsav + 4002]);
	    thp = (float)3.1416 - th;
	    psi = atan(x3 * x3 * sin(thp * 2) / (x1 * x1 + x3 * x3 * cos(thp *
		     2))) * (float).5;
	    lurobo_(&psi, &c_b8, &c_b8, &c_b8, &c_b8);
/* --------------------------------------------------------------
--------- */
	    vink = rlu_(&c__0) * (float)6.28317999999999977;
	    lurobo_(&c_b8, &vink, &c_b8, &c_b8, &c_b8);
	}
/* ------------------------------------------------------------------
----- */
/* -----boost to lab and pt for the whole string system -------------
----- */
	beinx = frstpt_1.pxsp[j - 1] * (float)2. / (frstpm_1.ppin[j - 1] + 
		frstpm_1.pmin[j - 1]);
	beiny = frstpt_1.pysp[j - 1] * (float)2. / (frstpm_1.ppin[j - 1] + 
		frstpm_1.pmin[j - 1]);
	embein = frstpm_1.pmin[j - 1] * (float)2. / (frstpm_1.ppin[j - 1] + 
		frstpm_1.pmin[j - 1]);
	luroin_(&c_b8, &c_b8, &beinx, &beiny, &embein);
	if (indata_1.iflout == 3) {
	    luedit_(&c__3);
	} else if (indata_1.iflout == 2) {
	    luedit_(&c__2);
	}
/* -----produced particles in fragmentation--------------------------
----- */
	i__2 = lujets_1.n;
	for (i = nsav + 1; i <= i__2; ++i) {
	    evevec_1.ipr[i - 1] = 1;
	    evevec_1.idi[i - 1] = 0;
/* L110: */
	}
	ludat1_1.mst[0] = 0;
L100:
	;
    }
/* -----------------------------------------------------------------------
 */
/* -----target loop  bele: quarkflavours in string ends-------------------
 */
/* ------------------torste: pt for the gluon & way of fragmentation-----a
 */
    i__1 = frnynu_1.nwt;
    for (j = 1; j <= i__1; ++j) {
	bele_(&ifla, &iflb, &frstty_1.idt[j - 1]);
	torste_(&frstma_1.wta[j - 1], &frstty_1.idt[j - 1], &ifla, &iflb, &x1,
		 &x3, &kt);
	nsav = lujets_1.n;
	if (kt == 1) {
	    angurv_(&c__2, &j);
	    goto L200;
	} else if (kt == 2) {
	    i__2 = nsav + 1;
	    lu2jet_(&i__2, &ifla, &iflb, &frstma_1.wta[j - 1]);
	    luexec_();
	    ludat1_1.mst[0] = nsav + 1;
	} else if (kt == 3) {
	    i__2 = nsav + 1;
	    lu3jet_(&i__2, &ifla, &iflb, &frstma_1.wta[j - 1], &x1, &x3);
	    luexec_();
	    ludat1_1.mst[0] = nsav + 1;
	    i__2 = nsav + 3;
	    thet3 = (float)3.1416 - plu_(&i__2, &c__13);
	    lurobo_(&thet3, &c_b8, &c_b8, &c_b8, &c_b8);
/* -------pt global----------------------------------------------
--------- */
/* -------orientation of the threejet event ---------------------
--------- */
	    x2 = (float)2. - x1 - x3;
/* -------quarkjet axis minimizing pt ---------------------------
--------- */
	    th = (r__1 = atan2(lujets_1.p[nsav], lujets_1.p[nsav + 4000]), 
		    dabs(r__1));
	    tht = th;
	    psi = atan(x1 * x1 * sin(tht * 2) / (x3 * x3 + x1 * x1 * cos(tht *
		     2))) * (float).5;
	    r__1 = -(doublereal)psi;
	    lurobo_(&r__1, &c_b8, &c_b8, &c_b8, &c_b8);
/* --------------------------------------------------------------
--------- */
	    vink = rlu_(&c__0) * (float)6.28317999999999977;
	    lurobo_(&c_b8, &vink, &c_b8, &c_b8, &c_b8);
	}
/* ------------------------------------------------------------------
----- */
/* -----boost to lab and pt for the whole string system -------------
----- */
	betax = frstpt_1.pxst[j - 1] * (float)2. / (frstpm_1.ppta[j - 1] + 
		frstpm_1.pmta[j - 1]);
	betay = frstpt_1.pyst[j - 1] * (float)2. / (frstpm_1.ppta[j - 1] + 
		frstpm_1.pmta[j - 1]);
	epbeta = frstpm_1.ppta[j - 1] * (float)2. / (frstpm_1.ppta[j - 1] + 
		frstpm_1.pmta[j - 1]);
	embeta = frstpm_1.pmta[j - 1] * (float)2. / (frstpm_1.ppta[j - 1] + 
		frstpm_1.pmta[j - 1]);
	if (indata_1.rots != (float)0.) {
	    lurota_(&c_b8, &c_b8, &betax, &betay, &epbeta);
	} else {
	    luroin_(&c_b8, &c_b8, &betax, &betay, &embeta);
	}
	if (indata_1.iflout == 3) {
	    luedit_(&c__3);
	} else if (indata_1.iflout == 2) {
	    luedit_(&c__2);
	}
/* -----produced particles in fragmentation--------------------------
----- */
	i__2 = lujets_1.n;
	for (i = nsav + 1; i <= i__2; ++i) {
	    evevec_1.ipr[i - 1] = 0;
	    evevec_1.idi[i - 1] = 0;
/* L210: */
	}
	ludat1_1.mst[0] = 0;
L200:
	;
    }
/* -----preparing the event as determined by the iflout setting-----------
 */
    if (indata_1.iflout == 1 || indata_1.iflout == 0) {
	nlines = 0;
	lastje = 0;
	i__1 = lujets_1.n;
	for (i = 1; i <= i__1; ++i) {
	    if ((i__2 = lujets_1.k[i + 1999], abs(i__2)) >= 500) {
		lastje = i;
	    } else {
		++nlines;
		for (j = 1; j <= 5; ++j) {
		    lujets_1.p[nlines + j * 2000 - 2001] = lujets_1.p[i + j * 
			    2000 - 2001];
/* L112: */
		}
		iori = lujets_1.k[i - 1] % 10000;
		if (iori <= lastje) {
		    iori = 0;
		} else {
		    iori = nlines + iori - i;
		}
		lujets_1.k[nlines - 1] = lujets_1.k[i - 1] / 10000 * 10000 + 
			iori;
		lujets_1.k[nlines + 1999] = lujets_1.k[i + 1999];
		evevec_1.idi[nlines - 1] = evevec_1.idi[i - 1];
		evevec_1.ipr[nlines - 1] = evevec_1.ipr[i - 1];
	    }
/* L111: */
	}
	lujets_1.n = nlines;
    }
    return 0;
} /* ingebo_ */

/* Subroutine */ int angurv_(l, j)
integer *l, *j;
{
    static integer kkod, nsav;
    static real e, px, py, pz;
    extern doublereal ulmass_();

/* -----------------------------------------------------------------------
 */
/*     taking care of diffractive nucleons(and diff pions,kaons) */
/* -----------------------------------------------------------------------
 */
/*        $$$$$$$$$$$$$$$$$$$$$$$$$$$$$ */
/*        in original version /indata/ is missing and iflout becomes */
/*        undefined. to avoid that, the next 2 lines inserted. */
/*        $$$$$$$$$$$$$$$$$$$$$$$$$$$$$ */
    nsav = lujets_1.n;
/* -----projectile--------------------------------------------------------
 */
    if (*l == 1) {
	e = (frstpm_1.ppin[*j - 1] + frstpm_1.pmin[*j - 1]) / (float)2.;
	pz = (frstpm_1.ppin[*j - 1] - frstpm_1.pmin[*j - 1]) / (float)2.;
	px = frstpt_1.pxsp[*j - 1];
	py = frstpt_1.pysp[*j - 1];
	kkod = frstty_1.idp[*j - 1];
/* -----target-------------------------------------------------------
----- */
    } else if (*l == 2) {
	e = (frstpm_1.ppta[*j - 1] + frstpm_1.pmta[*j - 1]) / (float)2.;
	pz = (frstpm_1.ppta[*j - 1] - frstpm_1.pmta[*j - 1]) / (float)2.;
	px = frstpt_1.pxst[*j - 1];
	py = frstpt_1.pyst[*j - 1];
	kkod = frstty_1.idt[*j - 1];
    }
/* -----------------------------------------------------------------------
 */
    ++lujets_1.n;
    if (*l == 1) {
	evevec_1.ipr[lujets_1.n - 1] = 1;
    }
    if (*l == 2) {
	evevec_1.ipr[lujets_1.n - 1] = 0;
    }
    evevec_1.idi[lujets_1.n - 1] = 1;
    lujets_1.k[lujets_1.n - 1] = 0;
    lujets_1.k[lujets_1.n + 1999] = kkod;
    lujets_1.p[lujets_1.n - 1] = px;
    lujets_1.p[lujets_1.n + 1999] = py;
    lujets_1.p[lujets_1.n + 3999] = pz;
    lujets_1.p[lujets_1.n + 5999] = e;
    lujets_1.p[lujets_1.n + 7999] = ulmass_(&c__0, &kkod);
    if (indata_1.iflout == 3 && kkod == 42) {
	--lujets_1.n;
    }
    return 0;
} /* angurv_ */

/* Subroutine */ int bele_(ifla, iflb, j)
integer *ifla, *iflb, *j;
{
    static real spin, u;
    extern doublereal rlu_();

/* -----------------------------------------------------------------------
 */
/*     giving spin and quarkflavour to the leading particles */
/* -----------------------------------------------------------------------
 */
    spin = rlu_(&c__0);
/*        pi */
    if (*j == 17) {
	if (spin < (float).5) {
	    *ifla = 1;
	    *iflb = -2;
	} else {
	    *ifla = -2;
	    *iflb = 1;
	}
    } else if (*j == -17) {
	if (spin < (float).5) {
	    *ifla = -1;
	    *iflb = 2;
	} else {
	    *ifla = 2;
	    *iflb = -1;
	}
/*         k */
    } else if (*j == 18) {
	if (spin < (float).5) {
	    *ifla = 1;
	    *iflb = -3;
	} else {
	    *ifla = -3;
	    *iflb = 1;
	}
    } else if (*j == -18) {
	if (spin < (float).5) {
	    *ifla = -1;
	    *iflb = 3;
	} else {
	    *ifla = 3;
	    *iflb = -1;
	}
    } else if (*j == 19 || *j == 37 || *j == 38) {
/*          k0 */
	if (spin <= (float).5) {
	    *ifla = 2;
	    *iflb = -3;
	} else {
	    *ifla = -3;
	    *iflb = 2;
	}
    } else if (*j == -19 || *j == -37 || *j == -38) {
/*          k0_bar */
	if (spin <= (float).5) {
	    *ifla = -2;
	    *iflb = 3;
	} else {
	    *ifla = 3;
	    *iflb = -2;
	}
    } else if (*j == 41) {
/*          p */
	if (spin < (float).167) {
	    *ifla = 1;
	    *iflb = 21;
	} else if (spin < (float).5) {
	    *ifla = 2;
	    *iflb = 11;
	} else {
	    *ifla = 1;
	    *iflb = 12;
	}
    } else if (*j == 42) {
/*          n */
	if (spin < (float).167) {
	    *ifla = 2;
	    *iflb = 21;
	} else if (spin < (float).5) {
	    *ifla = 1;
	    *iflb = 22;
	} else {
	    *ifla = 2;
	    *iflb = 12;
	}
    } else if (*j == -41) {
/*           p_bar */
	if (spin < (float).167) {
	    *ifla = -1;
	    *iflb = -21;
	} else if (spin < (float).5) {
	    *ifla = -2;
	    *iflb = -11;
	} else {
	    *ifla = -1;
	    *iflb = -12;
	}
    } else if (*j == -42) {
/*          n_bar */
	if (spin < (float).167) {
	    *ifla = -2;
	    *iflb = -21;
	} else if (spin < (float).5) {
	    *ifla = -1;
	    *iflb = -22;
	} else {
	    *ifla = -2;
	    *iflb = -12;
	}
    } else if (abs(*j) == 57 || *j >= 43 && *j <= 45) {
/*            lamda; sigma is treated as if lambda */
	if (spin < (float).167) {
	    *ifla = 1;
	    *iflb = 23;
	} else if (spin <= (float).333) {
	    *ifla = 1;
	    *iflb = 32;
	} else if (spin <= (float).5) {
	    *ifla = 2;
	    *iflb = 13;
	} else if (spin <= (float).667) {
	    *ifla = 2;
	    *iflb = 31;
	} else if (spin <= (float).833) {
	    *ifla = 3;
	    *iflb = 21;
	} else {
	    *ifla = 3;
	    *iflb = 12;
	}
    } else if (abs(*j) == 23 || abs(*j) >= 33 && abs(*j) <= 35) {
/*          pi0 and rho 0/ omega ,fai */
	u = rlu_(&c__0);
	if (u < (float).5) {
/*             uu_bar */
	    if (spin < (float).5) {
		*ifla = 1;
		*iflb = -1;
	    } else {
		*ifla = -1;
		*iflb = 1;
	    }
	} else {
/*             d d_bar */
	    if (spin < (float).5) {
		*ifla = 2;
		*iflb = -2;
	    } else {
		*ifla = -2;
		*iflb = 2;
	    }
	}
    }
    return 0;
} /* bele_ */

/* Subroutine */ int torste_(w, id, izpl, izmi, x1, x3, kt)
real *w;
integer *id, *izpl, *izmi;
real *x1, *x3;
integer *kt;
{
    /* Initialized data */

    static real alit = (float)6.;

    /* System generated locals */
    real r__1, r__2;
    doublereal d__1, d__2;

    /* Builtin functions */
    integer s_wsle(), do_lio(), e_wsle();
    /* Subroutine */ int s_stop();
    double pow_dd(), sqrt(), log(), exp();

    /* Local variables */
    static real fakt, pete, pete2;
    static integer idabs, iflag;
    static real y, x2, framin, pa1, pa2, pa3, zmmass, zpmass;
    extern doublereal rlu_();
    static real slu, arg1, arg2;

    /* Fortran I/O blocks */
    static cilist io___40 = { 0, 6, 0, 0, 0 };


/* -----------------------------------------------------------------------
 */
/*      twojet, threejet or diffractive nucleon. if threejet the routine 
*/
/*      gives pt to the gluon */
/* -----------------------------------------------------------------------
 */
/* $$$$$$$$$$$$$$$$$$$$$$ */
    idabs = abs(*id);
    if (idabs == 17 || idabs == 23) {
/*           pi */
	framin = (float).8;
    } else if (idabs == 41 || idabs == 42) {
/*           n,p */
	framin = (float)1.2;
    } else if (idabs == 18) {
/*           k+- */
	framin = (float)1.;
    } else if (idabs == 19 || idabs == 37 || idabs == 38) {
/*           k 0 */
	framin = (float)1.;
    } else if (idabs == 57) {
/*             lambda */
	framin = (float)1e37;
    } else if (idabs >= 43 && idabs <= 46) {
/*            sigma */
	framin = (float)1e37;
    } else if (idabs == 33 || idabs == 34) {
/*             rho,omega */
	framin = (float)1e37;
    } else if (idabs == 35) {
/*            fai */
	framin = (float)1e37;
    } else {
	s_wsle(&io___40);
	do_lio(&c__9, &c__1, " ptcl id=", 9L);
	do_lio(&c__3, &c__1, (char *)&(*id), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " not supported in torste", 24L);
	e_wsle();
	s_stop("", 0L);
    }
/*     if(abs(id).eq.17) framin=0.8 */
/*     if(abs(id).eq.18) framin=1.0 */
/*     if(abs(id).eq.41.or.abs(id).eq.42) framin=1.2 */
    if (*w <= framin - (float).001) {
	*kt = 1;
    } else {
	slu = rlu_(&c__0);
/* $$$$$$$$$$$$$$$$ originally pete=sqrt( .... ) is defined and used 
*/
/* Computing 2nd power */
	r__1 = *w;
	d__1 = (doublereal) (r__1 * r__1 / (alit * (float)16.) + (float)1.);
	d__2 = (doublereal) slu;
	pete2 = alit * (pow_dd(&d__1, &d__2) - (float)1.);
	if (pete2 < (float).25) {
	    *kt = 2;
	} else {
	    pete = sqrt(pete2);
	    *kt = 3;
	    iflag = 0;
	    fakt = rlu_(&c__0);
/* Computing 2nd power */
	    r__1 = *w;
	    y = (fakt - (float).5) * (float)2. * log(*w / (pete * (float)2.) 
		    + sqrt(r__1 * r__1 / (pete2 * (float)4.) - (float)1.));
/* $$$$$$$ */
	    *x1 = (float)1. - pete / *w * exp(y);
	    *x3 = (float)1. - pete / *w * exp(-(doublereal)y);
	    x2 = (float)2. - *x1 - *x3;
/*                               u,d */
	    if (abs(*izpl) <= 2) {
		zpmass = (float).325;
	    }
/*                               s */
	    if (abs(*izpl) == 3) {
		zpmass = (float).5;
	    }
/*                               c */
	    if (abs(*izpl) == 4) {
		zpmass = (float)1.6;
	    }
/*                               uu1 etc */
	    if (abs(*izpl) > 10) {
		zpmass = (float).65;
	    }
	    if (abs(*izmi) <= 2) {
		zmmass = (float).325;
	    }
	    if (abs(*izmi) == 3) {
		zmmass = (float).5;
	    }
	    if (abs(*izmi) > 10) {
		zmmass = (float).65;
	    }
/* ---------kinematical tests------------------------------------
--------- */
/* Computing 2nd power */
	    r__1 = *x1 * (float).5 * *w;
/* Computing 2nd power */
	    r__2 = zpmass;
	    pa1 = r__1 * r__1 - r__2 * r__2;
/* Computing 2nd power */
	    r__1 = *x3 * (float).5 * *w;
/* Computing 2nd power */
	    r__2 = zmmass;
	    pa3 = r__1 * r__1 - r__2 * r__2;
	    pa2 = ((float)2. - *x1 - *x3) * (float).5 * *w;
	    if (pa1 < (float)0. || pa3 < (float)0.) {
		iflag = 1;
		goto L13;
	    }
/* Computing 2nd power */
	    r__1 = pa2;
	    arg1 = (pa3 - pa1 - r__1 * r__1) / (sqrt(pa1) * (float)2. * pa2);
/* Computing 2nd power */
	    r__1 = pa2;
	    arg2 = (r__1 * r__1 - pa1 - pa3) / (sqrt(pa1 * pa3) * (float)2.);
	    if (dabs(arg1) > (float)1. || dabs(arg2) > (float)1.) {
		iflag = 1;
	    }
L13:
	    if (iflag == 1) {
		*kt = 2;
	    }
	}
    }
    return 0;
} /* torste_ */

/* Subroutine */ int ring_()
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(), pow_dd();

    /* Local variables */
    static integer kfel;
    static real eloc, esen, ploc, ptsq1;
    static integer i;
    static real ptsq2;
    extern /* Subroutine */ int helge_();
    static real delpm, delpp;
    static integer nyrak;
    static doublereal dptsq;
    static real bosfac;
    extern /* Subroutine */ int halvda_();
    static real widmin;
    static doublereal dmassq;
    static real pmicms, ppicms, wtamin, plongp, winmin, wtdmin, plongt, 
	    pptcms, pmtcms, pmtany, pminny, pptany, ppinny, ppstox, ppstoy, 
	    ptstox, ptstoy;
    static logical lab, cms;
    static real fmp[40], pmi, fmt[200], ppi, pmt;
    extern doublereal rlu_();
    static real ppt;

/* -----------------------------------------------------------------------
 */
/*     the routine gives masses to the excited nucleons */
/* -----------------------------------------------------------------------
 */
/* -----------------------------------------------------------------------
 */
L31:
    if (indata_1.elab == (float)0.) {
	cms = TRUE_;
	lab = FALSE_;
    } else if (indata_1.rots == (float)0.) {
	cms = FALSE_;
	lab = TRUE_;
    }
/* -----------------------------------------------------------------------
 */
    i__1 = frnynu_1.nwt;
    for (i = 1; i <= i__1; ++i) {
	if (frstty_1.idt[i - 1] == 41) {
	    fmt[i - 1] = (float).93828;
	} else {
	    fmt[i - 1] = (float).93957;
	}
/* L6: */
    }
    wtamin = (float)1.2;
    wtdmin = (float).94;
    if (abs(frstty_1.idp[0]) == 17) {
	fmp[0] = (float).14;
	winmin = (float)1.;
	widmin = (float).75;
    } else if (abs(frstty_1.idp[0]) == 18) {
	fmp[0] = (float).495;
	winmin = (float)1.1;
	widmin = (float).85;
    } else {
	i__1 = frnynu_1.nwp;
	for (i = 1; i <= i__1; ++i) {
	    if ((i__2 = frstty_1.idp[i - 1], abs(i__2)) == 41) {
		fmp[i - 1] = (float).93828;
	    } else {
		fmp[i - 1] = (float).93957;
	    }
/* L5: */
	}
	winmin = (float)1.2;
	widmin = (float).94;
    }
    if (cms) {
	i__1 = frnynu_1.nwp;
	for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	    r__1 = fmp[i - 1] * fmp[i - 1] - fmt[0] * fmt[0];
	    plongp = indata_1.rots * indata_1.rots / 4 - (fmp[i - 1] * fmp[i 
		    - 1] + fmt[0] * fmt[0]) / 2 + r__1 * r__1 / (
		    indata_1.rots * 4 * indata_1.rots);
	    esen = sqrt(plongp + fmp[i - 1] * fmp[i - 1]);
	    frstpm_1.ppin[i - 1] = esen + sqrt(plongp);
	    frstpm_1.pmin[i - 1] = fmp[i - 1] * fmp[i - 1] / frstpm_1.ppin[i 
		    - 1];
/* L10: */
	}
	i__1 = frnynu_1.nwt;
	for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	    r__1 = fmp[0] * fmp[0] - fmt[i - 1] * fmt[i - 1];
	    plongt = indata_1.rots * indata_1.rots / 4 - (fmp[0] * fmp[0] + 
		    fmt[i - 1] * fmt[i - 1]) / 2 + r__1 * r__1 / (
		    indata_1.rots * 4 * indata_1.rots);
	    esen = sqrt(plongt + fmt[i - 1] * fmt[i - 1]);
	    frstpm_1.pmta[i - 1] = esen + sqrt(plongt);
	    frstpm_1.ppta[i - 1] = fmt[i - 1] * fmt[i - 1] / frstpm_1.pmta[i 
		    - 1];
/* L20: */
	}
    } else if (lab) {
	i__1 = frnynu_1.nwp;
	for (i = 1; i <= i__1; ++i) {
	    frstpm_1.ppin[i - 1] = indata_1.elab + sqrt(indata_1.elab * 
		    indata_1.elab - fmp[i - 1] * fmp[i - 1]);
	    frstpm_1.pmin[i - 1] = fmp[i - 1] * fmp[i - 1] / frstpm_1.ppin[i 
		    - 1];
/* L11: */
	}
	i__1 = frnynu_1.nwt;
	for (i = 1; i <= i__1; ++i) {
	    frstpm_1.ppta[i - 1] = fmt[i - 1];
	    frstpm_1.pmta[i - 1] = fmt[i - 1];
/* L21: */
	}
    }
/* ---- helge gives fermi-motion to all nucleons in the nuclei -----------
 */
    if (indata_1.ifermi == 1) {
	helge_();
    }
/* -----------------------------------------------------------------------
 */
    i__1 = frnynu_1.ny;
    for (i = 1; i <= i__1; ++i) {
	ppi = frstpm_1.ppin[frnynu_1.ni[i - 1] - 1];
	pmi = frstpm_1.pmin[frnynu_1.ni[i - 1] - 1];
	ppt = frstpm_1.ppta[frnynu_1.nt[i - 1] - 1];
	pmt = frstpm_1.pmta[frnynu_1.nt[i - 1] - 1];
	ppstox = frstpt_1.pxsp[frnynu_1.ni[i - 1] - 1];
	ppstoy = frstpt_1.pysp[frnynu_1.ni[i - 1] - 1];
	ptstox = frstpt_1.pxst[frnynu_1.nt[i - 1] - 1];
	ptstoy = frstpt_1.pyst[frnynu_1.nt[i - 1] - 1];
/* -------transformation to nucleon-nucleon cms----------------------
----- */
	bosfac = sqrt((ppi + ppt) / (pmi + pmt));
	ppicms = ppi / bosfac;
	pmicms = pmi * bosfac;
	pptcms = ppt / bosfac;
	pmtcms = pmt * bosfac;
/* ------- if the strings are backing in the cms => no effective ----
----- */
/* ------- collision ------------------------------------------------
----- */
	if (pmicms > ppicms || pptcms > pmtcms) {
	    goto L30;
	}
	nyrak = 0;
L40:
	++nyrak;
/* ------- if we get here to often the collision better not take place
---- */
	if (nyrak > 50) {
	    goto L31;
	}
	d__1 = (doublereal) (pmtcms / pmicms);
	d__2 = (doublereal) rlu_(&c__0);
	frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] = pmicms * pow_dd(&d__1, &d__2);
	d__1 = (doublereal) (ppicms / pptcms);
	d__2 = (doublereal) rlu_(&c__0);
	frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] = pptcms * pow_dd(&d__1, &d__2);
	frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] = ppicms + pptcms - 
		frstpm_1.ppta[frnynu_1.nt[i - 1] - 1];
	frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] = pmicms + pmtcms - 
		frstpm_1.pmin[frnynu_1.ni[i - 1] - 1];
	frstpt_1.pxsp[frnynu_1.ni[i - 1] - 1] = ppstox;
	frstpt_1.pysp[frnynu_1.ni[i - 1] - 1] = ppstoy;
	frstpt_1.pxst[frnynu_1.nt[i - 1] - 1] = ptstox;
	frstpt_1.pyst[frnynu_1.nt[i - 1] - 1] = ptstoy;
/* ------- halvda gives the strings pt ------------------------------
----a */
	halvda_(&i, &kfel);
	if (kfel == 1) {
	    goto L40;
	}
/* -------calculation of excited masses------------------------------
----- */
	ptsq1 = frstpt_1.pxsp[frnynu_1.ni[i - 1] - 1] * frstpt_1.pxsp[
		frnynu_1.ni[i - 1] - 1] + frstpt_1.pysp[frnynu_1.ni[i - 1] - 
		1] * frstpt_1.pysp[frnynu_1.ni[i - 1] - 1];
	ptsq2 = frstpt_1.pxst[frnynu_1.nt[i - 1] - 1] * frstpt_1.pxst[
		frnynu_1.nt[i - 1] - 1] + frstpt_1.pyst[frnynu_1.nt[i - 1] - 
		1] * frstpt_1.pyst[frnynu_1.nt[i - 1] - 1];
	frstma_1.win[frnynu_1.ni[i - 1] - 1] = sqrt(frstpm_1.ppin[frnynu_1.ni[
		i - 1] - 1] * frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] - ptsq1);
	frstma_1.wta[frnynu_1.nt[i - 1] - 1] = sqrt(frstpm_1.ppta[frnynu_1.nt[
		i - 1] - 1] * frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] - ptsq2);
/* -------no projectilemasses < mp and no targetmasses < mt ---------
----- */
	if (frstma_1.win[frnynu_1.ni[i - 1] - 1] < widmin || frstma_1.wta[
		frnynu_1.nt[i - 1] - 1] < wtdmin) {
	    goto L40;
	}
/* -------no double diffractive collisions---------------------------
----- */
	if (frstma_1.win[frnynu_1.ni[i - 1] - 1] < winmin && frstma_1.wta[
		frnynu_1.nt[i - 1] - 1] < wtamin) {
	    goto L40;
	}
/* -------new disrtr.of p+ & p- if either win or wta < winmin or wtami
n--- */
/* -------keep p+ for the projectile & p- for the target ------------
----- */
/* -------some kinematical tests-------------------------------------
----- */
	if (frstma_1.win[frnynu_1.ni[i - 1] - 1] < winmin) {
	    pminny = (fmp[frnynu_1.ni[i - 1] - 1] * fmp[frnynu_1.ni[i - 1] - 
		    1] + ptsq1) / frstpm_1.ppin[frnynu_1.ni[i - 1] - 1];
	    ppinny = frstpm_1.ppin[frnynu_1.ni[i - 1] - 1];
	    ploc = (ppinny - pminny) / 2;
	    eloc = (ppinny + pminny) / 2;
/* Computing 2nd power */
	    r__1 = ploc;
	    if (ptsq1 >= r__1 * r__1) {
		goto L40;
	    }
/* Computing 2nd power */
	    r__1 = ploc;
	    ploc = dabs(ploc) / ploc * sqrt(r__1 * r__1 - ptsq1);
/* Computing 2nd power */
	    r__1 = eloc;
	    eloc = sqrt(r__1 * r__1 - ptsq1);
	    ppinny = eloc + ploc;
	    pminny = eloc - ploc;
	    delpm = frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] - pminny;
	    delpp = frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] - ppinny;
	    frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] = pminny;
	    frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] = ppinny;
	    frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] += delpm;
	    frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] += delpp;
	    if (ptsq1 >= frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] * 
		    frstpm_1.pmin[frnynu_1.ni[i - 1] - 1]) {
		goto L40;
	    }
	    frstma_1.win[frnynu_1.ni[i - 1] - 1] = sqrt(frstpm_1.ppin[
		    frnynu_1.ni[i - 1] - 1] * frstpm_1.pmin[frnynu_1.ni[i - 1]
		     - 1] - ptsq1);
	    frstma_1.wta[frnynu_1.nt[i - 1] - 1] = sqrt(frstpm_1.ppta[
		    frnynu_1.nt[i - 1] - 1] * frstpm_1.pmta[frnynu_1.nt[i - 1]
		     - 1] - ptsq2);
	    if (frstma_1.wta[frnynu_1.nt[i - 1] - 1] < wtamin) {
		goto L40;
	    }
	}
	if (frstma_1.wta[frnynu_1.nt[i - 1] - 1] < wtamin) {
	    pptany = (fmt[frnynu_1.nt[i - 1] - 1] * fmt[frnynu_1.nt[i - 1] - 
		    1] + ptsq2) / frstpm_1.pmta[frnynu_1.nt[i - 1] - 1];
	    pmtany = frstpm_1.pmta[frnynu_1.nt[i - 1] - 1];
	    ploc = (pptany - pmtany) / 2;
	    eloc = (pptany + pmtany) / 2;
/* Computing 2nd power */
	    r__1 = ploc;
	    if (ptsq2 >= r__1 * r__1) {
		goto L40;
	    }
/* Computing 2nd power */
	    r__1 = ploc;
	    ploc = dabs(ploc) / ploc * sqrt(r__1 * r__1 - ptsq2);
/* Computing 2nd power */
	    r__1 = eloc;
	    eloc = sqrt(r__1 * r__1 - ptsq2);
	    pptany = eloc + ploc;
	    pmtany = eloc - ploc;
	    delpm = frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] - pmtany;
	    delpp = frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] - pptany;
	    frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] = pmtany;
	    frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] = pptany;
	    frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] += delpm;
	    frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] += delpp;
	    if (ptsq2 >= frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] * 
		    frstpm_1.pmta[frnynu_1.nt[i - 1] - 1]) {
		goto L40;
	    }
	    frstma_1.win[frnynu_1.ni[i - 1] - 1] = sqrt(frstpm_1.ppin[
		    frnynu_1.ni[i - 1] - 1] * frstpm_1.pmin[frnynu_1.ni[i - 1]
		     - 1] - ptsq1);
	    frstma_1.wta[frnynu_1.nt[i - 1] - 1] = sqrt(frstpm_1.ppta[
		    frnynu_1.nt[i - 1] - 1] * frstpm_1.pmta[frnynu_1.nt[i - 1]
		     - 1] - ptsq2);
	    if (frstma_1.win[frnynu_1.ni[i - 1] - 1] < winmin) {
		goto L40;
	    }
	}
/* -------no backing strings-----------------------------------------
----- */
	if (frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] > frstpm_1.ppin[frnynu_1.ni[
		i - 1] - 1] || frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] > 
		frstpm_1.pmta[frnynu_1.nt[i - 1] - 1]) {
	    goto L40;
	}
/* -------transformation back to lab---------------------------------
----- */
	frstpm_1.ppin[frnynu_1.ni[i - 1] - 1] *= bosfac;
	frstpm_1.pmin[frnynu_1.ni[i - 1] - 1] /= bosfac;
	frstpm_1.ppta[frnynu_1.nt[i - 1] - 1] *= bosfac;
	frstpm_1.pmta[frnynu_1.nt[i - 1] - 1] /= bosfac;
L30:
	;
    }
    i__1 = frnynu_1.nwp;
    for (i = 1; i <= i__1; ++i) {
	if (frstma_1.win[i - 1] > winmin) {
	    dptsq = (doublereal) frstpt_1.pxsp[i - 1] * (doublereal) 
		    frstpt_1.pxsp[i - 1] + (doublereal) frstpt_1.pysp[i - 1] *
		     (doublereal) frstpt_1.pysp[i - 1];
	    dmassq = (doublereal) frstpm_1.ppin[i - 1] * (doublereal) 
		    frstpm_1.pmin[i - 1];
	    frstma_1.win[i - 1] = sqrt(dmassq - dptsq);
	}
/* L331: */
    }
    i__1 = frnynu_1.nwt;
    for (i = 1; i <= i__1; ++i) {
	if (frstma_1.wta[i - 1] > wtamin) {
	    dptsq = (doublereal) frstpt_1.pxst[i - 1] * (doublereal) 
		    frstpt_1.pxst[i - 1] + (doublereal) frstpt_1.pyst[i - 1] *
		     (doublereal) frstpt_1.pyst[i - 1];
	    dmassq = (doublereal) frstpm_1.ppta[i - 1] * (doublereal) 
		    frstpm_1.pmta[i - 1];
	    frstma_1.wta[i - 1] = sqrt(dmassq - dptsq);
	}
/* L332: */
    }
    return 0;
} /* ring_ */

/* Subroutine */ int halvda_(i, kfel)
integer *i, *kfel;
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double log(), sqrt(), cos(), sin();

    /* Local variables */
    static real ptsq1, ptsq2, delfi, delpt, delpx, delpy;
    extern doublereal rlu_();

/* -----------------------------------------------------------------------
 */
/*     giving the excited nucleons pt */
/* -----------------------------------------------------------------------
 */
    *kfel = 0;
    delpt = sqrt(log((float)1. - rlu_(&c__0)) * (float)-.08);
    delfi = rlu_(&c__0) * (float)6.28317999999999977;
    delpx = delpt * cos(delfi);
    delpy = delpt * sin(delfi);
    frstpt_1.pxsp[frnynu_2.nucp[*i - 1] - 1] += delpx;
    frstpt_1.pysp[frnynu_2.nucp[*i - 1] - 1] += delpy;
    frstpt_1.pxst[frnynu_2.nuct[*i - 1] - 1] -= delpx;
    frstpt_1.pyst[frnynu_2.nuct[*i - 1] - 1] -= delpy;
/* Computing 2nd power */
    r__1 = frstpt_1.pxsp[frnynu_2.nucp[*i - 1] - 1];
/* Computing 2nd power */
    r__2 = frstpt_1.pysp[frnynu_2.nucp[*i - 1] - 1];
    ptsq1 = r__1 * r__1 + r__2 * r__2;
/* Computing 2nd power */
    r__1 = frstpt_1.pxst[frnynu_2.nuct[*i - 1] - 1];
/* Computing 2nd power */
    r__2 = frstpt_1.pyst[frnynu_2.nuct[*i - 1] - 1];
    ptsq2 = r__1 * r__1 + r__2 * r__2;
    if (ptsq1 >= frstpm_1.ppin[frnynu_2.nucp[*i - 1] - 1] * frstpm_1.pmin[
	    frnynu_2.nucp[*i - 1] - 1] || ptsq2 >= frstpm_1.ppta[
	    frnynu_2.nuct[*i - 1] - 1] * frstpm_1.pmta[frnynu_2.nuct[*i - 1] 
	    - 1]) {
	*kfel = 1;
    }
    return 0;
} /* halvda_ */

/* Subroutine */ int hildin_()
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static real qpos;
    static integer i;
    static real slump;
    static integer ia, iz;
    extern doublereal rlu_();

/* -----------------------------------------------------------------------
 */
/* the subroutine gives the identity to the involved particles */
/* -----------------------------------------------------------------------
 */
/* $$$$$$$$$$$$$$$$ */
/* ---- projectiletype p,pbar,pi+,pi- ------------------------------------
 */
/*     if(abs(iproty).eq.2) then */
/*       idp(1)=iproty*18/2 */
/*       goto 32 */
/*     elseif(abs(iproty).eq.1) then */
/*       idp(1)=iproty*17 */
/*       goto 32 */
/*     elseif(iproty.eq.0) then */
/*       if (nzp.eq.-1.) then */
/*         idp(1)=-41 */
/*         goto 32 */
/*       endif */
/*     endif */
/* -----------------------------------------------------------------------
 */
/* $$$$$$$$$$$$$$$$ */
/* $$$$$$$$$$$$$$$$ */
    if (indata_1.iproty != 0) {
	frstty_1.idp[0] = indata_1.iproty;
    } else {
/*        p_bar,p, nucleus */
/* $$$$$$$$$$$$$$$$ */
/* $$$$$$$$$$$$$$$$ */
	if ((real) indata_1.nzp == (float)-1.) {
	    frstty_1.idp[0] = -41;
	} else {
/* $$$$$$$$$$$$$$$$ */
	    iz = indata_1.nzp;
	    ia = indata_1.nap;
	    i__1 = indata_1.nap;
	    for (i = 1; i <= i__1; ++i) {
		slump = rlu_(&c__0);
		qpos = (real) iz / ia;
		if (slump < qpos) {
		    frstty_1.idp[i - 1] = 41;
		    --ia;
		    --iz;
		} else {
		    frstty_1.idp[i - 1] = 42;
		    --ia;
		}
/* L30: */
	    }
/* $$$$$$$$$$$$$$$$ */
	}
/* $$$$$$$$$$$$$$$$ */
/* $$$$$$$$$$$$$$$$ */
    }
/* $$$$$$$$$$$$$$$$ */
/* L32: */
    iz = indata_1.nzt;
    ia = indata_1.nat;
    i__1 = indata_1.nat;
    for (i = 1; i <= i__1; ++i) {
	slump = rlu_(&c__0);
	qpos = (real) iz / ia;
	if (slump < qpos) {
	    frstty_1.idt[i - 1] = 41;
	    --ia;
	    --iz;
	} else {
	    frstty_1.idt[i - 1] = 42;
	    --ia;
	}
/* L40: */
    }
    return 0;
} /* hildin_ */

/* Subroutine */ int angant_()
{
    /* Initialized data */

    static real el91 = (float)2.19722;
    static real el92 = (float)4.59512;
    static real el93 = (float)6.90675;
    static real el94 = (float)9.21024;
    static real el95 = (float)11.51292;
    static real c0 = (float).545;
    static real pi = (float)3.14159;
    static real rmin = (float)1.12838;

    /* System generated locals */
    integer i__1, i__2, i__3;
    doublereal d__1;

    /* Builtin functions */
    double pow_dd(), exp(), sqrt(), cos(), sin(), log();

    /* Local variables */
    static integer mcub;
    static real rjam, xgen, ygen;
    static integer ntra;
    static real pimp, ravp;
    static integer nerr;
    static real avsq, rint, ravt, risq, xmax, xmin, avsx, rmsq, avsy, avsz, 
	    ymax, ymin;
    static integer i, j;
    static real r, phgen;
    static integer markp;
    static real xlgen;
    static integer markt[250];
    static real ylgen, genus, sumco[3];
    static integer j1, j2, j3, l1;
    static real xmint, ymint, xmaxt, ymaxt;
    static integer l2, l3;
    static real xmaxp, xminp, ymaxp, yminp, ravsq, ba;
    static integer ii;
    static real ctheta, rgpcub[5], rgtcub[5], coordp[120]	/* was [40][3]
	     */, stheta, coordt[750]	/* was [250][3] */, sumtra, sl1, sl2, 
	    phi, rgp[5], grp[5], zco, rgt[5], grt[5], xco, yco;
    extern doublereal rlu_();
    static real slu;

/* -----------------------------------------------------------------------
 */
/* the subroutine records the two particles involved in each binary */
/* collision */
/* -----------------------------------------------------------------------
 */
/* -------monte carlo generation of wounded nucleons----------------------
 */
/* -------the dimensions should be coordt(>nat,3),coordp(>nap,3),---------
 */
/* -------markt(>nat),nucp&nuct(<nat*nap)---------------------------------
 */
/* -------some initialization---------------------------------------------
 */
/* $$$$$$$$$$$$$$$ */
/*     rint=1.00925 */
/* -------pion,kaon-------------------------------------------------------
 */
/*     if (abs(iproty).eq.1) rint=.81759 */
/*     if (abs(iproty).eq.2) rint=.75694 */
/* $$$$$$$$$$$$$$$$$ */

/* $$$$$$$$$$$$$$ */
    if (indata_1.iproty == 0) {
	rint = (float)1.00925;
    } else if (abs(indata_1.iproty) == 17 || abs(indata_1.iproty) == 23) {
/*         pion */
	rint = (float).81795;
    } else if (abs(indata_1.iproty) == 18 || abs(indata_1.iproty) == 19) {
/*         kaon */
	rint = (float).75694;
    } else {
	rint = (float).76;
    }
/* $$$$$$$$$$$$$$$$$$$$$$ */
    sumtra = (float)0.;
    pimp = (float)0.;
    rmsq = rmin * rmin;
    risq = rint * rint;
    d__1 = (doublereal) indata_1.nat;
    ravt = indata_1.r0t * pow_dd(&d__1, &c_b89);
    rgt[0] = ravt + c0 * el91;
    rgt[1] = ravt + c0 * el92;
    rgt[2] = ravt + c0 * el93;
    rgt[3] = ravt + c0 * el94;
    rgt[4] = ravt + c0 * el95;
    for (mcub = 1; mcub <= 5; ++mcub) {
	rgtcub[mcub - 1] = rgt[mcub - 1] * rgt[mcub - 1] * rgt[mcub - 1];
/* L10: */
    }
    grt[0] = rgtcub[0] / (float)3.;
    grt[1] = rgtcub[1] / (float)30.;
    grt[2] = rgtcub[2] / (float)300.;
    grt[3] = rgtcub[3] / (float)3e3;
    grt[4] = rgtcub[4] / (float)3e4;
    grt[4] -= grt[3] / (float)10.;
    grt[3] -= grt[2] / (float)10.;
    grt[2] -= grt[1] / (float)10.;
    grt[1] -= grt[0] / (float)10.;
    grt[1] += grt[0];
    grt[2] += grt[1];
    grt[3] += grt[2];
    grt[4] += grt[3];
    grt[0] /= grt[4];
    grt[1] /= grt[4];
    grt[2] /= grt[4];
    grt[3] /= grt[4];
    grt[4] = (float)1.;
    d__1 = (doublereal) indata_1.nap;
    ravp = indata_1.r0p * pow_dd(&d__1, &c_b89);
    rgp[0] = ravp + c0 * el91;
    rgp[1] = ravp + c0 * el92;
    rgp[2] = ravp + c0 * el93;
    rgp[3] = ravp + c0 * el94;
    rgp[4] = ravp + c0 * el95;
    for (mcub = 1; mcub <= 5; ++mcub) {
	rgpcub[mcub - 1] = rgp[mcub - 1] * rgp[mcub - 1] * rgp[mcub - 1];
/* L1010: */
    }
    grp[0] = rgpcub[0] / (float)3.;
    grp[1] = rgpcub[1] / (float)30.;
    grp[2] = rgpcub[2] / (float)300.;
    grp[3] = rgpcub[3] / (float)3e3;
    grp[4] = rgpcub[4] / (float)3e4;
    grp[4] -= grp[3] / (float)10.;
    grp[3] -= grp[2] / (float)10.;
    grp[2] -= grp[1] / (float)10.;
    grp[1] -= grp[0] / (float)10.;
    grp[1] += grp[0];
    grp[2] += grp[1];
    grp[3] += grp[2];
    grp[4] += grp[3];
    grp[0] /= grp[4];
    grp[1] /= grp[4];
    grp[2] /= grp[4];
    grp[3] /= grp[4];
    grp[4] = (float)1.;
/* -------start generate--------------------------------------------------
 */
/* -----------------------------------------------------------------------
 */
/* -------create the nat nucleons of the target---------------------------
 */
L3333:
    if (indata_1.nat <= 8) {
	goto L950;
    }
/* -------jump to special for alpha---------------------------------------
 */
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
L900:
	slu = rlu_(&c__0);
	if (slu >= grt[0]) {
	    goto L901;
	}
	slu = rlu_(&c__0);
	d__1 = (doublereal) slu;
	r = rgt[0] * pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravt) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1. / rjam;
	if (slu >= rjam) {
	    goto L900;
	}
	goto L905;
L901:
	if (slu >= grt[1]) {
	    goto L902;
	}
	slu = rlu_(&c__0);
	r = rgtcub[1] - rgtcub[0];
	r = r * slu + rgtcub[0];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravt) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)10. / rjam;
	if (slu >= rjam) {
	    goto L900;
	}
	goto L905;
L902:
	if (slu >= grt[2]) {
	    goto L903;
	}
	slu = rlu_(&c__0);
	r = rgtcub[2] - rgtcub[1];
	r = r * slu + rgtcub[1];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravt) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)100. / rjam;
	if (slu >= rjam) {
	    goto L900;
	}
	goto L905;
L903:
	if (slu >= grt[3]) {
	    goto L904;
	}
	slu = rlu_(&c__0);
	r = rgtcub[3] - rgtcub[2];
	r = r * slu + rgtcub[2];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravt) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1e3 / rjam;
	if (slu >= rjam) {
	    goto L900;
	}
	goto L905;
L904:
	slu = rlu_(&c__0);
	r = rgtcub[4] - rgtcub[3];
	r = r * slu + rgtcub[3];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravt) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1e4 / rjam;
	if (slu >= rjam) {
	    goto L900;
	}
L905:
	for (nerr = 1; nerr <= 10; ++nerr) {
	    slu = rlu_(&c__0);
	    phi = slu * (float)2. * pi;
	    slu = rlu_(&c__0);
	    ctheta = (float)1. - slu * 2;
	    stheta = sqrt((float)1. - ctheta * ctheta);
	    coordt[j1 - 1] = r * ctheta;
	    coordt[j1 + 249] = r * stheta * cos(phi);
	    coordt[j1 + 499] = r * stheta * sin(phi);
/* -------a nucleon is placed - check if it has a neighbour------
--------- */
/* -------too close----------------------------------------------
--------- */
	    if (j1 == 1) {
		goto L910;
	    }
	    i__2 = j1 - 1;
	    for (j2 = 1; j2 <= i__2; ++j2) {
		avsx = coordt[j1 - 1] - coordt[j2 - 1];
		avsy = coordt[j1 + 249] - coordt[j2 + 249];
		avsz = coordt[j1 + 499] - coordt[j2 + 499];
		avsq = avsx * avsx + avsy * avsy + avsz * avsz;
		if (avsq <= rmsq) {
		    goto L777;
		}
/* L911: */
	    }
	    goto L910;
L777:
	    ;
	}
	goto L900;
L910:
/* --------the nucleon (finally) passed the test---------------------
----- */
/* --------go on with next-------------------------------------------
----- */
/* L101: */
	;
    }
/* --------a target nucleus is created------------------------------------
 */
/* --------now the turn comes to the projectile---------------------------
 */
/* --------but first jump over the alpha stuff----------------------------
 */
    goto L110;
/* --------special for alpha----------------------------------------------
 */
L950:
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
L952:
	for (j3 = 1; j3 <= 3; ++j3) {
	    sl1 = rlu_(&c__0);
	    sl1 = log(sl1) * (float)-2.;
	    if (indata_1.nat == 1) {
		sl1 = (float)0.;
	    } else {
		sl1 = sqrt(sl1 * indata_1.nat / (indata_1.nat - 1)) * 
			indata_1.r0t;
	    }
	    sl2 = rlu_(&c__0);
	    sl2 = cos(pi * (float)2. * sl2);
	    coordt[j1 + j3 * 250 - 251] = sl1 * sl2;
/* L953: */
	}
	if (j1 == 1) {
	    goto L951;
	}
	i__2 = j1 - 1;
	for (j2 = 1; j2 <= i__2; ++j2) {
	    avsx = coordt[j1 - 1] - coordt[j2 - 1];
	    avsy = coordt[j1 + 249] - coordt[j2 + 249];
	    avsz = coordt[j1 + 499] - coordt[j2 + 499];
	    avsq = avsx * avsx + avsy * avsy + avsz * avsz;
	    if (avsq <= rmsq) {
		goto L952;
	    }
/* L954: */
	}
L951:
	;
    }
/* --------end of special for alpha---------------------------------------
 */
L110:
/* --------center the nucleons inside the nucleus-------------------------
 */
    for (j2 = 1; j2 <= 3; ++j2) {
	sumco[j2 - 1] = (float)0.;
/* L115: */
    }
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
	for (j2 = 1; j2 <= 3; ++j2) {
	    sumco[j2 - 1] += coordt[j1 + j2 * 250 - 251];
/* L112: */
	}
/* L111: */
    }
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
	for (j2 = 1; j2 <= 3; ++j2) {
	    coordt[j1 + j2 * 250 - 251] -= sumco[j2 - 1] / indata_1.nat;
/* L117: */
	}
/* L116: */
    }
/* --------sort the nucleons on increasing z-coordinate-------------------
 */
    i__1 = indata_1.nat;
    for (j1 = 2; j1 <= i__1; ++j1) {
	zco = coordt[j1 + 499];
	i__2 = j1 - 1;
	for (j2 = 1; j2 <= i__2; ++j2) {
	    if (zco < coordt[j2 + 499]) {
		xco = coordt[j1 - 1];
		yco = coordt[j1 + 249];
		i__3 = j1 - j2;
		for (j3 = 1; j3 <= i__3; ++j3) {
		    for (i = 1; i <= 3; ++i) {
			coordt[j1 + 1 - j3 + i * 250 - 251] = coordt[j1 - j3 
				+ i * 250 - 251];
/* L781: */
		    }
/* L780: */
		}
		coordt[j2 - 1] = xco;
		coordt[j2 + 249] = yco;
		coordt[j2 + 499] = zco;
		goto L778;
	    }
/* L779: */
	}
L778:
	;
    }
/* ----------end sorting--------------------------------------------------
 */
    xmaxt = (float)-999.;
    xmint = (float)999.;
    ymaxt = (float)-999.;
    ymint = (float)999.;
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
	if (coordt[j1 - 1] >= xmaxt) {
	    xmaxt = coordt[j1 - 1];
	}
	if (coordt[j1 - 1] <= xmint) {
	    xmint = coordt[j1 - 1];
	}
	if (coordt[j1 + 249] >= ymaxt) {
	    ymaxt = coordt[j1 + 249];
	}
	if (coordt[j1 + 249] <= ymint) {
	    ymint = coordt[j1 + 249];
	}
/* L103: */
    }
/* -----------------------------------------------------------------------
 */
/* -----------------------------------------------------------------------
 */
    if (indata_1.nap <= 8) {
	goto L1950;
    }
/* -------jump to special for alpha---------------------------------------
 */
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
L1900:
	slu = rlu_(&c__0);
	if (slu >= grp[0]) {
	    goto L1901;
	}
	slu = rlu_(&c__0);
	d__1 = (doublereal) slu;
	r = rgp[0] * pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravp) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1. / rjam;
	if (slu >= rjam) {
	    goto L1900;
	}
	goto L1905;
L1901:
	if (slu >= grp[1]) {
	    goto L1902;
	}
	slu = rlu_(&c__0);
	r = rgpcub[1] - rgpcub[0];
	r = r * slu + rgpcub[0];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravp) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)10. / rjam;
	if (slu >= rjam) {
	    goto L1900;
	}
	goto L1905;
L1902:
	if (slu >= grp[2]) {
	    goto L1903;
	}
	slu = rlu_(&c__0);
	r = rgpcub[2] - rgpcub[1];
	r = r * slu + rgpcub[1];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravp) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)100. / rjam;
	if (slu >= rjam) {
	    goto L1900;
	}
	goto L1905;
L1903:
	if (slu >= grp[3]) {
	    goto L1904;
	}
	slu = rlu_(&c__0);
	r = rgpcub[3] - rgpcub[2];
	r = r * slu + rgpcub[2];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravp) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1e3 / rjam;
	if (slu >= rjam) {
	    goto L1900;
	}
	goto L1905;
L1904:
	slu = rlu_(&c__0);
	r = rgpcub[4] - rgpcub[3];
	r = r * slu + rgpcub[3];
	d__1 = (doublereal) r;
	r = pow_dd(&d__1, &c_b89);
	slu = rlu_(&c__0);
	rjam = (r - ravp) / c0;
	rjam = exp(rjam) + (float)1.;
	rjam = (float)1e4 / rjam;
	if (slu >= rjam) {
	    goto L1900;
	}
L1905:
	for (nerr = 1; nerr <= 10; ++nerr) {
	    slu = rlu_(&c__0);
	    phi = slu * (float)2. * pi;
	    slu = rlu_(&c__0);
	    ctheta = (float)1. - slu * 2;
	    stheta = sqrt((float)1. - ctheta * ctheta);
	    coordp[l1 - 1] = r * ctheta;
	    coordp[l1 + 39] = r * stheta * cos(phi);
	    coordp[l1 + 79] = r * stheta * sin(phi);
/* -------a nucleon is placed - check if it has a neighbour------
--------- */
/* -------too close----------------------------------------------
--------- */
	    if (l1 == 1) {
		goto L1910;
	    }
	    i__2 = l1 - 1;
	    for (l2 = 1; l2 <= i__2; ++l2) {
		avsx = coordp[l1 - 1] - coordp[l2 - 1];
		avsy = coordp[l1 + 39] - coordp[l2 + 39];
		avsz = coordp[l1 + 79] - coordp[l2 + 79];
		avsq = avsx * avsx + avsy * avsy + avsz * avsz;
		if (avsq <= rmsq) {
		    goto L1777;
		}
/* L1911: */
	    }
	    goto L1910;
L1777:
	    ;
	}
	goto L1900;
L1910:
/* --------the nucleon (finally) passed the test---------------------
----- */
/* --------go on with next-------------------------------------------
----- */
/* L1101: */
	;
    }
/* --------a projectile nucleus is created--------------------------------
 */
/* --------now the colliding starts---------------------------------------
 */
/* --------but first jump over the alpha stuff----------------------------
 */
    goto L1110;
/* --------special for alpha----------------------------------------------
 */
L1950:
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
L1952:
	for (l3 = 1; l3 <= 3; ++l3) {
	    sl1 = rlu_(&c__0);
	    sl1 = log(sl1) * (float)-2.;
	    if (indata_1.nap == 1) {
		sl1 = (float)0.;
	    } else {
		sl1 = sqrt(sl1 * indata_1.nap / (indata_1.nap - 1)) * 
			indata_1.r0p;
	    }
	    sl2 = rlu_(&c__0);
	    sl2 = cos(pi * (float)2. * sl2);
	    coordp[l1 + l3 * 40 - 41] = sl1 * sl2;
/* L1953: */
	}
	if (l1 == 1) {
	    goto L1951;
	}
	i__2 = l1 - 1;
	for (l2 = 1; l2 <= i__2; ++l2) {
	    avsx = coordp[l1 - 1] - coordp[l2 - 1];
	    avsy = coordp[l1 + 39] - coordp[l2 + 39];
	    avsz = coordp[l1 + 79] - coordp[l2 + 79];
	    avsq = avsx * avsx + avsy * avsy + avsz * avsz;
	    if (avsq <= rmsq) {
		goto L1952;
	    }
/* L1954: */
	}
L1951:
	;
    }
/* --------end of special for alpha---------------------------------------
 */
L1110:
/* --------center the nucleons inside the nucleus-------------------------
 */
    for (l2 = 1; l2 <= 3; ++l2) {
	sumco[l2 - 1] = (float)0.;
/* L1115: */
    }
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
	for (l2 = 1; l2 <= 3; ++l2) {
	    sumco[l2 - 1] += coordp[l1 + l2 * 40 - 41];
/* L1112: */
	}
/* L1111: */
    }
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
	for (l2 = 1; l2 <= 3; ++l2) {
	    coordp[l1 + l2 * 40 - 41] -= sumco[l2 - 1] / indata_1.nap;
/* L1117: */
	}
/* L1116: */
    }
/* --------sort the nucleons on increasing z-coordinate-------------------
 */
    i__1 = indata_1.nap;
    for (l1 = 2; l1 <= i__1; ++l1) {
	zco = coordp[l1 + 79];
	i__2 = l1 - 1;
	for (l2 = 1; l2 <= i__2; ++l2) {
	    if (zco < coordp[l2 + 79]) {
		xco = coordp[l1 - 1];
		yco = coordp[l1 + 39];
		i__3 = l1 - l2;
		for (l3 = 1; l3 <= i__3; ++l3) {
		    for (i = 1; i <= 3; ++i) {
			coordp[l1 + 1 - l3 + i * 40 - 41] = coordp[l1 - l3 + 
				i * 40 - 41];
/* L1781: */
		    }
/* L1780: */
		}
		coordp[l2 - 1] = xco;
		coordp[l2 + 39] = yco;
		coordp[l2 + 79] = zco;
		goto L1778;
	    }
/* L1779: */
	}
L1778:
	;
    }
/* ----------end sorting--------------------------------------------------
 */
    xmaxp = (float)-999.;
    xminp = (float)999.;
    ymaxp = (float)-999.;
    yminp = (float)999.;
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
	if (coordp[l1 - 1] >= xmaxp) {
	    xmaxp = coordp[l1 - 1];
	}
	if (coordp[l1 - 1] <= xminp) {
	    xminp = coordp[l1 - 1];
	}
	if (coordp[l1 + 39] >= ymaxp) {
	    ymaxp = coordp[l1 + 39];
	}
	if (coordp[l1 + 39] <= yminp) {
	    yminp = coordp[l1 + 39];
	}
/* L1103: */
    }
    xmax = xmaxt - xminp + rint;
    xmin = xmint - xmaxp - rint;
    ymax = ymaxt - yminp + rint;
    ymin = ymint - ymaxp - rint;
    ba = (xmax - xmin) * (ymax - ymin);
    ntra = 0;
    if (indata_1.iflspv == 2 || indata_1.iflspv == 3) {
	slu = rlu_(&c__0);
	genus = sqrt(slu * (indata_1.bmax * indata_1.bmax - indata_1.bmin * 
		indata_1.bmin) + indata_1.bmin * indata_1.bmin);
	slu = rlu_(&c__0);
	phgen = slu * (float)2. * pi;
	xgen = genus * cos(phgen);
	ygen = genus * sin(phgen);
    } else {
	slu = rlu_(&c__0);
	xgen = (xmax - xmin) * slu + xmin;
	slu = rlu_(&c__0);
	ygen = (ymax - ymin) * slu + ymin;
    }
    frnynu_2.bipa = sqrt(xgen * xgen + ygen * ygen);
    pimp += (float)1.;
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
	markt[j1 - 1] = 0;
/* L2010: */
    }
    frnynu_2.ny = 0;
    frnynu_2.nwp = 0;
    i__1 = indata_1.nap;
    for (l1 = 1; l1 <= i__1; ++l1) {
	markp = 0;
	xlgen = coordp[l1 - 1] + xgen;
	ylgen = coordp[l1 + 39] + ygen;
	if (xlgen > xmaxt + rint) {
	    goto L2020;
	}
	if (xlgen < xmint - rint) {
	    goto L2020;
	}
	if (ylgen > ymaxt + rint) {
	    goto L2020;
	}
	if (ylgen < ymint - rint) {
	    goto L2020;
	}
	i__2 = indata_1.nat;
	for (j1 = 1; j1 <= i__2; ++j1) {
	    ravsq = (coordt[j1 - 1] - xlgen) * (coordt[j1 - 1] - xlgen) + (
		    coordt[j1 + 249] - ylgen) * (coordt[j1 + 249] - ylgen);
	    if (risq < ravsq) {
		goto L105;
	    }
	    ++frnynu_2.ny;
	    markt[j1 - 1] = 1;
	    markp = 1;
	    frnynu_2.nucp[frnynu_2.ny - 1] = l1;
	    frnynu_2.nuct[frnynu_2.ny - 1] = j1;
L105:
	    ;
	}
	frnynu_2.nwp += markp;
L2020:
	;
    }
    if ((indata_1.iflspv == 1 || indata_1.iflspv == 3) && frnynu_2.nwp < 
	    indata_1.nap) {
	goto L3333;
    }
    if (frnynu_2.nwp == 0) {
	goto L3333;
    }
    frnynu_2.nwt = 0;
    i__1 = indata_1.nat;
    for (j1 = 1; j1 <= i__1; ++j1) {
	frnynu_2.nwt += markt[j1 - 1];
/* L2030: */
    }
    i__1 = indata_1.nap;
    for (i = 1; i <= i__1; ++i) {
	ii = 999;
	i__2 = frnynu_2.ny;
	for (j = 1; j <= i__2; ++j) {
	    if (frnynu_2.nucp[j - 1] >= i && frnynu_2.nucp[j - 1] < ii) {
		ii = frnynu_2.nucp[j - 1];
	    }
/* L2701: */
	}
	if (ii == i) {
	    goto L2700;
	}
	if (ii == 999) {
	    goto L2703;
	}
	i__2 = frnynu_2.ny;
	for (j = 1; j <= i__2; ++j) {
	    if (frnynu_2.nucp[j - 1] == ii) {
		frnynu_2.nucp[j - 1] = i;
	    }
/* L2702: */
	}
L2700:
	;
    }
L2703:
    i__1 = indata_1.nat;
    for (i = 1; i <= i__1; ++i) {
	ii = 999;
	i__2 = frnynu_2.ny;
	for (j = 1; j <= i__2; ++j) {
	    if (frnynu_2.nuct[j - 1] >= i && frnynu_2.nuct[j - 1] < ii) {
		ii = frnynu_2.nuct[j - 1];
	    }
/* L2711: */
	}
	if (ii == i) {
	    goto L2710;
	}
	if (ii == 999) {
	    goto L2713;
	}
	i__2 = frnynu_2.ny;
	for (j = 1; j <= i__2; ++j) {
	    if (frnynu_2.nuct[j - 1] == ii) {
		frnynu_2.nuct[j - 1] = i;
	    }
/* L2712: */
	}
L2710:
	;
    }
L2713:
    return 0;
} /* angant_ */

/* Subroutine */ int helge_()
{
    /* Initialized data */

    static real pi = (float)3.14159;

    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double log(), sqrt(), cos();

    /* Local variables */
    static integer i, j;
    static real fvect[750]	/* was [3][250] */, pplus, bosfac, pminus, 
	    sl1, sl2;
    extern doublereal rlu_();
    static real sum;

/* -----------------------------------------------------------------------
 */
/* ---- helge gives fermi-motion to the nucleons in the nuclei -----------
 */
/* -----------------------------------------------------------------------
 */
    if (indata_1.nap <= 1) {
	goto L100;
    }
L19:
    for (i = 1; i <= 3; ++i) {
	sum = (float)0.;
	i__1 = indata_1.nap;
	for (j = 1; j <= i__1; ++j) {
	    sl1 = rlu_(&c__0);
	    sl2 = rlu_(&c__0);
	    sl1 = sqrt(log(sl1) * (float)-2. * indata_1.nap / (indata_1.nap - 
		    1));
	    sl2 = cos(pi * (float)2. * sl2);
	    fvect[i + j * 3 - 4] = sl1 * sl2 * (float).1;
	    sum += fvect[i + j * 3 - 4];
/* L11: */
	}
	i__1 = frnynu_1.nwp;
	for (j = 1; j <= i__1; ++j) {
	    fvect[i + j * 3 - 4] -= sum / indata_1.nap;
/* L12: */
	}
/* L10: */
    }
    i__1 = frnynu_1.nwp;
    for (j = 1; j <= i__1; ++j) {
	sum = (float)0.;
	for (i = 1; i <= 3; ++i) {
/* Computing 2nd power */
	    r__1 = fvect[i + j * 3 - 4];
	    sum += r__1 * r__1;
/* L17: */
	}
	if (sum >= (float).3) {
	    goto L16;
	}
/* L18: */
    }
L16:
    if (sum >= (float).3) {
	goto L19;
    }
    i__1 = frnynu_1.nwp;
    for (j = 1; j <= i__1; ++j) {
	frstpt_1.pxsp[j - 1] = fvect[j * 3 - 3];
	frstpt_1.pysp[j - 1] = fvect[j * 3 - 2];
	bosfac = sqrt(frstpm_1.ppin[j - 1] / frstpm_1.pmin[j - 1]);
	pplus = frstpm_1.ppin[j - 1] / bosfac;
	pminus = frstpm_1.pmin[j - 1] * bosfac;
/* Computing 2nd power */
	r__1 = pplus;
/* Computing 2nd power */
	r__2 = fvect[j * 3 - 1];
	pplus = sqrt(r__1 * r__1 + r__2 * r__2) + fvect[j * 3 - 1];
/* Computing 2nd power */
	r__1 = pminus;
/* Computing 2nd power */
	r__2 = fvect[j * 3 - 1];
	pminus = sqrt(r__1 * r__1 + r__2 * r__2) - fvect[j * 3 - 1];
	frstpm_1.ppin[j - 1] = pplus * bosfac;
	frstpm_1.pmin[j - 1] = pminus / bosfac;
/* L13: */
    }
L100:
    if (indata_1.nat <= 1) {
	goto L200;
    }
L119:
    for (i = 1; i <= 3; ++i) {
	sum = (float)0.;
	i__1 = indata_1.nat;
	for (j = 1; j <= i__1; ++j) {
	    sl1 = rlu_(&c__0);
	    sl2 = rlu_(&c__0);
	    sl1 = sqrt(log(sl1) * (float)-2. * indata_1.nat / (indata_1.nat - 
		    1));
	    sl2 = cos(pi * (float)2. * sl2);
	    fvect[i + j * 3 - 4] = sl1 * sl2 * (float).1;
	    sum += fvect[i + j * 3 - 4];
/* L111: */
	}
	i__1 = frnynu_1.nwt;
	for (j = 1; j <= i__1; ++j) {
	    fvect[i + j * 3 - 4] -= sum / indata_1.nat;
/* L112: */
	}
/* L110: */
    }
    i__1 = frnynu_1.nwt;
    for (j = 1; j <= i__1; ++j) {
	sum = (float)0.;
	for (i = 1; i <= 3; ++i) {
/* Computing 2nd power */
	    r__1 = fvect[i + j * 3 - 4];
	    sum += r__1 * r__1;
/* L117: */
	}
	if (sum >= (float).3) {
	    goto L116;
	}
/* L118: */
    }
L116:
    if (sum >= (float).3) {
	goto L119;
    }
    i__1 = frnynu_1.nwt;
    for (j = 1; j <= i__1; ++j) {
	frstpt_1.pxst[j - 1] = fvect[j * 3 - 3];
	frstpt_1.pyst[j - 1] = fvect[j * 3 - 2];
	bosfac = sqrt(frstpm_1.ppta[j - 1] / frstpm_1.pmta[j - 1]);
	pplus = frstpm_1.ppta[j - 1] / bosfac;
	pminus = frstpm_1.pmta[j - 1] * bosfac;
/* Computing 2nd power */
	r__1 = pplus;
/* Computing 2nd power */
	r__2 = fvect[j * 3 - 1];
	pplus = sqrt(r__1 * r__1 + r__2 * r__2) + fvect[j * 3 - 1];
/* Computing 2nd power */
	r__1 = pminus;
/* Computing 2nd power */
	r__2 = fvect[j * 3 - 1];
	pminus = sqrt(r__1 * r__1 + r__2 * r__2) - fvect[j * 3 - 1];
	frstpm_1.ppta[j - 1] = pplus * bosfac;
	frstpm_1.pmta[j - 1] = pminus / bosfac;
/* L113: */
    }
L200:
    return 0;
} /* helge_ */

/* Subroutine */ int ellida_()
{
    /* Format strings */
    static char fmt_801[] = "(\002 \002,a,f6.0,a)";
    static char fmt_802[] = "(\002 \002,a,a,i4,a,i4)";
    static char fmt_803[] = "(\002 \002,a,i7,a)";
    static char fmt_804[] = "(\002 \002,a,f6.2,a,f6.2,a)";
    static char fmt_805[] = "(\002 \002,a,i7)";
    static char fmt_806[] = "(\002 \002,a,a,i4,a,i4)";
    static char fmt_807[] = "(\002 \002,a,f6.2,a)";
    static char fmt_808[] = "(\002 \002,a,i5,a)";
    static char fmt_809[] = "(\002 \002,a,a)";
    static char fmt_810[] = "(\002 \002,3i5,i3,i2,1x,a8,5(1x,f8.3))";

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(), e_wsle(), s_wsfe(), do_fio(), e_wsfe();

    /* Local variables */
    static integer icha, idec;
    static char chap[8];
    static integer iori, ityp, i, j;
    extern /* Subroutine */ int luname_(), lulist_();
    extern integer klu_();

    /* Fortran I/O blocks */
    static cilist io___188 = { 0, 0, 0, 0, 0 };
    static cilist io___189 = { 0, 0, 0, 0, 0 };
    static cilist io___190 = { 0, 0, 0, 0, 0 };
    static cilist io___191 = { 0, 0, 0, fmt_801, 0 };
    static cilist io___192 = { 0, 0, 0, fmt_801, 0 };
    static cilist io___193 = { 0, 0, 0, fmt_802, 0 };
    static cilist io___194 = { 0, 0, 0, fmt_802, 0 };
    static cilist io___195 = { 0, 0, 0, fmt_803, 0 };
    static cilist io___196 = { 0, 0, 0, fmt_804, 0 };
    static cilist io___197 = { 0, 0, 0, fmt_804, 0 };
    static cilist io___198 = { 0, 0, 0, fmt_804, 0 };
    static cilist io___199 = { 0, 0, 0, fmt_804, 0 };
    static cilist io___200 = { 0, 0, 0, fmt_805, 0 };
    static cilist io___201 = { 0, 0, 0, fmt_806, 0 };
    static cilist io___202 = { 0, 0, 0, fmt_806, 0 };
    static cilist io___203 = { 0, 0, 0, fmt_807, 0 };
    static cilist io___204 = { 0, 0, 0, fmt_808, 0 };
    static cilist io___205 = { 0, 0, 0, 0, 0 };
    static cilist io___206 = { 0, 0, 0, 0, 0 };
    static cilist io___207 = { 0, 0, 0, fmt_809, 0 };
    static cilist io___214 = { 0, 0, 0, fmt_810, 0 };


/* -----------------------------------------------------------------------
 */
/* -----ellida for eventlisting-------------------------------------------
 */
/* -----------------------------------------------------------------------
 */
    if (evevec_1.nevent == 1) {
	io___188.ciunit = ludat1_1.mst[19];
	s_wsle(&io___188);
	e_wsle();
	io___189.ciunit = ludat1_1.mst[19];
	s_wsle(&io___189);
	e_wsle();
	io___190.ciunit = ludat1_1.mst[19];
	s_wsle(&io___190);
	e_wsle();
	if (indata_1.rots == (float)0.) {
	    io___191.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___191);
	    do_fio(&c__1, "energy", 6L);
	    do_fio(&c__1, (char *)&indata_1.elab, (ftnlen)sizeof(real));
	    do_fio(&c__1, " a gev", 6L);
	    e_wsfe();
	}
	if (indata_1.elab == (float)0.) {
	    io___192.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___192);
	    do_fio(&c__1, "roots ", 6L);
	    do_fio(&c__1, (char *)&indata_1.rots, (ftnlen)sizeof(real));
	    do_fio(&c__1, " a gev", 6L);
	    e_wsfe();
	}
	io___193.ciunit = ludat1_1.mst[19];
	s_wsfe(&io___193);
	do_fio(&c__1, "projectile", 10L);
	do_fio(&c__1, " a=", 3L);
	do_fio(&c__1, (char *)&indata_1.nap, (ftnlen)sizeof(integer));
	do_fio(&c__1, " z=", 3L);
	do_fio(&c__1, (char *)&indata_1.nzp, (ftnlen)sizeof(integer));
	e_wsfe();
	io___194.ciunit = ludat1_1.mst[19];
	s_wsfe(&io___194);
	do_fio(&c__1, "target    ", 10L);
	do_fio(&c__1, " a=", 3L);
	do_fio(&c__1, (char *)&indata_1.nat, (ftnlen)sizeof(integer));
	do_fio(&c__1, " z=", 3L);
	do_fio(&c__1, (char *)&indata_1.nzt, (ftnlen)sizeof(integer));
	e_wsfe();
	io___195.ciunit = ludat1_1.mst[19];
	s_wsfe(&io___195);
	do_fio(&c__1, "this list contains", 18L);
	do_fio(&c__1, (char *)&indata_1.neve, (ftnlen)sizeof(integer));
	do_fio(&c__1, " events", 7L);
	e_wsfe();
	if (indata_1.iflspv == 0) {
	    io___196.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___196);
	    do_fio(&c__1, "minimum bias  ", 14L);
	    e_wsfe();
	} else if (indata_1.iflspv == 1) {
	    io___197.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___197);
	    do_fio(&c__1, "spectator veto", 14L);
	    e_wsfe();
	} else if (indata_1.iflspv == 2) {
	    io___198.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___198);
	    do_fio(&c__1, "impact setting", 14L);
	    do_fio(&c__1, (char *)&indata_1.bmin, (ftnlen)sizeof(real));
	    do_fio(&c__1, " -", 2L);
	    do_fio(&c__1, (char *)&indata_1.bmax, (ftnlen)sizeof(real));
	    do_fio(&c__1, " fermi", 6L);
	    e_wsfe();
	} else {
	    io___199.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___199);
	    do_fio(&c__1, "spect veto +impact setting", 26L);
	    do_fio(&c__1, (char *)&indata_1.bmin, (ftnlen)sizeof(real));
	    do_fio(&c__1, " -", 2L);
	    do_fio(&c__1, (char *)&indata_1.bmax, (ftnlen)sizeof(real));
	    do_fio(&c__1, " fermi", 6L);
	    e_wsfe();
	}
    }
    io___200.ciunit = ludat1_1.mst[19];
    s_wsfe(&io___200);
    do_fio(&c__1, "event", 5L);
    do_fio(&c__1, (char *)&evevec_1.nevent, (ftnlen)sizeof(integer));
    e_wsfe();
    io___201.ciunit = ludat1_1.mst[19];
    s_wsfe(&io___201);
    do_fio(&c__1, "projectile spectators", 21L);
    do_fio(&c__1, "  protons", 9L);
    do_fio(&c__1, (char *)&evevec_1.isppp, (ftnlen)sizeof(integer));
    do_fio(&c__1, " neutrons", 9L);
    do_fio(&c__1, (char *)&evevec_1.isppn, (ftnlen)sizeof(integer));
    e_wsfe();
    io___202.ciunit = ludat1_1.mst[19];
    s_wsfe(&io___202);
    do_fio(&c__1, "target     spectators", 21L);
    do_fio(&c__1, "  protons", 9L);
    do_fio(&c__1, (char *)&evevec_1.isptp, (ftnlen)sizeof(integer));
    do_fio(&c__1, " neutrons", 9L);
    do_fio(&c__1, (char *)&evevec_1.isptn, (ftnlen)sizeof(integer));
    e_wsfe();
    io___203.ciunit = ludat1_1.mst[19];
    s_wsfe(&io___203);
    do_fio(&c__1, "impact parameter", 16L);
    do_fio(&c__1, (char *)&evevec_1.bimp, (ftnlen)sizeof(real));
    do_fio(&c__1, " fermi", 6L);
    e_wsfe();
    io___204.ciunit = ludat1_1.mst[19];
    s_wsfe(&io___204);
    do_fio(&c__1, "the event contains", 18L);
    do_fio(&c__1, (char *)&lujets_1.n, (ftnlen)sizeof(integer));
    do_fio(&c__1, " lines", 6L);
    e_wsfe();
    if (lujets_1.n == 0) {
	return 0;
    }
    if (indata_1.iflout == -1) {
	lulist_(&c__1);
	io___205.ciunit = ludat1_1.mst[19];
	s_wsle(&io___205);
	e_wsle();
	io___206.ciunit = ludat1_1.mst[19];
	s_wsle(&io___206);
	e_wsle();
    } else {
	io___207.ciunit = ludat1_1.mst[19];
	s_wsfe(&io___207);
	do_fio(&c__1, "    i  ori code  q d particle    px", 35L);
	do_fio(&c__1, "       py       pz     energy    mass", 37L);
	e_wsfe();
	i__1 = lujets_1.n;
	for (i = 1; i <= i__1; ++i) {
	    if (indata_1.iflout == 0) {
		iori = lujets_1.k[i - 1] % 10000;
	    } else {
		iori = 0;
	    }
	    ityp = lujets_1.k[i + 1999];
	    icha = klu_(&i, &c__3) / 3;
	    if (klu_(&i, &c__11) == 0) {
		idec = 1;
	    } else {
		idec = 0;
	    }
	    luname_(&ityp, chap, 8L);
	    if (idec == 1) {
		chap[7] = 'd';
	    }
	    io___214.ciunit = ludat1_1.mst[19];
	    s_wsfe(&io___214);
	    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&iori, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&ityp, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&icha, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&idec, (ftnlen)sizeof(integer));
	    do_fio(&c__1, chap, 8L);
	    for (j = 1; j <= 5; ++j) {
		do_fio(&c__1, (char *)&lujets_1.p[i + j * 2000 - 2001], (
			ftnlen)sizeof(real));
	    }
	    e_wsfe();
/* L1: */
	}
    }
    return 0;
} /* ellida_ */

/* -----routines same as lurobo except that the boost parameter beta------ */
/* -----is changed to 1-beta and 1+beta respectively to make the boost---- */
/* -----more acurate------------------------------------------------------ */
/* *********************************************************************** */
/* Subroutine */ int luroin_(the, phi, bex, bey, embez)
real *the, *phi, *bex, *bey, *embez;
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double cos(), sin(), sqrt();

    /* Local variables */
    static doublereal dbep, dbex, dbey, dbez;
    static integer imax, i, j;
    static doublereal dgabep, dp[4];
    static real pv[3];
    static doublereal dga;
    static real rot[9]	/* was [3][3] */;

    imax = lujets_1.n;
    if (ludat1_1.mst[1] > 0) {
	imax = ludat1_1.mst[1];
    }
/* Computing 2nd power */
    r__1 = *the;
/* Computing 2nd power */
    r__2 = *phi;
    if (r__1 * r__1 + r__2 * r__2 < (float)1e-20) {
	goto L130;
    }
/* ...rotate (typically from z axis to direction theta,phi) */
    rot[0] = cos(*the) * cos(*phi);
    rot[3] = -(doublereal)sin(*phi);
    rot[6] = sin(*the) * cos(*phi);
    rot[1] = cos(*the) * sin(*phi);
    rot[4] = cos(*phi);
    rot[7] = sin(*the) * sin(*phi);
    rot[2] = -(doublereal)sin(*the);
    rot[5] = (float)0.;
    rot[8] = cos(*the);
    i__1 = imax;
    for (i = max(1,ludat1_1.mst[0]); i <= i__1; ++i) {
	if (lujets_1.k[i - 1] / 10000 % 10 >= 6) {
	    goto L120;
	}
	for (j = 1; j <= 3; ++j) {
/* L100: */
	    pv[j - 1] = lujets_1.p[i + j * 2000 - 2001];
	}
	for (j = 1; j <= 3; ++j) {
/* L110: */
	    lujets_1.p[i + j * 2000 - 2001] = rot[j - 1] * pv[0] + rot[j + 2] 
		    * pv[1] + rot[j + 5] * pv[2];
	}
L120:
	;
    }
L130:
/* Computing 2nd power */
    r__1 = *bex;
/* Computing 2nd power */
    r__2 = *bey;
/* Computing 2nd power */
    r__3 = (float)1. - *embez;
    if (r__1 * r__1 + r__2 * r__2 + r__3 * r__3 < (float)1e-20) {
	return 0;
    }
/* ...lorentz boost (typically from rest to momentum/energy=beta) */
    dbex = (doublereal) (*bex);
    dbey = (doublereal) (*bey);
    dbez = 1. - (doublereal) (*embez);
/* Computing 2nd power */
    d__1 = dbex;
/* Computing 2nd power */
    d__2 = dbey;
/* Computing 2nd power */
    d__3 = dbez;
    dga = 1. / sqrt(1. - d__1 * d__1 - d__2 * d__2 - d__3 * d__3);
    i__1 = imax;
    for (i = max(1,ludat1_1.mst[0]); i <= i__1; ++i) {
	if (lujets_1.k[i - 1] / 10000 % 10 >= 6) {
	    goto L150;
	}
	for (j = 1; j <= 4; ++j) {
/* L140: */
	    dp[j - 1] = (doublereal) lujets_1.p[i + j * 2000 - 2001];
	}
	dbep = dbex * dp[0] + dbey * dp[1] + dbez * dp[2];
	dgabep = dga * (dga * dbep / (dga + 1.) + dp[3]);
	lujets_1.p[i - 1] = dp[0] + dgabep * dbex;
	lujets_1.p[i + 1999] = dp[1] + dgabep * dbey;
	lujets_1.p[i + 3999] = dp[2] + dgabep * dbez;
	lujets_1.p[i + 5999] = dga * (dp[3] + dbep);
L150:
	;
    }
    return 0;
} /* luroin_ */

/* ********************************************************************* */
/* Subroutine */ int lurota_(the, phi, bex, bey, epbez)
real *the, *phi, *bex, *bey, *epbez;
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double cos(), sin(), sqrt();

    /* Local variables */
    static doublereal dbep, dbex, dbey, dbez;
    static integer imax, i, j;
    static doublereal dgabep, dp[4];
    static real pv[3];
    static doublereal dga;
    static real rot[9]	/* was [3][3] */;

    imax = lujets_1.n;
    if (ludat1_1.mst[1] > 0) {
	imax = ludat1_1.mst[1];
    }
/* Computing 2nd power */
    r__1 = *the;
/* Computing 2nd power */
    r__2 = *phi;
    if (r__1 * r__1 + r__2 * r__2 < (float)1e-20) {
	goto L130;
    }
/* ...rotate (typically from z axis to direction theta,phi) */
    rot[0] = cos(*the) * cos(*phi);
    rot[3] = -(doublereal)sin(*phi);
    rot[6] = sin(*the) * cos(*phi);
    rot[1] = cos(*the) * sin(*phi);
    rot[4] = cos(*phi);
    rot[7] = sin(*the) * sin(*phi);
    rot[2] = -(doublereal)sin(*the);
    rot[5] = (float)0.;
    rot[8] = cos(*the);
    i__1 = imax;
    for (i = max(1,ludat1_1.mst[0]); i <= i__1; ++i) {
	if (lujets_1.k[i - 1] / 10000 % 10 >= 6) {
	    goto L120;
	}
	for (j = 1; j <= 3; ++j) {
/* L100: */
	    pv[j - 1] = lujets_1.p[i + j * 2000 - 2001];
	}
	for (j = 1; j <= 3; ++j) {
/* L110: */
	    lujets_1.p[i + j * 2000 - 2001] = rot[j - 1] * pv[0] + rot[j + 2] 
		    * pv[1] + rot[j + 5] * pv[2];
	}
L120:
	;
    }
L130:
/* Computing 2nd power */
    r__1 = *bex;
/* Computing 2nd power */
    r__2 = *bey;
/* Computing 2nd power */
    r__3 = *epbez - (float)1.;
    if (r__1 * r__1 + r__2 * r__2 + r__3 * r__3 < (float)1e-20) {
	return 0;
    }
/* ...lorentz boost (typically from rest to momentum/energy=beta) */
    dbex = (doublereal) (*bex);
    dbey = (doublereal) (*bey);
    dbez = (doublereal) (*epbez) - 1.;
/* Computing 2nd power */
    d__1 = dbex;
/* Computing 2nd power */
    d__2 = dbey;
/* Computing 2nd power */
    d__3 = dbez;
    dga = 1. / sqrt(1. - d__1 * d__1 - d__2 * d__2 - d__3 * d__3);
    i__1 = imax;
    for (i = max(1,ludat1_1.mst[0]); i <= i__1; ++i) {
	if (lujets_1.k[i - 1] / 10000 % 10 >= 6) {
	    goto L150;
	}
	for (j = 1; j <= 4; ++j) {
/* L140: */
	    dp[j - 1] = (doublereal) lujets_1.p[i + j * 2000 - 2001];
	}
	dbep = dbex * dp[0] + dbey * dp[1] + dbez * dp[2];
	dgabep = dga * (dga * dbep / (dga + 1.) + dp[3]);
	lujets_1.p[i - 1] = dp[0] + dgabep * dbex;
	lujets_1.p[i + 1999] = dp[1] + dgabep * dbey;
	lujets_1.p[i + 3999] = dp[2] + dgabep * dbez;
	lujets_1.p[i + 5999] = dga * (dp[3] + dbep);
L150:
	;
    }
    return 0;
} /* lurota_ */

