c     ******************************************************************
c     *                                                                *
c     * cdecayLeng: samples decay length of a given particle
c     *                                                                *
c        samples decay length of a particle.
c        
c        For a charged particle, we consider the change of the life
c     time due to the energy change by ionization loss.

      subroutine  cdecayLeng(aTrack, length)
      implicit none
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"



      record /track/ aTrack ! input.a  track of a decaying particle
      real*8  length  ! output. length to wthich the decay takes place (m).

      real*8 g, u,  gbeta, dedt, dedl, ctau, rho
      real*8 a, x, p, gmin, ctaumax, pmin, cvh2den
      record /fmom/ gb

      data gmin/200.d0/, ctaumax/50.d0/, pmin/10.d0/


      call cgetctau(aTrack.p, ctau)
      if(ctau .eq. Infty) then
         length = Infty
      elseif(aTrack.p.fm.p(4) .le. aTrack.p.mass) then
         length = 1.d-5
         return   ! *******
      else 
         g = aTrack.p.fm.p(4)/aTrack.p.mass
         if(g .gt. gmin) then
            call rndc(u)
            length = - ctau* g *log(u)
         else
            call cgetlf(aTrack.p, gb)
            gbeta = sqrt(gb.p(1)**2 + gb.p(2)**2 + gb.p(3)**2)
            if(aTrack.p.charge .eq. 0 .or. ctau .lt. ctaumax) then
               call rndc(u)
               length = - ctau * gbeta * log(u)
            elseif(FromEpics) then
c                  no need to consider energy loss.
c                  this may not be good for rock of large length
c                 In that case we must consider decay length
c                 in Epics.  (don't call cdecayLeng and manage
c                  decay in Epics).
               call rndc(u)
               length = - ctau * gbeta * log(u)
            else
               rho = cvh2den(aTrack.pos.height)
               call cdedxInAir(aTrack.p, rho, dedt) ! dedt in GeV/(kg/m^2)
               dedl= dedt*rho   !    GeV/m
               a = dedl/aTrack.p.fm.p(4) ! 1/m
               p =1.0d0/( a * ctau * g )
               if( p .gt. pmin) then
                  call rndc(u)
                  length = - ctau* gbeta *log(u)
               else   
                  call cdecayWEL(p, g, x)
                  length =(1.0d0 -  x/g)/a
                  if(length .le. 0.) then
c                       many happpen when a<<<1.
                     length = 1.d-3
                  endif
               endif
            endif
         endif
      endif
      end
c  decay with costant rate of energy loss.
c
c       decay probability function can be expressed as
c   
c   p(x)dx=   dx 1/(x-sqrt(x**2-1))**p /sqrt(x**2-1)
c
c     the range of x is 1 to g=E0/m.
c   p is almost independent of energy and for muons
c     0.7 to 10.  For larger p's, we can use usual 
c    exp probability.  
c
      subroutine cdecayWEL(pin, g, x)
      implicit none
      real*8 pin ! input.  see above. should be 0.1<pin<10.
      real*8 g  ! input.  E0/m.  1<= g 
      real*8 x ! output. sampled x.  decay length 'l' is related to this
               !           by x=g(1-al) where a is dE/dl/E0 (/m).
c
c     Method:  
c        If x > 5, we use p(x)=(2x)**p/x
c           x < 5, we use (2x)**p/x + 1/sqrt(2(x-1)) and rejection
c   To decide which side, we compare  int(x=1 to  5) of p(x)dx and
c                                     int(x=5 to g) of   (2x)**p/x 
c
c  if  g< 5,  we use rejection method only.
c
c    log( int(x=1 to 5)) is approximated by 4-th order polynomial:
c         sum c_i p**i  (i=0 to 4)
c
c
c    c0        .77099
c    c1        1.3470  
c    c2        .12049 
c    c3       -.57001E-02 
c
      real*4 int1, int2, ans, xm, tf, rf, p
      real*8 u
      
      p = pin
      if(p .gt. 10.) then
         call cerrorMsg('p> 10 for cdecayWEL', 0)
      endif
      if(g .gt. 5.) then
         if(p .le. 0.1d0) then
            ans = 0.771
         else
            ans =((-0.57001E-02*p + 0.12049  )*p+1.3470)*p
     *        +0.77099
         endif
         xm= 5.
c              int(1 to 5) of p(x)dx
         int1 = exp(ans)
c              int(5 to g) of p(x)dx~ (2x)**p/xdx
         int2 = 2.0**p/p * (g**p - xm**p)
      else
         int1 = 1.  ! dummy value
         int2 = 0.  ! //  so that int1 > int2
         xm = g
      endif
      call rndc(u)
      if(u  .lt. int1/(int1+int2)) then
c            use rejection.
c           integral of 1/sqrt(2(x-1)) from 1 go xm
       int1 = sqrt(2.0*(xm-1.0))
c           integral of (2x)**p/x from (1 to xm)
       int2 = 2.0**p/p *(xm**p-1.0)
       do while (.true.)
c
          call rndc(u)
          if(u .lt. int1 /(int1+int2)) then
c           use dx/sqrt(2(x-1))
             call rndc(u)
             x = (u*int1)**2/2.0+1.0
          else
c            use dx(2x)**p/x 
             call rndc(u)
             x =( p*int2*u/2.0**p+ 1.)**(1./p)
          endif
          call rndc(u)
          tf = 1./(x-sqrt(x*x-1.0))**p/sqrt(x*x-1.0)
          rf = (2.0*x)**p/x + 1.0/sqrt(2*(x-1.0))
          if(u .lt. tf/rf) goto 10
       enddo
 10    continue
      else
c         use (2x)**p/x dx
         call rndc(u)
         x =( p*int2*u/2.0**p+ xm**p)**(1./p)
      endif
      end
