c        This makes tables needed to compute geometrical
c      relations in the atmospher.
c        
c       For a  given zenith angle (its cos) direction
c         at a given vertical height
c         compute the ratio: 
c
c            (exact slant depth)
c            -------------------
c               approx one
c
c      approx one is by exponential atmosphere
c     with scale height 6.33km normalized to
c     have 1030 g/cm2 at height=0. (see caslantdep.f)
c
c  To comile this program, use:
c         make tbl1

c
c  *** note *** for the integration,  we use k16pGaussLeg
c    because  kdeinte1 dose not give good result.
c    (It's especially so, when h > 80 km and/or cosz ~ 0)
c------------------------------------------------------------
c      make table sdepratio1.d and 
c                 sdepratio2.d
c     by the following do loop index.
c
c     ***************************************
c         for the sdepratio1.d
c      dsqcos =sqrt(.6d0)/(ndiv-1)
c      sqcos =0.
c     ****************************************
c      do j =1, ndiv
c         cosz = sqcos**2
c         do h=- 5.d2, 12.001d3, 100.d0
c
c     ***************************************


c     ***************************************
c     ***************************************
c
      program atmostbl
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"

      real*8 h, cosz,  sqcos, dsqcos, dhlog, logh
      common /catmosc/ cosz, h
      real*8  ans, catmosrho
      logical ok
      integer  ndiv, j, i
      parameter (ndiv =15)
      real*8  L1, L2, eps/1.d-12/, ansx, caslantdep
      external catmosrho
      dsqcos =(.5999999999d0)**(1./4.d0)/(ndiv-1)
      sqcos =0.
c     ****************************************
      do j =1, ndiv
         cosz = sqcos**4
         logh = 3.75
         dhlog=.025d0
         do h=- 5.d2, 12.001d3, 200.d0
c         do while(logh .lt. log10(220.d3))
c     ****************************************
c            h = 10.d0 ** logh
            ans = 0.
            ok = .false.
            L2 = 0.
            i = 0
            do while(.not.ok)
               L1 = L2
               L2 = L1 + 500.d0
               call k16pGaussLeg(catmosrho, L1, L2, 10, ansx)
               ans = ans + ansx
               if(mod(i,1000) .eq. 0) write(0,*) ansx/ans, cosz
               ok = ansx/ans .le. eps
               i = i+1
            enddo

c            write(*, *) sngl(cosz),  sngl(sqcos),  sngl(logh),
            write(*, *) sngl(cosz),  sngl(sqcos),  sngl(h),
     *                  ans/caslantdep(h, cosz)
            logh = logh + dhlog
         enddo
         write(*, *)
         sqcos = sqcos + dsqcos
      enddo
      end
      real*8 function catmosrho(L)
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 L, cnewh
      real*8 h, cosz
      common /catmosc/ cosz, h
      real*8 cdenair, ch2dep, height
      height = cnewh(Eradius+h, cosz, L) - Eradius
      catmosrho = cdenair( ch2dep(height) )
      end
