c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c          test mfapsd:
c      implicit real*8 (a-h, o-z)
c
c     data re/6370.d5/
c     character*70 ttl
c     character*16 capx, capy, capz
c     real*4 cosz
c
c     capx='hight(cm)'
c     capy='slnt dep.*efcos'
c     capz='z/z0'
c     h2=150.d5
c     cosz=0.
c     do 1000 k=1, 1
c        sinz=sqrt(1.d0- cosz**2)
c        write(ttl,'(''cos='',f5.2)') cosz
c        write(13) ttl
c        write(13) capx, capy, capz
c        h=-1.d5
c        do 100 until (h .gt. 100.d5)
c          call mfapsd(cosz, h, z0)
c          call mfzbz0(cosz,sngl(h), zbz0)
c          efcos=sqrt(1.00005d0 - sinz/(1.d0+h/re)**2)
c          write(13) sngl(h ), sngl(z0*zbz0*efcos)
c          h=h+100.d3
c 100   continue
c       write(13) 1.e50, 1.e50, 1.e50
c       cosz=cosz+.02
c1000   continue
c      end
c      *****************************************************************
c      *    cvh2sdep:   get slant depth from vertical height
c      *****************************************************************
c                          /sd(slant depth)   
c                        / |
c                      / * |
c                    /   cosz
c                  /       |
c                /         |h  
c
c
c
       subroutine cvh2sdep(cosz, h, sd)
c          cosz: input. real*8. cos of the zenith angle at the point.
c             h: input. real*8. height(m) from sea level at point.
c            sd: output. real*8. slant depth along cosz direction(kg/m2)
c
             real*8 h, sd, ch2dep, z0
             if(cosz .lt. .5d0) then
                 call mfapsd(cosz, h, z0)
                 call mfzbz0(cosz,  h, zbz0)
c                write(*,*) ' h=',h,' z0=',z0, ' zbz0=',zbz0
                 sd=z0*zbz0
             else
                 sd=ch2dep(h)/cosz
             endif
        end
c      *****************************************************************
c      *
c      *  mfapsd: get slant depth by approximate formula for large
c      *          zenith angle
c      *
c  /usage/ call mfapsd(cosz, h, z)
c
c
       subroutine mfapsd(cosz, hin, z)
         implicit real*8 (a-h, o-z)
         parameter (re=6370.d5, rpi=1.7724538509055159d0, h0=6.33d5,
     *           rho0=1036.d0/h0, h2=150.d5, h210=h2*10.d0)
         logical first/.true./
c
c        *************
         real*4  cosz
c        *************
c
         if(first) then
             cnst=sqrt(re*h0/2)*rho0
             cnst2=re/2/h0
             first=.false.
c            write(*,*) ' cnst=',cnst, ' cnst2=',cnst2
         endif
c
         h=hin
         if(h .le. 0.) then
             z=50000.
         else
             sinz=sqrt(1.-cosz**2)
             tmp=re*cosz**2/2
             xsq=(h+tmp)/h0
             xsq2=(h2+tmp)/h0
             x=sqrt(xsq)
             x2=sqrt(xsq2)
c             write(*,*) ' x=',x, ' x2=',x2
             if(xsq .gt. 15.d0) then
                   if(tmp .gt. h210) then
                       xbx2=sqrt((1.d0+h/tmp)*(1.d0-h2/tmp))
                   else
                       xbx2=sqrt( (h+tmp)/(h2+tmp))
                   endif
                   z0= cnst* exp(-h/h0)/x* (1.-1./2/xsq- xbx2
     *                * exp(-(h2-h)/h0) *(1.-1./2/xsq2) )
              else
                   if(x2 .gt. 15.d0) then
                       f1=1.- exp(-xsq2)/rpi/x2
                   else
                       f1=erf(x2)
                   endif
                   f2=erf(x)
                   ff=rpi*(f1-f2)
                   z0=cnst*exp(cnst2*cosz**2)*ff
               endif
               z=z0
       endif
       end
c     character ttl*70, capx*16, capy*16
c     open(13, file='c2s5001.#gd.data')
c     cosz=0.
c     capx='h'
c     capy='z/z0'
c       do 10 i=1,12
c          write(ttl,'(''cos='',f5.2)') cosz
c          write(13) ttl
c          write(13) capx, capy
c          h=0
c          do 20 j=1,1000
c              call mfzbz0(cosz, h, zbz0)
c              write(13) h, zbz0
c              h=h+100.e2
c  20      continue
c          write(13) 1.e50, 1.e50
c          cosz=cosz+0.015
c  10   continue
c      end
c     *************************************************************
c     *
c     *   mfzbz0: get ratio of slant depths computed by exact
c     *           one and the approximate one (by mfapsd).
c     *           for large zenith angle
c
c     ********************* tested 88.08.23 *************k.k ******
c
      subroutine mfzbz0(cosz, hin, zbz0)
c           get ratio of z / z0 where z is the correct slant depth
c           and z0 the approximate slant depth obtained by mfapsd
c
c   cosz: input. real*4  cos of zenith angle at obseravation depth
c    hin: input. real*4  height in cm from the surface to the earth
c                 (not from the observation point).
c   zbz0: output. real*4 ratio of slant depth.  where slant depth is
c         the integral of air density from 150 km to h along the cosz
c
c        for h=0 to 5 km step 100 m
c        for cosz=0 to .2 step .01
      dimension zbz0a(51,21)
      dimension zbz01(51), zbz02(51),zbz03(51), zbz04(51), zbz05(51)
      dimension zbz06(51), zbz07(51),zbz08(51), zbz09(51), zbz10(51)
      dimension zbz11(51), zbz12(51),zbz13(51), zbz14(51), zbz15(51)
      dimension zbz16(51), zbz17(51),zbz18(51), zbz19(51), zbz20(51)
      dimension zbz21(51)
c
      equivalence (zbz0a(1,1), zbz01(1))
      equivalence (zbz0a(1,2), zbz02(1))
      equivalence (zbz0a(1,3), zbz03(1))
      equivalence (zbz0a(1,4), zbz04(1))
      equivalence (zbz0a(1,5), zbz05(1))
      equivalence (zbz0a(1,6), zbz06(1))
      equivalence (zbz0a(1,7), zbz07(1))
      equivalence (zbz0a(1,8), zbz08(1))
      equivalence (zbz0a(1,9), zbz09(1))
      equivalence (zbz0a(1,10), zbz10(1))
      equivalence (zbz0a(1,11), zbz11(1))
      equivalence (zbz0a(1,12), zbz12(1))
      equivalence (zbz0a(1,13), zbz13(1))
      equivalence (zbz0a(1,14), zbz14(1))
      equivalence (zbz0a(1,15), zbz15(1))
      equivalence (zbz0a(1,16), zbz16(1))
      equivalence (zbz0a(1,17), zbz17(1))
      equivalence (zbz0a(1,18), zbz18(1))
      equivalence (zbz0a(1,19), zbz19(1))
      equivalence (zbz0a(1,20), zbz20(1))
      equivalence (zbz0a(1,21), zbz21(1))
c
      data (zbz01 (i),i=   1,  51)/
     10.8898,0.9114,0.9220,0.9307,0.9386,0.9459,0.9527,0.9592,0.9655,
     20.9715,0.9774,0.9832,0.9888,0.9942,0.9996,1.0049,1.0101,1.0152,
     31.0202,1.0251,1.0300,1.0348,1.0396,1.0443,1.0489,1.0535,1.0581,
     41.0626,1.0670,1.0714,1.0757,1.0800,1.0842,1.0884,1.0926,1.0967,
     51.1007,1.1047,1.1087,1.1126,1.1165,1.1203,1.1241,1.1279,1.1316,
     61.1352,1.1388,1.1424,1.1459,1.1494,1.1529/
      data (zbz02 (i),i=   1,  51)/
     10.9185,0.9262,0.9334,0.9403,0.9468,0.9531,0.9591,0.9650,0.9708,
     20.9764,0.9819,0.9873,0.9926,0.9979,1.0030,1.0081,1.0131,1.0180,
     31.0229,1.0277,1.0325,1.0372,1.0418,1.0464,1.0509,1.0554,1.0599,
     41.0643,1.0686,1.0729,1.0772,1.0814,1.0856,1.0897,1.0938,1.0979,
     51.1019,1.1059,1.1098,1.1137,1.1175,1.1213,1.1250,1.1287,1.1324,
     61.1360,1.1396,1.1432,1.1467,1.1501,1.1535/
      data (zbz03 (i),i=   1,  51)/
     10.9390,0.9446,0.9500,0.9554,0.9608,0.9660,0.9712,0.9763,0.9813,
     20.9863,0.9913,0.9962,1.0010,1.0058,1.0106,1.0153,1.0199,1.0245,
     31.0291,1.0336,1.0381,1.0426,1.0470,1.0514,1.0557,1.0600,1.0643,
     41.0685,1.0727,1.0768,1.0810,1.0850,1.0891,1.0931,1.0970,1.1010,
     51.1048,1.1087,1.1125,1.1163,1.1200,1.1237,1.1274,1.1310,1.1346,
     61.1381,1.1416,1.1451,1.1485,1.1519,1.1552/
      data (zbz04 (i),i=   1,  51)/
     10.9537,0.9585,0.9634,0.9681,0.9729,0.9776,0.9822,0.9869,0.9915,
     20.9961,1.0006,1.0052,1.0096,1.0141,1.0185,1.0229,1.0273,1.0317,
     31.0360,1.0403,1.0445,1.0488,1.0530,1.0571,1.0613,1.0654,1.0694,
     41.0735,1.0775,1.0815,1.0854,1.0894,1.0933,1.0971,1.1009,1.1047,
     51.1085,1.1122,1.1159,1.1196,1.1232,1.1268,1.1303,1.1338,1.1373,
     61.1408,1.1442,1.1475,1.1509,1.1542,1.1574/
      data (zbz05 (i),i=   1,  51)/
     10.9644,0.9688,0.9733,0.9778,0.9822,0.9866,0.9910,0.9954,0.9998,
     21.0041,1.0084,1.0127,1.0170,1.0212,1.0254,1.0296,1.0338,1.0380,
     31.0421,1.0462,1.0503,1.0543,1.0584,1.0624,1.0664,1.0703,1.0743,
     41.0782,1.0820,1.0859,1.0897,1.0935,1.0973,1.1010,1.1047,1.1084,
     51.1120,1.1157,1.1192,1.1228,1.1263,1.1298,1.1333,1.1367,1.1401,
     61.1434,1.1467,1.1500,1.1533,1.1565,1.1597/
      data (zbz06 (i),i=   1,  51)/
     10.9721,0.9764,0.9807,0.9850,0.9893,0.9935,0.9977,1.0020,1.0062,
     21.0103,1.0145,1.0186,1.0228,1.0269,1.0309,1.0350,1.0391,1.0431,
     31.0471,1.0511,1.0550,1.0590,1.0629,1.0668,1.0707,1.0745,1.0783,
     41.0821,1.0859,1.0897,1.0934,1.0971,1.1007,1.1044,1.1080,1.1116,
     51.1151,1.1187,1.1222,1.1256,1.1291,1.1325,1.1359,1.1392,1.1425,
     61.1458,1.1490,1.1523,1.1554,1.1586,1.1617/
      data (zbz07 (i),i=   1,  51)/
     10.9779,0.9821,0.9863,0.9905,0.9946,0.9987,1.0029,1.0070,1.0111,
     21.0151,1.0192,1.0232,1.0273,1.0313,1.0353,1.0392,1.0432,1.0471,
     31.0511,1.0549,1.0588,1.0627,1.0665,1.0703,1.0741,1.0779,1.0816,
     41.0854,1.0890,1.0927,1.0964,1.1000,1.1036,1.1072,1.1107,1.1142,
     51.1177,1.1212,1.1246,1.1280,1.1314,1.1347,1.1381,1.1413,1.1446,
     61.1478,1.1510,1.1542,1.1573,1.1604,1.1634/
      data (zbz08 (i),i=   1,  51)/
     10.9823,0.9864,0.9905,0.9946,0.9987,1.0027,1.0068,1.0108,1.0148,
     21.0189,1.0228,1.0268,1.0308,1.0347,1.0386,1.0426,1.0464,1.0503,
     31.0542,1.0580,1.0618,1.0656,1.0694,1.0731,1.0769,1.0806,1.0843,
     41.0879,1.0916,1.0952,1.0988,1.1024,1.1059,1.1094,1.1129,1.1164,
     51.1198,1.1232,1.1266,1.1300,1.1333,1.1366,1.1399,1.1431,1.1463,
     61.1495,1.1526,1.1557,1.1588,1.1618,1.1649/
      data (zbz09 (i),i=   1,  51)/
     10.9856,0.9897,0.9938,0.9978,1.0018,1.0058,1.0098,1.0138,1.0178,
     21.0217,1.0257,1.0296,1.0335,1.0374,1.0413,1.0452,1.0490,1.0528,
     31.0566,1.0604,1.0642,1.0679,1.0717,1.0754,1.0791,1.0827,1.0864,
     41.0900,1.0936,1.0972,1.1007,1.1042,1.1078,1.1112,1.1147,1.1181,
     51.1215,1.1249,1.1282,1.1315,1.1348,1.1381,1.1413,1.1445,1.1477,
     61.1508,1.1539,1.1570,1.1601,1.1631,1.1660/
      data (zbz10(i),i=    1,  51)/
     10.9882,0.9923,0.9963,1.0003,1.0043,1.0082,1.0122,1.0162,1.0201,
     21.0240,1.0279,1.0318,1.0357,1.0395,1.0434,1.0472,1.0510,1.0548,
     31.0586,1.0623,1.0661,1.0698,1.0735,1.0772,1.0808,1.0844,1.0881,
     41.0916,1.0952,1.0988,1.1023,1.1058,1.1092,1.1127,1.1161,1.1195,
     51.1229,1.1262,1.1295,1.1328,1.1361,1.1393,1.1425,1.1457,1.1488,
     61.1519,1.1550,1.1581,1.1611,1.1641,1.1670/
      data (zbz11(i),i=    1,  51)/
     10.9903,0.9943,0.9983,1.0023,1.0062,1.0102,1.0141,1.0180,1.0219,
     21.0258,1.0297,1.0336,1.0374,1.0412,1.0451,1.0489,1.0526,1.0564,
     31.0602,1.0639,1.0676,1.0713,1.0750,1.0786,1.0822,1.0858,1.0894,
     41.0930,1.0965,1.1000,1.1035,1.1070,1.1105,1.1139,1.1173,1.1206,
     51.1240,1.1273,1.1306,1.1339,1.1371,1.1403,1.1435,1.1466,1.1497,
     61.1528,1.1559,1.1589,1.1619,1.1649,1.1678/
      data (zbz12(i),i=    1,  51)/
     10.9920,0.9959,0.9999,1.0038,1.0078,1.0117,1.0156,1.0195,1.0234,
     21.0273,1.0311,1.0350,1.0388,1.0426,1.0464,1.0502,1.0540,1.0577,
     31.0614,1.0651,1.0688,1.0725,1.0761,1.0798,1.0834,1.0870,1.0905,
     41.0941,1.0976,1.1011,1.1046,1.1080,1.1114,1.1148,1.1182,1.1216,
     51.1249,1.1282,1.1315,1.1347,1.1379,1.1411,1.1443,1.1474,1.1505,
     61.1536,1.1566,1.1596,1.1626,1.1655,1.1684/
      data (zbz13(i),i=    1,  51)/
     10.9933,0.9972,1.0012,1.0051,1.0090,1.0130,1.0169,1.0207,1.0246,
     21.0285,1.0323,1.0361,1.0399,1.0437,1.0475,1.0513,1.0550,1.0588,
     31.0625,1.0662,1.0698,1.0735,1.0771,1.0807,1.0843,1.0879,1.0914,
     41.0950,1.0985,1.1019,1.1054,1.1088,1.1123,1.1156,1.1190,1.1223,
     51.1256,1.1289,1.1322,1.1354,1.1386,1.1418,1.1449,1.1480,1.1511,
     61.1542,1.1572,1.1602,1.1632,1.1661,1.1690/
      data (zbz14(i),i=    1,  51)/
     10.9944,0.9983,1.0023,1.0062,1.0101,1.0140,1.0179,1.0217,1.0256,
     21.0294,1.0333,1.0371,1.0409,1.0447,1.0484,1.0522,1.0559,1.0596,
     31.0633,1.0670,1.0707,1.0743,1.0779,1.0815,1.0851,1.0886,1.0922,
     41.0957,1.0992,1.1027,1.1061,1.1095,1.1129,1.1163,1.1196,1.1230,
     51.1263,1.1295,1.1328,1.1360,1.1392,1.1423,1.1455,1.1486,1.1517,
     61.1547,1.1577,1.1607,1.1636,1.1666,1.1694/
      data (zbz15(i),i=    1,  51)/
     10.9953,0.9992,1.0031,1.0071,1.0110,1.0148,1.0187,1.0226,1.0264,
     21.0303,1.0341,1.0379,1.0417,1.0454,1.0492,1.0529,1.0566,1.0603,
     31.0640,1.0677,1.0713,1.0750,1.0786,1.0822,1.0857,1.0893,1.0928,
     41.0963,1.0998,1.1033,1.1067,1.1101,1.1135,1.1169,1.1202,1.1235,
     51.1268,1.1301,1.1333,1.1365,1.1397,1.1428,1.1459,1.1490,1.1521,
     61.1551,1.1581,1.1611,1.1640,1.1669,1.1698/
      data (zbz16(i),i=    1,  51)/
     10.9960,1.0000,1.0039,1.0078,1.0117,1.0156,1.0194,1.0233,1.0271,
     21.0309,1.0347,1.0385,1.0423,1.0461,1.0498,1.0535,1.0573,1.0610,
     31.0646,1.0683,1.0719,1.0755,1.0791,1.0827,1.0863,1.0898,1.0933,
     41.0968,1.1003,1.1038,1.1072,1.1106,1.1140,1.1173,1.1206,1.1240,
     51.1272,1.1305,1.1337,1.1369,1.1401,1.1432,1.1463,1.1494,1.1525,
     61.1555,1.1585,1.1614,1.1644,1.1673,1.1701/
      data (zbz17(i),i=    1,  51)/
     10.9967,1.0006,1.0045,1.0084,1.0123,1.0162,1.0200,1.0239,1.0277,
     21.0315,1.0353,1.0391,1.0429,1.0466,1.0504,1.0541,1.0578,1.0615,
     31.0651,1.0688,1.0724,1.0760,1.0796,1.0832,1.0867,1.0903,1.0938,
     41.0973,1.1007,1.1042,1.1076,1.1110,1.1144,1.1177,1.1210,1.1243,
     51.1276,1.1308,1.1341,1.1373,1.1404,1.1436,1.1467,1.1497,1.1528,
     61.1558,1.1588,1.1617,1.1647,1.1676,1.1704/
      data (zbz18(i),i=    1,  51)/
     10.9972,1.0011,1.0050,1.0089,1.0128,1.0167,1.0205,1.0244,1.0282,
     21.0320,1.0358,1.0396,1.0433,1.0471,1.0508,1.0545,1.0582,1.0619,
     31.0656,1.0692,1.0728,1.0764,1.0800,1.0836,1.0871,1.0907,1.0942,
     41.0976,1.1011,1.1045,1.1113,1.1146,1.1180,1.1214,1.1247,1.1280,
     51.1312,1.1345,1.1377,1.1409,1.1440,1.1472,1.1503,1.1533,1.1564,
     61.1594,1.1624,1.1653,1.1682,1.1711,1.1740/
      data (zbz19(i),i=    1,  51)/
     11.0002,1.0041,1.0080,1.0119,1.0158,1.0197,1.0235,1.0274,1.0312,
     21.0350,1.0388,1.0426,1.0463,1.0501,1.0538,1.0575,1.0612,1.0649,
     31.0686,1.0722,1.0758,1.0794,1.0830,1.0866,1.0901,1.0936,1.0971,
     41.1006,1.1041,1.1075,1.1109,1.1143,1.1177,1.1210,1.1243,1.1276,
     51.1309,1.1341,1.1373,1.1405,1.1437,1.1468,1.1499,1.1530,1.1560,
     61.1590,1.1620,1.1649,1.1678,1.1707,1.1736/
      data (zbz20(i),i=   1,  51)/
     11.0002,1.0041,1.0080,1.0118,1.0157,1.0196,1.0234,1.0273,1.0311,
     21.0349,1.0387,1.0424,1.0462,1.0499,1.0537,1.0574,1.0611,1.0647,
     31.0684,1.0720,1.0757,1.0793,1.0828,1.0864,1.0899,1.0935,1.0969,
     41.1004,1.1039,1.1073,1.1107,1.1141,1.1175,1.1208,1.1241,1.1274,
     51.1306,1.1339,1.1371,1.1402,1.1434,1.1465,1.1496,1.1527,1.1557,
     61.1587,1.1617,1.1646,1.1675,1.1704,1.1733/
      data (zbz21(i),i=   1,  51)/
     11.0001,1.0040,1.0079,1.0118,1.0157,1.0195,1.0234,1.0272,1.0310,
     21.0348,1.0386,1.0424,1.0461,1.0499,1.0536,1.0573,1.0610,1.0646,
     31.0683,1.0719,1.0756,1.0791,1.0827,1.0863,1.0898,1.0933,1.0968,
     41.1003,1.1037,1.1072,1.1106,1.1139,1.1173,1.1206,1.1239,1.1272,
     51.1305,1.1337,1.1369,1.1401,1.1432,1.1463,1.1494,1.1525,1.1555,
     61.1585,1.1615,1.1644,1.1673,1.1702,1.1730/
c
c     for h=5 km to 10 km step 500 m
c     for cosz=0 to .2 step .02
c
      dimension zbz0b(11, 11)
      dimension zbzb1(11), zbzb2(11), zbzb3(11), zbzb4(11)
      dimension zbzb5(11), zbzb6(11), zbzb7(11), zbzb8(11)
      dimension zbzb9(11), zbzb10(11), zbzb11(11)
c
      equivalence (zbz0b(1,1), zbzb1(1))
      equivalence (zbz0b(1,2), zbzb2(1))
      equivalence (zbz0b(1,3), zbzb3(1))
      equivalence (zbz0b(1,4), zbzb4(1))
      equivalence (zbz0b(1,5), zbzb5(1))
      equivalence (zbz0b(1,6), zbzb6(1))
      equivalence (zbz0b(1,7), zbzb7(1))
      equivalence (zbz0b(1,8), zbzb8(1))
      equivalence (zbz0b(1,9), zbzb9(1))
      equivalence (zbz0b(1,10), zbzb10(1))
      equivalence (zbz0b(1,11), zbzb11(1))
      data (zbzb1 (i),i=   1,  11)/
     11.1529,1.1694,1.1847,1.1989,1.2118,1.2234,1.2337,1.2426,1.2500,
     21.2558,1.2601/
      data (zbzb2 (i),i=   1,  11)/
     11.1552,1.1713,1.1863,1.2001,1.2128,1.2242,1.2342,1.2430,1.2502,
     21.2560,1.2603/
      data (zbzb3 (i),i=   1,  11)/
     11.1597,1.1750,1.1893,1.2026,1.2147,1.2257,1.2354,1.2438,1.2508,
     21.2564,1.2605/
      data (zbzb4 (i),i=   1,  11)/
     11.1634,1.1782,1.1919,1.2047,1.2165,1.2271,1.2365,1.2446,1.2514,
     21.2568,1.2608/
      data (zbzb5 (i),i=   1,  11)/
     11.1660,1.1804,1.1939,1.2063,1.2178,1.2281,1.2373,1.2452,1.2518,
     21.2571,1.2610/
      data (zbzb6 (i),i=   1,  11)/
     11.1678,1.1819,1.1951,1.2074,1.2187,1.2288,1.2378,1.2456,1.2522,
     21.2573,1.2611/
      data (zbzb7 (i),i=   1,  11)/
     11.1690,1.1830,1.1960,1.2082,1.2193,1.2293,1.2382,1.2459,1.2524,
     21.2575,1.2613/
      data (zbzb8 (i),i=   1,  11)/
     11.1698,1.1837,1.1967,1.2087,1.2197,1.2297,1.2385,1.2461,1.2525,
     21.2576,1.2613/
      data (zbzb9 (i),i=   1,  11)/
     11.1704,1.1842,1.1971,1.2091,1.2200,1.2299,1.2387,1.2463,1.2527,
     21.2577,1.2614/
      data (zbzb10(i),i=   1,  11)/
     11.1736,1.1873,1.2002,1.2121,1.2230,1.2329,1.2416,1.2491,1.2555,
     21.2605,1.2641/
      data (zbzb11(i),i=   1,  11)/
     11.1730,1.1867,1.1996,1.2114,1.2223,1.2321,1.2409,1.2484,1.2547,
     21.2597,1.2633/
c
      dimension vw1(50), vw2(50), ha1(51), cosa1(21), ha2(11),cosa2(11)
      data isw1/0/, isw2/0/
      logical first/.true./
c
      if(first) then
         hx=0.
          do   i=1, 51
            if(i .eq. 51) hx=5.e5
            ha1(i)=hx
            hx=hx+100.e2
          enddo
         cs=0.
          do   i=1,21
            if(i .eq. 21) cs=.2
            cosa1(i)=cs
            cs=cs+.01
          enddo
c
         hx=5.e5
          do   i=1, 11
            if(i .eq. 11) hx=10.e5
            ha2(i)=hx
            hx=hx+500.e2
          enddo
         cs=0.
          do   i=1,11
            if(i .eq. 11) cs=.2
            cosa2(i)=cs
            cs=cs+.02
          enddo
         first=.false.
      endif
c
      cs=min(cosz, .2)
c        for practical reason, only h>=0 is treated.
      h=max(hin, 0.)
c$$$$$$$$$$$$$$$$$$
c      if(h .eq. 0.) then
c         write(*,*) ' hin=',hin
c      endif
c$$$$$$$$$$$$$$$$$$$$$$$
      if(h .lt. 5.e5) then
          ix=h/100.e2 +1
          iy=cs/.01 +1
          isw1=0
          call akmid(ha1, 51, cosa1, 21, zbz0a,  51, isw1, h,  ix,
     *    cs, iy, zbz0, vw1, jcon)
          if(jcon .gt. 10000) then
              write(*,*) ' error in mfaira-1; icon=',jcon
          endif
       elseif(h .lt. 10.e5)then
          ix=h/500.e2 +1
          iy=cs/.02 +1
          isw2=0
          call akmid(ha2, 11, cosa2, 11, zbz0b,  11, isw2, h,  ix,
     *    cs, iy, zbz0, vw2, jcon)
c$$$$$$$$$$$
          if(zbz0 .lt. 0.) then
              write(*,*) ' zbz0=', zbz0, ' h=',h, ' cs=',cs
              write(*,*) ' ha2=',ha2, ' cosa2=',cosa2, ' ix=',ix,
     *        ' iy=',iy
              write(*,*) ' zbz0b=',zbz0b
          endif
c$$$$$$$$$$$
          if(jcon .gt. 10000) then
              write(*,*) ' error in mfaira-2; icon=',jcon
          endif
          iprev=2
       elseif(h .lt. 11.e5) then
c         zbz0=(1.2653-1.2633)/1.e5*(h-10.e5) + 1.2633
          zbz0=2.0e-8*(h-10.e5) + 1.2633
       else
          zbz0=1.2653
       endif
      end
      subroutine mfefcs(sinz, h, efcos)
c         to get effective cosine for sin of zenith angle sinz
c         at observation depth
c   sinz: input.  sin of zenith at observation depth
c      h: input.  height where effecitve cos is computed. this is
c         on the slant line with the given zenith angle.
c  efcos: effective cos at h (due to earth curverture, different from
c         zenith at observation depth.
c         for 90 degree, 0 is avoided at h=0 to have non zero z*efcos
c         at h=0.)
       implicit real*8 (a-h, o-z)
       parameter (re=6370.d5)
       real*4 sinz, efcos
       tmp=h/re
       if(tmp .lt. 1.d-5) then
           efcos=sqrt( 1.00005d0 -sinz*(1.d0-2* tmp))
       else
           efcos=sqrt(1.00005d0 - sinz/(1.d0+tmp)**2)
       endif
      end
c         to test mfsdth
c      character ttl*70, capx*16, capy*16
c      real*8 h
c      open(13,file='c2s5001.#gd.data')
c      capx='z(g/cm2)'
c      capy='h(cm)'
c      cosz=0.0
c      do 100 i=1, 10
c          write(ttl,'(''cosz='',f6.2)') cosz
c          write(13) ttl
c          write(13) capx, capy
c          z=10000.
c          do 200 until (z .gt.36000..or. h .lt. 0.)
c              call mfsdth(cosz, z, h)
c              write(13) z, sngl(h)
c              z=z *10.**0.01
c 200      continue
c          write(13) 1.e50, 1.e50
c          cosz=cosz+.01
c          if(cosz .gt. .5) cosz=.5
c 100  continue
c      end
c     ****************************************************************
c     *
c     *  mfsdth: slant depth to h converstion
c     *          for cosz <= 0.5.
c     *
c     ********************* tested 88.08.23 *************k.k**********
c  /usage/  call mfsdth(cosz, z, h)
c     cosz: input. real*4  cos of zenith
c        z: input. real*4  slant depth along zenith angle (g/cm**2)
c        h: output. real*8 vertical hight in cm at z
c
      subroutine mfsdth(cosz, z, h)
       real*8 h
c
c    for z<100
c          cosz=0 to .5 step .1.  at100= h value at z=100
c                                 tn= tangent
       dimension at100(6), tn(6)
       data at100/3.04e6, 2.85e6, 2.57e6, 2.36e6, 2.19e6, 2.06e6/
       data tn/1.38e6, 1.4067e6, 1.4367e6, 1.443e6, 1.453e6, 1.453e6/
c
c         for  100<z<2000 and. cosz < .5
c        log10(z)=2 to 3.40  step .1
c
       dimension ztoha(15, 6)
       dimension ztoh1(15), ztoh2(15), ztoh3(15), ztoh4(15), ztoh5(15),
     *           ztoh6(15)
       equivalence (ztoha(1,1),ztoh1(1))
       equivalence (ztoha(1,2),ztoh2(1))
       equivalence (ztoha(1,3),ztoh3(1))
       equivalence (ztoha(1,4),ztoh4(1))
       equivalence (ztoha(1,5),ztoh5(1))
       equivalence (ztoha(1,6),ztoh6(1))
      data (ztoh1 (i),i=   1,  15)/
     1 0.30472e+07, 0.29134e+07, 0.27802e+07, 0.26474e+07, 0.25151e+07,
     2 0.23835e+07, 0.22524e+07, 0.21220e+07, 0.19923e+07, 0.18635e+07,
     3 0.17355e+07, 0.16086e+07, 0.14827e+07, 0.13580e+07, 0.12348e+07/
      data (ztoh2 (i),i=   1,  15)/
     1 0.28552e+07, 0.27160e+07, 0.25771e+07, 0.24382e+07, 0.22996e+07,
     2 0.21610e+07, 0.20227e+07, 0.18845e+07, 0.17465e+07, 0.16087e+07,
     3 0.14711e+07, 0.13337e+07, 0.11966e+07, 0.10594e+07, 0.91832e+06/
      data (ztoh3 (i),i=   1,  15)/
     1 0.25779e+07, 0.24348e+07, 0.22918e+07, 0.21489e+07, 0.20059e+07,
     2 0.18630e+07, 0.17201e+07, 0.15772e+07, 0.14344e+07, 0.12916e+07,
     3 0.11488e+07, 0.10048e+07, 0.85497e+06, 0.69888e+06, 0.53624e+06/
      data (ztoh4 (i),i=   1,  15)/
     1 0.23605e+07, 0.22161e+07, 0.20716e+07, 0.19272e+07, 0.17828e+07,
     2 0.16384e+07, 0.14940e+07, 0.13496e+07, 0.12052e+07, 0.10606e+07,
     3 0.91139e+06, 0.75581e+06, 0.59353e+06, 0.42430e+06, 0.24782e+06/
      data (ztoh5 (i),i=   1,  15)/
     1 0.21926e+07, 0.20475e+07, 0.19025e+07, 0.17575e+07, 0.16124e+07,
     2 0.14674e+07, 0.13224e+07, 0.11774e+07, 0.10317e+07, 0.88058e+06,
     3 0.72294e+06, 0.55848e+06, 0.38690e+06, 0.20792e+06,  21199.    /
      data (ztoh6 (i),i=   1,  15)/
     1 0.20578e+07, 0.19124e+07, 0.17671e+07, 0.16218e+07, 0.14764e+07,
     2 0.13311e+07, 0.11858e+07, 0.10399e+07, 0.88885e+06, 0.73122e+06,
     3 0.56675e+06, 0.39513e+06, 0.21607e+06,  29235.    ,-0.16570e+06/
       data iswa/0/
       dimension vwa(50), za(15), csa(6)
       data za/2., 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9,
     *         3.0, 3.1, 3.2, 3.3, 3.4/
       data csa/0., .1, .2, .3, .4, .5/
c
      dimension ztohb(30,11)
      dimension zhb1(30), zhb2(30), zhb3(30), zhb4(30), zhb5(30)
      dimension zhb6(30), zhb7(30), zhb8(30), zhb9(30)
      dimension zhb10(30), zhb11(30)
       equivalence (ztohb(1,1), zhb1(1))
       equivalence (ztohb(1,2), zhb2(1))
       equivalence (ztohb(1,3), zhb3(1))
       equivalence (ztohb(1,4), zhb4(1))
       equivalence (ztohb(1,5), zhb5(1))
       equivalence (ztohb(1,6), zhb6(1))
       equivalence (ztohb(1,7), zhb7(1))
       equivalence (ztohb(1,8), zhb8(1))
       equivalence (ztohb(1,9), zhb9(1))
       equivalence (ztohb(1,10), zhb10(1))
       equivalence (ztohb(1,11), zhb11(1))
       data iswb/0/
       dimension vwb(50), zb(30), csb(11)
       data zb/3.275, 3.30, 3.325, 3.35, 3.375, 3.4, 3.425, 3.45,
     *    3.475, 3.5, 3.525, 3.55, 3.575, 3.6, 3.625, 3.65, 3.675,
     *    3.70, 3.725, 3.75, 3.775, 3.8, 3.825, 3.85, 3.875, 3.9,
     *    3.925, 3.95, 3.975, 4./
       data csb/0., 0.05, 0.1, .15, .2, .25, .3, .35, .4, .45, .5/
c
      data (zhb1  (i),i=   1,  30)/
     1 0.13740e+07, 0.13462e+07, 0.13181e+07, 0.12896e+07, 0.12608e+07,
     2 0.12317e+07, 0.12024e+07, 0.11728e+07, 0.11430e+07, 0.11130e+07,
     3 0.10829e+07, 0.10525e+07, 0.10221e+07, 0.99150e+06, 0.96079e+06,
     4 0.92998e+06, 0.89906e+06, 0.86806e+06, 0.83699e+06, 0.80586e+06,
     5 0.77469e+06, 0.74349e+06, 0.71229e+06, 0.68110e+06, 0.64993e+06,
     6 0.61883e+06, 0.58780e+06, 0.55688e+06, 0.52609e+06, 0.49547e+06/
      data (zhb2  (i),i=   1,  30)/
     1 0.12821e+07, 0.12516e+07, 0.12207e+07, 0.11896e+07, 0.11581e+07,
     2 0.11263e+07, 0.10942e+07, 0.10619e+07, 0.10293e+07, 0.99649e+06,
     3 0.96344e+06, 0.93015e+06, 0.89662e+06, 0.86287e+06, 0.82889e+06,
     4 0.79469e+06, 0.76027e+06, 0.72565e+06, 0.69082e+06, 0.65578e+06,
     5 0.62056e+06, 0.58515e+06, 0.54955e+06, 0.51379e+06, 0.47786e+06,
     6 0.44178e+06, 0.40555e+06, 0.36919e+06, 0.33271e+06, 0.29612e+06/
      data (zhb3  (i),i=   1,  30)/
     1 0.10938e+07, 0.10594e+07, 0.10246e+07, 0.98951e+06, 0.95408e+06,
     2 0.91831e+06, 0.88221e+06, 0.84577e+06, 0.80899e+06, 0.77187e+06,
     3 0.73442e+06, 0.69662e+06, 0.65848e+06, 0.61999e+06, 0.58116e+06,
     4 0.54198e+06, 0.50246e+06, 0.46259e+06, 0.42237e+06, 0.38180e+06,
     5 0.34087e+06, 0.29960e+06, 0.25798e+06, 0.21601e+06, 0.17368e+06,
     6 0.13100e+06,  87973.    ,  44590.    ,  857.76    , -43186.    /
      data (zhb4  (i),i=   1,  30)/
     1 0.90489e+06, 0.86752e+06, 0.82978e+06, 0.79166e+06, 0.75315e+06,
     2 0.71426e+06, 0.67498e+06, 0.63530e+06, 0.59523e+06, 0.55477e+06,
     3 0.51390e+06, 0.47262e+06, 0.43094e+06, 0.38885e+06, 0.34635e+06,
     4 0.30343e+06, 0.26008e+06, 0.21632e+06, 0.17213e+06, 0.12751e+06,
     5  82451.    ,  36959.    , -8966.7    , -55266.    ,-0.10184e+06,
     6-0.14858e+06,-0.19538e+06,-0.24214e+06,-0.28876e+06,-0.33514e+06/
      data (zhb5  (i),i=   1,  30)/
     1 0.73849e+06, 0.69887e+06, 0.65883e+06, 0.61838e+06, 0.57751e+06,
     2 0.53622e+06, 0.49451e+06, 0.45237e+06, 0.40980e+06, 0.36679e+06,
     3 0.32334e+06, 0.27945e+06, 0.23510e+06, 0.19031e+06, 0.14505e+06,
     4  99338.    ,  53159.    ,  6509.7    , -40572.    , -87981.    ,
     5-0.13561e+06,-0.18333e+06,-0.23106e+06,-0.27866e+06,-0.32603e+06,
     6-0.37306e+06,-0.41963e+06,-0.46564e+06,-0.51097e+06,-0.55552e+06/
      data (zhb6  (i),i=   1,  30)/
     1 0.59398e+06, 0.55253e+06, 0.51065e+06, 0.46833e+06, 0.42557e+06,
     2 0.38236e+06, 0.33870e+06, 0.29459e+06, 0.25001e+06, 0.20497e+06,
     3 0.15946e+06, 0.11348e+06,  67025.    ,  20084.    , -27325.    ,
     4 -75105.    ,-0.12314e+06,-0.17131e+06,-0.21950e+06,-0.26760e+06,
     5-0.31549e+06,-0.36305e+06,-0.41017e+06,-0.45674e+06,-0.50262e+06,
     6-0.54772e+06,-0.63438e+06,-0.68812e+06,-0.74235e+06,-0.79707e+06/
      data (zhb7  (i),i=   1,  30)/
     1 0.46727e+06, 0.42429e+06, 0.38086e+06, 0.33698e+06, 0.29263e+06,
     2 0.24781e+06, 0.20253e+06, 0.15676e+06, 0.11052e+06,  63789.    ,
     3  16569.    , -31122.    , -79180.    ,-0.12749e+06,-0.17592e+06,
     4-0.22437e+06,-0.27271e+06,-0.32082e+06,-0.36859e+06,-0.41589e+06,
     5-0.46261e+06,-0.50863e+06,-0.55383e+06,-0.64226e+06,-0.69639e+06,
     6-0.75102e+06,-0.80615e+06,-0.86177e+06,-0.91788e+06,-0.97449e+06/
      data (zhb8  (i),i=   1,  30)/
     1 0.35467e+06, 0.31037e+06, 0.26561e+06, 0.22037e+06, 0.17466e+06,
     2 0.12846e+06,  81769.    ,  34586.    , -13088.    , -61178.    ,
     3-0.10956e+06,-0.15812e+06,-0.20674e+06,-0.25529e+06,-0.30365e+06,
     4-0.35171e+06,-0.39934e+06,-0.44642e+06,-0.49284e+06,-0.53847e+06,
     5-0.62417e+06,-0.67834e+06,-0.73300e+06,-0.78816e+06,-0.84383e+06,
     6-0.89999e+06,-0.95665e+06,-0.10138e+07,-0.10715e+07,-0.11296e+07/
      data (zhb9  (i),i=   1,  30)/
     1 0.25336e+06, 0.20790e+06, 0.16196e+06, 0.11553e+06,  68609.    ,
     2  21188.    , -26717.    , -75006.    ,-0.12356e+06,-0.17225e+06,
     3-0.22096e+06,-0.26957e+06,-0.31796e+06,-0.36600e+06,-0.41358e+06,
     4-0.46057e+06,-0.50685e+06,-0.55230e+06,-0.64097e+06,-0.69541e+06,
     5-0.75037e+06,-0.80582e+06,-0.86177e+06,-0.91823e+06,-0.97519e+06,
     6-0.10326e+07,-0.10906e+07,-0.11491e+07,-0.12080e+07,-0.12675e+07/
      data (zhb10 (i),i=   1,  30)/
     1 0.16123e+06, 0.11473e+06,  67726.    ,  20227.    , -27757.    ,
     2 -76124.    ,-0.12475e+06,-0.17352e+06,-0.22230e+06,-0.27098e+06,
     3-0.31942e+06,-0.36752e+06,-0.41515e+06,-0.46218e+06,-0.50850e+06,
     4-0.55397e+06,-0.64314e+06,-0.69770e+06,-0.75276e+06,-0.80833e+06,
     5-0.86440e+06,-0.92097e+06,-0.97805e+06,-0.10356e+07,-0.10937e+07,
     6-0.11523e+07,-0.12114e+07,-0.12710e+07,-0.13311e+07,-0.13917e+07/
      data (zhb11 (i),i=   1,  30)/
     1  76676.    ,  29222.    , -18727.    , -67083.    ,-0.11572e+06,
     2-0.16452e+06,-0.21336e+06,-0.26212e+06,-0.31067e+06,-0.35889e+06,
     3-0.40666e+06,-0.45385e+06,-0.50035e+06,-0.54602e+06,-0.63369e+06,
     4-0.68822e+06,-0.74326e+06,-0.79880e+06,-0.85485e+06,-0.91141e+06,
     5-0.96847e+06,-0.10260e+07,-0.10841e+07,-0.11427e+07,-0.12018e+07,
     6-0.12614e+07,-0.13215e+07,-0.13821e+07,-0.14432e+07,-0.15048e+07/
c
c
      dimension ztohc(34, 6)
      dimension zhc1(34), zhc2(34), zhc3(34), zhc4(34), zhc5(34)
      dimension zhc6(34)
       equivalence (ztohc(1,1), zhc1(1))
       equivalence (ztohc(1,2), zhc2(1))
       equivalence (ztohc(1,3), zhc3(1))
       equivalence (ztohc(1,4), zhc4(1))
       equivalence (ztohc(1,5), zhc5(1))
       equivalence (ztohc(1,6), zhc6(1))
       data iswc/0/
       dimension vwc(50), zc(34), csc( 6)
      data  zc/
     14.000,4.015,4.030,4.045,4.060,4.075,4.090,4.105,4.120,4.135,4.150,
     24.165,4.180,4.195,4.210,4.225,4.240,4.255,4.270,4.285,4.300,4.315,
     34.330,4.345,4.360,4.375,4.390,4.405,4.420,4.435,4.450,4.465,4.480,
     44.495/
       data csc/0., 0.02, 0.04, 0.06, .08, .1/
c
      data (zhc1  (i),i=   1,  34)/
     1 0.49546e+06, 0.47718e+06, 0.45898e+06, 0.44087e+06, 0.42286e+06,
     2 0.40496e+06, 0.38717e+06, 0.36951e+06, 0.35199e+06, 0.33463e+06,
     3 0.31742e+06, 0.30039e+06, 0.28355e+06, 0.26692e+06, 0.25051e+06,
     4 0.23435e+06, 0.21844e+06, 0.20281e+06, 0.18748e+06, 0.17247e+06,
     5 0.15781e+06, 0.14353e+06, 0.12965e+06, 0.11621e+06, 0.10324e+06,
     6  90769.    ,  78848.    ,  67518.    ,  56826.    ,  46827.    ,
     7  37577.    ,  29143.    ,  21594.    ,  10011.    /
      data (zhc2  (i),i=   1,  34)/
     1 0.45746e+06, 0.43839e+06, 0.41937e+06, 0.40042e+06, 0.38153e+06,
     2 0.36272e+06, 0.34399e+06, 0.32536e+06, 0.30682e+06, 0.28840e+06,
     3 0.27010e+06, 0.25193e+06, 0.23390e+06, 0.21603e+06, 0.19833e+06,
     4 0.18082e+06, 0.16350e+06, 0.14639e+06, 0.12952e+06, 0.11290e+06,
     5  96537.    ,  80468.    ,  64709.    ,  49285.    ,  34220.    ,
     6  19544.    ,  5284.4    , -8523.9    , -21841.    , -34619.    ,
     7 -46803.    , -58329.    , -69125.    , -79114.    /
      data (zhc3  (i),i=   1,  34)/
     1 0.35876e+06, 0.33783e+06, 0.31688e+06, 0.29594e+06, 0.27501e+06,
     2 0.25408e+06, 0.23317e+06, 0.21228e+06, 0.19141e+06, 0.17058e+06,
     3 0.14978e+06, 0.12902e+06, 0.10832e+06,  87675.    ,  67094.    ,
     4  46586.    ,  26159.    ,  5821.3    , -14417.    , -34545.    ,
     5 -54555.    , -74436.    , -94177.    ,-0.11377e+06,-0.13320e+06,
     6-0.15247e+06,-0.17155e+06,-0.19045e+06,-0.20915e+06,-0.22764e+06,
     7-0.24591e+06,-0.26395e+06,-0.28176e+06,-0.29931e+06/
      data (zhc4  (i),i=   1,  34)/
     1 0.22911e+06, 0.20606e+06, 0.18294e+06, 0.15977e+06, 0.13655e+06,
     2 0.11328e+06,  89956.    ,  66589.    ,  43179.    ,  19730.    ,
     3 -3756.9    , -27277.    , -50825.    , -74399.    , -97995.    ,
     4-0.12161e+06,-0.14523e+06,-0.16887e+06,-0.19251e+06,-0.21615e+06,
     5-0.23978e+06,-0.26341e+06,-0.28703e+06,-0.31063e+06,-0.33422e+06,
     6-0.35778e+06,-0.38131e+06,-0.40481e+06,-0.42828e+06,-0.45170e+06,
     7-0.47509e+06,-0.49842e+06,-0.52171e+06,-0.54493e+06/
      data (zhc5  (i),i=   1,  34)/
     1  91244.    ,  66261.    ,  41179.    ,  16003.    , -9270.7    ,
     2 -34638.    , -60098.    , -85647.    ,-0.11128e+06,-0.13701e+06,
     3-0.16282e+06,-0.18871e+06,-0.21468e+06,-0.24072e+06,-0.26685e+06,
     4-0.29304e+06,-0.31931e+06,-0.34565e+06,-0.37206e+06,-0.39853e+06,
     5-0.42507e+06,-0.45167e+06,-0.47832e+06,-0.50504e+06,-0.53181e+06,
     6-0.55864e+06,-0.58551e+06,-0.61244e+06,-0.63942e+06,-0.66644e+06,
     7-0.69350e+06,-0.72060e+06,-0.74775e+06,-0.77493e+06/
      data (zhc6  (i),i=   1,  34)/
     1 -43247.    , -69863.    , -96602.    ,-0.12346e+06,-0.15044e+06,
     2-0.17755e+06,-0.20476e+06,-0.23210e+06,-0.25956e+06,-0.28712e+06,
     3-0.31481e+06,-0.34260e+06,-0.37051e+06,-0.39853e+06,-0.42665e+06,
     4-0.45489e+06,-0.48323e+06,-0.51168e+06,-0.54023e+06,-0.56889e+06,
     5-0.59765e+06,-0.62651e+06,-0.65547e+06,-0.68453e+06,-0.71369e+06,
     6-0.74294e+06,-0.77229e+06,-0.80174e+06,-0.83128e+06,-0.86091e+06,
     7-0.89063e+06,-0.92045e+06,-0.95035e+06,-0.98034e+06/
c
       if(z .le. 100.) then
           call kintp3(at100, 1, 6, 0., .1, cosz, x100)
           call kintp3(tn, 1, 6, 0., .1, cosz, tng)
           zl=log10(z)
           h=-tng*(zl-2.) + x100
       elseif(z .lt. 2000.) then
           xx=log10(z)
           ix=(xx-2.)/.1 + 1
           iy= cosz/.1 +1
           iswa=0
           call akmid(za, 15, csa, 6, ztoha, 15, iswa, xx,
     *     ix, cosz, iy, f, vwa, jcon)
           if(jcon .gt. 10000) then
               write(*,*)' jocn in mfsdth=',jcon
               write(*,*) ' z=', z, ' xx=',xx, 'cosz=', cosz
           endif
           h=f
        elseif(z .lt. 10000.)then
           xx=log10(z)
           ix=(xx-3.275)/.1 + 1
           iy=cosz/.05+1
           iswb=0
           call akmid(zb, 30, csb,11, ztohb, 30, iswb, xx,
     *     ix, cosz, iy, f, vwb, jcon)
           if(jcon .gt. 10000) then
               write(*,*)' jocn in mfsdth-2=',jcon
           endif
           h=f
       else
           yy=log10(z)
           xx=min(yy, 4.495)
              ix=(xx-4.000)/.015+1
              iy=cosz/.02+1
              iswc=0
              call akmid(zc, 34, csc, 6, ztohc, 34, iswc, xx,
     *        ix, cosz, iy, f, vwc, jcon)
              if(jcon .gt. 10000) then
                  write(*,*)' jcon in mfsdth-c=',jcon
                  write(*,*)' xx=',xx,' zc=',zc, ' cosz=',cosz
                  write(*,*) csc
              endif
              if(yy .gt. 4.495) then
                 h= f / (4.495-4.55) * (yy-4.55)
c                write(*,*) ' yy=', yy, ' f=',f,' h=',h
              else
                 h=f
              endif
       endif
       end
c      ************************************************************
c      *
c      * mfltoh: convert slant length into height
c      *
c      ************************************************************
c        suppose length dl from the surface of the earth with zenith
c        angle cosz.  this sub. gives height at the end of the length
c           !
c           ! cosz   /
c           !     /   *
c           !  /dl    * h
c           /_________*___ curved earth surface
c           !
c           !
c           !
c           ! re
c           !
c           !
c           !
c
       subroutine mfltoh(cosz, dl, h)
          implicit real*8 (a-h, o-z)
c         ***********
          real*4 cosz
c         ***********
           parameter (re=6370.e5, re2=re**2)
           if(dl/re .lt. 1.d-7) then
              h=cosz*dl + dl**2/re/2
           else
              h=-re+ sqrt(re2+2*re*cosz*dl+dl**2)
           endif
       end
c          inverse of mfltoh
       subroutine mfhtol(cosz, h, dl)
          implicit real*8 (a-h, o-z)
c         ***********
          real*4 cosz
c         ***********
           parameter (re=6370.e5, re2=re**2)
           tmp=re*cosz
c          if(h*(2*re+h)*100.d0 .lt. tmp**2) then
c              dl=h*(1.d0/cosz+h/2/tmp)
c          else
               tmp2=max(tmp**2+2*re*h+h**2, 0.)
               dl=-tmp + sqrt(tmp2)
c          endif
       end
       subroutine mfvdsd(cosz, vd, sd)
c           convert vertical depth into slant depth
          real*8 hair, h, sdl
          if(cosz  .gt. .5) then
             sd=vd/cosz
          else
             h=hair(vd)
             call cvh2sdep(cosz, h, sdl)
             sd=sdl
          endif
       end
c      cosz=.0
c      sd=100.
c      call mfsdvd(cosz, sd, vd)
c      write(*,*) ' vd=',vd
c      call mfvdsd(cosz, vd, sd)
c      write(*,*) ' sd=',sd
c      end
       subroutine mfsdvd(cosz, sd, vd)
c           get vertical depth from slant depth cosz>=0
        implicit real*8 (a-h, o-z)
           real*4 cosz, sd,vd, zs, sds
           zs=ch2dep(0.0)
           call mfvdsd(cosz, zs,    sds)
c          write(*,*) ' zs=',zs, ' sds=',sds
           el=dstair(cosz, sd, sds)
c          write(*,*) ' el=',el
           call mfltoh(cosz, el, h)
           vd=ch2dep(sngl(h))
       end
c      ***********************************************************
c      *    dstair: see dstvar for usage.  this is usable for
c      *            any cosz
c      ******************* tested 88.08.25 ************k.k********
       function dstair(cosz, z1, z2)
c
        implicit real*8 (a-h, o-z)
        real*4  cosz, z1, z2
c
           if(cosz .lt. .5) then
c                 convert slant depth to height
               call mfsdth(cosz, z1, h1)
               call mfsdth(cosz, z2, h2)
c                 height to slant length from sea level
               call mfhtol(cosz, h1, dl1)
               call mfhtol(cosz, h2, dl2)
               dstair=dl1-dl2
           else
               dstair=dstvar(cosz, z1, z2)
           endif
       end
c      ***********************************************************
c      *    szair: see cslantdep for usage.  this is usable for
c      *            any cosz
c      ******************* tested 88.08.25 ************k.k********
       function szair(cosz, z1, path)
c
        implicit real*8 (a-h, o-z)
        real*4  cosz, z1
        real re/6370.e5/, dhbhm/0.03/, dhbhm2/0.0001/
c
        if(path .gt. 2.0d8) then
           szair=50000.
        else
          if(cosz .lt. .5) then
             call mfsdth(cosz, z1, h1)
             call mfhtol(cosz, h1, dl)
             if(h1 .gt. 0.) then
                 dhsq=(path/(h1+re)) **2
     *           * ( (h1+ re*2)*h1 + (re*cosz)**2 )
                 dhbh=dhsq/h1**2
c$$$$$$$$$$
c              write(*,*) ' dhbh=',dhbh, ' h1=',h1
c$$$$$$$$$$
             else
                 dhbh=1.
             endif
             if(dhbh .lt. dhbhm)  then
                 if(dhbh .lt. dhbhm2) then
                    dh=0.
                 else
                    dh=sqrt(dhsq)
                 endif
                 h2=max(h1-dh/2, 0.)
                 szair=(cdenair( sngl(ch2dep( sngl(h2)  )) ))
     *               *path + z1
             else
                 dl2=dl-path
                 call mfltoh(cosz, dl2, h2)
                 call cvh2sdep(cosz, h2, szair)
                 if(path .ge. 0. .and. szair .lt. z1) then
                     szair=cdenair(sngl(ch2dep(h1)))*path + z1
                 elseif(path .lt. 0. .and. szair .gt. z1) then
                     szair=cdenair(sngl(ch2dep(h1)))*path + z1
                 endif
             endif
           else
             szair=cpath2dep0(cosz, z1, path)
           endif
        endif
        end
c           test dstair
c     real*8 dstair
c     character ttl*70, capx*16, capy*16
c     real*4 cosza(9)/.5001, .4999, .41, .31, .21, .11, .05, .01,  0.0/
c     open(13, file='c2s5001.#gd.data')
c     ttl='test dstair'
c     capx='z2'
c     capy='dst z1 to z2'
c        z1=100.
c        do 1000 ics=1, 9
c            cosz=cosza(ics)
c            write(ttl,'(''cosz='',f6.4,'' z1='',f7.2)') cosz, z1
c            write(13) ttl
c            write(13) capx, capy
c            do 100 z2=150., 1030., 10.
c                call mfvdsd(cosz, z1, sd1)
c                call mfvdsd(cosz, z2, sd2)
c                ds1=dstair(cosz, sd1, sd2)
c                write(13) z2, ds1
c 100        continue
c            write(13) 1.e50, 1.e50
c1000    continue
c      end
c           test szair
c     real*8 szair
c     character ttl*70, capx*16, capy*16
c     real*4 cosza(9)/.5001, .4999, .41, .31, .21, .11, .05, .01,  0.0/
c     open(13, file='c2s5001.#gd.data')
c     capx='path'
c     capy='z=z1+path'
c        z1=1000
c        do 1000 ics=1, 9
c            cosz=cosza(ics)
c            write(ttl,'(''cosz='',f6.4,'' z1='',f7.2)') cosz, z1
c            write(13) ttl
c            write(13) capx, capy
c            do 100 path=-10.e5, 10e5, .1e5
c                z=szair(cosz, z1,path)
c                write(13) path, z
c 100        continue
c            write(13) 1.e50, 1.e50
c1000    continue
c      end
c     -----------------------------------------------------------------
c     !                dstvar, cdenair, hair,
c     !                cz2scaleh,  ch2dep,   cpath2dep0,
c     -----------------------------------------------------------------
      end
