c         test caslantdep
c
c      implicit none
c      include '../../Zglobalc.h'
c      real*8 z1, cost, caslantdep
c      do z1 = 0., 11.d3, .5d3
c            do cost = 1.d0, -1.d-15, -0.001d0
c               write(*, *) sngl( cost), ' ',
c     *              sngl( caslantdep(z1, cost)*Togpcm2 )
c            enddo
c            write(*, *)
c      enddo
c      end
c    *************************************
      real*8 function caslantdep(z1, cost)
c    *************************************
c           caslantdep:  compute approximate slant depth
c        at a given height to a given zenith angle direction.
c
c      z1:  given height (m) from the earth surface.
c    cost:  zenith angle to which the slant depth is
c           computed.
c   function value. slant depth in kg/m2.
c  -----------------------------------------------------
c    Suppose an exponential atmospher of which the
c  air density is expressed  as
c
c       RHO = RHO0 * exp(- z/z0)
c  where z is the vertical height, z0 the scale height.
c 
c  the slant depth at height z1 directed to the zenith angle 
c  of theta is
c
c      slant depth = I(0:inf){RHO(l)}dl
c  where l is the length along the theta. At point l,
c  the vertical height is
c
c   z =   sqrt(l**2 + H**2 +2Hlcos(t)) - H + z1
c  where 
c      H = Re + z1, cos(t) = cos(theta)
c  and Re is the earth radius.
c  Therefore we may substitute this expression into
c  RHO.
c  For the approximate integration, we can approximate
c  the vertical height at l to be
c
c      z1 + l cos(t) + sin(t)**2/2/H * l**2
c  Then, for the exponential atmosphere, we get,
c
c    slant depth =
c
c        RHO0 I(0:inf){exp(-(z1/z0 + l/z0 cos(t)
c                            
c                           sin(t)**2
c                           ~~~~~~~~~   (l/z0)**2))} dl
c                           (Re+z1)/z0
c
c         = RHO0 *z0 *I(0:inf){exp(-(z1/z0 + cos(t)x +
c 
c                          sin(t)**2
c                          ~~~~~~~~~~ x**2))} dx
c                          (Re+z1)/z0
c
c         = RHO0*z0*exp(-z1/z0)I(0:inf){exp(-(cos(t)x +
c
c                          sin(t)**2
c                          ~~~~~~~~~~ x**2))} dx
c                          (Re+z1)/z0
c
c                                 1
c         = RHO0*z0* exp(-z1/z0) ---sqrt(pi/a) exp((Re+z1)/z0 * cot(t)**2/4 )
c                                 2 
c
c                       *  kerfc(cot(t)sqrt(Re+z1)/z0))
c
c               where a is sin(t)**2/(Re+z1)/z0
c
c  if sin(t)~0, this is, of course,
c
c         = RHO0*z0*exp(-z1/z0)/cos(t)
c    
c   Another approach with little bit faster but less mathmatical
c  one is in caslantdepold.f
c
c  --------------------------------------------------------------
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 z1, cost

      real*8 rho0, z0
      parameter (z0 = 6.33d3, rho0 = 1030.d0*Tokgpm2/z0)
      real*8 sint, cott, hbyz0, sqrthbyz0, kerfc, erfarg
      real*8 experfc, temp


      if(cost .ge.  0.6) then
c          this is good even at cost=0.4 on the graph
c          actuall accuracy is not so important for the
c          ratio of exact / approx.
c
         caslantdep = rho0 * z0 * exp(-z1/z0)/cost
      else
         sint = sqrt(1.d0 - cost**2)
         cott = cost/sint
         hbyz0 =2*(Eradius + z1)/z0
         sqrthbyz0 = sqrt(hbyz0)
         erfarg = cott*sqrthbyz0/2
         if(erfarg .gt. 20.d0) then
            temp = 2*erfarg**2
c              exp(z**2)erfc(z)=            
            experfc =
     *       (1.d0 - 1.d0/temp + 3.d0/temp**2 - 15.d0/temp**3)
     *       /sqrtpi/erfarg
         else
            experfc =exp(hbyz0*cott**2/4)* kerfc(cott/2*sqrthbyz0)
         endif
         caslantdep = rho0*z0*exp(- z1/z0) *experfc*
     *                sqrtpi* sqrthbyz0/sint/2
      endif
      end

