c   inelastic cross-section at enetire  energy.
c   IncreaseXsec =2 should not be used.
c        cppXsec   p   p      n p
c        cpbarpXsec  p_b p      n_b  n    n_b p   p_b n
c        cpiMinuspXsec  pi- p
c        cpiPluspXsec  pi+ p
c        ckMinuspXsec  k-  p      k0_b n
c        ckPluspXsec k+  p k+ n  k- n   k0_b  p   k0 n
c        real*8 e, xs
c        e=1000.
c        call cppXsec(e, xs)
c        write(*,*) xs
c        end
c       ***********************************************************
c       *
c       * p_p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c    e:real*8.  input. kinetic energy of partilce in GeV.
c   xs:real*8   output. Inelastic cross-section in mb
c
        subroutine cppXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
c       *********************
        external cblkXsec
c       *********************
        real*8 e, xs
        if(e .lt. 1000. .or. IncreaseXsec .eq. 2) then
           call cppXsec0(e, xs)
        else
           call cppXsec0(1000.d0, xs)
           if(IncreaseXsec .eq. 1) then
              xs = xs * (e/1000.)**Deltpp
           endif
        endif    
      end
c       ***********************************************************
c       *
c       * p_b p inelastic cross-section
c       *
c       ******************                 *****************k.k ***
c
c   e: input.  e kinetic energy in GeV
c   xs:output. inelastic cross-section in mb
c
        subroutine cpbarpXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
        real*8 e, xs
        if(e .lt. 1000. .or. IncreaseXsec .eq. 2) then
           call cpbarpXsec0(e, xs)
        else
           call cpbarpXsec0(1000d0, xs)
           if(IncreaseXsec .eq. 1.) then
               xs = xs * (e/1000.)**Deltpp
           endif
        endif    
        end
c       ***********************************************************
c       *
c       * pi- p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c   e: input.  pi- k.e     in GeV
c   xs:output. inelastic cross-section in mb
c
        subroutine cpiMinuspXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
        real*8 e, xs
        if(e .lt. 500 .or. IncreaseXsec .eq. 2) then
           call cpiMinuspXsec0(e, xs)
        else
           call cpiMinuspXsec0(500d0, xs)
           if(IncreaseXsec .eq. 1.) then
               xs = xs * (e/500)**Deltpip
           endif
        endif    
      end
c       ***********************************************************
c       *
c       * pi+ p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c   e: input.  pi+ k.e     in GeV
c   xs:output. inelastic cross-section in mb
c
        subroutine cpiPluspXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
        real*8 e, xs
        if(e .lt. 500. .or. IncreaseXsec .eq. 2) then
           call cpiPluspXsec0(e, xs)
        else
           call cpiPluspXsec0(500d0, xs)
           if(IncreaseXsec .eq. 1.) then
               xs = xs * (e/500.)**Deltpip
           endif
        endif    
      end
c       ***********************************************************
c       *
c       * k-  p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c   e: input.  k- k.e   GeV
c   xs:output. inelastic cross-section in mb
c
        subroutine ckMinuspXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
        real*8 e, xs
        if(e .lt. 500.   .or. IncreaseXsec .eq. 2) then
           call ckMinuspXsec0(e, xs)
        else
           call ckMinuspXsec0(500d0, xs)
           if(IncreaseXsec .eq. 1.) then
               xs = xs * (e/500.)**Deltkp
           endif
        endif    
      end
c       ***********************************************************
c       *
c       * k+  p inelastic cross-section
c       *
c       ****************** tested 88.08.11 *****************k.k ***
c
c   e: input.  k+ k.e    GeV
c   xs:output. inelastic cross-section in mb
c
        subroutine ckPluspXsec(e, xs)
        implicit none
c----        include 'Zxsectionp.h'
#include  "Zxsectionp.h"
        real*8 e, xs
        if(e .lt. 500. .or.IncreaseXsec .eq. 2) then
           call ckPluspXsec0(e, xs)
        else
           call ckPluspXsec0(500d0, xs)
           if(IncreaseXsec .eq. 1.) then
               xs = xs * (e/500.)**Deltkp
           endif
        endif    
      end

