c     test crot3vec, cirot3vec
c      implicit none
c#include "Zptcl.h"
c       
c      integer i
c      record /fmom/ wa, dc, ans
c      real*8 cst, snt, fai
c      wa.p(1)=00
c      wa.p(2)=-1.0
c      wa.p(3)=sqrt(1. - (wa.p(1)**2+wa.p(2)**2))
c      wa.p(1) = wa.p(1) *10.
c      wa.p(2) = wa.p(2) *10
c      wa.p(3) = wa.p(3) *10.
c      cst=-0.2
c      snt=sqrt(1.-cst**2)
c      i =0
c      do fai=0., 2*3.1415, .1
c         i = 1
c         dc.p(1)=snt*cos(fai)*10
c         dc.p(2)=snt*sin(fai)*10
c         dc.p(3)=cst*10
c         call crot3vec(wa, dc, ans)
c         write(*,*)  dc.p(1), dc.p(2), dc.p(3),
c     *     dc.p(1)**2 + dc.p(2)**2
c         call cirot3vec(i, wa, ans, ans)
c         write(*,*) ans.x, ans.y,
c     *    ans.z, ans.x**2 + ans.y**2
c      enddo
c      end
c      ************************************
       subroutine crot3vec(zax, vec1, vec2)
c      ************************************
       implicit none
#include "Zptcl.h"
       record /fmom/ zax, vec1, vec2

       real*8  sml, epsx, av

       parameter (sml=0.001,  epsx=1.e-4, av=.985)

c
c   /usage/ call crot3vec(zax, vec1, vec2)
c         4 momentum  vec1 are given in a system
c         (=R) whose z-axis has pallarel to 4 momentum (zax) in
c         a certain system(=B).
c         This subroutine transform the angles so that (vec1)
c         be the 4 momeuntum in the B-system,
c         and put the result into vec2.
c   (Note 4th component is acutally not needed and not changed)
c         The x and y
c         axes of the R-system are chosen so that the transformation
c         becomes simplest. This does not guarantee that the vec2
c         have the same sing as the original one when xax(1) is
c         1.0 or close to 1.0. 
c      vec2 can be the same one as vec1, or zax.
c   This is essentially the same as ctransVectZ.
c
       real*8  el2, em2, d, a, b, c
       real*8 tmpa, tmpb, tmpc, pabs
       record /fmom/ zaxdir
c
c           get direction cos from zax
       pabs = sqrt(zax.p(1)**2 + zax.p(2)**2 + zax.p(3)**2)
       if(pabs .eq. 0.) then
          zaxdir.p(1) = 0.
          zaxdir.p(2) = 0.
          zaxdir.p(3) = 1.
       else
          zaxdir.p(1) = zax.p(1)/pabs
          zaxdir.p(2) = zax.p(2)/pabs
          zaxdir.p(3) = zax.p(3)/pabs
       endif
c
       el2=zaxdir.p(1)**2
       em2=zaxdir.p(2)**2
       d=1.+zaxdir.p(3)
       if(abs(d) .gt. epsx) then
          a=el2/d - 1.
          b=zaxdir.p(1)*zaxdir.p(2)/d
          c=em2/d - 1.
          tmpa=a*vec1.p(1) + b*vec1.p(2) + zaxdir.p(1)*vec1.p(3)
          tmpb=b*vec1.p(1) + c*vec1.p(2) + zaxdir.p(2)*vec1.p(3)
       else
          tmpa= vec1.p(2)
          tmpb= vec1.p(1)
       endif
       tmpc=zaxdir.p(1)*vec1.p(1) + zaxdir.p(2)*vec1.p(2) +
     *     zaxdir.p(3)*vec1.p(3)
       vec2.p(1) = tmpa
       vec2.p(2) = tmpb
       vec2.p(3) = tmpc
       end

c    ***************************************
      subroutine cirot3vec(init, p1, p2, po)
      implicit none
#include "Zptcl.h"
c    ***************************************
c     
c         suppose p1 and p2 are given in the same system.
c      This program rotate the  z-axis so that
c      it coinsides with p1 and transform p2 as seen from p1.
c      The result is put in po.
c      Note that the x and y are arbitrary chosen.
c      the 4-th  comp. is not used and unchanged.
c
      integer init  ! input. give 1 if p1 is diff. from prev. call.
      record /fmom/p1  ! input.
      record /fmom/p2  ! input. 
      record /fmom/po  ! output. po may be p2
c
      record /fmom/x, y, px
      real*8 xnorm, ynorm, pnorm, sum, ax, ay, az

#ifdef   USESAVE
         save x, y, xnorm, ynorm, pnorm
#endif
      
c
c        form x and y with  p1 being z.
c
      if(init .eq. 1) then
         pnorm = sqrt(p1.p(1)**2 + p1.p(2)**2 + p1.p(3)**2)
      endif
      if( pnorm .eq. 0.0 ) then
         po = p2
      else
         if(init .eq. 1) then 
            ax = abs(p1.p(1))
            ay = abs(p1.p(2))
            az = abs(p1.p(3))

            if(az .gt. ay) then
               if(az .gt. ax) then
                  sum = -(p1.p(1) + p1.p(2)) 
                  x.p(1) = 1.
                  x.p(2) = 1.
                  x.p(3) = sum/p1.p(3)
               else
                  sum = -(p1.p(2) + p1.p(3)) 
                  x.p(2) = 1.
                  x.p(3) = 1.
                  x.p(1) = sum/p1.p(1)
               endif
            elseif(ay .gt. ax ) then
               sum = -(p1.p(1) + p1.p(3)) 
               x.p(1) = 1.
               x.p(3) = 1.
               x.p(2) = sum/p1.p(2)
            else
               sum = -(p1.p(2) + p1.p(3)) 
               x.p(2) = 1.
               x.p(3) = 1.
               x.p(1) = sum/p1.p(1)
            endif
c             form y
            y.p(1) = p1.p(2)* x.p(3) - p1.p(3) * x.p(2)
            y.p(2) = p1.p(3)* x.p(1) - p1.p(1) * x.p(3)
            y.p(3) = p1.p(1)* x.p(2) - p1.p(2) * x.p(1)
c
c            since p1, x, y are not unit vector, we have to normalize
c
            xnorm = sqrt(x.p(1)**2 + x.p(2)**2 + x.p(3)**2)
            ynorm = sqrt(y.p(1)**2 + y.p(2)**2 + y.p(3)**2)
         endif
c
c          if init != 1, we come here directly
c
c          get projection of p2 on to x, y, p1
c
         px.p(1) = (p2.p(1)* x.p(1) + p2.p(2)* x.p(2) +
     *        p2.p(3) * x.p(3))/xnorm
         px.p(2) = (p2.p(1)* y.p(1) + p2.p(2)* y.p(2) +
     *        p2.p(3) * y.p(3))/ynorm
         px.p(3) = (p2.p(1)* p1.p(1) + p2.p(2)* p1.p(2) +
     *        p2.p(3) * p1.p(3))/pnorm
c
         po = px
         po.p(4) = p2.p(4)
      endif
      end






      

