c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file that exists already
c  *     for formatted mode. If it doen not
c  *     exist or cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenf(io, fn, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fn: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fn
         logical opn, ex
         integer io, ios, icon, klena
         character*300 msg

c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
#ifdef ACTION_READ
c                     for non-writable file action ='read'
c                      is needed.
                 open(io, file=fn(1:klena(fn)), 
     *           iostat=ios, access='sequential',
     *           form='formatted', action='read') 
#else
                 open(io, file=fn(1:klena(fn)), 
     *           iostat=ios, access='sequential',
     *           form='formatted') 
#endif
                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                 write(msg, *) ' file=', fn(1:klena(fn)),' not exist'
                 call cerrorMsg(msg, 1)
                 icon = 1
             endif    
         end

c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file 
c  *     for formatted i/o mode. If it
c  *     cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenfw(io, fn, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fn: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fn
         logical opn, ex
         integer io, ios, icon, klena
         character*100 msg

c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
                open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted') 

                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted') 
                icon = 0
             endif    
         end
      subroutine cskiptoEOF(iodev)
      implicit none
      integer iodev

c          skip to the end of previous write
       do while(.true.)
          read(iodev, *, end=100)
       enddo
 100   continue
       end






