c*********************************************************************
c*********************************************************************
c*                                                                  **
c*                                                  january 1991    **
c*                                                                  **
c*           the lund monte carlo for hadronic processes            **
c*                                                                  **
c*                        pythia version 5.5                        **
c*                                                                  **
c*                        hans-uno bengtsson                        **
c*     department of theoretical physics, university of uppsala     **
c*            thunbergsvagen 3, s-752 38 uppsala, sweden            **
c*               internet address hansuno@thep.lu.se                **
c*                       tel. +18 - 18 32 44                        **
c*                                                                  **
c*                        torbjorn sjostrand                        **
c*                    cern/th, ch-1211 geneva 23                    **
c*                bitnet/earn address torsjo@cernvm                 **
c*                       tel. +22 - 767 28 20                       **
c*                                                                  **
c*       copyright hans-uno bengtsson and torbjorn sjostrand        **
c*                                                                  **
c*********************************************************************
c*********************************************************************
c                                                                    *
c  list of subprograms in order of appearance, with main purpose     *
c  (s = subroutine, f = function, b = block data)                    *
c                                                                    *
c  s   pyinit   to administer the initialization procedure           *
c  s   pyevnt   to administer the generation of an event             *
c  s   pystat   to print cross-section and other information         *
c  s   pyinki   to initialize kinematics of incoming particles       *
c  s   pyinre   to initialize treatment of resonances                *
c  s   pyxtot   to give total, elastic and diffractive cross-sect.   *
c  s   pymaxi   to find differential cross-section maxima            *
c  s   pypile   to select multiplicity of pileup events              *
c  s   pyrand   to select subprocess and kinematics for event        *
c  s   pyscat   to set up kinematics and colour flow of event        *
c  s   pysspa   to simulate initial state spacelike showers          *
c  s   pyresd   to perform resonance decays                          *
c  s   pymult   to generate multiple interactions                    *
c  s   pyremn   to add on target remnants                            *
c  s   pydiff   to set up kinematics for diffractive events          *
c  s   pydocu   to compute cross-sections and handle documentation   *
c  s   pyfram   to perform boosts between different frames           *
c  s   pywidt   to calculate full and partial widths of resonances   *
c  s   pyofsh   to calculate partial width into off-shell channels   *
c  s   pyklim   to calculate borders of allowed kinematical region   *
c  s   pykmap   to construct value of kinematical variable           *
c  s   pysigh   to calculate differential cross-sections             *
c  s   pystfu   to evaluate structure functions                      *
c  s   pystga   to evaluate photon structure function                *
c  s   pyspli   to find flavours left in hadron when one removed     *
c  f   pygamm   to evaluate ordinary gamma function gamma(x)         *
c  s   pywaux   to evaluate auxiliary functions w1(s) and w2(s)      *
c  s   pyi3au   to evaluate auxiliary function i3(s,t,u,v)           *
c  f   pyspen   to evaluate spence (dilogarithm) function sp(x)      *
c  s   pytest   to test the proper functioning of the package        *
c  b   pydata   to contain all default values                        *
c  s   pykcut   to provide dummy routine for user kinematical cuts   *
c  s   pystfe   to provide interface to tung or user structure func. *
c                                                                    *
c*********************************************************************

      subroutine pyinit(frame,beam,target,win)
      implicit double precision (a-h,o-z)

c...initializes the generation procedure; finds maxima of the
c...differential cross-sections to be used for weighting.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/ludat4/chaf(500)
      character chaf*8
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /ludat1/,/ludat2/,/ludat3/,/ludat4/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint5/
      dimension alamin(20),nfin(20)
      character*(*) frame,beam,target
      character chfram*8,chbeam*8,chtarg*8,chmo(12)*3,chlh(2)*6
      data alamin/0.20,0.29,0.20,0.40,0.187,0.212,0.191,0.155,
     &0.22,0.16,0.16,0.26,0.36,7*0.2/,nfin/20*4/
      data chmo/'jan','feb','mar','apr','may','jun','jul','aug','sep',
     &'oct','nov','dec'/, chlh/'lepton','hadron'/

c...reset mint and vint arrays. write headers.
      do 100 j=1,400
      mint(j)=0
  100 vint(j)=0.
      if(mstp(127).ge.1) write(mstu(11),5000) mstp(181),mstp(182),
     &mstp(185),chmo(mstp(184)),mstp(183)
      mstp(127)=0
      if(mstu(12).ge.1) call lulist(0)
      if(mstp(122).ge.1) write(mstu(11),5100)

c...identify beam and target particles and initialize kinematics.
      chfram=frame//' '
      chbeam=beam//' '
      chtarg=target//' '
      call pyinki(chfram,chbeam,chtarg,win)
      if(mint(65).eq.1) goto 160

c...select partonic subprocesses to be included in the simulation.
      if(msel.ne.0) then
        do 110 i=1,200
  110   msub(i)=0
      endif
      if(mint(43).eq.1.and.(msel.eq.1.or.msel.eq.2)) then
c...lepton+lepton -> gamma/z0 or w.
        if(mint(11)+mint(12).eq.0) msub(1)=1
        if(mint(11)+mint(12).ne.0) msub(2)=1
      elseif(mint(43).le.3.and.(msel.eq.1.or.msel.eq.2)) then
c...lepton+hadron: deep inelastic scattering.
        msub(11)=1
      elseif(msel.eq.1) then
c...high-pt qcd processes:
        msub(11)=1
        msub(12)=1
        msub(13)=1
        msub(28)=1
        msub(53)=1
        msub(68)=1
        if(mstp(82).le.1.and.ckin(3).lt.parp(81)) msub(95)=1
        if(mstp(82).ge.2.and.ckin(3).lt.parp(82)) msub(95)=1
      elseif(msel.eq.2) then
c...all qcd processes:
        msub(11)=1
        msub(12)=1
        msub(13)=1
        msub(28)=1
        msub(53)=1
        msub(68)=1
        msub(91)=1
        msub(92)=1
        msub(93)=1
        msub(95)=1
      elseif(msel.ge.4.and.msel.le.8) then
c...heavy quark production.
        msub(81)=1
        msub(82)=1
        msub(84)=1
        do 120 j=1,min(8,mdcy(21,3))
  120   mdme(mdcy(21,2)+j-1,1)=0
        mdme(mdcy(21,2)+msel-1,1)=1
        msub(85)=1
        do 130 j=1,min(8,mdcy(22,3))
  130   mdme(mdcy(22,2)+j-1,1)=0
        mdme(mdcy(22,2)+msel-1,1)=1
      elseif(msel.eq.10) then
c...prompt photon production:
        msub(14)=1
        msub(18)=1
        msub(29)=1
      elseif(msel.eq.11) then
c...z0/gamma* production:
        msub(1)=1
      elseif(msel.eq.12) then
c...w+/- production:
        msub(2)=1
      elseif(msel.eq.13) then
c...z0 + jet:
        msub(15)=1
        msub(30)=1
      elseif(msel.eq.14) then
c...w+/- + jet:
        msub(16)=1
        msub(31)=1
      elseif(msel.eq.15) then
c...z0 & w+/- pair production:
        msub(19)=1
        msub(20)=1
        msub(22)=1
        msub(23)=1
        msub(25)=1
      elseif(msel.eq.16) then
c...h0 production:
        msub(3)=1
        msub(102)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
      elseif(msel.eq.17) then
c...h0 & z0 or w+/- pair production:
        msub(24)=1
        msub(26)=1
      elseif(msel.eq.18) then
c...h0 production; interesting processes in e+e-.
        msub(24)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
      elseif(msel.eq.19) then
c...h0, h'0 and a0 production; interesting processes in e+e-.
        msub(24)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
        msub(153)=1
        msub(171)=1
        msub(173)=1
        msub(174)=1
        msub(158)=1
        msub(176)=1
        msub(178)=1
        msub(179)=1
      elseif(msel.eq.21) then
c...z'0 production:
        msub(141)=1
      elseif(msel.eq.22) then
c...w'+/- production:
        msub(142)=1
      elseif(msel.eq.23) then
c...h+/- production:
        msub(143)=1
      elseif(msel.eq.24) then
c...r production:
        msub(144)=1
      elseif(msel.eq.25) then
c...lq (leptoquark) production.
        msub(145)=1
        msub(162)=1
        msub(163)=1
        msub(164)=1
      elseif(msel.ge.35.and.msel.le.38) then
c...production of one heavy quark (w exchange):
        msub(83)=1
        do 140 j=1,min(8,mdcy(21,3))
  140   mdme(mdcy(21,2)+j-1,1)=0
        mdme(mdcy(21,2)+msel-31,1)=1
      endif

c...count number of subprocesses on.
      mint(48)=0
      do 150 isub=1,200
      if(mint(44).lt.4.and.isub.ge.91.and.isub.le.96.and.
     &msub(isub).eq.1) then
        write(mstu(11),5200) isub,chlh(mint(41)),chlh(mint(42))
        stop
      elseif(msub(isub).eq.1.and.iset(isub).eq.-1) then
        write(mstu(11),5300) isub
        stop
      elseif(msub(isub).eq.1.and.iset(isub).le.-2) then
        write(mstu(11),5400) isub
        stop
      elseif(msub(isub).eq.1) then
        mint(48)=mint(48)+1
      endif
  150 continue
      if(mint(48).eq.0) then
        write(mstu(11),5500)
        stop
      endif
      mint(49)=mint(48)-msub(91)-msub(92)-msub(93)-msub(94)

c...maximum 4 generations; set maximum number of allowed flavours.
  160 mstp(1)=min(4,mstp(1))
      mstu(114)=min(mstu(114),2*mstp(1))
      mstp(54)=min(mstp(54),2*mstp(1))

c...sum up cabibbo-kobayashi-maskawa factors for each quark/lepton.
      do 180 i=-20,20
      vint(180+i)=0.
      ia=iabs(i)
      if(ia.ge.1.and.ia.le.2*mstp(1)) then
        do 170 j=1,mstp(1)
        ib=2*j-1+mod(ia,2)
        ipm=(5-isign(1,i))/2
        idc=j+mdcy(ia,2)+2
  170   if(mdme(idc,1).eq.1.or.mdme(idc,1).eq.ipm) vint(180+i)=
     &  vint(180+i)+vckm((ia+1)/2,(ib+1)/2)
      elseif(ia.ge.11.and.ia.le.10+2*mstp(1)) then
        vint(180+i)=1.
      endif
  180 continue

c...choose lambda value to use in alpha-strong.
      mstu(111)=mstp(2)
      if(mstp(3).ge.1) then
        alam=parp(1)
        if(mstp(51).ge.1.and.mstp(51).le.13) alam=alamin(mstp(51))
        parp(1)=alam
        parp(61)=alam
        paru(112)=alam
        parj(81)=alam
        if(mstp(51).ge.1.and.mstp(51).le.13) mstu(112)=nfin(mstp(51))
      endif

c...initialize widths and partial widths for resonances.
      call pyinre
      if(mint(65).eq.1) goto 200

c...reset variables for cross-section calculation.
      do 190 i=0,200
      do 190 j=1,3
      ngen(i,j)=0
  190 xsec(i,j)=0.

c...find parametrized total cross-sections.
      if(mint(44).eq.4) call pyxtot

c...maxima of differential cross-sections.
      if(mstp(121).le.1) call pymaxi

c...initialize possibility of pileup events.
      if(mstp(131).ne.0) call pypile(1)

c...initialize multiple interactions with variable impact parameter.
      if(mint(44).eq.4.and.(mint(49).ne.0.or.mstp(131).ne.0).and.
     &mstp(82).ge.2) call pymult(1)
  200 if(mstp(122).ge.1) write(mstu(11),5600)

c...formats for initialization information.
 5000 format(///20x,'the lund monte carlo - pythia version ',i1,'.',i1/
     &20x,'**  last date of change:  ',i2,1x,a3,1x,i4,'  **'/)
 5100 format('1',18('*'),1x,'pyinit: initialization of pythia ',
     &'routines',1x,17('*'))
 5200 format(1x,'error: process number ',i3,' not meaningful for ',a6,
     &'-',a6,' interactions.'/1x,'execution stopped!')
 5300 format(1x,'error: requested subprocess',i4,' not implemented.'/
     &1x,'execution stopped!')
 5400 format(1x,'error: requested subprocess',i4,' not existing.'/
     &1x,'execution stopped!')
 5500 format(1x,'error: no subprocess switched on.'/
     &1x,'execution stopped.')
 5600 format(/1x,22('*'),1x,'pyinit: initialization completed',1x,
     &22('*'))

      return
      end

c*********************************************************************

      subroutine pyevnt
      implicit double precision (a-h,o-z)

c...administers the generation of a high-pt event via calls to
c...a number of subroutines.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /lujets/,/ludat1/,/ludat2/
      save /pypars/,/pyint1/,/pyint2/,/pyint5/

c...initial values for some counters.
      mint(5)=mint(5)+1
      mint(7)=0
      mint(8)=0
      mint(83)=0
      mint(84)=mstp(126)
      mstu(24)=0
      mstu70=0
      mstj14=mstj(14)

c...loop over number of pileup events; check space left.
      if(mstp(131).le.0) then
        npile=1
      else
        call pypile(2)
        npile=mint(81)
      endif
      do 170 ipile=1,npile
      if(mint(84)+100.ge.mstu(4)) then
        call luerrm(11,
     &  '(pyevnt:) no more space in lujets for pileup events')
        if(mstu(21).ge.1) goto 180
      endif
      mint(82)=ipile

c...generate variables of hard scattering.
  100 continue
      mint(31)=0
      mint(51)=0
      call pyrand
      isub=mint(1)
      if(mstp(111).eq.-1) goto 160

      if(isub.le.90.or.isub.ge.95) then
c...hard scattering (including low-pt):
c...reconstruct kinematics and colour flow of hard scattering.
        call pyscat
        if(mint(51).eq.1) goto 100
        ipu1=mint(84)+1
        ipu2=mint(84)+2
        if(isub.eq.95) goto 110

c...showering of initial state partons (optional).
        if(mstp(61).ge.1.and.mint(44).ge.2) call pysspa(ipu1,ipu2)

c...showering of final state partons (optional).
        if(mstp(71).ge.1.and.iset(isub).ge.2) then
          ipu3=mint(84)+3
          ipu4=mint(84)+4
          if(iset(isub).eq.6) ipu4=-3
          qmax=sqrt(parp(71)*vint(52))
          if(iset(isub).ge.3.and.iset(isub).le.5) qmax=pmas(23,1)
          if(isub.eq.8.or.isub.eq.76.or.isub.eq.77.or.isub.eq.124.or.
     &    isub.eq.174.or.isub.eq.179) qmax=pmas(24,1)
          call lushow(ipu3,ipu4,qmax)
        endif

c...decay of final state resonances.
        if(mstp(41).ge.1) call pyresd
        if(mint(51).eq.1) goto 100
        mint(52)=n

c...multiple interactions.
        if(mstp(81).ge.1.and.mint(44).eq.4) call pymult(6)
        mint(53)=n

c...hadron remnants and primordial kt.
  110   call pyremn(ipu1,ipu2)
        if(mint(51).eq.1) goto 100

      else
c...diffractive and elastic scattering.
        call pydiff
      endif

c...recalculate energies from momenta and masses (if desired).
      if(mstp(113).ge.1) then
        do 120 i=mint(83)+1,n
  120   if(k(i,1).gt.0.and.k(i,1).le.10) p(i,4)=sqrt(p(i,1)**2+
     &  p(i,2)**2+p(i,3)**2+p(i,5)**2)
      endif

c...rearrange partons along strings, check invariant mass cuts.
      mstu(28)=0
      if(mstp(111).le.0) mstj(14)=-1
      call luprep(mint(84)+1)
      mstj(14)=mstj14
      if(mstp(112).eq.1.and.mstu(28).eq.3) goto 100
      if(mstp(125).eq.0.or.mstp(125).eq.1) then
        do 130 i=mint(84)+1,n
        if(k(i,2).ne.94) goto 130
        k(i+1,3)=mod(k(i+1,4)/mstu(5),mstu(5))
        k(i+2,3)=mod(k(i+2,4)/mstu(5),mstu(5))
  130   continue
        call luedit(12)
        call luedit(14)
        if(mstp(125).eq.0) call luedit(15)
        if(mstp(125).eq.0) mint(4)=0
        do 150 i=mint(83)+1,n
        if(k(i,1).eq.11.and.k(i,4).eq.0.and.k(i,5).eq.0) then
          do 140 i1=i+1,n
          if(k(i1,3).eq.i.and.k(i,4).eq.0) k(i,4)=i1
  140     if(k(i1,3).eq.i) k(i,5)=i1
        endif
  150   continue
      endif

c...introduce separators between sections in lulist event listing.
      if(ipile.eq.1.and.mstp(125).le.0) then
        mstu70=1
        mstu(71)=n
      elseif(ipile.eq.1) then
        mstu70=3
        mstu(71)=2
        mstu(72)=mint(4)
        mstu(73)=n
      endif

c...perform hadronization (if desired).
      if(mstp(111).ge.1) then
        call luexec
        if(mstu(24).ne.0) goto 100
      endif
      if(mstp(125).eq.0.or.mstp(125).eq.1) call luedit(14)

c...store event information and calculate monte carlo estimates of
c...subprocess cross-sections.
  160 if(ipile.eq.1) call pydocu

c...set counters for current pileup event and loop to next one.
      msti(41)=ipile
      if(ipile.ge.2.and.ipile.le.10) msti(40+ipile)=isub
      if(mstu70.lt.10) then
        mstu70=mstu70+1
        mstu(70+mstu70)=n
      endif
      mint(83)=n
      mint(84)=n+mstp(126)
  170 continue

c...generic information on pileup events.
      if(mstp(131).eq.1.and.mstp(133).ge.1) then
        pari(91)=vint(132)
        pari(92)=vint(133)
        pari(93)=vint(134)
        if(mstp(133).ge.2) pari(93)=pari(93)*xsec(0,3)/vint(131)
      endif

c...transform to the desired coordinate frame.
  180 call pyfram(mstp(124))
      mstu(70)=mstu70
      paru(21)=vint(1)

      return
      end

c***********************************************************************

      subroutine pystat(mstat)
      implicit double precision (a-h,o-z)

c...prints out information about cross-sections, decay widths, branching
c...ratios, kinematical limits, status codes and parameter values.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      common/pyint6/proc(0:200)
      character proc*28
      save /ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint4/,/pyint5/,/pyint6/
      character chau*16,chpa(-40:40)*9,chin(2)*12,
     &state(-1:5)*4,chkin(21)*18
      data state/'----','off ','on  ','on/+','on/-','on/1','on/2'/,
     &chkin/' m_hard (gev/c^2) ',' p_t_hard (gev/c) ',
     &'m_finite (gev/c^2)','   y*_subsystem   ','     y*_large     ',
     &'     y*_small     ','    eta*_large    ','    eta*_small    ',
     &'cos(theta*)_large ','cos(theta*)_small ','       x_1        ',
     &'       x_2        ','       x_f        ',' cos(theta_hard)  ',
     &'m''_hard (gev/c^2) ','       tau        ','        y*        ',
     &'cos(theta_hard^-) ','cos(theta_hard^+) ','      x_t^2       ',
     &'       tau''       '/

c...cross-sections.
      if(mstat.le.1) then
        write(mstu(11),5000)
        write(mstu(11),5100)
        write(mstu(11),5200) 0,proc(0),ngen(0,3),ngen(0,1),xsec(0,3)
        do 100 i=1,200
        if(msub(i).ne.1) goto 100
        write(mstu(11),5200) i,proc(i),ngen(i,3),ngen(i,1),xsec(i,3)
  100   continue
        write(mstu(11),5300) 1.-float(ngen(0,3))/
     &  max(1.,float(ngen(0,2)))

c...decay widths and branching ratios.
      elseif(mstat.eq.2) then
        do 110 kf=-40,40
        call luname(kf,chau)
  110   chpa(kf)=chau(1:9)
        write(mstu(11),5400)
        write(mstu(11),5500)
c...off-shell branchings.
        do 130 i=1,17
        kc=i
        if(i.ge.9) kc=i+2
        if(i.eq.17) kc=21
        ngp=0
        if(kc.le.20) ngp=(mod(kc,10)+1)/2
        if(ngp.le.mstp(1)) write(mstu(11),5600) kc,chpa(kc),pmas(kc,1),
     &  0.,0.,state(mdcy(kc,1)),0.
        do 120 j=1,mdcy(kc,3)
        idc=j+mdcy(kc,2)-1
        ngp1=0
        if(iabs(kfdp(idc,1)).le.20) ngp1=
     &  (mod(iabs(kfdp(idc,1)),10)+1)/2
        ngp2=0
        if(iabs(kfdp(idc,2)).le.20) ngp2=
     &  (mod(iabs(kfdp(idc,2)),10)+1)/2
  120   if(mdme(idc,2).eq.102.and.ngp1.le.mstp(1).and.ngp2.le.mstp(1))
     &  write(mstu(11),5700) idc,chpa(kfdp(idc,1)),chpa(kfdp(idc,2)),
     &  0.,0.,state(mdme(idc,1)),0.
  130   continue
c...on-shell decays.
        do 150 i=1,10
        kc=i+22
        if(i.eq.4) kc=32
        if(i.ge.5.and.i.le.8) kc=i+29
        if(i.ge.9) kc=i+30
        if(wide(kc,0).gt.0.) then
          write(mstu(11),5600) kc,chpa(kc),pmas(kc,1),widp(kc,0),1.,
     &    state(mdcy(kc,1)),1.
          do 140 j=1,mdcy(kc,3)
          idc=j+mdcy(kc,2)-1
          ngp1=0
          if(iabs(kfdp(idc,1)).le.20) ngp1=
     &    (mod(iabs(kfdp(idc,1)),10)+1)/2
          ngp2=0
          if(iabs(kfdp(idc,2)).le.20) ngp2=
     &    (mod(iabs(kfdp(idc,2)),10)+1)/2
  140     if(ngp1.le.mstp(1).and.ngp2.le.mstp(1)) write(mstu(11),5700)
     &    idc,chpa(kfdp(idc,1)),chpa(kfdp(idc,2)),widp(kc,j),
     &    widp(kc,j)/widp(kc,0),state(mdme(idc,1)),
     &    wide(kc,j)/wide(kc,0)
        else
          write(mstu(11),5600) kc,chpa(kc),pmas(kc,1),widp(kc,0),1.,
     &    state(mdcy(kc,1)),0.
        endif
  150   continue
        write(mstu(11),5800)

c...allowed incoming partons/particles at hard interaction.
      elseif(mstat.eq.3) then
        write(mstu(11),5900)
        call luname(mint(11),chau)
        chin(1)=chau(1:12)
        call luname(mint(12),chau)
        chin(2)=chau(1:12)
        write(mstu(11),6000) chin(1),chin(2)
        do 160 kf=-40,40
        call luname(kf,chau)
  160   chpa(kf)=chau(1:9)
        do 170 i=-20,22
        if(i.eq.0) goto 170
        ia=iabs(i)
        if(ia.gt.mstp(54).and.ia.le.10) goto 170
        if(ia.gt.10+2*mstp(1).and.ia.le.20) goto 170
        write(mstu(11),6100) chpa(i),state(kfin(1,i)),chpa(i),
     &  state(kfin(2,i))
  170   continue
        write(mstu(11),6200)

c...user-defined limits on kinematical variables.
      elseif(mstat.eq.4) then
        write(mstu(11),6300)
        write(mstu(11),6400)
        shrmax=ckin(2)
        if(shrmax.lt.0.) shrmax=vint(1)
        write(mstu(11),6500) ckin(1),chkin(1),shrmax
        pthmin=max(ckin(3),ckin(5))
        pthmax=ckin(4)
        if(pthmax.lt.0.) pthmax=0.5*shrmax
        write(mstu(11),6600) ckin(3),pthmin,chkin(2),pthmax
        write(mstu(11),6700) chkin(3),ckin(6)
        do 180 i=4,14
  180   write(mstu(11),6500) ckin(2*i-1),chkin(i),ckin(2*i)
        sprmax=ckin(32)
        if(sprmax.lt.0.) sprmax=vint(1)
        write(mstu(11),6500) ckin(31),chkin(15),sprmax
        write(mstu(11),6800)

c...status codes and parameter values.
      elseif(mstat.eq.5) then
        write(mstu(11),6900)
        write(mstu(11),7000)
        do 190 i=1,100
  190   write(mstu(11),7100) i,mstp(i),parp(i),100+i,mstp(100+i),
     &  parp(100+i)
      endif

c...formats for printouts.
 5000 format('1',9('*'),1x,'pystat:  statistics on number of ',
     &'events and cross-sections',1x,9('*'))
 5100 format(/1x,78('=')/1x,'i',34x,'i',28x,'i',12x,'i'/1x,'i',12x,
     &'subprocess',12x,'i',6x,'number of points',6x,'i',4x,'sigma',3x,
     &'i'/1x,'i',34x,'i',28x,'i',12x,'i'/1x,'i',34('-'),'i',28('-'),
     &'i',4x,'(mb)',4x,'i'/1x,'i',34x,'i',28x,'i',12x,'i'/1x,'i',1x,
     &'n:o',1x,'type',25x,'i',4x,'generated',9x,'tried',1x,'i',12x,
     &'i'/1x,'i',34x,'i',28x,'i',12x,'i'/1x,78('=')/1x,'i',34x,'i',28x,
     &'i',12x,'i')
 5200 format(1x,'i',1x,i3,1x,a28,1x,'i',1x,i12,1x,i13,1x,'i',1x,1p,
     &e10.3,1x,'i')
 5300 format(1x,'i',34x,'i',28x,'i',12x,'i'/1x,78('=')//
     &1x,'********* fraction of events that fail fragmentation ',
     &'cuts =',1x,f8.5,' *********'/)
 5400 format('1',17('*'),1x,'pystat:  decay widths and branching ',
     &'ratios',1x,17('*'))
 5500 format(/1x,78('=')/1x,'i',29x,'i',13x,'i',12x,'i',6x,'i',12x,'i'/
     &1x,'i',1x,'branching/decay channel',5x,'i',1x,'width (gev)',1x,
     &'i',7x,'b.r.',1x,'i',1x,'stat',1x,'i',2x,'eff. b.r.',1x,'i'/1x,
     &'i',29x,'i',13x,'i',12x,'i',6x,'i',12x,'i'/1x,78('='))
 5600 format(1x,'i',29x,'i',13x,'i',12x,'i',6x,'i',12x,'i'/1x,'i',1x,
     &i4,1x,a9,'(',1p,e8.2,0p,')',1x,'->',1x,'i',2x,1p,e10.3,0p,1x,
     &'i',1x,1p,e10.3,0p,1x,'i',1x,a4,1x,'i',1x,1p,e10.3,0p,1x,'i')
 5700 format(1x,'i',1x,i4,1x,a9,1x,'+',1x,a9,2x,'i',2x,1p,e10.3,0p,
     &1x,'i',1x,1p,e10.3,0p,1x,'i',1x,a4,1x,'i',1x,1p,e10.3,0p,1x,'i')
 5800 format(1x,'i',29x,'i',13x,'i',12x,'i',6x,'i',12x,'i'/1x,78('='))
 5900 format('1',7('*'),1x,'pystat: allowed incoming partons/',
     &'particles at hard interaction',1x,7('*'))
 6000 format(/1x,78('=')/1x,'i',38x,'i',37x,'i'/1x,'i',1x,
     &'beam particle:',1x,a12,10x,'i',1x,'target particle:',1x,a12,7x,
     &'i'/1x,'i',38x,'i',37x,'i'/1x,'i',1x,'content',6x,'state',19x,
     &'i',1x,'content',6x,'state',18x,'i'/1x,'i',38x,'i',37x,'i'/1x,
     &78('=')/1x,'i',38x,'i',37x,'i')
 6100 format(1x,'i',1x,a9,5x,a4,19x,'i',1x,a9,5x,a4,18x,'i')
 6200 format(1x,'i',38x,'i',37x,'i'/1x,78('='))
 6300 format('1',12('*'),1x,'pystat: user-defined limits on ',
     &'kinematical variables',1x,12('*'))
 6400 format(/1x,78('=')/1x,'i',76x,'i')
 6500 format(1x,'i',16x,1p,e10.3,0p,1x,'<',1x,a,1x,'<',1x,1p,e10.3,0p,
     &16x,'i')
 6600 format(1x,'i',3x,1p,e10.3,0p,1x,'(',1p,e10.3,0p,')',1x,'<',1x,a,
     &1x,'<',1x,1p,e10.3,0p,16x,'i')
 6700 format(1x,'i',29x,a,1x,'=',1x,1p,e10.3,0p,16x,'i')
 6800 format(1x,'i',76x,'i'/1x,78('='))
 6900 format('1',12('*'),1x,'pystat: summary of status codes and ',
     &'parameter values',1x,12('*'))
 7000 format(/3x,'i',4x,'mstp(i)',9x,'parp(i)',20x,'i',4x,'mstp(i)',9x,
     &'parp(i)'/)
 7100 format(1x,i3,5x,i6,6x,1p,e10.3,0p,18x,i3,5x,i6,6x,1p,e10.3)

      return
      end

c*********************************************************************

      subroutine pyinki(chfram,chbeam,chtarg,win)
      implicit double precision (a-h,o-z)

c...identifies the two incoming particles and sets up kinematics,
c...including rotations and boosts to/from cm frame.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /lujets/,/ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/
      character chfram*8,chbeam*8,chtarg*8,chcom(3)*8,chalp(2)*26,
     &chidnt(3)*8,chtemp*8,chcde(19)*8,chinit*76
      dimension len(3),kcde(19)
      data chalp/'abcdefghijklmnopqrstuvwxyz',
     &'abcdefghijklmnopqrstuvwxyz'/
      data chcde/'e-      ','e+      ','nu_e    ','nu_e~   ',
     &'mu-     ','mu+     ','nu_mu   ','nu_mu~  ','tau-    ',
     &'tau+    ','nu_tau  ','nu_tau~ ','pi+     ','pi-     ',
     &'n0      ','n~0     ','p+      ','p~-     ','gamma   '/
      data kcde/11,-11,12,-12,13,-13,14,-14,15,-15,16,-16,
     &211,-211,2112,-2112,2212,-2212,22/

c...convert character variables to lowercase and find their length.
      chcom(1)=chfram
      chcom(2)=chbeam
      chcom(3)=chtarg
      do 120 i=1,3
      len(i)=8
      do 100 ll=8,1,-1
      if(len(i).eq.ll.and.chcom(i)(ll:ll).eq.' ') len(i)=ll-1
      do 100 la=1,26
  100 if(chcom(i)(ll:ll).eq.chalp(2)(la:la)) chcom(i)(ll:ll)=
     &chalp(1)(la:la)
      chidnt(i)=chcom(i)

c...fix up bar, underscore and charge in particle name (if needed).
      do 110 ll=1,6
      if(chidnt(i)(ll:ll+2).eq.'bar') then
        chtemp=chidnt(i)
        chidnt(i)=chtemp(1:ll-1)//'~'//chtemp(ll+3:8)//'  '
      endif
  110 continue
      if(chidnt(i)(1:2).eq.'nu'.and.chidnt(i)(3:3).ne.'_') then
        chtemp=chidnt(i)
        chidnt(i)='nu_'//chtemp(3:7)
      elseif(chidnt(i)(1:2).eq.'n ') then
        chidnt(i)(1:3)='n0 '
      elseif(chidnt(i)(1:2).eq.'n~') then
        chidnt(i)(1:3)='n~0'
      elseif(chidnt(i)(1:2).eq.'p ') then
        chidnt(i)(1:3)='p+ '
      elseif(chidnt(i)(1:2).eq.'p~'.or.chidnt(i)(1:2).eq.'p-') then
        chidnt(i)(1:3)='p~-'
      endif
  120 continue

c...identify free initialization.
      if(chcom(1)(1:2).eq.'no') then
        mint(65)=1
        return
      endif

c...set initial state. error for unknown codes. reset variables.
      n=2
      do 140 i=1,2
      k(i,1)=1
      k(i,2)=0
      do 130 j=1,19
  130 if(chidnt(i+1).eq.chcde(j)) k(i,2)=kcde(j)
      p(i,5)=ulmass(k(i,2))
      mint(40+i)=1
      if(iabs(k(i,2)).gt.100.or.k(i,2).eq.22) mint(40+i)=2
      mint(44+i)=mint(40+i)
      if(mstp(11).ge.1.and.iabs(k(i,2)).eq.11) mint(44+i)=3
      do 140 j=1,5
  140 v(i,j)=0.
      if(k(1,2).eq.0) write(mstu(11),5000) chbeam(1:len(2))
      if(k(2,2).eq.0) write(mstu(11),5100) chtarg(1:len(3))
      if(k(1,2).eq.0.or.k(2,2).eq.0) stop
      do 150 j=6,10
  150 vint(j)=0.
      chinit=' '

c...set up kinematics for events defined in cm frame.
      if(chcom(1)(1:2).eq.'cm') then
        if(chcom(2)(1:1).ne.'e') then
          loffs=(31-(len(2)+len(3)))/2
          chinit(loffs+1:76)='pythia will be initialized for a '//
     &    chcom(2)(1:len(2))//' on '//chcom(3)(1:len(3))//' collider'//
     &    ' '
        else
          loffs=(30-(len(2)+len(3)))/2
          chinit(loffs+1:76)='pythia will be initialized for an '//
     &    chcom(2)(1:len(2))//' on '//chcom(3)(1:len(3))//' collider'//
     &    ' '
        endif
        if(mstp(122).ge.1) write(mstu(11),5200) chinit
        if(mstp(122).ge.1) write(mstu(11),5300) win
        s=win**2
        p(1,1)=0.
        p(1,2)=0.
        p(2,1)=0.
        p(2,2)=0.
        p(1,3)=sqrt(((s-p(1,5)**2-p(2,5)**2)**2-(2.*p(1,5)*p(2,5))**2)/
     &  (4.*s))
        p(2,3)=-p(1,3)
        p(1,4)=sqrt(p(1,3)**2+p(1,5)**2)
        p(2,4)=sqrt(p(2,3)**2+p(2,5)**2)

c...set up kinematics for fixed target events.
      elseif(chcom(1)(1:3).eq.'fix') then
        loffs=(29-(len(2)+len(3)))/2
        chinit(loffs+1:76)='pythia will be initialized for '//
     &  chcom(2)(1:len(2))//' on '//chcom(3)(1:len(3))//
     &  ' fixed target'//' '
        if(mstp(122).ge.1) write(mstu(11),5200) chinit
        if(mstp(122).ge.1) write(mstu(11),5400) win
        p(1,1)=0.
        p(1,2)=0.
        p(2,1)=0.
        p(2,2)=0.
        p(1,3)=win
        p(1,4)=sqrt(p(1,3)**2+p(1,5)**2)
        p(2,3)=0.
        p(2,4)=p(2,5)
        s=p(1,5)**2+p(2,5)**2+2.*p(2,4)*p(1,4)
        vint(10)=p(1,3)/(p(1,4)+p(2,4))
        call lurobo(0.d0,0.d0,0.d0,0.d0,-vint(10))
        if(mstp(122).ge.1) write(mstu(11),5500) sqrt(s)

c...set up kinematics for events in user-defined frame.
      elseif(chcom(1)(1:3).eq.'use') then
        loffs=(12-(len(2)+len(3)))/2
        chinit(loffs+1:76)='pythia will be initialized for '//
     &  chcom(2)(1:len(2))//' on '//chcom(3)(1:len(3))//
     &  ' user-specified configuration'//' '
        if(mstp(122).ge.1) write(mstu(11),5200) chinit
        if(mstp(122).ge.1) write(mstu(11),5600)
        if(mstp(122).ge.1) write(mstu(11),5700) chcom(2),p(1,1),
     &  p(1,2),p(1,3)
        if(mstp(122).ge.1) write(mstu(11),5700) chcom(3),p(2,1),
     &  p(2,2),p(2,3)
        p(1,4)=sqrt(p(1,1)**2+p(1,2)**2+p(1,3)**2+p(1,5)**2)
        p(2,4)=sqrt(p(2,1)**2+p(2,2)**2+p(2,3)**2+p(2,5)**2)
        do 160 j=1,3
  160   vint(7+j)=(p(1,j)+p(2,j))/(p(1,4)+p(2,4))
        call lurobo(0.d0,0.d0,-vint(8),-vint(9),-vint(10))
        vint(7)=ulangl(p(1,1),p(1,2))
        call lurobo(0.d0,-vint(7),0.d0,0.d0,0.d0)
        vint(6)=ulangl(p(1,3),p(1,1))
        call lurobo(-vint(6),0.d0,0.d0,0.d0,0.d0)
        s=p(1,5)**2+p(2,5)**2+2.*(p(1,4)*p(2,4)-p(1,3)*p(2,3))
        if(mstp(122).ge.1) write(mstu(11),5500) sqrt(s)

c...unknown frame. error for too low cm energy.
      else
        write(mstu(11),5800) chfram(1:len(1))
        stop
      endif
      if(s.lt.parp(2)**2) then
        write(mstu(11),5900) sqrt(s)
        stop
      endif

c...save information on incoming particles.
      mint(11)=k(1,2)
      mint(12)=k(2,2)
      mint(43)=2*mint(41)+mint(42)-2
      mint(44)=mint(43)
      if(mint(11).eq.22) mint(44)=mint(44)-2
      if(mint(12).eq.22) mint(44)=mint(44)-1
      mint(47)=2*min(2,mint(45))+min(2,mint(46))-2
      if(min(mint(45),mint(46)).eq.3) mint(47)=5
      vint(1)=sqrt(s)
      vint(2)=s
      vint(3)=p(1,5)
      vint(4)=p(2,5)
      vint(5)=p(1,3)

c...store constants to be used in generation.
      if(mstp(82).le.1) vint(149)=4.*parp(81)**2/s
      if(mstp(82).ge.2) vint(149)=4.*parp(82)**2/s

c...formats for initialization and error information.
 5000 format(1x,'error: unrecognized beam particle ''',a,'''.'/
     &1x,'execution stopped!')
 5100 format(1x,'error: unrecognized target particle ''',a,'''.'/
     &1x,'execution stopped!')
 5200 format(/1x,78('=')/1x,'i',76x,'i'/1x,'i',a76,'i')
 5300 format(1x,'i',18x,'at',1x,f10.3,1x,'gev center-of-mass energy',
     &19x,'i'/1x,'i',76x,'i'/1x,78('='))
 5400 format(1x,'i',22x,'at',1x,f10.3,1x,'gev/c lab-momentum',22x,'i')
 5500 format(1x,'i',76x,'i'/1x,'i',11x,'corresponding to',1x,f10.3,1x,
     &'gev center-of-mass energy',12x,'i'/1x,'i',76x,'i'/1x,78('='))
 5600 format(1x,'i',76x,'i'/1x,'i',25x,'px (gev/c)',3x,'py (gev/c)',3x,
     &'pz (gev/c)',15x,'i')
 5700 format(1x,'i',15x,a8,3(2x,f10.3,1x),14x,'i')
 5800 format(1x,'error: unrecognized coordinate frame ''',a,'''.'/
     &1x,'execution stopped!')
 5900 format(1x,'error: too low cm energy,',f8.3,' gev for event ',
     &'generation.'/1x,'execution stopped!')

      return
      end

c*********************************************************************

      subroutine pyinre
      implicit double precision (a-h,o-z)

c...calculates full and effective widths of gauge bosons, stores
c...masses and widths, rescales coefficients to be used for
c...resonance production generation.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/ludat4/chaf(500)
      character chaf*8
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint6/proc(0:200)
      character proc*28
      save /ludat1/,/ludat2/,/ludat3/,/ludat4/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint4/,/pyint6/
      dimension wdtp(0:40),wdte(0:40,0:5)

c...born level couplings in mssm higgs doublet sector.
      if(mstp(4).eq.2) then
        tanbe=paru(141)
        ratbe=((1.-tanbe**2)/(1.+tanbe**2))**2
        sqmz=pmas(23,1)**2
        sqmw=pmas(24,1)**2
        sqmh=pmas(25,1)**2
        sqma=sqmh*(sqmz-sqmh)/(sqmz*ratbe-sqmh)
        sqmhp=0.5*(sqma+sqmz+sqrt((sqma+sqmz)**2-4.*sqma*sqmz*ratbe))
        sqmhc=sqma+sqmw
        if(min(sqma,sqmhp,sqmhc).le.0.) then
          write(mstu(11),5000)
          stop
        endif
        pmas(35,1)=sqrt(sqmhp)
        pmas(36,1)=sqrt(sqma)
        pmas(37,1)=sqrt(sqmhc)
        alsu=0.5*atan(2.*tanbe*(sqma+sqmz)/((1.-tanbe**2)*
     &  (sqma-sqmz)))
        besu=atan(tanbe)
        paru(161)=-sin(alsu)/cos(besu)
        paru(162)=cos(alsu)/sin(besu)
        paru(163)=paru(161)
        paru(164)=sin(besu-alsu)
        paru(165)=paru(164)
        paru(171)=cos(alsu)/cos(besu)
        paru(172)=sin(alsu)/sin(besu)
        paru(173)=paru(171)
        paru(174)=cos(besu-alsu)
        paru(175)=paru(174)
        paru(176)=cos(2.*alsu)*cos(besu+alsu)-2.*sin(2.*alsu)*
     &  sin(besu+alsu)
        paru(177)=cos(2.*besu)*cos(besu+alsu)
        paru(181)=-tanbe
        paru(182)=-1./tanbe
        paru(183)=paru(181)
        paru(184)=0.
        paru(185)=paru(184)
        paru(186)=cos(besu-alsu)
        paru(187)=sin(besu-alsu)
        paru(195)=cos(besu-alsu)
      endif

c...reset full and effective widths of gauge bosons.
      xw=paru(102)
      do 100 i=21,40
      do 100 j=0,40
      widp(i,j)=0.
  100 wide(i,j)=0.

c...loop over possible resonances.
      do 130 i=1,10
      if(i.le.3) kc=i+22
      if(i.eq.4) kc=37
      if(i.eq.5) kc=36
      if(i.eq.6) kc=35
      if(i.eq.7) kc=32
      if(i.eq.8) kc=34
      if(i.ge.9) kc=i+30

c...check that no fourth generation channels on by mistake.
      if(mstp(1).le.3) then
        do 110 j=1,mdcy(kc,3)
        idc=j+mdcy(kc,2)-1
        kfa1=iabs(kfdp(idc,1))
        kfa2=iabs(kfdp(idc,2))
  110   if(kfa1.eq.7.or.kfa1.eq.8.or.kfa1.eq.17.or.kfa1.eq.18.or.kfa2.
     &  eq.7.or.kfa2.eq.8.or.kfa2.eq.17.or.kfa2.eq.18) mdme(idc,1)=-1
      endif

c...find mass and evaluate width.
      pmr=pmas(kc,1)
      if(kc.eq.25.or.kc.eq.35.or.kc.eq.36) mint(62)=1
      call pywidt(kc,pmr**2,wdtp,wdte)

c...evaluate suppression factors due to non-simulated channels.
      if(kchg(kc,3).eq.0) then
        wids(kc,1)=((wdte(0,1)+wdte(0,2))**2+
     &  2.*(wdte(0,1)+wdte(0,2))*(wdte(0,4)+wdte(0,5))+
     &  2.*wdte(0,4)*wdte(0,5))/wdtp(0)**2
        wids(kc,2)=(wdte(0,1)+wdte(0,2)+wdte(0,4))/wdtp(0)
        wids(kc,3)=0.
      else
        wids(kc,1)=((wdte(0,1)+wdte(0,2))*(wdte(0,1)+wdte(0,3))+
     &  (wdte(0,1)+wdte(0,2)+wdte(0,1)+wdte(0,3))*(wdte(0,4)+wdte(0,5))+
     &  2.*wdte(0,4)*wdte(0,5))/wdtp(0)**2
        wids(kc,2)=(wdte(0,1)+wdte(0,2)+wdte(0,4))/wdtp(0)
        wids(kc,3)=(wdte(0,1)+wdte(0,3)+wdte(0,4))/wdtp(0)
        if(kc.eq.24) then
          vint(91)=((wdte(0,1)+wdte(0,2))**2+2.*(wdte(0,1)+wdte(0,2))*
     &    (wdte(0,4)+wdte(0,5))+2.*wdte(0,4)*wdte(0,5))/wdtp(0)**2
          vint(92)=((wdte(0,1)+wdte(0,3))**2+2.*(wdte(0,1)+wdte(0,3))*
     &    (wdte(0,4)+wdte(0,5))+2.*wdte(0,4)*wdte(0,5))/wdtp(0)**2
        endif
      endif

c...find factors to give widths in gev.
      aem=ulalem(pmr**2)
      if(kc.eq.23) then
        fac=aem/(48.*xw*(1.-xw))*pmr
      elseif(kc.eq.24) then
        fac=aem/(24.*xw)*pmr
      elseif(kc.eq.25.or.kc.eq.35.or.kc.eq.36) then
        fac=aem/(8.*xw)*(pmr/pmas(24,1))**2*pmr
      elseif(kc.eq.32) then
        fac=aem/(48.*xw*(1.-xw))*pmr
      elseif(kc.eq.34) then
        fac=aem/(24.*xw)*pmr
      elseif(kc.eq.37) then
        fac=aem/(8.*xw)*(pmr/pmas(24,1))**2*pmr
      elseif(kc.eq.39) then
        fac=aem/4.*pmr
      elseif(kc.eq.40) then
        fac=aem/(12.*xw)*pmr
      endif

c...translate widths into gev and save them.
      do 120 j=0,40
      widp(kc,j)=fac*wdtp(j)
  120 wide(kc,j)=fac*wdte(j,0)

c...set resonance widths and branching ratios in jetset;
c...also on/off switch for decays in pythia/jetset.
      pmas(kc,2)=widp(kc,0)
      pmas(kc,3)=min(0.9*pmas(kc,1),10.*pmas(kc,2))
      mdcy(kc,1)=mstp(41)
      do 130 j=1,mdcy(kc,3)
      idc=j+mdcy(kc,2)-1
      brat(idc)=wide(kc,j)/wide(kc,0)
  130 continue

c...find heaviest new quark flavour allowed in processes 81-84.
      kflqm=1
      do 140 i=1,min(8,mdcy(21,3))
      idc=i+mdcy(21,2)-1
      if(mdme(idc,1).le.0) goto 140
      kflqm=i
  140 continue
      mint(55)=kflqm
      kfpr(81,1)=kflqm
      kfpr(81,2)=kflqm
      kfpr(82,1)=kflqm
      kfpr(82,2)=kflqm
      kfpr(83,1)=kflqm
      kfpr(84,1)=kflqm
      kfpr(84,2)=kflqm

c...find heaviest new fermion flavour allowed in process 85.
      kflfm=1
      do 150 i=1,min(12,mdcy(22,3))
      idc=i+mdcy(22,2)-1
      if(mdme(idc,1).le.0) goto 150
      kflfm=kfdp(idc,1)
  150 continue
      mint(56)=kflfm
      kfpr(85,1)=kflfm
      kfpr(85,2)=kflfm

c...flavours of leptoquark: redefine charge and name.
      kflqq=kfdp(mdcy(39,2),1)
      kflql=kfdp(mdcy(39,2),2)
      kchg(39,1)=kchg(iabs(kflqq),1)*isign(1,kflqq)+
     &kchg(iabs(kflql),1)*isign(1,kflql)
      chaf(39)(4:4)=chaf(iabs(kflqq))(1:1)
      chaf(39)(5:7)=chaf(iabs(kflql))(1:3)

c...special cases in treatment of gamma*/z0: redefine process name.
      if(mstp(43).eq.1) then
        proc(1)='f + f~ -> gamma*'
      elseif(mstp(43).eq.2) then
        proc(1)='f + f~ -> z0'
      elseif(mstp(43).eq.3) then
        proc(1)='f + f~ -> gamma*/z0'
      endif

c...special cases in treatment of gamma*/z0/z'0: redefine process name.
      if(mstp(44).eq.1) then
        proc(141)='f + f~ -> gamma*'
      elseif(mstp(44).eq.2) then
        proc(141)='f + f~ -> z0'
      elseif(mstp(44).eq.3) then
        proc(141)='f + f~ -> z''0'
      elseif(mstp(44).eq.4) then
        proc(141)='f + f~ -> gamma*/z0'
      elseif(mstp(44).eq.5) then
        proc(141)='f + f~ -> gamma*/z''0'
      elseif(mstp(44).eq.6) then
        proc(141)='f + f~ -> z0/z''0'
      elseif(mstp(44).eq.7) then
        proc(141)='f + f~ -> gamma*/z0/z''0'
      endif

c...special cases in treatment of ww -> ww: redefine process name.
      if(mstp(45).eq.1) then
        proc(77)='w+ + w+ -> w+ + w+'
      elseif(mstp(45).eq.2) then
        proc(77)='w+ + w- -> w+ + w-'
      elseif(mstp(45).eq.3) then
        proc(77)='w+/- + w+/- -> w+/- + w+/-'
      endif

c...format for error information.
 5000 format(1x,'error: unphysical input tan^2(beta) and m_h ',
     &'combination'/1x,'execution stopped!')

      return
      end

c*********************************************************************

      subroutine pyxtot
      implicit double precision (a-h,o-z)

c...parametrizes total, double diffractive, single diffractive and
c...elastic cross-sections for different energies and beams.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /ludat1/
      save /pypars/,/pyint1/,/pyint5/
      dimension bcs(5,8),bcb(2,5),bcc(3)

c...the following data lines are coefficients needed in the
c...block, cahn parametrization of total cross-section and nuclear
c...slope parameter; see below.
      data ((bcs(i,j),j=1,8),i=1,5)/
     1 41.74, 0.66, 0.0000, 337.,  0.0, 0.0, -39.3, 0.48,
     2 41.66, 0.60, 0.0000, 306.,  0.0, 0.0, -34.6, 0.51,
     3 41.36, 0.63, 0.0000, 299.,  7.3, 0.5, -40.4, 0.47,
     4 41.68, 0.63, 0.0083, 330.,  0.0, 0.0, -39.0, 0.48,
     5 41.13, 0.59, 0.0074, 278., 10.5, 0.5, -41.2, 0.46/
      data ((bcb(i,j),j=1,5),i=1,2)/
     1 10.79, -0.049, 0.040, 21.5, 1.23,
     2  9.92, -0.027, 0.013, 18.9, 1.07/
      data bcc/2.0164346,-0.5590311,0.0376279/

c...total cross-section and nuclear slope parameter for pp and p-pbar
      nfit=min(5,max(1,mstp(31)))
      sigp=bcs(nfit,1)+bcs(nfit,2)*(-0.25*paru(1)**2*
     &(1.-0.25*bcs(nfit,3)*paru(1)**2)+(1.+0.5*bcs(nfit,3)*paru(1)**2)*
     &(log(vint(2)/bcs(nfit,4)))**2+bcs(nfit,3)*
     &(log(vint(2)/bcs(nfit,4)))**4)/
     &((1.-0.25*bcs(nfit,3)*paru(1)**2)**2+2.*bcs(nfit,3)*
     &(1.+0.25*bcs(nfit,3)*paru(1)**2)*(log(vint(2)/bcs(nfit,4)))**2+
     &bcs(nfit,3)**2*(log(vint(2)/bcs(nfit,4)))**4)+bcs(nfit,5)*
     &vint(2)**(bcs(nfit,6)-1.)*sin(0.5*paru(1)*bcs(nfit,6))
      sigm=-bcs(nfit,7)*vint(2)**(bcs(nfit,8)-1.)*
     &cos(0.5*paru(1)*bcs(nfit,8))
      refp=bcs(nfit,2)*paru(1)*log(vint(2)/bcs(nfit,4))/
     &((1.-0.25*bcs(nfit,3)*paru(1)**2)**2+2.*bcs(nfit,3)*
     &(1.+0.25*bcs(nfit,3)*paru(1)**2)+(log(vint(2)/bcs(nfit,4)))**2+
     &bcs(nfit,3)**2*(log(vint(2)/bcs(nfit,4)))**4)-bcs(nfit,5)*
     &vint(2)**(bcs(nfit,6)-1.)*cos(0.5*paru(1)*bcs(nfit,6))
      refm=-bcs(nfit,7)*vint(2)**(bcs(nfit,8)-1.)*
     &sin(0.5*paru(1)*bcs(nfit,8))
      sigma=sigp-isign(1,mint(11)*mint(12))*sigm
      rho=(refp-isign(1,mint(11)*mint(12))*refm)/sigma

c...nuclear slope parameter b, curvature c:
      nfit=1
      if(mstp(31).ge.4) nfit=2
      bp=bcb(nfit,1)+bcb(nfit,2)*log(vint(2))+
     &bcb(nfit,3)*(log(vint(2)))**2
      bm=bcb(nfit,4)+bcb(nfit,5)*log(vint(2))
      b=bp-isign(1,mint(11)*mint(12))*sigm/sigp*(bm-bp)
      vint(121)=b
      c=-0.5*bcc(2)/bcc(3)*
     & (1.-sqrt(max(0.d0,1.+4.*bcc(3)/bcc(2)**2*
     & (1.d-03*vint(1)-bcc(1)))))
      vint(122)=c

c...elastic scattering cross-section (fixed by sigma-tot, rho and b).
      sigel=sigma**2*(1.+rho**2)/(16.*paru(1)*paru(5)*b)

c...single diffractive scattering cross-section from goulianos:
      sigsd=2.*0.68*(1.+36./vint(2))*log(0.6+0.1*vint(2))

c...double diffractive scattering cross-section (essentially fixed by
c...sigma-sd and sigma-el).
      sigdd=sigsd**2/(3.*sigel)

c...total non-elastic, non-diffractive cross-section.
      signd=sigma-sigdd-sigsd-sigel

c...rescale for pions.
      if(iabs(mint(11)).eq.211.and.iabs(mint(12)).eq.211) then
        sigma=4./9.*sigma
        sigdd=4./9.*sigdd
        sigsd=4./9.*sigsd
        sigel=4./9.*sigel
        signd=4./9.*signd
      elseif(iabs(mint(11)).eq.211.or.iabs(mint(12)).eq.211) then
        sigma=2./3.*sigma
        sigdd=2./3.*sigdd
        sigsd=2./3.*sigsd
        sigel=2./3.*sigel
        signd=2./3.*signd
      endif

c...save cross-sections in common block pypara.
      vint(101)=sigma
      vint(102)=sigel
      vint(103)=sigsd
      vint(104)=sigdd
      vint(106)=signd
      xsec(95,1)=signd

      return
      end

c*********************************************************************

      subroutine pymaxi
      implicit double precision (a-h,o-z)

c...finds optimal set of coefficients for kinematical variable selection
c...and the maximum of the part of the differential cross-section used
c...in the event weighting.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      common/pyint6/proc(0:200)
      character proc*28
      save /ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint4/,
     &/pyint5/,/pyint6/
      character cvar(4)*4
      dimension npts(4),mvarpt(500,4),vintpt(500,30),sigspt(500),
     &narel(7),wtrel(7),wtmat(7,7),wtreln(7),coefu(7),coefo(7),
     &iaccmx(4),sigsmx(4),sigssm(3)
      data cvar/'tau ','tau''','y*  ','cth '/

c...select subprocess to study: skip cases not applicable.
      nposi=0
      vint(143)=1.
      vint(144)=1.
      xsec(0,1)=0.
      do 410 isub=1,200
      if(isub.ge.91.and.isub.le.95) then
        xsec(isub,1)=vint(isub+11)
        if(msub(isub).ne.1) goto 410
        nposi=nposi+1
        goto 400
      elseif(isub.eq.96) then
        if(mint(44).ne.4) goto 410
        if(msub(95).ne.1.and.mstp(81).le.0.and.mstp(131).le.0) goto 410
      elseif(isub.eq.11.or.isub.eq.12.or.isub.eq.13.or.isub.eq.28.or.
     &isub.eq.53.or.isub.eq.68) then
        if(msub(isub).ne.1.or.msub(95).eq.1) goto 410
      else
        if(msub(isub).ne.1) goto 410
      endif
      mint(1)=isub
      istsb=iset(isub)
      if(isub.eq.96) istsb=2
      if(mstp(122).ge.2) write(mstu(11),5000) isub

c...find resonances (explicit or implicit in cross-section).
      mint(72)=0
      kfr1=0
      if(istsb.eq.1.or.istsb.eq.3.or.istsb.eq.5) then
        kfr1=kfpr(isub,1)
      elseif(isub.eq.24.or.isub.eq.25.or.isub.eq.171.or.isub.eq.176)
     &then
        kfr1=23
      elseif(isub.eq.23.or.isub.eq.26.or.isub.eq.172.or.isub.eq.177)
     &then
        kfr1=24
      elseif(isub.ge.71.and.isub.le.77) then
        kfr1=25
        if(mstp(46).eq.5) then
          kfr1=30
          pmas(30,1)=parp(45)
          pmas(30,2)=parp(45)**3/(96.*paru(1)*246.**2)
        endif
      endif
      ckmx=ckin(2)
      if(ckmx.le.0.) ckmx=vint(1)
      if(kfr1.ne.0) then
        if(ckin(1).gt.pmas(kfr1,1)+20.*pmas(kfr1,2).or.
     &  ckmx.lt.pmas(kfr1,1)-20.*pmas(kfr1,2)) kfr1=0
      endif
      if(kfr1.ne.0) then
        taur1=pmas(kfr1,1)**2/vint(2)
        gamr1=pmas(kfr1,1)*pmas(kfr1,2)/vint(2)
        mint(72)=1
        mint(73)=kfr1
        vint(73)=taur1
        vint(74)=gamr1
      endif
      if(isub.eq.141) then
        kfr2=23
        taur2=pmas(kfr2,1)**2/vint(2)
        gamr2=pmas(kfr2,1)*pmas(kfr2,2)/vint(2)
        if(ckin(1).gt.pmas(kfr2,1)+20.*pmas(kfr2,2).or.
     &  ckmx.lt.pmas(kfr2,1)-20.*pmas(kfr2,2)) kfr2=0
        if(kfr2.ne.0.and.kfr1.ne.0) then
          mint(72)=2
          mint(74)=kfr2
          vint(75)=taur2
          vint(76)=gamr2
        elseif(kfr2.ne.0) then
          kfr1=kfr2
          taur1=taur2
          gamr1=gamr2
          mint(72)=1
          mint(73)=kfr1
          vint(73)=taur1
          vint(74)=gamr1
        endif
      endif

c...find product masses and minimum pt of process.
      sqm3=0.
      sqm4=0.
      mint(71)=0
      vint(71)=ckin(3)
      vint(80)=1.
      if(istsb.eq.2.or.istsb.eq.4) then
        nbw=0
        do 100 i=1,2
        if(kfpr(isub,i).eq.0) then
        elseif(mstp(42).le.0.or.pmas(kfpr(isub,i),2).lt.parp(41)) then
          if(i.eq.1) sqm3=pmas(kfpr(isub,i),1)**2
          if(i.eq.2) sqm4=pmas(kfpr(isub,i),1)**2
        else
          nbw=nbw+1
        endif
  100   continue
        if(nbw.ge.1) then
          call pyofsh(3,0,kfpr(isub,1),kfpr(isub,2),0.,pqm3,pqm4)
          if(mint(51).eq.1) then
            write(mstu(11),5100) isub
            msub(isub)=0
            goto 410
          endif
          sqm3=pqm3**2
          sqm4=pqm4**2
        endif
        if(min(sqm3,sqm4).lt.ckin(6)**2) mint(71)=1
        if(mint(71).eq.1) vint(71)=max(ckin(3),ckin(5))
        if(isub.eq.96.and.mstp(82).le.1) vint(71)=parp(81)
        if(isub.eq.96.and.mstp(82).ge.2) vint(71)=0.08*parp(82)
      elseif(istsb.eq.6) then
        call pyofsh(5,0,kfpr(isub,1),kfpr(isub,2),0.,pqm3,pqm4)
        if(mint(51).eq.1) then
          write(mstu(11),5100) isub
          msub(isub)=0
          goto 410
        endif
        sqm3=pqm3**2
        sqm4=pqm4**2
      endif
      vint(63)=sqm3
      vint(64)=sqm4

c...prepare for additional variable choices in 2 -> 3.
      if(istsb.eq.5) then
        vint(201)=0.
        vint(206)=0.
        vint(204)=pmas(23,1)
        if(isub.eq.124) vint(204)=pmas(24,1)
        vint(209)=vint(204)
      endif

c...number of points for each variable: tau, tau', y*, cos(theta-hat).
      npts(1)=2+2*mint(72)
      if(mint(47).eq.1) then
        if(istsb.eq.1.or.istsb.eq.2.or.istsb.eq.6) npts(1)=1
      elseif(mint(47).eq.5) then
        if(istsb.le.2.or.istsb.ge.6) npts(1)=npts(1)+1
      endif
      npts(2)=1
      if(istsb.ge.3.and.istsb.le.5) then
        if(mint(47).ge.2) npts(2)=2
        if(mint(47).eq.5) npts(2)=3
      endif
      npts(3)=1
      if(mint(47).ge.4) npts(3)=3
      if(mint(45).eq.3) npts(3)=npts(3)+1
      if(mint(46).eq.3) npts(3)=npts(3)+1
      npts(4)=1
      if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) npts(4)=5
      ntry=npts(1)*npts(2)*npts(3)*npts(4)

c...reset coefficients of cross-section weighting.
      do 110 j=1,20
  110 coef(isub,j)=0.
      coef(isub,1)=1.
      coef(isub,8)=0.5
      coef(isub,9)=0.5
      coef(isub,13)=1.
      coef(isub,18)=1.
      mcth=0
      mtaup=0
      metaup=0
      vint(23)=0.
      vint(26)=0.
      sigsam=0.

c...find limits and select tau, y*, cos(theta-hat) and tau' values,
c...in grid of phase space points.
      call pyklim(1)
      metau=mint(51)
      nacc=0
      do 140 itry=1,ntry
      if(metau.eq.1) goto 140
      if(mod(itry-1,npts(2)*npts(3)*npts(4)).eq.0) then
        mtau=1+(itry-1)/(npts(2)*npts(3)*npts(4))
        if(mtau.gt.2+2*mint(72)) mtau=7
        call pykmap(1,mtau,0.5d0)
        if(istsb.ge.3.and.istsb.le.5) call pyklim(4)
        metaup=mint(51)
      endif
      if(metaup.eq.1) goto 140
      if(istsb.ge.3.and.istsb.le.5.and.mod(itry-1,npts(3)*npts(4)).
     &eq.0) then
        mtaup=1+mod((itry-1)/(npts(3)*npts(4)),npts(2))
        call pykmap(4,mtaup,0.5d0)
      endif
      if(mod(itry-1,npts(3)*npts(4)).eq.0) then
        call pyklim(2)
        meyst=mint(51)
      endif
      if(meyst.eq.1) goto 140
      if(mod(itry-1,npts(4)).eq.0) then
        myst=1+mod((itry-1)/npts(4),npts(3))
        if(myst.eq.4.and.mint(45).ne.3) myst=5
        call pykmap(2,myst,0.5d0)
        call pyklim(3)
        mecth=mint(51)
      endif
      if(mecth.eq.1) goto 140
      if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) then
        mcth=1+mod(itry-1,npts(4))
        call pykmap(3,mcth,0.5d0)
      endif
      if(isub.eq.96) vint(25)=vint(21)*(1.-vint(23)**2)

c...store position and limits.
      mint(51)=0
      call pyklim(0)
      if(mint(51).eq.1) goto 140
      nacc=nacc+1
      mvarpt(nacc,1)=mtau
      mvarpt(nacc,2)=mtaup
      mvarpt(nacc,3)=myst
      mvarpt(nacc,4)=mcth
      do 120 j=1,30
  120 vintpt(nacc,j)=vint(10+j)

c...normal case: calculate cross-section.
      if(istsb.ne.5) then
        call pysigh(nchn,sigs)

c..2 -> 3: find highest value out of a number of tries.
      else
        sigs=0.
        do 130 ikin3=1,mstp(129)
        call pykmap(5,0,0.d0)
        if(mint(51).eq.1) goto 130
        call pysigh(nchn,sigtmp)
        if(sigtmp.gt.sigs) sigs=sigtmp
  130   continue
      endif

c...store cross-section.
      sigspt(nacc)=sigs
      if(sigs.gt.sigsam) sigsam=sigs
      if(mstp(122).ge.2) write(mstu(11),5200) mtau,myst,mcth,mtaup,
     &vint(21),vint(22),vint(23),vint(26),sigs
  140 continue
      if(nacc.eq.0) then
        write(mstu(11),5100) isub
        msub(isub)=0
        goto 410
      elseif(sigsam.eq.0.) then
        write(mstu(11),5300) isub
        msub(isub)=0
        goto 410
      endif
      if(isub.ne.96) nposi=nposi+1

c...calculate integrals in tau over maximal phase space limits.
      taumin=vint(11)
      taumax=vint(31)
      atau1=log(taumax/taumin)
      if(npts(1).ge.2) then
        atau2=(taumax-taumin)/(taumax*taumin)
      endif
      if(npts(1).ge.4) then
        atau3=log(taumax/taumin*(taumin+taur1)/(taumax+taur1))/taur1
        atau4=(atan((taumax-taur1)/gamr1)-atan((taumin-taur1)/gamr1))/
     &  gamr1
      endif
      if(npts(1).ge.6) then
        atau5=log(taumax/taumin*(taumin+taur2)/(taumax+taur2))/taur2
        atau6=(atan((taumax-taur2)/gamr2)-atan((taumin-taur2)/gamr2))/
     &  gamr2
      endif
      if(npts(1).gt.2+2*mint(72)) then
        atau7=log(max(2d-6,1.-taumin)/max(2d-6,1.-taumax))
      endif

c...reset. sum up cross-sections in points calculated.
      do 270 ivar=1,4
      if(npts(ivar).eq.1) goto 270
      if(isub.eq.96.and.ivar.eq.4) goto 270
      nbin=npts(ivar)
      do 150 j1=1,nbin
      narel(j1)=0
      wtrel(j1)=0.
      coefu(j1)=0.
      do 150 j2=1,nbin
  150 wtmat(j1,j2)=0.
      do 160 iacc=1,nacc
      ibin=mvarpt(iacc,ivar)
      if(ivar.eq.1.and.ibin.eq.7) ibin=3+2*mint(72)
      if(ivar.eq.3.and.ibin.eq.5.and.mint(45).ne.3) ibin=4
      narel(ibin)=narel(ibin)+1
      wtrel(ibin)=wtrel(ibin)+sigspt(iacc)

c...sum up tau cross-section pieces in points used.
      if(ivar.eq.1) then
        tau=vintpt(iacc,11)
        wtmat(ibin,1)=wtmat(ibin,1)+1.
        wtmat(ibin,2)=wtmat(ibin,2)+(atau1/atau2)/tau
        if(nbin.ge.4) then
          wtmat(ibin,3)=wtmat(ibin,3)+(atau1/atau3)/(tau+taur1)
          wtmat(ibin,4)=wtmat(ibin,4)+(atau1/atau4)*tau/
     &    ((tau-taur1)**2+gamr1**2)
        endif
        if(nbin.ge.6) then
          wtmat(ibin,5)=wtmat(ibin,5)+(atau1/atau5)/(tau+taur2)
          wtmat(ibin,6)=wtmat(ibin,6)+(atau1/atau6)*tau/
     &    ((tau-taur2)**2+gamr2**2)
        endif
        if(nbin.gt.2+2*mint(72)) then
          wtmat(ibin,nbin)=wtmat(ibin,nbin)+(atau1/atau7)*
     &    tau/max(2d-6,1.-tau)
        endif

c...sum up tau' cross-section pieces in points used.
      elseif(ivar.eq.2) then
        tau=vintpt(iacc,11)
        taup=vintpt(iacc,16)
        taupmn=vintpt(iacc,6)
        taupmx=vintpt(iacc,26)
        ataup1=log(taupmx/taupmn)
        ataup2=((1.-tau/taupmx)**4-(1.-tau/taupmn)**4)/(4.*tau)
        wtmat(ibin,1)=wtmat(ibin,1)+1.
        wtmat(ibin,2)=wtmat(ibin,2)+(ataup1/ataup2)*(1.-tau/taup)**3/
     &  taup
        if(nbin.ge.3) then
          ataup3=log(max(2d-6,1.-taupmn)/max(2d-6,1.-taupmx))
          wtmat(ibin,3)=wtmat(ibin,3)+(ataup1/ataup3)*
     &    taup/max(2d-6,1.-taup)
        endif

c...sum up y* cross-section pieces in points used.
      elseif(ivar.eq.3) then
        yst=vintpt(iacc,12)
        ystmin=vintpt(iacc,2)
        ystmax=vintpt(iacc,22)
        ayst0=ystmax-ystmin
        ayst1=0.5*(ystmax-ystmin)**2
        ayst2=ayst1
        ayst3=2.*(atan(exp(ystmax))-atan(exp(ystmin)))
        wtmat(ibin,1)=wtmat(ibin,1)+(ayst0/ayst1)*(yst-ystmin)
        wtmat(ibin,2)=wtmat(ibin,2)+(ayst0/ayst2)*(ystmax-yst)
        wtmat(ibin,3)=wtmat(ibin,3)+(ayst0/ayst3)/cosh(yst)
        if(mint(45).eq.3) then
          taue=vintpt(iacc,11)
          if(istsb.ge.3.and.istsb.le.5) taue=vintpt(iacc,16)
          yst0=-0.5*log(taue)
          ayst4=log(max(1d-6,exp(yst0-ystmin)-1.)/
     &    max(1d-6,exp(yst0-ystmax)-1.))
          wtmat(ibin,4)=wtmat(ibin,4)+(ayst0/ayst4)/
     &    max(1d-6,1.-exp(yst-yst0))
        endif
        if(mint(46).eq.3) then
          taue=vintpt(iacc,11)
          if(istsb.ge.3.and.istsb.le.5) taue=vintpt(iacc,16)
          yst0=-0.5*log(taue)
          ayst5=log(max(1d-6,exp(yst0+ystmax)-1.)/
     &    max(1d-6,exp(yst0+ystmin)-1.))
          wtmat(ibin,nbin)=wtmat(ibin,nbin)+(ayst0/ayst5)/
     &    max(1d-6,1.-exp(-yst-yst0))
        endif

c...sum up cos(theta-hat) cross-section pieces in points used.
      else
        rm34=2.*sqm3*sqm4/(vintpt(iacc,11)*vint(2))**2
        rsqm=1.+rm34
        cthmax=sqrt(1.-4.*vint(71)**2/(taumax*vint(2)))
        cthmin=-cthmax
        if(cthmax.gt.0.9999) rm34=max(rm34,2.*vint(71)**2/
     &  (taumax*vint(2)))
        acth1=cthmax-cthmin
        acth2=log(max(rm34,rsqm-cthmin)/max(rm34,rsqm-cthmax))
        acth3=log(max(rm34,rsqm+cthmax)/max(rm34,rsqm+cthmin))
        acth4=1./max(rm34,rsqm-cthmax)-1./max(rm34,rsqm-cthmin)
        acth5=1./max(rm34,rsqm+cthmin)-1./max(rm34,rsqm+cthmax)
        cth=vintpt(iacc,13)
        wtmat(ibin,1)=wtmat(ibin,1)+1.
        wtmat(ibin,2)=wtmat(ibin,2)+(acth1/acth2)/max(rm34,rsqm-cth)
        wtmat(ibin,3)=wtmat(ibin,3)+(acth1/acth3)/max(rm34,rsqm+cth)
        wtmat(ibin,4)=wtmat(ibin,4)+(acth1/acth4)/max(rm34,rsqm-cth)**2
        wtmat(ibin,5)=wtmat(ibin,5)+(acth1/acth5)/max(rm34,rsqm+cth)**2
      endif
  160 continue

c...check that equation system solvable; else trivial way out.
      if(mstp(122).ge.2) write(mstu(11),5400) cvar(ivar)
      msolv=1
      wtrels=0.
      do 170 ibin=1,nbin
      if(mstp(122).ge.2) write(mstu(11),5500) (wtmat(ibin,ired),
     &ired=1,nbin),wtrel(ibin)
      if(narel(ibin).eq.0) msolv=0
  170 wtrels=wtrels+wtrel(ibin)
      if(msolv.eq.0) then
        do 180 ibin=1,nbin
        coefu(ibin)=1.
        wtreln(ibin)=0.1
  180   if(wtrels.gt.0.) wtreln(ibin)=max(0.1d0,wtrel(ibin)/wtrels)

c...solve to find relative importance of cross-section pieces.
      else
        do 190 ibin=1,nbin
  190   wtreln(ibin)=max(0.1d0,wtrel(ibin)/wtrels)
        do 200 ired=1,nbin-1
        do 200 ibin=ired+1,nbin
        rqt=wtmat(ibin,ired)/wtmat(ired,ired)
        wtrel(ibin)=wtrel(ibin)-rqt*wtrel(ired)
        do 200 icoe=ired,nbin
  200   wtmat(ibin,icoe)=wtmat(ibin,icoe)-rqt*wtmat(ired,icoe)
        do 220 ired=nbin,1,-1
        do 210 icoe=ired+1,nbin
  210   wtrel(ired)=wtrel(ired)-wtmat(ired,icoe)*coefu(icoe)
  220   coefu(ired)=wtrel(ired)/wtmat(ired,ired)
      endif

c...normalize coefficients, with piece shared democratically.
      coefsu=0.
      wtrels=0.
      do 230 ibin=1,nbin
      coefu(ibin)=max(0.d0,coefu(ibin))
      coefsu=coefsu+coefu(ibin)
  230 wtrels=wtrels+wtreln(ibin)
      if(coefsu.gt.0.) then
        do 240 ibin=1,nbin
  240   coefo(ibin)=parp(122)/nbin+(1.-parp(122))*0.5*
     &  (coefu(ibin)/coefsu+wtreln(ibin)/wtrels)
      else
        do 250 ibin=1,nbin
  250   coefo(ibin)=1./nbin
      endif
      if(ivar.eq.1) ioff=0
      if(ivar.eq.2) ioff=17
      if(ivar.eq.3) ioff=7
      if(ivar.eq.4) ioff=12
      do 260 ibin=1,nbin
      icof=ioff+ibin
      if(ivar.eq.1.and.ibin.gt.2+2*mint(72)) icof=7
      if(ivar.eq.3.and.ibin.eq.4.and.mint(45).ne.3) icof=icof+1
  260 coef(isub,icof)=coefo(ibin)
      if(mstp(122).ge.2) write(mstu(11),5600) cvar(ivar),
     &(coefo(ibin),ibin=1,nbin)
  270 continue

c...find two most promising maxima among points previously determined.
      do 280 j=1,4
      iaccmx(j)=0
  280 sigsmx(j)=0.
      nmax=0
      do 340 iacc=1,nacc
      do 290 j=1,30
  290 vint(10+j)=vintpt(iacc,j)
      if(istsb.ne.5) then
        call pysigh(nchn,sigs)
      else
        sigs=0.
        do 300 ikin3=1,mstp(129)
        call pykmap(5,0,0.d0)
        if(mint(51).eq.1) goto 300
        call pysigh(nchn,sigtmp)
        if(sigtmp.gt.sigs) sigs=sigtmp
  300   continue
      endif
      ieq=0
      do 310 imv=1,nmax
  310 if(abs(sigs-sigsmx(imv)).lt.1e-4*(sigs+sigsmx(imv))) ieq=imv
      if(ieq.eq.0) then
        do 320 imv=nmax,1,-1
        iin=imv+1
        if(sigs.le.sigsmx(imv)) goto 330
        iaccmx(imv+1)=iaccmx(imv)
  320   sigsmx(imv+1)=sigsmx(imv)
        iin=1
  330   iaccmx(iin)=iacc
        sigsmx(iin)=sigs
        if(nmax.le.1) nmax=nmax+1
      endif
  340 continue

c...read out starting position for search.
      if(mstp(122).ge.2) write(mstu(11),5700)
      sigsam=sigsmx(1)
      do 390 imax=1,nmax
      iacc=iaccmx(imax)
      mtau=mvarpt(iacc,1)
      mtaup=mvarpt(iacc,2)
      myst=mvarpt(iacc,3)
      mcth=mvarpt(iacc,4)
      vtau=0.5
      vyst=0.5
      vcth=0.5
      vtaup=0.5

c...starting point and step size in parameter space.
      do 380 irpt=1,2
      do 370 ivar=1,4
      if(npts(ivar).eq.1) goto 370
      if(ivar.eq.1) vvar=vtau
      if(ivar.eq.2) vvar=vtaup
      if(ivar.eq.3) vvar=vyst
      if(ivar.eq.4) vvar=vcth
      if(ivar.eq.1) mvar=mtau
      if(ivar.eq.2) mvar=mtaup
      if(ivar.eq.3) mvar=myst
      if(ivar.eq.4) mvar=mcth
      if(irpt.eq.1) vdel=0.1
      if(irpt.eq.2)
     &   vdel=max(0.01d0,min(0.05d0,vvar-0.02,0.98-vvar))
      if(irpt.eq.1) vmar=0.02
      if(irpt.eq.2) vmar=0.002
      imov0=1
      if(irpt.eq.1.and.ivar.eq.1) imov0=0
      do 360 imov=imov0,8

c...define new point in parameter space.
      if(imov.eq.0) then
        inew=2
        vnew=vvar
      elseif(imov.eq.1) then
        inew=3
        vnew=vvar+vdel
      elseif(imov.eq.2) then
        inew=1
        vnew=vvar-vdel
      elseif(sigssm(3).ge.max(sigssm(1),sigssm(2)).and.
     &vvar+2.*vdel.lt.1.-vmar) then
        vvar=vvar+vdel
        sigssm(1)=sigssm(2)
        sigssm(2)=sigssm(3)
        inew=3
        vnew=vvar+vdel
      elseif(sigssm(1).ge.max(sigssm(2),sigssm(3)).and.
     &vvar-2.*vdel.gt.vmar) then
        vvar=vvar-vdel
        sigssm(3)=sigssm(2)
        sigssm(2)=sigssm(1)
        inew=1
        vnew=vvar-vdel
      elseif(sigssm(3).ge.sigssm(1)) then
        vdel=0.5*vdel
        vvar=vvar+vdel
        sigssm(1)=sigssm(2)
        inew=2
        vnew=vvar
      else
        vdel=0.5*vdel
        vvar=vvar-vdel
        sigssm(3)=sigssm(2)
        inew=2
        vnew=vvar
      endif

c...convert to relevant variables and find derived new limits.
      if(ivar.eq.1) then
        vtau=vnew
        call pykmap(1,mtau,vtau)
        if(istsb.ge.3.and.istsb.le.5) call pyklim(4)
      endif
      if(ivar.le.2.and.istsb.ge.3.and.istsb.le.5) then
        if(ivar.eq.2) vtaup=vnew
        call pykmap(4,mtaup,vtaup)
      endif
      if(ivar.le.2) call pyklim(2)
      if(ivar.le.3) then
        if(ivar.eq.3) vyst=vnew
        call pykmap(2,myst,vyst)
        call pyklim(3)
      endif
      if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) then
        if(ivar.eq.4) vcth=vnew
        call pykmap(3,mcth,vcth)
      endif
      if(isub.eq.96) vint(25)=vint(21)*(1.-vint(23)**2)

c...evaluate cross-section. save new maximum. final maximum.
      if(istsb.ne.5) then
        call pysigh(nchn,sigs)
      else
        sigs=0.
        do 350 ikin3=1,mstp(129)
        call pykmap(5,0,0.d0)
        if(mint(51).eq.1) goto 350
        call pysigh(nchn,sigtmp)
        if(sigtmp.gt.sigs) sigs=sigtmp
  350   continue
      endif
      sigssm(inew)=sigs
      if(sigs.gt.sigsam) sigsam=sigs
      if(mstp(122).ge.2) write(mstu(11),5800) imax,ivar,mvar,imov,
     &vnew,vint(21),vint(22),vint(23),vint(26),sigs
  360 continue
  370 continue
  380 continue
  390 continue
      if(mstp(121).eq.1) sigsam=parp(121)*sigsam
      xsec(isub,1)=1.05*sigsam
  400 if(isub.ne.96) xsec(0,1)=xsec(0,1)+xsec(isub,1)
  410 continue

c...print summary table.
      if(nposi.eq.0) then
        write(mstu(11),5900)
        stop
      endif
      if(mstp(122).ge.1) then
        write(mstu(11),6000)
        write(mstu(11),6100)
        do 420 isub=1,200
        if(msub(isub).ne.1.and.isub.ne.96) goto 420
        if(isub.eq.96.and.mint(44).ne.4) goto 420
        if(isub.eq.96.and.msub(95).ne.1.and.mstp(81).le.0) goto 420
        if(msub(95).eq.1.and.(isub.eq.11.or.isub.eq.12.or.isub.eq.13.or.
     &  isub.eq.28.or.isub.eq.53.or.isub.eq.68)) goto 420
        write(mstu(11),6200) isub,proc(isub),xsec(isub,1)
  420   continue
        write(mstu(11),6300)
      endif

c...format statements for maximization results.
 5000 format(/1x,'coefficient optimization and maximum search for ',
     &'subprocess no',i4/1x,'coefficient modes     tau',10x,'y*',9x,
     &'cth',9x,'tau''',7x,'sigma')
 5100 format(1x,'warning: requested subprocess ',i3,' has no allowed ',
     &'phase space.'/1x,'process switched off!')
 5200 format(1x,4i4,f12.8,f12.6,f12.7,f12.8,1p,e12.4)
 5300 format(1x,'warning: requested subprocess ',i3,' has vanishing ',
     &'cross-section.'/1x,'process switched off!')
 5400 format(1x,'coefficients of equation system to be solved for ',a4)
 5500 format(1x,1p,8e11.3)
 5600 format(1x,'result for ',a4,':',7f9.4)
 5700 format(1x,'maximum search for given coefficients'/2x,'max var ',
     &'mod mov   vnew',7x,'tau',7x,'y*',8x,'cth',7x,'tau''',7x,'sigma')
 5800 format(1x,4i4,f8.4,f11.7,f9.3,f11.6,f11.7,1p,e12.4)
 5900 format(1x,'error: no requested process has non-vanishing ',
     &'cross-section.'/1x,'execution stopped!')
 6000 format(/1x,8('*'),1x,'pymaxi: summary of differential ',
     &'cross-section maximum search',1x,8('*'))
 6100 format(/11x,58('=')/11x,'i',38x,'i',17x,'i'/11x,'i  isub  ',
     &'subprocess name',15x,'i  maximum value  i'/11x,'i',38x,'i',
     &17x,'i'/11x,58('=')/11x,'i',38x,'i',17x,'i')
 6200 format(11x,'i',2x,i3,3x,a28,2x,'i',2x,1p,e12.4,3x,'i')
 6300 format(11x,'i',38x,'i',17x,'i'/11x,58('='))

      return
      end

c*********************************************************************

      subroutine pypile(mpile)
      implicit double precision (a-h,o-z)

c...initializes multiplicity distribution and selects mutliplicity
c...of pileup events, i.e. several events occuring at the same
c...beam crossing.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /ludat1/
      save /pypars/,/pyint1/
      dimension wti(0:200)
      save imin,imax,wti,wts

c...sum of allowed cross-sections for pileup events.
      if(mpile.eq.1) then
        vint(131)=vint(106)
        if(mstp(132).ge.2) vint(131)=vint(131)+vint(104)
        if(mstp(132).ge.3) vint(131)=vint(131)+vint(103)
        if(mstp(132).ge.4) vint(131)=vint(131)+vint(102)
        if(mstp(133).le.0) return

c...initialize multiplicity distribution at maximum.
        xnave=vint(131)*parp(131)
        if(xnave.gt.120.) write(mstu(11),5000) xnave
        inave=max(1,min(200,nint(xnave)))
        wti(inave)=1.
        wts=wti(inave)
        wtn=wti(inave)*inave

c...find shape of multiplicity distribution below maximum.
        do 100 i=inave-1,1,-1
        if(mstp(133).eq.1) wti(i)=wti(i+1)*(i+1)/xnave
        if(mstp(133).ge.2) wti(i)=wti(i+1)*i/xnave
        if(wti(i).lt.1e-6) goto 110
        wts=wts+wti(i)
        wtn=wtn+wti(i)*i
  100   imin=i

c...find shape of multiplicity distribution above maximum.
  110   do 120 i=inave+1,200
        if(mstp(133).eq.1) wti(i)=wti(i-1)*xnave/i
        if(mstp(133).ge.2) wti(i)=wti(i-1)*xnave/(i-1)
        if(wti(i).lt.1e-6) goto 130
        wts=wts+wti(i)
        wtn=wtn+wti(i)*i
  120   imax=i
  130   vint(132)=xnave
        vint(133)=wtn/wts
        if(mstp(133).eq.1.and.imin.eq.1) vint(134)=
     &  wts/(wts+wti(1)/xnave)
        if(mstp(133).eq.1.and.imin.gt.1) vint(134)=1.
        if(mstp(133).ge.2) vint(134)=xnave

c...pick multiplicity of pileup events.
      else
        if(mstp(133).le.0) then
          mint(81)=max(1,mstp(134))
        else
          wtr=wts*rlu(0)
          do 140 i=imin,imax
          mint(81)=i
          wtr=wtr-wti(i)
          if(wtr.le.0.) goto 150
  140     continue
  150     continue
        endif
      endif

c...format statement for error message.
 5000 format(1x,'warning: requested average number of events per bunch',
     &'crossing too large, ',1p,e12.4)

      return
      end

c*********************************************************************

      subroutine pyrand
      implicit double precision (a-h,o-z)

c...generates quantities characterizing the high-pt scattering at the
c...parton level according to the matrix elements. chooses incoming,
c...reacting partons, their momentum fractions and one of the possible
c...subprocesses.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint4/,
     &/pyint5/
      double precision sh,sqm1,sqm2,sqm3,sqm4,sqla12,sqla34,
     &thter1,thter2,thl,thu,thm,sqmmin,sqmmax,sqmi,sqmj,sqmf,
     &squa,quar,b,c,expth,tharg,ratlog,th

c...initial values, specifically for (first) semihard interaction.
      mint(17)=0
      mint(18)=0
      vint(143)=1.
      vint(144)=1.
      if(mint(82).eq.1) ngen(0,2)=ngen(0,2)+1
      if(msub(95).eq.1.or.mint(82).ge.2) call pymult(2)
      isub=0
  100 mint(51)=0

c...choice of process type - first event of pileup.
      if(mint(82).eq.1.and.(isub.le.90.or.isub.gt.96)) then
        rsub=xsec(0,1)*rlu(0)
        do 110 i=1,200
        if(msub(i).ne.1) goto 110
        isub=i
        rsub=rsub-xsec(i,1)
        if(rsub.le.0.) goto 120
  110   continue
  120   if(isub.eq.95) isub=96

c...choice of inclusive process type - pileup events.
      elseif(mint(82).ge.2.and.isub.eq.0) then
        rsub=vint(131)*rlu(0)
        isub=96
        if(rsub.gt.vint(106)) isub=93
        if(rsub.gt.vint(106)+vint(104)) isub=92
        if(rsub.gt.vint(106)+vint(104)+vint(103)) isub=91
      endif
      if(mint(82).eq.1) ngen(0,1)=ngen(0,1)+1
      if(mint(82).eq.1) ngen(isub,1)=ngen(isub,1)+1
      mint(1)=isub
      istsb=iset(isub)

c...find resonances (explicit or implicit in cross-section).
      mint(72)=0
      kfr1=0
      if(istsb.eq.1.or.istsb.eq.3.or.istsb.eq.5) then
        kfr1=kfpr(isub,1)
      elseif(isub.eq.24.or.isub.eq.25.or.isub.eq.171.or.isub.eq.176)
     &then
        kfr1=23
      elseif(isub.eq.23.or.isub.eq.26.or.isub.eq.172.or.isub.eq.177)
     &then
        kfr1=24
      elseif(isub.ge.71.and.isub.le.77) then
        kfr1=25
        if(mstp(46).eq.5) then
          kfr1=30
          pmas(30,1)=parp(45)
          pmas(30,2)=parp(45)**3/(96.*paru(1)*246.**2)
        endif
      endif
      ckmx=ckin(2)
      if(ckmx.le.0.) ckmx=vint(1)
      if(kfr1.ne.0) then
        if(ckin(1).gt.pmas(kfr1,1)+20.*pmas(kfr1,2).or.
     &  ckmx.lt.pmas(kfr1,1)-20.*pmas(kfr1,2)) kfr1=0
      endif
      if(kfr1.ne.0) then
        taur1=pmas(kfr1,1)**2/vint(2)
        gamr1=pmas(kfr1,1)*pmas(kfr1,2)/vint(2)
        mint(72)=1
        mint(73)=kfr1
        vint(73)=taur1
        vint(74)=gamr1
      endif
      if(isub.eq.141) then
        kfr2=23
        taur2=pmas(kfr2,1)**2/vint(2)
        gamr2=pmas(kfr2,1)*pmas(kfr2,2)/vint(2)
        if(ckin(1).gt.pmas(kfr2,1)+20.*pmas(kfr2,2).or.
     &  ckmx.lt.pmas(kfr2,1)-20.*pmas(kfr2,2)) kfr2=0
        if(kfr2.ne.0.and.kfr1.ne.0) then
          mint(72)=2
          mint(74)=kfr2
          vint(75)=taur2
          vint(76)=gamr2
        elseif(kfr2.ne.0) then
          kfr1=kfr2
          taur1=taur2
          gamr1=gamr2
          mint(72)=1
          mint(73)=kfr1
          vint(73)=taur1
          vint(74)=gamr1
        endif
      endif

c...find product masses and minimum pt of process,
c...optionally with broadening according to a truncated breit-wigner.
      vint(63)=0.
      vint(64)=0.
      mint(71)=0
      vint(71)=ckin(3)
      if(mint(82).ge.2) vint(71)=0.
      vint(80)=1.
      if(istsb.eq.2.or.istsb.eq.4) then
        nbw=0
        do 130 i=1,2
        if(kfpr(isub,i).eq.0) then
        elseif(mstp(42).le.0.or.pmas(kfpr(isub,i),2).lt.parp(41)) then
          vint(62+i)=pmas(kfpr(isub,i),1)**2
        else
          nbw=nbw+1
        endif
  130   continue
        if(nbw.ge.1) then
          call pyofsh(4,0,kfpr(isub,1),kfpr(isub,2),0.d0,pqm3,pqm4)
          if(mint(51).eq.1) goto 100
          vint(63)=pqm3**2
          vint(64)=pqm4**2
        endif
        if(min(vint(63),vint(64)).lt.ckin(6)**2) mint(71)=1
        if(mint(71).eq.1) vint(71)=max(ckin(3),ckin(5))
      elseif(istsb.eq.6) then
        call pyofsh(6,0,kfpr(isub,1),kfpr(isub,2),0.,pqm3,pqm4)
        if(mint(51).eq.1) goto 100
        vint(63)=pqm3**2
        vint(64)=pqm4**2
      endif

c...prepare for additional variable choices in 2 -> 3.
      if(istsb.eq.5) then
        vint(201)=0.
        vint(206)=0.
        vint(204)=pmas(23,1)
        if(isub.eq.124) vint(204)=pmas(24,1)
        vint(209)=vint(204)
      endif

      if(istsb.eq.0) then
c...double or single diffractive, or elastic scattering:
c...choose m^2 according to 1/m^2 (diffractive), constant (elastic)
        is=int(1.5+rlu(0))
        vint(63)=vint(3)**2
        vint(64)=vint(4)**2
        if(isub.eq.92.or.isub.eq.93) vint(62+is)=parp(111)**2
        if(isub.eq.93) vint(65-is)=parp(111)**2
        sh=vint(2)
        sqm1=vint(3)**2
        sqm2=vint(4)**2
        sqm3=vint(63)
        sqm4=vint(64)
        sqla12=(sh-sqm1-sqm2)**2-4d0*sqm1*sqm2
        sqla34=(sh-sqm3-sqm4)**2-4d0*sqm3*sqm4
        thter1=sqm1+sqm2+sqm3+sqm4-(sqm1-sqm2)*(sqm3-sqm4)/sh-sh
        thter2=sqrt(max(0d0,sqla12))*sqrt(max(0d0,sqla34))/sh
        thl=0.5d0*(thter1-thter2)
        thu=0.5d0*(thter1+thter2)
        thm=min(max(thl,parp(101)),thu)
        jtmax=0
        if(isub.eq.92.or.isub.eq.93) jtmax=isub-91
        do 140 jt=1,jtmax
        mint(13+3*jt-is*(2*jt-3))=1
        sqmmin=vint(59+3*jt-is*(2*jt-3))
        sqmi=vint(8-3*jt+is*(2*jt-3))**2
        sqmj=vint(3*jt-1-is*(2*jt-3))**2
        sqmf=vint(68-3*jt+is*(2*jt-3))
        squa=0.5d0*sh/sqmi*((1d0+(sqmi-sqmj)/sh)*thm+sqmi-sqmf-
     &  sqmj**2/sh+(sqmi+sqmj)*sqmf/sh+(sqmi-sqmj)**2/sh**2*sqmf)
        quar=sh/sqmi*(thm*(thm+sh-sqmi-sqmj-sqmf*(1d0-(sqmi-sqmj)/sh))+
     &  sqmi*sqmj-sqmj*sqmf*(1d0+(sqmi-sqmj-sqmf)/sh))
        sqmmax=squa+sqrt(max(0d0,squa**2-quar))
        if(abs(quar/squa**2).lt.1.d-06) sqmmax=0.5d0*quar/squa
        sqmmax=min(sqmmax,(vint(1)-sqrt(sqmf))**2)
        vint(59+3*jt-is*(2*jt-3))=sqmmin*(sqmmax/sqmmin)**rlu(0)
  140   continue
c...choose t-hat according to exp(b*t-hat+c*t-hat^2).
        sqm3=vint(63)
        sqm4=vint(64)
        sqla34=(sh-sqm3-sqm4)**2-4d0*sqm3*sqm4
        thter1=sqm1+sqm2+sqm3+sqm4-(sqm1-sqm2)*(sqm3-sqm4)/sh-sh
        thter2=sqrt(max(0d0,sqla12))*sqrt(max(0d0,sqla34))/sh
        thl=0.5d0*(thter1-thter2)
        thu=0.5d0*(thter1+thter2)
        b=vint(121)
        c=vint(122)
        if(isub.eq.92.or.isub.eq.93) then
          b=0.5d0*b
          c=0.5d0*c
        endif
        thm=min(max(thl,parp(101)),thu)
        expth=0d0
        tharg=b*(thm-thu)
        if(tharg.gt.-20d0) expth=exp(tharg)
  150   th=thu+log(expth+(1d0-expth)*rlu(0))/b
        th=max(thm,min(thu,th))
        ratlog=min((b+c*(th+thm))*(th-thm),(b+c*(th+thu))*(th-thu))
        if(ratlog.lt.log(rlu(0))) goto 150
        vint(21)=1.
        vint(22)=0.
        vint(23)=min(1d0,max(-1d0,(2d0*th-thter1)/thter2))

c...note: in the following, by in is meant the integral over the
c...quantity multiplying coefficient cn.
c...choose tau according to h1(tau)/tau, where
c...h1(tau) = c1 + i1/i2*c2*1/tau + i1/i3*c3*1/(tau+tau_r) +
c...i1/i4*c4*tau/((s*tau-m^2)^2+(m*gamma)^2) +
c...i1/i5*c5*1/(tau+tau_r') +
c...i1/i6*c6*tau/((s*tau-m'^2)^2+(m'*gamma')^2) +
c...i1/i7*c7*tau/(1.-tau), and
c...c1 + c2 + c3 + c4 + c5 + c6 + c7 = 1.
      elseif(istsb.ge.1.and.istsb.le.6) then
        call pyklim(1)
        if(mint(51).ne.0) goto 100
        rtau=rlu(0)
        mtau=1
        if(rtau.gt.coef(isub,1)) mtau=2
        if(rtau.gt.coef(isub,1)+coef(isub,2)) mtau=3
        if(rtau.gt.coef(isub,1)+coef(isub,2)+coef(isub,3)) mtau=4
        if(rtau.gt.coef(isub,1)+coef(isub,2)+coef(isub,3)+coef(isub,4))
     &  mtau=5
        if(rtau.gt.coef(isub,1)+coef(isub,2)+coef(isub,3)+coef(isub,4)+
     &  coef(isub,5)) mtau=6
        if(rtau.gt.coef(isub,1)+coef(isub,2)+coef(isub,3)+coef(isub,4)+
     &  coef(isub,5)+coef(isub,6)) mtau=7
        call pykmap(1,mtau,rlu(0))

c...2 -> 3, 4 processes:
c...choose tau' according to h4(tau,tau')/tau', where
c...h4(tau,tau') = c1 + i1/i2*c2*(1 - tau/tau')^3/tau' +
c...i1/i3*c3*1/(1 - tau'), and c1 + c2 + c3 = 1.
        if(istsb.ge.3.and.istsb.le.5) then
          call pyklim(4)
          if(mint(51).ne.0) goto 100
          rtaup=rlu(0)
          mtaup=1
          if(rtaup.gt.coef(isub,18)) mtaup=2
          if(rtaup.gt.coef(isub,18)+coef(isub,19)) mtaup=3
          call pykmap(4,mtaup,rlu(0))
        endif

c...choose y* according to h2(y*), where
c...h2(y*) = i0/i1*c1*(y*-y*min) + i0/i2*c2*(y*max-y*) +
c...i0/i3*c3*1/cosh(y*) + i0/i4*c4*1/(1-exp(y*-y*max)) +
c...i0/i5*c5*1/(1-exp(-y*-y*min)), i0 = y*max-y*min,
c...and c1 + c2 + c3 + c4 + c5 = 1.
        call pyklim(2)
        if(mint(51).ne.0) goto 100
        ryst=rlu(0)
        myst=1
        if(ryst.gt.coef(isub,8)) myst=2
        if(ryst.gt.coef(isub,8)+coef(isub,9)) myst=3
        if(ryst.gt.coef(isub,8)+coef(isub,9)+coef(isub,10)) myst=4
        if(ryst.gt.coef(isub,8)+coef(isub,9)+coef(isub,10)+
     &  coef(isub,11)) myst=5
        call pykmap(2,myst,rlu(0))

c...2 -> 2 processes:
c...choose cos(theta-hat) (cth) according to h3(cth), where
c...h3(cth) = c0 + i0/i1*c1*1/(a - cth) + i0/i2*c2*1/(a + cth) +
c...i0/i3*c3*1/(a - cth)^2 + i0/i4*c4*1/(a + cth)^2,
c...a = 1 + 2*(m3*m4/sh)^2 (= 1 for massless products),
c...and c0 + c1 + c2 + c3 + c4 = 1.
        call pyklim(3)
        if(mint(51).ne.0) goto 100
        if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) then
          rcth=rlu(0)
          mcth=1
          if(rcth.gt.coef(isub,13)) mcth=2
          if(rcth.gt.coef(isub,13)+coef(isub,14)) mcth=3
          if(rcth.gt.coef(isub,13)+coef(isub,14)+coef(isub,15)) mcth=4
          if(rcth.gt.coef(isub,13)+coef(isub,14)+coef(isub,15)+
     &    coef(isub,16)) mcth=5
          call pykmap(3,mcth,rlu(0))
        endif

c...2 -> 3 : select pt1, phi1, pt2, phi2, y3 for 3 outgoing.
        if(istsb.eq.5) then
          call pykmap(5,0,0.d0)
          if(mint(51).ne.0) goto 100
        endif

c...low-pt or multiple interactions (first semihard interaction).
      elseif(istsb.eq.9) then
        call pymult(3)
        isub=mint(1)
      endif

c...choose azimuthal angle.
      vint(24)=paru(2)*rlu(0)

c...check against user cuts on kinematics at parton level.
      mint(51)=0
      if(isub.le.90.or.isub.gt.100) call pyklim(0)
      if(mint(51).ne.0) goto 100
      if(mint(82).eq.1.and.mstp(141).ge.1) then
        mcut=0
        if(msub(91)+msub(92)+msub(93)+msub(94)+msub(95).eq.0)
     &  call pykcut(mcut)
        if(mcut.ne.0) goto 100
      endif

c...calculate differential cross-section for different subprocesses.
      call pysigh(nchn,sigs)

c...calculations for monte carlo estimate of all cross-sections.
      if(mint(82).eq.1.and.isub.le.90.or.isub.ge.96) then
        xsec(isub,2)=xsec(isub,2)+sigs
      elseif(mint(82).eq.1) then
        xsec(isub,2)=xsec(isub,2)+xsec(isub,1)
      endif

c...multiple interactions: store results of cross-section calculation.
      if(mint(44).eq.4.and.mstp(82).ge.3) then
        vint(153)=sigs
        call pymult(4)
      endif

c...weighting using estimate of maximum of differential cross-section.
c...check that weight not negative!
      viol=sigs/xsec(isub,1)
      if(mstp(123).le.0) then
        if(viol.lt.-1e-3) then
          write(mstu(11),5000) viol,ngen(0,3)+1
          write(mstu(11),5100) isub,vint(21),vint(22),vint(23),vint(26)
          stop
        endif
      else
        if(viol.lt.min(-1d-3,vint(109))) then
          vint(109)=viol
          write(mstu(11),5200) viol,ngen(0,3)+1
          write(mstu(11),5100) isub,vint(21),vint(22),vint(23),vint(26)
        endif
      endif
      if(viol.lt.rlu(0)) goto 100

c...check for possible violation of estimated maximum of differential
c...cross-section used in weighting.
      if(mstp(123).le.0) then
        if(viol.gt.1.) then
          write(mstu(11),5300) viol,ngen(0,3)+1
          write(mstu(11),5100) isub,vint(21),vint(22),vint(23),vint(26)
          stop
        endif
      elseif(mstp(123).eq.1) then
        if(viol.gt.vint(108)) then
          vint(108)=viol
          if(viol.gt.1.) then
            write(mstu(11),5400) viol,ngen(0,3)+1
            write(mstu(11),5100) isub,vint(21),vint(22),vint(23),
     &      vint(26)
          endif
        endif
      elseif(viol.gt.vint(108)) then
        vint(108)=viol
        if(viol.gt.1.) then
          xdif=xsec(isub,1)*(viol-1.)
          xsec(isub,1)=xsec(isub,1)+xdif
          if(msub(isub).eq.1.and.(isub.le.90.or.isub.gt.96))
     &    xsec(0,1)=xsec(0,1)+xdif
          write(mstu(11),5400) viol,ngen(0,3)+1
          write(mstu(11),5100) isub,vint(21),vint(22),vint(23),vint(26)
          if(isub.le.9) then
            write(mstu(11),5500) isub,xsec(isub,1)
          elseif(isub.le.99) then
            write(mstu(11),5600) isub,xsec(isub,1)
          else
            write(mstu(11),5700) isub,xsec(isub,1)
          endif
          vint(108)=1.
        endif
      endif

c...multiple interactions: choose impact parameter.
      vint(148)=1.
      if(mint(44).eq.4.and.(isub.le.90.or.isub.ge.96).and.mstp(82).ge.3)
     &then
        call pymult(5)
        if(vint(150).lt.rlu(0)) goto 100
      endif
      if(mint(82).eq.1.and.msub(95).eq.1) then
        if(isub.le.90.or.isub.ge.95) ngen(95,1)=ngen(95,1)+1
        if(isub.le.90.or.isub.ge.96) ngen(96,2)=ngen(96,2)+1
      endif
      if(isub.le.90.or.isub.ge.96) mint(31)=mint(31)+1

c...choose flavour of reacting partons (and subprocess).
      rsigs=sigs*rlu(0)
      qt2=vint(48)
      rqqbar=parp(87)*(1.-(qt2/(qt2+(parp(88)*parp(82))**2))**2)
      if(isub.ne.95.and.(isub.ne.96.or.mstp(82).le.1.or.
     &rlu(0).gt.rqqbar)) then
        do 160 ichn=1,nchn
        kfl1=isig(ichn,1)
        kfl2=isig(ichn,2)
        mint(2)=isig(ichn,3)
        rsigs=rsigs-sigh(ichn)
        if(rsigs.le.0.) goto 170
  160   continue

c...multiple interactions: choose qq~ preferentially at small pt.
      elseif(isub.eq.96) then
        call pyspli(mint(11),21,kfl1,kfldum)
        call pyspli(mint(12),21,kfl2,kfldum)
        mint(1)=11
        mint(2)=1
        if(kfl1.eq.kfl2.and.rlu(0).lt.0.5) mint(2)=2

c...low-pt: choose string drawing configuration.
      else
        kfl1=21
        kfl2=21
        rsigs=6.*rlu(0)
        mint(2)=1
        if(rsigs.gt.1.) mint(2)=2
        if(rsigs.gt.2.) mint(2)=3
      endif

c...reassign qcd process. partons before initial state radiation.
  170 if(mint(2).gt.10) then
        mint(1)=mint(2)/10
        mint(2)=mod(mint(2),10)
      endif
      if(mint(82).eq.1.and.mstp(111).ge.0) ngen(mint(1),2)=
     &ngen(mint(1),2)+1
      mint(15)=kfl1
      mint(16)=kfl2
      mint(13)=mint(15)
      mint(14)=mint(16)
      vint(141)=vint(41)
      vint(142)=vint(42)
      vint(151)=0.
      vint(152)=0.

c...format statements for differential cross-section maximum violations.
 5000 format(1x,'error: negative cross-section fraction',1p,e11.3,1x,
     &'in event',1x,i7,'.'/1x,'execution stopped!')
 5100 format(1x,'isub = ',i3,'; point of violation:'/1x,'tau =',1p,
     &e11.3,', y* =',e11.3,', cthe = ',0p,f11.7,', tau'' =',1p,e11.3)
 5200 format(1x,'warning: negative cross-section fraction',1p,e11.3,1x,
     &'in event',1x,i7)
 5300 format(1x,'error: maximum violated by',1p,e11.3,1x,
     &'in event',1x,i7,'.'/1x,'execution stopped!')
 5400 format(1x,'warning: maximum violated by',1p,e11.3,1x,
     &'in event',1x,i7)
 5500 format(1x,'xsec(',i1,',1) increased to',1p,e11.3)
 5600 format(1x,'xsec(',i2,',1) increased to',1p,e11.3)
 5700 format(1x,'xsec(',i3,',1) increased to',1p,e11.3)

      return
      end

c*********************************************************************

      subroutine pyscat
      implicit double precision (a-h,o-z)

c...finds outgoing flavours and event type; sets up the kinematics
c...and colour flow of the hard scattering.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /lujets/,/ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint4/,
     &/pyint5/
      dimension wdtp(0:40),wdte(0:40,0:5),pmq(2),z(2),cthe(2),phi(2)

c...convert h' or a process into equivalent h one.
      isub=mint(1)
      ihigg=1
      kfhigg=25
      if((isub.ge.151.and.isub.le.160).or.(isub.ge.171.and.
     &isub.le.180)) then
        ihigg=2
        if(mod(isub-1,10).ge.5) ihigg=3
        kfhigg=33+ihigg
        if(isub.eq.151.or.isub.eq.156) isub=3
        if(isub.eq.152.or.isub.eq.157) isub=102
        if(isub.eq.153.or.isub.eq.158) isub=103
        if(isub.eq.171.or.isub.eq.176) isub=24
        if(isub.eq.172.or.isub.eq.177) isub=26
        if(isub.eq.173.or.isub.eq.178) isub=123
        if(isub.eq.174.or.isub.eq.179) isub=124
      endif

c...choice of subprocess, number of documentation lines.
      idoc=6+iset(isub)
      if(isub.eq.95) idoc=8
      if(iset(isub).eq.5.or.iset(isub).eq.6) idoc=9
      mint(3)=idoc-6
      if(idoc.ge.9.and.iset(isub).le.4) idoc=idoc+2
      mint(4)=idoc
      ipu1=mint(84)+1
      ipu2=mint(84)+2
      ipu3=mint(84)+3
      ipu4=mint(84)+4
      ipu5=mint(84)+5
      ipu6=mint(84)+6

c...reset k, p and v vectors. store incoming particles.
      do 100 jt=1,mstp(126)+10
      i=mint(83)+jt
      do 100 j=1,5
      k(i,j)=0
      p(i,j)=0.
  100 v(i,j)=0.
      do 110 jt=1,2
      i=mint(83)+jt
      k(i,1)=21
      k(i,2)=mint(10+jt)
      p(i,1)=0.
      p(i,2)=0.
      p(i,5)=vint(2+jt)
      p(i,3)=vint(5)*(-1)**(jt+1)
  110 p(i,4)=sqrt(p(i,3)**2+p(i,5)**2)
      mint(6)=2
      kfres=0

c...store incoming partons in their cm-frame.
      sh=vint(44)
      shr=sqrt(sh)
      shp=vint(26)*vint(2)
      shpr=sqrt(shp)
      shuser=shr
      if(iset(isub).ge.3.and.iset(isub).le.5) shuser=shpr
      do 120 jt=1,2
      i=mint(84)+jt
      k(i,1)=14
      k(i,2)=mint(14+jt)
      k(i,3)=mint(83)+2+jt
      p(i,3)=0.5*shuser*(-1.)**(jt-1)
  120 p(i,4)=0.5*shuser

c...copy incoming partons to documentation lines.
      do 130 jt=1,2
      i1=mint(83)+4+jt
      i2=mint(84)+jt
      k(i1,1)=21
      k(i1,2)=k(i2,2)
      k(i1,3)=i1-2
      do 130 j=1,5
  130 p(i1,j)=p(i2,j)

c...choose new quark/lepton flavour for relevant annihilation graphs.
      if(isub.eq.12.or.isub.eq.53.or.isub.eq.54.or.isub.eq.58) then
        iglga=21
        if(isub.eq.58) iglga=22
        call pywidt(iglga,sh,wdtp,wdte)
  140   rkfl=(wdte(0,1)+wdte(0,2)+wdte(0,4))*rlu(0)
        do 150 i=1,mdcy(iglga,3)
        kflf=kfdp(i+mdcy(iglga,2)-1,1)
        rkfl=rkfl-(wdte(i,1)+wdte(i,2)+wdte(i,4))
        if(rkfl.le.0.) goto 160
  150   continue
  160   continue
        if(isub.eq.54) then
          if((kchg(iabs(kflf),1)/2.)**2.lt.rlu(0)) goto 140
        elseif(isub.eq.58) then
          if((kchg(iabs(kflf),1)/3.)**2.lt.rlu(0)) goto 140
        endif
      endif

c...final state flavours and colour flow: default values.
      js=1
      mint(21)=mint(15)
      mint(22)=mint(16)
      mint(23)=0
      mint(24)=0
      kcc=20
      kcs=isign(1,mint(15))

      if(isub.le.10) then
      if(isub.eq.1) then
c...f + f~ -> gamma*/z0.
        kfres=23

      elseif(isub.eq.2) then
c...f + f~' -> w+/- .
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        kfres=isign(24,kch1+kch2)

      elseif(isub.eq.3) then
c...f + f~ -> h0 (or h'0, or a0).
        kfres=kfhigg

      elseif(isub.eq.4) then
c...gamma + w+/- -> w+/-.

      elseif(isub.eq.5) then
c...z0 + z0 -> h0.
        xh=sh/shp
        mint(21)=mint(15)
        mint(22)=mint(16)
        pmq(1)=ulmass(mint(21))
        pmq(2)=ulmass(mint(22))
  170   jt=int(1.5+rlu(0))
        zmin=2.*pmq(jt)/shpr
        zmax=1.-pmq(3-jt)/shpr-(sh-pmq(jt)**2)/(shpr*(shpr-pmq(3-jt)))
        zmax=min(1.-xh,zmax)
        z(jt)=zmin+(zmax-zmin)*rlu(0)
        if(-1.+(1.+xh)/(1.-z(jt))-xh/(1.-z(jt))**2.lt.
     &  (1.-xh)**2/(4.*xh)*rlu(0)) goto 170
        sqc1=1.-4.*pmq(jt)**2/(z(jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 170
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(jt)**2)/(z(jt)*shp)
        cthe(jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(jt)=min(1.d0,max(-1.d0,cthe(jt)))
        z(3-jt)=1.-xh/(1.-z(jt))
        sqc1=1.-4.*pmq(3-jt)**2/(z(3-jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 170
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(3-jt)**2)/(z(3-jt)*shp)
        cthe(3-jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(3-jt)=min(1.d0, max(-1.d0, cthe(3-jt)))
        phir=paru(2)*rlu(0)
        cphi=cos(phir)
        ang=cthe(1)*cthe(2)-sqrt(1.-cthe(1)**2)*sqrt(1.-cthe(2)**2)*cphi
        z1=2.-z(jt)
        z2=ang*sqrt(z(jt)**2-4.*pmq(jt)**2/shp)
        z3=1.-z(jt)-xh+(pmq(1)**2+pmq(2)**2)/shp
        z(3-jt)=2./(z1**2-z2**2)*(z1*z3+z2*sqrt(z3**2-(z1**2-z2**2)*
     &  pmq(3-jt)**2/shp))
        zmin=2.*pmq(3-jt)/shpr
        zmax=1.-pmq(jt)/shpr-(sh-pmq(3-jt)**2)/(shpr*(shpr-pmq(jt)))
        zmax=min(1.-xh,zmax)
        if(z(3-jt).lt.zmin.or.z(3-jt).gt.zmax) goto 170
        kcc=22
        kfres=25

      elseif(isub.eq.6) then
c...z0 + w+/- -> w+/-.

      elseif(isub.eq.7) then
c...w+ + w- -> z0.

      elseif(isub.eq.8) then
c...w+ + w- -> h0.
        xh=sh/shp
  180   do 200 jt=1,2
        i=mint(14+jt)
        ia=iabs(i)
        if(ia.le.10) then
          rvckm=vint(180+i)*rlu(0)
          do 190 j=1,mstp(1)
          ib=2*j-1+mod(ia,2)
          ipm=(5-isign(1,i))/2
          idc=j+mdcy(ia,2)+2
          if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 190
          mint(20+jt)=isign(ib,i)
          rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
          if(rvckm.le.0.) goto 200
  190     continue
        else
          ib=2*((ia+1)/2)-1+mod(ia,2)
          mint(20+jt)=isign(ib,i)
        endif
  200   pmq(jt)=ulmass(mint(20+jt))
        jt=int(1.5+rlu(0))
        zmin=2.*pmq(jt)/shpr
        zmax=1.-pmq(3-jt)/shpr-(sh-pmq(jt)**2)/(shpr*(shpr-pmq(3-jt)))
        zmax=min(1.-xh,zmax)
        if(zmin.ge.zmax) goto 180
        z(jt)=zmin+(zmax-zmin)*rlu(0)
        if(-1.+(1.+xh)/(1.-z(jt))-xh/(1.-z(jt))**2.lt.
     &  (1.-xh)**2/(4.*xh)*rlu(0)) goto 180
        sqc1=1.-4.*pmq(jt)**2/(z(jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 180
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(24,1)**2-pmq(jt)**2)/(z(jt)*shp)
        cthe(jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(jt)=min(1.d0, max(-1.0d0,cthe(jt)))
        z(3-jt)=1.-xh/(1.-z(jt))
        sqc1=1.-4.*pmq(3-jt)**2/(z(3-jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 180
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(24,1)**2-pmq(3-jt)**2)/(z(3-jt)*shp)
        cthe(3-jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(3-jt)=min(1.d0,max(-1.d0,cthe(3-jt)))
        phir=paru(2)*rlu(0)
        cphi=cos(phir)
        ang=cthe(1)*cthe(2)-sqrt(1.-cthe(1)**2)*sqrt(1.-cthe(2)**2)*cphi
        z1=2.-z(jt)
        z2=ang*sqrt(z(jt)**2-4.*pmq(jt)**2/shp)
        z3=1.-z(jt)-xh+(pmq(1)**2+pmq(2)**2)/shp
        z(3-jt)=2./(z1**2-z2**2)*(z1*z3+z2*sqrt(z3**2-(z1**2-z2**2)*
     &  pmq(3-jt)**2/shp))
        zmin=2.*pmq(3-jt)/shpr
        zmax=1.-pmq(jt)/shpr-(sh-pmq(3-jt)**2)/(shpr*(shpr-pmq(jt)))
        zmax=min(1.-xh,zmax)
        if(z(3-jt).lt.zmin.or.z(3-jt).gt.zmax) goto 180
        kcc=22
        kfres=25
      endif

      elseif(isub.le.20) then
      if(isub.eq.11) then
c...f + f' -> f + f'; th = (p(f)-p(f))**2.
        if(mint(2).le.4) then
          kcc=mint(2)
          if(mint(15)*mint(16).lt.0) kcc=kcc+2
        elseif(mint(2).eq.5) then
          kcc=22
        else
c...w exchange: need to mix flavours according to ckm matrix.
          do 220 jt=1,2
          i=mint(14+jt)
          ia=iabs(i)
          if(ia.le.10) then
            rvckm=vint(180+i)*rlu(0)
            do 210 j=1,mstp(1)
            ib=2*j-1+mod(ia,2)
            ipm=(5-isign(1,i))/2
            idc=j+mdcy(ia,2)+2
            if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 210
            mint(20+jt)=isign(ib,i)
            rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
            if(rvckm.le.0.) goto 220
  210       continue
          else
            ib=2*((ia+1)/2)-1+mod(ia,2)
            mint(20+jt)=isign(ib,i)
          endif
  220     continue
          kcc=22
        endif

      elseif(isub.eq.12) then
c...f + f~ -> f' + f~'; th = (p(f)-p(f'))**2.
        mint(21)=isign(kflf,mint(15))
        mint(22)=-mint(21)
        kcc=4

      elseif(isub.eq.13) then
c...f + f~ -> g + g; th arbitrary.
        mint(21)=21
        mint(22)=21
        kcc=mint(2)+4

      elseif(isub.eq.14) then
c...f + f~ -> g + gamma; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=21
        mint(23-js)=22
        kcc=17+js

      elseif(isub.eq.15) then
c...f + f~ -> g + z0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=21
        mint(23-js)=23
        kcc=17+js

      elseif(isub.eq.16) then
c...f + f~' -> g + w+/-; th = (p(f)-p(w-))**2 or (p(f~')-p(w+))**2.
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        if(mint(15)*(kch1+kch2).lt.0) js=2
        mint(20+js)=21
        mint(23-js)=isign(24,kch1+kch2)
        kcc=17+js

      elseif(isub.eq.17) then
c...f + f~ -> g + h0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=21
        mint(23-js)=25
        kcc=17+js

      elseif(isub.eq.18) then
c...f + f~ -> gamma + gamma; th arbitrary.
        mint(21)=22
        mint(22)=22

      elseif(isub.eq.19) then
c...f + f~ -> gamma + z0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=22
        mint(23-js)=23

      elseif(isub.eq.20) then
c...f + f~' -> gamma + w+/-; th = (p(f)-p(w-))**2 or (p(f~')-p(w+))**2.
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        if(mint(15)*(kch1+kch2).lt.0) js=2
        mint(20+js)=22
        mint(23-js)=isign(24,kch1+kch2)
      endif

      elseif(isub.le.30) then
      if(isub.eq.21) then
c...f + f~ -> gamma + h0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=22
        mint(23-js)=25

      elseif(isub.eq.22) then
c...f + f~ -> z0 + z0; th arbitrary.
        mint(21)=23
        mint(22)=23

      elseif(isub.eq.23) then
c...f + f~' -> z0 + w+/-; th = (p(f)-p(w-))**2 or (p(f~')-p(w+))**2.
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        if(mint(15)*(kch1+kch2).lt.0) js=2
        mint(20+js)=23
        mint(23-js)=isign(24,kch1+kch2)

      elseif(isub.eq.24) then
c...f + f~ -> z0 + h0 (or h'0, or a0); th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=23
        mint(23-js)=kfhigg

      elseif(isub.eq.25) then
c...f + f~ -> w+ + w-; th = (p(f)-p(w-))**2.
        mint(21)=-isign(24,mint(15))
        mint(22)=-mint(21)

      elseif(isub.eq.26) then
c...f + f~' -> w+/- + h0 (or h'0, or a0);
c...th = (p(f)-p(w-))**2 or (p(f~')-p(w+))**2.
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        if(mint(15)*(kch1+kch2).gt.0) js=2
        mint(20+js)=isign(24,kch1+kch2)
        mint(23-js)=kfhigg

      elseif(isub.eq.27) then
c...f + f~ -> h0 + h0.

      elseif(isub.eq.28) then
c...f + g -> f + g; th = (p(f)-p(f))**2.
        kcc=mint(2)+6
        if(mint(15).eq.21) kcc=kcc+2
        if(mint(15).ne.21) kcs=isign(1,mint(15))
        if(mint(16).ne.21) kcs=isign(1,mint(16))

      elseif(isub.eq.29) then
c...f + g -> f + gamma; th = (p(f)-p(f))**2.
        if(mint(15).eq.21) js=2
        mint(23-js)=22
        kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.30) then
c...f + g -> f + z0; th = (p(f)-p(f))**2.
        if(mint(15).eq.21) js=2
        mint(23-js)=23
        kcc=15+js
        kcs=isign(1,mint(14+js))
      endif

      elseif(isub.le.40) then
      if(isub.eq.31) then
c...f + g -> f' + w+/-; th = (p(f)-p(f'))**2; choose flavour f'.
        if(mint(15).eq.21) js=2
        i=mint(14+js)
        ia=iabs(i)
        mint(23-js)=isign(24,kchg(ia,1)*i)
        rvckm=vint(180+i)*rlu(0)
        do 230 j=1,mstp(1)
        ib=2*j-1+mod(ia,2)
        ipm=(5-isign(1,i))/2
        idc=j+mdcy(ia,2)+2
        if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 230
        mint(20+js)=isign(ib,i)
        rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
        if(rvckm.le.0.) goto 240
  230   continue
  240   kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.32) then
c...f + g -> f + h0; th = (p(f)-p(f))**2.
        if(mint(15).eq.21) js=2
        mint(23-js)=25
        kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.33) then
c...f + gamma -> f + g; th=(p(f)-p(f))**2.
        if(mint(15).eq.22) js=2
        mint(23-js)=21
        kcc=24+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.34) then
c...f + gamma -> f + gamma; th=(p(f)-p(f))**2.
        if(mint(15).eq.22) js=2
        kcc=22
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.35) then
c...f + gamma -> f + z0; th=(p(f)-p(f))**2.
        if(mint(15).eq.22) js=2
        mint(23-js)=23
        kcc=22

      elseif(isub.eq.36) then
c...f + gamma -> f' + w+/-; th=(p(f)-p(f'))**2.
        if(mint(15).eq.22) js=2
        i=mint(14+js)
        ia=iabs(i)
        mint(23-js)=isign(24,kchg(ia,1)*i)
        if(ia.le.10) then
          rvckm=vint(180+i)*rlu(0)
          do 250 j=1,mstp(1)
          ib=2*j-1+mod(ia,2)
          ipm=(5-isign(1,i))/2
          idc=j+mdcy(ia,2)+2
          if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 250
          mint(20+js)=isign(ib,i)
          rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
          if(rvckm.le.0.) goto 260
  250     continue
        else
          ib=2*((ia+1)/2)-1+mod(ia,2)
          mint(20+js)=isign(ib,i)
        endif
  260   kcc=22

      elseif(isub.eq.37) then
c...f + gamma -> f + h0.

      elseif(isub.eq.38) then
c...f + z0 -> f + g.

      elseif(isub.eq.39) then
c...f + z0 -> f + gamma.

      elseif(isub.eq.40) then
c...f + z0 -> f + z0.
      endif

      elseif(isub.le.50) then
      if(isub.eq.41) then
c...f + z0 -> f' + w+/-.

      elseif(isub.eq.42) then
c...f + z0 -> f + h0.

      elseif(isub.eq.43) then
c...f + w+/- -> f' + g.

      elseif(isub.eq.44) then
c...f + w+/- -> f' + gamma.

      elseif(isub.eq.45) then
c...f + w+/- -> f' + z0.

      elseif(isub.eq.46) then
c...f + w+/- -> f' + w+/-.

      elseif(isub.eq.47) then
c...f + w+/- -> f' + h0.

      elseif(isub.eq.48) then
c...f + h0 -> f + g.

      elseif(isub.eq.49) then
c...f + h0 -> f + gamma.

      elseif(isub.eq.50) then
c...f + h0 -> f + z0.
      endif

      elseif(isub.le.60) then
      if(isub.eq.51) then
c...f + h0 -> f' + w+/-.

      elseif(isub.eq.52) then
c...f + h0 -> f + h0.

      elseif(isub.eq.53) then
c...g + g -> f + f~; th arbitrary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(kflf,kcs)
        mint(22)=-mint(21)
        kcc=mint(2)+10

      elseif(isub.eq.54) then
c...g + gamma -> f + f~; th arbitrary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(kflf,kcs)
        mint(22)=-mint(21)
        kcc=27
        if(mint(16).eq.21) kcc=28

      elseif(isub.eq.55) then
c...g + z0 -> f + f~.

      elseif(isub.eq.56) then
c...g + w+/- -> f + f~'.

      elseif(isub.eq.57) then
c...g + h0 -> f + f~.

      elseif(isub.eq.58) then
c...gamma + gamma -> f + f~; th arbitrary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(kflf,kcs)
        mint(22)=-mint(21)
        kcc=21

      elseif(isub.eq.59) then
c...gamma + z0 -> f + f~.

      elseif(isub.eq.60) then
c...gamma + w+/- -> f + f~'.
      endif

      elseif(isub.le.70) then
      if(isub.eq.61) then
c...gamma + h0 -> f + f~.

      elseif(isub.eq.62) then
c...z0 + z0 -> f + f~.

      elseif(isub.eq.63) then
c...z0 + w+/- -> f + f~'.

      elseif(isub.eq.64) then
c...z0 + h0 -> f + f~.

      elseif(isub.eq.65) then
c...w+ + w- -> f + f~.

      elseif(isub.eq.66) then
c...w+/- + h0 -> f + f~'.

      elseif(isub.eq.67) then
c...h0 + h0 -> f + f~.

      elseif(isub.eq.68) then
c...g + g -> g + g; th arbitrary.
        kcc=mint(2)+12
        kcs=(-1)**int(1.5+rlu(0))

      elseif(isub.eq.69) then
c...gamma + gamma -> w+ + w-; th arbitrary.
        mint(21)=24
        mint(22)=-24
        kcc=21

      elseif(isub.eq.70) then
c...gamma + w+/- -> z0 + w+/-; th=(p(w)-p(w))**2.
        if(mint(15).eq.22) mint(21)=23
        if(mint(16).eq.22) mint(22)=23
        kcc=21
      endif

      elseif(isub.le.80) then
      if(isub.eq.71.or.isub.eq.72) then
c...z0 + z0 -> z0 + z0; z0 + z0 -> w+ + w-.
        xh=sh/shp
        mint(21)=mint(15)
        mint(22)=mint(16)
        pmq(1)=ulmass(mint(21))
        pmq(2)=ulmass(mint(22))
  270   jt=int(1.5+rlu(0))
        zmin=2.*pmq(jt)/shpr
        zmax=1.-pmq(3-jt)/shpr-(sh-pmq(jt)**2)/(shpr*(shpr-pmq(3-jt)))
        zmax=min(1.-xh,zmax)
        z(jt)=zmin+(zmax-zmin)*rlu(0)
        if(-1.+(1.+xh)/(1.-z(jt))-xh/(1.-z(jt))**2.lt.
     &  (1.-xh)**2/(4.*xh)*rlu(0)) goto 270
        sqc1=1.-4.*pmq(jt)**2/(z(jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 270
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(jt)**2)/(z(jt)*shp)
        cthe(jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(jt)=min(1.d0,max(-1.d0,cthe(jt)))
        z(3-jt)=1.-xh/(1.-z(jt))
        sqc1=1.-4.*pmq(3-jt)**2/(z(3-jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 270
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(3-jt)**2)/(z(3-jt)*shp)
        cthe(3-jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(3-jt)=min(1.d0,max(-1.d0,cthe(3-jt)))
        phir=paru(2)*rlu(0)
        cphi=cos(phir)
        ang=cthe(1)*cthe(2)-sqrt(1.-cthe(1)**2)*sqrt(1.-cthe(2)**2)*cphi
        z1=2.-z(jt)
        z2=ang*sqrt(z(jt)**2-4.*pmq(jt)**2/shp)
        z3=1.-z(jt)-xh+(pmq(1)**2+pmq(2)**2)/shp
        z(3-jt)=2./(z1**2-z2**2)*(z1*z3+z2*sqrt(z3**2-(z1**2-z2**2)*
     &  pmq(3-jt)**2/shp))
        zmin=2.*pmq(3-jt)/shpr
        zmax=1.-pmq(jt)/shpr-(sh-pmq(3-jt)**2)/(shpr*(shpr-pmq(jt)))
        zmax=min(1.-xh,zmax)
        if(z(3-jt).lt.zmin.or.z(3-jt).gt.zmax) goto 270
        kcc=22

      elseif(isub.eq.73) then
c...z0 + w+/- -> z0 + w+/-.
        xh=sh/shp
  280   jt=int(1.5+rlu(0))
        i=mint(14+jt)
        ia=iabs(i)
        if(ia.le.10) then
          rvckm=vint(180+i)*rlu(0)
          do 290 j=1,mstp(1)
          ib=2*j-1+mod(ia,2)
          ipm=(5-isign(1,i))/2
          idc=j+mdcy(ia,2)+2
          if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 290
          mint(20+jt)=isign(ib,i)
          rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
          if(rvckm.le.0.) goto 300
  290     continue
        else
          ib=2*((ia+1)/2)-1+mod(ia,2)
          mint(20+jt)=isign(ib,i)
        endif
  300   pmq(jt)=ulmass(mint(20+jt))
        mint(23-jt)=mint(17-jt)
        pmq(3-jt)=ulmass(mint(23-jt))
        jt=int(1.5+rlu(0))
        zmin=2.*pmq(jt)/shpr
        zmax=1.-pmq(3-jt)/shpr-(sh-pmq(jt)**2)/(shpr*(shpr-pmq(3-jt)))
        zmax=min(1.-xh,zmax)
        if(zmin.ge.zmax) goto 280
        z(jt)=zmin+(zmax-zmin)*rlu(0)
        if(-1.+(1.+xh)/(1.-z(jt))-xh/(1.-z(jt))**2.lt.
     &  (1.-xh)**2/(4.*xh)*rlu(0)) goto 280
        sqc1=1.-4.*pmq(jt)**2/(z(jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 280
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(jt)**2)/(z(jt)*shp)
        cthe(jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(jt)=min(1.d0,max(-1.d0,cthe(jt)))
        z(3-jt)=1.-xh/(1.-z(jt))
        sqc1=1.-4.*pmq(3-jt)**2/(z(3-jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 280
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(23,1)**2-pmq(3-jt)**2)/(z(3-jt)*shp)
        cthe(3-jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(3-jt)=min(1.d0,max(-1.d0,cthe(3-jt)))
        phir=paru(2)*rlu(0)
        cphi=cos(phir)
        ang=cthe(1)*cthe(2)-sqrt(1.-cthe(1)**2)*sqrt(1.-cthe(2)**2)*cphi
        z1=2.-z(jt)
        z2=ang*sqrt(z(jt)**2-4.*pmq(jt)**2/shp)
        z3=1.-z(jt)-xh+(pmq(1)**2+pmq(2)**2)/shp
        z(3-jt)=2./(z1**2-z2**2)*(z1*z3+z2*sqrt(z3**2-(z1**2-z2**2)*
     &  pmq(3-jt)**2/shp))
        zmin=2.*pmq(3-jt)/shpr
        zmax=1.-pmq(jt)/shpr-(sh-pmq(3-jt)**2)/(shpr*(shpr-pmq(jt)))
        zmax=min(1.-xh,zmax)
        if(z(3-jt).lt.zmin.or.z(3-jt).gt.zmax) goto 280
        kcc=22

      elseif(isub.eq.74) then
c...z0 + h0 -> z0 + h0.

      elseif(isub.eq.75) then
c...w+ + w- -> gamma + gamma.

      elseif(isub.eq.76.or.isub.eq.77) then
c...w+ + w- -> z0 + z0; w+ + w- -> w+ + w-.
        xh=sh/shp
  310   do 330 jt=1,2
        i=mint(14+jt)
        ia=iabs(i)
        if(ia.le.10) then
          rvckm=vint(180+i)*rlu(0)
          do 320 j=1,mstp(1)
          ib=2*j-1+mod(ia,2)
          ipm=(5-isign(1,i))/2
          idc=j+mdcy(ia,2)+2
          if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 320
          mint(20+jt)=isign(ib,i)
          rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
          if(rvckm.le.0.) goto 330
  320     continue
        else
          ib=2*((ia+1)/2)-1+mod(ia,2)
          mint(20+jt)=isign(ib,i)
        endif
  330   pmq(jt)=ulmass(mint(20+jt))
        jt=int(1.5+rlu(0))
        zmin=2.*pmq(jt)/shpr
        zmax=1.-pmq(3-jt)/shpr-(sh-pmq(jt)**2)/(shpr*(shpr-pmq(3-jt)))
        zmax=min(1.-xh,zmax)
        if(zmin.ge.zmax) goto 310
        z(jt)=zmin+(zmax-zmin)*rlu(0)
        if(-1.+(1.+xh)/(1.-z(jt))-xh/(1.-z(jt))**2.lt.
     &  (1.-xh)**2/(4.*xh)*rlu(0)) goto 310
        sqc1=1.-4.*pmq(jt)**2/(z(jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 310
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(24,1)**2-pmq(jt)**2)/(z(jt)*shp)
        cthe(jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(jt)=min(1.d0,max(-1.d0,cthe(jt)))
        z(3-jt)=1.-xh/(1.-z(jt))
        sqc1=1.-4.*pmq(3-jt)**2/(z(3-jt)**2*shp)
        if(sqc1.lt.1.e-8) goto 310
        c1=sqrt(sqc1)
        c2=1.+2.*(pmas(24,1)**2-pmq(3-jt)**2)/(z(3-jt)*shp)
        cthe(3-jt)=(c2-(c2**2-c1**2)/(c2+(2.*rlu(0)-1.)*c1))/c1
        cthe(3-jt)=min(1.d0,max(-1.d0,cthe(3-jt)))
        phir=paru(2)*rlu(0)
        cphi=cos(phir)
        ang=cthe(1)*cthe(2)-sqrt(1.-cthe(1)**2)*sqrt(1.-cthe(2)**2)*cphi
        z1=2.-z(jt)
        z2=ang*sqrt(z(jt)**2-4.*pmq(jt)**2/shp)
        z3=1.-z(jt)-xh+(pmq(1)**2+pmq(2)**2)/shp
        z(3-jt)=2./(z1**2-z2**2)*(z1*z3+z2*sqrt(z3**2-(z1**2-z2**2)*
     &  pmq(3-jt)**2/shp))
        zmin=2.*pmq(3-jt)/shpr
        zmax=1.-pmq(jt)/shpr-(sh-pmq(3-jt)**2)/(shpr*(shpr-pmq(jt)))
        zmax=min(1.-xh,zmax)
        if(z(3-jt).lt.zmin.or.z(3-jt).gt.zmax) goto 310
        kcc=22

      elseif(isub.eq.78) then
c...w+/- + h0 -> w+/- + h0.

      elseif(isub.eq.79) then
c...h0 + h0 -> h0 + h0.
      endif

      elseif(isub.le.90) then
      if(isub.eq.81) then
c...q + q~ -> q + q~; th = (p(q)-p(q))**2.
        mint(21)=isign(mint(55),mint(15))
        mint(22)=-mint(21)
        kcc=4

      elseif(isub.eq.82) then
c...g + g -> q + q~; th arbitrary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(mint(55),kcs)
        mint(22)=-mint(21)
        kcc=mint(2)+10

      elseif(isub.eq.83) then
c...f + q -> f' + q; th = (p(f) - p(f'))**2.
        kfold=mint(16)
        if(mint(2).eq.2) kfold=mint(15)
        kfaold=iabs(kfold)
        if(kfaold.gt.10) then
          kfanew=kfaold+2*mod(kfaold,2)-1
        else
          rckm=vint(180+kfold)*rlu(0)
          ipm=(5-isign(1,kfold))/2
          kfanew=-mod(kfaold+1,2)
  340     kfanew=kfanew+2
          idc=mdcy(kfaold,2)+(kfanew+1)/2+2
          if(mdme(idc,1).eq.1.or.mdme(idc,1).eq.ipm) then
            if(mod(kfaold,2).eq.0) rckm=rckm-vckm(kfaold/2,(kfanew+1)/2)
            if(mod(kfaold,2).eq.1) rckm=rckm-vckm(kfanew/2,(kfaold+1)/2)
          endif
          if(kfanew.le.6.and.rckm.gt.0.) goto 340
        endif
        if(mint(2).eq.1) then
          mint(21)=isign(mint(55),mint(15))
          mint(22)=isign(kfanew,mint(16))
        else
          mint(21)=isign(kfanew,mint(15))
          mint(22)=isign(mint(55),mint(16))
        endif
        kcc=22

      elseif(isub.eq.84) then
c...g + gamma -> q + q~; th arbitary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(mint(55),kcs)
        mint(22)=-mint(21)
        kcc=27
        if(mint(16).eq.21) kcc=28

      elseif(isub.eq.85) then
c...gamma + gamma -> f + f~; th arbitary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(mint(56),kcs)
        mint(22)=-mint(21)
        kcc=21
      endif

      elseif(isub.le.100) then
      if(isub.eq.95) then
c...low-pt ( = energyless g + g -> g + g).
        kcc=mint(2)+12
        kcs=(-1)**int(1.5+rlu(0))

      elseif(isub.eq.96) then
c...multiple interactions (should be reassigned to qcd process).
      endif

      elseif(isub.le.110) then
      if(isub.eq.101) then
c...g + g -> gamma*/z0.
        kcc=21
        kfres=22

      elseif(isub.eq.102) then
c...g + g -> h0 (or h'0, or a0).
        kcc=21
        kfres=kfhigg

      elseif(isub.eq.103) then
c...gamma + gamma -> h0 (or h'0, or a0).
        kcc=21
        kfres=kfhigg
      endif

      elseif(isub.le.120) then
      if(isub.eq.111) then
c...f + f~ -> g + h0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(20+js)=21
        mint(23-js)=25
        kcc=17+js

      elseif(isub.eq.112) then
c...f + g -> f + h0; th = (p(f) - p(f))**2.
        if(mint(15).eq.21) js=2
        mint(23-js)=25
        kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.113) then
c...g + g -> g + h0; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(23-js)=25
        kcc=22+js
        kcs=(-1)**int(1.5+rlu(0))

      elseif(isub.eq.114) then
c...g + g -> gamma + gamma; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(21)=22
        mint(22)=22
        kcc=21

      elseif(isub.eq.115) then
c...g + g -> g + gamma; th arbitrary.
        if(rlu(0).gt.0.5) js=2
        mint(23-js)=22
        kcc=22+js
        kcs=(-1)**int(1.5+rlu(0))

      elseif(isub.eq.116) then
c...g + g -> gamma + z0.

      elseif(isub.eq.117) then
c...g + g -> z0 + z0.

      elseif(isub.eq.118) then
c...g + g -> w+ + w-.
      endif

      elseif(isub.le.140) then
      if(isub.eq.121) then
c...g + g -> f + f~ + h0 (f + f~ -> h0 as inner process).

      elseif(isub.eq.122) then
c...gamma + gamma -> f + f' + h0 (f + f~ -> h0 as inner process).

      elseif(isub.eq.123) then
c...f + f' -> f + f' + h0 (or h'0, or a0) (z0 + z0 -> h0 as
c...inner process).
        kcc=22
        kfres=kfhigg

      elseif(isub.eq.124) then
c...f + f' -> f" + f"' + h0 (or h'0, or a) (w+ + w- -> h0 as
c...inner process).
        do 360 jt=1,2
        i=mint(14+jt)
        ia=iabs(i)
        if(ia.le.10) then
          rvckm=vint(180+i)*rlu(0)
          do 350 j=1,mstp(1)
          ib=2*j-1+mod(ia,2)
          ipm=(5-isign(1,i))/2
          idc=j+mdcy(ia,2)+2
          if(mdme(idc,1).ne.1.and.mdme(idc,1).ne.ipm) goto 350
          mint(20+jt)=isign(ib,i)
          rvckm=rvckm-vckm((ia+1)/2,(ib+1)/2)
          if(rvckm.le.0.) goto 360
  350     continue
        else
          ib=2*((ia+1)/2)-1+mod(ia,2)
          mint(20+jt)=isign(ib,i)
        endif
  360   continue
        kcc=22
        kfres=kfhigg

      elseif(isub.eq.131) then
c...g + g -> z0 + q + q~.
        mint(21)=kfpr(131,1)
        mint(22)=kfpr(131,2)
        mint(23)=-mint(22)
        kcc=mint(2)+10
        kcs=1
      endif

      elseif(isub.le.160) then
      if(isub.eq.141) then
c...f + f~ -> gamma*/z0/z'0.
        kfres=32

      elseif(isub.eq.142) then
c...f + f~' -> w'+/- .
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        kfres=isign(34,kch1+kch2)

      elseif(isub.eq.143) then
c...f + f~' -> h+/-.
        kch1=kchg(iabs(mint(15)),1)*isign(1,mint(15))
        kch2=kchg(iabs(mint(16)),1)*isign(1,mint(16))
        kfres=isign(37,kch1+kch2)

      elseif(isub.eq.144) then
c...f + f~' -> r.
        kfres=isign(40,mint(15)+mint(16))

      elseif(isub.eq.145) then
c...q + l -> lq (leptoquark).
        kfres=isign(39,mint(15))
        if(iabs(mint(16)).le.8) kfres=isign(39,mint(16))
      endif

      else
      if(isub.eq.161) then
c...f + g -> f' + h+/-; th = (p(f)-p(f'))**2.
        if(mint(15).eq.21) js=2
        i=mint(14+js)
        ia=iabs(i)
        mint(23-js)=isign(37,kchg(ia,1)*i)
        ib=ia+mod(ia,2)-mod(ia+1,2)
        mint(20+js)=isign(ib,i)
        kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.162) then
c...q + g -> lq + l~; lq=leptoquark; th=(p(q)-p(lq))^2.
        if(mint(15).eq.21) js=2
        mint(20+js)=isign(39,mint(14+js))
        kflql=kfdp(mdcy(39,2),2)
        mint(23-js)=-isign(kflql,mint(14+js))
        kcc=15+js
        kcs=isign(1,mint(14+js))

      elseif(isub.eq.163) then
c...g + g -> lq + lq~; lq=leptoquark; th arbitrary.
        kcs=(-1)**int(1.5+rlu(0))
        mint(21)=isign(39,kcs)
        mint(22)=-mint(21)
        kcc=mint(2)+10

      elseif(isub.eq.164) then
c...q + q~ -> lq + lq~; lq=leptoquark; th=(p(q)-p(lq))**2.
        mint(21)=isign(39,mint(15))
        mint(22)=-mint(21)
        kcc=4
      endif
      endif

      if(idoc.eq.7) then
c...resonance not decaying: store colour connection indices.
        i=mint(83)+7
        k(ipu3,1)=1
        k(ipu3,2)=kfres
        k(ipu3,3)=i
        p(ipu3,4)=shuser
        p(ipu3,5)=shuser
        k(ipu1,4)=ipu2
        k(ipu1,5)=ipu2
        k(ipu2,4)=ipu1
        k(ipu2,5)=ipu1
        k(i,1)=21
        k(i,2)=kfres
        p(i,4)=shuser
        p(i,5)=shuser
        n=ipu3
        mint(21)=kfres
        mint(22)=0

c...special case: colour flow in q + g -> lq.
        if(iabs(kfres).eq.39) then
          if(mint(15).gt.0.and.mint(15).le.8) then
            k(ipu1,4)=ipu3
            k(ipu3,4)=mstu(5)*ipu1
          elseif(mint(15).lt.0.and.mint(15).ge.-8) then
            k(ipu1,5)=ipu3
            k(ipu3,5)=mstu(5)*ipu1
          elseif(mint(16).gt.0) then
            k(ipu2,4)=ipu3
            k(ipu3,4)=mstu(5)*ipu2
          else
            k(ipu2,5)=ipu3
            k(ipu3,5)=mstu(5)*ipu2
          endif
        endif

      elseif(idoc.eq.8) then
c...2 -> 2 processes: store outgoing partons in their cm-frame.
        do 370 jt=1,2
        i=mint(84)+2+jt
        k(i,1)=1
        if(iabs(mint(20+jt)).le.100) then
          if(kchg(iabs(mint(20+jt)),2).ne.0) k(i,1)=3
        endif
        k(i,2)=mint(20+jt)
        k(i,3)=mint(83)+idoc+jt-2
        if(iabs(k(i,2)).le.22) then
          p(i,5)=ulmass(k(i,2))
        else
          p(i,5)=sqrt(vint(63+mod(js+jt,2)))
        endif
  370   continue
        if(p(ipu3,5)+p(ipu4,5).ge.shr) then
          kfa1=iabs(mint(21))
          kfa2=iabs(mint(22))
          if((kfa1.gt.3.and.kfa1.ne.21).or.(kfa2.gt.3.and.kfa2.ne.21))
     &    then
            mint(51)=1
            return
          endif
          p(ipu3,5)=0.
          p(ipu4,5)=0.
        endif
        p(ipu3,4)=0.5*(shr+(p(ipu3,5)**2-p(ipu4,5)**2)/shr)
        p(ipu3,3)=sqrt(max(0.d0,p(ipu3,4)**2-p(ipu3,5)**2))
        p(ipu4,4)=shr-p(ipu3,4)
        p(ipu4,3)=-p(ipu3,3)
        n=ipu4
        mint(7)=mint(83)+7
        mint(8)=mint(83)+8

c...rotate outgoing partons using cos(theta)=(th-uh)/lam(sh,sqm3,sqm4).
        call ludbrb(ipu3,ipu4,acos(vint(23)),vint(24),0d0,0d0,0d0)

      elseif(idoc.eq.9.and.iset(isub).eq.5) then
c...2 -> 3 processes (alt 1): store outgoing partons in their cm frame.
        do 380 jt=1,2
        i=mint(84)+2+jt
        k(i,1)=1
        if(iabs(mint(20+jt)).le.100) then
          if(kchg(iabs(mint(20+jt)),2).ne.0) k(i,1)=3
        endif
        k(i,2)=mint(20+jt)
        k(i,3)=mint(83)+idoc+jt-3
        if(iabs(k(i,2)).le.22) then
          p(i,5)=ulmass(k(i,2))
        else
          p(i,5)=sqrt(vint(63+mod(js+jt,2)))
        endif
        pt=
     &  sqrt(max(0.d0,vint(197+5*jt)-p(i,5)**2+vint(196+5*jt)**2))
        p(i,1)=pt*cos(vint(198+5*jt))
        p(i,2)=pt*sin(vint(198+5*jt))
  380   continue
        k(ipu5,1)=1
        k(ipu5,2)=kfres
        k(ipu5,3)=mint(83)+idoc
        p(ipu5,5)=shr
        p(ipu5,1)=-p(ipu3,1)-p(ipu4,1)
        p(ipu5,2)=-p(ipu3,2)-p(ipu4,2)
        pms1=p(ipu3,5)**2+p(ipu3,1)**2+p(ipu3,2)**2
        pms2=p(ipu4,5)**2+p(ipu4,1)**2+p(ipu4,2)**2
        pms3=p(ipu5,5)**2+p(ipu5,1)**2+p(ipu5,2)**2
        pmt3=sqrt(pms3)
        p(ipu5,3)=pmt3*sinh(vint(211))
        p(ipu5,4)=pmt3*cosh(vint(211))
        pms12=(shpr-p(ipu5,4))**2-p(ipu5,3)**2
        sql12=(pms12-pms1-pms2)**2-4.*pms1*pms2
        if(sql12.le.0.) then
          mint(51)=1
          return
        endif
        p(ipu3,3)=(-p(ipu5,3)*(pms12+pms1-pms2)+
     &  vint(213)*(shpr-p(ipu5,4))*sqrt(sql12))/(2.*pms12)
        p(ipu4,3)=-p(ipu3,3)-p(ipu5,3)
        p(ipu3,4)=sqrt(pms1+p(ipu3,3)**2)
        p(ipu4,4)=sqrt(pms2+p(ipu4,3)**2)
        n=ipu5
        mint(7)=mint(83)+7
        mint(8)=mint(83)+8

      elseif(idoc.eq.9) then
c...2 -> 3 processes: store outgoing partons in their cm frame.
        do 390 jt=1,3
        i=mint(84)+2+jt
        k(i,1)=1
        if(iabs(mint(20+jt)).le.10.or.mint(20+jt).eq.21) k(i,1)=3
        k(i,2)=mint(20+jt)
        k(i,3)=mint(83)+idoc+jt-3
        if(jt.eq.1) then
          p(i,5)=sqrt(vint(63))
        else
          p(i,5)=pmas(kfpr(isub,2),1)
        endif
  390   continue
        p(ipu3,4)=0.5*(shr+(vint(63)-vint(64))/shr)
        p(ipu3,3)=sqrt(max(0.d0,p(ipu3,4)**2-p(ipu3,5)**2))
        p(ipu4,4)=0.5*sqrt(vint(64))
        p(ipu4,3)=sqrt(max(0.d0,p(ipu4,4)**2-p(ipu4,5)**2))
        p(ipu5,4)=p(ipu4,4)
        p(ipu5,3)=-p(ipu4,3)
        n=ipu5
        mint(7)=mint(83)+7
        mint(8)=mint(83)+9

c...rotate and boost outgoing partons.
        call ludbrb(ipu4,ipu5,acos(vint(83)),vint(84),0d0,0d0,0d0)
        call ludbrb(ipu4,ipu5,0.d0,0.d0,0d0,0d0,
     &  -p(ipu3,3)/(shr-p(ipu3,4)))
        call ludbrb(ipu3,ipu5,acos(vint(23)),vint(24),0d0,0d0,0d0)

      elseif(idoc.eq.11) then
c...z0 + z0 -> h0, w+ + w- -> h0: store higgs and outgoing partons.
        phi(1)=paru(2)*rlu(0)
        phi(2)=phi(1)-phir
        do 400 jt=1,2
        i=mint(84)+2+jt
        k(i,1)=1
        if(iabs(mint(20+jt)).le.10.or.mint(20+jt).eq.21) k(i,1)=3
        k(i,2)=mint(20+jt)
        k(i,3)=mint(83)+idoc+jt-2
        p(i,5)=ulmass(k(i,2))
        if(0.5*shpr*z(jt).le.p(i,5)) p(i,5)=0.
        pabs=sqrt(max(0.d0,(0.5*shpr*z(jt))**2-p(i,5)**2))
        ptabs=pabs*sqrt(max(0.d0,1.-cthe(jt)**2))
        p(i,1)=ptabs*cos(phi(jt))
        p(i,2)=ptabs*sin(phi(jt))
        p(i,3)=pabs*cthe(jt)*(-1)**(jt+1)
        p(i,4)=0.5*shpr*z(jt)
        izw=mint(83)+6+jt
        k(izw,1)=21
        k(izw,2)=23
        if(isub.eq.8) k(izw,2)=isign(24,luchge(mint(14+jt)))
        k(izw,3)=izw-2
        p(izw,1)=-p(i,1)
        p(izw,2)=-p(i,2)
        p(izw,3)=(0.5*shpr-pabs*cthe(jt))*(-1)**(jt+1)
        p(izw,4)=0.5*shpr*(1.-z(jt))
  400   p(izw,5)=-sqrt(max(0.d0,p(izw,3)**2+ptabs**2-p(izw,4)**2))
        i=mint(83)+9
        k(ipu5,1)=1
        k(ipu5,2)=kfres
        k(ipu5,3)=i
        p(ipu5,5)=shr
        p(ipu5,1)=-p(ipu3,1)-p(ipu4,1)
        p(ipu5,2)=-p(ipu3,2)-p(ipu4,2)
        p(ipu5,3)=-p(ipu3,3)-p(ipu4,3)
        p(ipu5,4)=shpr-p(ipu3,4)-p(ipu4,4)
        k(i,1)=21
        k(i,2)=kfres
        do 410 j=1,5
  410   p(i,j)=p(ipu5,j)
        n=ipu5
        mint(23)=kfres

      elseif(idoc.eq.12) then
c...z0 and w+/- scattering: store bosons and outgoing partons.
        phi(1)=paru(2)*rlu(0)
        phi(2)=phi(1)-phir
        jtran=int(1.5+rlu(0))
        do 420 jt=1,2
        i=mint(84)+2+jt
        k(i,1)=1
        if(iabs(mint(20+jt)).le.10.or.mint(20+jt).eq.21) k(i,1)=3
        k(i,2)=mint(20+jt)
        k(i,3)=mint(83)+idoc+jt-2
        p(i,5)=ulmass(k(i,2))
        if(0.5*shpr*z(jt).le.p(i,5)) p(i,5)=0.
        pabs=sqrt(max(0.d0,(0.5*shpr*z(jt))**2-p(i,5)**2))
        ptabs=pabs*sqrt(max(0.d0,1.-cthe(jt)**2))
        p(i,1)=ptabs*cos(phi(jt))
        p(i,2)=ptabs*sin(phi(jt))
        p(i,3)=pabs*cthe(jt)*(-1)**(jt+1)
        p(i,4)=0.5*shpr*z(jt)
        izw=mint(83)+6+jt
        k(izw,1)=21
        if(mint(14+jt).eq.mint(20+jt)) then
          k(izw,2)=23
        else
          k(izw,2)=isign(24,luchge(mint(14+jt))-luchge(mint(20+jt)))
        endif
        k(izw,3)=izw-2
        p(izw,1)=-p(i,1)
        p(izw,2)=-p(i,2)
        p(izw,3)=(0.5*shpr-pabs*cthe(jt))*(-1)**(jt+1)
        p(izw,4)=0.5*shpr*(1.-z(jt))
        p(izw,5)=-sqrt(max(0.d0,p(izw,3)**2+ptabs**2-p(izw,4)**2))
        ipu=mint(84)+4+jt
        k(ipu,1)=3
        k(ipu,2)=kfpr(isub,jt)
        if(isub.eq.72.and.jt.eq.jtran) k(ipu,2)=-k(ipu,2)
        if(isub.eq.73.or.isub.eq.77) k(ipu,2)=k(izw,2)
        k(ipu,3)=mint(83)+8+jt
        if(iabs(k(ipu,2)).le.10.or.k(ipu,2).eq.21) then
          p(ipu,5)=ulmass(k(ipu,2))
        else
          p(ipu,5)=sqrt(vint(63+mod(js+jt,2)))
        endif
        mint(22+jt)=k(ipu,2)
  420   continue
c...find rotation and boost for hard scattering subsystem.
        i1=mint(83)+7
        i2=mint(83)+8
        bexcm=(p(i1,1)+p(i2,1))/(p(i1,4)+p(i2,4))
        beycm=(p(i1,2)+p(i2,2))/(p(i1,4)+p(i2,4))
        bezcm=(p(i1,3)+p(i2,3))/(p(i1,4)+p(i2,4))
        gamcm=(p(i1,4)+p(i2,4))/shr
        bepcm=bexcm*p(i1,1)+beycm*p(i1,2)+bezcm*p(i1,3)
        px=p(i1,1)+gamcm*(gamcm/(1.+gamcm)*bepcm-p(i1,4))*bexcm
        py=p(i1,2)+gamcm*(gamcm/(1.+gamcm)*bepcm-p(i1,4))*beycm
        pz=p(i1,3)+gamcm*(gamcm/(1.+gamcm)*bepcm-p(i1,4))*bezcm
        thecm=ulangl(pz,sqrt(px**2+py**2))
        phicm=ulangl(px,py)
c...store hard scattering subsystem. rotate and boost it.
        sqlam=(sh-p(ipu5,5)**2-p(ipu6,5)**2)**2-4.*p(ipu5,5)**2*
     &  p(ipu6,5)**2
        pabs=sqrt(max(0.d0,sqlam/(4.*sh)))
        cthwz=vint(23)
        sthwz=sqrt(max(0.d0,1.-cthwz**2))
        phiwz=vint(24)-phicm
        p(ipu5,1)=pabs*sthwz*cos(phiwz)
        p(ipu5,2)=pabs*sthwz*sin(phiwz)
        p(ipu5,3)=pabs*cthwz
        p(ipu5,4)=sqrt(pabs**2+p(ipu5,5)**2)
        p(ipu6,1)=-p(ipu5,1)
        p(ipu6,2)=-p(ipu5,2)
        p(ipu6,3)=-p(ipu5,3)
        p(ipu6,4)=sqrt(pabs**2+p(ipu6,5)**2)
        call ludbrb(ipu5,ipu6,thecm,phicm, bexcm,beycm,
     &  bezcm)
        do 430 jt=1,2
        i1=mint(83)+8+jt
        i2=mint(84)+4+jt
        k(i1,1)=21
        k(i1,2)=k(i2,2)
        do 430 j=1,5
  430   p(i1,j)=p(i2,j)
        n=ipu6
        mint(7)=mint(83)+9
        mint(8)=mint(83)+10
      endif

      if(idoc.ge.8.and.iset(isub).ne.6) then
c...store colour connection indices.
        do 440 j=1,2
        jc=j
        if(kcs.eq.-1) jc=3-j
        if(icol(kcc,1,jc).ne.0.and.k(ipu1,1).eq.14) k(ipu1,j+3)=
     &  k(ipu1,j+3)+mint(84)+icol(kcc,1,jc)
        if(icol(kcc,2,jc).ne.0.and.k(ipu2,1).eq.14) k(ipu2,j+3)=
     &  k(ipu2,j+3)+mint(84)+icol(kcc,2,jc)
        if(icol(kcc,3,jc).ne.0.and.k(ipu3,1).eq.3) k(ipu3,j+3)=
     &  mstu(5)*(mint(84)+icol(kcc,3,jc))
  440   if(icol(kcc,4,jc).ne.0.and.k(ipu4,1).eq.3) k(ipu4,j+3)=
     &  mstu(5)*(mint(84)+icol(kcc,4,jc))

c...copy outgoing partons to documentation lines.
        imax=2
        if(idoc.eq.9) imax=3
        do 450 i=1,imax
        i1=mint(83)+idoc-imax+i
        i2=mint(84)+2+i
        k(i1,1)=21
        k(i1,2)=k(i2,2)
        if(idoc.le.9) k(i1,3)=0
        if(idoc.ge.11) k(i1,3)=mint(83)+2+i
        do 450 j=1,5
  450   p(i1,j)=p(i2,j)

      elseif(idoc.eq.9) then
c...store colour connection indices.
        do 460 j=1,2
        jc=j
        if(kcs.eq.-1) jc=3-j
        if(icol(kcc,1,jc).ne.0.and.k(ipu1,1).eq.14) k(ipu1,j+3)=
     &  k(ipu1,j+3)+mint(84)+icol(kcc,1,jc)+
     &  max(0,min(1,icol(kcc,1,jc)-2))
        if(icol(kcc,2,jc).ne.0.and.k(ipu2,1).eq.14) k(ipu2,j+3)=
     &  k(ipu2,j+3)+mint(84)+icol(kcc,2,jc)+
     &  max(0,min(1,icol(kcc,2,jc)-2))
        if(icol(kcc,3,jc).ne.0.and.k(ipu4,1).eq.3) k(ipu4,j+3)=
     &  mstu(5)*(mint(84)+icol(kcc,3,jc))
  460   if(icol(kcc,4,jc).ne.0.and.k(ipu5,1).eq.3) k(ipu5,j+3)=
     &  mstu(5)*(mint(84)+icol(kcc,4,jc))

c...copy outgoing partons to documentation lines.
        do 470 i=1,3
        i1=mint(83)+idoc-3+i
        i2=mint(84)+2+i
        k(i1,1)=21
        k(i1,2)=k(i2,2)
        k(i1,3)=0
        do 470 j=1,5
  470   p(i1,j)=p(i2,j)
      endif

c...low-pt events: remove gluons used for string drawing purposes.
      if(isub.eq.95) then
        k(ipu3,1)=k(ipu3,1)+10
        k(ipu4,1)=k(ipu4,1)+10
        do 480 j=41,66
  480   vint(j)=0.
        do 490 i=mint(83)+5,mint(83)+8
        do 490 j=1,5
  490   p(i,j)=0.
      endif

      return
      end

c*********************************************************************

      subroutine pysspa(ipu1,ipu2)
      implicit double precision (a-h,o-z)

c...generates spacelike parton showers.
c      implicit double precision(d)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      save /lujets/,/ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/
      dimension kfls(4),is(2),xs(2),zs(2),q2s(2),tevs(2),robo(5),
     &xfs(2,-25:25),xfa(-25:25),xfb(-25:25),xfn(-25:25),wtap(-25:25),
     &wtsf(-25:25),the2(2),alam(2),dq2(3),dpc(3),dpd(4),dpb(4)

c...calculate maximum virtuality and check that evolution possible.
      ipus1=ipu1
      ipus2=ipu2
      isub=mint(1)
      q2e=vint(52)
      if(iset(isub).eq.1) then
        q2e=q2e/parp(67)
      elseif(iset(isub).ge.3.and.iset(isub).le.5) then
        q2e=pmas(23,1)**2
        if(isub.eq.8.or.isub.eq.76.or.isub.eq.77.or.isub.eq.124.or.
     &  isub.eq.174.or.isub.eq.179) q2e=pmas(24,1)**2
      endif
      tmax=log(parp(67)*parp(63)*q2e/parp(61)**2)
      if(parp(67)*q2e.lt.max(parp(62)**2,2.*parp(61)**2).or.
     &tmax.lt.0.2) return

c...common constants and initial values. save normal lambda value.
      xe0=2.*parp(65)/vint(1)
      alams=paru(111)
      paru(111)=parp(61)
      ns=n
  100 n=ns
      do 110 jt=1,2
      kfls(jt)=mint(14+jt)
      kfls(jt+2)=kfls(jt)
      xs(jt)=vint(40+jt)
      zs(jt)=1.
      q2s(jt)=parp(67)*q2e
      tevs(jt)=tmax
      alam(jt)=parp(61)
      the2(jt)=100.
      do 110 kfl=-25,25
  110 xfs(jt,kfl)=xsfx(jt,kfl)
      dsh=vint(44)
      if(iset(isub).ge.3.and.iset(isub).le.5) dsh=vint(26)*vint(2)

c...pick up leg with highest virtuality.
  120 n=n+1
      jt=1
      if(n.gt.ns+1.and.q2s(2).gt.q2s(1)) jt=2
      kflb=kfls(jt)
      xb=xs(jt)
      do 130 kfl=-25,25
  130 xfb(kfl)=xfs(jt,kfl)
      dshr=2d0*sqrt(dsh)
      dshz=dsh/zs(jt)
      xe=max(xe0,xb*(1./(1.-parp(66))-1.))
      if(mint(40+jt).eq.1.or.xb+xe.ge.0.999) then
        q2b=0.
        goto 220
      endif

c...maximum q2 without or with q2 ordering. effective lambda and n_f.
      if(mstp(62).le.1) then
        q2b=0.5*(1./zs(jt)+1.)*q2s(jt)+0.5*(1./zs(jt)-1.)*(q2s(3-jt)-
     &  dsh+sqrt((dsh+q2s(1)+q2s(2))**2+8.*q2s(1)*q2s(2)*
     &  zs(jt)/(1.-zs(jt))))
        tevb=log(parp(63)*q2b/alam(jt)**2)
      else
        q2b=q2s(jt)
        tevb=tevs(jt)
      endif
      alsdum=ulalps(parp(63)*q2b)
      tevb=tevb+2.*log(alam(jt)/paru(117))
      tevbsv=tevb
      alam(jt)=paru(117)
      b0=(33.-2.*mstu(118))/6.

c...calculate altarelli-parisi and structure function weights.
      do 140 kfl=-25,25
      wtap(kfl)=0.
  140 wtsf(kfl)=0.
      if(kflb.eq.21) then
        wtapq=16.*(1.-sqrt(xb+xe))/(3.*sqrt(xb))
        do 150 kfl=-mstp(54),mstp(54)
        if(kfl.eq.0) wtap(kfl)=6.*log((1.-xb)/xe)
  150   if(kfl.ne.0) wtap(kfl)=wtapq
      else
        wtap(0)=0.5*xb*(1./(xb+xe)-1.)
        wtap(kflb)=8.*log((1.-xb)*(xb+xe)/xe)/3.
      endif
  160 wtsum=0.
      if(kflb.ne.21) xfbo=xfb(kflb)
      if(kflb.eq.21) xfbo=xfb(0)
      do 170 kfl=-mstp(54),mstp(54)
      wtsf(kfl)=xfb(kfl)/xfbo
  170 wtsum=wtsum+wtap(kfl)*wtsf(kfl)
      wtsum=max(0.0001d0,wtsum)

c...choose new t: fix alpha_s, alpha_s(q^2), alpha_s(k_t^2).
  180 if(mstp(64).le.0) then
        tevb=tevb+log(rlu(0))*paru(2)/(paru(111)*wtsum)
      elseif(mstp(64).eq.1) then
        tevb=tevb*exp(max(-70.d0,log(rlu(0))*b0/wtsum))
      else
        tevb=tevb*exp(max(-70.d0,log(rlu(0))*b0/(5.*wtsum)))
      endif
  190 q2ref=alam(jt)**2*exp(tevb)
      q2b=q2ref/parp(63)

c...evolution ended or select flavour for branching parton.
      if(q2b.lt.parp(62)**2) then
        q2b=0.
      else
        wtran=rlu(0)*wtsum
        kfla=-mstp(54)-1
  200   kfla=kfla+1
        wtran=wtran-wtap(kfla)*wtsf(kfla)
        if(kfla.lt.mstp(54).and.wtran.gt.0.) goto 200
        if(kfla.eq.0) kfla=21

c...choose z value and corrective weight.
        if(kflb.eq.21.and.kfla.eq.21) then
          z=1./(1.+((1.-xb)/xb)*(xe/(1.-xb))**rlu(0))
          wtz=(1.-z*(1.-z))**2
        elseif(kflb.eq.21) then
          z=xb/(1.-rlu(0)*(1.-sqrt(xb+xe)))**2
          wtz=0.5*(1.+(1.-z)**2)*sqrt(z)
        elseif(kfla.eq.21) then
          z=xb*(1.+rlu(0)*(1./(xb+xe)-1.))
          wtz=1.-2.*z*(1.-z)
        else
          z=1.-(1.-xb)*(xe/((xb+xe)*(1.-xb)))**rlu(0)
          wtz=0.5*(1.+z**2)
        endif

c...option with resummation of soft gluon emission as effective z shift.
        if(mstp(65).ge.1) then
          rsoft=6.
          if(kflb.ne.21) rsoft=8./3.
          z=z*(tevb/tevs(jt))**(rsoft*xe/((xb+xe)*b0))
          if(z.le.xb) goto 180
        endif

c...option with alpha_s(k_t^2): demand k_t^2 > cutoff, reweight.
        if(mstp(64).ge.2) then
          if((1.-z)*q2b.lt.parp(62)**2) goto 180
          alprat=tevb/(tevb+log(1.-z))
          if(alprat.lt.5.*rlu(0)) goto 180
          if(alprat.gt.5.) wtz=wtz*alprat/5.
        endif

c...option with angular ordering requirement.
        if(mstp(62).ge.3) then
          the2t=(4.*z**2*q2b)/(vint(2)*(1.-z)*xb**2)
          if(the2t.gt.the2(jt)) goto 180
        endif

c...weighting with new structure functions.
        call pystfu(mint(10+jt),xb,q2ref,xfn)
        if(kflb.ne.21) xfbn=xfn(kflb)
        if(kflb.eq.21) xfbn=xfn(0)
        if(xfbn.lt.1e-20) then
          if(kfla.eq.kflb) then
            tevb=tevbsv
            wtap(kflb)=0.
            goto 160
          elseif(tevbsv-tevb.gt.0.2) then
            tevb=0.5*(tevbsv+tevb)
            goto 190
          else
            xfbn=1e-10
            if(kflb.ne.21) xfn(kflb)=xfbn
            if(kflb.eq.21) xfn(0)=xfbn
          endif
        endif
        do 210 kfl=-mstp(54),mstp(54)
  210   xfb(kfl)=xfn(kfl)
        xa=xb/z
        call pystfu(mint(10+jt),xa,q2ref,xfa)
        if(kfla.ne.21) xfan=xfa(kfla)
        if(kfla.eq.21) xfan=xfa(0)
        if(xfan.lt.1e-20) goto 160
        if(kfla.ne.21) wtsfa=wtsf(kfla)
        if(kfla.eq.21) wtsfa=wtsf(0)
        if(wtz*xfan/xfbn.lt.rlu(0)*wtsfa) goto 160
      endif

c...define two hard scatterers in their cm-frame.
  220 if(n.eq.ns+2) then
        dq2(jt)=q2b
        dplcm=sqrt((dsh+dq2(1)+dq2(2))**2-4d0*dq2(1)*dq2(2))/dshr
        do 240 jr=1,2
        i=ns+jr
        if(jr.eq.1) ipo=ipus1
        if(jr.eq.2) ipo=ipus2
        do 230 j=1,5
        k(i,j)=0
        p(i,j)=0.
  230   v(i,j)=0.
        k(i,1)=14
        k(i,2)=kfls(jr+2)
        k(i,4)=ipo
        k(i,5)=ipo
        p(i,3)=dplcm*(-1)**(jr+1)
        p(i,4)=(dsh+dq2(3-jr)-dq2(jr))/dshr
        p(i,5)=-sqrt(dq2(jr))
        k(ipo,1)=14
        k(ipo,3)=i
        k(ipo,4)=mod(k(ipo,4),mstu(5))+mstu(5)*i
  240   k(ipo,5)=mod(k(ipo,5),mstu(5))+mstu(5)*i

c...find maximum allowed mass of timelike parton.
      elseif(n.gt.ns+2) then
        jr=3-jt
        dq2(3)=q2b
        dpc(1)=p(is(1),4)
        dpc(2)=p(is(2),4)
        dpc(3)=0.5*(abs(p(is(1),3))+abs(p(is(2),3)))
        dpd(1)=dsh+dq2(jr)+dq2(jt)
        dpd(2)=dshz+dq2(jr)+dq2(3)
        dpd(3)=sqrt(dpd(1)**2-4d0*dq2(jr)*dq2(jt))
        dpd(4)=sqrt(dpd(2)**2-4d0*dq2(jr)*dq2(3))
        ikin=0
        if(q2s(jr).ge.(0.5*parp(62))**2.and.dpd(1)-dpd(3).ge.
     &  1d-10*dpd(1)) ikin=1
        if(ikin.eq.0) dmsma=(dq2(jt)/zs(jt)-dq2(3))*(dsh/
     &  (dsh+dq2(jt))-dsh/(dshz+dq2(3)))
        if(ikin.eq.1) dmsma=(dpd(1)*dpd(2)-dpd(3)*dpd(4))/(2.*
     &  dq2(jr))-dq2(jt)-dq2(3)

c...generate timelike parton shower (if required).
        it=n
        do 250 j=1,5
        k(it,j)=0
        p(it,j)=0.
  250   v(it,j)=0.
        k(it,1)=3
        k(it,2)=21
        if(kflb.eq.21.and.kfls(jt+2).ne.21) k(it,2)=-kfls(jt+2)
        if(kflb.ne.21.and.kfls(jt+2).eq.21) k(it,2)=kflb
        p(it,5)=ulmass(k(it,2))
        if(dmsma .le.p(it,5)**2) goto 100
        if(mstp(63).ge.1) then
          p(it,4)=(dshz-dsh-p(it,5)**2)/dshr
          p(it,3)=sqrt(p(it,4)**2-p(it,5)**2)
          if(mstp(63).eq.1) then
            q2tim=dmsma
          elseif(mstp(63).eq.2) then
            q2tim=min(dmsma,parp(71)*q2s(jt))
          else
c'''here remains to introduce angular ordering in first branching.
            q2tim=dmsma
          endif
          call lushow(it,0,sqrt(q2tim))
          if(n.ge.it+1) p(it,5)=p(it+1,5)
        endif

c...reconstruct kinematics of branching: timelike parton shower.
        dms=p(it,5)**2
        if(ikin.eq.0) dpt2=(dmsma-dms)*(dshz+dq2(3))/(dsh+dq2(jt))
        if(ikin.eq.1) dpt2=(dmsma-dms)*(0.5*dpd(1)*dpd(2)+0.5*dpd(3)*
     &  dpd(4)-dq2(jr)*(dq2(jt)+dq2(3)+dms))/(4.*dsh*dpc(3)**2)
        if(dpt2.lt.0.) goto 100
        dpb(1)=(0.5*dpd(2)-dpc(jr)*(dshz+dq2(jr)-dq2(jt)-dms)/
     &  dshr)/dpc(3)-dpc(3)
        p(it,1)=sqrt(dpt2)
        p(it,3)=dpb(1)*(-1)**(jt+1)
        p(it,4)=(dshz-dsh-dms)/dshr
        if(n.ge.it+1) then
          dpb(1)=sqrt(dpb(1)**2+dpt2)
          dpb(2)=sqrt(dpb(1)**2+dms)
          dpb(3)=p(it+1,3)
          dpb(4)=sqrt(dpb(3)**2+dms)
          dbez=(dpb(4)*dpb(1)-dpb(3)*dpb(2))/(dpb(4)*dpb(2)-dpb(3)*
     &    dpb(1))
          call ludbrb(it+1,n,0.d0,0.d0,0d0,0d0,dbez)
          the=ulangl(p(it,3),p(it,1))
          call ludbrb(it+1,n,the,0.d0,0d0,0d0,0d0)
        endif

c...reconstruct kinematics of branching: spacelike parton.
        do 260 j=1,5
        k(n+1,j)=0
        p(n+1,j)=0.
  260   v(n+1,j)=0.
        k(n+1,1)=14
        k(n+1,2)=kflb
        p(n+1,1)=p(it,1)
        p(n+1,3)=p(it,3)+p(is(jt),3)
        p(n+1,4)=p(it,4)+p(is(jt),4)
        p(n+1,5)=-sqrt(dq2(3))

c...define colour flow of branching.
        k(is(jt),3)=n+1
        k(it,3)=n+1
        id1=it
        if((k(n+1,2).gt.0.and.k(n+1,2).ne.21.and.k(id1,2).gt.0.and.
     &  k(id1,2).ne.21).or.(k(n+1,2).lt.0.and.k(id1,2).eq.21).or.
     &  (k(n+1,2).eq.21.and.k(id1,2).eq.21.and.rlu(0).gt.0.5).or.
     &  (k(n+1,2).eq.21.and.k(id1,2).lt.0)) id1=is(jt)
        id2=it+is(jt)-id1
        k(n+1,4)=k(n+1,4)+id1
        k(n+1,5)=k(n+1,5)+id2
        k(id1,4)=k(id1,4)+mstu(5)*(n+1)
        k(id1,5)=k(id1,5)+mstu(5)*id2
        k(id2,4)=k(id2,4)+mstu(5)*id1
        k(id2,5)=k(id2,5)+mstu(5)*(n+1)
        n=n+1

c...boost to new cm-frame.
        call 
     &  ludbrb(ns+1,n,0.d0,0.d0,-(p(n,1)+p(is(jr),1))/(p(n,4)+
     &  p(is(jr),4)), 0d0,-(p(n,3)+p(is(jr),3))/(p(n,4)+
     &  p(is(jr),4)))
        ir=n+(jt-1)*(is(1)-n)
        call ludbrb(ns+1,n,-ulangl(p(ir,3),p(ir,1)),paru(2)*rlu(0),
     &  0d0,0d0,0d0)
      endif

c...save quantities, loop back.
      is(jt)=n
      q2s(jt)=q2b
      dq2(jt)=q2b
      if(mstp(62).ge.3) the2(jt)=the2t
      dsh=dshz
      if(q2b.ge.(0.5*parp(62))**2) then
        kfls(jt+2)=kfls(jt)
        kfls(jt)=kfla
        xs(jt)=xa
        zs(jt)=z
        do 270 kfl=-25,25
  270   xfs(jt,kfl)=xfa(kfl)
        tevs(jt)=tevb
      else
        if(jt.eq.1) ipu1=n
        if(jt.eq.2) ipu2=n
      endif
      if(n.gt.mstu(4)-mstu(32)-10) then
        call luerrm(11,'(pysspa:) no more memory left in lujets')
        if(mstu(21).ge.1) n=ns
        if(mstu(21).ge.1) return
      endif
      if(max(q2s(1),q2s(2)).ge.(0.5*parp(62))**2.or.n.le.ns+1) goto 120

c...boost hard scattering partons to frame of shower initiators.
      do 280 j=1,3
  280 robo(j+2)=(p(ns+1,j)+p(ns+2,j))/(p(ns+1,4)+p(ns+2,4))
      k(n+2,1)=1
      do 290 j=1,5
  290 p(n+2,j)=p(ns+1,j)
      robot=robo(3)**2+robo(4)**2+robo(5)**2
      if(robot.ge.0.999999) then
        robot=1.00001*sqrt(robot)
        robo(3)=robo(3)/robot
        robo(4)=robo(4)/robot
        robo(5)=robo(5)/robot
      endif
      call ludbrb(n+2,n+2,0.d0,0.d0,-robo(3),-robo(4),
     &-robo(5))
      robo(2)=ulangl(p(n+2,1),p(n+2,2))
      robo(1)=ulangl(p(n+2,3),sqrt(p(n+2,1)**2+p(n+2,2)**2))
      call ludbrb(mint(83)+5,ns,robo(1),robo(2),robo(3),
     &robo(4),robo(5))

c...store user information. reset lambda value.
      k(ipu1,3)=mint(83)+3
      k(ipu2,3)=mint(83)+4
      do 300 jt=1,2
      mint(12+jt)=kfls(jt)
  300 vint(140+jt)=xs(jt)
      paru(111)=alams

      return
      end

c*********************************************************************

      subroutine pyresd
      implicit double precision (a-h,o-z)

c...allows resonances to decay (including parton showers for hadronic
c...channels).
c      implicit double precision(d)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      save /lujets/,/ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint4/
      dimension iref(10,6),kdcy(2),kfl1(2),kfl2(2),keql(2),nsd(2),
     &ilin(6),hgz(2,3),coup(6,4),corl(2,2,2),pk(6,4),pkk(6,6),
     &cthe(2),phi(2),wdtp(0:40),wdte(0:40,0:5),dbezqq(3)
      complex*16 fgk,ha(6,6),hc(6,6)

c...the f, xi and xj functions of gunion and kunszt
c...(phys. rev. d33, 665, plus errata from the authors).
      fgk(i1,i2,i3,i4,i5,i6)=4.*ha(i1,i3)*hc(i2,i6)*(ha(i1,i5)*
     &hc(i1,i4)+ha(i3,i5)*hc(i3,i4))
      digk(dt,du)=-4.*d34*d56+dt*(3.*dt+4.*du)+dt**2*(dt*du/(d34*d56)-
     &2.*(1./d34+1./d56)*(dt+du)+2.*(d34/d56+d56/d34))
      djgk(dt,du)=8.*(d34+d56)**2-8.*(d34+d56)*(dt+du)-6.*dt*du-
     &2.*dt*du*(dt*du/(d34*d56)-2.*(1./d34+1./d56)*(dt+du)+
     &2.*(d34/d56+d56/d34))

c...some general constants.
      xw=paru(102)
      sqmz=pmas(23,1)**2
      sqmw=pmas(24,1)**2
      sh=vint(44)

c...define initial two objects.
      isub=mint(1)
      if(iset(isub).eq.1.or.iset(isub).eq.3.or.iset(isub).eq.5) then
        iref(1,1)=mint(84)+2+min(3,iset(isub))
        iref(1,2)=0
        iref(1,3)=mint(83)+6+min(3,iset(isub))
        iref(1,4)=0
      elseif(iset(isub).eq.2.or.iset(isub).eq.4) then
        iref(1,1)=mint(84)+1+iset(isub)
        iref(1,2)=mint(84)+2+iset(isub)
        iref(1,3)=mint(83)+5+iset(isub)
        iref(1,4)=mint(83)+6+iset(isub)
      elseif(iset(isub).eq.6) then
        iref(1,1)=mint(84)+3
        iref(1,2)=0
        iref(1,3)=mint(83)+7
        iref(1,4)=0
      endif

c...check if initial resonance has been moved (in resonance + jet).
      if(k(iref(1,1),1).gt.10) then
        kfa=iabs(k(iref(1,1),2))
        kda=mod(k(iref(1,1),4),mstu(4))
        if(kfa.ge.23.and.kfa.le.40.and.kda.gt.1) iref(1,1)=kda
      endif
      if(iref(1,2).gt.0) then
        if(k(iref(1,2),1).gt.10) then
          kfa=iabs(k(iref(1,2),2))
          kda=mod(k(iref(1,2),4),mstu(4))
          if(kfa.ge.23.and.kfa.le.40.and.kda.gt.1) iref(1,2)=kda
        endif
      endif
      iref(1,5)=0
      iref(1,6)=0

c...loop over decay history.
      np=1
      ip=0
  100 ip=ip+1
      ninh=0
      jtmax=2
      if(ip.eq.1.and.iref(1,2).eq.0) jtmax=1
      nsav=n

c...start treatment of one or two resonances in parallel.
  110 n=nsav
      do 140 jt=1,jtmax
      id=iref(ip,jt)
      kdcy(jt)=0
      kfl1(jt)=0
      kfl2(jt)=0
      keql(jt)=0
      nsd(jt)=id
      if(id.eq.0) goto 140
      kfa=iabs(k(id,2))
      if(kfa.lt.23.or.kfa.gt.40) goto 140
      if(k(id,1).gt.10.or.mdcy(kfa,1).eq.0) goto 140

c...select decay channel.
      if(iset(isub).ne.6) then
        if(isub.eq.1.or.isub.eq.22.or.isub.eq.141) mint(61)=1
        call pywidt(kfa,p(id,5)**2,wdtp,wdte)
        if(kchg(kfa,3).eq.0) then
          ipm=2
        else
          ipm=(5+isign(1,k(id,2)))/2
        endif
        kfb=0
        if(jtmax.eq.2) kfb=iabs(k(iref(ip,3-jt),2))
        wdte0s=wdte(0,1)+wdte(0,ipm)+wdte(0,4)
        if(kfb.eq.kfa) wdte0s=wdte0s+wdte(0,5)
        if(wdte0s.le.0.) goto 140
        rkfl=wdte0s*rlu(0)
        idl=0
  120   idl=idl+1
        idc=idl+mdcy(kfa,2)-1
        rkfl=rkfl-(wdte(idl,1)+wdte(idl,ipm)+wdte(idl,4))
        if(kfb.eq.kfa) rkfl=rkfl-wdte(idl,5)
        if(idl.lt.mdcy(kfa,3).and.rkfl.gt.0.) goto 120
      else
        idc=mint(35)
      endif

c...read out and classify decay channel chosen.
      kfl1(jt)=kfdp(idc,1)*isign(1,k(id,2))
      kfc1a=iabs(kfl1(jt))
      if(kfc1a.gt.100) kfc1a=lucomp(kfc1a)
      if(kchg(kfc1a,3).eq.0) kfl1(jt)=iabs(kfl1(jt))
      kfl2(jt)=kfdp(idc,2)*isign(1,k(id,2))
      kfc2a=iabs(kfl2(jt))
      if(kfc2a.gt.100) kfc2a=lucomp(kfc2a)
      if(kchg(kfc2a,3).eq.0) kfl2(jt)=iabs(kfl2(jt))
      kdcy(jt)=2
      if(iabs(kfl1(jt)).le.10.or.kfl1(jt).eq.21) kdcy(jt)=1
      if(iabs(kfl1(jt)).ge.23.and.iabs(kfl1(jt)).le.40) kdcy(jt)=3
      keql(jt)=mdme(idc,1)
      nsd(jt)=n
      hgz(jt,1)=vint(111)
      hgz(jt,2)=vint(112)
      hgz(jt,3)=vint(114)

c...select masses and check that mass sum not too large.
      if(mstp(42).le.0.or.(pmas(kfc1a,2).lt.parp(41).and.
     &pmas(kfc2a,2).lt.parp(41))) then
        p(n+1,5)=pmas(kfc1a,1)
        p(n+2,5)=pmas(kfc2a,1)
        if(p(n+1,5)+p(n+2,5)+parj(64).gt.p(id,5)) then
          call luerrm(13,'(pyresd:) daughter masses too large')
          mint(51)=1
          return
        endif
      elseif(ip.eq.1) then
        call pyofsh(2,kfa,kfl1(jt),kfl2(jt),p(id,5),p(n+1,5),p(n+2,5))
        if(mint(51).eq.1) return
      else
  130   p(n+1,5)=ulmass(kfl1(jt))
        p(n+2,5)=ulmass(kfl2(jt))
        if(p(n+1,5)+p(n+2,5)+parj(64).gt.p(id,5)) goto 130
      endif

c...fill decay products, prepared for parton showers for quarks.
c...special case, done by hand, for leptoquark.
      mstu(10)=1
      if(kfa.eq.39) then
        mstu(19)=1
        call lu2ent(n+1,kfl1(jt),kfl2(jt),p(id,5))
        k(n-1,1)=3
        k(n,1)=1
        isid=4
        if(k(id,2).lt.0) isid=5
        k(id,isid)=k(id,isid)+(n-1)
        k(n-1,isid)=mstu(5)*id
      elseif(kdcy(jt).eq.1) then
        call lu2ent(-(n+1),kfl1(jt),kfl2(jt),p(id,5))
      else
        call lu2ent(n+1,kfl1(jt),kfl2(jt),p(id,5))
      endif
      mstu(10)=2
  140 if(kfa.ge.23.and.kfa.le.40.and.kfl1(jt).eq.0) ninh=ninh+1

c...check for allowed combinations. skip if no decays.
      if(iset(isub).eq.6) goto 290
      if(jtmax.eq.2) then
        if(keql(1).eq.4.and.keql(2).eq.4) goto 110
        if(keql(1).eq.5.and.keql(2).eq.5) goto 110
      endif
      if(jtmax.eq.1.and.kdcy(1).eq.0) goto 350
      if(jtmax.eq.2.and.kdcy(1).eq.0.and.kdcy(2).eq.0) goto 350

c...order incoming partons and outgoing resonances.
      if(jtmax.eq.2.and.mstp(47).ge.1.and.ninh.eq.0) then
        ilin(1)=mint(84)+1
        if(k(mint(84)+1,2).gt.0) ilin(1)=mint(84)+2
        if(k(ilin(1),2).eq.21) ilin(1)=2*mint(84)+3-ilin(1)
        ilin(2)=2*mint(84)+3-ilin(1)
        imin=1
        if(iref(ip,5).eq.25.or.iref(ip,5).eq.35.or.iref(ip,5).
     &  eq.36) imin=3
        imax=2
        iord=1
        if(k(iref(ip,1),2).eq.23) iord=2
        if(k(iref(ip,1),2).eq.24.and.k(iref(ip,2),2).eq.-24) iord=2
        iakipd=iabs(k(iref(ip,iord),2))
        if(iakipd.eq.25.or.iakipd.eq.35.or.iakipd.eq.36) iord=3-iord
        if(kdcy(iord).eq.0) iord=3-iord

c...order decay products of resonances.
        do 150 jt=iord,3-iord,3-2*iord
        if(kdcy(jt).eq.0) then
          ilin(imax+1)=nsd(jt)
          imax=imax+1
        elseif(k(nsd(jt)+1,2).gt.0) then
          ilin(imax+1)=n+2*jt-1
          ilin(imax+2)=n+2*jt
          imax=imax+2
          k(n+2*jt-1,2)=k(nsd(jt)+1,2)
          k(n+2*jt,2)=k(nsd(jt)+2,2)
        else
          ilin(imax+1)=n+2*jt
          ilin(imax+2)=n+2*jt-1
          imax=imax+2
          k(n+2*jt-1,2)=k(nsd(jt)+1,2)
          k(n+2*jt,2)=k(nsd(jt)+2,2)
        endif
  150   continue

c...find charge, isospin, left- and righthanded couplings.
        do 170 i=imin,imax
        do 160 j=1,4
  160   coup(i,j)=0.
        kfa=iabs(k(ilin(i),2))
        if(kfa.eq.0.or.kfa.gt.20) goto 170
        coup(i,1)=kchg(kfa,1)/3.
        coup(i,2)=(-1)**mod(kfa,2)
        coup(i,4)=-2.*coup(i,1)*xw
        coup(i,3)=coup(i,2)+coup(i,4)
  170   continue

c...full propagator dependence and flavour correlations for 2 gamma*/z.
        if(isub.eq.22) then
          do 180 i=3,5,2
          i1=iord
          if(i.eq.5) i1=3-iord
          do 180 j1=1,2
          do 180 j2=1,2
  180     corl(i/2,j1,j2)=coup(1,1)**2*hgz(i1,1)*coup(i,1)**2/16.+
     &    coup(1,1)*coup(1,j1+2)*hgz(i1,2)*coup(i,1)*coup(i,j2+2)/4.+
     &    coup(1,j1+2)**2*hgz(i1,3)*coup(i,j2+2)**2
          cowt12=(corl(1,1,1)+corl(1,1,2))*(corl(2,1,1)+corl(2,1,2))+
     &    (corl(1,2,1)+corl(1,2,2))*(corl(2,2,1)+corl(2,2,2))
          comx12=(corl(1,1,1)+corl(1,1,2)+corl(1,2,1)+corl(1,2,2))*
     &    (corl(2,1,1)+corl(2,1,2)+corl(2,2,1)+corl(2,2,2))
          if(cowt12.lt.rlu(0)*comx12) goto 110
        endif
      endif

c...select angular orientation type - z'/w' only.
      mzpwp=0
      if(isub.eq.141) then
        if(rlu(0).lt.paru(130)) mzpwp=1
        if(ip.eq.2.and.iabs(k(iref(2,1),2)).eq.37) mzpwp=2
        iakir=iabs(k(iref(2,2),2))
        if(ip.eq.2.and.(iakir.eq.25.or.iakir.eq.35.or.iakir.eq.36))
     &  mzpwp=2
        if(ip.ge.3) mzpwp=2
      elseif(isub.eq.142) then
        if(rlu(0).lt.paru(136)) mzpwp=1
        iakir=iabs(k(iref(2,2),2))
        if(ip.eq.2.and.(iakir.eq.25.or.iakir.eq.35.or.iakir.eq.36))
     &  mzpwp=2
        if(ip.ge.3) mzpwp=2
      endif

c...select random angles (begin of weighting procedure).
  190 do 200 jt=1,jtmax
      if(kdcy(jt).eq.0) goto 200
      if(jtmax.eq.1) then
        cthe(jt)=vint(13)+(vint(33)-vint(13)+vint(34)-vint(14))*rlu(0)
        if(cthe(jt).gt.vint(33)) cthe(jt)=cthe(jt)+vint(14)-vint(33)
        phi(jt)=vint(24)
      else
        cthe(jt)=2.*rlu(0)-1.
        phi(jt)=paru(2)*rlu(0)
      endif
  200 continue

      if(jtmax.eq.2.and.mstp(47).ge.1.and.ninh.eq.0) then
c...construct massless four-vectors.
        do 210 i=n+1,n+4
        k(i,1)=1
        do 210 j=1,5
  210   p(i,j)=0.
        do 220 jt=1,jtmax
        if(kdcy(jt).eq.0) goto 220
        id=iref(ip,jt)
        p(n+2*jt-1,3)=0.5*p(id,5)
        p(n+2*jt-1,4)=0.5*p(id,5)
        p(n+2*jt,3)=-0.5*p(id,5)
        p(n+2*jt,4)=0.5*p(id,5)
        call ludbrb(n+2*jt-1,n+2*jt,acos(cthe(jt)),phi(jt),p(id,1)/
     &  p(id,4),p(id,2)/p(id,4),p(id,3)/p(id,4))
  220   continue

c...store incoming and outgoing momenta, with random rotation to
c...avoid accidental zeroes in ha expressions.
        do 230 i=1,imax
        k(n+4+i,1)=1
        p(n+4+i,4)=sqrt(p(ilin(i),1)**2+p(ilin(i),2)**2+p(ilin(i),3)**2+
     &  p(ilin(i),5)**2)
        p(n+4+i,5)=p(ilin(i),5)
        do 230 j=1,3
  230   p(n+4+i,j)=p(ilin(i),j)
  240   therr=acos(2.*rlu(0)-1.)
        phirr=paru(2)*rlu(0)
        call ludbrb(n+5,n+4+imax,therr,phirr,0d0,0d0,0d0)
        do 250 i=1,imax
        if(p(n+4+i,1)**2+p(n+4+i,2)**2.lt.1e-4*p(n+4+i,4)**2) goto 240
        do 250 j=1,4
  250   pk(i,j)=p(n+4+i,j)

c...calculate internal products.
        if(isub.eq.22.or.isub.eq.23.or.isub.eq.25.or.isub.eq.141.or.
     &  isub.eq.142) then
          do 260 i1=imin,imax-1
          do 260 i2=i1+1,imax
          ha(i1,i2)=sqrt((pk(i1,4)-pk(i1,3))*(pk(i2,4)+pk(i2,3))/
     &    (1e-20+pk(i1,1)**2+pk(i1,2)**2))*cmplx(pk(i1,1),pk(i1,2))-
     &    sqrt((pk(i1,4)+pk(i1,3))*(pk(i2,4)-pk(i2,3))/
     &    (1e-20+pk(i2,1)**2+pk(i2,2)**2))*cmplx(pk(i2,1),pk(i2,2))
          hc(i1,i2)=conjg(ha(i1,i2))
          if(i1.le.2) ha(i1,i2)=cmplx(0.,1.)*ha(i1,i2)
          if(i1.le.2) hc(i1,i2)=cmplx(0.,1.)*hc(i1,i2)
          ha(i2,i1)=-ha(i1,i2)
  260     hc(i2,i1)=-hc(i1,i2)
        endif
        do 270 i=1,2
        do 270 j=1,4
  270   pk(i,j)=-pk(i,j)
        do 280 i1=imin,imax-1
        do 280 i2=i1+1,imax
        pkk(i1,i2)=2.*(pk(i1,4)*pk(i2,4)-pk(i1,1)*pk(i2,1)-
     &  pk(i1,2)*pk(i2,2)-pk(i1,3)*pk(i2,3))
  280   pkk(i2,i1)=pkk(i1,i2)
      endif

      if(mstp(47).le.0.or.ninh.ne.0) then
c...isotropic decay selected by user.
        wt=1.
        wtmax=1.

      elseif(iref(ip,5).eq.25.or.iref(ip,5).eq.35.or.
     &iref(ip,5).eq.36) then
c...angular weight for h0 -> z0 + z0 or w+ + w- -> 4 quarks/leptons.
        wt=16.*pkk(3,5)*pkk(4,6)
        if(ip.eq.1) wtmax=sh**2
        if(ip.ge.2) wtmax=p(iref(ip,6),5)**4

      elseif(isub.eq.1) then
c...angular weight for gamma*/z0 -> 2 quarks/leptons.
        ei=kchg(iabs(mint(15)),1)/3.
        ai=sign(1.d0,ei+0.1)
        vi=ai-4.*ei*xw
        ef=kchg(iabs(kfl1(1)),1)/3.
        af=sign(1.d0,ef+0.1)
        vf=af-4.*ef*xw
        asym=2.*(ei*ai*vint(112)*ef*af+4.*vi*ai*vint(114)*vf*af)/
     &  (ei**2*vint(111)*ef**2+ei*vi*vint(112)*ef*vf+
     &  (vi**2+ai**2)*vint(114)*(vf**2+af**2))
        wt=1.+asym*cthe(1)*isign(1,mint(15)*kfl1(1))+cthe(1)**2
        wtmax=2.+abs(asym)

      elseif(isub.eq.2) then
c...angular weight for w+/- -> 2 quarks/leptons.
        wt=(1.+cthe(1)*isign(1,mint(15)*kfl1(1)))**2
        wtmax=4.

      elseif(isub.eq.15.or.isub.eq.19) then
c...angular weight for f + f~ -> gluon/gamma + z0 ->
c...-> gluon/gamma + 2 quarks/leptons.
        wt=((coup(1,3)*coup(3,3))**2+(coup(1,4)*coup(3,4))**2)*
     &  (pkk(1,3)**2+pkk(2,4)**2)+((coup(1,3)*coup(3,4))**2+
     &  (coup(1,4)*coup(3,3))**2)*(pkk(1,4)**2+pkk(2,3)**2)
        wtmax=(coup(1,3)**2+coup(1,4)**2)*(coup(3,3)**2+coup(3,4)**2)*
     &  ((pkk(1,3)+pkk(1,4))**2+(pkk(2,3)+pkk(2,4))**2)

      elseif(isub.eq.16.or.isub.eq.20) then
c...angular weight for f + f~' -> gluon/gamma + w+/- ->
c...-> gluon/gamma + 2 quarks/leptons.
        wt=pkk(1,3)**2+pkk(2,4)**2
        wtmax=(pkk(1,3)+pkk(1,4))**2+(pkk(2,3)+pkk(2,4))**2

      elseif(isub.eq.22) then
c...angular weight for f + f~ -> z0 + z0 -> 4 quarks/leptons.
        s34=p(iref(ip,iord),5)**2
        s56=p(iref(ip,3-iord),5)**2
        ti=pkk(1,3)+pkk(1,4)+s34
        ui=pkk(1,5)+pkk(1,6)+s56
        fgk135=abs(fgk(1,2,3,4,5,6)/ti+fgk(1,2,5,6,3,4)/ui)**2
        fgk145=abs(fgk(1,2,4,3,5,6)/ti+fgk(1,2,5,6,4,3)/ui)**2
        fgk136=abs(fgk(1,2,3,4,6,5)/ti+fgk(1,2,6,5,3,4)/ui)**2
        fgk146=abs(fgk(1,2,4,3,6,5)/ti+fgk(1,2,6,5,4,3)/ui)**2
        fgk253=abs(fgk(2,1,5,6,3,4)/ti+fgk(2,1,3,4,5,6)/ui)**2
        fgk263=abs(fgk(2,1,6,5,3,4)/ti+fgk(2,1,3,4,6,5)/ui)**2
        fgk254=abs(fgk(2,1,5,6,4,3)/ti+fgk(2,1,4,3,5,6)/ui)**2
        fgk264=abs(fgk(2,1,6,5,4,3)/ti+fgk(2,1,4,3,6,5)/ui)**2
        wt=
     &  corl(1,1,1)*corl(2,1,1)*fgk135+corl(1,1,2)*corl(2,1,1)*fgk145+
     &  corl(1,1,1)*corl(2,1,2)*fgk136+corl(1,1,2)*corl(2,1,2)*fgk146+
     &  corl(1,2,1)*corl(2,2,1)*fgk253+corl(1,2,2)*corl(2,2,1)*fgk263+
     &  corl(1,2,1)*corl(2,2,2)*fgk254+corl(1,2,2)*corl(2,2,2)*fgk264
        wtmax=16.*((corl(1,1,1)+corl(1,1,2))*(corl(2,1,1)+corl(2,1,2))+
     &  (corl(1,2,1)+corl(1,2,2))*(corl(2,2,1)+corl(2,2,2)))*s34*s56*
     &  ((ti**2+ui**2+2.*sh*(s34+s56))/(ti*ui)-s34*s56*(1./ti**2+
     &  1./ui**2))

      elseif(isub.eq.23) then
c...angular weight for f + f~' -> z0 + w+/- -> 4 quarks/leptons.
        d34=p(iref(ip,iord),5)**2
        d56=p(iref(ip,3-iord),5)**2
        dt=pkk(1,3)+pkk(1,4)+d34
        du=pkk(1,5)+pkk(1,6)+d56
        cawz=coup(2,3)/dt-2.*(1.-xw)*coup(1,2)/(sh-sqmw)
        cbwz=coup(1,3)/du+2.*(1.-xw)*coup(1,2)/(sh-sqmw)
        fgk135=abs(cawz*fgk(1,2,3,4,5,6)+cbwz*fgk(1,2,5,6,3,4))
        fgk136=abs(cawz*fgk(1,2,3,4,6,5)+cbwz*fgk(1,2,6,5,3,4))
        wt=(coup(5,3)*fgk135)**2+(coup(5,4)*fgk136)**2
        wtmax=4.*d34*d56*(coup(5,3)**2+coup(5,4)**2)*(cawz**2*
     &  digk(dt,du)+cbwz**2*digk(du,dt)+cawz*cbwz*djgk(dt,du))

      elseif(isub.eq.24.or.isub.eq.171.or.isub.eq.176) then
c...angular weight for f + f~ -> z0 + h0 -> 2 quarks/leptons + h0
c...(or h'0, or a0).
        wt=((coup(1,3)*coup(3,3))**2+(coup(1,4)*coup(3,4))**2)*
     &  pkk(1,3)*pkk(2,4)+((coup(1,3)*coup(3,4))**2+(coup(1,4)*
     &  coup(3,3))**2)*pkk(1,4)*pkk(2,3)
        wtmax=(coup(1,3)**2+coup(1,4)**2)*(coup(3,3)**2+coup(3,4)**2)*
     &  (pkk(1,3)+pkk(1,4))*(pkk(2,3)+pkk(2,4))

      elseif(isub.eq.25) then
c...angular weight for f + f~ -> w+ + w- -> 4 quarks/leptons.
        d34=p(iref(ip,iord),5)**2
        d56=p(iref(ip,3-iord),5)**2
        dt=pkk(1,3)+pkk(1,4)+d34
        du=pkk(1,5)+pkk(1,6)+d56
        cdww=(coup(1,3)*sqmz/(sh-sqmz)+coup(1,2))/sh
        caww=cdww+0.5*(coup(1,2)+1.)/dt
        cbww=cdww+0.5*(coup(1,2)-1.)/du
        ccww=coup(1,4)*sqmz/(sh-sqmz)/sh
        fgk135=abs(caww*fgk(1,2,3,4,5,6)-cbww*fgk(1,2,5,6,3,4))
        fgk253=abs(fgk(2,1,5,6,3,4)-fgk(2,1,3,4,5,6))
        wt=fgk135**2+(ccww*fgk253)**2
        wtmax=4.*d34*d56*(caww**2*digk(dt,du)+cbww**2*digk(du,dt)-caww*
     &  cbww*djgk(dt,du)+ccww**2*(digk(dt,du)+digk(du,dt)-djgk(dt,du)))

      elseif(isub.eq.26.or.isub.eq.172.or.isub.eq.177) then
c...angular weight for f + f~' -> w+/- + h0 -> 2 quarks/leptons + h0
c...(or h'0, or a0).
        wt=pkk(1,3)*pkk(2,4)
        wtmax=(pkk(1,3)+pkk(1,4))*(pkk(2,3)+pkk(2,4))

      elseif(isub.eq.30.or.isub.eq.35) then
c...angular weight for f + g -> f + z0 -> f + 2 quarks/leptons
c...and for f + gamma -> f + z0 -> f + 2 quarks/leptons.
        if(k(ilin(1),2).gt.0) wt=((coup(1,3)*coup(3,3))**2+
     &  (coup(1,4)*coup(3,4))**2)*(pkk(1,4)**2+pkk(3,5)**2)+
     &  ((coup(1,3)*coup(3,4))**2+(coup(1,4)*coup(3,3))**2)*
     &  (pkk(1,3)**2+pkk(4,5)**2)
        if(k(ilin(1),2).lt.0) wt=((coup(1,3)*coup(3,3))**2+
     &  (coup(1,4)*coup(3,4))**2)*(pkk(1,3)**2+pkk(4,5)**2)+
     &  ((coup(1,3)*coup(3,4))**2+(coup(1,4)*coup(3,3))**2)*
     &  (pkk(1,4)**2+pkk(3,5)**2)
        wtmax=(coup(1,3)**2+coup(1,4)**2)*(coup(3,3)**2+coup(3,4)**2)*
     &  ((pkk(1,3)+pkk(1,4))**2+(pkk(3,5)+pkk(4,5))**2)

      elseif(isub.eq.31) then
c...angular weight for f + g -> f' + w+/- -> f' + 2 quarks/leptons.
        if(k(ilin(1),2).gt.0) wt=pkk(1,4)**2+pkk(3,5)**2
        if(k(ilin(1),2).lt.0) wt=pkk(1,3)**2+pkk(4,5)**2
        wtmax=(pkk(1,3)+pkk(1,4))**2+(pkk(3,5)+pkk(4,5))**2

      elseif(isub.eq.71.or.isub.eq.72.or.isub.eq.73.or.isub.eq.76.or.
     &isub.eq.77) then
c...angular weight for v_l1 + v_l2 -> v_l3 + v_l4 (v = z/w).
        wt=16.*pkk(3,5)*pkk(4,6)
        wtmax=sh**2

      elseif(isub.eq.141) then
        if(ip.eq.1.and.(kdcy(1).eq.1.or.kdcy(1).eq.2)) then
c...angular weight for f + f~ -> gamma*/z0/z'0 -> 2 quarks/leptons.
c...couplings of incoming flavour.
          kfai=iabs(mint(15))
          ei=kchg(kfai,1)/3.
          ai=sign(1.d0,ei+0.1)
          vi=ai-4.*ei*xw
          kfaic=1
          if(kfai.le.10.and.mod(kfai,2).eq.0) kfaic=2
          if(kfai.gt.10.and.mod(kfai,2).ne.0) kfaic=3
          if(kfai.gt.10.and.mod(kfai,2).eq.0) kfaic=4
          vpi=paru(119+2*kfaic)
          api=paru(120+2*kfaic)
c...couplings of final flavour.
          kfaf=iabs(kfl1(1))
          ef=kchg(kfaf,1)/3.
          af=sign(1.d0,ef+0.1)
          vf=af-4.*ef*xw
          kfafc=1
          if(kfaf.le.10.and.mod(kfaf,2).eq.0) kfafc=2
          if(kfaf.gt.10.and.mod(kfaf,2).ne.0) kfafc=3
          if(kfaf.gt.10.and.mod(kfaf,2).eq.0) kfafc=4
          vpf=paru(119+2*kfafc)
          apf=paru(120+2*kfafc)
c...asymmetry and weight.
          asym=2.*(ei*ai*vint(112)*ef*af+ei*api*vint(113)*ef*apf+
     &    4.*vi*ai*vint(114)*vf*af+(vi*api+vpi*ai)*vint(115)*
     &    (vf*apf+vpf*af)+4.*vpi*api*vint(116)*vpf*apf)/
     &    (ei**2*vint(111)*ef**2+ei*vi*vint(112)*ef*vf+
     &    ei*vpi*vint(113)*ef*vpf+(vi**2+ai**2)*vint(114)*
     &    (vf**2+af**2)+(vi*vpi+ai*api)*vint(115)*(vf*vpf+af*apf)+
     &    (vpi**2+api**2)*vint(116)*(vpf**2+apf**2))
          wt=1.+asym*cthe(1)*isign(1,mint(15)*kfl1(1))+cthe(1)**2
          wtmax=2.+abs(asym)
        elseif(ip.eq.1.and.iabs(kfl1(1)).eq.24) then
c...angular weight for f + f~ -> z' -> w+ + w-.
          rm1=p(nsd(1)+1,5)**2/sh
          rm2=p(nsd(1)+2,5)**2/sh
          ccos2=-(1./16.)*((1.-rm1-rm2)**2-4.*rm1*rm2)*
     &    (1.-2.*rm1-2.*rm2+rm1**2+rm2**2+10.*rm1*rm2)
          cflat=-ccos2+0.5*(rm1+rm2)*(1.-2.*rm1-2.*rm2+(rm2-rm1)**2)
          wt=cflat+ccos2*cthe(1)**2
          wtmax=cflat+max(0.d0,ccos2)
        elseif(ip.eq.1.and.(kfl1(1).eq.25.or.kfl1(1).eq.35.or.
     &  iabs(kfl1(1)).eq.37)) then
c...angular weight for f + f~ -> z' -> h0 + a0, h'0 + a0, h+ + h-.
          wt=1.-cthe(1)**2
          wtmax=1.
        elseif(ip.eq.1.and.kdcy(1).eq.3) then
c...angular weight for f + f~ -> z' -> z0 + h0.
          rm1=p(nsd(1)+1,5)**2/sh
          rm2=p(nsd(1)+2,5)**2/sh
          flam2=max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2)
          wt=1.+flam2*(1.-cthe(1)**2)/(8.*rm1)
          wtmax=1.+flam2/(8.*rm1)
        elseif(mzpwp.eq.0) then
c...angular weight for f + f~ -> z' -> w+ + w- -> 4 quarks/leptons
c...(w:s like if intermediate z).
          d34=p(iref(ip,iord),5)**2
          d56=p(iref(ip,3-iord),5)**2
          dt=pkk(1,3)+pkk(1,4)+d34
          du=pkk(1,5)+pkk(1,6)+d56
          fgk135=abs(fgk(1,2,3,4,5,6)-fgk(1,2,5,6,3,4))
          fgk253=abs(fgk(2,1,5,6,3,4)-fgk(2,1,3,4,5,6))
          wt=(coup(1,3)*fgk135)**2+(coup(1,4)*fgk253)**2
          wtmax=4.*d34*d56*(coup(1,3)**2+coup(1,4)**2)*
     &    (digk(dt,du)+digk(du,dt)-djgk(dt,du))
        elseif(mzpwp.eq.1) then
c...angular weight for f + f~ -> z' -> w+ + w- -> 4 quarks/leptons
c...(w:s approximately longitudinal, like if intermediate h).
          wt=16.*pkk(3,5)*pkk(4,6)
          wtmax=sh**2
        else
c...angular weight for f + f~ -> z' -> h+ + h-, z0 + h0, h0 + a0,
c...h'0 + a0 -> 4 quarks/leptons.
          wt=1.
          wtmax=1.
        endif

      elseif(isub.eq.142) then
        if(ip.eq.1.and.(kdcy(1).eq.1.or.kdcy(1).eq.2)) then
c...angular weight for f + f~' -> w'+/- -> 2 quarks/leptons.
          kfai=iabs(mint(15))
          kfaic=1
          if(kfai.gt.10) kfaic=2
          vi=paru(129+2*kfaic)
          ai=paru(130+2*kfaic)
          kfaf=iabs(kfl1(1))
          kfafc=1
          if(kfaf.gt.10) kfafc=2
          vf=paru(129+2*kfafc)
          af=paru(130+2*kfafc)
          asym=8.*vi*ai*vf*af/((vi**2+ai**2)*(vf**2+af**2))
          wt=1.+asym*cthe(1)*isign(1,mint(15)*kfl1(1))+cthe(1)**2
          wtmax=2.+abs(asym)
        elseif(ip.eq.1.and.iabs(kfl2(1)).eq.23) then
c...angular weight for f + f~' -> w'+/- -> w+/- + z0.
          rm1=p(nsd(1)+1,5)**2/sh
          rm2=p(nsd(1)+2,5)**2/sh
          ccos2=-(1./16.)*((1.-rm1-rm2)**2-4.*rm1*rm2)*
     &    (1.-2.*rm1-2.*rm2+rm1**2+rm2**2+10.*rm1*rm2)
          cflat=-ccos2+0.5*(rm1+rm2)*(1.-2.*rm1-2.*rm2+(rm2-rm1)**2)
          wt=cflat+ccos2*cthe(1)**2
          wtmax=cflat+max(0.d0,ccos2)
        elseif(ip.eq.1.and.kdcy(1).eq.3) then
c...angular weight for f + f~ -> w'+/- -> w+/- + h0.
          rm1=p(nsd(1)+1,5)**2/sh
          rm2=p(nsd(1)+2,5)**2/sh
          flam2=max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2)
          wt=1.+flam2*(1.-cthe(1)**2)/(8.*rm1)
          wtmax=1.+flam2/(8.*rm1)
        elseif(mzpwp.eq.0) then
c...angular weight for f + f~' -> w' -> w + z0 -> 4 quarks/leptons
c...(w/z like if intermediate w).
          d34=p(iref(ip,iord),5)**2
          d56=p(iref(ip,3-iord),5)**2
          dt=pkk(1,3)+pkk(1,4)+d34
          du=pkk(1,5)+pkk(1,6)+d56
          fgk135=abs(fgk(1,2,3,4,5,6)-fgk(1,2,5,6,3,4))
          fgk136=abs(fgk(1,2,3,4,6,5)-fgk(1,2,6,5,3,4))
          wt=(coup(5,3)*fgk135)**2+(coup(5,4)*fgk136)**2
          wtmax=4.*d34*d56*(coup(5,3)**2+coup(5,4)**2)*
     &    (digk(dt,du)+digk(du,dt)-djgk(dt,du))
        elseif(mzpwp.eq.1) then
c...angular weight for f + f~' -> w' -> w + z0 -> 4 quarks/leptons
c...(w/z approximately longitudinal, like if intermediate h).
          wt=16.*pkk(3,5)*pkk(4,6)
          wtmax=sh**2
        else
c...angular weight for f + f~ -> w' -> w + h0 -> whatever.
          wt=1.
          wtmax=1.
        endif

      elseif(isub.eq.145.or.isub.eq.162.or.isub.eq.163.or.isub.eq.164)
     &then
c...isotropic decay of leptoquarks (assumed spin 0).
        wt=1.
        wtmax=1.

c...obtain correct angular distribution by rejection techniques.
      else
        wt=1.
        wtmax=1.
      endif
      if(wt.lt.rlu(0)*wtmax) goto 190

c...construct massive four-vectors using angles chosen. mark decayed
c...resonances, add documentation lines. shower evolution.
  290 do 340 jt=1,jtmax
      if(kdcy(jt).eq.0) goto 340
      id=iref(ip,jt)
      if(iset(isub).ne.6) then
        call ludbrb(nsd(jt)+1,nsd(jt)+2,acos(cthe(jt)),phi(jt),
     &  p(id,1)/p(id,4),p(id,2)/p(id,4),
     &  p(id,3)/p(id,4))
      else
c...z + q + q~ : angles already known, in rest frame of system.
        do 300 j=1,3
  300   dbezqq(j)=(p(id,j)+p(id+1,j)+p(id+2,j))/(p(id,4)+p(id+1,4)+
     &  p(id+2,4))
        k(n+1,1)=1
        do 310 j=1,5
  310   p(n+1,j)=p(id,j)
        call ludbrb(n+1,n+1,0.,0.,-dbezqq(1),-dbezqq(2),-dbezqq(3))
        phizqq=ulangl(p(n+1,1),p(n+1,2))
        thezqq=ulangl(p(n+1,3),sqrt(p(n+1,1)**2+p(n+1,2)**2))
        call ludbrb(nsd(jt)+1,nsd(jt)+2,acos(vint(81)),vint(82),
     &  0d0,0d0,sqrt(p(n+1,1)**2+p(n+1,2)**2+p(n+1,3)**2)/
     &  p(n+1,4))
        call ludbrb(nsd(jt)+1,nsd(jt)+2,thezqq,phizqq,dbezqq(1),
     &  dbezqq(2),dbezqq(3))
      endif
      k(id,1)=k(id,1)+10
c...do not kill colour flow through leptoquark!
      if(iabs(k(id,2)).ne.39) then
        k(id,4)=nsd(jt)+1
        k(id,5)=nsd(jt)+2
      endif
      idoc=mint(83)+mint(4)
      do 330 i=nsd(jt)+1,nsd(jt)+2
      i1=mint(83)+mint(4)+1
      k(i,3)=i1
      if(mstp(128).ge.1) k(i,3)=id
      if(mstp(128).le.1) then
        mint(4)=mint(4)+1
        k(i1,1)=21
        k(i1,2)=k(i,2)
        k(i1,3)=iref(ip,jt+2)
        do 320 j=1,5
  320   p(i1,j)=p(i,j)
      endif
  330 continue
      if(mstp(71).ge.1.and.kdcy(jt).eq.1) call lushow(nsd(jt)+1,
     &nsd(jt)+2,p(id,5))

c...check if new resonances were produced.
      if(kdcy(jt).ne.3) goto 340
      np=np+1
      iref(np,1)=nsd(jt)+1
      iref(np,2)=nsd(jt)+2
      iref(np,3)=idoc+1
      iref(np,4)=idoc+2
      iref(np,5)=k(iref(ip,jt),2)
      iref(np,6)=iref(ip,jt)
  340 continue

c...fill information for 2 -> 1 -> 2. loop back if needed.
      if(jtmax.eq.1.and.kdcy(1).ne.0) then
        mint(7)=mint(83)+6+2*iset(isub)
        mint(8)=mint(83)+7+2*iset(isub)
        mint(25)=kfl1(1)
        mint(26)=kfl2(1)
        vint(23)=cthe(1)
        rm3=p(n-1,5)**2/sh
        rm4=p(n,5)**2/sh
        be34=sqrt(max(0.d0,(1.-rm3-rm4)**2-4.*rm3*rm4))
        vint(45)=-0.5*sh*(1.-rm3-rm4-be34*cthe(1))
        vint(46)=-0.5*sh*(1.-rm3-rm4+be34*cthe(1))
        vint(48)=0.25*sh*be34**2*max(0.d0,1.-cthe(1)**2)
        vint(47)=sqrt(vint(48))
      endif
  350 if(ip.lt.np) goto 100

      return
      end

c*********************************************************************

      subroutine pymult(mmul)
      implicit double precision (a-h,o-z)

c...initializes treatment of multiple interactions, selects kinematics
c...of hardest interaction if low-pt physics included in run, and
c...generates all non-hardest interactions.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /lujets/,/ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint5/
      dimension nmul(20),sigm(20),kstr(500,2),vintsv(80)
      save xt2,xt2fac,xc2,xts,irbin,rbin,nmul,sigm

c...initialization of multiple interaction treatment.
      if(mmul.eq.1) then
        if(mstp(122).ge.1) write(mstu(11),5000) mstp(82)
        isub=96
        mint(1)=96
        vint(63)=0.
        vint(64)=0.
        vint(143)=1.
        vint(144)=1.

c...loop over phase space points: xt2 choice in 20 bins.
  100   sigsum=0.
        do 120 ixt2=1,20
        nmul(ixt2)=mstp(83)
        sigm(ixt2)=0.
        do 110 itry=1,mstp(83)
        rsca=0.05*((21-ixt2)-rlu(0))
        xt2=vint(149)*(1.+vint(149))/(vint(149)+rsca)-vint(149)
        xt2=max(0.01*vint(149),xt2)
        vint(25)=xt2

c...choose tau and y*. calculate cos(theta-hat).
        if(rlu(0).le.coef(isub,1)) then
          taut=(2.*(1.+sqrt(1.-xt2))/xt2-1.)**rlu(0)
          tau=xt2*(1.+taut)**2/(4.*taut)
        else
          tau=xt2*(1.+tan(rlu(0)*atan(sqrt(1./xt2-1.)))**2)
        endif
        vint(21)=tau
        call pyklim(2)
        ryst=rlu(0)
        myst=1
        if(ryst.gt.coef(isub,8)) myst=2
        if(ryst.gt.coef(isub,8)+coef(isub,9)) myst=3
        call pykmap(2,myst,rlu(0))
        vint(23)=sqrt(max(0.d0,1.-xt2/tau))*(-1)**int(1.5+rlu(0))

c...calculate differential cross-section.
        vint(71)=0.5*vint(1)*sqrt(xt2)
        call pysigh(nchn,sigs)
  110   sigm(ixt2)=sigm(ixt2)+sigs
  120   sigsum=sigsum+sigm(ixt2)
        sigsum=sigsum/(20.*mstp(83))

c...reject result if sigma(parton-parton) is smaller than hadronic one.
        if(sigsum.lt.1.1*vint(106)) then
          if(mstp(122).ge.1) write(mstu(11),5100) parp(82),sigsum
          parp(82)=0.9*parp(82)
          vint(149)=4.*parp(82)**2/vint(2)
          goto 100
        endif
        if(mstp(122).ge.1) write(mstu(11),5200) parp(82), sigsum

c...start iteration to find k factor.
        yke=sigsum/vint(106)
        so=0.5
        xi=0.
        yi=0.
        xk=0.5
        iit=0
  130   if(iit.eq.0) then
          xk=2.*xk
        elseif(iit.eq.1) then
          xk=0.5*xk
        else
          xk=xi+(yke-yi)*(xf-xi)/(yf-yi)
        endif

c...evaluate overlap integrals.
        if(mstp(82).eq.2) then
          sp=0.5*paru(1)*(1.-exp(-xk))
          sop=sp/paru(1)
        else
          if(mstp(82).eq.3) deltab=0.02
          if(mstp(82).eq.4) deltab=min(0.01d0,0.05*parp(84))
          sp=0.
          sop=0.
          b=-0.5*deltab
  140     b=b+deltab
          if(mstp(82).eq.3) then
            ov=exp(-b**2)/paru(2)
          else
            cq2=parp(84)**2
            ov=((1.-parp(83))**2*exp(-min(87.d0,b**2))+2.*parp(83)*
     &     (1.-parp(83))*2./(1.+cq2)*exp(-min(87.d0,b**2*2./(1.+cq2)))+
     &      parp(83)**2/cq2*exp(-min(87.d0,b**2/cq2)))/paru(2)
          endif
          pacc=1.-exp(-min(87.d0,paru(1)*xk*ov))
          sp=sp+paru(2)*b*deltab*pacc
          sop=sop+paru(2)*b*deltab*ov*pacc
          if(b.lt.1..or.b*pacc.gt.1e-6) goto 140
        endif
        yk=paru(1)*xk*so/sp

c...continue iteration until convergence.
        if(yk.lt.yke) then
          xi=xk
          yi=yk
          if(iit.eq.1) iit=2
        else
          xf=xk
          yf=yk
          if(iit.eq.0) iit=1
        endif
        if(abs(yk-yke).ge.1e-5*yke) goto 130

c...store some results for subsequent use.
        vint(145)=sigsum
        vint(146)=sop/so
        vint(147)=sop/sp

c...initialize iteration in xt2 for hardest interaction.
      elseif(mmul.eq.2) then
        if(mstp(82).le.0) then
        elseif(mstp(82).eq.1) then
          xt2=1.
          xt2fac=xsec(96,1)/vint(106)*vint(149)/(1.-vint(149))
        elseif(mstp(82).eq.2) then
          xt2=1.
          xt2fac=vint(146)*xsec(96,1)/vint(106)*vint(149)*(1.+vint(149))
        else
          xc2=4.*ckin(3)**2/vint(2)
          if(ckin(3).le.ckin(5).or.mint(82).ge.2) xc2=0.
        endif

      elseif(mmul.eq.3) then
c...low-pt or multiple interactions (first semihard interaction):
c...choose xt2 according to dpt2/pt2**2*exp(-(sigma above pt2)/norm)
c...or (mstp(82)>=2) dpt2/(pt2+pt0**2)**2*exp(-....).
        isub=mint(1)
        if(mstp(82).le.0) then
          xt2=0.
        elseif(mstp(82).eq.1) then
          xt2=xt2fac*xt2/(xt2fac-xt2*log(rlu(0)))
        elseif(mstp(82).eq.2) then
          if(xt2.lt.1..and.exp(-xt2fac*xt2/(vint(149)*(xt2+
     &    vint(149)))).gt.rlu(0)) xt2=1.
          if(xt2.ge.1.) then
            xt2=(1.+vint(149))*xt2fac/(xt2fac-(1.+vint(149))*log(1.-
     &      rlu(0)*(1.-exp(-xt2fac/(vint(149)*(1.+vint(149)))))))-
     &      vint(149)
          else
            xt2=-xt2fac/log(exp(-xt2fac/(xt2+vint(149)))+rlu(0)*
     &      (exp(-xt2fac/vint(149))-exp(-xt2fac/(xt2+vint(149)))))-
     &      vint(149)
          endif
          xt2=max(0.01*vint(149),xt2)
        else
          xt2=(xc2+vint(149))*(1.+vint(149))/(1.+vint(149)-
     &    rlu(0)*(1.-xc2))-vint(149)
          xt2=max(0.01*vint(149),xt2)
        endif
        vint(25)=xt2

c...low-pt: choose xt2, tau, y* and cos(theta-hat) fixed.
        if(mstp(82).le.1.and.xt2.lt.vint(149)) then
          if(mint(82).eq.1) ngen(0,1)=ngen(0,1)-1
          if(mint(82).eq.1) ngen(isub,1)=ngen(isub,1)-1
          isub=95
          mint(1)=isub
          vint(21)=0.01*vint(149)
          vint(22)=0.
          vint(23)=0.
          vint(25)=0.01*vint(149)

        else
c...multiple interactions (first semihard interaction).
c...choose tau and y*. calculate cos(theta-hat).
          if(rlu(0).le.coef(isub,1)) then
            taut=(2.*(1.+sqrt(1.-xt2))/xt2-1.)**rlu(0)
            tau=xt2*(1.+taut)**2/(4.*taut)
          else
            tau=xt2*(1.+tan(rlu(0)*atan(sqrt(1./xt2-1.)))**2)
          endif
          vint(21)=tau
          call pyklim(2)
          ryst=rlu(0)
          myst=1
          if(ryst.gt.coef(isub,8)) myst=2
          if(ryst.gt.coef(isub,8)+coef(isub,9)) myst=3
          call pykmap(2,myst,rlu(0))
          vint(23)=sqrt(max(0.d0,1.-xt2/tau))*(-1)**int(1.5+rlu(0))
        endif
        vint(71)=0.5*vint(1)*sqrt(vint(25))

c...store results of cross-section calculation.
      elseif(mmul.eq.4) then
        isub=mint(1)
        xts=vint(25)
        if(iset(isub).eq.1) xts=vint(21)
        if(iset(isub).eq.2.or.iset(isub).eq.6)
     &  xts=(4.*vint(48)+2.*vint(63)+2.*vint(64))/vint(2)
        if(iset(isub).ge.3.and.iset(isub).le.5) xts=vint(26)
        rbin=max(0.000001d0,min(0.999999d0,xts*(1.+vint(149))/
     &  (xts+vint(149))))
        irbin=int(1.+20.*rbin)
        if(isub.eq.96) nmul(irbin)=nmul(irbin)+1
        if(isub.eq.96) sigm(irbin)=sigm(irbin)+vint(153)

c...choose impact parameter.
      elseif(mmul.eq.5) then
        if(mstp(82).eq.3) then
          vint(148)=rlu(0)/(paru(2)*vint(147))
        else
          rtype=rlu(0)
          cq2=parp(84)**2
          if(rtype.lt.(1.-parp(83))**2) then
            b2=-log(rlu(0))
          elseif(rtype.lt.1.-parp(83)**2) then
            b2=-0.5*(1.+cq2)*log(rlu(0))
          else
            b2=-cq2*log(rlu(0))
          endif
          vint(148)=
     &   ((1.-parp(83))**2*exp(-min(87.d0,b2))+2.*parp(83)*
     &    (1.-parp(83))*2./(1.+cq2)*exp(-min(87.d0,b2*2./(1.+cq2)))+
     &    parp(83)**2/cq2*exp(-min(87.d0,b2/cq2)))/(paru(2)*vint(147))
        endif

c...multiple interactions (variable impact parameter) : reject with
c...probability exp(-overlap*cross-section above pt/normalization).
        rncor=(irbin-20.*rbin)*nmul(irbin)
        sigcor=(irbin-20.*rbin)*sigm(irbin)
        do 150 ibin=irbin+1,20
        rncor=rncor+nmul(ibin)
  150   sigcor=sigcor+sigm(ibin)
        sigabv=(sigcor/rncor)*vint(149)*(1.-xts)/(xts+vint(149))
        vint(150)=
     &  exp(-min(87.d0,vint(146)*vint(148)*sigabv/vint(106)))

c...generate additional multiple semihard interactions.
      elseif(mmul.eq.6) then
        isubsv=mint(1)
        do 160 j=11,80
  160   vintsv(j)=vint(j)
        isub=96
        mint(1)=96

c...reconstruct strings in hard scattering.
        nmax=mint(84)+4
        if(iset(isubsv).eq.1) nmax=mint(84)+2
        nstr=0
        do 180 i=mint(84)+1,nmax
        kcs=kchg(lucomp(k(i,2)),2)*isign(1,k(i,2))
        if(kcs.eq.0) goto 180
        do 170 j=1,4
        if(kcs.eq.1.and.(j.eq.2.or.j.eq.4)) goto 170
        if(kcs.eq.-1.and.(j.eq.1.or.j.eq.3)) goto 170
        if(j.le.2) then
          ist=mod(k(i,j+3)/mstu(5),mstu(5))
        else
          ist=mod(k(i,j+1),mstu(5))
        endif
        if(ist.lt.mint(84).or.ist.gt.i) goto 170
        if(kchg(lucomp(k(ist,2)),2).eq.0) goto 170
        nstr=nstr+1
        if(j.eq.1.or.j.eq.4) then
          kstr(nstr,1)=i
          kstr(nstr,2)=ist
        else
          kstr(nstr,1)=ist
          kstr(nstr,2)=i
        endif
  170   continue
  180   continue

c...set up starting values for iteration in xt2.
        xt2=vint(25)
        if(iset(isubsv).eq.1) xt2=vint(21)
        if(iset(isubsv).eq.2) xt2=(4.*vint(48)+2.*vint(63)+2.*vint(64))/
     &  vint(2)
        if(iset(isubsv).eq.3.or.iset(isubsv).eq.4) xt2=vint(26)
        if(mstp(82).le.1) then
          xt2fac=xsec(isub,1)*vint(149)/((1.-vint(149))*vint(106))
        else
          xt2fac=vint(146)*vint(148)*xsec(isub,1)/vint(106)*
     &    vint(149)*(1.+vint(149))
        endif
        vint(63)=0.
        vint(64)=0.
        vint(143)=1.-vint(141)
        vint(144)=1.-vint(142)

c...iterate downwards in xt2.
  190   if(mstp(82).le.1) then
          xt2=xt2fac*xt2/(xt2fac-xt2*log(rlu(0)))
          if(xt2.lt.vint(149)) goto 230
        else
          if(xt2.le.0.01*vint(149)) goto 230
          xt2=xt2fac*(xt2+vint(149))/(xt2fac-(xt2+vint(149))*
     &    log(rlu(0)))-vint(149)
          if(xt2.le.0.) goto 230
          xt2=max(0.01*vint(149),xt2)
        endif
        vint(25)=xt2

c...choose tau and y*. calculate cos(theta-hat).
        if(rlu(0).le.coef(isub,1)) then
          taut=(2.*(1.+sqrt(1.-xt2))/xt2-1.)**rlu(0)
          tau=xt2*(1.+taut)**2/(4.*taut)
        else
          tau=xt2*(1.+tan(rlu(0)*atan(sqrt(1./xt2-1.)))**2)
        endif
        vint(21)=tau
        call pyklim(2)
        ryst=rlu(0)
        myst=1
        if(ryst.gt.coef(isub,8)) myst=2
        if(ryst.gt.coef(isub,8)+coef(isub,9)) myst=3
        call pykmap(2,myst,rlu(0))
        vint(23)=sqrt(max(0.d0,1.-xt2/tau))*(-1)**int(1.5+rlu(0))

c...check that x not used up. accept or reject kinematical variables.
        x1m=sqrt(tau)*exp(vint(22))
        x2m=sqrt(tau)*exp(-vint(22))
        if(vint(143)-x1m.lt.0.01.or.vint(144)-x2m.lt.0.01) goto 190
        vint(71)=0.5*vint(1)*sqrt(xt2)
        call pysigh(nchn,sigs)
        if(sigs.lt.xsec(isub,1)*rlu(0)) goto 190

c...reset k, p and v vectors. select some variables.
        do 200 i=n+1,n+2
        do 200 j=1,5
        k(i,j)=0
        p(i,j)=0.
  200   v(i,j)=0.
        rflav=rlu(0)
        pt=0.5*vint(1)*sqrt(xt2)
        phi=paru(2)*rlu(0)
        cth=vint(23)

c...add first parton to event record.
        k(n+1,1)=3
        k(n+1,2)=21
        if(rflav.ge.max(parp(85),parp(86))) k(n+1,2)=
     &  1+int((2.+parj(2))*rlu(0))
        p(n+1,1)=pt*cos(phi)
        p(n+1,2)=pt*sin(phi)
        p(n+1,3)=0.25*vint(1)*(vint(41)*(1.+cth)-vint(42)*(1.-cth))
        p(n+1,4)=0.25*vint(1)*(vint(41)*(1.+cth)+vint(42)*(1.-cth))
        p(n+1,5)=0.

c...add second parton to event record.
        k(n+2,1)=3
        k(n+2,2)=21
        if(k(n+1,2).ne.21) k(n+2,2)=-k(n+1,2)
        p(n+2,1)=-p(n+1,1)
        p(n+2,2)=-p(n+1,2)
        p(n+2,3)=0.25*vint(1)*(vint(41)*(1.-cth)-vint(42)*(1.+cth))
        p(n+2,4)=0.25*vint(1)*(vint(41)*(1.-cth)+vint(42)*(1.+cth))
        p(n+2,5)=0.

        if(rflav.lt.parp(85).and.nstr.ge.1) then
c....choose relevant string pieces to place gluons on.
          do 220 i=n+1,n+2
          dmin=1e8
          do 210 istr=1,nstr
          i1=kstr(istr,1)
          i2=kstr(istr,2)
          dist=(p(i,4)*p(i1,4)-p(i,1)*p(i1,1)-p(i,2)*p(i1,2)-
     &    p(i,3)*p(i1,3))*(p(i,4)*p(i2,4)-p(i,1)*p(i2,1)-
     &    p(i,2)*p(i2,2)-p(i,3)*p(i2,3))/
     &    max(1.d0,p(i1,4)*p(i2,4)-
     &    p(i1,1)*p(i2,1)-p(i1,2)*p(i2,2)-p(i1,3)*p(i2,3))
          if(istr.eq.1.or.dist.lt.dmin) then
            dmin=dist
            ist1=i1
            ist2=i2
            istm=istr
          endif
  210     continue

c....colour flow adjustments, new string pieces.
          if(k(ist1,4)/mstu(5).eq.ist2) k(ist1,4)=mstu(5)*i+
     &    mod(k(ist1,4),mstu(5))
          if(mod(k(ist1,5),mstu(5)).eq.ist2) k(ist1,5)=
     &    mstu(5)*(k(ist1,5)/mstu(5))+i
          k(i,5)=mstu(5)*ist1
          k(i,4)=mstu(5)*ist2
          if(k(ist2,5)/mstu(5).eq.ist1) k(ist2,5)=mstu(5)*i+
     &    mod(k(ist2,5),mstu(5))
          if(mod(k(ist2,4),mstu(5)).eq.ist1) k(ist2,4)=
     &    mstu(5)*(k(ist2,4)/mstu(5))+i
          kstr(istm,2)=i
          kstr(nstr+1,1)=i
          kstr(nstr+1,2)=ist2
  220     nstr=nstr+1

c...string drawing and colour flow for gluon loop.
        elseif(k(n+1,2).eq.21) then
          k(n+1,4)=mstu(5)*(n+2)
          k(n+1,5)=mstu(5)*(n+2)
          k(n+2,4)=mstu(5)*(n+1)
          k(n+2,5)=mstu(5)*(n+1)
          kstr(nstr+1,1)=n+1
          kstr(nstr+1,2)=n+2
          kstr(nstr+2,1)=n+2
          kstr(nstr+2,2)=n+1
          nstr=nstr+2

c...string drawing and colour flow for qq~ pair.
        else
          k(n+1,4)=mstu(5)*(n+2)
          k(n+2,5)=mstu(5)*(n+1)
          kstr(nstr+1,1)=n+1
          kstr(nstr+1,2)=n+2
          nstr=nstr+1
        endif

c...update remaining energy; iterate.
        n=n+2
        if(n.gt.mstu(4)-mstu(32)-10) then
          call luerrm(11,'(pymult:) no more memory left in lujets')
          if(mstu(21).ge.1) return
        endif
        mint(31)=mint(31)+1
        vint(151)=vint(151)+vint(41)
        vint(152)=vint(152)+vint(42)
        vint(143)=vint(143)-vint(41)
        vint(144)=vint(144)-vint(42)
        if(mint(31).lt.240) goto 190
  230   continue
        mint(1)=isubsv
        do 240 j=11,80
  240   vint(j)=vintsv(j)
      endif

c...format statements for printout.
 5000 format(/1x,'****** pymult: initialization of multiple inter',
     &'actions for mstp(82) =',i2,' ******')
 5100 format(8x,'pt0 =',f5.2,' gev gives sigma(parton-parton) =',1p,
     &e9.2,' mb: rejected')
 5200 format(8x,'pt0 =',f5.2,' gev gives sigma(parton-parton) =',1p,
     &e9.2,' mb: accepted')

      return
      end

c*********************************************************************

      subroutine pyremn(ipu1,ipu2)
      implicit double precision (a-h,o-z)

c...adds on target remnants (one or two from each side) and
c...includes primordial kt for hadron beams.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /lujets/,/ludat1/,/ludat2/
      save /pypars/,/pyint1/
      dimension kflch(2),kflsp(2),chi(2),pms(0:6),is(2),isn(2),robo(5),
     &psys(0:2,5),pmin(0:2)

c...find event type and remaining energy.
      isub=mint(1)
      ns=n
      if(mint(44).ne.4.or.mstp(81).le.0) then
        vint(143)=1.-vint(141)
        vint(144)=1.-vint(142)
      endif

c...define initial partons.
  100 do 130 jt=1,2
      i=mint(83)+jt+2
      if(jt.eq.1) ipu=ipu1
      if(jt.eq.2) ipu=ipu2
      k(i,1)=21
      k(i,2)=k(ipu,2)
      k(i,3)=i-2
      pms(jt)=0.
      if(mint(47).eq.1) then
        do 110 j=1,5
  110   p(i,j)=p(i-2,j)
      elseif(isub.eq.95) then
        k(i,2)=21
      else
        p(i,5)=p(ipu,5)

c...no primordial kt, or chosen according to truncated gaussian or
c...exponential.
  120   if(mint(40+jt).eq.1.or.mstp(91).le.0) then
          pt=0.
        elseif(mstp(91).eq.1) then
          pt=parp(91)*sqrt(-log(rlu(0)))
        else
          rpt1=rlu(0)
          rpt2=rlu(0)
          pt=-parp(92)*log(rpt1*rpt2)
        endif
        if(pt.gt.parp(93)) goto 120
        phi=paru(2)*rlu(0)
        p(i,1)=pt*cos(phi)
        p(i,2)=pt*sin(phi)
        pms(jt)=p(i,5)**2+p(i,1)**2+p(i,2)**2
      endif
  130 continue
      if(mint(47).eq.1) return

c...kinematics construction for initial partons.
      i1=mint(83)+3
      i2=mint(83)+4
      if(isub.eq.95) then
        shs=0.
        shr=0.
      else
        shs=vint(141)*vint(142)*vint(2)+(p(i1,1)+p(i2,1))**2+
     &  (p(i1,2)+p(i2,2))**2
        shr=sqrt(max(0.d0,shs))
        if((shs-pms(1)-pms(2))**2-4.*pms(1)*pms(2).le.0.) goto 100
        p(i1,4)=0.5*(shr+(pms(1)-pms(2))/shr)
        p(i1,3)=sqrt(max(0.d0,p(i1,4)**2-pms(1)))
        p(i2,4)=shr-p(i1,4)
        p(i2,3)=-p(i1,3)

c...transform partons to overall cm-frame.
        robo(3)=(p(i1,1)+p(i2,1))/shr
        robo(4)=(p(i1,2)+p(i2,2))/shr
        call
     &  ludbrb(i1,i2,0.d0,0.d0,-robo(3),-robo(4),0d0)
        robo(2)=ulangl(p(i1,1),p(i1,2))
        call ludbrb(i1,i2,0.d0,-robo(2),0d0,0d0,0d0)
        robo(1)=ulangl(p(i1,3),p(i1,1))
        call ludbrb(i1,i2,-robo(1),0.d0,0d0,0d0,0d0)
        call ludbrb(i1,mint(52),robo(1),robo(2),(robo(3)),
     &  (robo(4)),0d0)
        robo(5)=
     &  max(-0.999999d0,min(0.999999d0,(vint(141)-vint(142))/
     &  (vint(141)+vint(142))))
        call ludbrb(i1,mint(52),0.d0,0.d0,0d0,0d0,(robo(5)))
      endif

c...check minimum invariant mass of remnant system(s).
      psys(0,4)=p(i1,4)+p(i2,4)+0.5*vint(1)*(vint(151)+vint(152))
      psys(0,3)=p(i1,3)+p(i2,3)+0.5*vint(1)*(vint(151)-vint(152))
      pms(0)=max(0.d0,psys(0,4)**2-psys(0,3)**2)
      pmin(0)=sqrt(pms(0))
      do 140 jt=1,2
      psys(jt,4)=0.5*vint(1)*vint(142+jt)
      pmin(jt)=0.
      if(mint(40+jt).eq.1.and.mstp(11).eq.0) goto 140
      call pyspli(mint(10+jt),mint(12+jt),kflch(jt),kflsp(jt))
      if(kflch(jt).ne.0) pmin(jt)=pmin(jt)+ulmass(kflch(jt))
      if(kflsp(jt).ne.0) pmin(jt)=pmin(jt)+ulmass(kflsp(jt))
      if(kflch(jt)*kflsp(jt).ne.0) pmin(jt)=pmin(jt)+0.5*parp(111)
      pmin(jt)=sqrt(pmin(jt)**2+p(mint(83)+jt+2,1)**2+
     &p(mint(83)+jt+2,2)**2)
  140 continue
      if(pmin(0)+pmin(1)+pmin(2).gt.vint(1).or.pmin(1).gt.psys(1,4).or.
     &pmin(2).gt.psys(2,4)) then
        mint(51)=1
        return
      endif

c...loop over two remnants; skip if none there.
      i=ns
      do 210 jt=1,2
      isn(jt)=0
      if(mint(40+jt).eq.1.and.mstp(11).eq.0) goto 210
      if(jt.eq.1) ipu=ipu1
      if(jt.eq.2) ipu=ipu2

c...store first remnant parton.
      i=i+1
      is(jt)=i
      isn(jt)=1
      do 150 j=1,5
      k(i,j)=0
      p(i,j)=0.
  150 v(i,j)=0.
      k(i,1)=1
      k(i,2)=kflsp(jt)
      k(i,3)=mint(83)+jt
      p(i,5)=ulmass(k(i,2))

c...first parton colour connections and kinematics.
      kcol=kchg(lucomp(kflsp(jt)),2)
      if(kcol.ne.0) then
        k(i,1)=3
        kfls=(3-kcol*isign(1,kflsp(jt)))/2
        k(i,kfls+3)=ipu
        k(ipu,6-kfls)=mod(k(ipu,6-kfls),mstu(5))+mstu(5)*i
      endif
      if(kflch(jt).eq.0) then
        p(i,1)=-p(mint(83)+jt+2,1)
        p(i,2)=-p(mint(83)+jt+2,2)
        pms(jt)=p(i,5)**2+p(i,1)**2+p(i,2)**2
        psys(jt,3)=sqrt(max(0.d0,psys(jt,4)**2-pms(jt)))*(-1)**(jt-1)
        p(i,3)=psys(jt,3)
        p(i,4)=psys(jt,4)

c...when extra remnant parton or hadron: store extra remnant.
      else
        i=i+1
        isn(jt)=2
        do 160 j=1,5
        k(i,j)=0
        p(i,j)=0.
  160   v(i,j)=0.
        k(i,1)=1
        k(i,2)=kflch(jt)
        k(i,3)=mint(83)+jt
        p(i,5)=ulmass(k(i,2))

c...find parton colour connections of extra remnant.
        kcol=kchg(lucomp(kflch(jt)),2)
        if(kcol.eq.2) then
          k(i,1)=3
          k(i,4)=mstu(5)*ipu+ipu
          k(i,5)=mstu(5)*ipu+ipu
          k(ipu,4)=mod(k(ipu,4),mstu(5))+mstu(5)*i
          k(ipu,5)=mod(k(ipu,5),mstu(5))+mstu(5)*i
        elseif(kcol.ne.0) then
          k(i,1)=3
          kfls=(3-kcol*isign(1,kflch(jt)))/2
          k(i,kfls+3)=ipu
          k(ipu,6-kfls)=mod(k(ipu,6-kfls),mstu(5))+mstu(5)*i
        endif

c...relative transverse momentum when two remnants.
  170   call luptdi(1,p(i-1,1),p(i-1,2))
        if(iabs(mint(10+jt)).lt.20) then
          p(i-1,1)=0.
          p(i-1,2)=0.
        endif
        pms(jt+2)=p(i-1,5)**2+p(i-1,1)**2+p(i-1,2)**2
        p(i,1)=-p(mint(83)+jt+2,1)-p(i-1,1)
        p(i,2)=-p(mint(83)+jt+2,2)-p(i-1,2)
        pms(jt+4)=p(i,5)**2+p(i,1)**2+p(i,2)**2

c...relative distribution of electron energy into electron plus parton.
        imb=1
        if(mod(mint(10+jt)/1000,10).ne.0) imb=2
        if(iabs(mint(10+jt)).lt.20) then
          xhrd=vint(140+jt)
          t= log(min(1d4,max(1.d0,vint(52)))/0.16)
          nfe=1
          if(vint(52).gt.25.) nfe=2
          if(vint(52).gt.300.) nfe=3
          call pystga(nfe,xhrd,t,xpgl1,xpqu1,xpqd1)
          call pystga(nfe,0.999999d0,t,xpgl2,xpqu2,xpqd2)
          if(kflch(jt).eq.21) then
            wtmx=2.*max(xpgl1,xpgl2)
          elseif(mod(iabs(kflch(jt)),2).eq.0) then
            wtmx=2.*max(xpqu1,xpqu2)
          else
            wtmx=2.*max(xpqd1,xpqd2)
          endif
  180     xe=xhrd**rlu(0)
          xg=min(0.999999d0,xhrd/xe)
          xpga=1.+(1.-xe)**2
          call pystga(nfe,xg,t,xpgl,xpqu,xpqd)
          if(kflch(jt).eq.21) then
            wt=xpga*xpgl
          elseif(mod(iabs(kflch(jt)),2).eq.0) then
            wt=xpga*xpqu
          else
            wt=xpga*xpqd
          endif
          if(wt.lt.rlu(0)*wtmx) goto 180
          chi(jt)=(xe-xhrd)/(1.-xhrd)

c...relative distribution of energy for particle into two jets.
        elseif(iabs(kflch(jt)).le.10.or.kflch(jt).eq.21) then
          chik=parp(92+2*imb)
          if(mstp(92).le.1) then
            if(imb.eq.1) chi(jt)=rlu(0)
            if(imb.eq.2) chi(jt)=1.-sqrt(rlu(0))
          elseif(mstp(92).eq.2) then
            chi(jt)=1.-rlu(0)**(1./(1.+chik))
          elseif(mstp(92).eq.3) then
            cut=2.*0.3/vint(1)
  190       chi(jt)=rlu(0)**2
            if((chi(jt)**2/(chi(jt)**2+cut**2))**0.25*(1.-chi(jt))**chik
     &      .lt.rlu(0)) goto 190
          else
            cut=2.*0.3/vint(1)
            cutr=(1.+sqrt(1.+cut**2))/cut
  200       chir=cut*cutr**rlu(0)
            chi(jt)=(chir**2-cut**2)/(2.*chir)
            if((1.-chi(jt))**chik.lt.rlu(0)) goto 200
          endif

c...relative distribution of energy for particle into jet plus particle.
        else
          if(mstp(92).le.1) then
            if(imb.eq.1) chi(jt)=rlu(0)
            if(imb.eq.2) chi(jt)=1.-sqrt(rlu(0))
          else
            chi(jt)=1.-rlu(0)**(1./(1.+parp(93+2*imb)))
          endif
          if(mod(kflch(jt)/1000,10).ne.0) chi(jt)=1.-chi(jt)
        endif

c...construct total transverse mass; reject if too large.
        pms(jt)=pms(jt+4)/chi(jt)+pms(jt+2)/(1.-chi(jt))
        if(pms(jt).gt.psys(jt,4)**2) goto 170
        psys(jt,3)=sqrt(psys(jt,4)**2-pms(jt))*(-1)**(jt-1)

c...subdivide longitudinal momentum according to value selected above.
        pw1=chi(jt)*(psys(jt,4)+abs(psys(jt,3)))
        p(is(jt)+1,4)=0.5*(pw1+pms(jt+4)/pw1)
        p(is(jt)+1,3)=0.5*(pw1-pms(jt+4)/pw1)*(-1)**(jt-1)
        p(is(jt),4)=psys(jt,4)-p(is(jt)+1,4)
        p(is(jt),3)=psys(jt,3)-p(is(jt)+1,3)
      endif
  210 continue
      n=i

c...check if longitudinal boosts needed - if so pick two systems.
      pdev=abs(psys(0,4)+psys(1,4)+psys(2,4)-vint(1))+
     &abs(psys(0,3)+psys(1,3)+psys(2,3))
      if(pdev.le.1e-6*vint(1)) return
      if(vint(143).gt.0.2.and.vint(144).gt.0.2) then
        ir=1
        il=2
      elseif(vint(143).gt.0.2) then
        ir=1
        il=0
      elseif(vint(144).gt.0.2) then
        ir=0
        il=2
      elseif(pms(1)/psys(1,4)**2.gt.pms(2)/psys(2,4)**2) then
        ir=1
        il=0
      else
        ir=0
        il=2
      endif
      ig=3-ir-il

c...construct longitudinal boosts.
      if((ig.eq.1.and.isn(1).eq.0).or.(ig.eq.2.and.isn(2).eq.0)) then
        ppb=vint(1)
        pnb=vint(1)
      else
        ppb=vint(1)-psys(ig,4)-psys(ig,3)
        pnb=vint(1)-psys(ig,4)+psys(ig,3)
      endif
      pmtb=ppb*pnb
      pmtr=pms(ir)
      pmtl=pms(il)
      sqlam=sqrt(max(0.d0,(pmtb-pmtr-pmtl)**2-4.*pmtr*pmtl))
      sqsgn=sign(1.d0, psys(ir,3)*psys(il,4)-psys(il,3)*psys(ir,4))
      rkr=(pmtb+pmtr-pmtl+sqlam*sqsgn)/(2.*(psys(ir,4)+psys(ir,3))*pnb)
      rkl=(pmtb+pmtl-pmtr+sqlam*sqsgn)/(2.*(psys(il,4)-psys(il,3))*ppb)
      ber=(rkr**2-1.)/(rkr**2+1.)
      bel=-(rkl**2-1.)/(rkl**2+1.)

c...perform longitudinal boosts.
      if(ir.eq.1) then
        call 
     &  ludbrb(is(1),is(1)+isn(1)-1,0.d0,0.d0,0d0,0d0,(ber))
      else
        call ludbrb(i1,ns,0.d0,0.d0,0d0,0d0,(ber))
      endif
      if(il.eq.2) then
        call
     &  ludbrb(is(2),is(2)+isn(2)-1,0.d0,0.d0,0d0,0d0,(bel))
      else
        call ludbrb(i1,ns,0.d0,0.d0,0d0,0d0,(bel))
      endif

      return
      end

c*********************************************************************

      subroutine pydiff
      implicit double precision (a-h,o-z)

c...handles diffractive and elastic scattering.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /lujets/,/ludat1/
      save /pypars/,/pyint1/

c...reset k, p and v vectors. store incoming particles.
      do 100 jt=1,mstp(126)+10
      i=mint(83)+jt
      do 100 j=1,5
      k(i,j)=0
      p(i,j)=0.
  100 v(i,j)=0.
      n=mint(84)
      mint(3)=0
      mint(21)=0
      mint(22)=0
      mint(23)=0
      mint(24)=0
      mint(4)=4
      do 110 jt=1,2
      i=mint(83)+jt
      k(i,1)=21
      k(i,2)=mint(10+jt)
      p(i,5)=vint(2+jt)
      p(i,3)=vint(5)*(-1)**(jt+1)
  110 p(i,4)=sqrt(p(i,3)**2+p(i,5)**2)
      mint(6)=2

c...subprocess; kinematics.
      sqlam=(vint(2)-vint(63)-vint(64))**2-4.*vint(63)*vint(64)
      pz=sqrt(sqlam)/(2.*vint(1))
      do 150 jt=1,2
      i=mint(83)+jt
      pe=(vint(2)+vint(62+jt)-vint(65-jt))/(2.*vint(1))

c...elastically scattered particle.
      if(mint(16+jt).le.0) then
        n=n+1
        k(n,1)=1
        k(n,2)=k(i,2)
        k(n,3)=i+2
        p(n,3)=pz*(-1)**(jt+1)
        p(n,4)=pe
        p(n,5)=p(i,5)

c...diffracted particle: valence quark kicked out.
      elseif(mstp(101).eq.1) then
        n=n+2
        k(n-1,1)=2
        k(n,1)=1
        k(n-1,3)=i+2
        k(n,3)=i+2
        call pyspli(k(i,2),21,k(n,2),k(n-1,2))
        p(n-1,5)=ulmass(k(n-1,2))
        p(n,5)=ulmass(k(n,2))
        sqlam=(vint(62+jt)-p(n-1,5)**2-p(n,5)**2)**2-
     &  4.*p(n-1,5)**2*p(n,5)**2
        p(n-1,3)=(pe*sqrt(sqlam)+pz*(vint(62+jt)+p(n-1,5)**2-
     &  p(n,5)**2))/(2.*vint(62+jt))*(-1)**(jt+1)
        p(n-1,4)=sqrt(p(n-1,3)**2+p(n-1,5)**2)
        p(n,3)=pz*(-1)**(jt+1)-p(n-1,3)
        p(n,4)=sqrt(p(n,3)**2+p(n,5)**2)

c...diffracted particle: gluon kicked out.
      else
        n=n+3
        k(n-2,1)=2
        k(n-1,1)=2
        k(n,1)=1
        k(n-2,3)=i+2
        k(n-1,3)=i+2
        k(n,3)=i+2
        call pyspli(k(i,2),21,k(n,2),k(n-2,2))
        k(n-1,2)=21
        p(n-2,5)=ulmass(k(n-2,2))
        p(n-1,5)=0.
        p(n,5)=ulmass(k(n,2))
c...energy distribution for particle into two jets.
  120   imb=1
        if(mod(k(i,2)/1000,10).ne.0) imb=2
        chik=parp(92+2*imb)
        if(mstp(92).le.1) then
          if(imb.eq.1) chi=rlu(0)
          if(imb.eq.2) chi=1.-sqrt(rlu(0))
        elseif(mstp(92).eq.2) then
          chi=1.-rlu(0)**(1./(1.+chik))
        elseif(mstp(92).eq.3) then
          cut=2.*0.3/vint(1)
  130     chi=rlu(0)**2
          if((chi**2/(chi**2+cut**2))**0.25*(1.-chi)**chik.lt.
     &    rlu(0)) goto 130
        else
          cut=2.*0.3/vint(1)
          cutr=(1.+sqrt(1.+cut**2))/cut
  140     chir=cut*cutr**rlu(0)
          chi=(chir**2-cut**2)/(2.*chir)
          if((1.-chi)**chik.lt.rlu(0)) goto 140
        endif
        if(chi.lt.p(n,5)**2/vint(62+jt).or.chi.gt.1.-p(n-2,5)**2/
     &  vint(62+jt)) goto 120
        sqm=p(n-2,5)**2/(1.-chi)+p(n,5)**2/chi
        if((sqrt(sqm)+parj(32))**2.ge.vint(62+jt)) goto 120
        pzi=(pe*(vint(62+jt)-sqm)+pz*(vint(62+jt)+sqm))/
     &  (2.*vint(62+jt))
        pei=sqrt(pzi**2+sqm)
        pqqp=(1.-chi)*(pei+pzi)
        p(n-2,3)=0.5*(pqqp-p(n-2,5)**2/pqqp)*(-1)**(jt+1)
        p(n-2,4)=sqrt(p(n-2,3)**2+p(n-2,5)**2)
        p(n-1,3)=(pz-pzi)*(-1)**(jt+1)
        p(n-1,4)=abs(p(n-1,3))
        p(n,3)=pzi*(-1)**(jt+1)-p(n-2,3)
        p(n,4)=sqrt(p(n,3)**2+p(n,5)**2)
      endif

c...documentation lines.
      k(i+2,1)=21
      if(mint(16+jt).eq.0) k(i+2,2)=mint(10+jt)
      if(mint(16+jt).ne.0) k(i+2,2)=10*(mint(10+jt)/10)
      k(i+2,3)=i
      p(i+2,3)=pz*(-1)**(jt+1)
      p(i+2,4)=pe
      p(i+2,5)=sqrt(vint(62+jt))
  150 continue

c...rotate outgoing partons/particles using cos(theta).
      call ludbrb(mint(83)+3,n,acos(vint(23)),vint(24),0d0,0d0,0d0)

      return
      end

c*********************************************************************

      subroutine pydocu
      implicit double precision (a-h,o-z)

c...handles the decumentation of the process in msti and pari,
c...and also computes cross-sections based on accumulated statistics.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /lujets/,/ludat1/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint5/

c...calculate monte carlo estimates of cross-sections.
      isub=mint(1)
      if(mstp(111).ne.-1) ngen(isub,3)=ngen(isub,3)+1
      ngen(0,3)=ngen(0,3)+1
      xsec(0,3)=0.
      do 100 i=1,200
      if(i.eq.96) then
        xsec(i,3)=0.
      elseif(msub(95).eq.1.and.(i.eq.11.or.i.eq.12.or.i.eq.13.or.
     &i.eq.28.or.i.eq.53.or.i.eq.68)) then
        xsec(i,3)=xsec(96,2)*ngen(i,3)/max(1,ngen(96,1)*
     &  ngen(96,2))
      elseif(ngen(i,1).eq.0) then
        xsec(i,3)=0.
      elseif(ngen(i,2).eq.0) then
        xsec(i,3)=(xsec(i,2)*ngen(0,3))/(ngen(i,1)*
     &  ngen(0,2))
      else
        xsec(i,3)=xsec(i,2)*ngen(i,3)/(ngen(i,1)*
     &  ngen(i,2))
      endif
  100 xsec(0,3)=xsec(0,3)+xsec(i,3)

c...rescale to known low-pt cross-section for standard qcd processes.
      if(msub(95).eq.1) then
        ngens=ngen(91,3)+ngen(92,3)+ngen(93,3)+ngen(94,3)+ngen(95,3)
        xsecs=xsec(91,3)+xsec(92,3)+xsec(93,3)+xsec(94,3)+xsec(95,3)
        xmaxs=xsec(95,1)
        if(msub(91).eq.1) xmaxs=xmaxs+xsec(91,1)
        if(msub(92).eq.1) xmaxs=xmaxs+xsec(92,1)
        if(msub(93).eq.1) xmaxs=xmaxs+xsec(93,1)
        if(msub(94).eq.1) xmaxs=xmaxs+xsec(94,1)
        fac=1.
        if(ngens.lt.ngen(0,3)) fac=(xmaxs-xsecs)/(xsec(0,3)-xsecs)
        xsec(11,3)=fac*xsec(11,3)
        xsec(12,3)=fac*xsec(12,3)
        xsec(13,3)=fac*xsec(13,3)
        xsec(28,3)=fac*xsec(28,3)
        xsec(53,3)=fac*xsec(53,3)
        xsec(68,3)=fac*xsec(68,3)
        xsec(0,3)=xsec(91,3)+xsec(92,3)+xsec(93,3)+xsec(94,3)+
     &  xsec(95,1)
      endif

c...reset information on hard interaction.
      do 110 j=1,200
      msti(j)=0
  110 pari(j)=0.

c...copy integer valued information from mint into msti.
      do 120 j=1,31
  120 msti(j)=mint(j)

c...store cross-section and kinematics variables in pari.
      pari(1)=xsec(0,3)
      pari(2)=xsec(0,3)/mint(5)
      pari(11)=vint(1)
      pari(12)=vint(2)
      if(isub.ne.95) then
        do 130 j=13,22
  130   pari(j)=vint(30+j)
        pari(31)=vint(141)
        pari(32)=vint(142)
        pari(33)=vint(41)
        pari(34)=vint(42)
        pari(35)=pari(33)-pari(34)
        pari(36)=vint(21)
        pari(37)=vint(22)
        pari(38)=vint(26)
        pari(41)=vint(23)
        pari(42)=2.*vint(47)/vint(1)
      endif

c...store information on scattered partons in pari.
      if(isub.ne.95.and.mint(7)*mint(8).ne.0) then
        do 140 is=7,8
        i=mint(is)
        pari(36+is)=p(i,3)/vint(1)
        pari(38+is)=p(i,4)/vint(1)
        pr=max(1d-20,p(i,5)**2+p(i,1)**2+p(i,2)**2)
        pari(40+is)=sign(log(min((sqrt(pr+p(i,3)**2)+abs(p(i,3)))/
     &  sqrt(pr),1d20)),p(i,3))
        pr=max(1d-20,p(i,1)**2+p(i,2)**2)
        pari(42+is)=sign(log(min((sqrt(pr+p(i,3)**2)+abs(p(i,3)))/
     &  sqrt(pr),1d20)),p(i,3))
        pari(44+is)=p(i,3)/sqrt(1e-20+p(i,1)**2+p(i,2)**2+p(i,3)**2)
        pari(46+is)=ulangl(p(i,3),sqrt(p(i,1)**2+p(i,2)**2))
        pari(48+is)=ulangl(p(i,1),p(i,2))
  140   continue
      endif

c...store sum up transverse and longitudinal momenta.
      pari(65)=2.*pari(17)
      if(isub.le.90.or.isub.ge.95) then
        do 150 i=mstp(126)+1,n
        if(k(i,1).le.0.or.k(i,1).gt.10) goto 150
        pt=sqrt(p(i,1)**2+p(i,2)**2)
        pari(69)=pari(69)+pt
        if(i.le.mint(52)) pari(66)=pari(66)+pt
        if(i.gt.mint(52).and.i.le.mint(53)) pari(68)=pari(68)+pt
  150   continue
        pari(67)=pari(68)
        pari(71)=vint(151)
        pari(72)=vint(152)
        pari(73)=vint(151)
        pari(74)=vint(152)
      else
        pari(66)=pari(65)
        pari(69)=pari(65)
      endif

c...store various other pieces of information into pari.
      pari(61)=vint(148)
      pari(81)=vint(138)

c...set information for lutabu.
      if(iset(isub).eq.1.or.iset(isub).eq.3) then
        mstu(161)=mint(21)
        mstu(162)=0
      elseif(iset(isub).eq.5) then
        mstu(161)=mint(23)
        mstu(162)=0
      else
        mstu(161)=mint(21)
        mstu(162)=mint(22)
      endif

      return
      end

c*********************************************************************

      subroutine pyfram(iframe)
      implicit double precision (a-h,o-z)

c...performs transformations between different coordinate frames.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /ludat1/
      save /pypars/,/pyint1/

      if(iframe.lt.1.or.iframe.gt.2) then
        write(mstu(11),5000) iframe,mint(6)
        return
      endif
      if(iframe.eq.mint(6)) return

      if(mint(6).eq.1) then
c...transform from fixed target or user specified frame to
c...cm-frame of incoming particles.
        call lurobo(0.d0,0.d0,-vint(8),-vint(9),-vint(10))
        call lurobo(0.d0,-vint(7),0.d0,0.d0,0.d0)
        call lurobo(-vint(6),0.d0,0.d0,0.d0,0.d0)
        mint(6)=2

      else
c...transform from particle cm-frame to fixed target or user specified
c...frame.
        call lurobo(vint(6),vint(7),vint(8),vint(9),vint(10))
        mint(6)=1
      endif
      msti(6)=mint(6)

 5000 format(1x,'error: illegal values in subroutine pyfram.',1x,
     &'no transformation performed.'/1x,'iframe =',1x,i5,'; mint(6) =',
     &1x,i5)

      return
      end

c*********************************************************************

      subroutine pywidt(kflr,sh,wdtp,wdte)
      implicit double precision (a-h,o-z)

c...calculates full and partial widths of resonances.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      save /ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint4/
      dimension wdtp(0:40),wdte(0:40,0:5),mofsv(3,2),widwsv(3,2),
     &wid2sv(3,2)
      save mofsv,widwsv,wid2sv
      data mofsv/6*0/,widwsv/6*0./,wid2sv/6*0./

c...some common constants.
      kfla=iabs(kflr)
      kfhigg=25
      ihigg=1
      if(kfla.eq.35.or.kfla.eq.36) then
        kfhigg=kfla
        ihigg=kfla-33
      endif
      aem=ulalem(sh)
      xw=paru(102)
      as=ulalps(sh)
      radc=1.+as/paru(1)

c...reset width information.
      do 100 i=0,40
      wdtp(i)=0.
      do 100 j=0,5
  100 wdte(i,j)=0.

      if(kfla.eq.21) then
c...qcd:
        do 110 i=1,mdcy(21,3)
        idc=i+mdcy(21,2)-1
        if(mdme(idc,1).lt.0) goto 110
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 110
        if(i.le.8) then
c...qcd -> q + q~
          wdtp(i)=(1.+2.*rm1)*sqrt(max(0.d0,1.-4.*rm1))
          wid2=1.
        endif
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  110   continue

      elseif(kfla.eq.22) then
c...qed photon.
        do 120 i=1,mdcy(22,3)
        idc=i+mdcy(22,2)-1
        if(mdme(idc,1).lt.0) goto 120
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 120
        if(i.le.8) then
c...qed -> q + q~.
          ef=kchg(i,1)/3.
          fcof=3.*radc
          wdtp(i)=fcof*ef**2*(1.+2.*rm1)*sqrt(max(0.d0,1.-4.*rm1))
          wid2=1.
        elseif(i.le.12) then
c...qed -> l+ + l-.
          ef=kchg(9+2*(i-8),1)/3.
          wdtp(i)=ef**2*(1.+2.*rm1)*sqrt(max(0.d0,1.-4.*rm1))
          wid2=1.
        endif
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  120   continue

      elseif(kfla.eq.23) then
c...z0:
        icase=1
        xwc=1./(16.*xw*(1.-xw))
        fach=aem/3.*xwc*sh
  130   continue
        if(mint(61).ge.1.and.icase.eq.2) then
          vint(111)=0.
          vint(112)=0.
          vint(114)=0.
        endif
        if(mint(61).eq.1.and.icase.eq.2) then
          ei=kchg(iabs(mint(15)),1)/3.
          ai=sign(1.d0,ei)
          vi=ai-4.*ei*xw
          sqmz=pmas(23,1)**2
          hz=fach*wdtp(0)
          if(mstp(43).eq.1.or.mstp(43).eq.3) vint(111)=1.
          if(mstp(43).eq.3) vint(112)=
     &    2.*xwc*sh*(sh-sqmz)/((sh-sqmz)**2+hz**2)
          if(mstp(43).eq.2.or.mstp(43).eq.3) vint(114)=
     &    xwc**2*sh**2/((sh-sqmz)**2+hz**2)
        endif
        do 140 i=1,mdcy(23,3)
        idc=i+mdcy(23,2)-1
        if(mdme(idc,1).lt.0) goto 140
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 140
        if(i.le.8) then
c...z0 -> q + q~
          ef=kchg(i,1)/3.
          af=sign(1.d0,ef+0.1)
          vf=af-4.*ef*xw
          fcof=3.*radc
        elseif(i.le.16) then
c...z0 -> l+ + l-, nu + nu~
          ef=kchg(i+2,1)/3.
          af=sign(1.d0,ef+0.1)
          vf=af-4.*ef*xw
          fcof=1.
        endif
        be34=sqrt(max(0.d0,1.-4.*rm1))
        if(icase.eq.1) then
          wdtp(i)=fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
        elseif(mint(61).eq.1.and.icase.eq.2) then
          wdtp(i)=fcof*((ei**2*vint(111)*ef**2+ei*vi*vint(112)*
     &    ef*vf+(vi**2+ai**2)*vint(114)*vf**2)*(1.+2.*rm1)+
     &    (vi**2+ai**2)*vint(114)*af**2*(1.-4.*rm1))*be34
        elseif(mint(61).eq.2.and.icase.eq.2) then
          fggf=fcof*ef**2*(1.+2.*rm1)*be34
          fgzf=fcof*ef*vf*(1.+2.*rm1)*be34
          fzzf=fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
        endif
        wid2=1.
        if(icase.eq.1) wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          if((icase.eq.1.and.mint(61).ne.1).or.
     &    (icase.eq.2.and.mint(61).eq.1)) then
            wdte(i,mdme(idc,1))=wdtp(i)*wid2
            wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
            wdte(i,0)=wdte(i,mdme(idc,1))
            wdte(0,0)=wdte(0,0)+wdte(i,0)
          endif
          if(mint(61).eq.2.and.icase.eq.2) then
            if(mstp(43).eq.1.or.mstp(43).eq.3) vint(111)=
     &      vint(111)+fggf*wid2
            if(mstp(43).eq.3) vint(112)=vint(112)+fgzf*wid2
            if(mstp(43).eq.2.or.mstp(43).eq.3) vint(114)=
     &      vint(114)+fzzf*wid2
          endif
        endif
  140   continue
        if(mint(61).ge.1) icase=3-icase
        if(icase.eq.2) goto 130

      elseif(kfla.eq.24) then
c...w+/-:
        do 150 i=1,mdcy(24,3)
        idc=i+mdcy(24,2)-1
        if(mdme(idc,1).lt.0) goto 150
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 150
        if(i.le.16) then
c...w+/- -> q + q~'
          fcof=3.*radc*vckm((i-1)/4+1,mod(i-1,4)+1)
        elseif(i.le.20) then
c...w+/- -> l+/- + nu
          fcof=1.
        endif
        wdtp(i)=fcof*(2.-rm1-rm2-(rm1-rm2)**2)*
     &  sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
        wid2=1.
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  150   continue

      elseif(kfla.eq.25.or.kfla.eq.35.or.kfla.eq.36) then
c...h0 (or h'0, or a0):
        do 190 i=1,mdcy(kfhigg,3)
        idc=i+mdcy(kfhigg,2)-1
        if(mdme(idc,1).lt.0) goto 190
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(i.ne.16.and.i.ne.17.and.sqrt(rm1)+sqrt(rm2).gt.1.) goto 190
        if(i.le.8) then
c...h0 -> q + q~
          wdtp(i)=3.*rm1*(1.-4.*rm1)*sqrt(max(0.d0,1.-4.*rm1))*radc
          if(mstp(37).eq.1) wdtp(i)=wdtp(i)*
     &    (log(max(4.d0,parp(37)**2*rm1*sh/paru(117)**2))/
     &    log(max(4.d0,sh/paru(117)**2)))**(24./(33.-2.*mstu(118)))
          if(mstp(4).ge.1.or.ihigg.ge.2) then
            if(mod(i,2).eq.1) wdtp(i)=wdtp(i)*paru(151+10*ihigg)**2
            if(mod(i,2).eq.0) wdtp(i)=wdtp(i)*paru(152+10*ihigg)**2
          endif
          wid2=1.
        elseif(i.le.12) then
c...h0 -> l+ + l-
          wdtp(i)=rm1*(1.-4.*rm1)*sqrt(max(0.d0,1.-4.*rm1))
          if(mstp(4).ge.1.or.ihigg.ge.2) wdtp(i)=wdtp(i)*
     &    paru(153+10*ihigg)**2
          wid2=1.
        elseif(i.eq.13) then
c...h0 -> g + g; quark loop contribution only
          etare=0.
          etaim=0.
          do 160 j=1,2*mstp(1)
          eps=(2.*pmas(j,1))**2/sh
          if(eps.le.1.) then
            if(eps.gt.1.e-4) then
              root=sqrt(1.-eps)
              rln=log((1.+root)/(1.-root))
            else
              rln=log(4./eps-2.)
            endif
            phire=0.25*(rln**2-paru(1)**2)
            phiim=0.5*paru(1)*rln
          else
            phire=-(asin(1./sqrt(eps)))**2
            phiim=0.
          endif
          etarej=0.5*eps*(1.+(eps-1.)*phire)
          etaimj=0.5*eps*(eps-1.)*phiim
          if(mstp(4).ge.1.or.ihigg.ge.2.and.mod(j,2).eq.1) then
            etarej=etarej*paru(151+10*ihigg)
            etaimj=etaimj*paru(151+10*ihigg)
          elseif(mstp(4).ge.1.or.ihigg.ge.2) then
            etarej=etarej*paru(152+10*ihigg)
            etaimj=etaimj*paru(152+10*ihigg)
          endif
          etare=etare+etarej
          etaim=etaim+etaimj
  160     continue
          eta2=etare**2+etaim**2
          wdtp(i)=(as/paru(1))**2*eta2
          wid2=1.
        elseif(i.eq.14) then
c...h0 -> gamma + gamma; quark, charged lepton and w loop contributions
          etare=0.
          etaim=0.
          do 170 j=1,3*mstp(1)+1
          if(j.le.2*mstp(1)) then
            ej=kchg(j,1)/3.
            eps=(2.*pmas(j,1))**2/sh
          elseif(j.le.3*mstp(1)) then
            jl=2*(j-2*mstp(1))-1
            ej=kchg(10+jl,1)/3.
            eps=(2.*pmas(10+jl,1))**2/sh
          else
            eps=(2.*pmas(24,1))**2/sh
          endif
          if(eps.le.1.) then
            if(eps.gt.1.e-4) then
              root=sqrt(1.-eps)
              rln=log((1.+root)/(1.-root))
            else
              rln=log(4./eps-2.)
            endif
            phire=0.25*(rln**2-paru(1)**2)
            phiim=0.5*paru(1)*rln
          else
            phire=-(asin(1./sqrt(eps)))**2
            phiim=0.
          endif
          if(j.le.2*mstp(1)) then
            etarej=0.5*3.*ej**2*eps*(1.+(eps-1.)*phire)
            etaimj=0.5*3.*ej**2*eps*(eps-1.)*phiim
            if(mstp(4).ge.1.or.ihigg.ge.2.and.mod(j,2).eq.1) then
              etarej=etarej*paru(151+10*ihigg)
              etaimj=etaimj*paru(151+10*ihigg)
            elseif(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(152+10*ihigg)
              etaimj=etaimj*paru(152+10*ihigg)
            endif
          elseif(j.le.3*mstp(1)) then
            etarej=0.5*ej**2*eps*(1.+(eps-1.)*phire)
            etaimj=0.5*ej**2*eps*(eps-1.)*phiim
            if(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(153+10*ihigg)
              etaimj=etaimj*paru(153+10*ihigg)
            endif
          else
            etarej=-0.5-0.75*eps*(1.+(eps-2.)*phire)
            etaimj=0.75*eps*(eps-2.)*phiim
            if(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(155+10*ihigg)
              etaimj=etaimj*paru(155+10*ihigg)
            endif
          endif
          etare=etare+etarej
          etaim=etaim+etaimj
  170     continue
          eta2=etare**2+etaim**2
          wdtp(i)=(aem/paru(1))**2*0.5*eta2
          wid2=1.
        elseif(i.eq.15) then
c...h0 -> gamma + z0; quark, charged lepton and w loop contributions
          etare=0.
          etaim=0.
          do 180 j=1,3*mstp(1)+1
          if(j.le.2*mstp(1)) then
            ej=kchg(j,1)/3.
            aj=sign(1.d0,ej+0.1)
            vj=aj-4.*ej*xw
            eps=(2.*pmas(j,1))**2/sh
            epsp=(2.*pmas(j,1)/pmas(23,1))**2
          elseif(j.le.3*mstp(1)) then
            jl=2*(j-2*mstp(1))-1
            ej=kchg(10+jl,1)/3.
            aj=sign(1.d0,ej+0.1)
            vj=aj-4.*ej*xw
            eps=(2.*pmas(10+jl,1))**2/sh
            epsp=(2.*pmas(10+jl,1)/pmas(23,1))**2
          else
            eps=(2.*pmas(24,1))**2/sh
            epsp=(2.*pmas(24,1)/pmas(23,1))**2
          endif
          if(eps.le.1.) then
            root=sqrt(1.-eps)
            if(eps.gt.1.e-4) then
              rln=log((1.+root)/(1.-root))
            else
              rln=log(4./eps-2.)
            endif
            phire=0.25*(rln**2-paru(1)**2)
            phiim=0.5*paru(1)*rln
            psire=-(1.+0.5*root*rln)
            psiim=0.5*paru(1)*root
          else
            phire=-(asin(1./sqrt(eps)))**2
            phiim=0.
            psire=-(1.+sqrt(eps-1.)*asin(1./sqrt(eps)))
            psiim=0.
          endif
          if(epsp.le.1.) then
            root=sqrt(1.-epsp)
            if(epsp.gt.1.e-4) then
              rln=log((1.+root)/(1.-root))
            else
              rln=log(4./epsp-2.)
            endif
            phirep=0.25*(rln**2-paru(1)**2)
            phiimp=0.5*paru(1)*rln
            psirep=-(1.+0.5*root*rln)
            psiimp=0.5*paru(1)*root
          else
            phirep=-(asin(1./sqrt(epsp)))**2
            phiimp=0.
            psirep=-(1.+sqrt(epsp-1.)*asin(1./sqrt(epsp)))
            psiimp=0.
          endif
          fxyre=eps*epsp/(8.*(eps-epsp))*(1.-eps*epsp/(eps-epsp)*(phire-
     &    phirep)-2.*eps/(eps-epsp)*(psire-psirep))
          fxyim=eps*epsp/(8.*(eps-epsp))*(-eps*epsp/(eps-epsp)*(phiim-
     &    phiimp)-2.*eps/(eps-epsp)*(psiim-psiimp))
          f1re=eps*epsp/(2.*(eps-epsp))*(phire-phirep)
          f1im=eps*epsp/(2.*(eps-epsp))*(phiim-phiimp)
          if(j.le.2*mstp(1)) then
            etarej=-3.*ej*vj*(fxyre-0.25*f1re)
            etaimj=-3.*ej*vj*(fxyim-0.25*f1im)
            if(mstp(4).ge.1.or.ihigg.ge.2.and.mod(j,2).eq.1) then
              etarej=etarej*paru(151+10*ihigg)
              etaimj=etaimj*paru(151+10*ihigg)
            elseif(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(152+10*ihigg)
              etaimj=etaimj*paru(152+10*ihigg)
            endif
          elseif(j.le.3*mstp(1)) then
            etarej=-ej*vj*(fxyre-0.25*f1re)
            etaimj=-ej*vj*(fxyim-0.25*f1im)
            if(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(153+10*ihigg)
              etaimj=etaimj*paru(153+10*ihigg)
            endif
          else
            etarej=-(1.-xw)*(((1.+2./eps)*xw/(1.-xw)-
     &      (5.+2./eps))*fxyre+(3.-xw/(1.-xw))*f1re)
            etaimj=-(1.-xw)*(((1.+2./eps)*xw/(1.-xw)-
     &      (5.+2./eps))*fxyim+(3.-xw/(1.-xw))*f1im)
            if(mstp(4).ge.1.or.ihigg.ge.2) then
              etarej=etarej*paru(155+10*ihigg)
              etaimj=etaimj*paru(155+10*ihigg)
            endif
          endif
          etare=etare+etarej
          etaim=etaim+etaimj
  180     continue
          eta2=(etare**2+etaim**2)/(1.-xw)
          wdtp(i)=(aem/paru(1))**2*(1.-pmas(23,1)**2/sh)**3/xw*eta2
          wid2=wids(23,2)
        elseif(i.le.17) then
c...h0 -> z0 + z0, w+ + w-
          pm1=pmas(iabs(kfdp(idc,1)),1)
          pg1=pmas(iabs(kfdp(idc,1)),2)
          if(mint(62).ge.1) then
            if(mstp(42).eq.0.or.(4.*(pm1+10.*pg1)**2.lt.sh.and.
     &      ckin(46).lt.ckin(45).and.ckin(48).lt.ckin(47).and.
     &      max(ckin(45),ckin(47)).lt.pm1-10.*pg1)) then
              mofsv(ihigg,i-15)=0
              widw=(1.-4.*rm1+12.*rm1**2)*sqrt(max(0.d0,1.-4.*rm1))
              wid2=1.
            else
              mofsv(ihigg,i-15)=1
              rmas=sqrt(max(0.d0,sh))
              call pyofsh(1,kfla,kfdp(idc,1),kfdp(idc,2),rmas,widw,wid2)
              widwsv(ihigg,i-15)=widw
              wid2sv(ihigg,i-15)=wid2
            endif
          else
            if(mofsv(ihigg,i-15).eq.0) then
              widw=(1.-4.*rm1+12.*rm1**2)*sqrt(max(0.d0,1.-4.*rm1))
              wid2=1.
            else
              widw=widwsv(ihigg,i-15)
              wid2=wid2sv(ihigg,i-15)
            endif
          endif
          wdtp(i)=widw/(2.*(18-i))
          if(mstp(4).ge.1.or.ihigg.ge.2) wdtp(i)=wdtp(i)*
     &    paru(138+i+10*ihigg)**2
          wid2=wid2*wids(7+i,1)
        elseif(i.eq.18.and.kfla.eq.35) then
c...h'0 -> h0 + h0.
          wdtp(i)=paru(176)**2*0.25*pmas(23,1)**4/sh**2*
     &    sqrt(max(0.d0,1.-4.*rm1))
          wid2=wids(25,2)**2
        elseif(i.eq.19.and.kfla.eq.35) then
c...h'0 -> a0 + a0.
          wdtp(i)=paru(177)**2*0.25*pmas(23,1)**4/sh**2*
     &    sqrt(max(0.d0,1.-4.*rm1))
          wid2=wids(36,2)**2
        elseif(i.eq.18.and.kfla.eq.36) then
c...a0 -> z0 + h0.
          wdtp(i)=paru(186)**2*0.5*sqrt(max(0.d0,(1.-rm1-rm2)**2-
     &    4.*rm1*rm2))**3
          wid2=wids(23,2)*wids(25,2)
        endif
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  190   continue

      elseif(kfla.eq.32) then
c...z'0:
        icase=1
        xwc=1./(16.*xw*(1.-xw))
        fach=aem/3.*xwc*sh
        vint(117)=0.
  200   continue
        if(mint(61).ge.1.and.icase.eq.2) then
          vint(111)=0.
          vint(112)=0.
          vint(113)=0.
          vint(114)=0.
          vint(115)=0.
          vint(116)=0.
        endif
        if(mint(61).eq.1.and.icase.eq.2) then
          kfai=iabs(mint(15))
          ei=kchg(kfai,1)/3.
          ai=sign(1.d0,ei+0.1)
          vi=ai-4.*ei*xw
          kfaic=1
          if(kfai.le.10.and.mod(kfai,2).eq.0) kfaic=2
          if(kfai.gt.10.and.mod(kfai,2).ne.0) kfaic=3
          if(kfai.gt.10.and.mod(kfai,2).eq.0) kfaic=4
          vpi=paru(119+2*kfaic)
          api=paru(120+2*kfaic)
          sqmz=pmas(23,1)**2
          hz=fach*vint(117)
          sqmzp=pmas(32,1)**2
          hzp=fach*wdtp(0)
          if(mstp(44).eq.1.or.mstp(44).eq.4.or.mstp(44).eq.5.or.
     &    mstp(44).eq.7) vint(111)=1.
          if(mstp(44).eq.4.or.mstp(44).eq.7) vint(112)=
     &    2.*xwc*sh*(sh-sqmz)/((sh-sqmz)**2+hz**2)
          if(mstp(44).eq.5.or.mstp(44).eq.7) vint(113)=
     &    2.*xwc*sh*(sh-sqmzp)/((sh-sqmzp)**2+hzp**2)
          if(mstp(44).eq.2.or.mstp(44).eq.4.or.mstp(44).eq.6.or.
     &    mstp(44).eq.7) vint(114)=xwc**2*sh**2/((sh-sqmz)**2+hz**2)
          if(mstp(44).eq.6.or.mstp(44).eq.7) vint(115)=
     &    2.*xwc**2*sh**2*((sh-sqmz)*(sh-sqmzp)+hz*hzp)/
     &    (((sh-sqmz)**2+hz**2)*((sh-sqmzp)**2+hzp**2))
          if(mstp(44).eq.3.or.mstp(44).eq.5.or.mstp(44).eq.6.or.
     &    mstp(44).eq.7) vint(116)=xwc**2*sh**2/((sh-sqmzp)**2+hzp**2)
        endif
        do 210 i=1,mdcy(32,3)
        idc=i+mdcy(32,2)-1
        if(mdme(idc,1).lt.0) goto 210
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1..or.mdme(idc,1).lt.0) goto 210
        if(i.le.16) then
          if(i.le.8) then
c...z'0 -> q + q~
            ef=kchg(i,1)/3.
            af=sign(1.d0,ef+0.1)
            vf=af-4.*ef*xw
            vpf=paru(123-2*mod(i,2))
            apf=paru(124-2*mod(i,2))
            fcof=3.*radc
          elseif(i.le.16) then
c...z'0 -> l+ + l-, nu + nu~
            ef=kchg(i+2,1)/3.
            af=sign(1.d0,ef+0.1)
            vf=af-4.*ef*xw
            vpf=paru(127-2*mod(i,2))
            apf=paru(128-2*mod(i,2))
            fcof=1.
          endif
          be34=sqrt(max(0.d0,1.-4.*rm1))
          if(icase.eq.1) then
            wdtpz=fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
            wdtp(i)=fcof*(vpf**2*(1.+2.*rm1)+apf**2*(1.-4.*rm1))*be34
          elseif(mint(61).eq.1.and.icase.eq.2) then
            wdtp(i)=fcof*((ei**2*vint(111)*ef**2+ei*vi*vint(112)*
     &      ef*vf+ei*vpi*vint(113)*ef*vpf+(vi**2+ai**2)*vint(114)*
     &      vf**2+(vi*vpi+ai*api)*vint(115)*vf*vpf+(vpi**2+api**2)*
     &      vint(116)*vpf**2)*(1.+2.*rm1)+((vi**2+ai**2)*vint(114)*
     &      af**2+(vi*vpi+ai*api)*vint(115)*af*apf+(vpi**2+api**2)*
     &      vint(116)*apf**2)*(1.-4.*rm1))*be34
          elseif(mint(61).eq.2) then
            fggf=fcof*ef**2*(1.+2.*rm1)*be34
            fgzf=fcof*ef*vf*(1.+2.*rm1)*be34
            fgzpf=fcof*ef*vpf*(1.+2.*rm1)*be34
            fzzf=fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
            fzzpf=fcof*(vf*vpf*(1.+2.*rm1)+af*apf*(1.-4.*rm1))*be34
            fzpzpf=fcof*(vpf**2*(1.+2.*rm1)+apf**2*(1.-4.*rm1))*be34
          endif
          wid2=1.
        elseif(i.eq.17) then
c...z'0 -> w+ + w-
          wdtpzp=paru(129)**2*(1.-xw)**2*
     &    sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))**3*
     &    (1.+10.*rm1+10.*rm2+rm1**2+rm2**2+10.*rm1*rm2)
          if(icase.eq.1) then
            wdtpz=0.
            wdtp(i)=wdtpzp
          elseif(mint(61).eq.1.and.icase.eq.2) then
            wdtp(i)=(vpi**2+api**2)*vint(116)*wdtpzp
          elseif(mint(61).eq.2) then
            fggf=0.
            fgzf=0.
            fgzpf=0.
            fzzf=0.
            fzzpf=0.
            fzpzpf=wdtpzp
          endif
          wid2=wids(24,1)
        elseif(i.eq.18) then
c...z'0 -> h+ + h-
          czc=2.*(1.-2.*xw)
          be34c=(1.-4.*rm1)*sqrt(max(0.d0,1.-4.*rm1))
          if(icase.eq.1) then
            wdtpz=0.25*paru(142)**2*czc**2*be34c
            wdtp(i)=0.25*paru(143)**2*czc**2*be34c
          elseif(mint(61).eq.1.and.icase.eq.2) then
            wdtp(i)=0.25*(ei**2*vint(111)+paru(142)*ei*vi*vint(112)*
     &      czc+paru(143)*ei*vpi*vint(113)*czc+paru(142)**2*
     &      (vi**2+ai**2)*vint(114)*czc**2+paru(142)*paru(143)*
     &      (vi*vpi+ai*api)*vint(115)*czc**2+paru(143)**2*
     &      (vpi**2+api**2)*vint(116)*czc**2)*be34c
          elseif(mint(61).eq.2) then
            fggf=0.25*be34c
            fgzf=0.25*paru(142)*czc*be34c
            fgzpf=0.25*paru(143)*czc*be34c
            fzzf=0.25*paru(142)**2*czc**2*be34c
            fzzpf=0.25*paru(142)*paru(143)*czc**2*be34c
            fzpzpf=0.25*paru(143)**2*czc**2*be34c
          endif
          wid2=wids(37,1)
        elseif(i.eq.19) then
c...z'0 -> z0 + gamma.
        elseif(i.eq.20) then
c...z'0 -> z0 + h0
          flam=sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
          wdtpzp=paru(145)**2*4.*abs(1.-2.*xw)*(3.*rm1+0.25*flam**2)*
     &    flam
          if(icase.eq.1) then
            wdtpz=0.
            wdtp(i)=wdtpzp
          elseif(mint(61).eq.1.and.icase.eq.2) then
            wdtp(i)=(vpi**2+api**2)*vint(116)*wdtpzp
          elseif(mint(61).eq.2) then
            fggf=0.
            fgzf=0.
            fgzpf=0.
            fzzf=0.
            fzzpf=0.
            fzpzpf=wdtpzp
          endif
          wid2=wids(23,2)*wids(25,2)
        elseif(i.eq.21.or.i.eq.22) then
c...z' -> h0 + a0 or h'0 + a0.
          be34c=sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))**3
          if(i.eq.21) then
            czah=paru(186)
            czpah=paru(188)
          else
            czah=paru(187)
            czpah=paru(189)
          endif
          if(icase.eq.1) then
            wdtpz=czah**2*be34c
            wdtp(i)=czpah**2*be34c
          elseif(mint(61).eq.1.and.icase.eq.2) then
            wdtp(i)=(czah**2*(vi**2+ai**2)*vint(114)+czah*czpah*
     &      (vi*vpi+ai*api)*vint(115)+czpah**2*(vpi**2+api**2)*
     &      vint(116))*be34c
          elseif(mint(61).eq.2) then
            fggf=0.
            fgzf=0.
            fgzpf=0.
            fzzf=czah**2*be34c
            fzzpf=czah*czpah*be34c
            fzpzpf=czpah**2*be34c
          endif
          if(i.eq.21) wid2=wids(25,2)*wids(36,2)
          if(i.eq.22) wid2=wids(35,2)*wids(36,2)
        endif
        if(icase.eq.1) then
          vint(117)=vint(117)+wdtpz
          wdtp(0)=wdtp(0)+wdtp(i)
        endif
        if(mdme(idc,1).gt.0) then
          if((icase.eq.1.and.mint(61).ne.1).or.
     &    (icase.eq.2.and.mint(61).eq.1)) then
            wdte(i,mdme(idc,1))=wdtp(i)*wid2
            wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
            wdte(i,0)=wdte(i,mdme(idc,1))
            wdte(0,0)=wdte(0,0)+wdte(i,0)
          endif
          if(mint(61).eq.2.and.icase.eq.2) then
            if(mstp(44).eq.1.or.mstp(44).eq.4.or.mstp(44).eq.5.or.
     &      mstp(44).eq.7) vint(111)=vint(111)+fggf*wid2
            if(mstp(44).eq.4.or.mstp(44).eq.7) vint(112)=vint(112)+
     &      fgzf*wid2
            if(mstp(44).eq.5.or.mstp(44).eq.7) vint(113)=vint(113)+
     &      fgzpf*wid2
            if(mstp(44).eq.2.or.mstp(44).eq.4.or.mstp(44).eq.6.or.
     &      mstp(44).eq.7) vint(114)=vint(114)+fzzf*wid2
            if(mstp(44).eq.6.or.mstp(44).eq.7) vint(115)=vint(115)+
     &      fzzpf*wid2
            if(mstp(44).eq.3.or.mstp(44).eq.5.or.mstp(44).eq.6.or.
     &      mstp(44).eq.7) vint(116)=vint(116)+fzpzpf*wid2
          endif
        endif
  210   continue
        if(mint(61).ge.1) icase=3-icase
        if(icase.eq.2) goto 200

      elseif(kfla.eq.34) then
c...w'+/-:
        do 220 i=1,mdcy(34,3)
        idc=i+mdcy(34,2)-1
        if(mdme(idc,1).lt.0) goto 220
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 220
        if(i.le.20) then
          if(i.le.16) then
c...w'+/- -> q + q~'
            fcof=3.*radc*(paru(131)**2+paru(132)**2)*
     &      vckm((i-1)/4+1,mod(i-1,4)+1)
          elseif(i.le.20) then
c...w'+/- -> l+/- + nu
            fcof=paru(133)**2+paru(134)**2
          endif
          wdtp(i)=fcof*0.5*(2.-rm1-rm2-(rm1-rm2)**2)*
     &    sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
          wid2=1.
        elseif(i.eq.21) then
c...w'+/- -> w+/- + z0
          wdtp(i)=paru(135)**2*0.5*(1.-xw)*(rm1/rm2)*
     &    sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))**3*
     &    (1.+10.*rm1+10.*rm2+rm1**2+rm2**2+10.*rm1*rm2)
          if(kflr.gt.0) wid2=wids(24,2)*wids(23,2)
          if(kflr.lt.0) wid2=wids(24,3)*wids(23,2)
        elseif(i.eq.23) then
c...w'+/- -> w+/- + h0
          flam=sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
          wdtp(i)=paru(146)**2*2.*(3.*rm1+0.25*flam**2)*flam
          if(kflr.gt.0) wid2=wids(24,2)*wids(25,2)
          if(kflr.lt.0) wid2=wids(24,3)*wids(25,2)
        endif
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  220   continue

      elseif(kfla.eq.37) then
c...h+/-:
        do 230 i=1,mdcy(37,3)
        idc=i+mdcy(37,2)-1
        if(mdme(idc,1).lt.0) goto 230
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 230
        if(i.le.4) then
c...h+/- -> q + q~'
          wdtp(i)=3.*radc*((rm1*paru(141)**2+rm2/paru(141)**2)*
     &    (1.-rm1-rm2)-4.*rm1*rm2)*
     &    sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
          wid2=1.
        elseif(i.le.8) then
c...h+/- -> l+/- + nu
          wdtp(i)=((rm1*paru(141)**2+rm2/paru(141)**2)*(1.-rm1-rm2)-
     &    4.*rm1*rm2)*sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
          wid2=1.
        elseif(i.eq.9) then
c...h+/- -> w+/- + h0.
          wdtp(i)=paru(195)**2*0.5*sqrt(max(0.d0,(1.-rm1-rm2)**2-
     &    4.*rm1*rm2))**3
          if(kflr.gt.0) wid2=wids(24,2)*wids(25,2)
          if(kflr.lt.0) wid2=wids(24,3)*wids(25,2)
        endif
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  230   continue

      elseif(kfla.eq.39) then
c...lq (leptoquark).
        do 240 i=1,mdcy(39,3)
        idc=i+mdcy(39,2)-1
        if(mdme(idc,1).lt.0) goto 240
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 240
        wdtp(i)=paru(151)*sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))**3
        wid2=1.
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  240   continue

      elseif(kfla.eq.40) then
c...r:
        do 250 i=1,mdcy(40,3)
        idc=i+mdcy(40,2)-1
        if(mdme(idc,1).lt.0) goto 250
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sh
        rm2=pmas(iabs(kfdp(idc,2)),1)**2/sh
        if(sqrt(rm1)+sqrt(rm2).gt.1.) goto 250
        if(i.le.6) then
c...r -> q + q~'
          fcof=3.*radc
        elseif(i.le.9) then
c...r -> l+ + l'-
          fcof=1.
        endif
        wdtp(i)=fcof*(2.-rm1-rm2-(rm1-rm2)**2)*
     &  sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
        wid2=1.
        wdtp(0)=wdtp(0)+wdtp(i)
        if(mdme(idc,1).gt.0) then
          wdte(i,mdme(idc,1))=wdtp(i)*wid2
          wdte(0,mdme(idc,1))=wdte(0,mdme(idc,1))+wdte(i,mdme(idc,1))
          wdte(i,0)=wdte(i,mdme(idc,1))
          wdte(0,0)=wdte(0,0)+wdte(i,0)
        endif
  250   continue

      endif
      mint(61)=0
      mint(62)=0

      return
      end

c***********************************************************************

      subroutine pyofsh(mofsh,kfmo,kfd1,kfd2,pmmo,ret1,ret2)
      implicit double precision (a-h,o-z)

c...calculates partial width and differential cross-section maxima
c...of channels/processes not allowed on mass-shell, and selects
c...masses in such channels/processes.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint5/
      dimension kfd(2),mbw(2),pmd(2),pgd(2),pmg(2),pml(2),pmu(2),
     &pmh(2),atl(2),atu(2),ath(2),rmg(2),inx1(100),xpt1(100),
     &fpt1(100),inx2(100),xpt2(100),fpt2(100),wdtp(0:40),
     &wdte(0:40,0:5)

c...find if particles equal, maximum mass, matrix elements, etc.
      isub=mint(1)
      kfd(1)=iabs(kfd1)
      kfd(2)=iabs(kfd2)
      meql=0
      if(kfd(1).eq.kfd(2)) meql=1
      mlm=0
      if(mofsh.ge.2.and.meql.eq.1) mlm=int(1.5+rlu(0))
      if(mofsh.le.2) then
        noff=44
        pmmx=pmmo
      else
        noff=40
        pmmx=vint(1)
        if(ckin(2).gt.ckin(1)) pmmx=min(ckin(2),vint(1))
      endif
      mmed=0
      if((kfmo.eq.25.or.kfmo.eq.35.or.kfmo.eq.36).and.meql.eq.1.and.
     &(kfd(1).eq.23.or.kfd(1).eq.24)) mmed=1
      if((kfmo.eq.32.or.iabs(kfmo).eq.34).and.(kfd(1).eq.23.or.
     &kfd(1).eq.24).and.(kfd(2).eq.23.or.kfd(2).eq.24)) mmed=2
      if((kfmo.eq.32.or.iabs(kfmo).eq.34).and.(kfd(2).eq.25.or.
     &kfd(2).eq.35.or.kfd(2).eq.36)) mmed=3
      loop=1

c...find where breit-wigners are required, else select discrete masses.
  100 do 110 i=1,2
      kfca=kfd(i)
      if(kfca.gt.100) kfca=lucomp(kfca)
      pmd(i)=pmas(kfca,1)
      pgd(i)=pmas(kfca,2)
      if(mstp(42).le.0.or.pgd(i).lt.parp(41)) then
        mbw(i)=0
        pmg(i)=pmd(i)
      else
        mbw(i)=1
      endif
  110 continue

c...find allowed mass range and breit-wigner parameters.
      do 120 i=1,2
      if(mofsh.eq.1.and.loop.eq.1.and.mbw(i).eq.1) then
        pml(i)=parp(42)
        pmu(i)=pmmx-parp(42)
        if(mbw(3-i).eq.0) pmu(i)=min(pmu(i),pmmx-pmd(3-i))
        if(pmu(i).lt.pml(i)+parj(64)) mbw(i)=-1
      elseif(mbw(i).eq.1.or.mofsh.ge.5) then
        ilm=i
        if(mlm.eq.2) ilm=3-i
        pml(i)=max(ckin(noff+2*ilm-1),parp(42))
        if(mofsh.ge.5.and.i.eq.2) pml(i)=max(pml(i),2.*pmas(kfd2,1))
        pmu(i)=pmmx-max(ckin(noff+5-2*ilm),parp(42))
        if(mofsh.ge.5.and.i.eq.1) pmu(i)=min(pmu(i),pmmx-2.*
     &  pmas(kfd2,1))
        if(ckin(noff+2*ilm).gt.ckin(noff+2*ilm-1)) pmu(i)=min(pmu(i),
     &  ckin(noff+2*ilm))
        if(mbw(3-i).eq.0) pmu(i)=min(pmu(i),pmmx-pmd(3-i))
        if(i.eq.mlm) pmu(i)=min(pmu(i),0.5*pmmx)
        if(meql.eq.0) pmh(i)=min(pmu(i),0.5*pmmx)
        if(pmu(i).lt.pml(i)+parj(64)) mbw(i)=-1
        if(mbw(i).eq.1) then
          atl(i)=atan((pml(i)**2-pmd(i)**2)/(pmd(i)*pgd(i)))
          atu(i)=atan((pmu(i)**2-pmd(i)**2)/(pmd(i)*pgd(i)))
          if(meql.eq.0) ath(i)=atan((pmh(i)**2-pmd(i)**2)/(pmd(i)*
     &    pgd(i)))
        endif
      endif
  120 continue
      if(mbw(1).lt.0.or.mbw(2).lt.0.or.(mbw(1).eq.0.and.mbw(2).eq.0))
     &then
        call luerrm(13,'(pyofsh:) no allowed decay product masses')
        mint(51)=1
        return
      endif

c...calculation of partial width of resonance.
      if(mofsh.eq.1) then

c..if only one integration, pick that to be the inner.
        if(mbw(1).eq.0) then
          pm2=pmd(1)
          pmd(1)=pmd(2)
          pgd(1)=pgd(2)
          pml(1)=pml(2)
          pmu(1)=pmu(2)
        elseif(mbw(2).eq.0) then
          pm2=pmd(2)
        endif

c...start outer loop of integration.
        if(mbw(1).eq.1.and.mbw(2).eq.1) then
          atl2=atan((pml(2)**2-pmd(2)**2)/(pmd(2)*pgd(2)))
          atu2=atan((pmu(2)**2-pmd(2)**2)/(pmd(2)*pgd(2)))
          npt2=1
          xpt2(1)=1.
          inx2(1)=0
          fmax2=0.
        endif
  130   if(mbw(1).eq.1.and.mbw(2).eq.1) then
          pm2s=pmd(2)**2+pmd(2)*pgd(2)*tan(atl2+xpt2(npt2)*(atu2-atl2))
          pm2=min(pmu(2),max(pml(2),sqrt(max(0.d0,pm2s))))
        endif
        rm2=(pm2/pmmx)**2

c...start inner loop of integration.
        pml1=pml(1)
        pmu1=min(pmu(1),pmmx-pm2)
        if(meql.eq.1) pmu1=min(pmu1,pm2)
        atl1=atan((pml1**2-pmd(1)**2)/(pmd(1)*pgd(1)))
        atu1=atan((pmu1**2-pmd(1)**2)/(pmd(1)*pgd(1)))
        if(pml1+parj(64).ge.pmu1.or.atl1+1e-7.ge.atu1) then
          func2=0.
          goto 180
        endif
        npt1=1
        xpt1(1)=1.
        inx1(1)=0
        fmax1=0.
  140   pm1s=pmd(1)**2+pmd(1)*pgd(1)*tan(atl1+xpt1(npt1)*(atu1-atl1))
        pm1=min(pmu1,max(pml1,sqrt(max(0.d0,pm1s))))
        rm1=(pm1/pmmx)**2

c...evaluate function value - inner loop.
        func1=sqrt(max(0.d0,(1.-rm1-rm2)**2-4.*rm1*rm2))
        if(mmed.eq.1) func1=func1*((1.-rm1-rm2)**2+8.*rm1*rm2)
        if(mmed.eq.2) func1=func1**3*(1.+10.*rm1+10.*rm2+rm1**2+
     &  rm2**2+10.*rm1*rm2)
        if(func1.gt.fmax1) fmax1=func1
        fpt1(npt1)=func1

c...go to next position in inner loop.
        if(npt1.eq.1) then
          npt1=npt1+1
          xpt1(npt1)=0.
          inx1(npt1)=1
          goto 140
        elseif(npt1.le.8) then
          npt1=npt1+1
          if(npt1.le.4.or.npt1.eq.6) ish1=1
          ish1=ish1+1
          xpt1(npt1)=0.5*(xpt1(ish1)+xpt1(inx1(ish1)))
          inx1(npt1)=inx1(ish1)
          inx1(ish1)=npt1
          goto 140
        elseif(npt1.lt.100) then
          isn1=ish1
  150     ish1=ish1+1
          if(ish1.gt.npt1) ish1=2
          if(ish1.eq.isn1) goto 160
          dfpt1=abs(fpt1(ish1)-fpt1(inx1(ish1)))
          if(dfpt1.lt.parp(43)*fmax1) goto 150
          npt1=npt1+1
          xpt1(npt1)=0.5*(xpt1(ish1)+xpt1(inx1(ish1)))
          inx1(npt1)=inx1(ish1)
          inx1(ish1)=npt1
          goto 140
        endif

c...calculate integral over inner loop.
  160   fsum1=0.
        do 170 ipt1=2,npt1
  170   fsum1=fsum1+0.5*(fpt1(ipt1)+fpt1(inx1(ipt1)))*
     &  (xpt1(inx1(ipt1))-xpt1(ipt1))
        func2=fsum1*(atu1-atl1)/paru(1)
  180   if(mbw(1).eq.1.and.mbw(2).eq.1) then
          if(func2.gt.fmax2) fmax2=func2
          fpt2(npt2)=func2

c...go to next position in outer loop.
          if(npt2.eq.1) then
            npt2=npt2+1
            xpt2(npt2)=0.
            inx2(npt2)=1
            goto 130
          elseif(npt2.le.8) then
            npt2=npt2+1
            if(npt2.le.4.or.npt2.eq.6) ish2=1
            ish2=ish2+1
            xpt2(npt2)=0.5*(xpt2(ish2)+xpt2(inx2(ish2)))
            inx2(npt2)=inx2(ish2)
            inx2(ish2)=npt2
            goto 130
          elseif(npt2.lt.100) then
            isn2=ish2
  190       ish2=ish2+1
            if(ish2.gt.npt2) ish2=2
            if(ish2.eq.isn2) goto 200
            dfpt2=abs(fpt2(ish2)-fpt2(inx2(ish2)))
            if(dfpt2.lt.parp(43)*fmax2) goto 190
            npt2=npt2+1
            xpt2(npt2)=0.5*(xpt2(ish2)+xpt2(inx2(ish2)))
            inx2(npt2)=inx2(ish2)
            inx2(ish2)=npt2
            goto 130
          endif

c...calculate integral over outer loop.
  200     fsum2=0.
          do 210 ipt2=2,npt2
  210     fsum2=fsum2+0.5*(fpt2(ipt2)+fpt2(inx2(ipt2)))*
     &    (xpt2(inx2(ipt2))-xpt2(ipt2))
          fsum2=fsum2*(atu2-atl2)/paru(1)
          if(meql.eq.1) fsum2=2.*fsum2
        else
          fsum2=func2
        endif

c...save result; second integration for user-selected mass range.
        if(loop.eq.1) widw=fsum2
        wid2=fsum2
        if(loop.eq.1.and.(ckin(46).ge.ckin(45).or.ckin(48).ge.ckin(47).
     &  or.max(ckin(45),ckin(47)).ge.1.01*parp(42))) then
          loop=2
          goto 100
        endif
        ret1=widw
        ret2=wid2/widw

c...select two decay product masses of a resonance.
      elseif(mofsh.eq.2) then
  220   do 230 i=1,2
        if(mbw(i).eq.0) goto 230
        pmbw=pmd(i)**2+pmd(i)*pgd(i)*tan(atl(i)+rlu(0)*(atu(i)-atl(i)))
        pmg(i)=min(pmu(i),max(pml(i),sqrt(max(0.d0,pmbw))))
        rmg(i)=(pmg(i)/pmmx)**2
  230   continue
        if((meql.eq.1.and.pmg(max(1,mlm)).gt.pmg(min(2,3-mlm))).or.
     &  pmg(1)+pmg(2)+parj(64).gt.pmmx) goto 220

c...weight with matrix element (if none known, use beta factor).
        flam=sqrt(max(0.d0,(1.-rmg(1)-rmg(2))**2-4.*rmg(1)*rmg(2)))
        if(mmed.eq.1) then
          wtbe=flam*((1.-rmg(1)-rmg(2))**2+8.*rmg(1)*rmg(2))
        elseif(mmed.eq.2) then
          wtbe=flam**3*(1.+10.*rmg(1)+10.*rmg(2)+rmg(1)**2+
     &    rmg(2)**2+10.*rmg(1)*rmg(2))
        elseif(mmed.eq.3) then
          wtbe=flam*(rmg(1)+flam**2/12.)
        else
          wtbe=flam
        endif
        if(wtbe.lt.rlu(0)) goto 220
        ret1=pmg(1)
        ret2=pmg(2)

c...find suitable set of masses for initialization of 2 -> 2 processes.
      elseif(mofsh.eq.3) then
        if(mbw(1).ne.0.and.mbw(2).eq.0) then
          pmg(1)=min(pmd(1),0.5*(pml(1)+pmu(1)))
          pmg(2)=pmd(2)
        elseif(mbw(2).ne.0.and.mbw(1).eq.0) then
          pmg(1)=pmd(1)
          pmg(2)=min(pmd(2),0.5*(pml(2)+pmu(2)))
        else
          idiv=-1
  240     idiv=idiv+1
          pmg(1)=min(pmd(1),0.1*(idiv*pml(1)+(10-idiv)*pmu(1)))
          pmg(2)=min(pmd(2),0.1*(idiv*pml(2)+(10-idiv)*pmu(2)))
          if(idiv.le.9.and.pmg(1)+pmg(2).gt.0.9*pmmx) goto 240
        endif
        ret1=pmg(1)
        ret2=pmg(2)

c...evaluate importance of excluded tails of breit-wigners.
        if(meql.eq.0.and.mbw(1).eq.1.and.mbw(2).eq.1.and.pmd(1)+pmd(2).
     &  gt.pmmx.and.pmh(1).gt.pml(1).and.pmh(2).gt.pml(2)) meql=2
        if(meql.le.1) then
          vint(80)=1.
          do 250 i=1,2
  250     if(mbw(i).ne.0) vint(80)=vint(80)*1.25*(atu(i)-atl(i))/paru(1)
        else
          vint(80)=(1.25/paru(1))**2*max((atu(1)-atl(1))*
     &    (ath(2)-atl(2)),(ath(1)-atl(1))*(atu(2)-atl(2)))
        endif
        if(isub.eq.22.and.mstp(43).ne.2) vint(80)=4.*vint(80)
        if(meql.ge.1) vint(80)=2.*vint(80)

c...pick one particle to be the lighter (if improves efficiency).
      elseif(mofsh.eq.4) then
        if(meql.eq.0.and.mbw(1).eq.1.and.mbw(2).eq.1.and.pmd(1)+pmd(2).
     &  gt.pmmx.and.pmh(1).gt.pml(1).and.pmh(2).gt.pml(2)) meql=2
  260   if(meql.eq.2) mlm=int(1.5+rlu(0))

c...select two masses according to breit-wigner + flat in s + 1/s.
        do 270 i=1,2
        if(mbw(i).eq.0) goto 270
        pmv=pmu(i)
        if(meql.eq.2.and.i.eq.mlm) pmv=pmh(i)
        atv=atu(i)
        if(meql.eq.2.and.i.eq.mlm) atv=ath(i)
        rbr=rlu(0)
        if(isub.eq.22.and.mstp(43).ne.2) rbr=2.*rbr
        if(rbr.lt.0.8) then
          pmsr=pmd(i)**2+pmd(i)*pgd(i)*tan(atl(i)+rlu(0)*(atv-atl(i)))
          pmg(i)=min(pmv,max(pml(i),sqrt(max(0.d0,pmsr))))
        elseif(rbr.lt.0.9) then
          pmg(i)=sqrt(max(0.d0,pml(i)**2+rlu(0)*(pmv**2-pml(i)**2)))
        elseif(rbr.lt.1.5) then
          pmg(i)=pml(i)*(pmv/pml(i))**rlu(0)
        else
          pmg(i)=sqrt(max(0.d0,pml(i)**2*pmv**2/(pml(i)**2+rlu(0)*
     &    (pmv**2-pml(i)**2))))
        endif
  270   continue
        if((meql.ge.1.and.pmg(max(1,mlm)).gt.pmg(min(2,3-mlm))).or.
     &  pmg(1)+pmg(2)+parj(64).gt.pmmx) then
          ngen(0,1)=ngen(0,1)+1
          ngen(mint(1),1)=ngen(mint(1),1)+1
          goto 260
        endif
        ret1=pmg(1)
        ret2=pmg(2)

c...give weight for selected mass distribution.
        vint(80)=1.
        do 280 i=1,2
        if(mbw(i).eq.0) goto 280
        pmv=pmu(i)
        if(meql.eq.2.and.i.eq.mlm) pmv=pmh(i)
        atv=atu(i)
        if(meql.eq.2.and.i.eq.mlm) atv=ath(i)
        f0=pmd(i)*pgd(i)/((pmg(i)**2-pmd(i)**2)**2+
     &  (pmd(i)*pgd(i))**2)/paru(1)
        f1=1.
        f2=1./pmg(i)**2
        f3=1./pmg(i)**4
        fi0=(atv-atl(i))/paru(1)
        fi1=pmv**2-pml(i)**2
        fi2=2.*log(pmv/pml(i))
        fi3=1./pml(i)**2-1./pmv**2
        if(isub.eq.22.and.mstp(43).ne.2) then
          vint(80)=vint(80)*20./(8.+(fi0/f0)*(f1/fi1+6.*f2/fi2+
     &    5.*f3/fi3))
        else
          vint(80)=vint(80)*10./(8.+(fi0/f0)*(f1/fi1+f2/fi2))
        endif
        vint(80)=vint(80)*fi0
  280   continue
        if(meql.ge.1) vint(80)=2.*vint(80)

      elseif(mofsh.eq.5) then
c...find suitable set of masses for initialization of 2 -> 3 process.
        idiv=6
  290   idiv=idiv-1
        if(mbw(1).eq.0) then
          pmg(1)=pmd(1)
        else
          pmsr=pmd(1)**2+pmd(1)*pgd(1)*tan(atl(1)+0.1*idiv*(atu(1)-
     &    atl(1)))
          pmg(1)=min(pmu(1),max(pml(1),sqrt(max(0.d0,pmsr))))
        endif
        pmg(2)=pml(2)*(pmu(2)/pml(2))**(0.1*idiv)
        if(idiv.ge.1.and.pmg(1)+pmg(2).gt.0.9*pmmx) goto 290
        ret1=pmg(1)
        ret2=pmg(2)

c...evaluate size of selected phase space volume.
        vint(80)=2.*log(pmu(2)/pml(2))
        if(mbw(1).ne.0) vint(80)=vint(80)*1.25*(atu(1)-atl(1))/paru(1)

c...pick decay angles.
        vint(81)=0.
        vint(82)=0.5*paru(1)
        vint(83)=1.
        vint(84)=0.

c...select flavour of resonance decays.
        kfa=kfpr(isub,1)
        call pywidt(kfa,pmg(1)**2,wdtp,wdte)
        if(kchg(kfa,3).eq.0) then
          ipm=2
        else
          ipm=(5+isign(1,kfa))/2
        endif
        wdte0s=wdte(0,1)+wdte(0,ipm)+wdte(0,4)
        if(wdte0s.le.0.) then
          call luerrm(12,'(pyofsh:) no allowed resonace decay channel')
          mint(51)=1
          return
        endif
        wdtec=0.
        do 300 idl=1,mdcy(kfa,3)
        wdtek=wdte(idl,1)+wdte(idl,ipm)+wdte(idl,4)
        if(wdtek.gt.wdtec) then
          idc=idl+mdcy(kfa,2)-1
          wdtec=wdtek
        endif
  300   continue
        mint(35)=idc

c...compensating factor for all flavours.
        kfl=iabs(kfdp(idc,1))
        qfl=kchg(kfl,1)/3.
        afl=sign(1.d0,qfl+0.1)
        vfl=afl-4.*paru(102)*qfl
        wdtek=vfl**2+afl**2
        vint(80)=vint(80)*wdte0s/wdtek

      elseif(mofsh.eq.6) then
c...select two masses, one basically breit-wigner, other dm^2/m^2.
        if(mbw(1).ne.0) then
          rbr=rlu(0)
          if(rbr.lt.0.8) then
            pmsr=pmd(1)**2+pmd(1)*pgd(1)*tan(atl(1)+rlu(0)*
     &      (atu(1)-atl(1)))
            pmg(1)=min(pmu(1),max(pml(1),sqrt(max(0.d0,pmsr))))
          elseif(rbr.lt.0.9) then
            pmg(1)=
     &      sqrt(max(0.d0,pml(1)**2+rlu(0)*(pmu(1)**2-pml(1)**2)))
          else
            pmg(1)=pml(1)*(pmu(1)/pml(1))**rlu(0)
          endif
        endif
        pmg(2)=pml(2)*(pmu(2)/pml(2))**rlu(0)
        if(sqrt(max(0.d0,1.-(pml(2)/pmg(2))**2)).lt.rlu(0).or.
     &  pmg(1)+pmg(2)+parj(64).gt.pmmx) then
          mint(51)=1
          return
        endif
        ret1=pmg(1)
        ret2=pmg(2)

c...give weight for selected mass distribution.
        vint(80)=2.*log(pmu(2)/pml(2))
        if(mbw(1).ne.0) then
          f0=pmd(1)*pgd(1)/((pmg(1)**2-pmd(1)**2)**2+
     &    (pmd(1)*pgd(1))**2)/paru(1)
          f1=1.
          f2=1./pmg(1)**2
          fi0=(atu(1)-atl(1))/paru(1)
          fi1=pmu(1)**2-pml(1)**2
          fi2=2.*log(pmu(1)/pml(1))
          vint(80)=vint(80)*10.*fi0/(8.+(fi0/f0)*(f1/fi1+f2/fi2))
        endif

c...select decay angles.
        vint(81)=2.*rlu(0)-1.
        vint(82)=paru(2)*rlu(0)
        vint(83)=2.*rlu(0)-1.
        vint(84)=paru(2)*rlu(0)

c...select flavour of resonance decays.
        kfa=kfpr(isub,1)
        call pywidt(kfa,pmg(1)**2,wdtp,wdte)
        if(kchg(kfa,3).eq.0) then
          ipm=2
        else
          ipm=(5+isign(1,kfa))/2
        endif
        wdte0s=wdte(0,1)+wdte(0,ipm)+wdte(0,4)
        if(wdte0s.le.0.) then
          call luerrm(12,'(pyofsh:) no allowed resonace decay channel')
          mint(51)=1
          return
        endif
        rkfl=wdte0s*rlu(0)
        idl=0
  320   idl=idl+1
        idc=idl+mdcy(kfa,2)-1
        rkfl=rkfl-(wdte(idl,1)+wdte(idl,ipm)+wdte(idl,4))
        if(idl.lt.mdcy(kfa,3).and.rkfl.gt.0.) goto 320
        mint(35)=idc

c...compensating factor for all flavours.
        kfl=iabs(kfdp(idc,1))
        qfl=kchg(kfl,1)/3.
        afl=sign(1.d0,qfl+0.1)
        vfl=afl-4.*paru(102)*qfl
        wdtek=vfl**2+afl**2
        vint(80)=vint(80)*wdte0s/wdtek
      endif

      return
      end

c***********************************************************************

      subroutine pyklim(ilim)
      implicit double precision (a-h,o-z)

c...checks generated variables against pre-set kinematical limits;
c...also calculates limits on variables used in generation.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      save /lujets/,/ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/

c...common kinematical expressions.
      mint(51)=0
      isub=mint(1)
      istsb=iset(isub)
      if(isub.eq.96) goto 120
      sqm3=vint(63)
      sqm4=vint(64)
      if(ilim.ne.1) then
        tau=vint(21)
        rm3=sqm3/(tau*vint(2))
        rm4=sqm4/(tau*vint(2))
        be34=sqrt(max(1d-20,(1.-rm3-rm4)**2-4.*rm3*rm4))
      endif
      pthmin=ckin(3)
      if(min(sqm3,sqm4).lt.ckin(6)**2) pthmin=max(ckin(3),ckin(5))

      if(ilim.eq.0) then
c...check generated values of tau, y*, cos(theta-hat), and tau' against
c...pre-set kinematical limits.
        yst=vint(22)
        cth=vint(23)
        taup=vint(26)
        taue=tau
        if(istsb.ge.3.and.istsb.le.5) taue=taup
        x1=sqrt(taue)*exp(yst)
        x2=sqrt(taue)*exp(-yst)
        xf=x1-x2
        if(tau*vint(2).lt.ckin(1)**2) mint(51)=1
        if(ckin(2).ge.0..and.tau*vint(2).gt.ckin(2)**2) mint(51)=1
        if(x1.lt.ckin(21).or.x1.gt.ckin(22)) mint(51)=1
        if(x2.lt.ckin(23).or.x2.gt.ckin(24)) mint(51)=1
        if(xf.lt.ckin(25).or.xf.gt.ckin(26)) mint(51)=1
        if(yst.lt.ckin(7).or.yst.gt.ckin(8)) mint(51)=1
        if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) then
          pth=0.5*be34*sqrt(tau*vint(2)*max(0.d0,1.-cth**2))
          expy3=max(1.d-10,(1.+rm3-rm4+be34*cth)/
     &    max(1.d-10,(1.+rm3-rm4-be34*cth)))
          expy4=max(1.d-10,(1.-rm3+rm4-be34*cth)/
     &    max(1.d-10,(1.-rm3+rm4+be34*cth)))
          y3=yst+0.5*log(expy3)
          y4=yst+0.5*log(expy4)
          ylarge=max(y3,y4)
          ysmall=min(y3,y4)
          etalar=10.
          etasma=-10.
          sth=sqrt(max(0.d0,1.-cth**2))
          exsq3=sqrt(max(1d-20,((1.+rm3-rm4)*cosh(yst)+be34*sinh(yst)*
     &    cth)**2-4.*rm3))
          exsq4=sqrt(max(1d-20,((1.-rm3+rm4)*cosh(yst)-be34*sinh(yst)*
     &    cth)**2-4.*rm4))
          if(sth.lt.1.e-6) goto 100
          expet3=((1.+rm3-rm4)*sinh(yst)+be34*cosh(yst)*cth+exsq3)/
     &    (be34*sth)
          expet4=((1.-rm3+rm4)*sinh(yst)-be34*cosh(yst)*cth+exsq4)/
     &    (be34*sth)
          eta3=log(min(1.d10,max(1.d-10,expet3)))
          eta4=log(min(1.d10,max(1.d-10,expet4)))
          etalar=max(eta3,eta4)
          etasma=min(eta3,eta4)
  100     cts3=((1.+rm3-rm4)*sinh(yst)+be34*cosh(yst)*cth)/exsq3
          cts4=((1.-rm3+rm4)*sinh(yst)-be34*cosh(yst)*cth)/exsq4
          ctslar=min(1.d0,max(cts3,cts4))
          ctssma=max(-1.d0,min(cts3,cts4))
          if(pth.lt.pthmin) mint(51)=1
          if(ckin(4).ge.0..and.pth.gt.ckin(4)) mint(51)=1
          if(ylarge.lt.ckin(9).or.ylarge.gt.ckin(10)) mint(51)=1
          if(ysmall.lt.ckin(11).or.ysmall.gt.ckin(12)) mint(51)=1
          if(etalar.lt.ckin(13).or.etalar.gt.ckin(14)) mint(51)=1
          if(etasma.lt.ckin(15).or.etasma.gt.ckin(16)) mint(51)=1
          if(ctslar.lt.ckin(17).or.ctslar.gt.ckin(18)) mint(51)=1
          if(ctssma.lt.ckin(19).or.ctssma.gt.ckin(20)) mint(51)=1
          if(cth.lt.ckin(27).or.cth.gt.ckin(28)) mint(51)=1
        endif
        if(istsb.ge.3.and.istsb.le.5) then
          if(taup*vint(2).lt.ckin(31)**2) mint(51)=1
          if(ckin(32).ge.0..and.taup*vint(2).gt.ckin(32)**2) mint(51)=1
        endif

c...additional p_t cuts on 2 -> 3 process.
        if(istsb.eq.6) then
          kfq=kfpr(131,2)
          pmqq=sqrt(vint(64))
          pmq=pmas(kfq,1)
          pzq=sqrt(max(0.d0,(0.5*pmqq)**2-pmq**2))
          do 110 i=mint(84)+1,mint(84)+2
          k(i,1)=1
          p(i,1)=0.
          p(i,2)=0.
          p(i,3)=pzq*(-1.)**(i-1)
          p(i,4)=0.5*pmqq
  110     p(i,5)=pmq
          peqq=0.5*sqrt(tau*vint(2))*(1.+(vint(64)-vint(63))/
     &    (tau*vint(2)))
          pzqq=sqrt(max(0.d0,peqq**2-vint(64)))
          call ludbrb(mint(84)+1,mint(84)+2,acos(vint(83)),vint(84),
     &    0d0,0d0,-(pzqq/peqq))
          call ludbrb(mint(84)+1,mint(84)+2,acos(vint(23)),vint(24),
     &    0d0,0d0,0d0)
          ptq2=sqrt(p(mint(84)+1,1)**2+p(mint(84)+1,2)**2)
          ptq3=sqrt(p(mint(84)+2,1)**2+p(mint(84)+2,2)**2)
          ptmnq=min(ptq2,ptq3)
          ptmxq=max(ptq2,ptq3)
          if(ptmnq.lt.ckin(51)) mint(51)=1
          if(ckin(52).ge.0..and.ptmnq.gt.ckin(52)) mint(51)=1
          if(ptmxq.lt.ckin(53)) mint(51)=1
          if(ckin(54).ge.0..and.ptmxq.gt.ckin(54)) mint(51)=1
          vint(85)=ptmnq
          vint(86)=ptmxq
        endif

      elseif(ilim.eq.1) then
c...calculate limits on tau
c...0) due to definition
        taumn0=0.
        taumx0=1.
c...1) due to limits on subsystem mass
        taumn1=ckin(1)**2/vint(2)
        taumx1=1.
        if(ckin(2).ge.0.) taumx1=ckin(2)**2/vint(2)
c...2) due to limits on pt-hat (and non-overlapping rapidity intervals)
        tm3=sqrt(sqm3+pthmin**2)
        tm4=sqrt(sqm4+pthmin**2)
        ydcosh=1.
        if(ckin(9).gt.ckin(12)) ydcosh=cosh(ckin(9)-ckin(12))
        taumn2=(tm3**2+2.*tm3*tm4*ydcosh+tm4**2)/vint(2)
        taumx2=1.
c...3) due to limits on pt-hat and cos(theta-hat)
        cth2mn=min(ckin(27)**2,ckin(28)**2)
        cth2mx=max(ckin(27)**2,ckin(28)**2)
        taumn3=0.
        if(ckin(27)*ckin(28).gt.0.) taumn3=
     &  (sqrt(sqm3+pthmin**2/(1.-cth2mn))+
     &  sqrt(sqm4+pthmin**2/(1.-cth2mn)))**2/vint(2)
        taumx3=1.
        if(ckin(4).ge.0..and.cth2mx.lt.1.) taumx3=
     &  (sqrt(sqm3+ckin(4)**2/(1.-cth2mx))+
     &  sqrt(sqm4+ckin(4)**2/(1.-cth2mx)))**2/vint(2)
c...4) due to limits on x1 and x2
        taumn4=ckin(21)*ckin(23)
        taumx4=ckin(22)*ckin(24)
c...5) due to limits on xf
        taumn5=0.
        taumx5=max(1.-ckin(25),1.+ckin(26))
        vint(11)=max(taumn0,taumn1,taumn2,taumn3,taumn4,taumn5)
        vint(31)=min(taumx0,taumx1,taumx2,taumx3,taumx4,taumx5)
        if(mint(47).eq.1.and.(istsb.eq.1.or.istsb.eq.2.or.istsb.eq.6))
     &  then
          vint(11)=0.99999
          vint(31)=1.00001
        endif
        if(vint(31).le.vint(11)) mint(51)=1

      elseif(ilim.eq.2) then
c...calculate limits on y*
        taue=tau
        if(istsb.ge.3.and.istsb.le.5) taue=vint(26)
        taurt=sqrt(taue)
c...0) due to kinematics
        ystmn0=log(taurt)
        ystmx0=-ystmn0
c...1) due to explicit limits
        ystmn1=ckin(7)
        ystmx1=ckin(8)
c...2) due to limits on x1
        ystmn2=log(max(taue,ckin(21))/taurt)
        ystmx2=log(max(taue,ckin(22))/taurt)
c...3) due to limits on x2
        ystmn3=-log(max(taue,ckin(24))/taurt)
        ystmx3=-log(max(taue,ckin(23))/taurt)
c...4) due to limits on xf
        yepmn4=0.5*abs(ckin(25))/taurt
        ystmn4=sign(log(max(1d-20,sqrt(1.+yepmn4**2)+yepmn4)),ckin(25))
        yepmx4=0.5*abs(ckin(26))/taurt
        ystmx4=sign(log(max(1d-20,sqrt(1.+yepmx4**2)+yepmx4)),ckin(26))
c...5) due to simultaneous limits on y-large and y-small
        yepsmn=(rm3-rm4)*sinh(ckin(9)-ckin(11))
        yepsmx=(rm3-rm4)*sinh(ckin(10)-ckin(12))
        ydifmn=abs(log(max(1d-20,sqrt(1.+yepsmn**2)-yepsmn)))
        ydifmx=abs(log(max(1d-20,sqrt(1.+yepsmx**2)-yepsmx)))
        ystmn5=0.5*(ckin(9)+ckin(11)-ydifmn)
        ystmx5=0.5*(ckin(10)+ckin(12)+ydifmx)
c...6) due to simultaneous limits on cos(theta-hat) and y-large or
c...   y-small
        cthlim=sqrt(max(0.d0,1.-4.*pthmin**2/(be34**2*taue*vint(2))))
        rzmn=be34*max(ckin(27),-cthlim)
        rzmx=be34*min(ckin(28),cthlim)
        yex3mx=(1.+rm3-rm4+rzmx)/max(1d-10,1.+rm3-rm4-rzmx)
        yex4mx=(1.+rm4-rm3-rzmn)/max(1d-10,1.+rm4-rm3+rzmn)
        yex3mn=max(1d-10,1.+rm3-rm4+rzmn)/(1.+rm3-rm4-rzmn)
        yex4mn=max(1d-10,1.+rm4-rm3-rzmx)/(1.+rm4-rm3+rzmx)
        ystmn6=ckin(9)-0.5*log(max(yex3mx,yex4mx))
        ystmx6=ckin(12)-0.5*log(min(yex3mn,yex4mn))
        vint(12)=max(ystmn0,ystmn1,ystmn2,ystmn3,ystmn4,ystmn5,ystmn6)
        vint(32)=min(ystmx0,ystmx1,ystmx2,ystmx3,ystmx4,ystmx5,ystmx6)
        if(mint(47).eq.1) then
          vint(12)=-0.00001
          vint(32)=0.00001
        elseif(mint(47).eq.2) then
          vint(12)=0.99999*ystmx0
          vint(32)=1.00001*ystmx0
        elseif(mint(47).eq.3) then
          vint(12)=-1.00001*ystmx0
          vint(32)=-0.99999*ystmx0
        endif
        if(vint(32).le.vint(12)) mint(51)=1

      elseif(ilim.eq.3) then
c...calculate limits on cos(theta-hat)
        yst=vint(22)
c...0) due to definition
        ctnmn0=-1.
        ctnmx0=0.
        ctpmn0=0.
        ctpmx0=1.
c...1) due to explicit limits
        ctnmn1=min(0.d0,ckin(27))
        ctnmx1=min(0.d0,ckin(28))
        ctpmn1=max(0.d0,ckin(27))
        ctpmx1=max(0.d0,ckin(28))
c...2) due to limits on pt-hat
        ctnmn2=-sqrt(max(0.d0,1.-4.*pthmin**2/(be34**2*tau*vint(2))))
        ctpmx2=-ctnmn2
        ctnmx2=0.
        ctpmn2=0.
        if(ckin(4).ge.0.) then
          ctnmx2=
     &  -sqrt(max(0.d0,1.-4.*ckin(4)**2/(be34**2*tau*vint(2))))
          ctpmn2=-ctnmx2
        endif
c...3) due to limits on y-large and y-small
        ctnmn3=min(0.d0,max((1.+rm3-rm4)/be34*tanh(ckin(11)-yst),
     &  -(1.-rm3+rm4)/be34*tanh(ckin(10)-yst)))
        ctnmx3=min(0.d0,(1.+rm3-rm4)/be34*tanh(ckin(12)-yst),
     &  -(1.-rm3+rm4)/be34*tanh(ckin(9)-yst))
        ctpmn3=max(0.d0,(1.+rm3-rm4)/be34*tanh(ckin(9)-yst),
     &  -(1.-rm3+rm4)/be34*tanh(ckin(12)-yst))
        ctpmx3=max(0.d0,min((1.+rm3-rm4)/be34*tanh(ckin(10)-yst),
     &  -(1.-rm3+rm4)/be34*tanh(ckin(11)-yst)))
        vint(13)=max(ctnmn0,ctnmn1,ctnmn2,ctnmn3)
        vint(33)=min(ctnmx0,ctnmx1,ctnmx2,ctnmx3)
        vint(14)=max(ctpmn0,ctpmn1,ctpmn2,ctpmn3)
        vint(34)=min(ctpmx0,ctpmx1,ctpmx2,ctpmx3)
        if(vint(33).le.vint(13).and.vint(34).le.vint(14)) mint(51)=1

      elseif(ilim.eq.4) then
c...calculate limits on tau'
c...0) due to kinematics
        tapmn0=tau
        tapmx0=1.
c...1) due to explicit limits
        tapmn1=ckin(31)**2/vint(2)
        tapmx1=1.
        if(ckin(32).ge.0.) tapmx1=ckin(32)**2/vint(2)
        vint(16)=max(tapmn0,tapmn1)
        vint(36)=min(tapmx0,tapmx1)
        if(mint(47).eq.1) then
          vint(16)=0.99999
          vint(36)=1.00001
        endif
        if(vint(36).le.vint(16)) mint(51)=1

      endif
      return

c...special case for low-pt and multiple interactions:
c...effective kinematical limits for tau, y*, cos(theta-hat).
  120 if(ilim.eq.0) then
      elseif(ilim.eq.1) then
        if(mstp(82).le.1) vint(11)=4.*parp(81)**2/vint(2)
        if(mstp(82).ge.2) vint(11)=parp(82)**2/vint(2)
        vint(31)=1.
      elseif(ilim.eq.2) then
        vint(12)=0.5*log(vint(21))
        vint(32)=-vint(12)
      elseif(ilim.eq.3) then
        if(mstp(82).le.1) st2eff=4.*parp(81)**2/(vint(21)*vint(2))
        if(mstp(82).ge.2) st2eff=0.01*parp(82)**2/(vint(21)*vint(2))
        vint(13)=-sqrt(max(0.d0,1.-st2eff))
        vint(33)=0.
        vint(14)=0.
        vint(34)=-vint(13)
      endif

      return
      end

c*********************************************************************

      subroutine pykmap(ivar,mvar,vvar)
      implicit double precision (a-h,o-z)

c...maps a uniform distribution into a distribution of a kinematical
c...variable according to one of the possibilities allowed. it is
c...assumed that kinematical limits have been set by a pyklim call.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      save /ludat1/,/ludat2/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/

c...convert vvar to tau variable.
      isub=mint(1)
      istsb=iset(isub)
      if(ivar.eq.1) then
        taumin=vint(11)
        taumax=vint(31)
        if(mvar.eq.3.or.mvar.eq.4) then
          taure=vint(73)
          gamre=vint(74)
        elseif(mvar.eq.5.or.mvar.eq.6) then
          taure=vint(75)
          gamre=vint(76)
        endif
        if(mint(47).eq.1.and.(istsb.eq.1.or.istsb.eq.2.or.istsb.eq.6))
     &  then
          tau=1.
        elseif(mvar.eq.1) then
          tau=taumin*(taumax/taumin)**vvar
        elseif(mvar.eq.2) then
          tau=taumax*taumin/(taumin+(taumax-taumin)*vvar)
        elseif(mvar.eq.3.or.mvar.eq.5) then
          ratgen=(taure+taumax)/(taure+taumin)*taumin/taumax
          tau=taure*taumin/((taure+taumin)*ratgen**vvar-taumin)
        elseif(mvar.eq.4.or.mvar.eq.6) then
          aupp=atan((taumax-taure)/gamre)
          alow=atan((taumin-taure)/gamre)
          tau=taure+gamre*tan(alow+(aupp-alow)*vvar)
        else
          aupp=log(max(2d-6,1.-taumax))
          alow=log(max(2d-6,1.-taumin))
          tau=1.-exp(aupp+vvar*(alow-aupp))
        endif
        vint(21)=min(taumax,max(taumin,tau))

c...convert vvar to y* variable.
      elseif(ivar.eq.2) then
        ystmin=vint(12)
        ystmax=vint(32)
        taue=vint(21)
        if(istsb.ge.3.and.istsb.le.5) taue=vint(26)
        if(mint(47).eq.1) then
          yst=0.
        elseif(mint(47).eq.2) then
          yst=-0.5*log(taue)
        elseif(mint(47).eq.3) then
          yst=0.5*log(taue)
        elseif(mvar.eq.1) then
          yst=ystmin+(ystmax-ystmin)*sqrt(vvar)
        elseif(mvar.eq.2) then
          yst=ystmax-(ystmax-ystmin)*sqrt(1.-vvar)
        elseif(mvar.eq.3) then
          aupp=atan(exp(ystmax))
          alow=atan(exp(ystmin))
          yst=log(tan(alow+(aupp-alow)*vvar))
        elseif(mvar.eq.4) then
          yst0=-0.5*log(taue)
          aupp=log(max(1d-6,exp(yst0-ystmin)-1.))
          alow=log(max(1d-6,exp(yst0-ystmax)-1.))
          yst=yst0-log(1.+exp(alow+vvar*(aupp-alow)))
        else
          yst0=-0.5*log(taue)
          aupp=log(max(1d-6,exp(yst0+ystmin)-1.))
          alow=log(max(1d-6,exp(yst0+ystmax)-1.))
          yst=log(1.+exp(aupp+vvar*(alow-aupp)))-yst0
        endif
        vint(22)=min(ystmax,max(ystmin,yst))

c...convert vvar to cos(theta-hat) variable.
      elseif(ivar.eq.3) then
        rm34=2.*vint(63)*vint(64)/(vint(21)*vint(2))**2
        if(isub.eq.83) rm34=max(1d-20,rm34)
        rsqm=1.+rm34
        if(2.*vint(71)**2/(vint(21)*vint(2)).lt.0.0001) rm34=max(rm34,
     &  2.*vint(71)**2/(vint(21)*vint(2)))
        ctnmin=vint(13)
        ctnmax=vint(33)
        ctpmin=vint(14)
        ctpmax=vint(34)
        if(mvar.eq.1) then
          aneg=ctnmax-ctnmin
          apos=ctpmax-ctpmin
          if(aneg.gt.0..and.vvar*(aneg+apos).le.aneg) then
            vctn=vvar*(aneg+apos)/aneg
            cth=ctnmin+(ctnmax-ctnmin)*vctn
          else
            vctp=(vvar*(aneg+apos)-aneg)/apos
            cth=ctpmin+(ctpmax-ctpmin)*vctp
          endif
        elseif(mvar.eq.2) then
          rmnmin=max(rm34,rsqm-ctnmin)
          rmnmax=max(rm34,rsqm-ctnmax)
          rmpmin=max(rm34,rsqm-ctpmin)
          rmpmax=max(rm34,rsqm-ctpmax)
          aneg=log(rmnmin/rmnmax)
          apos=log(rmpmin/rmpmax)
          if(aneg.gt.0..and.vvar*(aneg+apos).le.aneg) then
            vctn=vvar*(aneg+apos)/aneg
            cth=rsqm-rmnmin*(rmnmax/rmnmin)**vctn
          else
            vctp=(vvar*(aneg+apos)-aneg)/apos
            cth=rsqm-rmpmin*(rmpmax/rmpmin)**vctp
          endif
        elseif(mvar.eq.3) then
          rmnmin=max(rm34,rsqm+ctnmin)
          rmnmax=max(rm34,rsqm+ctnmax)
          rmpmin=max(rm34,rsqm+ctpmin)
          rmpmax=max(rm34,rsqm+ctpmax)
          aneg=log(rmnmax/rmnmin)
          apos=log(rmpmax/rmpmin)
          if(aneg.gt.0..and.vvar*(aneg+apos).le.aneg) then
            vctn=vvar*(aneg+apos)/aneg
            cth=rmnmin*(rmnmax/rmnmin)**vctn-rsqm
          else
            vctp=(vvar*(aneg+apos)-aneg)/apos
            cth=rmpmin*(rmpmax/rmpmin)**vctp-rsqm
          endif
        elseif(mvar.eq.4) then
          rmnmin=max(rm34,rsqm-ctnmin)
          rmnmax=max(rm34,rsqm-ctnmax)
          rmpmin=max(rm34,rsqm-ctpmin)
          rmpmax=max(rm34,rsqm-ctpmax)
          aneg=1./rmnmax-1./rmnmin
          apos=1./rmpmax-1./rmpmin
          if(aneg.gt.0..and.vvar*(aneg+apos).le.aneg) then
            vctn=vvar*(aneg+apos)/aneg
            cth=rsqm-1./(1./rmnmin+aneg*vctn)
          else
            vctp=(vvar*(aneg+apos)-aneg)/apos
            cth=rsqm-1./(1./rmpmin+apos*vctp)
          endif
        elseif(mvar.eq.5) then
          rmnmin=max(rm34,rsqm+ctnmin)
          rmnmax=max(rm34,rsqm+ctnmax)
          rmpmin=max(rm34,rsqm+ctpmin)
          rmpmax=max(rm34,rsqm+ctpmax)
          aneg=1./rmnmin-1./rmnmax
          apos=1./rmpmin-1./rmpmax
          if(aneg.gt.0..and.vvar*(aneg+apos).le.aneg) then
            vctn=vvar*(aneg+apos)/aneg
            cth=1./(1./rmnmin-aneg*vctn)-rsqm
          else
            vctp=(vvar*(aneg+apos)-aneg)/apos
            cth=1./(1./rmpmin-apos*vctp)-rsqm
          endif
        endif
        if(cth.lt.0.) cth=min(ctnmax,max(ctnmin,cth))
        if(cth.gt.0.) cth=min(ctpmax,max(ctpmin,cth))
        vint(23)=cth

c...convert vvar to tau' variable.
      elseif(ivar.eq.4) then
        tau=vint(21)
        taupmn=vint(16)
        taupmx=vint(36)
        if(mint(47).eq.1) then
          taup=1.
        elseif(mvar.eq.1) then
          taup=taupmn*(taupmx/taupmn)**vvar
        elseif(mvar.eq.2) then
          aupp=(1.-tau/taupmx)**4
          alow=(1.-tau/taupmn)**4
          taup=tau/max(1d-7,1.-(alow+(aupp-alow)*vvar)**0.25)
        else
          aupp=log(max(2d-6,1.-taupmx))
          alow=log(max(2d-6,1.-taupmn))
          taup=1.-exp(aupp+vvar*(alow-aupp))
        endif
        vint(26)=min(taupmx,max(taupmn,taup))

c...selection of extra variables needed in 2 -> 3 process:
c...pt1, pt2, phi1, phi2, y3 for three outgoing particles.
c...since no options are available, the functions of pyklim
c...and pykmap are joint for these choices.
      elseif(ivar.eq.5) then

c...read out total energy and particle masses.
        mint(51)=0
        shp=vint(26)*vint(2)
        shpr=sqrt(shp)
        pm1=vint(201)
        pm2=vint(206)
        pm3=sqrt(vint(21))*vint(1)
        if(pm1+pm2+pm3.gt.0.9999*shpr) then
          mint(51)=1
          return
        endif
        pmrs1=vint(204)**2
        pmrs2=vint(209)**2

c...select transverse momenta according to dpt^2/(pt^2+m^2)^2.
        ptsmx1=((shp-pm1**2-(pm2+pm3)**2)**2-(2.*pm1*(pm2+pm3))**2)/
     &  (4.*shp)
        if(ckin(52).gt.0.) ptsmx1=min(ptsmx1,ckin(52)**2)
        ptsmn1=ckin(51)**2
        pts1=max(ptsmn1,(pmrs1+ptsmn1)*(pmrs1+ptsmx1)/
     &  (pmrs1+ptsmn1+rlu(0)*(ptsmx1-ptsmn1))-pmrs1)
        ptsmx2=((shp-pm2**2-(pm1+pm3)**2)**2-(2.*pm2*(pm1+pm3))**2)/
     &  (4.*shp)
        if(ckin(54).gt.0.) ptsmx2=min(ptsmx2,ckin(54)**2)
        ptsmn2=ckin(53)**2
        pts2=max(ptsmn2,(pmrs2+ptsmn2)*(pmrs2+ptsmx2)/
     &  (pmrs2+ptsmn2+rlu(0)*(ptsmx2-ptsmn2))-pmrs2)
        phi1=paru(2)*rlu(0)
        phi2=paru(2)*rlu(0)
        phir=phi2-phi1
        pts3=max(0.d0,pts1+pts2+2.*sqrt(pts1*pts2)*cos(phir))
        if(pts3.lt.ckin(55)**2.or.(ckin(56).gt.0..and.pts3.gt.
     &  ckin(56)**2)) then
          mint(51)=1
          return
        endif

c...calculate transverse masses and check phase space not closed.
        pms1=pm1**2+pts1
        pms2=pm2**2+pts2
        pms3=pm3**2+pts3
        pmt1=sqrt(pms1)
        pmt2=sqrt(pms2)
        pmt3=sqrt(pms3)
        pm12=(pmt1+pmt2)**2
        if(pmt1+pmt2+pmt3.gt.0.9999*shpr) then
          mint(51)=1
          return
        endif

c...select rapidity for particle 3 and check phase space not closed.
        y3max=log((shp+pms3-pm12+sqrt(max(0.d0,(shp-pms3-pm12)**2-
     &  4.*pms3*pm12)))/(2.*shpr*pmt3))
        if(y3max.lt.1e-6) then
          mint(51)=1
          return
        endif
        y3=(2.*rlu(0)-1.)*0.999999*y3max
        pz3=pmt3*sinh(y3)
        pe3=pmt3*cosh(y3)

c...find momentum transfers in two mirror solutions (in 1-2 frame).
        pz12=-pz3
        pe12=shpr-pe3
        pms12=pe12**2-pz12**2
        sql12=sqrt(max(0.d0,(pms12-pms1-pms2)**2-4.*pms1*pms2))
        if(sql12.lt.1e-6*shp) then
          mint(51)=1
          return
        endif
        pmm1=pms12+pms1-pms2
        pmm2=pms12+pms2-pms1
        tfac=-shpr/(2.*pms12)
        t1p=tfac*(pe12-pz12)*(pmm1-sql12)
        t1n=tfac*(pe12-pz12)*(pmm1+sql12)
        t2p=tfac*(pe12+pz12)*(pmm2-sql12)
        t2n=tfac*(pe12+pz12)*(pmm2+sql12)

c...construct relative mirror weights and make choice.
        wtpu=1./((t1p-pmrs1)*(t2p-pmrs2))**2
        wtnu=1./((t1n-pmrs1)*(t2n-pmrs2))**2
        wtp=wtpu/(wtpu+wtnu)
        wtn=wtnu/(wtpu+wtnu)
        eps=1.
        if(wtn.gt.rlu(0)) eps=-1.

c...store result of variable choice and associated weights.
        vint(202)=pts1
        vint(207)=pts2
        vint(203)=phi1
        vint(208)=phi2
        vint(205)=(pmrs1+pts1)**2*(ptsmx1-ptsmn1)/((pmrs1+ptsmn1)*
     &  (pmrs1+ptsmx1))
        vint(210)=(pmrs2+pts2)**2*(ptsmx2-ptsmn2)/((pmrs2+ptsmn2)*
     &  (pmrs2+ptsmx2))
        vint(211)=y3
        vint(212)=y3max
        vint(213)=eps
        if(eps.gt.0.) then
          vint(214)=1./wtp
          vint(215)=t1p
          vint(216)=t2p
        else
          vint(214)=1./wtn
          vint(215)=t1n
          vint(216)=t2n
        endif
        vint(217)=-0.5*tfac*(pe12-pz12)*(pmm2+eps*sql12)
        vint(218)=-0.5*tfac*(pe12+pz12)*(pmm1+eps*sql12)
        vint(219)=0.5*(pms12-pts3)
        vint(220)=sql12
      endif

      return
      end

c***********************************************************************

      subroutine pysigh(nchn,sigs)
      implicit double precision (a-h,o-z)

c...differential matrix elements for all included subprocesses.
c...note that what is coded is (disregarding the comfac factor)
c...1) for 2 -> 1 processes: s-hat/pi*d(sigma-hat), where,
c...when d(sigma-hat) is given in the zero-width limit, the delta
c...function in tau is replaced by a (modified) breit-wigner:
c...1/pi*s*h_res/((s*tau-m_res^2)^2+h_res^2),
c...where h_res = s-hat/m_res*gamma_res(s-hat);
c...2) for 2 -> 2 processes: (s-hat)**2/pi*d(sigma-hat)/d(t-hat);
c...i.e., dimensionless quantities.
c...3) for 2 -> 3 processes: abs(m)^2, where the total cross-section is
c...integral abs(m)^2/(2shat') * (prod_(i=1)^3 d^3p_i/((2pi)^3*2e_i)) *
c...(2pi)^4 delta^4(p - sum p_i).
c...comfac contains the factor pi/s (or equivalent) and
c...the conversion factor from gev^-2 to mb.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      save /lujets/,/ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint4/,
     &/pyint5/
      dimension x(2),xpq(-25:25),kfac(2,-40:40),wdtp(0:40),
     &wdte(0:40,0:5),hgz(6,3),hl3(3),hr3(3),hl4(3),hr4(3)
      complex*16 a004,a204,a114,a00u,a20u,a11u

c...the following gives an interface for process 131, gg -> zqq,
c...to the matrix element package of ronald kleiss.
      common/rkbbvc/rkmq,rkmz,rkgz,rkvq,rkaq,rkvl,rkal
      save /rkbbvc/
      dimension rkg1(0:3),rkg2(0:3),rkq1(0:3),rkq2(0:3),rkl1(0:3),
     &rkl2(0:3)

c...reset number of channels and cross-section.
      nchn=0
      sigs=0.

c...convert h' or a process into equivalent h one.
      isub=mint(1)
      isubsv=isub
      ihigg=1
      kfhigg=25
      if((isub.ge.151.and.isub.le.160).or.(isub.ge.171.and.
     &isub.le.180)) then
        ihigg=2
        if(mod(isub-1,10).ge.5) ihigg=3
        kfhigg=33+ihigg
        if(isub.eq.151.or.isub.eq.156) isub=3
        if(isub.eq.152.or.isub.eq.157) isub=102
        if(isub.eq.153.or.isub.eq.158) isub=103
        if(isub.eq.171.or.isub.eq.176) isub=24
        if(isub.eq.172.or.isub.eq.177) isub=26
        if(isub.eq.173.or.isub.eq.178) isub=123
        if(isub.eq.174.or.isub.eq.179) isub=124
      endif

c...read kinematical variables and limits.
      istsb=iset(isub)
      taumin=vint(11)
      ystmin=vint(12)
      ctnmin=vint(13)
      ctpmin=vint(14)
      taupmn=vint(16)
      tau=vint(21)
      yst=vint(22)
      cth=vint(23)
      xt2=vint(25)
      taup=vint(26)
      taumax=vint(31)
      ystmax=vint(32)
      ctnmax=vint(33)
      ctpmax=vint(34)
      taupmx=vint(36)

c...derive kinematical quantities.
      taue=tau
      if(istsb.ge.3.and.istsb.le.5) taue=taup
      x(1)=sqrt(taue)*exp(yst)
      x(2)=sqrt(taue)*exp(-yst)
      if(mint(45).eq.2.and.istsb.ge.1) then
        if(x(1).gt.0.9999) return
      elseif(mint(45).eq.3) then
        x(1)=min(0.9999989d0,x(1))
      endif
      if(mint(46).eq.2.and.istsb.ge.1) then
        if(x(2).gt.0.9999) return
      elseif(mint(46).eq.3) then
        x(2)=min(0.9999989d0,x(2))
      endif
      sh=tau*vint(2)
      sqm3=vint(63)
      sqm4=vint(64)
      rm3=sqm3/sh
      rm4=sqm4/sh
      be34=sqrt(max(0.d0,(1.-rm3-rm4)**2-4.*rm3*rm4))
      rpts=4.*vint(71)**2/sh
      be34l=sqrt(max(0.d0,(1.-rm3-rm4)**2-4.*rm3*rm4-rpts))
      rm34=2.*rm3*rm4
      if(isub.eq.83) rm34=max(1d-20,rm34)
      rsqm=1.+rm34
      rthm=(4.*rm3*rm4+rpts)/(1.-rm3-rm4+be34l)
      th=-0.5*sh*max(rthm,1.-rm3-rm4-be34*cth)
      uh=-0.5*sh*max(rthm,1.-rm3-rm4+be34*cth)
      sqpth=max(vint(71)**2,0.25*sh*be34**2*(1.-cth**2))
      sh2=sh**2
      th2=th**2
      uh2=uh**2

c...choice of q2 scale.
      if(istsb.eq.1.or.istsb.eq.3.or.istsb.eq.5) then
        q2=sh
      elseif(mod(istsb,2).eq.0.or.istsb.eq.9) then
        if(mstp(32).eq.1) then
          q2=2.*sh*th*uh/(sh**2+th**2+uh**2)
        elseif(mstp(32).eq.2) then
          q2=sqpth+0.5*(sqm3+sqm4)
        elseif(mstp(32).eq.3) then
          q2=min(-th,-uh)
        elseif(mstp(32).eq.4) then
          q2=sh
        endif
        if(istsb.eq.9.and.mstp(82).ge.2) q2=q2+parp(82)**2
      endif

c...store derived kinematical quantities.
      vint(41)=x(1)
      vint(42)=x(2)
      vint(44)=sh
      vint(43)=sqrt(sh)
      vint(45)=th
      vint(46)=uh
      vint(48)=sqpth
      vint(47)=sqrt(sqpth)
      vint(50)=taup*vint(2)
      vint(49)=sqrt(max(0.d0,vint(50)))
      vint(52)=q2
      vint(51)=sqrt(q2)

c...calculate parton structure functions.
      if(istsb.le.0) goto 150
      if(mint(47).ge.2) then
        q2sf=q2
        if(istsb.ge.3.and.istsb.le.5) then
          q2sf=pmas(23,1)**2
          if(isub.eq.8.or.isub.eq.76.or.isub.eq.77.or.isub.eq.124.or.
     &    isub.eq.174.or.isub.eq.179) q2sf=pmas(24,1)**2
        endif
        do 100 i=3-min(2,mint(45)),min(2,mint(46))
        xsf=x(i)
        if(istsb.eq.9) xsf=x(i)/vint(142+i)
        call pystfu(mint(10+i),xsf,q2sf,xpq)
        do 100 kfl=-25,25
  100   xsfx(i,kfl)=xpq(kfl)
      endif

c...calculate alpha_em, alpha_strong and k-factor.
      aem=ulalem(q2)
      if(mstp(33).ne.3) as=ulalps(q2)
      fack=1.
      faca=1.
      if(mstp(33).eq.1) then
        fack=parp(31)
      elseif(mstp(33).eq.2) then
        fack=parp(31)
        faca=parp(32)/parp(31)
      elseif(mstp(33).eq.3) then
        q2as=parp(33)*q2
        if(istsb.eq.9.and.mstp(82).ge.2) q2as=q2as+
     &  paru(112)*parp(82)
        as=ulalps(q2as)
      endif
      vint(138)=1.

c...set flags for allowed reacting partons/leptons.
      do 130 i=1,2
      do 110 j=-25,25
  110 kfac(i,j)=0
      if(mint(44+i).eq.1) then
        kfac(i,mint(10+i))=1
      elseif(mint(40+i).eq.1.and.mstp(12).eq.0) then
        kfac(i,mint(10+i))=1
        kfac(i,22)=1
        kfac(i,24)=1
        kfac(i,-24)=1
      else
        do 120 j=-25,25
        kfac(i,j)=kfin(i,j)
        if(abs(j).gt.mstp(54).and.j.le.10) kfac(i,j)=0
        if(abs(j).ne.21) then
          if(xsfx(i,j).lt.1.e-10) kfac(i,j)=0
        else
          if(xsfx(i,0).lt.1.e-10) kfac(i,21)=0
        endif
  120   continue
      endif
  130 continue

c...lower and upper limit for fermion flavour loops.
      min1=0
      max1=0
      min2=0
      max2=0
      do 140 j=-20,20
      if(kfac(1,-j).eq.1) min1=-j
      if(kfac(1,j).eq.1) max1=j
      if(kfac(2,-j).eq.1) min2=-j
      if(kfac(2,j).eq.1) max2=j
  140 continue
      mina=min(min1,min2)
      maxa=max(max1,max2)

c...common conversion factors (including jacobian) for subprocesses.
      sqmz=pmas(23,1)**2
      sqmw=pmas(24,1)**2
      sqmh=pmas(kfhigg,1)**2
      gmmh=pmas(kfhigg,1)*pmas(kfhigg,2)
      sqmzp=pmas(32,1)**2
      sqmwp=pmas(34,1)**2
      sqmhc=pmas(37,1)**2
      sqmlq=pmas(39,1)**2
      sqmr=pmas(40,1)**2
      xw=paru(102)
      xwc=1./(16.*xw*(1.-xw))

c...phase space integral in tau.
      comfac=paru(1)*paru(5)/vint(2)
      if(mint(43).eq.4) comfac=comfac*fack
      if((mint(47).ge.2.or.(istsb.ge.3.and.istsb.le.5)).and.
     &istsb.ne.9) then
        atau1=log(taumax/taumin)
        atau2=(taumax-taumin)/(taumax*taumin)
        h1=coef(isub,1)+(atau1/atau2)*coef(isub,2)/tau
        if(mint(72).ge.1) then
          taur1=vint(73)
          gamr1=vint(74)
          ataud=log(taumax/taumin*(taumin+taur1)/(taumax+taur1))
          atau3=ataud/taur1
          if(ataud.gt.1e-6) h1=h1+(atau1/atau3)*coef(isub,3)/(tau+taur1)
          ataud=atan((taumax-taur1)/gamr1)-atan((taumin-taur1)/gamr1)
          atau4=ataud/gamr1
          if(ataud.gt.1e-6) h1=h1+
     &    (atau1/atau4)*coef(isub,4)*tau/((tau-taur1)**2+gamr1**2)
        endif
        if(mint(72).eq.2) then
          taur2=vint(75)
          gamr2=vint(76)
          ataud=log(taumax/taumin*(taumin+taur2)/(taumax+taur2))
          atau5=ataud/taur2
          if(ataud.gt.1e-6) h1=h1+(atau1/atau5)*coef(isub,5)/(tau+taur2)
          ataud=atan((taumax-taur2)/gamr2)-atan((taumin-taur2)/gamr2)
          atau6=ataud/gamr2
          if(ataud.gt.1e-6) h1=h1+
     &    (atau1/atau6)*coef(isub,6)*tau/((tau-taur2)**2+gamr2**2)
        endif
        if(mint(47).eq.5.and.(istsb.le.2.or.istsb.ge.6)) then
          atau7=log(max(2d-6,1.-taumin)/max(2d-6,1.-taumax))
          h1=h1+(atau1/atau7)*coef(isub,7)*tau/max(2d-6,1.-tau)
        endif
        comfac=comfac*atau1/(tau*h1)
      endif

c...phase space integral in y*.
      if(mint(47).ge.4.and.istsb.ne.9) then
        ayst0=ystmax-ystmin
        ayst1=0.5*(ystmax-ystmin)**2
        ayst2=ayst1
        ayst3=2.*(atan(exp(ystmax))-atan(exp(ystmin)))
        h2=(ayst0/ayst1)*coef(isub,8)*(yst-ystmin)+
     &  (ayst0/ayst2)*coef(isub,9)*(ystmax-yst)+
     &  (ayst0/ayst3)*coef(isub,10)/cosh(yst)
        if(mint(45).eq.3) then
          yst0=-0.5*log(taue)
          ayst4=log(max(1d-6,exp(yst0-ystmin)-1.)/
     &    max(1d-6,exp(yst0-ystmax)-1.))
          h2=h2+(ayst0/ayst4)*coef(isub,11)/max(1d-6,1.-exp(yst-yst0))
        endif
        if(mint(46).eq.3) then
          yst0=-0.5*log(taue)
          ayst5=log(max(1d-6,exp(yst0+ystmax)-1.)/
     &    max(1d-6,exp(yst0+ystmin)-1.))
          h2=h2+(ayst0/ayst5)*coef(isub,12)/max(1d-6,1.-exp(-yst-yst0))
        endif
        comfac=comfac*ayst0/h2
      endif

c...2 -> 1 processes: reduction in angular part of phase space integral
c...for case of decaying resonance.
      acth0=ctnmax-ctnmin+ctpmax-ctpmin
c      ///////////////////// if is divided into two if
      if((istsb.eq.1.or.istsb.eq.3.or.istsb.eq.5)) then
       if(mdcy(kfpr(isubsv,1),1).eq.1) then
         if(kfpr(isub,1).eq.25.or.kfpr(isub,1).eq.37.or.kfpr(isub,1).eq.
     &   39) then
          comfac=comfac*0.5*acth0
         else
           comfac=comfac*0.125*(3.*acth0+ctnmax**3-ctnmin**3+
     &     ctpmax**3-ctpmin**3)
         endif
       endif
c...2 -> 2 processes: angular part of phase space integral.
      elseif(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) then
        acth1=log((max(rm34,rsqm-ctnmin)*max(rm34,rsqm-ctpmin))/
     &  (max(rm34,rsqm-ctnmax)*max(rm34,rsqm-ctpmax)))
        acth2=log((max(rm34,rsqm+ctnmax)*max(rm34,rsqm+ctpmax))/
     &  (max(rm34,rsqm+ctnmin)*max(rm34,rsqm+ctpmin)))
        acth3=1./max(rm34,rsqm-ctnmax)-1./max(rm34,rsqm-ctnmin)+
     &  1./max(rm34,rsqm-ctpmax)-1./max(rm34,rsqm-ctpmin)
        acth4=1./max(rm34,rsqm+ctnmin)-1./max(rm34,rsqm+ctnmax)+
     &  1./max(rm34,rsqm+ctpmin)-1./max(rm34,rsqm+ctpmax)
        h3=coef(isub,13)+
     &  (acth0/acth1)*coef(isub,14)/max(rm34,rsqm-cth)+
     &  (acth0/acth2)*coef(isub,15)/max(rm34,rsqm+cth)+
     &  (acth0/acth3)*coef(isub,16)/max(rm34,rsqm-cth)**2+
     &  (acth0/acth4)*coef(isub,17)/max(rm34,rsqm+cth)**2
        comfac=comfac*acth0*0.5*be34/h3

c...2 -> 2 processes: take into account final state breit-wigners.
        comfac=comfac*vint(80)
      endif

c...2 -> 3, 4 processes: phace space integral in tau'.
      if(mint(47).ge.2.and.istsb.ge.3.and.istsb.le.5) then
        ataup1=log(taupmx/taupmn)
        ataup2=((1.-tau/taupmx)**4-(1.-tau/taupmn)**4)/(4.*tau)
        h4=coef(isub,18)+
     &  (ataup1/ataup2)*coef(isub,19)*(1.-tau/taup)**3/taup
        if(mint(47).eq.5) then
          ataup3=log(max(2d-6,1.-taupmn)/max(2d-6,1.-taupmx))
          h4=h4+(ataup1/ataup3)*coef(isub,20)*taup/max(2d-6,1.-taup)
        endif
        comfac=comfac*ataup1/h4
      endif

c...2 -> 3, 4 processes: effective w/z structure functions.
      if(istsb.eq.3.or.istsb.eq.4) then
        if(1.-tau/taup.gt.1.e-4) then
          fzw=(1.+tau/taup)*log(taup/tau)-2.*(1.-tau/taup)
        else
          fzw=1./6.*(1.-tau/taup)**3*tau/taup
        endif
        comfac=comfac*fzw
      endif

c...2 -> 3 processes: phase space integrals for pt1, pt2, y3, mirror.
      if(istsb.eq.5) then
        comfac=comfac*vint(205)*vint(210)*vint(212)*vint(214)/
     &  (128.*paru(1)**4*vint(220))*(tau**2/taup)
      endif

c...phase space integral for low-pt and multiple interactions.
      if(istsb.eq.9) then
        comfac=paru(1)*paru(5)*fack*0.5*vint(2)/sh2
        atau1=log(2.*(1.+sqrt(1.-xt2))/xt2-1.)
        atau2=2.*atan(1./xt2-1.)/sqrt(xt2)
        h1=coef(isub,1)+(atau1/atau2)*coef(isub,2)/sqrt(tau)
        comfac=comfac*atau1/h1
        ayst0=ystmax-ystmin
        ayst1=0.5*(ystmax-ystmin)**2
        ayst3=2.*(atan(exp(ystmax))-atan(exp(ystmin)))
        h2=(ayst0/ayst1)*coef(isub,8)*(yst-ystmin)+
     &  (ayst0/ayst1)*coef(isub,9)*(ystmax-yst)+
     &  (ayst0/ayst3)*coef(isub,10)/cosh(yst)
        comfac=comfac*ayst0/h2
        if(mstp(82).le.1) comfac=comfac*xt2**2*(1./vint(149)-1.)
c...for mstp(82)>=2 an additional factor (xt2/(xt2+vint(149))**2 is
c...introduced to make cross-section finite for xt2 -> 0.
        if(mstp(82).ge.2) comfac=comfac*xt2**2/(vint(149)*
     &  (1.+vint(149)))
      endif

c...strongly interacting z_l/w_l model of dobado, herrero, terron.
      if((mstp(46).ge.3.and.mstp(46).le.6).and.(isub.eq.71.or.isub.eq.
     &72.or.isub.eq.73.or.isub.eq.76.or.isub.eq.77)) then
c...calculate m_r and n_r functions for higgs-like and qcd-like models.
        if(mstp(46).le.4) then
          hdtlh=log(pmas(25,1)/parp(44))
          hdtmr=(4.5*paru(1)/sqrt(3.)-74./9.)/8.+hdtlh/12.
          hdtnr=-1./18.+hdtlh/6.
        else
          hdtnm=0.125*(1./(288.*paru(1)**2)+(246./parp(45))**2)
          hdtlq=log(parp(45)/parp(44))
          hdtmr=-(4.*paru(1))**2*0.5*hdtnm+hdtlq/12.
          hdtnr=(4.*paru(1))**2*hdtnm+hdtlq/6.
        endif

c...calculate lowest and next-to-lowest order partial wave amplitudes.
        hdtv=1./(16.*paru(1)*246.**2)
        a00l=hdtv*sh
        a20l=-0.5*a00l
        a11l=a00l/6.
        hdtls=log(sh/parp(44)**2)
        a004=(hdtv*sh)**2/(4.*paru(1))*cmplx((176.*hdtmr+112.*hdtnr)/3.+
     &  11./27.-(50./9.)*hdtls,4.*paru(1))
        a204=(hdtv*sh)**2/(4.*paru(1))*cmplx(32.*(hdtmr+2.*hdtnr)/3.+
     &  25./54.-(20./9.)*hdtls,paru(1))
        a114=(hdtv*sh)**2/(6.*paru(1))*cmplx(4.*(-2.*hdtmr+hdtnr)-
     &  1./18.,paru(1)/6.)

c...unitarize partial wave amplitudes with pade or k-matrix method.
        if(mstp(46).eq.3.or.mstp(46).eq.5) then
          a00u=a00l/(1.-a004/a00l)
          a20u=a20l/(1.-a204/a20l)
          a11u=a11l/(1.-a114/a11l)
        else
          a00u=(a00l+real(a004))/(1.-cmplx(0.d0,a00l+real(a004)))
          a20u=(a20l+real(a204))/(1.-cmplx(0.d0,a20l+real(a204)))
          a11u=(a11l+real(a114))/(1.-cmplx(0.d0,a11l+real(a114)))
        endif
      endif

c...a: 2 -> 1, tree diagrams.

  150 if(isub.le.10) then
      if(isub.eq.1) then
c...f + f~ -> gamma*/z0.
        mint(61)=2
        call pywidt(23,sh,wdtp,wdte)
        hp0=aem/3.*sh
        hp1=aem/3.*xwc*sh
        hs=hp1*wdtp(0)
        facz=4.*comfac*3.
        do 160 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 160
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        hi0=hp0
        if(iabs(i).le.10) hi0=hi0*faca/3.
        hi1=hp1
        if(iabs(i).le.10) hi1=hi1*faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facz*(ei**2/sh2*hi0*hp0*vint(111)+ei*vi*(1.-sqmz/sh)/
     &  ((sh-sqmz)**2+hs**2)*(hi0*hp1+hi1*hp0)*vint(112)+
     &  (vi**2+ai**2)/((sh-sqmz)**2+hs**2)*hi1*hp1*vint(114))
  160   continue

      elseif(isub.eq.2) then
c...f + f~' -> w+/-.
        call pywidt(24,sh,wdtp,wdte)
        hp=aem/(24.*xw)*sh
        hs=hp*wdtp(0)
        facbw=4.*comfac/((sh-sqmw)**2+hs**2)*3.
        do 180 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 180
        ia=iabs(i)
        do 170 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 170
        ja=iabs(j)
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 170
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 170
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        hi=hp*2.
        if(ia.le.10) hi=hi*vckm((ia+1)/2,(ja+1)/2)*faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        hf=hp*(wdte(0,1)+wdte(0,(5-kchw)/2)+wdte(0,4))
        sigh(nchn)=hi*facbw*hf
  170   continue
  180   continue

      elseif(isub.eq.3) then
c...f + f~ -> h0 (or h'0, or a0).
        call pywidt(kfhigg,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=4.*comfac/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        do 190 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 190
        ia=iabs(i)
        rmq=pmas(ia,1)**2/sh
        hi=hp*rmq
        if(ia.le.10) hi=hp*rmq*faca/3.
        if(ia.le.10.and.mstp(37).eq.1) hi=hi*
     &  (log(max(4.d0,parp(37)**2*rmq*sh/paru(117)**2))/
     &  log(max(4.d0,sh/paru(117)**2)))**(24./(33.-2.*mstu(118)))
        if(mstp(4).ge.1.or.ihigg.ge.2) then
          ikfi=1
          if(ia.le.10.and.mod(ia,2).eq.0) ikfi=2
          if(ia.gt.10) ikfi=3
          hi=hi*paru(150+10*ihigg+ikfi)**2
        endif
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
  190   continue

      elseif(isub.eq.4) then
c...gamma + w+/- -> w+/-.

      elseif(isub.eq.5) then
c...z0 + z0 -> h0.
        call pywidt(25,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=4.*comfac/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        hi=hp/4.
        faci=8./(paru(1)**2*(1.-xw))*(aem*xwc)**2
        do 210 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 210
        do 200 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 200
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        ej=kchg(iabs(j),1)/3.
        aj=sign(1.d0,ej)
        vj=aj-4.*ej*xw
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=faci*(vi**2+ai**2)*(vj**2+aj**2)*hi*facbw*hf
  200   continue
  210   continue

      elseif(isub.eq.6) then
c...z0 + w+/- -> w+/-.

      elseif(isub.eq.7) then
c...w+ + w- -> z0.

      elseif(isub.eq.8) then
c...w+ + w- -> h0.
        call pywidt(25,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=4.*comfac/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        hi=hp/2.
        faci=1./(4.*paru(1)**2)*(aem/xw)**2
        do 230 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 230
        ei=sign(1.0,float(i))*kchg(iabs(i),1)
        do 220 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 220
        ej=sign(1.0,float(j))*kchg(iabs(j),1)
        if(ei*ej.gt.0.) goto 220
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=faci*vint(180+i)*vint(180+j)*hi*facbw*hf
  220   continue
  230   continue
      endif

c...b: 2 -> 2, tree diagrams.

      elseif(isub.le.20) then
      if(isub.eq.11) then
c...f + f' -> f + f'.
c...gluon exchange (in t or s channel):
        facqq1=comfac*as**2*4./9.*(sh2+uh2)/th2
        facqqb=comfac*as**2*4./9.*((sh2+uh2)/th2*faca-
     &  mstp(34)*2./3.*uh2/(sh*th))
        facqq2=comfac*as**2*4./9.*((sh2+th2)/uh2-
     &  mstp(34)*2./3.*sh2/(th*uh))
c...gamma, gamma/z, z and w exchange (in t channel):
        facggf=comfac*aem**2*2.*(sh2+uh2)/th2
        facgzf=comfac*aem**2*xwc*4.*sh2/(th*(th-sqmz))
        faczzf=comfac*(aem*xwc)**2*2.*sh2/(th-sqmz)**2
        facwwf=comfac*(0.5*aem/xw)**2*sh2/(th-sqmw)**2
        do 250 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 250
        ia=iabs(i)
        do 240 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 240
        ja=iabs(j)

        if(ia.lt.10.and.ja.lt.10) then
c...gluon exchange.
          nchn=nchn+1
          isig(nchn,1)=i
          isig(nchn,2)=j
          isig(nchn,3)=1
          sigh(nchn)=facqq1
          if(i.eq.-j) sigh(nchn)=facqqb
          if(i.eq.j) then
            sigh(nchn)=0.5*sigh(nchn)
            nchn=nchn+1
            isig(nchn,1)=i
            isig(nchn,2)=j
            isig(nchn,3)=2
            sigh(nchn)=0.5*facqq2
          endif

        else
c...electroweak couplings.
          ei=kchg(ia,1)*isign(1,i)/3.
          ai=sign(1.,kchg(ia,1)+0.5)*isign(1,i)
          vi=ai-4.*ei*xw
          ej=kchg(ja,1)*isign(1,j)/3.
          aj=sign(1.,kchg(ja,1)+0.5)*isign(1,j)
          vj=aj-4.*ej*xw
          epsij=isign(1,i*j)
c...gamma/z exchange, only gamma exchange, or only z exchange.
          if(mstp(21).ge.1.and.mstp(21).le.4) then
            if(mstp(21).eq.1.or.mstp(21).eq.4) then
              facncf=facggf*ei**2*ej**2+facgzf*ei*ej*
     &        (vi*vj*(1.+uh2/sh2)+ai*aj*epsij*(1.-uh2/sh2))+
     &        faczzf*((vi**2+ai**2)*(vj**2+aj**2)*(1.+uh2/sh2)+
     &        4.*vi*vj*ai*aj*epsij*(1.-uh2/sh2))
            elseif(mstp(21).eq.2) then
              facncf=facggf*ei**2*ej**2
            else
              facncf=faczzf*((vi**2+ai**2)*(vj**2+aj**2)*(1.+uh2/sh2)+
     &        4.*vi*vj*ai*aj*epsij*(1.-uh2/sh2))
            endif
            nchn=nchn+1
            isig(nchn,1)=i
            isig(nchn,2)=j
            isig(nchn,3)=5
            sigh(nchn)=facncf
          endif
c...w exchange.
          if((mstp(21).eq.1.or.mstp(21).eq.5).and.ai*aj.lt.0.) then
            facccf=facwwf*vint(180+i)*vint(180+j)
            if(epsij.lt.0.) facccf=facccf*uh2/sh2
            if(ia.gt.10.and.mod(ia,2).eq.0) facccf=2.*facccf
            if(ja.gt.10.and.mod(ja,2).eq.0) facccf=2.*facccf
            nchn=nchn+1
            isig(nchn,1)=i
            isig(nchn,2)=j
            isig(nchn,3)=6
            sigh(nchn)=facccf
          endif
        endif
  240   continue
  250   continue

      elseif(isub.eq.12) then
c...f + f~ -> f' + f~' (q + q~ -> q' + q~' only).
        call pywidt(21,sh,wdtp,wdte)
        facqqb=comfac*as**2*4./9.*(th2+uh2)/sh2*(wdte(0,1)+wdte(0,2)+
     &  wdte(0,3)+wdte(0,4))
        do 260 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 260
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facqqb
  260   continue

      elseif(isub.eq.13) then
c...f + f~ -> g + g (q + q~ -> g + g only).
        facgg1=comfac*as**2*32./27.*(uh/th-(2.+mstp(34)*1./4.)*uh2/sh2)
        facgg2=comfac*as**2*32./27.*(th/uh-(2.+mstp(34)*1./4.)*th2/sh2)
        do 270 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 270
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=0.5*facgg1
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=2
        sigh(nchn)=0.5*facgg2
  270   continue

      elseif(isub.eq.14) then
c...f + f~ -> g + gamma (q + q~ -> g + gamma only).
        facgg=comfac*as*aem*8./9.*(th2+uh2)/(th*uh)
        do 280 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 280
        ei=kchg(iabs(i),1)/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facgg*ei**2
  280   continue

      elseif(isub.eq.15) then
c...f + f~ -> g + z0 (q + q~ -> g + z0 only).
        faczg=comfac*as*aem/(xw*(1.-xw))*1./18.*
     &  (th2+uh2+2.*sqm4*sh)/(th*uh)
        faczg=faczg*wids(23,2)
        do 290 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 290
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=faczg*(vi**2+ai**2)
  290   continue

      elseif(isub.eq.16) then
c...f + f~' -> g + w+/- (q + q~' -> g + w+/- only).
        facwg=comfac*as*aem/xw*2./9.*(th2+uh2+2.*sqm4*sh)/(th*uh)
        do 310 i=min1,max1
        ia=iabs(i)
        if(i.eq.0.or.ia.gt.10.or.kfac(1,i).eq.0) goto 310
        do 300 j=min2,max2
        ja=iabs(j)
        if(j.eq.0.or.ja.gt.10.or.kfac(2,j).eq.0) goto 300
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 300
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        fckm=vckm((ia+1)/2,(ja+1)/2)
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=facwg*fckm*wids(24,(5-kchw)/2)
  300   continue
  310   continue

      elseif(isub.eq.17) then
c...f + f~ -> g + h0 (q + q~ -> g + h0 only).

      elseif(isub.eq.18) then
c...f + f~ -> gamma + gamma.
        facgg=comfac*aem**2*2.*(th2+uh2)/(th*uh)
        do 320 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 320
        ei=kchg(iabs(i),1)/3.
        fcoi=1.
        if(iabs(i).le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=0.5*facgg*fcoi*ei**4
  320   continue

      elseif(isub.eq.19) then
c...f + f~ -> gamma + z0.
        facgz=comfac*2.*aem**2*xwc*(th2+uh2+2.*sqm4*sh)/(th*uh)
        facgz=facgz*wids(23,2)
        do 330 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 330
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        fcoi=1.
        if(iabs(i).le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facgz*fcoi*ei**2*(vi**2+ai**2)
  330   continue

      elseif(isub.eq.20) then
c...f + f~' -> gamma + w+/-.
        facgw=comfac*0.5*aem**2/xw*
     &  ((2.*uh-th)/(3.*(sh-sqm4)))**2*(th2+uh2+2.*sqm4*sh)/(th*uh)
        do 350 i=min1,max1
        ia=iabs(i)
        if(i.eq.0.or.ia.gt.20.or.kfac(1,i).eq.0) goto 350
        do 340 j=min2,max2
        ja=iabs(j)
        if(j.eq.0.or.ja.gt.20.or.kfac(2,j).eq.0) goto 340
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 340
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 340
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        fckm=1.
        if(ia.le.10) fckm=vckm((ia+1)/2,(ja+1)/2)
        fcoi=1.
        if(ia.le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=facgw*fcoi*fckm*wids(24,(5-kchw)/2)
  340   continue
  350   continue
      endif

      elseif(isub.le.30) then
      if(isub.eq.21) then
c...f + f~ -> gamma + h0.

      elseif(isub.eq.22) then
c...f + f~ -> (gamma*/z0) + (gamma*/z0).
c...kinematics dependence.
        faczz=comfac*aem**2*((th2+uh2+2.*(sqm3+sqm4)*sh)/(th*uh)-
     &  sqm3*sqm4*(1./th2+1./uh2))
c...gamma, gamma/z interference and z couplings to final fermion pairs.
        do 360 i=1,6
        do 360 j=1,3
  360   hgz(i,j)=0.
        hbw3=0.
        hbw4=0.
        radc3=1.+ulalps(sqm3)/paru(1)
        radc4=1.+ulalps(sqm4)/paru(1)
        do 370 i=1,min(16,mdcy(23,3))
        idc=i+mdcy(23,2)-1
        if(mdme(idc,1).lt.0) goto 370
        imdm=0
        if(mdme(idc,1).eq.1.or.mdme(idc,1).eq.2) imdm=1
        if(mdme(idc,1).eq.4.or.mdme(idc,1).eq.5) imdm=mdme(idc,1)-2
        if(i.le.8) then
          ef=kchg(i,1)/3.
          af=sign(1.d0,ef+0.1)
          vf=af-4.*ef*xw
        elseif(i.le.16) then
          ef=kchg(i+2,1)/3.
          af=sign(1.d0,ef+0.1)
          vf=af-4.*ef*xw
        endif
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sqm3
        if(4.*rm1.lt.1.) then
          fcof=1.
          if(i.le.8) fcof=3.*radc3
          be34=sqrt(max(0.d0,1.-4.*rm1))
          if(imdm.ge.1) then
            hgz(1,imdm)=hgz(1,imdm)+fcof*ef**2*(1.+2.*rm1)*be34
            hgz(2,imdm)=hgz(2,imdm)+fcof*ef*vf*(1.+2.*rm1)*be34
            hgz(3,imdm)=hgz(3,imdm)+fcof*(vf**2*(1.+2.*rm1)+
     &      af**2*(1.-4.*rm1))*be34
          endif
          hbw3=hbw3+fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
        endif
        rm1=pmas(iabs(kfdp(idc,1)),1)**2/sqm4
        if(4.*rm1.lt.1.) then
          fcof=1.
          if(i.le.8) fcof=3.*radc4
          be34=sqrt(max(0.d0,1.-4.*rm1))
          if(imdm.ge.1) then
            hgz(4,imdm)=hgz(4,imdm)+fcof*ef**2*(1.+2.*rm1)*be34
            hgz(5,imdm)=hgz(5,imdm)+fcof*ef*vf*(1.+2.*rm1)*be34
            hgz(6,imdm)=hgz(6,imdm)+fcof*(vf**2*(1.+2.*rm1)+
     &      af**2*(1.-4.*rm1))*be34
          endif
          hbw4=hbw4+fcof*(vf**2*(1.+2.*rm1)+af**2*(1.-4.*rm1))*be34
        endif
  370   continue
c...propagators: as simulated in pyofsh and as desired.
        gmmz=pmas(23,1)*pmas(23,2)
        hbw3=hbw3*xwc*sqmz/((sqm3-sqmz)**2+gmmz**2)
        hbw4=hbw4*xwc*sqmz/((sqm4-sqmz)**2+gmmz**2)
        mint(15)=1
        mint(61)=1
        call pywidt(23,sqm3,wdtp,wdte)
        do 380 j=1,3
        hgz(1,j)=hgz(1,j)*vint(111)/sqm3
        hgz(2,j)=hgz(2,j)*vint(112)/sqm3
  380   hgz(3,j)=hgz(3,j)*vint(114)/sqm3
        mint(61)=1
        call pywidt(23,sqm4,wdtp,wdte)
        do 390 j=1,3
        hgz(4,j)=hgz(4,j)*vint(111)/sqm4
        hgz(5,j)=hgz(5,j)*vint(112)/sqm4
  390   hgz(6,j)=hgz(6,j)*vint(114)/sqm4
c...loop over flavours; separate left- and right-handed couplings.
        do 410 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 410
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        vali=vi-ai
        vari=vi+ai
        fcoi=1.
        if(iabs(i).le.10) fcoi=faca/3.
        do 400 j=1,3
        hl3(j)=ei**2*hgz(1,j)+ei*vali*hgz(2,j)+vali**2*hgz(3,j)
        hr3(j)=ei**2*hgz(1,j)+ei*vari*hgz(2,j)+vari**2*hgz(3,j)
        hl4(j)=ei**2*hgz(4,j)+ei*vali*hgz(5,j)+vali**2*hgz(6,j)
  400   hr4(j)=ei**2*hgz(4,j)+ei*vari*hgz(5,j)+vari**2*hgz(6,j)
        faclr=hl3(1)*hl4(1)+hl3(1)*(hl4(2)+hl4(3))+
     &  hl4(1)*(hl3(2)+hl3(3))+hl3(2)*hl4(3)+hl4(2)*hl3(3)+
     &  hr3(1)*hr4(1)+hr3(1)*(hr4(2)+hr4(3))+
     &  hr4(1)*(hr3(2)+hr3(3))+hr3(2)*hr4(3)+hr4(2)*hr3(3)
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=0.5*faczz*fcoi*faclr/(hbw3*hbw4)
  410   continue

      elseif(isub.eq.23) then
c...f + f~' -> z0 + w+/-.
        faczw=comfac*0.5*(aem/xw)**2
        faczw=faczw*wids(23,2)
        thuh=max(th*uh-sqm3*sqm4,sh*ckin(3)**2)
        do 430 i=min1,max1
        ia=iabs(i)
        if(i.eq.0.or.ia.gt.20.or.kfac(1,i).eq.0) goto 430
        do 420 j=min2,max2
        ja=iabs(j)
        if(j.eq.0.or.ja.gt.20.or.kfac(2,j).eq.0) goto 420
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 420
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 420
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        ei=kchg(ia,1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        ej=kchg(ja,1)/3.
        aj=sign(1.d0,ej)
        vj=aj-4.*ej*xw
        if(vi+ai.gt.0) then
          visav=vi
          aisav=ai
          vi=vj
          ai=aj
          vj=visav
          aj=aisav
        endif
        fckm=1.
        if(ia.le.10) fckm=vckm((ia+1)/2,(ja+1)/2)
        fcoi=1.
        if(ia.le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=faczw*fcoi*fckm*(1./(sh-sqmw)**2*
     &  ((9.-8.*xw)/4.*thuh+(8.*xw-6.)/4.*sh*(sqm3+sqm4))+
     &  (thuh-sh*(sqm3+sqm4))/(2.*(sh-sqmw))*((vj+aj)/th-(vi+ai)/uh)+
     &  thuh/(16.*(1.-xw))*((vj+aj)**2/th2+(vi+ai)**2/uh2)+
     &  sh*(sqm3+sqm4)/(8.*(1.-xw))*(vi+ai)*(vj+aj)/(th*uh))*
     &  wids(24,(5-kchw)/2)
  420   continue
  430   continue

      elseif(isub.eq.24) then
c...f + f~ -> z0 + h0 (or h'0, or a0).
        thuh=max(th*uh-sqm3*sqm4,sh*ckin(3)**2)
        fachz=comfac*8.*(aem*xwc)**2*
     &  (thuh+2.*sh*sqmz)/((sh-sqmz)**2+sqmz*pmas(23,2)**2)
        fachz=fachz*wids(23,2)*wids(kfhigg,2)
        if(mstp(4).ge.1.or.ihigg.ge.2) fachz=fachz*
     &  paru(154+10*ihigg)**2
        do 440 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 440
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        fcoi=1.
        if(iabs(i).le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=fachz*fcoi*(vi**2+ai**2)
  440   continue

      elseif(isub.eq.25) then
c...f + f~ -> w+ + w-.
        thuh=max(th*uh-sqm3*sqm4,sh*ckin(3)**2)
        facww=comfac*0.25*(aem/xw)**2
        facww=facww*wids(24,1)
        do 450 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 450
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        fcoi=1.
        if(iabs(i).le.10) fcoi=faca/3.
        dsigww=thuh/sh2*(3.-(sh-3.*(sqm3+sqm4))/(sh-sqmz)*
     &  (vi+ai)/(2.*ai*(1.-xw))+(sh/(sh-sqmz))**2*
     &  (1.-2.*(sqm3+sqm4)/sh+12.*sqm3*sqm4/sh2)*(vi**2+ai**2)/
     &  (8.*(1.-xw)**2))-2.*sqmz/(sh-sqmz)*(vi+ai)/ai+
     &  sqmz*sh/(sh-sqmz)**2*(1.-2.*(sqm3+sqm4)/sh)*(vi**2+ai**2)/
     &  (2.*(1.-xw))
        if(kchg(iabs(i),1).lt.0) then
          dsigww=dsigww+2.*(1.+sqmz/(sh-sqmz)*(vi+ai)/(2.*ai))*
     &    (thuh/(sh*th)-(sqm3+sqm4)/th)+thuh/th2
        else
          dsigww=dsigww+2.*(1.+sqmz/(sh-sqmz)*(vi+ai)/(2.*ai))*
     &    (thuh/(sh*uh)-(sqm3+sqm4)/uh)+thuh/uh2
        endif
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facww*fcoi*dsigww
  450   continue

      elseif(isub.eq.26) then
c...f + f~' -> w+/- + h0 (or h'0, or a0).
        thuh=max(th*uh-sqm3*sqm4,sh*ckin(3)**2)
        fachw=comfac*0.125*(aem/xw)**2*(thuh+2.*sh*sqmw)/
     &  ((sh-sqmw)**2+sqmw*pmas(24,2)**2)
        fachw=fachw*wids(kfhigg,2)
        if(mstp(4).ge.1.or.ihigg.ge.2) fachw=fachw*
     &  paru(155+10*ihigg)**2
        do 470 i=min1,max1
        ia=iabs(i)
        if(i.eq.0.or.ia.gt.20.or.kfac(1,i).eq.0) goto 470
        do 460 j=min2,max2
        ja=iabs(j)
        if(j.eq.0.or.ja.gt.20.or.kfac(1,j).eq.0) goto 460
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 460
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 460
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        fckm=1.
        if(ia.le.10) fckm=vckm((ia+1)/2,(ja+1)/2)
        fcoi=1.
        if(ia.le.10) fcoi=faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=fachw*fcoi*fckm*wids(24,(5-kchw)/2)
  460   continue
  470   continue

      elseif(isub.eq.27) then
c...f + f~ -> h0 + h0.

      elseif(isub.eq.28) then
c...f + g -> f + g (q + g -> q + g only).
        facqg1=comfac*as**2*4./9.*((2.+mstp(34)*1./4.)*uh2/th2-uh/sh)*
     &  faca
        facqg2=comfac*as**2*4./9.*((2.+mstp(34)*1./4.)*sh2/th2-sh/uh)
        do 490 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.10) goto 490
        do 480 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 480
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 480
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=facqg1
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=2
        sigh(nchn)=facqg2
  480   continue
  490   continue

      elseif(isub.eq.29) then
c...f + g -> f + gamma (q + g -> q + gamma only).
        fgq=comfac*faca*as*aem*1./3.*(sh2+uh2)/(-sh*uh)
        do 510 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54)) goto 510
        ei=kchg(iabs(i),1)/3.
        facgq=fgq*ei**2
        do 500 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 500
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 500
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=facgq
  500   continue
  510   continue

      elseif(isub.eq.30) then
c...f + g -> f + z0 (q + g -> q + z0 only).
        fzq=comfac*faca*as*aem*xwc*1./3.*
     &  (sh2+uh2+2.*sqm4*th)/(-sh*uh)
        fzq=fzq*wids(23,2)
        do 530 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54)) goto 530
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        faczq=fzq*(vi**2+ai**2)
        do 520 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 520
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 520
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=faczq
  520   continue
  530   continue
      endif

      elseif(isub.le.40) then
      if(isub.eq.31) then
c...f + g -> f' + w+/- (q + g -> q' + w+/- only).
        facwq=comfac*faca*as*aem/xw*1./12.*
     &  (sh2+uh2+2.*sqm4*th)/(-sh*uh)
        do 550 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54)) goto 550
        ia=iabs(i)
        kchw=isign(1,kchg(ia,1)*isign(1,i))
        do 540 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 540
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 540
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=facwq*vint(180+i)*wids(24,(5-kchw)/2)
  540   continue
  550   continue

      elseif(isub.eq.32) then
c...f + g -> f + h0 (q + g -> q + h0 only).

      elseif(isub.eq.33) then
c...f + gamma -> f + g (q + gamma -> q + g only).
        fgq=comfac*as*aem*8./3.*(sh2+uh2)/(-sh*uh)
        do 570 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54)) goto 570
        ei=kchg(iabs(i),1)/3.
        facgq=fgq*ei**2
        do 560 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,22).eq.0) goto 560
        if(isde.eq.2.and.kfac(1,22)*kfac(2,i).eq.0) goto 560
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=22
        isig(nchn,3)=1
        sigh(nchn)=facgq
  560   continue
  570   continue

      elseif(isub.eq.34) then
c...f + gamma -> f + gamma.
        fgq=comfac*aem**2*2.*(sh2+uh2)/(-sh*uh)
        do 590 i=mina,maxa
        if(i.eq.0) goto 590
        ei=kchg(iabs(i),1)/3.
        facgq=fgq*ei**4
        do 580 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,22).eq.0) goto 580
        if(isde.eq.2.and.kfac(1,22)*kfac(2,i).eq.0) goto 580
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=22
        isig(nchn,3)=1
        sigh(nchn)=facgq
  580   continue
  590   continue

      elseif(isub.eq.35) then
c...f + gamma -> f + z0.
        fzq=comfac*aem**2*xwc*2.*
     &  (sh2+uh2+2.*sqm4*th)/(sqpth*sqm4-sh*uh)
        fzq=fzq*wids(23,2)
        do 610 i=mina,maxa
        if(i.eq.0) goto 610
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        faczq=fzq*ei**2*(vi**2+ai**2)
        do 600 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,22).eq.0) goto 600
        if(isde.eq.2.and.kfac(1,22)*kfac(2,i).eq.0) goto 600
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=22
        isig(nchn,3)=1
        sigh(nchn)=faczq
  600   continue
  610   continue

      elseif(isub.eq.36) then
c...f + gamma -> f' + w+/-.
        fwq=comfac*aem**2/(2.*xw)*
     &  (sh2+uh2+2.*sqm4*th)/(sqpth*sqm4-sh*uh)
        do 630 i=mina,maxa
        if(i.eq.0) goto 630
        ia=iabs(i)
        eia=abs(kchg(iabs(i),1)/3.)
        facwq=fwq*(eia-sh/(sh+uh))**2
        kchw=isign(1,kchg(ia,1)*isign(1,i))
        do 620 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,22).eq.0) goto 620
        if(isde.eq.2.and.kfac(1,22)*kfac(2,i).eq.0) goto 620
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=22
        isig(nchn,3)=1
        sigh(nchn)=facwq*vint(180+i)*wids(24,(5-kchw)/2)
  620   continue
  630   continue

      elseif(isub.eq.37) then
c...f + gamma -> f + h0.

      elseif(isub.eq.38) then
c...f + z0 -> f + g (q + z0 -> q + g only).

      elseif(isub.eq.39) then
c...f + z0 -> f + gamma.

      elseif(isub.eq.40) then
c...f + z0 -> f + z0.
      endif

      elseif(isub.le.50) then
      if(isub.eq.41) then
c...f + z0 -> f' + w+/-.

      elseif(isub.eq.42) then
c...f + z0 -> f + h0.

      elseif(isub.eq.43) then
c...f + w+/- -> f' + g (q + w+/- -> q' + g only).

      elseif(isub.eq.44) then
c...f + w+/- -> f' + gamma.

      elseif(isub.eq.45) then
c...f + w+/- -> f' + z0.

      elseif(isub.eq.46) then
c...f + w+/- -> f' + w+/-.

      elseif(isub.eq.47) then
c...f + w+/- -> f' + h0.

      elseif(isub.eq.48) then
c...f + h0 -> f + g (q + h0 -> q + g only).

      elseif(isub.eq.49) then
c...f + h0 -> f + gamma.

      elseif(isub.eq.50) then
c...f + h0 -> f + z0.
      endif

      elseif(isub.le.60) then
      if(isub.eq.51) then
c...f + h0 -> f' + w+/-.

      elseif(isub.eq.52) then
c...f + h0 -> f + h0.

      elseif(isub.eq.53) then
c...g + g -> f + f~ (g + g -> q + q~ only).
        call pywidt(21,sh,wdtp,wdte)
        facqq1=comfac*as**2*1./6.*(uh/th-(2.+mstp(34)*1./4.)*uh2/sh2)*
     &  (wdte(0,1)+wdte(0,2)+wdte(0,3)+wdte(0,4))*faca
        facqq2=comfac*as**2*1./6.*(th/uh-(2.+mstp(34)*1./4.)*th2/sh2)*
     &  (wdte(0,1)+wdte(0,2)+wdte(0,3)+wdte(0,4))*faca
        if(kfac(1,21)*kfac(2,21).eq.0) goto 640
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        sigh(nchn)=facqq1
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=2
        sigh(nchn)=facqq2
  640   continue

      elseif(isub.eq.54) then
c...g + gamma -> f + f~ (g + gamma -> q + q~ only).
        call pywidt(21,sh,wdtp,wdte)
        wdtesu=0.
        do 650 i=1,min(8,mdcy(21,3))
        ef=kchg(i,1)/3.
  650   wdtesu=wdtesu+ef**2*(wdte(i,1)+wdte(i,2)+wdte(i,3)+wdte(i,4))
        facqq=comfac*aem*as*wdtesu*(th2+uh2)/(th*uh)
        if(kfac(1,21)*kfac(2,22).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=21
          isig(nchn,2)=22
          isig(nchn,3)=1
          sigh(nchn)=facqq
        endif
        if(kfac(1,22)*kfac(2,21).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=22
          isig(nchn,2)=21
          isig(nchn,3)=1
          sigh(nchn)=facqq
        endif

      elseif(isub.eq.55) then
c...g + z -> f + f~ (g + z -> q + q~ only).

      elseif(isub.eq.56) then
c...g + w -> f + f'~ (g + w -> q + q'~ only).

      elseif(isub.eq.57) then
c...g + h0 -> f + f~ (g + h0 -> q + q~ only).

      elseif(isub.eq.58) then
c...gamma + gamma -> f + f~.
        call pywidt(22,sh,wdtp,wdte)
        wdtesu=0.
        do 660 i=1,min(12,mdcy(22,3))
        if(i.le.8) ef= kchg(i,1)/3.
        if(i.ge.9) ef= kchg(9+2*(i-8),1)/3.
  660   wdtesu=wdtesu+ef**2*(wdte(i,1)+wdte(i,2)+wdte(i,3)+wdte(i,4))
        facff=comfac*aem**2*wdtesu*2.*(th2+uh2)/(th*uh)
        if(kfac(1,22)*kfac(2,22).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=22
          isig(nchn,2)=22
          isig(nchn,3)=1
          sigh(nchn)=facff
        endif

      elseif(isub.eq.59) then
c...gamma + z0 -> f + f~.

      elseif(isub.eq.60) then
c...gamma + w+/- -> f + f~'.
      endif

      elseif(isub.le.70) then
      if(isub.eq.61) then
c...gamma + h0 -> f + f~.

      elseif(isub.eq.62) then
c...z0 + z0 -> f + f~.

      elseif(isub.eq.63) then
c...z0 + w+/- -> f + f~'.

      elseif(isub.eq.64) then
c...z0 + h0 -> f + f~.

      elseif(isub.eq.65) then
c...w+ + w- -> f + f~.

      elseif(isub.eq.66) then
c...w+/- + h0 -> f + f~'.

      elseif(isub.eq.67) then
c...h0 + h0 -> f + f~.

      elseif(isub.eq.68) then
c...g + g -> g + g.
        facgg1=comfac*as**2*9./4.*(sh2/th2+2.*sh/th+3.+2.*th/sh+
     &  th2/sh2)*faca
        facgg2=comfac*as**2*9./4.*(uh2/sh2+2.*uh/sh+3.+2.*sh/uh+
     &  sh2/uh2)*faca
        facgg3=comfac*as**2*9./4.*(th2/uh2+2.*th/uh+3+2.*uh/th+uh2/th2)
        if(kfac(1,21)*kfac(2,21).eq.0) goto 670
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        sigh(nchn)=0.5*facgg1
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=2
        sigh(nchn)=0.5*facgg2
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=3
        sigh(nchn)=0.5*facgg3
  670   continue

      elseif(isub.eq.69) then
c...gamma + gamma -> w+ + w-.
        sqmwe=max(0.5*sqmw,sqrt(sqm3*sqm4))
        fprop=sh2/((sqmwe-th)*(sqmwe-uh))
        facww=comfac*6.*aem**2*(1.-fprop*(4./3.+2.*sqmwe/sh)+
     &  fprop**2*(2./3.+2.*(sqmwe/sh)**2))*wids(24,1)
        if(kfac(1,22)*kfac(2,22).eq.0) goto 680
        nchn=nchn+1
        isig(nchn,1)=22
        isig(nchn,2)=22
        isig(nchn,3)=1
        sigh(nchn)=facww
  680   continue

      elseif(isub.eq.70) then
c...gamma + w+/- -> z0 + w+/-.
        sqmwe=max(0.5*sqmw,sqrt(sqm3*sqm4))
        fprop=(th-sqmwe)**2/(-sh*(sqmwe-uh))
        faczw=comfac*6.*aem**2*((1.-xw)/xw)*
     &  (1.-fprop*(4./3.+2.*sqmwe/(th-sqmwe))+
     &  fprop**2*(2./3.+2.*(sqmwe/(th-sqmwe))**2))*wids(23,2)
        do 700 kchw=1,-1,-2
        do 690 isde=1,2
        if(kfac(isde,22)*kfac(3-isde,24*kchw).eq.0) goto 690
        nchn=nchn+1
        isig(nchn,isde)=22
        isig(nchn,3-isde)=24*kchw
        isig(nchn,3)=1
        sigh(nchn)=faczw*wids(24,(5-kchw)/2)
  690   continue
  700   continue
      endif

      elseif(isub.le.80) then
      if(isub.eq.71) then
c...z0 + z0 -> z0 + z0.
        if(sh.le.4.01*sqmz) goto 730

        if(mstp(46).le.2) then
c...exact scattering me:s for on-mass-shell gauge bosons.
          be2=1.-4.*sqmz/sh
          th=-0.5*sh*be2*(1.-cth)
          uh=-0.5*sh*be2*(1.+cth)
          if(max(th,uh).gt.-1.) goto 730
          shang=1./(1.-xw)*sqmw/sqmz*(1.+be2)**2
          ashre=(sh-sqmh)/((sh-sqmh)**2+gmmh**2)*shang
          ashim=-gmmh/((sh-sqmh)**2+gmmh**2)*shang
          thang=1./(1.-xw)*sqmw/sqmz*(be2-cth)**2
          athre=(th-sqmh)/((th-sqmh)**2+gmmh**2)*thang
          athim=-gmmh/((th-sqmh)**2+gmmh**2)*thang
          uhang=1./(1.-xw)*sqmw/sqmz*(be2+cth)**2
          auhre=(uh-sqmh)/((uh-sqmh)**2+gmmh**2)*uhang
          auhim=-gmmh/((uh-sqmh)**2+gmmh**2)*uhang
          faczz=comfac*1./(4096.*paru(1)**2*16.*(1.-xw)**2)*
     &    (aem/xw)**4*(sh/sqmw)**2*(sqmz/sqmw)*sh2
          if(mstp(46).le.0) faczz=faczz*(ashre**2+ashim**2)
          if(mstp(46).eq.1) faczz=faczz*((ashre+athre+auhre)**2+
     &    (ashim+athim+auhim)**2)
          if(mstp(46).eq.2) faczz=0.

        else
c...strongly interacting z_l/w_l model of dobado, herrero, terron.
          faczz=comfac*(aem/(16.*paru(1)*xw*(1.-xw)))**2*(64./9.)*
     &    abs(a00u+2.*a20u)**2
        endif
        faczz=faczz*wids(23,1)

        do 720 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 720
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        avi=ai**2+vi**2
        do 710 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 710
        ej=kchg(iabs(j),1)/3.
        aj=sign(1.d0,ej)
        vj=aj-4.*ej*xw
        avj=aj**2+vj**2
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=0.5*faczz*avi*avj
  710   continue
  720   continue
  730   continue

      elseif(isub.eq.72) then
c...z0 + z0 -> w+ + w-.
        if(sh.le.4.01*sqmz) goto 760

        if(mstp(46).le.2) then
c...exact scattering me:s for on-mass-shell gauge bosons.
          be2=sqrt((1.-4.*sqmw/sh)*(1.-4.*sqmz/sh))
          cth2=cth**2
          th=-0.5*sh*(1.-2.*(sqmw+sqmz)/sh-be2*cth)
          uh=-0.5*sh*(1.-2.*(sqmw+sqmz)/sh+be2*cth)
          if(max(th,uh).gt.-1.) goto 760
          shang=4.*sqrt(sqmw/(sqmz*(1.-xw)))*(1.-2.*sqmw/sh)*
     &    (1.-2.*sqmz/sh)
          ashre=(sh-sqmh)/((sh-sqmh)**2+gmmh**2)*shang
          ashim=-gmmh/((sh-sqmh)**2+gmmh**2)*shang
          atwre=(1.-xw)/sqmz*sh/(th-sqmw)*((cth-be2)**2*(3./2.+be2/2.*
     &    cth-(sqmw+sqmz)/sh+(sqmw-sqmz)**2/(sh*sqmw))+4.*((sqmw+sqmz)/
     &    sh*(1.-3.*cth2)+8.*sqmw*sqmz/sh2*(2.*cth2-1.)+
     &    4.*(sqmw**2+sqmz**2)/sh2*cth2+2.*(sqmw+sqmz)/sh*be2*cth))
          atwim=0.
          auwre=(1.-xw)/sqmz*sh/(uh-sqmw)*((cth+be2)**2*(3./2.-be2/2.*
     &    cth-(sqmw+sqmz)/sh+(sqmw-sqmz)**2/(sh*sqmw))+4.*((sqmw+sqmz)/
     &    sh*(1.-3.*cth2)+8.*sqmw*sqmz/sh2*(2.*cth2-1.)+
     &    4.*(sqmw**2+sqmz**2)/sh2*cth2-2.*(sqmw+sqmz)/sh*be2*cth))
          auwim=0.
          a4re=2.*(1.-xw)/sqmz*(3.-cth2-4.*(sqmw+sqmz)/sh)
          a4im=0.
          facww=comfac*1./(4096.*paru(1)**2*16.*(1.-xw)**2)*
     &    (aem/xw)**4*(sh/sqmw)**2*(sqmz/sqmw)*sh2
          if(mstp(46).le.0) facww=facww*(ashre**2+ashim**2)
          if(mstp(46).eq.1) facww=facww*((ashre+atwre+auwre+a4re)**2+
     &    (ashim+atwim+auwim+a4im)**2)
          if(mstp(46).eq.2) facww=facww*((atwre+auwre+a4re)**2+
     &    (atwim+auwim+a4im)**2)

        else
c...strongly interacting z_l/w_l model of dobado, herrero, terron.
          facww=comfac*(aem/(16.*paru(1)*xw*(1.-xw)))**2*(64./9.)*
     &    abs(a00u-a20u)**2
        endif
        facww=facww*wids(24,1)

        do 750 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 750
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        avi=ai**2+vi**2
        do 740 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 740
        ej=kchg(iabs(j),1)/3.
        aj=sign(1.d0,ej)
        vj=aj-4.*ej*xw
        avj=aj**2+vj**2
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=facww*avi*avj
  740   continue
  750   continue
  760   continue

      elseif(isub.eq.73) then
c...z0 + w+/- -> z0 + w+/-.
        if(sh.le.2.*sqmz+2.*sqmw) goto 790

        if(mstp(46).le.2) then
c...exact scattering me:s for on-mass-shell gauge bosons.
          be2=1.-2.*(sqmz+sqmw)/sh+((sqmz-sqmw)/sh)**2
          ep1=1.-(sqmz-sqmw)/sh
          ep2=1.+(sqmz-sqmw)/sh
          th=-0.5*sh*be2*(1.-cth)
          uh=(sqmz-sqmw)**2/sh-0.5*sh*be2*(1.+cth)
          if(max(th,uh).gt.-1.) goto 790
          thang=(be2-ep1*cth)*(be2-ep2*cth)
          athre=(th-sqmh)/((th-sqmh)**2+gmmh**2)*thang
          athim=-gmmh/((th-sqmh)**2+gmmh**2)*thang
          aswre=-(1.-xw)/sqmz*sh/(sh-sqmw)*(-be2*(ep1+ep2)**4*cth+
     &    1./4.*(be2+ep1*ep2)**2*((ep1-ep2)**2-4.*be2*cth)+
     &    2.*be2*(be2+ep1*ep2)*(ep1+ep2)**2*cth-
     &    1./16.*sh/sqmw*(ep1**2-ep2**2)**2*(be2+ep1*ep2)**2)
          aswim=0.
          auwre=(1.-xw)/sqmz*sh/(uh-sqmw)*(-be2*(ep2+ep1*cth)*
     &    (ep1+ep2*cth)*(be2+ep1*ep2)+be2*(ep2+ep1*cth)*
     &    (be2+ep1*ep2*cth)*(2.*ep2-ep2*cth+ep1)-be2*(ep2+ep1*cth)**2*
     &    (be2-ep2**2*cth)-1./8.*(be2+ep1*ep2*cth)**2*((ep1+ep2)**2+
     &    2.*be2*(1.-cth))+1./32.*sh/sqmw*(be2+ep1*ep2*cth)**2*
     &    (ep1**2-ep2**2)**2-be2*(ep1+ep2*cth)*(ep2+ep1*cth)*
     &    (be2+ep1*ep2)+be2*(ep1+ep2*cth)*(be2+ep1*ep2*cth)*
     &    (2.*ep1-ep1*cth+ep2)-be2*(ep1+ep2*cth)**2*(be2-ep1**2*cth)-
     &    1./8.*(be2+ep1*ep2*cth)**2*((ep1+ep2)**2+2.*be2*(1.-cth))+
     &    1./32.*sh/sqmw*(be2+ep1*ep2*cth)**2*(ep1**2-ep2**2)**2)
          auwim=0.
          a4re=(1.-xw)/sqmz*(ep1**2*ep2**2*(cth**2-1.)-
     &    2.*be2*(ep1**2+ep2**2+ep1*ep2)*cth-2.*be2*ep1*ep2)
          a4im=0.
          faczw=comfac*1./(4096.*paru(1)**2*4.*(1.-xw))*(aem/xw)**4*
     &    (sh/sqmw)**2*sqrt(sqmz/sqmw)*sh2
          if(mstp(46).le.0) faczw=0.
          if(mstp(46).eq.1) faczw=faczw*((athre+aswre+auwre+a4re)**2+
     &    (athim+aswim+auwim+a4im)**2)
          if(mstp(46).eq.2) faczw=faczw*((aswre+auwre+a4re)**2+
     &    (aswim+auwim+a4im)**2)

        else
c...strongly interacting z_l/w_l model of dobado, herrero, terron.
          faczw=comfac*aem**2/(64.*paru(1)**2*xw**2*(1.-xw))*16.*
     &    abs(a20u+3.*a11u*cth)**2
        endif
        faczw=faczw*wids(23,2)

        do 780 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 780
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        avi=ai**2+vi**2
        kchwi=isign(1,kchg(iabs(i),1)*isign(1,i))
        do 770 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 770
        ej=kchg(iabs(j),1)/3.
        aj=sign(1.d0,ej)
        vj=ai-4.*ej*xw
        avj=aj**2+vj**2
        kchwj=isign(1,kchg(iabs(j),1)*isign(1,j))
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=faczw*(avi*vint(180+j)*wids(24,(5-kchwj)/2)+
     &  vint(180+i)*wids(24,(5-kchwi)/2)*avj)
  770   continue
  780   continue
  790   continue

      elseif(isub.eq.75) then
c...w+ + w- -> gamma + gamma.

      elseif(isub.eq.76) then
c...w+ + w- -> z0 + z0.
        if(sh.le.4.01*sqmz) goto 820

        if(mstp(46).le.2) then
c...exact scattering me:s for on-mass-shell gauge bosons.
          be2=sqrt((1.-4.*sqmw/sh)*(1.-4.*sqmz/sh))
          cth2=cth**2
          th=-0.5*sh*(1.-2.*(sqmw+sqmz)/sh-be2*cth)
          uh=-0.5*sh*(1.-2.*(sqmw+sqmz)/sh+be2*cth)
          if(max(th,uh).gt.-1.) goto 820
          shang=4.*sqrt(sqmw/(sqmz*(1.-xw)))*(1.-2.*sqmw/sh)*
     &    (1.-2.*sqmz/sh)
          ashre=(sh-sqmh)/((sh-sqmh)**2+gmmh**2)*shang
          ashim=-gmmh/((sh-sqmh)**2+gmmh**2)*shang
          atwre=(1.-xw)/sqmz*sh/(th-sqmw)*((cth-be2)**2*(3./2.+be2/2.*
     &    cth-(sqmw+sqmz)/sh+(sqmw-sqmz)**2/(sh*sqmw))+4.*((sqmw+sqmz)/
     &    sh*(1.-3.*cth2)+8.*sqmw*sqmz/sh2*(2.*cth2-1.)+
     &    4.*(sqmw**2+sqmz**2)/sh2*cth2+2.*(sqmw+sqmz)/sh*be2*cth))
          atwim=0.
          auwre=(1.-xw)/sqmz*sh/(uh-sqmw)*((cth+be2)**2*(3./2.-be2/2.*
     &    cth-(sqmw+sqmz)/sh+(sqmw-sqmz)**2/(sh*sqmw))+4.*((sqmw+sqmz)/
     &    sh*(1.-3.*cth2)+8.*sqmw*sqmz/sh2*(2.*cth2-1.)+
     &    4.*(sqmw**2+sqmz**2)/sh2*cth2-2.*(sqmw+sqmz)/sh*be2*cth))
          auwim=0.
          a4re=2.*(1.-xw)/sqmz*(3.-cth2-4.*(sqmw+sqmz)/sh)
          a4im=0.
          faczz=comfac*1./(4096.*paru(1)**2)*(aem/xw)**4*
     &    (sh/sqmw)**2*sh2
          if(mstp(46).le.0) faczz=faczz*(ashre**2+ashim**2)
          if(mstp(46).eq.1) faczz=faczz*((ashre+atwre+auwre+a4re)**2+
     &    (ashim+atwim+auwim+a4im)**2)
          if(mstp(46).eq.2) faczz=faczz*((atwre+auwre+a4re)**2+
     &    (atwim+auwim+a4im)**2)

        else
c...strongly interacting z_l/w_l model of dobado, herrero, terron.
          faczz=comfac*(aem/(4.*paru(1)*xw))**2*(64./9.)*
     &    abs(a00u-a20u)**2
        endif
        faczz=faczz*wids(23,1)

        do 810 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 810
        ei=sign(1.,float(i))*kchg(iabs(i),1)
        do 800 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 800
        ej=sign(1.,float(j))*kchg(iabs(j),1)
        if(ei*ej.gt.0.) goto 800
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=0.5*faczz*vint(180+i)*vint(180+j)
  800   continue
  810   continue
  820   continue

      elseif(isub.eq.77) then
c...w+/- + w+/- -> w+/- + w+/-.
        if(sh.le.4.01*sqmw) goto 850

        if(mstp(46).le.2) then
c...exact scattering me:s for on-mass-shell gauge bosons.
          be2=1.-4.*sqmw/sh
          be4=be2**2
          cth2=cth**2
          cth3=cth**3
          th=-0.5*sh*be2*(1.-cth)
          uh=-0.5*sh*be2*(1.+cth)
          if(max(th,uh).gt.-1.) goto 850
          shang=(1.+be2)**2
          ashre=(sh-sqmh)/((sh-sqmh)**2+gmmh**2)*shang
          ashim=-gmmh/((sh-sqmh)**2+gmmh**2)*shang
          thang=(be2-cth)**2
          athre=(th-sqmh)/((th-sqmh)**2+gmmh**2)*thang
          athim=-gmmh/((th-sqmh)**2+gmmh**2)*thang
          uhang=(be2+cth)**2
          auhre=(uh-sqmh)/((uh-sqmh)**2+gmmh**2)*uhang
          auhim=-gmmh/((uh-sqmh)**2+gmmh**2)*uhang
          sgzang=1./sqmw*be2*(3.-be2)**2*cth
          asgre=xw*sgzang
          asgim=0.
          aszre=(1.-xw)*sh/(sh-sqmz)*sgzang
          aszim=0.
          tgzang=1./sqmw*(be2*(4.-2.*be2+be4)+be2*(4.-10.*be2+be4)*cth+
     &    (2.-11.*be2+10.*be4)*cth2+be2*cth3)
          atgre=0.5*xw*sh/th*tgzang
          atgim=0.
          atzre=0.5*(1.-xw)*sh/(th-sqmz)*tgzang
          atzim=0.
          ugzang=1./sqmw*(be2*(4.-2.*be2+be4)-be2*(4.-10.*be2+be4)*cth+
     &    (2.-11.*be2+10.*be4)*cth2-be2*cth3)
          augre=0.5*xw*sh/uh*ugzang
          augim=0.
          auzre=0.5*(1.-xw)*sh/(uh-sqmz)*ugzang
          auzim=0.
          a4re=1./sqmw*(1.+2.*be2-6.*be2*cth-cth2)
          a4im=0.
          fww=comfac*1./(4096.*paru(1)**2)*(aem/xw)**4*(sh/sqmw)**2*sh2
          if(mstp(46).le.0) then
            awware=ashre
            awwaim=ashim
            awwsre=0.
            awwsim=0.
          elseif(mstp(46).eq.1) then
            awware=ashre+athre+asgre+aszre+atgre+atzre+a4re
            awwaim=ashim+athim+asgim+aszim+atgim+atzim+a4im
            awwsre=athre+auhre+atgre+atzre+augre+auzre
            awwsim=athim+auhim+atgim+atzim+augim+auzim
          else
            awware=asgre+aszre+atgre+atzre+a4re
            awwaim=asgim+aszim+atgim+atzim+a4im
            awwsre=atgre+atzre+augre+auzre
            awwsim=atgim+atzim+augim+auzim
          endif
          awwa2=awware**2+awwaim**2
          awws2=awwsre**2+awwsim**2

        else
c...strongly interacting z_l/w_l model of dobado, herrero, terron.
          fwwa=comfac*(aem/(4.*paru(1)*xw))**2*(64./9.)*
     &    abs(a00u+0.5*a20u+4.5*a11u*cth)**2
          fwws=comfac*(aem/(4.*paru(1)*xw))**2*64.*abs(a20u)**2
        endif

        do 840 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 840
        ei=sign(1.,float(i))*kchg(iabs(i),1)
        do 830 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 830
        ej=sign(1.,float(j))*kchg(iabs(j),1)
        if(ei*ej.lt.0.) then
c...w+w-
          if(mstp(45).eq.1) goto 830
          if(mstp(46).le.2) facww=fww*awwa2*wids(24,1)
          if(mstp(46).ge.3) facww=fwwa*wids(24,1)
        else
c...w+w+/w-w-
          if(mstp(45).eq.2) goto 830
          if(mstp(46).le.2) facww=fww*awws2
          if(mstp(46).ge.3) facww=fwws
          if(ei.gt.0.) facww=facww*vint(91)
          if(ei.lt.0.) facww=facww*vint(92)
        endif
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=facww*vint(180+i)*vint(180+j)
        if(ei*ej.gt.0.) sigh(nchn)=0.5*sigh(nchn)
  830   continue
  840   continue
  850   continue

      elseif(isub.eq.78) then
c...w+/- + h0 -> w+/- + h0.

      elseif(isub.eq.79) then
c...h0 + h0 -> h0 + h0.

      endif

c...c: 2 -> 2, tree diagrams with masses.

      elseif(isub.le.90) then
      if(isub.eq.81) then
c...q + q~ -> q + q~.
        facqqb=comfac*as**2*4./9.*(((th-sqm3)**2+
     &  (uh-sqm3)**2)/sh2+2.*sqm3/sh)
        if(mstp(35).ge.1) then
          if(mstp(35).eq.1) then
            alssg=parp(35)
          else
            mst115=mstu(115)
            mstu(115)=mstp(36)
            q2bn=sqrt(sqm3*((sqrt(sh)-2.*sqrt(sqm3))**2+parp(36)**2))
            alssg=ulalps(q2bn)
            mstu(115)=mst115
          endif
          xrepu=paru(1)*alssg/(6.*sqrt(max(1d-20,1.-4.*sqm3/sh)))
          frepu=xrepu/(exp(min(87.d0,xrepu))-1.)
          vint(138)=frepu
          facqqb=facqqb*frepu
        endif
        do 860 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 860
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facqqb
  860   continue

      elseif(isub.eq.82) then
c...g + g -> q + q~.
        facqq1=comfac*faca*as**2*1./6.*((uh-sqm3)/(th-sqm3)-
     &  2.*(uh-sqm3)**2/sh2+4.*sqm3/sh*(th*uh-sqm3**2)/(th-sqm3)**2)
        facqq2=comfac*faca*as**2*1./6.*((th-sqm3)/(uh-sqm3)-
     &  2.*(th-sqm3)**2/sh2+4.*sqm3/sh*(th*uh-sqm3**2)/(uh-sqm3)**2)
        if(mstp(35).ge.1) then
          if(mstp(35).eq.1) then
            alssg=parp(35)
          else
            mst115=mstu(115)
            mstu(115)=mstp(36)
            q2bn=sqrt(sqm3*((sqrt(sh)-2.*sqrt(sqm3))**2+parp(36)**2))
            alssg=ulalps(q2bn)
            mstu(115)=mst115
          endif
          xattr=4.*paru(1)*alssg/(3.*sqrt(max(1d-20,1.-4.*sqm3/sh)))
          fattr=xattr/(1.-exp(-min(87.d0,xattr)))
          xrepu=paru(1)*alssg/(6.*sqrt(max(1d-20,1.-4.*sqm3/sh)))
          frepu=xrepu/(exp(min(87.d0,xrepu))-1.)
          fatre=(2.*fattr+5.*frepu)/7.
          vint(138)=fatre
          facqq1=facqq1*fatre
          facqq2=facqq2*fatre
        endif
        if(kfac(1,21)*kfac(2,21).eq.0) goto 870
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        sigh(nchn)=facqq1
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=2
        sigh(nchn)=facqq2
  870   continue

      elseif(isub.eq.83) then
c...f + q -> f' + q.
        facqqs=comfac*(0.5*aem/xw)**2*sh*(sh-sqm3)/(sqmw-th)**2
        facqqu=comfac*(0.5*aem/xw)**2*uh*(uh-sqm3)/(sqmw-th)**2
        do 890 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 890
        do 880 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 880
        if(i*j.gt.0.and.mod(iabs(i+j),2).eq.0) goto 880
        if(i*j.lt.0.and.mod(iabs(i+j),2).eq.1) goto 880
        if(iabs(i).lt.mint(55).and.mod(iabs(i+mint(55)),2).eq.1) then
          nchn=nchn+1
          isig(nchn,1)=i
          isig(nchn,2)=j
          isig(nchn,3)=1
          if(mod(mint(55),2).eq.0) facckm=vckm(mint(55)/2,
     &    (iabs(i)+1)/2)*vint(180+j)
          if(mod(mint(55),2).eq.1) facckm=vckm(iabs(i)/2,
     &    (mint(55)+1)/2)*vint(180+j)
          if(i*j.gt.0) sigh(nchn)=facqqs*facckm
          if(i*j.lt.0) sigh(nchn)=facqqu*facckm
        endif
        if(iabs(j).lt.mint(55).and.mod(iabs(j+mint(55)),2).eq.1) then
          nchn=nchn+1
          isig(nchn,1)=i
          isig(nchn,2)=j
          isig(nchn,3)=2
          if(mod(mint(55),2).eq.0) facckm=vckm(mint(55)/2,
     &    (iabs(j)+1)/2)*vint(180+i)
          if(mod(mint(55),2).eq.1) facckm=vckm(iabs(j)/2,
     &    (mint(55)+1)/2)*vint(180+i)
          if(i*j.gt.0) sigh(nchn)=facqqs*facckm
          if(i*j.lt.0) sigh(nchn)=facqqu*facckm
        endif
  880   continue
  890   continue

      elseif(isub.eq.84) then
c...g + gamma -> q + q~.
        fmtu=sqm3/(sqm3-th)+sqm3/(sqm3-uh)
        facqq=comfac*as*aem*(kchg(iabs(mint(55)),1)/3.)**2*
     &  ((sqm3-th)/(sqm3-uh)+(sqm3-uh)/(sqm3-th)+4.*fmtu*(1.-fmtu))
        if(mstp(35).ge.1) then
          if(mstp(35).eq.1) then
            alssg=parp(35)
          else
            mst115=mstu(115)
            mstu(115)=mstp(36)
            q2bn=sqrt(sqm3*((sqrt(sh)-2.*sqrt(sqm3))**2+parp(36)**2))
            alssg=ulalps(q2bn)
            mstu(115)=mst115
          endif
          xrepu=paru(1)*alssg/(6.*sqrt(max(1d-20,1.-4.*sqm3/sh)))
          frepu=xrepu/(exp(min(87.d0,xrepu))-1.)
          vint(138)=frepu
          facqq=facqq*frepu
        endif
        if(kfac(1,21)*kfac(2,22).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=21
          isig(nchn,2)=22
          isig(nchn,3)=1
          sigh(nchn)=facqq
        endif
        if(kfac(1,22)*kfac(2,21).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=22
          isig(nchn,2)=21
          isig(nchn,3)=1
          sigh(nchn)=facqq2
        endif

      elseif(isub.eq.85) then
c...gamma + gamma -> f + f~ (heavy fermion, quark or lepton).
        fmtu=sqm3/(sqm3-th)+sqm3/(sqm3-uh)
        facff=comfac*aem**2*(kchg(iabs(mint(56)),1)/3.)**4*2.*
     &  ((sqm3-th)/(sqm3-uh)+(sqm3-uh)/(sqm3-th)+4.*fmtu*(1.-fmtu))
        if(iabs(mint(56)).lt.10) facff=3.*facff
        if(iabs(mint(56)).lt.10.and.mstp(35).ge.1) then
          if(mstp(35).eq.1) then
            alssg=parp(35)
          else
            mst115=mstu(115)
            mstu(115)=mstp(36)
            q2bn=sqrt(sqm3*((sqrt(sh)-2.*sqrt(sqm3))**2+parp(36)**2))
            alssg=ulalps(q2bn)
            mstu(115)=mst115
          endif
          xattr=4.*paru(1)*alssg/(3.*sqrt(max(1d-20,1.-4.*sqm3/sh)))
          fattr=xattr/(1.-exp(-min(87.d0,xattr)))
          vint(138)=fattr
          facff=facff*fattr
        endif
        if(kfac(1,22)*kfac(2,22).ne.0) then
          nchn=nchn+1
          isig(nchn,1)=22
          isig(nchn,2)=22
          isig(nchn,3)=1
          sigh(nchn)=facff
        endif
      endif

c...d: mimimum bias processes.

      elseif(isub.le.100) then
      if(isub.eq.91) then
c...elastic scattering.
        sigs=xsec(isub,1)

      elseif(isub.eq.92) then
c...single diffractive scattering.
        sigs=xsec(isub,1)

      elseif(isub.eq.93) then
c...double diffractive scattering.
        sigs=xsec(isub,1)

      elseif(isub.eq.94) then
c...central diffractive scattering.
        sigs=xsec(isub,1)

      elseif(isub.eq.95) then
c...low-pt scattering.
        sigs=xsec(isub,1)

      elseif(isub.eq.96) then
c...multiple interactions: sum of qcd processes.
        call pywidt(21,sh,wdtp,wdte)

c...q + q' -> q + q'.
        facqq1=comfac*as**2*4./9.*(sh2+uh2)/th2
        facqqb=comfac*as**2*4./9.*((sh2+uh2)/th2*faca-
     &  mstp(34)*2./3.*uh2/(sh*th))
        facqq2=comfac*as**2*4./9.*((sh2+th2)/uh2-
     &  mstp(34)*2./3.*sh2/(th*uh))
        do 910 i=-3,3
        if(i.eq.0) goto 910
        do 900 j=-3,3
        if(j.eq.0) goto 900
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=111
        sigh(nchn)=facqq1
        if(i.eq.-j) sigh(nchn)=facqqb
        if(i.eq.j) then
          sigh(nchn)=0.5*sigh(nchn)
          nchn=nchn+1
          isig(nchn,1)=i
          isig(nchn,2)=j
          isig(nchn,3)=112
          sigh(nchn)=0.5*facqq2
        endif
  900   continue
  910   continue

c...q + q~ -> q' + q~' or g + g.
        facqqb=comfac*as**2*4./9.*(th2+uh2)/sh2*(wdte(0,1)+wdte(0,2)+
     &  wdte(0,3)+wdte(0,4))
        facgg1=comfac*as**2*32./27.*(uh/th-(2.+mstp(34)*1./4.)*uh2/sh2)
        facgg2=comfac*as**2*32./27.*(th/uh-(2.+mstp(34)*1./4.)*th2/sh2)
        do 920 i=-3,3
        if(i.eq.0) goto 920
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=121
        sigh(nchn)=facqqb
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=131
        sigh(nchn)=0.5*facgg1
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=132
        sigh(nchn)=0.5*facgg2
  920   continue

c...q + g -> q + g.
        facqg1=comfac*as**2*4./9.*((2.+mstp(34)*1./4.)*uh2/th2-uh/sh)*
     &  faca
        facqg2=comfac*as**2*4./9.*((2.+mstp(34)*1./4.)*sh2/th2-sh/uh)
        do 940 i=-3,3
        if(i.eq.0) goto 940
        do 930 isde=1,2
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=281
        sigh(nchn)=facqg1
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=282
        sigh(nchn)=facqg2
  930   continue
  940   continue

c...g + g -> q + q~ or g + g.
        facqq1=comfac*as**2*1./6.*(uh/th-(2.+mstp(34)*1./4.)*uh2/sh2)*
     &  (wdte(0,1)+wdte(0,2)+wdte(0,3)+wdte(0,4))*faca
        facqq2=comfac*as**2*1./6.*(th/uh-(2.+mstp(34)*1./4.)*th2/sh2)*
     &  (wdte(0,1)+wdte(0,2)+wdte(0,3)+wdte(0,4))*faca
        facgg1=comfac*as**2*9./4.*(sh2/th2+2.*sh/th+3.+2.*th/sh+
     &  th2/sh2)*faca
        facgg2=comfac*as**2*9./4.*(uh2/sh2+2.*uh/sh+3.+2.*sh/uh+
     &  sh2/uh2)*faca
        facgg3=comfac*as**2*9./4.*(th2/uh2+2.*th/uh+3+2.*uh/th+uh2/th2)
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=531
        sigh(nchn)=facqq1
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=532
        sigh(nchn)=facqq2
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=681
        sigh(nchn)=0.5*facgg1
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=682
        sigh(nchn)=0.5*facgg2
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=683
        sigh(nchn)=0.5*facgg3
      endif

c...e: 2 -> 1, loop diagrams.

      elseif(isub.le.110) then
      if(isub.eq.101) then
c...g + g -> gamma*/z0.

      elseif(isub.eq.102) then
c...g + g -> h0 (or h'0, or a0).
        call pywidt(kfhigg,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=4.*comfac/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        hi=hp*wdtp(13)/32.
        if(kfac(1,21)*kfac(2,21).eq.0) goto 950
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
  950   continue

      elseif(isub.eq.103) then
c...gamma + gamma -> h0 (or h'0, or a0).
        call pywidt(kfhigg,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=4.*comfac/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        hi=hp*wdtp(14)*2.
        if(kfac(1,22)*kfac(2,22).eq.0) goto 960
        nchn=nchn+1
        isig(nchn,1)=22
        isig(nchn,2)=22
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
  960   continue

      endif

c...f: 2 -> 2, box diagrams.

      elseif(isub.le.120) then
      if(isub.eq.111) then
c...f + f~ -> g + h0 (q + q~ -> g + h0 only).
        a5stur=0.
        a5stui=0.
        do 970 i=1,2*mstp(1)
        sqmq=pmas(i,1)**2
        epss=4.*sqmq/sh
        epsh=4.*sqmq/sqmh
        call pywaux(1,epss,w1sr,w1si)
        call pywaux(1,epsh,w1hr,w1hi)
        call pywaux(2,epss,w2sr,w2si)
        call pywaux(2,epsh,w2hr,w2hi)
        a5stur=a5stur+epsh*(1.+sh/(th+uh)*(w1sr-w1hr)+
     &  (0.25-sqmq/(th+uh))*(w2sr-w2hr))
        a5stui=a5stui+epsh*(sh/(th+uh)*(w1si-w1hi)+
     &  (0.25-sqmq/(th+uh))*(w2si-w2hi))
  970   continue
        facgh=comfac*faca/(144.*paru(1)**2)*aem/xw*as**3*sqmh/sqmw*
     &  sqmh/sh*(uh**2+th**2)/(uh+th)**2*(a5stur**2+a5stui**2)
        facgh=facgh*wids(25,2)
        do 980 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 980
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=facgh
  980   continue

      elseif(isub.eq.112) then
c...f + g -> f + h0 (q + g -> q + h0 only).
        a5tsur=0.
        a5tsui=0.
        do 990 i=1,2*mstp(1)
        sqmq=pmas(i,1)**2
        epst=4.*sqmq/th
        epsh=4.*sqmq/sqmh
        call pywaux(1,epst,w1tr,w1ti)
        call pywaux(1,epsh,w1hr,w1hi)
        call pywaux(2,epst,w2tr,w2ti)
        call pywaux(2,epsh,w2hr,w2hi)
        a5tsur=a5tsur+epsh*(1.+th/(sh+uh)*(w1tr-w1hr)+
     &  (0.25-sqmq/(sh+uh))*(w2tr-w2hr))
        a5tsui=a5tsui+epsh*(th/(sh+uh)*(w1ti-w1hi)+
     &  (0.25-sqmq/(sh+uh))*(w2ti-w2hi))
  990   continue
        facqh=comfac*faca/(384.*paru(1)**2)*aem/xw*as**3*sqmh/sqmw*
     &  sqmh/(-th)*(uh**2+sh**2)/(uh+sh)**2*(a5tsur**2+a5tsui**2)
        facqh=facqh*wids(25,2)
        do 1010 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54)) goto 1010
        do 1000 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 1000
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 1000
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=facqh
 1000   continue
 1010   continue

      elseif(isub.eq.113) then
c...g + g -> g + h0.
        a2stur=0.
        a2stui=0.
        a2ustr=0.
        a2usti=0.
        a2tusr=0.
        a2tusi=0.
        a4stur=0.
        a4stui=0.
        do 1020 i=1,2*mstp(1)
        sqmq=pmas(i,1)**2
        epss=4.*sqmq/sh
        epst=4.*sqmq/th
        epsu=4.*sqmq/uh
        epsh=4.*sqmq/sqmh
        if(epsh.lt.1.e-6) goto 1020
        call pywaux(1,epss,w1sr,w1si)
        call pywaux(1,epst,w1tr,w1ti)
        call pywaux(1,epsu,w1ur,w1ui)
        call pywaux(1,epsh,w1hr,w1hi)
        call pywaux(2,epss,w2sr,w2si)
        call pywaux(2,epst,w2tr,w2ti)
        call pywaux(2,epsu,w2ur,w2ui)
        call pywaux(2,epsh,w2hr,w2hi)
        call pyi3au(epss,th/uh,y3stur,y3stui)
        call pyi3au(epss,uh/th,y3sutr,y3suti)
        call pyi3au(epst,sh/uh,y3tsur,y3tsui)
        call pyi3au(epst,uh/sh,y3tusr,y3tusi)
        call pyi3au(epsu,sh/th,y3ustr,y3usti)
        call pyi3au(epsu,th/sh,y3utsr,y3utsi)
        call pyi3au(epsh,sqmh/sh*th/uh,yhstur,yhstui)
        call pyi3au(epsh,sqmh/sh*uh/th,yhsutr,yhsuti)
        call pyi3au(epsh,sqmh/th*sh/uh,yhtsur,yhtsui)
        call pyi3au(epsh,sqmh/th*uh/sh,yhtusr,yhtusi)
        call pyi3au(epsh,sqmh/uh*sh/th,yhustr,yhusti)
        call pyi3au(epsh,sqmh/uh*th/sh,yhutsr,yhutsi)
        w3stur=yhstur-y3stur-y3utsr
        w3stui=yhstui-y3stui-y3utsi
        w3sutr=yhsutr-y3sutr-y3tusr
        w3suti=yhsuti-y3suti-y3tusi
        w3tsur=yhtsur-y3tsur-y3ustr
        w3tsui=yhtsui-y3tsui-y3usti
        w3tusr=yhtusr-y3tusr-y3sutr
        w3tusi=yhtusi-y3tusi-y3suti
        w3ustr=yhustr-y3ustr-y3tsur
        w3usti=yhusti-y3usti-y3tsui
        w3utsr=yhutsr-y3utsr-y3stur
        w3utsi=yhutsi-y3utsi-y3stui
        b2stur=sqmq/sqmh**2*(sh*(uh-sh)/(sh+uh)+2.*th*uh*(uh+2.*sh)/
     &  (sh+uh)**2*(w1tr-w1hr)+(sqmq-sh/4.)*(0.5*w2sr+0.5*w2hr-w2tr+
     &  w3stur)+sh2*(2.*sqmq/(sh+uh)**2-0.5/(sh+uh))*(w2tr-w2hr)+
     &  0.5*th*uh/sh*(w2hr-2.*w2tr)+0.125*(sh-12.*sqmq-4.*th*uh/sh)*
     &  w3tsur)
        b2stui=sqmq/sqmh**2*(2.*th*uh*(uh+2.*sh)/(sh+uh)**2*
     &  (w1ti-w1hi)+(sqmq-sh/4.)*(0.5*w2si+0.5*w2hi-w2ti+w3stui)+
     &  sh2*(2.*sqmq/(sh+uh)**2-0.5/(sh+uh))*(w2ti-w2hi)+0.5*th*uh/sh*
     &  (w2hi-2.*w2ti)+0.125*(sh-12.*sqmq-4.*th*uh/sh)*w3tsui)
        b2sutr=sqmq/sqmh**2*(sh*(th-sh)/(sh+th)+2.*uh*th*(th+2.*sh)/
     &  (sh+th)**2*(w1ur-w1hr)+(sqmq-sh/4.)*(0.5*w2sr+0.5*w2hr-w2ur+
     &  w3sutr)+sh2*(2.*sqmq/(sh+th)**2-0.5/(sh+th))*(w2ur-w2hr)+
     &  0.5*uh*th/sh*(w2hr-2.*w2ur)+0.125*(sh-12.*sqmq-4.*uh*th/sh)*
     &  w3ustr)
        b2suti=sqmq/sqmh**2*(2.*uh*th*(th+2.*sh)/(sh+th)**2*
     &  (w1ui-w1hi)+(sqmq-sh/4.)*(0.5*w2si+0.5*w2hi-w2ui+w3suti)+
     &  sh2*(2.*sqmq/(sh+th)**2-0.5/(sh+th))*(w2ui-w2hi)+0.5*uh*th/sh*
     &  (w2hi-2.*w2ui)+0.125*(sh-12.*sqmq-4.*uh*th/sh)*w3usti)
        b2tsur=sqmq/sqmh**2*(th*(uh-th)/(th+uh)+2.*sh*uh*(uh+2.*th)/
     &  (th+uh)**2*(w1sr-w1hr)+(sqmq-th/4.)*(0.5*w2tr+0.5*w2hr-w2sr+
     &  w3tsur)+th2*(2.*sqmq/(th+uh)**2-0.5/(th+uh))*(w2sr-w2hr)+
     &  0.5*sh*uh/th*(w2hr-2.*w2sr)+0.125*(th-12.*sqmq-4.*sh*uh/th)*
     &  w3stur)
        b2tsui=sqmq/sqmh**2*(2.*sh*uh*(uh+2.*th)/(th+uh)**2*
     &  (w1si-w1hi)+(sqmq-th/4.)*(0.5*w2ti+0.5*w2hi-w2si+w3tsui)+
     &  th2*(2.*sqmq/(th+uh)**2-0.5/(th+uh))*(w2si-w2hi)+0.5*sh*uh/th*
     &  (w2hi-2.*w2si)+0.125*(th-12.*sqmq-4.*sh*uh/th)*w3stui)
        b2tusr=sqmq/sqmh**2*(th*(sh-th)/(th+sh)+2.*uh*sh*(sh+2.*th)/
     &  (th+sh)**2*(w1ur-w1hr)+(sqmq-th/4.)*(0.5*w2tr+0.5*w2hr-w2ur+
     &  w3tusr)+th2*(2.*sqmq/(th+sh)**2-0.5/(th+sh))*(w2ur-w2hr)+
     &  0.5*uh*sh/th*(w2hr-2.*w2ur)+0.125*(th-12.*sqmq-4.*uh*sh/th)*
     &  w3utsr)
        b2tusi=sqmq/sqmh**2*(2.*uh*sh*(sh+2.*th)/(th+sh)**2*
     &  (w1ui-w1hi)+(sqmq-th/4.)*(0.5*w2ti+0.5*w2hi-w2ui+w3tusi)+
     &  th2*(2.*sqmq/(th+sh)**2-0.5/(th+sh))*(w2ui-w2hi)+0.5*uh*sh/th*
     &  (w2hi-2.*w2ui)+0.125*(th-12.*sqmq-4.*uh*sh/th)*w3utsi)
        b2ustr=sqmq/sqmh**2*(uh*(th-uh)/(uh+th)+2.*sh*th*(th+2.*uh)/
     &  (uh+th)**2*(w1sr-w1hr)+(sqmq-uh/4.)*(0.5*w2ur+0.5*w2hr-w2sr+
     &  w3ustr)+uh2*(2.*sqmq/(uh+th)**2-0.5/(uh+th))*(w2sr-w2hr)+
     &  0.5*sh*th/uh*(w2hr-2.*w2sr)+0.125*(uh-12.*sqmq-4.*sh*th/uh)*
     &  w3sutr)
        b2usti=sqmq/sqmh**2*(2.*sh*th*(th+2.*uh)/(uh+th)**2*
     &  (w1si-w1hi)+(sqmq-uh/4.)*(0.5*w2ui+0.5*w2hi-w2si+w3usti)+
     &  uh2*(2.*sqmq/(uh+th)**2-0.5/(uh+th))*(w2si-w2hi)+0.5*sh*th/uh*
     &  (w2hi-2.*w2si)+0.125*(uh-12.*sqmq-4.*sh*th/uh)*w3suti)
        b2utsr=sqmq/sqmh**2*(uh*(sh-uh)/(uh+sh)+2.*th*sh*(sh+2.*uh)/
     &  (uh+sh)**2*(w1tr-w1hr)+(sqmq-uh/4.)*(0.5*w2ur+0.5*w2hr-w2tr+
     &  w3utsr)+uh2*(2.*sqmq/(uh+sh)**2-0.5/(uh+sh))*(w2tr-w2hr)+
     &  0.5*th*sh/uh*(w2hr-2.*w2tr)+0.125*(uh-12.*sqmq-4.*th*sh/uh)*
     &  w3tusr)
        b2utsi=sqmq/sqmh**2*(2.*th*sh*(sh+2.*uh)/(uh+sh)**2*
     &  (w1ti-w1hi)+(sqmq-uh/4.)*(0.5*w2ui+0.5*w2hi-w2ti+w3utsi)+
     &  uh2*(2.*sqmq/(uh+sh)**2-0.5/(uh+sh))*(w2ti-w2hi)+0.5*th*sh/uh*
     &  (w2hi-2.*w2ti)+0.125*(uh-12.*sqmq-4.*th*sh/uh)*w3tusi)
        b4stur=0.25*epsh*(-2./3.+0.25*(epsh-1.)*(w2sr-w2hr+w3stur))
        b4stui=0.25*epsh*0.25*(epsh-1.)*(w2si-w2hi+w3stui)
        b4tusr=0.25*epsh*(-2./3.+0.25*(epsh-1.)*(w2tr-w2hr+w3tusr))
        b4tusi=0.25*epsh*0.25*(epsh-1.)*(w2ti-w2hi+w3tusi)
        b4ustr=0.25*epsh*(-2./3.+0.25*(epsh-1.)*(w2ur-w2hr+w3ustr))
        b4usti=0.25*epsh*0.25*(epsh-1.)*(w2ui-w2hi+w3usti)
        a2stur=a2stur+b2stur+b2sutr
        a2stui=a2stui+b2stui+b2suti
        a2ustr=a2ustr+b2ustr+b2utsr
        a2usti=a2usti+b2usti+b2utsi
        a2tusr=a2tusr+b2tusr+b2tsur
        a2tusi=a2tusi+b2tusi+b2tsui
        a4stur=a4stur+b4stur+b4ustr+b4tusr
        a4stui=a4stui+b4stui+b4usti+b4tusi
 1020   continue
        facgh=comfac*faca*3./(128.*paru(1)**2)*aem/xw*as**3*
     &  sqmh/sqmw*sqmh**3/(sh*th*uh)*(a2stur**2+a2stui**2+a2ustr**2+
     &  a2usti**2+a2tusr**2+a2tusi**2+a4stur**2+a4stui**2)
        facgh=facgh*wids(25,2)
        if(kfac(1,21)*kfac(2,21).eq.0) goto 1030
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        sigh(nchn)=facgh
 1030   continue

      elseif(isub.eq.114.or.isub.eq.115) then
c...g + g -> gamma + gamma or g + g -> g + gamma.
        a0stur=0.
        a0stui=0.
        a0tsur=0.
        a0tsui=0.
        a0utsr=0.
        a0utsi=0.
        a1stur=0.
        a1stui=0.
        a2stur=0.
        a2stui=0.
        alst=log(-sh/th)
        alsu=log(-sh/uh)
        altu=log(th/uh)
        imax=2*mstp(1)
        if(mstp(38).ge.1.and.mstp(38).le.8) imax=mstp(38)
        do 1040 i=1,imax
        ei=kchg(iabs(i),1)/3.
        eiwt=ei**2
        if(isub.eq.115) eiwt=ei
        sqmq=pmas(i,1)**2
        epss=4.*sqmq/sh
        epst=4.*sqmq/th
        epsu=4.*sqmq/uh
        if((mstp(38).ge.1.and.mstp(38).le.8).or.epss.lt.1.e-4) then
          b0stur=1.+(th-uh)/sh*altu+0.5*(th2+uh2)/sh2*(altu**2+
     &    paru(1)**2)
          b0stui=0.
          b0tsur=1.+(sh-uh)/th*alsu+0.5*(sh2+uh2)/th2*alsu**2
          b0tsui=-paru(1)*((sh-uh)/th+(sh2+uh2)/th2*alsu)
          b0utsr=1.+(sh-th)/uh*alst+0.5*(sh2+th2)/uh2*alst**2
          b0utsi=-paru(1)*((sh-th)/uh+(sh2+th2)/uh2*alst)
          b1stur=-1.
          b1stui=0.
          b2stur=-1.
          b2stui=0.
        else
          call pywaux(1,epss,w1sr,w1si)
          call pywaux(1,epst,w1tr,w1ti)
          call pywaux(1,epsu,w1ur,w1ui)
          call pywaux(2,epss,w2sr,w2si)
          call pywaux(2,epst,w2tr,w2ti)
          call pywaux(2,epsu,w2ur,w2ui)
          call pyi3au(epss,th/uh,y3stur,y3stui)
          call pyi3au(epss,uh/th,y3sutr,y3suti)
          call pyi3au(epst,sh/uh,y3tsur,y3tsui)
          call pyi3au(epst,uh/sh,y3tusr,y3tusi)
          call pyi3au(epsu,sh/th,y3ustr,y3usti)
          call pyi3au(epsu,th/sh,y3utsr,y3utsi)
          b0stur=1.+(1.+2.*th/sh)*w1tr+(1.+2.*uh/sh)*w1ur+
     &    0.5*((th2+uh2)/sh2-epss)*(w2tr+w2ur)-
     &    0.25*epst*(1.-0.5*epss)*(y3sutr+y3tusr)-
     &    0.25*epsu*(1.-0.5*epss)*(y3stur+y3utsr)+
     &    0.25*(-2.*(th2+uh2)/sh2+4.*epss+epst+epsu+0.5*epst*epsu)*
     &    (y3tsur+y3ustr)
          b0stui=(1.+2.*th/sh)*w1ti+(1.+2.*uh/sh)*w1ui+
     &    0.5*((th2+uh2)/sh2-epss)*(w2ti+w2ui)-
     &    0.25*epst*(1.-0.5*epss)*(y3suti+y3tusi)-
     &    0.25*epsu*(1.-0.5*epss)*(y3stui+y3utsi)+
     &    0.25*(-2.*(th2+uh2)/sh2+4.*epss+epst+epsu+0.5*epst*epsu)*
     &    (y3tsui+y3usti)
          b0tsur=1.+(1.+2.*sh/th)*w1sr+(1.+2.*uh/th)*w1ur+
     &    0.5*((sh2+uh2)/th2-epst)*(w2sr+w2ur)-
     &    0.25*epss*(1.-0.5*epst)*(y3tusr+y3sutr)-
     &    0.25*epsu*(1.-0.5*epst)*(y3tsur+y3ustr)+
     &    0.25*(-2.*(sh2+uh2)/th2+4.*epst+epss+epsu+0.5*epss*epsu)*
     &    (y3stur+y3utsr)
          b0tsui=(1.+2.*sh/th)*w1si+(1.+2.*uh/th)*w1ui+
     &    0.5*((sh2+uh2)/th2-epst)*(w2si+w2ui)-
     &    0.25*epss*(1.-0.5*epst)*(y3tusi+y3suti)-
     &    0.25*epsu*(1.-0.5*epst)*(y3tsui+y3usti)+
     &    0.25*(-2.*(sh2+uh2)/th2+4.*epst+epss+epsu+0.5*epss*epsu)*
     &    (y3stui+y3utsi)
          b0utsr=1.+(1.+2.*th/uh)*w1tr+(1.+2.*sh/uh)*w1sr+
     &    0.5*((th2+sh2)/uh2-epsu)*(w2tr+w2sr)-
     &    0.25*epst*(1.-0.5*epsu)*(y3ustr+y3tsur)-
     &    0.25*epss*(1.-0.5*epsu)*(y3utsr+y3stur)+
     &    0.25*(-2.*(th2+sh2)/uh2+4.*epsu+epst+epss+0.5*epst*epss)*
     &    (y3tusr+y3sutr)
          b0utsi=(1.+2.*th/uh)*w1ti+(1.+2.*sh/uh)*w1si+
     &    0.5*((th2+sh2)/uh2-epsu)*(w2ti+w2si)-
     &    0.25*epst*(1.-0.5*epsu)*(y3usti+y3tsui)-
     &    0.25*epss*(1.-0.5*epsu)*(y3utsi+y3stui)+
     &    0.25*(-2.*(th2+sh2)/uh2+4.*epsu+epst+epss+0.5*epst*epss)*
     &    (y3tusi+y3suti)
          b1stur=-1.-0.25*(epss+epst+epsu)*(w2sr+w2tr+w2ur)+
     &    0.25*(epsu+0.5*epss*epst)*(y3sutr+y3tusr)+
     &    0.25*(epst+0.5*epss*epsu)*(y3stur+y3utsr)+
     &    0.25*(epss+0.5*epst*epsu)*(y3tsur+y3ustr)
          b1stui=-0.25*(epss+epst+epsu)*(w2si+w2ti+w2ui)+
     &    0.25*(epsu+0.5*epss*epst)*(y3suti+y3tusi)+
     &    0.25*(epst+0.5*epss*epsu)*(y3stui+y3utsi)+
     &    0.25*(epss+0.5*epst*epsu)*(y3tsui+y3usti)
          b2stur=-1.+0.125*epss*epst*(y3sutr+y3tusr)+
     &    0.125*epss*epsu*(y3stur+y3utsr)+
     &    0.125*epst*epsu*(y3tsur+y3ustr)
          b2stui=0.125*epss*epst*(y3suti+y3tusi)+
     &    0.125*epss*epsu*(y3stui+y3utsi)+
     &    0.125*epst*epsu*(y3tsui+y3usti)
        endif
        a0stur=a0stur+eiwt*b0stur
        a0stui=a0stui+eiwt*b0stui
        a0tsur=a0tsur+eiwt*b0tsur
        a0tsui=a0tsui+eiwt*b0tsui
        a0utsr=a0utsr+eiwt*b0utsr
        a0utsi=a0utsi+eiwt*b0utsi
        a1stur=a1stur+eiwt*b1stur
        a1stui=a1stui+eiwt*b1stui
        a2stur=a2stur+eiwt*b2stur
        a2stui=a2stui+eiwt*b2stui
 1040   continue
        asqsum=a0stur**2+a0stui**2+a0tsur**2+a0tsui**2+a0utsr**2+
     &  a0utsi**2+4.*a1stur**2+4.*a1stui**2+a2stur**2+a2stui**2
        facgg=comfac*faca/(16.*paru(1)**2)*as**2*aem**2*asqsum
        facgp=comfac*faca*5./(192.*paru(1)**2)*as**3*aem*asqsum
        if(kfac(1,21)*kfac(2,21).eq.0) goto 1050
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=1
        if(isub.eq.114) sigh(nchn)=0.5*facgg
        if(isub.eq.115) sigh(nchn)=facgp
 1050   continue

      elseif(isub.eq.116) then
c...g + g -> gamma + z0.

      elseif(isub.eq.117) then
c...g + g -> z0 + z0.

      elseif(isub.eq.118) then
c...g + g -> w+ + w-.

      endif

c...g: 2 -> 3, tree diagrams.

      elseif(isub.le.140) then
      if(isub.eq.121) then
c...g + g -> f + f~ + h0 (f + f~ -> h0 as inner process).

      elseif(isub.eq.122) then
c...gamma + gamma -> f + f' + h0 (f + f~ -> h0 as inner process).

      elseif(isub.eq.123) then
c...f + f' -> f + f' + h0 (or h'0, or a0) (z0 + z0 -> h0 as
c...inner process).
        facnor=comfac*(4.*paru(1)*aem/(xw*(1.-xw)))**3*sqmz/32.
        if(mstp(4).ge.1.or.ihigg.ge.2) facnor=facnor*
     &  paru(154+10*ihigg)**2
        facprp=1./((vint(215)-vint(204)**2)*(vint(216)-vint(209)**2))**2
        faczz1=facnor*facprp*(0.5*taup*vint(2))*vint(219)
        faczz2=facnor*facprp*vint(217)*vint(218)
        call pywidt(kfhigg,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=(1./paru(1))*vint(2)*hf/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        do 1070 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 1070
        ia=iabs(i)
        do 1060 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 1060
        ja=iabs(j)
        ei=kchg(ia,1)*isign(1,i)/3.
        ai=sign(1.,kchg(ia,1)+0.5)*isign(1,i)
        vi=ai-4.*ei*xw
        ej=kchg(ja,1)*isign(1,j)/3.
        aj=sign(1.,kchg(ja,1)+0.5)*isign(1,j)
        vj=aj-4.*ej*xw
        faclr1=(vi**2+ai**2)*(vj**2+aj**2)+4.*vi*ai*vj*aj
        faclr2=(vi**2+ai**2)*(vj**2+aj**2)-4.*vi*ai*vj*aj
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=(faclr1*faczz1+faclr2*faczz2)*facbw
 1060   continue
 1070   continue

      elseif(isub.eq.124) then
c...f + f' -> f" + f"' + h0 (or h'0, or a0) (w+ + w- -> h0 as
c...inner process).
        facnor=comfac*(4.*paru(1)*aem/xw)**3*sqmw
        if(mstp(4).ge.1.or.ihigg.ge.2) facnor=facnor*
     &  paru(155+10*ihigg)**2
        facprp=1./((vint(215)-vint(204)**2)*(vint(216)-vint(209)**2))**2
        facww=facnor*facprp*(0.5*taup*vint(2))*vint(219)
        call pywidt(kfhigg,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        hf=hp*(wdte(0,1)+wdte(0,2)+wdte(0,4))
        facbw=(1./paru(1))*vint(2)*hf/((sh-sqmh)**2+hs**2)
        if(abs(sh-sqmh).gt.100.*hs) facbw=0.
        do 1090 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 1090
        ei=sign(1.,float(i))*kchg(iabs(i),1)
        do 1080 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 1080
        ej=sign(1.,float(j))*kchg(iabs(j),1)
        if(ei*ej.gt.0.) goto 1080
        faclr=vint(180+i)*vint(180+j)
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=faclr*facww*facbw
 1080   continue
 1090   continue

      elseif(isub.eq.131) then
c...g + g -> z0 + q + qbar.
        if(kfac(1,21)*kfac(2,21).eq.0) goto 1120

c...read out information on flavours, masses, couplings.
        kfq=kfpr(131,2)
        kfl=iabs(kfdp(mint(35),1))
        pmh=sqrt(sh)
        pmqq=sqrt(vint(64))
        pmll=sqrt(vint(63))
        pmq=pmas(kfq,1)
        qfq=kchg(kfq,1)/3.
        afq=sign(1.d0,qfq+0.1)
        vfq=afq-4.*xw*qfq
        qfl=kchg(kfl,1)/3.
        afl=sign(1.d0,qfl+0.1)
        vfl=afl-4.*xw*qfl

c...set line numbers for particles.
        ig1=mint(84)+1
        ig2=mint(84)+2
        iq1=mint(84)+3
        iq2=mint(84)+4
        il1=mint(84)+5
        il2=mint(84)+6
        iz=mint(84)+7

c...reconstruct decay kinematics.
        do 1100 i=mint(84)+1,mint(84)+7
        k(i,1)=1
        do 1100 j=1,5
 1100   p(i,j)=0.
        p(ig1,4)=0.5*pmh
        p(ig1,3)=p(ig1,4)
        p(ig2,4)=p(ig1,4)
        p(ig2,3)=-p(ig1,3)
        p(iq1,5)=pmq
        p(iq1,4)=0.5*pmqq
        p(iq1,3)=sqrt(max(0.d0,p(iq1,4)**2-pmq**2))
        p(iq2,5)=pmq
        p(iq2,4)=p(iq1,4)
        p(iq2,3)=-p(iq1,3)
        p(il1,4)=0.5*pmll
        p(il1,3)=p(il1,4)
        p(il2,4)=p(il1,4)
        p(il2,3)=-p(il1,3)
        p(iz,5)=pmll
        p(iz,4)=0.5*(pmh+(pmll**2-pmqq**2)/pmh)
        p(iz,3)=sqrt(max(0.d0,p(iz,4)**2-pmll**2))
        call ludbrb(iq1,iq2,acos(vint(83)),vint(84),0d0,0d0,
     &  -(p(iz,3)/(pmh-p(iz,4))))
        call ludbrb(il1,il2,acos(vint(81)),vint(82),0d0,0d0,
     &  (p(iz,3)/p(iz,4)))
        call ludbrb(iq1,iz,acos(vint(23)),vint(24),0d0,0d0,0d0)

c...interface information to program of ronald kleiss.
        rkmq=pmq
        rkmz=pmas(23,1)
        rkgz=pmas(23,2)
        rkvq=vfq
        rkaq=afq
        rkvl=vfl
        rkal=afl
        rkg1(0)=p(ig1,4)
        rkg2(0)=p(ig2,4)
        rkq1(0)=p(iq1,4)
        rkq2(0)=p(iq2,4)
        rkl1(0)=p(il1,4)
        rkl2(0)=p(il2,4)
        do 1110 j=1,3
        rkg1(j)=p(ig1,j)
        rkg2(j)=p(ig2,j)
        rkq1(j)=p(iq1,j)
        rkq2(j)=p(iq2,j)
        rkl1(j)=p(il1,j)
        rkl2(j)=p(il2,j)
 1110   continue
        call rkbbv(rkg1,rkg2,rkq1,rkq2,rkl1,rkl2,1,rkres)

c...multiply with normalization factors.
        wtmep=1./(2.*sh*paru(2)**8)
        wtcou=as**2*(4.*paru(1)*aem*xwc)**2
        wtzqq=wtmep*wtcou*rkres
        wtphs=(paru(1)/2.)**2*pmqq**2*
     &  (paru(1)*((pmll**2-pmas(23,1)**2)**2+(pmas(23,1)*
     &  pmas(23,2))**2)/(pmas(23,1)*pmas(23,2)))*0.5*sh
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
        isig(nchn,3)=int(1.5+rlu(0))
        sigh(nchn)=comfac*wtphs*wtzqq
 1120   continue
      endif

c...h: 2 -> 1, tree diagrams, non-standard model processes.

      elseif(isub.le.160) then
      if(isub.eq.141) then
c...f + f~ -> gamma*/z0/z'0.
        mint(61)=2
        call pywidt(32,sh,wdtp,wdte)
        hp0=aem/3.*sh
        hp1=aem/3.*xwc*sh
        hp2=hp1
        hs=hp1*vint(117)
        hsp=hp2*wdtp(0)
        faczp=4.*comfac*3.
        do 1130 i=mina,maxa
        if(i.eq.0.or.kfac(1,i)*kfac(2,-i).eq.0) goto 1130
        ei=kchg(iabs(i),1)/3.
        ai=sign(1.d0,ei)
        vi=ai-4.*ei*xw
        if(iabs(i).lt.10) then
          vpi=paru(123-2*mod(iabs(i),2))
          api=paru(124-2*mod(iabs(i),2))
        else
          vpi=paru(127-2*mod(iabs(i),2))
          api=paru(128-2*mod(iabs(i),2))
        endif
        hi0=hp0
        if(iabs(i).le.10) hi0=hi0*faca/3.
        hi1=hp1
        if(iabs(i).le.10) hi1=hi1*faca/3.
        hi2=hp2
        if(iabs(i).le.10) hi2=hi2*faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=faczp*(ei**2/sh2*hi0*hp0*vint(111)+ei*vi*
     &  (1.-sqmz/sh)/((sh-sqmz)**2+hs**2)*(hi0*hp1+hi1*hp0)*vint(112)+
     &  ei*vpi*(1.-sqmzp/sh)/((sh-sqmzp)**2+hsp**2)*(hi0*hp2+hi2*hp0)*
     &  vint(113)+(vi**2+ai**2)/((sh-sqmz)**2+hs**2)*hi1*hp1*vint(114)+
     &  (vi*vpi+ai*api)*((sh-sqmz)*(sh-sqmzp)+hs*hsp)/(((sh-sqmz)**2+
     &  hs**2)*((sh-sqmzp)**2+hsp**2))*(hi1*hp2+hi2*hp1)*vint(115)+
     &  (vpi**2+api**2)/((sh-sqmzp)**2+hsp**2)*hi2*hp2*vint(116))
 1130   continue

      elseif(isub.eq.142) then
c...f + f~' -> w'+/-.
        call pywidt(34,sh,wdtp,wdte)
        hp=aem/(24.*xw)*sh
        hs=hp*wdtp(0)
        facbw=4.*comfac/((sh-sqmwp)**2+hs**2)*3.
        do 1150 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 1150
        ia=iabs(i)
        do 1140 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 1140
        ja=iabs(j)
        if(i*j.gt.0.or.mod(ia+ja,2).eq.0) goto 1140
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 1140
        kchw=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        hi=hp*(paru(133)**2+paru(134)**2)
        if(ia.le.10) hi=hp*(paru(131)**2+paru(132)**2)*
     &  vckm((ia+1)/2,(ja+1)/2)*faca/3.
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        hf=hp*(wdte(0,1)+wdte(0,(5-kchw)/2)+wdte(0,4))
        sigh(nchn)=hi*facbw*hf
 1140   continue
 1150   continue

      elseif(isub.eq.143) then
c...f + f~' -> h+/-.
        call pywidt(37,sh,wdtp,wdte)
        hp=aem/(8.*xw)*sh/sqmw*sh
        hs=hp*wdtp(0)
        facbw=4.*comfac/((sh-sqmhc)**2+hs**2)
        do 1170 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 1170
        ia=iabs(i)
        im=(mod(ia,10)+1)/2
        do 1160 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 1160
        ja=iabs(j)
        jm=(mod(ja,10)+1)/2
        if(i*j.gt.0.or.ia.eq.ja.or.im.ne.jm) goto 1160
        if((ia.le.10.and.ja.gt.10).or.(ia.gt.10.and.ja.le.10)) goto 1160
        if(mod(ia,2).eq.0) then
          iu=ia
          il=ja
        else
          iu=ja
          il=ia
        endif
        rml=pmas(il,1)**2/sh
        rmu=pmas(iu,1)**2/sh
        hi=hp*(rml*paru(141)**2+rmu/paru(141)**2)
        if(ia.le.10) hi=hi*faca/3.
        kchhc=(kchg(ia,1)*isign(1,i)+kchg(ja,1)*isign(1,j))/3
        hf=hp*(wdte(0,1)+wdte(0,(5-kchhc)/2)+wdte(0,4))
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
 1160   continue
 1170   continue

      elseif(isub.eq.144) then
c...f + f~' -> r.
        call pywidt(40,sh,wdtp,wdte)
        hp=aem/(12.*xw)*sh
        hs=hp*wdtp(0)
        facbw=4.*comfac/((sh-sqmr)**2+hs**2)*3.
        do 1190 i=min1,max1
        if(i.eq.0.or.kfac(1,i).eq.0) goto 1190
        ia=iabs(i)
        do 1180 j=min2,max2
        if(j.eq.0.or.kfac(2,j).eq.0) goto 1180
        ja=iabs(j)
        if(i*j.gt.0.or.iabs(ia-ja).ne.2) goto 1180
        hi=hp
        if(ia.le.10) hi=hi*faca/3.
        hf=hp*(wdte(0,1)+wdte(0,(10-(i+j))/4)+wdte(0,4))
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
 1180   continue
 1190   continue

      elseif(isub.eq.145) then
c...q + l -> lq (leptoquark).
        call pywidt(39,sh,wdtp,wdte)
        hp=aem/4.*sh
        hs=hp*wdtp(0)
        facbw=4.*comfac/((sh-sqmlq)**2+hs**2)
        if(abs(sh-sqmlq).gt.100.*hs) facbw=0.
        kflqq=kfdp(mdcy(39,2),1)
        kflql=kfdp(mdcy(39,2),2)
        do 1210 i=min1,max1
        if(kfac(1,i).eq.0) goto 1210
        ia=iabs(i)
        if(ia.ne.kflqq.and.ia.ne.kflql) goto 1210
        do 1200 j=min2,max2
        if(kfac(2,j).eq.0) goto 1200
        ja=iabs(j)
        if(ja.ne.kflqq.and.ja.ne.kflql) goto 1200
        if(i*j.ne.kflqq*kflql) goto 1200
        if(ia.eq.kflqq) kchlq=isign(1,i)
        if(ja.eq.kflqq) kchlq=isign(1,j)
        hi=hp*paru(151)
        hf=hp*(wdte(0,1)+wdte(0,(5-kchlq)/2)+wdte(0,4))
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=j
        isig(nchn,3)=1
        sigh(nchn)=hi*facbw*hf
 1200   continue
 1210   continue

      endif

c...i: 2 -> 2, tree diagrams, non-standard model processes.

      else
      if(isub.eq.161) then
c...f + g -> f' + h+/- (b + g -> t + h+/- only)
c...(choice of only b and t to avoid kinematics problems).
        fhcq=comfac*faca*as*aem/xw*1./24
        do 1230 i=mina,maxa
        ia=iabs(i)
        if(ia.ne.5) goto 1230
        iua=ia+mod(ia,2)
        sqmq=pmas(iua,1)**2
        fachcq=fhcq/paru(141)**2*sqmq/sqmw*(sh/(sqmq-uh)+
     &  2.*sqmq*(sqmhc-uh)/(sqmq-uh)**2+(sqmq-uh)/sh+
     &  2.*sqmq/(sqmq-uh)+2.*(sqmhc-uh)/(sqmq-uh)*(sqmhc-sqmq-sh)/sh)
        kchhc=isign(1,kchg(ia,1)*isign(1,i))
        do 1220 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 1220
        if(isde.eq.2.and.kfac(1,21)*kfac(2,1).eq.0) goto 1220
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=fachcq*wids(37,(5-kchhc)/2)
 1220   continue
 1230   continue

      elseif(isub.eq.162) then
c...q + g -> lq + l~; lq=leptoquark.
        faclq=comfac*faca*paru(151)*(as*aem/6.)*(-th/sh)*
     &  (uh2+sqmlq**2)/(uh-sqmlq)**2
        kflqq=kfdp(mdcy(39,2),1)
        do 1250 i=mina,maxa
        if(iabs(i).ne.kflqq) goto 1250
        kchlq=isign(1,i)
        do 1240 isde=1,2
        if(isde.eq.1.and.kfac(1,i)*kfac(2,21).eq.0) goto 1240
        if(isde.eq.2.and.kfac(1,21)*kfac(2,i).eq.0) goto 1240
        nchn=nchn+1
        isig(nchn,isde)=i
        isig(nchn,3-isde)=21
        isig(nchn,3)=1
        sigh(nchn)=faclq*wids(39,(5-kchlq)/2)
 1240   continue
 1250   continue

      elseif(isub.eq.163) then
c...g + g -> lq + lq~; lq=leptoquark.
        faclq=comfac*faca*wids(39,1)*(as**2/2.)*
     &  (7./48.+3.*(uh-th)**2/(16.*sh2))*(1.+2.*sqmlq*th/(th-sqmlq)**2+
     &  2.*sqmlq*uh/(uh-sqmlq)**2+4.*sqmlq**2/((th-sqmlq)*(uh-sqmlq)))
        if(kfac(1,21)*kfac(2,21).eq.0) goto 1260
        nchn=nchn+1
        isig(nchn,1)=21
        isig(nchn,2)=21
c...since don't know proper colour flow, randomize between alternatives.
        isig(nchn,3)=int(1.5+rlu(0))
        sigh(nchn)=faclq
 1260   continue

      elseif(isub.eq.164) then
c...q + q~ -> lq + lq~; lq=leptoquark.
        faclqa=comfac*wids(39,1)*(as**2/9.)*
     &  (sh*(sh-4.*sqmlq)-(uh-th)**2)/sh2
        faclqs=comfac*wids(39,1)*((paru(151)**2*aem**2/8.)*
     &  (-sh*th-(sqmlq-th)**2)/th2+(paru(151)*aem*as/18.)*
     &  ((sqmlq-th)*(uh-th)+sh*(sqmlq+th))/(sh*th))
        kflqq=kfdp(mdcy(39,2),1)
        do 1270 i=mina,maxa
        if(i.eq.0.or.iabs(i).gt.mstp(54).or.
     &  kfac(1,i)*kfac(2,-i).eq.0) goto 1270
        nchn=nchn+1
        isig(nchn,1)=i
        isig(nchn,2)=-i
        isig(nchn,3)=1
        sigh(nchn)=faclqa
        if(iabs(i).eq.kflqq) sigh(nchn)=faclqa+faclqs
 1270   continue

      endif
      endif

c...multiply with structure functions.
      if(isub.le.90.or.isub.ge.96) then
        do 1280 ichn=1,nchn
        if(mint(45).ge.2) then
          kfl1=isig(ichn,1)
          if(kfl1.eq.21) kfl1=0
          sigh(ichn)=sigh(ichn)*xsfx(1,kfl1)
        endif
        if(mint(46).ge.2) then
          kfl2=isig(ichn,2)
          if(kfl2.eq.21) kfl2=0
          sigh(ichn)=sigh(ichn)*xsfx(2,kfl2)
        endif
 1280   sigs=sigs+sigh(ichn)
      endif

      return
      end

c*********************************************************************

      subroutine pystfu(kf,x,q2,xpq)
      implicit double precision (a-h,o-z)

c...gives electron, photon, pi+, neutron and proton parton structure
c...functions according to a few different parametrizations. note
c...that what is coded is x times the probability distribution,
c...i.e. xq(x,q2) etc.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      save /ludat1/,/ludat2/
      save /pypars/,/pyint1/
      dimension xpq(-25:25),xq(9),tx(6),tt(6),ts(6),nehlq(8,2),
     &cehlq(6,6,2,8,2),cdo(3,6,5,2),cow(3,5,4,2),cmt(0:3,0:2,9,4),
     &exmt(0:3)

c...the following data lines are coefficients needed in the
c...owens pion structure function parametrizations, see below.
c...expansion coefficients for up and down valence quark distributions.
      data ((cow(ip,is,1,1),is=1,5),ip=1,3)/
     1  4.0000e-01,  7.0000e-01,  0.0000e+00,  0.0000e+00,  0.0000e+00,
     2 -6.2120e-02,  6.4780e-01,  0.0000e+00,  0.0000e+00,  0.0000e+00,
     3 -7.1090e-03,  1.3350e-02,  0.0000e+00,  0.0000e+00,  0.0000e+00/
      data ((cow(ip,is,1,2),is=1,5),ip=1,3)/
     1  4.0000e-01,  6.2800e-01,  0.0000e+00,  0.0000e+00,  0.0000e+00,
     2 -5.9090e-02,  6.4360e-01,  0.0000e+00,  0.0000e+00,  0.0000e+00,
     3 -6.5240e-03,  1.4510e-02,  0.0000e+00,  0.0000e+00,  0.0000e+00/
c...expansion coefficients for gluon distribution.
      data ((cow(ip,is,2,1),is=1,5),ip=1,3)/
     1  8.8800e-01,  0.0000e+00,  3.1100e+00,  6.0000e+00,  0.0000e+00,
     2 -1.8020e+00, -1.5760e+00, -1.3170e-01,  2.8010e+00, -1.7280e+01,
     3  1.8120e+00,  1.2000e+00,  5.0680e-01, -1.2160e+01,  2.0490e+01/
      data ((cow(ip,is,2,2),is=1,5),ip=1,3)/
     1  7.9400e-01,  0.0000e+00,  2.8900e+00,  6.0000e+00,  0.0000e+00,
     2 -9.1440e-01, -1.2370e+00,  5.9660e-01, -3.6710e+00, -8.1910e+00,
     3  5.9660e-01,  6.5820e-01, -2.5500e-01, -2.3040e+00,  7.7580e+00/
c...expansion coefficients for (up+down+strange) quark sea distribution.
      data ((cow(ip,is,3,1),is=1,5),ip=1,3)/
     1  9.0000e-01,  0.0000e+00,  5.0000e+00,  0.0000e+00,  0.0000e+00,
     2 -2.4280e-01, -2.1200e-01,  8.6730e-01,  1.2660e+00,  2.3820e+00,
     3  1.3860e-01,  3.6710e-03,  4.7470e-02, -2.2150e+00,  3.4820e-01/
      data ((cow(ip,is,3,2),is=1,5),ip=1,3)/
     1  9.0000e-01,  0.0000e+00,  5.0000e+00,  0.0000e+00,  0.0000e+00,
     2 -1.4170e-01, -1.6970e-01, -2.4740e+00, -2.5340e+00,  5.6210e-01,
     3 -1.7400e-01, -9.6230e-02,  1.5750e+00,  1.3780e+00, -2.7010e-01/
c...expansion coefficients for charm quark sea distribution.
      data ((cow(ip,is,4,1),is=1,5),ip=1,3)/
     1  0.0000e+00, -2.2120e-02,  2.8940e+00,  0.0000e+00,  0.0000e+00,
     2  7.9280e-02, -3.7850e-01,  9.4330e+00,  5.2480e+00,  8.3880e+00,
     3 -6.1340e-02, -1.0880e-01, -1.0852e+01, -7.1870e+00, -1.1610e+01/
      data ((cow(ip,is,4,2),is=1,5),ip=1,3)/
     1  0.0000e+00, -8.8200e-02,  1.9240e+00,  0.0000e+00,  0.0000e+00,
     2  6.2290e-02, -2.8920e-01,  2.4240e-01, -4.4630e+00, -8.3670e-01,
     3 -4.0990e-02, -1.0820e-01,  2.0360e+00,  5.2090e+00, -4.8400e-02/

c...the following data lines are coefficients needed in the
c...eichten, hinchliffe, lane, quigg proton structure function
c...parametrizations, see below.
c...powers of 1-x in different cases.
      data nehlq/3,4,7,5,7,7,7,7,3,4,7,6,7,7,7,7/
c...expansion coefficients for up valence quark distribution.
      data (((cehlq(ix,it,nx,1,1),ix=1,6),it=1,6),nx=1,2)/
     1 7.677e-01,-2.087e-01,-3.303e-01,-2.517e-02,-1.570e-02,-1.000e-04,
     2-5.326e-01,-2.661e-01, 3.201e-01, 1.192e-01, 2.434e-02, 7.620e-03,
     3 2.162e-01, 1.881e-01,-8.375e-02,-6.515e-02,-1.743e-02,-5.040e-03,
     4-9.211e-02,-9.952e-02, 1.373e-02, 2.506e-02, 8.770e-03, 2.550e-03,
     5 3.670e-02, 4.409e-02, 9.600e-04,-7.960e-03,-3.420e-03,-1.050e-03,
     6-1.549e-02,-2.026e-02,-3.060e-03, 2.220e-03, 1.240e-03, 4.100e-04,
     1 2.395e-01, 2.905e-01, 9.778e-02, 2.149e-02, 3.440e-03, 5.000e-04,
     2 1.751e-02,-6.090e-03,-2.687e-02,-1.916e-02,-7.970e-03,-2.750e-03,
     3-5.760e-03,-5.040e-03, 1.080e-03, 2.490e-03, 1.530e-03, 7.500e-04,
     4 1.740e-03, 1.960e-03, 3.000e-04,-3.400e-04,-2.900e-04,-1.800e-04,
     5-5.300e-04,-6.400e-04,-1.700e-04, 4.000e-05, 6.000e-05, 4.000e-05,
     6 1.700e-04, 2.200e-04, 8.000e-05, 1.000e-05,-1.000e-05,-1.000e-05/
      data (((cehlq(ix,it,nx,1,2),ix=1,6),it=1,6),nx=1,2)/
     1 7.237e-01,-2.189e-01,-2.995e-01,-1.909e-02,-1.477e-02, 2.500e-04,
     2-5.314e-01,-2.425e-01, 3.283e-01, 1.119e-01, 2.223e-02, 7.070e-03,
     3 2.289e-01, 1.890e-01,-9.859e-02,-6.900e-02,-1.747e-02,-5.080e-03,
     4-1.041e-01,-1.084e-01, 2.108e-02, 2.975e-02, 9.830e-03, 2.830e-03,
     5 4.394e-02, 5.116e-02,-1.410e-03,-1.055e-02,-4.230e-03,-1.270e-03,
     6-1.991e-02,-2.539e-02,-2.780e-03, 3.430e-03, 1.720e-03, 5.500e-04,
     1 2.410e-01, 2.884e-01, 9.369e-02, 1.900e-02, 2.530e-03, 2.400e-04,
     2 1.765e-02,-9.220e-03,-3.037e-02,-2.085e-02,-8.440e-03,-2.810e-03,
     3-6.450e-03,-5.260e-03, 1.720e-03, 3.110e-03, 1.830e-03, 8.700e-04,
     4 2.120e-03, 2.320e-03, 2.600e-04,-4.900e-04,-3.900e-04,-2.300e-04,
     5-6.900e-04,-8.200e-04,-2.000e-04, 7.000e-05, 9.000e-05, 6.000e-05,
     6 2.400e-04, 3.100e-04, 1.100e-04, 0.000e+00,-2.000e-05,-2.000e-05/
c...expansion coefficients for down valence quark distribution.
      data (((cehlq(ix,it,nx,2,1),ix=1,6),it=1,6),nx=1,2)/
     1 3.813e-01,-8.090e-02,-1.634e-01,-2.185e-02,-8.430e-03,-6.200e-04,
     2-2.948e-01,-1.435e-01, 1.665e-01, 6.638e-02, 1.473e-02, 4.080e-03,
     3 1.252e-01, 1.042e-01,-4.722e-02,-3.683e-02,-1.038e-02,-2.860e-03,
     4-5.478e-02,-5.678e-02, 8.900e-03, 1.484e-02, 5.340e-03, 1.520e-03,
     5 2.220e-02, 2.567e-02,-3.000e-05,-4.970e-03,-2.160e-03,-6.500e-04,
     6-9.530e-03,-1.204e-02,-1.510e-03, 1.510e-03, 8.300e-04, 2.700e-04,
     1 1.261e-01, 1.354e-01, 3.958e-02, 8.240e-03, 1.660e-03, 4.500e-04,
     2 3.890e-03,-1.159e-02,-1.625e-02,-9.610e-03,-3.710e-03,-1.260e-03,
     3-1.910e-03,-5.600e-04, 1.590e-03, 1.590e-03, 8.400e-04, 3.900e-04,
     4 6.400e-04, 4.900e-04,-1.500e-04,-2.900e-04,-1.800e-04,-1.000e-04,
     5-2.000e-04,-1.900e-04, 0.000e+00, 6.000e-05, 4.000e-05, 3.000e-05,
     6 7.000e-05, 8.000e-05, 2.000e-05,-1.000e-05,-1.000e-05,-1.000e-05/
      data (((cehlq(ix,it,nx,2,2),ix=1,6),it=1,6),nx=1,2)/
     1 3.578e-01,-8.622e-02,-1.480e-01,-1.840e-02,-7.820e-03,-4.500e-04,
     2-2.925e-01,-1.304e-01, 1.696e-01, 6.243e-02, 1.353e-02, 3.750e-03,
     3 1.318e-01, 1.041e-01,-5.486e-02,-3.872e-02,-1.038e-02,-2.850e-03,
     4-6.162e-02,-6.143e-02, 1.303e-02, 1.740e-02, 5.940e-03, 1.670e-03,
     5 2.643e-02, 2.957e-02,-1.490e-03,-6.450e-03,-2.630e-03,-7.700e-04,
     6-1.218e-02,-1.497e-02,-1.260e-03, 2.240e-03, 1.120e-03, 3.500e-04,
     1 1.263e-01, 1.334e-01, 3.732e-02, 7.070e-03, 1.260e-03, 3.400e-04,
     2 3.660e-03,-1.357e-02,-1.795e-02,-1.031e-02,-3.880e-03,-1.280e-03,
     3-2.100e-03,-3.600e-04, 2.050e-03, 1.920e-03, 9.800e-04, 4.400e-04,
     4 7.700e-04, 5.400e-04,-2.400e-04,-3.900e-04,-2.400e-04,-1.300e-04,
     5-2.600e-04,-2.300e-04, 2.000e-05, 9.000e-05, 6.000e-05, 4.000e-05,
     6 9.000e-05, 1.000e-04, 2.000e-05,-2.000e-05,-2.000e-05,-1.000e-05/
c...expansion coefficients for up and down sea quark distributions.
      data (((cehlq(ix,it,nx,3,1),ix=1,6),it=1,6),nx=1,2)/
     1 6.870e-02,-6.861e-02, 2.973e-02,-5.400e-03, 3.780e-03,-9.700e-04,
     2-1.802e-02, 1.400e-04, 6.490e-03,-8.540e-03, 1.220e-03,-1.750e-03,
     3-4.650e-03, 1.480e-03,-5.930e-03, 6.000e-04,-1.030e-03,-8.000e-05,
     4 6.440e-03, 2.570e-03, 2.830e-03, 1.150e-03, 7.100e-04, 3.300e-04,
     5-3.930e-03,-2.540e-03,-1.160e-03,-7.700e-04,-3.600e-04,-1.900e-04,
     6 2.340e-03, 1.930e-03, 5.300e-04, 3.700e-04, 1.600e-04, 9.000e-05,
     1 1.014e+00,-1.106e+00, 3.374e-01,-7.444e-02, 8.850e-03,-8.700e-04,
     2 9.233e-01,-1.285e+00, 4.475e-01,-9.786e-02, 1.419e-02,-1.120e-03,
     3 4.888e-02,-1.271e-01, 8.606e-02,-2.608e-02, 4.780e-03,-6.000e-04,
     4-2.691e-02, 4.887e-02,-1.771e-02, 1.620e-03, 2.500e-04,-6.000e-05,
     5 7.040e-03,-1.113e-02, 1.590e-03, 7.000e-04,-2.000e-04, 0.000e+00,
     6-1.710e-03, 2.290e-03, 3.800e-04,-3.500e-04, 4.000e-05, 1.000e-05/
      data (((cehlq(ix,it,nx,3,2),ix=1,6),it=1,6),nx=1,2)/
     1 1.008e-01,-7.100e-02, 1.973e-02,-5.710e-03, 2.930e-03,-9.900e-04,
     2-5.271e-02,-1.823e-02, 1.792e-02,-6.580e-03, 1.750e-03,-1.550e-03,
     3 1.220e-02, 1.763e-02,-8.690e-03,-8.800e-04,-1.160e-03,-2.100e-04,
     4-1.190e-03,-7.180e-03, 2.360e-03, 1.890e-03, 7.700e-04, 4.100e-04,
     5-9.100e-04, 2.040e-03,-3.100e-04,-1.050e-03,-4.000e-04,-2.400e-04,
     6 1.190e-03,-1.700e-04,-2.000e-04, 4.200e-04, 1.700e-04, 1.000e-04,
     1 1.081e+00,-1.189e+00, 3.868e-01,-8.617e-02, 1.115e-02,-1.180e-03,
     2 9.917e-01,-1.396e+00, 4.998e-01,-1.159e-01, 1.674e-02,-1.720e-03,
     3 5.099e-02,-1.338e-01, 9.173e-02,-2.885e-02, 5.890e-03,-6.500e-04,
     4-3.178e-02, 5.703e-02,-2.070e-02, 2.440e-03, 1.100e-04,-9.000e-05,
     5 8.970e-03,-1.392e-02, 2.050e-03, 6.500e-04,-2.300e-04, 2.000e-05,
     6-2.340e-03, 3.010e-03, 5.000e-04,-3.900e-04, 6.000e-05, 1.000e-05/
c...expansion coefficients for gluon distribution.
      data (((cehlq(ix,it,nx,4,1),ix=1,6),it=1,6),nx=1,2)/
     1 9.482e-01,-9.578e-01, 1.009e-01,-1.051e-01, 3.456e-02,-3.054e-02,
     2-9.627e-01, 5.379e-01, 3.368e-01,-9.525e-02, 1.488e-02,-2.051e-02,
     3 4.300e-01,-8.306e-02,-3.372e-01, 4.902e-02,-9.160e-03, 1.041e-02,
     4-1.925e-01,-1.790e-02, 2.183e-01, 7.490e-03, 4.140e-03,-1.860e-03,
     5 8.183e-02, 1.926e-02,-1.072e-01,-1.944e-02,-2.770e-03,-5.200e-04,
     6-3.884e-02,-1.234e-02, 5.410e-02, 1.879e-02, 3.350e-03, 1.040e-03,
     1 2.948e+01,-3.902e+01, 1.464e+01,-3.335e+00, 5.054e-01,-5.915e-02,
     2 2.559e+01,-3.955e+01, 1.661e+01,-4.299e+00, 6.904e-01,-8.243e-02,
     3-1.663e+00, 1.176e+00, 1.118e+00,-7.099e-01, 1.948e-01,-2.404e-02,
     4-2.168e-01, 8.170e-01,-7.169e-01, 1.851e-01,-1.924e-02,-3.250e-03,
     5 2.088e-01,-4.355e-01, 2.239e-01,-2.446e-02,-3.620e-03, 1.910e-03,
     6-9.097e-02, 1.601e-01,-5.681e-02,-2.500e-03, 2.580e-03,-4.700e-04/
      data (((cehlq(ix,it,nx,4,2),ix=1,6),it=1,6),nx=1,2)/
     1 2.367e+00, 4.453e-01, 3.660e-01, 9.467e-02, 1.341e-01, 1.661e-02,
     2-3.170e+00,-1.795e+00, 3.313e-02,-2.874e-01,-9.827e-02,-7.119e-02,
     3 1.823e+00, 1.457e+00,-2.465e-01, 3.739e-02, 6.090e-03, 1.814e-02,
     4-1.033e+00,-9.827e-01, 2.136e-01, 1.169e-01, 5.001e-02, 1.684e-02,
     5 5.133e-01, 5.259e-01,-1.173e-01,-1.139e-01,-4.988e-02,-2.021e-02,
     6-2.881e-01,-3.145e-01, 5.667e-02, 9.161e-02, 4.568e-02, 1.951e-02,
     1 3.036e+01,-4.062e+01, 1.578e+01,-3.699e+00, 6.020e-01,-7.031e-02,
     2 2.700e+01,-4.167e+01, 1.770e+01,-4.804e+00, 7.862e-01,-1.060e-01,
     3-1.909e+00, 1.357e+00, 1.127e+00,-7.181e-01, 2.232e-01,-2.481e-02,
     4-2.488e-01, 9.781e-01,-8.127e-01, 2.094e-01,-2.997e-02,-4.710e-03,
     5 2.506e-01,-5.427e-01, 2.672e-01,-3.103e-02,-1.800e-03, 2.870e-03,
     6-1.128e-01, 2.087e-01,-6.972e-02,-2.480e-03, 2.630e-03,-8.400e-04/
c...expansion coefficients for strange sea quark distribution.
      data (((cehlq(ix,it,nx,5,1),ix=1,6),it=1,6),nx=1,2)/
     1 4.968e-02,-4.173e-02, 2.102e-02,-3.270e-03, 3.240e-03,-6.700e-04,
     2-6.150e-03,-1.294e-02, 6.740e-03,-6.890e-03, 9.000e-04,-1.510e-03,
     3-8.580e-03, 5.050e-03,-4.900e-03,-1.600e-04,-9.400e-04,-1.500e-04,
     4 7.840e-03, 1.510e-03, 2.220e-03, 1.400e-03, 7.000e-04, 3.500e-04,
     5-4.410e-03,-2.220e-03,-8.900e-04,-8.500e-04,-3.600e-04,-2.000e-04,
     6 2.520e-03, 1.840e-03, 4.100e-04, 3.900e-04, 1.600e-04, 9.000e-05,
     1 9.235e-01,-1.085e+00, 3.464e-01,-7.210e-02, 9.140e-03,-9.100e-04,
     2 9.315e-01,-1.274e+00, 4.512e-01,-9.775e-02, 1.380e-02,-1.310e-03,
     3 4.739e-02,-1.296e-01, 8.482e-02,-2.642e-02, 4.760e-03,-5.700e-04,
     4-2.653e-02, 4.953e-02,-1.735e-02, 1.750e-03, 2.800e-04,-6.000e-05,
     5 6.940e-03,-1.132e-02, 1.480e-03, 6.500e-04,-2.100e-04, 0.000e+00,
     6-1.680e-03, 2.340e-03, 4.200e-04,-3.400e-04, 5.000e-05, 1.000e-05/
      data (((cehlq(ix,it,nx,5,2),ix=1,6),it=1,6),nx=1,2)/
     1 6.478e-02,-4.537e-02, 1.643e-02,-3.490e-03, 2.710e-03,-6.700e-04,
     2-2.223e-02,-2.126e-02, 1.247e-02,-6.290e-03, 1.120e-03,-1.440e-03,
     3-1.340e-03, 1.362e-02,-6.130e-03,-7.900e-04,-9.000e-04,-2.000e-04,
     4 5.080e-03,-3.610e-03, 1.700e-03, 1.830e-03, 6.800e-04, 4.000e-04,
     5-3.580e-03, 6.000e-05,-2.600e-04,-1.050e-03,-3.800e-04,-2.300e-04,
     6 2.420e-03, 9.300e-04,-1.000e-04, 4.500e-04, 1.700e-04, 1.100e-04,
     1 9.868e-01,-1.171e+00, 3.940e-01,-8.459e-02, 1.124e-02,-1.250e-03,
     2 1.001e+00,-1.383e+00, 5.044e-01,-1.152e-01, 1.658e-02,-1.830e-03,
     3 4.928e-02,-1.368e-01, 9.021e-02,-2.935e-02, 5.800e-03,-6.600e-04,
     4-3.133e-02, 5.785e-02,-2.023e-02, 2.630e-03, 1.600e-04,-8.000e-05,
     5 8.840e-03,-1.416e-02, 1.900e-03, 5.800e-04,-2.500e-04, 1.000e-05,
     6-2.300e-03, 3.080e-03, 5.500e-04,-3.700e-04, 7.000e-05, 1.000e-05/
c...expansion coefficients for charm sea quark distribution.
      data (((cehlq(ix,it,nx,6,1),ix=1,6),it=1,6),nx=1,2)/
     1 9.270e-03,-1.817e-02, 9.590e-03,-6.390e-03, 1.690e-03,-1.540e-03,
     2 5.710e-03,-1.188e-02, 6.090e-03,-4.650e-03, 1.240e-03,-1.310e-03,
     3-3.960e-03, 7.100e-03,-3.590e-03, 1.840e-03,-3.900e-04, 3.400e-04,
     4 1.120e-03,-1.960e-03, 1.120e-03,-4.800e-04, 1.000e-04,-4.000e-05,
     5 4.000e-05,-3.000e-05,-1.800e-04, 9.000e-05,-5.000e-05,-2.000e-05,
     6-4.200e-04, 7.300e-04,-1.600e-04, 5.000e-05, 5.000e-05, 5.000e-05,
     1 8.098e-01,-1.042e+00, 3.398e-01,-6.824e-02, 8.760e-03,-9.000e-04,
     2 8.961e-01,-1.217e+00, 4.339e-01,-9.287e-02, 1.304e-02,-1.290e-03,
     3 3.058e-02,-1.040e-01, 7.604e-02,-2.415e-02, 4.600e-03,-5.000e-04,
     4-2.451e-02, 4.432e-02,-1.651e-02, 1.430e-03, 1.200e-04,-1.000e-04,
     5 1.122e-02,-1.457e-02, 2.680e-03, 5.800e-04,-1.200e-04, 3.000e-05,
     6-7.730e-03, 7.330e-03,-7.600e-04,-2.400e-04, 1.000e-05, 0.000e+00/
      data (((cehlq(ix,it,nx,6,2),ix=1,6),it=1,6),nx=1,2)/
     1 9.980e-03,-1.945e-02, 1.055e-02,-6.870e-03, 1.860e-03,-1.560e-03,
     2 5.700e-03,-1.203e-02, 6.250e-03,-4.860e-03, 1.310e-03,-1.370e-03,
     3-4.490e-03, 7.990e-03,-4.170e-03, 2.050e-03,-4.400e-04, 3.300e-04,
     4 1.470e-03,-2.480e-03, 1.460e-03,-5.700e-04, 1.200e-04,-1.000e-05,
     5-9.000e-05, 1.500e-04,-3.200e-04, 1.200e-04,-6.000e-05,-4.000e-05,
     6-4.200e-04, 7.600e-04,-1.400e-04, 4.000e-05, 7.000e-05, 5.000e-05,
     1 8.698e-01,-1.131e+00, 3.836e-01,-8.111e-02, 1.048e-02,-1.300e-03,
     2 9.626e-01,-1.321e+00, 4.854e-01,-1.091e-01, 1.583e-02,-1.700e-03,
     3 3.057e-02,-1.088e-01, 8.022e-02,-2.676e-02, 5.590e-03,-5.600e-04,
     4-2.845e-02, 5.164e-02,-1.918e-02, 2.210e-03,-4.000e-05,-1.500e-04,
     5 1.311e-02,-1.751e-02, 3.310e-03, 5.100e-04,-1.200e-04, 5.000e-05,
     6-8.590e-03, 8.380e-03,-9.200e-04,-2.600e-04, 1.000e-05,-1.000e-05/
c...expansion coefficients for bottom sea quark distribution.
      data (((cehlq(ix,it,nx,7,1),ix=1,6),it=1,6),nx=1,2)/
     1 9.010e-03,-1.401e-02, 7.150e-03,-4.130e-03, 1.260e-03,-1.040e-03,
     2 6.280e-03,-9.320e-03, 4.780e-03,-2.890e-03, 9.100e-04,-8.200e-04,
     3-2.930e-03, 4.090e-03,-1.890e-03, 7.600e-04,-2.300e-04, 1.400e-04,
     4 3.900e-04,-1.200e-03, 4.400e-04,-2.500e-04, 2.000e-05,-2.000e-05,
     5 2.600e-04, 1.400e-04,-8.000e-05, 1.000e-04, 1.000e-05, 1.000e-05,
     6-2.600e-04, 3.200e-04, 1.000e-05,-1.000e-05, 1.000e-05,-1.000e-05,
     1 8.029e-01,-1.075e+00, 3.792e-01,-7.843e-02, 1.007e-02,-1.090e-03,
     2 7.903e-01,-1.099e+00, 4.153e-01,-9.301e-02, 1.317e-02,-1.410e-03,
     3-1.704e-02,-1.130e-02, 2.882e-02,-1.341e-02, 3.040e-03,-3.600e-04,
     4-7.200e-04, 7.230e-03,-5.160e-03, 1.080e-03,-5.000e-05,-4.000e-05,
     5 3.050e-03,-4.610e-03, 1.660e-03,-1.300e-04,-1.000e-05, 1.000e-05,
     6-4.360e-03, 5.230e-03,-1.610e-03, 2.000e-04,-2.000e-05, 0.000e+00/
      data (((cehlq(ix,it,nx,7,2),ix=1,6),it=1,6),nx=1,2)/
     1 8.980e-03,-1.459e-02, 7.510e-03,-4.410e-03, 1.310e-03,-1.070e-03,
     2 5.970e-03,-9.440e-03, 4.800e-03,-3.020e-03, 9.100e-04,-8.500e-04,
     3-3.050e-03, 4.440e-03,-2.100e-03, 8.500e-04,-2.400e-04, 1.400e-04,
     4 5.300e-04,-1.300e-03, 5.600e-04,-2.700e-04, 3.000e-05,-2.000e-05,
     5 2.000e-04, 1.400e-04,-1.100e-04, 1.000e-04, 0.000e+00, 0.000e+00,
     6-2.600e-04, 3.200e-04, 0.000e+00,-3.000e-05, 1.000e-05,-1.000e-05,
     1 8.672e-01,-1.174e+00, 4.265e-01,-9.252e-02, 1.244e-02,-1.460e-03,
     2 8.500e-01,-1.194e+00, 4.630e-01,-1.083e-01, 1.614e-02,-1.830e-03,
     3-2.241e-02,-5.630e-03, 2.815e-02,-1.425e-02, 3.520e-03,-4.300e-04,
     4-7.300e-04, 8.030e-03,-5.780e-03, 1.380e-03,-1.300e-04,-4.000e-05,
     5 3.460e-03,-5.380e-03, 1.960e-03,-2.100e-04, 1.000e-05, 1.000e-05,
     6-4.850e-03, 5.950e-03,-1.890e-03, 2.600e-04,-3.000e-05, 0.000e+00/
c...expansion coefficients for top sea quark distribution.
      data (((cehlq(ix,it,nx,8,1),ix=1,6),it=1,6),nx=1,2)/
     1 4.410e-03,-7.480e-03, 3.770e-03,-2.580e-03, 7.300e-04,-7.100e-04,
     2 3.840e-03,-6.050e-03, 3.030e-03,-2.030e-03, 5.800e-04,-5.900e-04,
     3-8.800e-04, 1.660e-03,-7.500e-04, 4.700e-04,-1.000e-04, 1.000e-04,
     4-8.000e-05,-1.500e-04, 1.200e-04,-9.000e-05, 3.000e-05, 0.000e+00,
     5 1.300e-04,-2.200e-04,-2.000e-05,-2.000e-05,-2.000e-05,-2.000e-05,
     6-7.000e-05, 1.900e-04,-4.000e-05, 2.000e-05, 0.000e+00, 0.000e+00,
     1 6.623e-01,-9.248e-01, 3.519e-01,-7.930e-02, 1.110e-02,-1.180e-03,
     2 6.380e-01,-9.062e-01, 3.582e-01,-8.479e-02, 1.265e-02,-1.390e-03,
     3-2.581e-02, 2.125e-02, 4.190e-03,-4.980e-03, 1.490e-03,-2.100e-04,
     4 7.100e-04, 5.300e-04,-1.270e-03, 3.900e-04,-5.000e-05,-1.000e-05,
     5 3.850e-03,-5.060e-03, 1.860e-03,-3.500e-04, 4.000e-05, 0.000e+00,
     6-3.530e-03, 4.460e-03,-1.500e-03, 2.700e-04,-3.000e-05, 0.000e+00/
      data (((cehlq(ix,it,nx,8,2),ix=1,6),it=1,6),nx=1,2)/
     1 4.260e-03,-7.530e-03, 3.830e-03,-2.680e-03, 7.600e-04,-7.300e-04,
     2 3.640e-03,-6.050e-03, 3.030e-03,-2.090e-03, 5.900e-04,-6.000e-04,
     3-9.200e-04, 1.710e-03,-8.200e-04, 5.000e-04,-1.200e-04, 1.000e-04,
     4-5.000e-05,-1.600e-04, 1.300e-04,-9.000e-05, 3.000e-05, 0.000e+00,
     5 1.300e-04,-2.100e-04,-1.000e-05,-2.000e-05,-2.000e-05,-1.000e-05,
     6-8.000e-05, 1.800e-04,-5.000e-05, 2.000e-05, 0.000e+00, 0.000e+00,
     1 7.146e-01,-1.007e+00, 3.932e-01,-9.246e-02, 1.366e-02,-1.540e-03,
     2 6.856e-01,-9.828e-01, 3.977e-01,-9.795e-02, 1.540e-02,-1.790e-03,
     3-3.053e-02, 2.758e-02, 2.150e-03,-4.880e-03, 1.640e-03,-2.500e-04,
     4 9.200e-04, 4.200e-04,-1.340e-03, 4.600e-04,-8.000e-05,-1.000e-05,
     5 4.230e-03,-5.660e-03, 2.140e-03,-4.300e-04, 6.000e-05, 0.000e+00,
     6-3.890e-03, 5.000e-03,-1.740e-03, 3.300e-04,-4.000e-05, 0.000e+00/

c...the following data lines are coefficients needed in the
c...duke, owens proton structure function parametrizations, see below.
c...expansion coefficients for (up+down) valence quark distribution.
      data ((cdo(ip,is,1,1),is=1,6),ip=1,3)/
     1 4.190e-01, 3.460e+00, 4.400e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2 4.000e-03, 7.240e-01,-4.860e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     3-7.000e-03,-6.600e-02, 1.330e+00, 0.000e+00, 0.000e+00, 0.000e+00/
      data ((cdo(ip,is,1,2),is=1,6),ip=1,3)/
     1 3.740e-01, 3.330e+00, 6.030e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2 1.400e-02, 7.530e-01,-6.220e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     3 0.000e+00,-7.600e-02, 1.560e+00, 0.000e+00, 0.000e+00, 0.000e+00/
c...expansion coefficients for down valence quark distribution.
      data ((cdo(ip,is,2,1),is=1,6),ip=1,3)/
     1 7.630e-01, 4.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2-2.370e-01, 6.270e-01,-4.210e-01, 0.000e+00, 0.000e+00, 0.000e+00,
     3 2.600e-02,-1.900e-02, 3.300e-02, 0.000e+00, 0.000e+00, 0.000e+00/
      data ((cdo(ip,is,2,2),is=1,6),ip=1,3)/
     1 7.610e-01, 3.830e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2-2.320e-01, 6.270e-01,-4.180e-01, 0.000e+00, 0.000e+00, 0.000e+00,
     3 2.300e-02,-1.900e-02, 3.600e-02, 0.000e+00, 0.000e+00, 0.000e+00/
c...expansion coefficients for (up+down+strange) sea quark distribution.
      data ((cdo(ip,is,3,1),is=1,6),ip=1,3)/
     1 1.265e+00, 0.000e+00, 8.050e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2-1.132e+00,-3.720e-01, 1.590e+00, 6.310e+00,-1.050e+01, 1.470e+01,
     3 2.930e-01,-2.900e-02,-1.530e-01,-2.730e-01,-3.170e+00, 9.800e+00/
      data ((cdo(ip,is,3,2),is=1,6),ip=1,3)/
     1 1.670e+00, 0.000e+00, 9.150e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2-1.920e+00,-2.730e-01, 5.300e-01, 1.570e+01,-1.010e+02, 2.230e+02,
     3 5.820e-01,-1.640e-01,-7.630e-01,-2.830e+00, 4.470e+01,-1.170e+02/
c...expansion coefficients for charm sea quark distribution.
      data ((cdo(ip,is,4,1),is=1,6),ip=1,3)/
     1 0.000e+00,-3.600e-02, 6.350e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2 1.350e-01,-2.220e-01, 3.260e+00,-3.030e+00, 1.740e+01,-1.790e+01,
     3-7.500e-02,-5.800e-02,-9.090e-01, 1.500e+00,-1.130e+01, 1.560e+01/
       data ((cdo(ip,is,4,2),is=1,6),ip=1,3)/
     1 0.000e+00,-1.200e-01, 3.510e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     2 6.700e-02,-2.330e-01, 3.660e+00,-4.740e-01, 9.500e+00,-1.660e+01,
     3-3.100e-02,-2.300e-02,-4.530e-01, 3.580e-01,-5.430e+00, 1.550e+01/
c...expansion coefficients for gluon distribution.
      data ((cdo(ip,is,5,1),is=1,6),ip=1,3)/
     1 1.560e+00, 0.000e+00, 6.000e+00, 9.000e+00, 0.000e+00, 0.000e+00,
     2-1.710e+00,-9.490e-01, 1.440e+00,-7.190e+00,-1.650e+01, 1.530e+01,
     3 6.380e-01, 3.250e-01,-1.050e+00, 2.550e-01, 1.090e+01,-1.010e+01/
      data ((cdo(ip,is,5,2),is=1,6),ip=1,3)/
     1 8.790e-01, 0.000e+00, 4.000e+00, 9.000e+00, 0.000e+00, 0.000e+00,
     2-9.710e-01,-1.160e+00, 1.230e+00,-5.640e+00,-7.540e+00,-5.960e-01,
     3 4.340e-01, 4.760e-01,-2.540e-01,-8.170e-01, 5.500e+00, 1.260e-01/

c...the following data lines are coefficients needed in the
c...morfin and tung structure function parametrizations.
c...12 coefficients each for d(valence), u(valence), g, u(sea),
c...d(sea), s, c, b and t, in that order.
c...expansion coefficients for set 1 (fit s1).
      data (((cmt(iex,ipn,ifl,1),ifl=1,9),ipn=0,2),iex=0,3)/
     &   1.30,  1.64,  1.86, -0.60, -0.45, -1.10, -3.87, -6.14,-12.53,
     &  -0.57, -0.33, -2.76, -1.68, -1.64, -1.66,  0.79,  2.65,  8.13,
     &  -0.08, -0.10,  0.10,  0.08,  0.05,  0.13, -0.70, -1.24, -2.64,
     &   0.18,  0.08, -0.17, -0.19, -0.18, -0.19, -0.03, -0.10, -0.38,
     &   0.16,  0.14, -0.07, -0.16, -0.19, -0.09, -0.17, -0.03,  0.34,
     &  -0.02, -0.01,  0.02,  0.04,  0.06,  0.01,  0.03, -0.02, -0.14,
     &   5.27,  3.74,  7.33,  9.31,  9.36,  9.07,  7.96,  6.90, 16.30,
     &   0.43,  0.54, -0.88, -1.17, -1.01, -1.39,  0.95,  1.52,-13.23,
     &   0.06,  0.03, -0.08,  0.29,  0.20,  0.47, -0.38, -0.50,  4.77,
     &  -1.85, -2.04, -0.88, -1.45, -1.48, -1.26,  0.60,  0.80, -0.57,
     &   1.08,  0.88,  2.47,  1.65,  1.49,  1.96,  0.60,  1.05,  3.58,
     &  -0.03,  0.02, -0.32, -0.20, -0.12, -0.36,  0.08, -0.14, -0.99/
c...expansion coefficients for set 2 (fit b1).
      data (((cmt(iex,ipn,ifl,2),ifl=1,9),ipn=0,2),iex=0,3)/
     &   1.34,  1.62,  1.88, -0.99, -0.99, -0.99, -3.98, -6.28,-13.08,
     &  -0.57, -0.33, -2.78, -1.54, -1.54, -1.54,  0.72,  2.62,  8.54,
     &  -0.08, -0.10,  0.13,  0.10,  0.10,  0.10, -0.63, -1.18, -2.70,
     &   0.15,  0.11, -0.33, -0.33, -0.33, -0.33, -0.15, -0.18, -0.40,
     &   0.16,  0.14,  0.10,  0.03,  0.03,  0.03, -0.06,  0.02,  0.31,
     &  -0.02, -0.01, -0.04, -0.03, -0.03, -0.03,  0.00, -0.03, -0.12,
     &   5.30,  3.68,  7.52,  8.53,  8.53,  8.53,  7.46,  6.56, 15.35,
     &   0.43,  0.53, -1.13, -1.08, -1.08, -1.08,  0.96,  1.40,-11.83,
     &   0.06,  0.03,  0.04,  0.39,  0.39,  0.39, -0.30, -0.38,  4.16,
     &  -1.96, -1.94, -1.34, -1.55, -1.55, -1.55,  0.35,  0.65, -0.43,
     &   1.08,  0.87,  2.92,  2.02,  2.02,  2.02,  0.89,  1.13,  3.18,
     &  -0.03,  0.02, -0.49, -0.39, -0.39, -0.39, -0.04, -0.16, -0.82/
c...expansion coefficients for set 3 (fit b2).
      data (((cmt(iex,ipn,ifl,3),ifl=1,9),ipn=0,2),iex=0,3)/
     &   1.38,  1.64,  1.52, -0.85, -0.85, -0.85, -3.74, -6.07,-12.08,
     &  -0.59, -0.33, -2.71, -1.43, -1.43, -1.43,  0.21,  2.33,  7.31,
     &  -0.08, -0.10,  0.15, -0.03, -0.03, -0.03, -0.50, -1.15, -2.35,
     &   0.18,  0.09, -0.72, -0.82, -0.82, -0.82, -0.58, -0.52, -0.73,
     &   0.16,  0.14,  0.45,  0.35,  0.35,  0.35,  0.24,  0.22,  0.54,
     &  -0.02, -0.01, -0.15, -0.09, -0.10, -0.10, -0.07, -0.07, -0.18,
     &   5.40,  3.74,  7.75,  9.19,  9.19,  9.19,  9.63,  8.33, 21.14,
     &   0.42,  0.54, -1.56, -0.92, -0.92, -0.92, -1.13,  0.28,-19.17,
     &   0.06,  0.03,  0.16,  0.12,  0.12,  0.12,  0.25, -0.28,  6.64,
     &  -1.91, -2.02, -2.18, -2.76, -2.76, -2.76, -1.09, -0.52, -1.92,
     &   1.11,  0.88,  3.75,  2.56,  2.56,  2.56,  2.10,  1.91,  4.59,
     &  -0.03,  0.02, -0.76, -0.40, -0.40, -0.40, -0.33, -0.31, -1.25/
c...expansion coefficients for set 4 (fit e1).
      data (((cmt(iex,ipn,ifl,4),ifl=1,9),ipn=0,2),iex=0,3)/
     &   1.43,  1.69,  2.11, -0.84, -0.84, -0.84, -3.87, -6.09,-12.56,
     &  -0.65, -0.33, -3.01, -1.65, -1.65, -1.65,  0.85,  2.81,  8.69,
     &  -0.08, -0.11,  0.18,  0.12,  0.12,  0.12, -0.73, -1.34, -2.93,
     &   0.16,  0.11, -0.33, -0.32, -0.32, -0.32, -0.15, -0.17, -0.38,
     &   0.16,  0.14,  0.10,  0.02,  0.02,  0.02, -0.07,  0.01,  0.30,
     &  -0.02, -0.01, -0.04, -0.03, -0.03, -0.03,  0.00, -0.03, -0.12,
     &   6.17,  3.69,  7.93,  8.96,  8.96,  8.96,  7.83,  6.75, 14.62,
     &   0.43,  0.54, -1.40, -1.24, -1.24, -1.24,  1.00,  1.74,-11.27,
     &   0.06,  0.03,  0.09,  0.45,  0.45,  0.45, -0.36, -0.56,  4.29,
     &  -1.94, -1.99, -1.51, -1.70, -1.70, -1.70,  0.21,  0.54, -0.41,
     &   1.12,  0.90,  3.14,  2.15,  2.15,  2.15,  0.93,  1.15,  3.19,
     &  -0.02,  0.02, -0.55, -0.43, -0.43, -0.43, -0.03, -0.16, -0.87/

c...euler's beta function, requires ordinary gamma function
      eulbet(x,y)=pygamm(x)*pygamm(y)/pygamm(x+y)

c...reset structure functions, check x and hadron flavour.
      alam=0.
      do 100 kfl=-25,25
  100 xpq(kfl)=0.
      if(x.le.0..or.x.ge.1.) then
        write(mstu(11),5000) x
        return
      endif
      kfa=iabs(kf)
      if(kfa.ne.11.and.kfa.ne.22.and.kfa.ne.211.and.kfa.ne.2112.and.
     &kfa.ne.2212) then
        write(mstu(11),5100) kf
        return
      endif

c...call user-supplied structure function.
      if(mstp(51).eq.0.or.mstp(52).ge.2) then
        kfe=kfa
        if(kfa.eq.2112) kfe=2212
        call pystfe(kfe,x,q2,xpq)

      elseif(kfa.eq.11) then
c...electron structure function.
        aem=paru(101)
        pme=pmas(11,1)
        xl=log(max(1d-10,x))
        x1l=log(max(1d-10,1.-x))
        hle=log(max(3.d0,q2/pme**2))
        hbe=(2.*aem/paru(1))*(hle-1.)

c...electron inside electron, see r. kleiss et al., in z physics at
c...lep 1, cern 89-08, p. 34
        if(mstp(11).le.1) then
          hde=1.+(aem/paru(1))*(1.5*hle+1.289868)+(aem/paru(1))**2*
     &    (-2.164868*hle**2+9.840808*hle-10.130464)
          hee=0.5*hbe*(1.-x)**(0.5*hbe-1.)*sqrt(max(0.d0,hde))-
     &    0.25*hbe*(1.+x)+hbe**2/32.*((1.+x)*(-4.*x1l+3.*xl)-
     &    4.*xl/(1.-x)-5.-x)
          hcb=0.5*hbe
        else
          hca=parp(11)
          hcb=parp(12)
          if(mstp(11).eq.3) hcb=hcb+0.5*hbe
          hee=x**hca*(1.-x)**hcb/eulbet(1.+hca,1.+hcb)
        endif
        if(x.gt.0.9999.and.x.le.0.999999) then
          hee=hee*100.**hcb/(100.**hcb-1.)
        elseif(x.gt.0.999999) then
          hee=0.
        endif
        xpq(11)=x*hee

c...photon and (transverse) w- inside electron.
        aemp=ulalem(pme*sqrt(max(0.d0,q2)))/paru(2)
        if(mstp(13).le.1) then
          hlg=hle
        else
          hlg=log((parp(13)/pme**2)*(1.-x)/x**2)
        endif
        xpq(22)=aemp*hlg*(1.+(1.-x)**2)
        hlw=log(1.+q2/pmas(24,1)**2)/(4.*paru(102))
        xpq(-24)=aemp*hlw*(1.+(1.-x)**2)

c..quarks and gluons inside photon inside electron.
        if(mstp(12).eq.1) then
          t= log(min(1d4,max(1.d0,q2))/0.16)
          nf=3
          if(q2.gt.25.) nf=4
          if(q2.gt.300.) nf=5
          nfe=nf-2
          xl=log(max(1d-10,x))

c...numerical integration of struncture function convolution.
          sxpgl=0.
          sxpqu=0.
          sxpqd=0.
          sumxpp=0.
          iter=-1
  110     iter=iter+1
          sumxp=sumxpp
          nstp=2**(iter-1)
          if(iter.eq.0) nstp=2
          sxpgl=0.5*sxpgl
          sxpqu=0.5*sxpqu
          sxpqd=0.5*sxpqd
          wtstp=0.5/nstp
          if(iter.eq.0) wtstp=0.5
          do 120 istp=1,nstp
          if(iter.eq.0) then
            xle=xl*(istp-1)
          else
            xle=xl*(istp-0.5)/nstp
          endif
          xe=exp(xle)
          xg=min(0.999999d0,x/xe)
          xpga=1.+(1.-xe)**2
          call pystga(nfe,xg,t,xpgl,xpqu,xpqd)
          sxpgl=sxpgl+wtstp*xpga*xpgl
          sxpqu=sxpqu+wtstp*xpga*xpqu
  120     sxpqd=sxpqd+wtstp*xpga*xpqd
          sumxpp=sxpgl+sxpqu+sxpqd
          if(iter.le.2.or.(iter.le.7.and.abs(sumxpp-sumxp).gt.
     &    parp(14)*(sumxpp+sumxp))) goto 110
          fconv=aemp*hle*aem*(-xl)

c...put into output arrays.
          xpq(0)=fconv*sxpgl
          xpq(1)=fconv*sxpqd
          xpq(-1)=xpq(1)
          xpq(2)=fconv*sxpqu
          xpq(-2)=xpq(2)
          xpq(3)=fconv*sxpqd
          xpq(-3)=xpq(3)
          if(nfe.ge.2) then
            xpq(4)=fconv*sxpqu
            xpq(-4)=xpq(4)
          endif
          if(nfe.eq.3) then
            xpq(5)=fconv*sxpqd
            xpq(-5)=xpq(5)
          endif
        endif

      elseif(kfa.eq.22) then
c...photon structure function from drees and grassie.
c...allowed variable range: 1 gev^2 < q^2 < 10000 gev^2.
        t=log(min(1d4,max(1.d0,q2))/0.16)
        nf=3
        if(q2.gt.25.) nf=4
        if(q2.gt.300.) nf=5
        nfe=nf-2
        call pystga(nfe,x,t,xpgl,xpqu,xpqd)
        aem=paru(101)

c...put into output arrays.
        xpq(0)=aem*xpgl
        xpq(1)=aem*xpqd
        xpq(-1)=xpq(1)
        xpq(2)=aem*xpqu
        xpq(-2)=xpq(2)
        xpq(3)=aem*xpqd
        xpq(-3)=xpq(3)
        if(nfe.ge.2) then
          xpq(4)=aem*xpqu
          xpq(-4)=xpq(4)
        endif
        if(nfe.eq.3) then
          xpq(5)=aem*xpqd
          xpq(-5)=xpq(5)
        endif

      elseif(kfa.eq.211) then
c...pion structure functions from owens.
c...allowed variable range: 4 gev^2 < q^2 < approx 2000 gev^2.

c...determine set, lambda and s expansion variable.
        nset=1
        if(mstp(51).eq.2.or.mstp(51).eq.4.or.mstp(51).eq.13) nset=2
        if(nset.eq.1) alam=0.2
        if(nset.eq.2) alam=0.4
        if(mstp(52).le.0) then
          sd=0.
        else
          q2in=min(2d3,max(4.d0,q2))
          sd=log(log(q2in/alam**2)/log(4./alam**2))
        endif

c...calculate structure functions.
        do 140 kfl=1,4
        do 130 is=1,5
  130   ts(is)=cow(1,is,kfl,nset)+cow(2,is,kfl,nset)*sd+
     &  cow(3,is,kfl,nset)*sd**2
        if(kfl.eq.1) then
          xq(kfl)=x**ts(1)*(1.-x)**ts(2)/eulbet(ts(1),ts(2)+1.)
        else
          xq(kfl)=ts(1)*x**ts(2)*(1.-x)**ts(3)*(1.+ts(4)*x+ts(5)*x**2)
        endif
  140   continue

c...put into output arrays.
        xpq(0)=xq(2)
        xpq(1)=xq(3)/6.
        xpq(2)=xq(1)+xq(3)/6.
        xpq(3)=xq(3)/6.
        xpq(4)=xq(4)
        xpq(-1)=xq(1)+xq(3)/6.
        xpq(-2)=xq(3)/6.
        xpq(-3)=xq(3)/6.
        xpq(-4)=xq(4)

      elseif(mstp(51).eq.1.or.mstp(51).eq.2) then
c...proton structure functions from eichten, hinchliffe, lane, quigg.
c...allowed variable range: 5 gev^2 < q^2 < 1e8 gev^2; 1e-4 < x < 1

c...determine set, lamdba and x and t expansion variables.
        nset=mstp(51)
        if(nset.eq.1) alam=0.2
        if(nset.eq.2) alam=0.29
        tmin=log(5./alam**2)
        tmax=log(1e8/alam**2)
        if(mstp(52).eq.0) then
          t=tmin
        else
          t=log(max(1.d0,q2/alam**2))
        endif
        vt=max(-1.d0,min(1.d0,(2.*t-tmax-tmin)/(tmax-tmin)))
        nx=1
        if(x.le.0.1) nx=2
        if(nx.eq.1) vx=(2.*x-1.1)/0.9
        if(nx.eq.2) vx=max(-1.d0,(2.*log(x)+11.51293)/6.90776)
        cxs=1.
        if(x.lt.1e-4.and.abs(parp(51)-1.).gt.0.01) cxs=
     &  (1e-4/x)**(parp(51)-1.)

c...chebyshev polynomials for x and t expansion.
        tx(1)=1.
        tx(2)=vx
        tx(3)=2.*vx**2-1.
        tx(4)=4.*vx**3-3.*vx
        tx(5)=8.*vx**4-8.*vx**2+1.
        tx(6)=16.*vx**5-20.*vx**3+5.*vx
        tt(1)=1.
        tt(2)=vt
        tt(3)=2.*vt**2-1.
        tt(4)=4.*vt**3-3.*vt
        tt(5)=8.*vt**4-8.*vt**2+1.
        tt(6)=16.*vt**5-20.*vt**3+5.*vt

c...calculate structure functions.
        do 160 kfl=1,6
        xqsum=0.
        do 150 it=1,6
        do 150 ix=1,6
  150   xqsum=xqsum+cehlq(ix,it,nx,kfl,nset)*tx(ix)*tt(it)
  160   xq(kfl)=xqsum*(1.-x)**nehlq(kfl,nset)*cxs

c...put into output array.
        xpq(0)=xq(4)
        xpq(1)=xq(2)+xq(3)
        xpq(2)=xq(1)+xq(3)
        xpq(3)=xq(5)
        xpq(4)=xq(6)
        xpq(-1)=xq(3)
        xpq(-2)=xq(3)
        xpq(-3)=xq(5)
        xpq(-4)=xq(6)

c...special expansion for bottom (threshold effects).
        if(mstp(54).ge.5) then
          if(nset.eq.1) tmin=8.1905
          if(nset.eq.2) tmin=7.4474
          if(t.le.tmin) goto 180
          vt=max(-1.d0,min(1.d0,(2.*t-tmax-tmin)/(tmax-tmin)))
          tt(1)=1.
          tt(2)=vt
          tt(3)=2.*vt**2-1.
          tt(4)=4.*vt**3-3.*vt
          tt(5)=8.*vt**4-8.*vt**2+1.
          tt(6)=16.*vt**5-20.*vt**3+5.*vt
          xqsum=0.
          do 170 it=1,6
          do 170 ix=1,6
  170     xqsum=xqsum+cehlq(ix,it,nx,7,nset)*tx(ix)*tt(it)
          xpq(5)=xqsum*(1.-x)**nehlq(7,nset)*cxs
          xpq(-5)=xpq(5)
  180     continue
        endif

c...special expansion for top (threshold effects).
        if(mstp(54).ge.6) then
          if(nset.eq.1) tmin=11.5528
          if(nset.eq.2) tmin=10.8097
          tmin=tmin+2.*log(pmas(6,1)/30.)
          tmax=tmax+2.*log(pmas(6,1)/30.)
          if(t.le.tmin) goto 200
          vt=max(-1.d0,min(1.d0,(2.*t-tmax-tmin)/(tmax-tmin)))
          tt(1)=1.
          tt(2)=vt
          tt(3)=2.*vt**2-1.
          tt(4)=4.*vt**3-3.*vt
          tt(5)=8.*vt**4-8.*vt**2+1.
          tt(6)=16.*vt**5-20.*vt**3+5.*vt
          xqsum=0.
          do 190 it=1,6
          do 190 ix=1,6
  190     xqsum=xqsum+cehlq(ix,it,nx,8,nset)*tx(ix)*tt(it)
          xpq(6)=xqsum*(1.-x)**nehlq(8,nset)*cxs
          xpq(-6)=xpq(6)
  200     continue
        endif

      elseif(mstp(51).eq.3.or.mstp(51).eq.4) then
c...proton structure functions from duke, owens.
c...allowed variable range: 4 gev^2 < q^2 < approx 1e6 gev^2.

c...determine set, lambda and s expansion parameter.
        nset=mstp(51)-2
        if(nset.eq.1) alam=0.2
        if(nset.eq.2) alam=0.4
        if(mstp(52).le.0) then
          sd=0.
        else
          q2in=min(1d6,max(4.d0,q2))
          sd=log(log(q2in/alam**2)/log(4./alam**2))
        endif

c...calculate structure functions.
        do 220 kfl=1,5
        do 210 is=1,6
  210   ts(is)=cdo(1,is,kfl,nset)+cdo(2,is,kfl,nset)*sd+
     &  cdo(3,is,kfl,nset)*sd**2
        if(kfl.le.2) then
          xq(kfl)=x**ts(1)*(1.-x)**ts(2)*(1.+ts(3)*x)/(eulbet(ts(1),
     &    ts(2)+1.)*(1.+ts(3)*ts(1)/(ts(1)+ts(2)+1.)))
        else
          xq(kfl)=ts(1)*x**ts(2)*(1.-x)**ts(3)*(1.+ts(4)*x+ts(5)*x**2+
     &    ts(6)*x**3)
        endif
  220   continue

c...put into output arrays.
        xpq(0)=xq(5)
        xpq(1)=xq(2)+xq(3)/6.
        xpq(2)=3.*xq(1)-xq(2)+xq(3)/6.
        xpq(3)=xq(3)/6.
        xpq(4)=xq(4)
        xpq(-1)=xq(3)/6.
        xpq(-2)=xq(3)/6.
        xpq(-3)=xq(3)/6.
        xpq(-4)=xq(4)

      elseif(mstp(51).ge.5.and.mstp(51).le.8) then
c...proton structure functions from morfin and tung.
c...allowed variable range: 4 gev^2 < q^2 < 1e8 gev^2, 0 < x < 1.

c...calculate expansion parameters.
        nset=mstp(51)-4
        if(nset.eq.1) alam=0.187
        if(nset.eq.2) alam=0.212
        if(nset.eq.3) alam=0.191
        if(nset.eq.4) alam=0.155
        if(mstp(52).eq.0) then
          sd=0.
        else
          sd=log(log(max(4.d0,q2)/alam**2)/log(4./alam**2))
        endif
        xl=log(max(1d-10,x))
        x1l=log(max(1d-10,1.-x))
        xll=log(max(1d-10,log(1.+1./max(1d-10,x))))

c...calculate structure functions up to b.
        do 240 ip=1,8
        do 230 iex=0,3
  230   exmt(iex)=cmt(iex,0,ip,nset)+cmt(iex,1,ip,nset)*sd+
     &  cmt(iex,2,ip,nset)*sd**2
        exmts=exmt(0)+exmt(1)*xl+exmt(2)*x1l+exmt(3)*xll
        if(exmts.lt.-50.) then
          xq(ip)=0.
        else
          xq(ip)=exp(exmts)
        endif
  240   continue
        if(q2.le.2.25) xq(7)=0
        if(q2.le.25.0) xq(8)=0

c...calculate t structure function, shifting effective q scale for
c...nondefault t mass, q_actual = q_nominal * m_t_nominal/m_t_actual.
        if(mstp(52).eq.0.or.q2.le.pmas(6,1)**2) then
          xq(9)=0.
        else
          sd=log(log(max(4.d0,q2)/alam**2*(100./pmas(6,1))**2)/
     &    log(4./alam**2))
          do 250 iex=0,3
  250     exmt(iex)=cmt(iex,0,9,nset)+cmt(iex,1,9,nset)*sd+
     &    cmt(iex,2,9,nset)*sd**2
          exmts=exmt(0)+exmt(1)*xl+exmt(2)*x1l+exmt(3)*xll
          if(exmts.lt.-50.) then
            xq(ip)=0.
          else
            xq(ip)=exp(exmts)
          endif
        endif

c...put into output array.
        xpq(0)=xq(3)
        xpq(1)=xq(1)+xq(5)
        xpq(-1)=xq(5)
        xpq(2)=xq(2)+xq(4)
        xpq(-2)=xq(4)
        xpq(3)=xq(6)
        xpq(-3)=xq(6)
        xpq(4)=xq(7)
        xpq(-4)=xq(7)
        xpq(5)=xq(8)
        xpq(-5)=xq(8)
        xpq(6)=xq(9)
        xpq(-6)=xq(9)

      elseif(mstp(51).eq.9) then
c...lowest order parametrization of gluck, reya, vogt.
c...allowed variable range: 0.2 gev^2 < q2 < 1e6 gev^2; 1e-4 < x < 1;
c...extended to 0.2 gev^2 < q2 < 1e8 gev^2; 1e-6 < x < 1
c...after consultation with the authors.

c...determine s and x.
        alam=0.25
        if(mstp(52).eq.0) then
          sd=0.
        else
          q2in=min(1d8,max(0.2d0,q2))
          sd=log(log(q2in/alam**2)/log(0.2/alam**2))
        endif
        xc=max(1d-6,x)
        xl=-log(xc)

c...calculate structure functions.
        xq(1)=(0.794+0.312*sd)*xc**(0.427-0.011*sd)*
     &  (1.+(6.887-2.227*sd)*xc+(-11.083+2.136*sd)*xc**2+
     &  (3.900+1.079*sd)*xc**3)*(1.-xc)**(1.037+1.077*sd)
        xq(2)=(0.486+0.139*sd)*xc**(0.434-0.018*sd)*
     &  (1.+(7.716-2.684*sd)*xc+(-12.768+3.122*sd)*xc**2+
     &  (4.564+0.470*sd)*xc**3)*(1.-xc)**(1.889+1.129*sd)
        xq(3)=(xc**(0.415+0.186*sd)*((0.786+0.942*sd)+
     &  (5.256-5.810*sd)*xc+(-4.599+5.842*sd)*xc**2)+sd**0.592*
     &  exp(-(0.398+2.135*sd)+sqrt(3.779*sd**1.250*xl)))*
     &  (1.-xc)**(1.622+1.980*sd)
        xq(4)=sd**0.448*(1.-xc)**(5.540-0.445*sd)*
     &  exp(-(4.668+1.230*sd)+sqrt((13.173-1.361*sd)*sd**0.442*xl))/
     &  xl**(3.181-0.862*sd)
        xq(5)=0.
        if(sd.gt.1.125) xq(5)=(sd-1.125)*(1.-xc)**(2.038+1.022*sd)*
     &  exp(-(4.290+1.569*sd)+sqrt((2.982+1.452*sd)*sd**0.5*xl))
        xq(6)=0.
        if(sd.gt.1.603) xq(6)=(sd-1.603)*(1.-xc)**(2.230+1.052*sd)*
     &  exp(-(4.566+1.559*sd)+sqrt((4.147+1.268*sd)*sd**0.5*xl))

c...put into output array - special factor for small x.
        cxs=1.
        if(x.lt.1e-6.and.abs(parp(51)-1.).gt.0.01)
     &  cxs=(1e-6/x)**(parp(51)-1.)
        xpq(0)=cxs*xq(3)
        xpq(1)=cxs*(xq(2)+xq(4))
        xpq(-1)=cxs*xq(4)
        xpq(2)=cxs*(xq(1)+xq(4))
        xpq(-2)=cxs*xq(4)
        xpq(3)=cxs*xq(4)
        xpq(-3)=cxs*xq(4)
        xpq(4)=cxs*xq(5)
        xpq(-4)=cxs*xq(5)
        xpq(5)=cxs*xq(6)
        xpq(-5)=cxs*xq(6)

      elseif(mstp(51).eq.10) then
c...higher order parametrization of gluck, reya, vogt.
c...allowed variable range: 0.2 gev^2 < q2 < 1e6 gev^2; 1e-4 < x < 1;
c...extended to 0.2 gev^2 < q2 < 1e8 gev^2; 1e-6 < x < 1
c...after consultation with the authors.

c...determine s and x.
        alam=0.20
        if(mstp(52).eq.0) then
          sd=0.
        else
          q2in=min(1d8,max(0.2d0,q2))
          sd=log(log(q2in/alam**2)/log(0.2/alam**2))
        endif
        sd2=sd**2
        xc=max(1d-6,x)
        xl=-log(xc)

c...calculate structure functions.
        xq(1)=(1.364+0.989*sd-0.236*sd2)*xc**(0.593-0.048*sd)*
     &  (1.+(8.912-6.092*sd+0.852*sd2)*xc+(-16.737+7.039*sd)*xc**2+
     &  (10.275+0.806*sd-2.000*sd2)*xc**3)*
     &  (1.-xc)**(2.043+1.408*sd-0.283*sd2)
        xq(2)=(0.835+0.527*sd-0.144*sd2)*xc**(0.600-0.054*sd)*
     &  (1.+(10.245-7.821*sd+1.325*sd2)*xc+(-19.511+10.940*sd-
     &  1.133*sd2)*xc**2+(12.836-2.570*sd-1.041*sd2)*xc**3)*
     &  (1.-xc)**(3.083+1.382*sd-0.276*sd2)
        xq(3)=(xc**(0.321-0.135*sd)*((10.51-2.299*sd)+
     &  (-17.28+0.755*sd)*xc+(8.242+2.543*sd)*xc**2)*
     &  xl**(-2.023-0.103*sd)+sd**1.044*
     &  exp(-(-1.178+2.792*sd)+sqrt(2.318*sd**1.673*xl)))*
     &  (1.-xc)**(3.720+2.337*sd-0.199*sd2)
        xq(4)=sd**0.761*(1.+(6.078-2.065*sd)*xc)*(1.-xc)**(4.654+
     &  0.603*sd-0.326*sd2)*exp(-(4.231+1.036*sd)+sqrt(3.419*sd**0.316*
     &  xl))/xl**(0.897-0.618*sd)
        xq(5)=0.
        if(sd.gt.0.918) xq(5)=(sd-0.918)*(1.-xc)**(3.328+0.859*sd)*
     &  exp(-(3.837+1.504*sd)+sqrt((2.150+1.291*sd)*sd**0.5*xl))
        xq(6)=0.
        if(sd.gt.1.353) xq(6)=(sd-1.353)*(1.-xc)**(3.382+0.909*sd)*
     &  exp(-(4.130+1.486*sd)+sqrt((2.895+1.240*sd)*sd**0.5*xl))

c...put into output array - special factor for small x.
        cxs=1.
        if(x.lt.1e-6.and.abs(parp(51)-1.).gt.0.01)
     &  cxs=(1e-6/x)**(parp(51)-1.)
        xpq(0)=cxs*xq(3)
        xpq(1)=cxs*(xq(2)+xq(4))
        xpq(-1)=cxs*xq(4)
        xpq(2)=cxs*(xq(1)+xq(4))
        xpq(-2)=cxs*xq(4)
        xpq(3)=cxs*xq(4)
        xpq(-3)=cxs*xq(4)
        xpq(4)=cxs*xq(5)
        xpq(-4)=cxs*xq(5)
        xpq(5)=cxs*xq(6)
        xpq(-5)=cxs*xq(6)

c...proton structure functions from diemoz, ferroni, longo, martinelli.
c...these are accessed via pystfe since the files needed may not always
c...available.
      elseif(mstp(51).ge.11.and.mstp(51).le.13) then
        call pystfe(2212,x,q2,xpq)

c...unknown proton parametrization.
      else
        write(mstu(11),5200) mstp(51)
      endif

c...isospin conjugation for neutron.
      if(kfa.eq.2112) then
        xps=xpq(1)
        xpq(1)=xpq(2)
        xpq(2)=xps
        xps=xpq(-1)
        xpq(-1)=xpq(-2)
        xpq(-2)=xps
      endif

c...charge conjugation for antiparticle.
      if(kf.lt.0) then
        do 260 kfl=1,25
        if(kfl.eq.21.or.kfl.eq.22.or.kfl.eq.23.or.kfl.eq.25) goto 260
        xps=xpq(kfl)
        xpq(kfl)=xpq(-kfl)
        xpq(-kfl)=xps
  260   continue
      endif

c...check positivity and reset above maximum allowed flavour.
      do 270 kfl=-25,25
      xpq(kfl)=max(0.d0,xpq(kfl))
  270 if(iabs(kfl).le.8.and.iabs(kfl).gt.mstp(54)) xpq(kfl)=0.

c...formats for error printouts.
 5000 format(' error: x value outside physical range, x =',1p,e12.3)
 5100 format(' error: illegal particle code for structure function,',
     &' kf =',i5)
 5200 format(' error: bad value of parameter mstp(51) in pystfu,',
     &' mstp(51) =',i5)

      return
      end

c*********************************************************************

      subroutine pystga(nfe,x,t,xpgl,xpqu,xpqd)
      implicit double precision (a-h,o-z)

c...gives photon structure function; external to pystfu since it
c...may be called several times for convolution of photon structure
c...functions with photons in electron structure function.
      dimension dgag(4,3),dgbg(4,3),dgcg(4,3),dgan(4,3),dgbn(4,3),
     &dgcn(4,3),dgdn(4,3),dgen(4,3),dgas(4,3),dgbs(4,3),dgcs(4,3),
     &dgds(4,3),dges(4,3)

c...the following data lines are coefficients needed in the
c...drees and grassie photon structure function parametrizations.
      data dgag/-.207e0,.6158e0,1.074e0,0.e0,.8926e-2,.6594e0,
     &.4766e0,.1975e-1,.03197e0,1.018e0,.2461e0,.2707e-1/
      data dgbg/-.1987e0,.6257e0,8.352e0,5.024e0,.5085e-1,.2774e0,
     &-.3906e0,-.3212e0,-.618e-2,.9476e0,-.6094e0,-.1067e-1/
      data dgcg/5.119e0,-.2752e0,-6.993e0,2.298e0,-.2313e0,.1382e0,
     &6.542e0,.5162e0,-.1216e0,.9047e0,2.653e0,.2003e-2/
      data dgan/2.285e0,-.1526e-1,1330.e0,4.219e0,-.3711e0,1.061e0,
     &4.758e0,-.1503e-1,15.8e0,-.9464e0,-.5e0,-.2118e0/
      data dgbn/6.073e0,-.8132e0,-41.31e0,3.165e0,-.1717e0,.7815e0,
     &1.535e0,.7067e-2,2.742e0,-.7332e0,.7148e0,3.287e0/
      data dgcn/-.4202e0,.1778e-1,.9216e0,.18e0,.8766e-1,.2197e-1,
     &.1096e0,.204e0,.2917e-1,.4657e-1,.1785e0,.4811e-1/
      data dgdn/-.8083e-1,.6346e0,1.208e0,.203e0,-.8915e0,.2857e0,
     &2.973e0,.1185e0,-.342e-1,.7196e0,.7338e0,.8139e-1/
      data dgen/.5526e-1,1.136e0,.9512e0,.1163e-1,-.1816e0,.5866e0,
     &2.421e0,.4059e0,-.2302e-1,.9229e0,.5873e0,-.79e-4/
      data dgas/16.69e0,-.7916e0,1099.e0,4.428e0,-.1207e0,1.071e0,
     &1.977e0,-.8625e-2,6.734e0,-1.008e0,-.8594e-1,.7625e-1/
      data dgbs/.176e0,.4794e-1,1.047e0,.25e-1,25.e0,-1.648e0,
     &-.1563e-1,6.438e0,59.88e0,-2.983e0,4.48e0,.9686e0/
      data dgcs/-.208e-1,.3386e-2,4.853e0,.8404e0,-.123e-1,1.162e0,
     &.4824e0,-.11e-1,-.3226e-2,.8432e0,.3616e0,.1383e-2/
      data dgds/-.1685e-1,1.353e0,1.426e0,1.239e0,-.9194e-1,.7912e0,
     &.6397e0,2.327e0,-.3321e-1,.9475e0,-.3198e0,.2132e-1/
      data dges/-.1986e0,1.1e0,1.136e0,-.2779e0,.2015e-1,.9869e0,
     &-.7036e-1,.1694e-1,.1059e0,.6954e0,-.6663e0,.3683e0/

c...photon structure function from drees and grassie.
c...allowed variable range: 1 gev^2 < q^2 < 10000 gev^2.
      x1=1.-x

c...evaluate gluon content.
      dga=dgag(1,nfe)*t**dgag(2,nfe)+dgag(3,nfe)*t**(-dgag(4,nfe))
      dgb=dgbg(1,nfe)*t**dgbg(2,nfe)+dgbg(3,nfe)*t**(-dgbg(4,nfe))
      dgc=dgcg(1,nfe)*t**dgcg(2,nfe)+dgcg(3,nfe)*t**(-dgcg(4,nfe))
      xpgl=dga*x**dgb*x1**dgc

c...evaluate up- and down-type quark content.
      dga=dgan(1,nfe)*t**dgan(2,nfe)+dgan(3,nfe)*t**(-dgan(4,nfe))
      dgb=dgbn(1,nfe)*t**dgbn(2,nfe)+dgbn(3,nfe)*t**(-dgbn(4,nfe))
      dgc=dgcn(1,nfe)*t**dgcn(2,nfe)+dgcn(3,nfe)*t**(-dgcn(4,nfe))
      dgd=dgdn(1,nfe)*t**dgdn(2,nfe)+dgdn(3,nfe)*t**(-dgdn(4,nfe))
      dge=dgen(1,nfe)*t**dgen(2,nfe)+dgen(3,nfe)*t**(-dgen(4,nfe))
      xpqn=x*(x**2+x1**2)/(dga-dgb*log(x1))+dgc*x**dgd*x1**dge
      dga=dgas(1,nfe)*t**dgas(2,nfe)+dgas(3,nfe)*t**(-dgas(4,nfe))
      dgb=dgbs(1,nfe)*t**dgbs(2,nfe)+dgbs(3,nfe)*t**(-dgbs(4,nfe))
      dgc=dgcs(1,nfe)*t**dgcs(2,nfe)+dgcs(3,nfe)*t**(-dgcs(4,nfe))
      dgd=dgds(1,nfe)*t**dgds(2,nfe)+dgds(3,nfe)*t**(-dgds(4,nfe))
      dge=dges(1,nfe)*t**dges(2,nfe)+dges(3,nfe)*t**(-dges(4,nfe))
      dgf=9.
      if(nfe.eq.2) dgf=10.
      if(nfe.eq.3) dgf=55./6.
      xpqs=dgf*x*(x**2+x1**2)/(dga-dgb*log(x1))+dgc*x**dgd*x1**dge
      if(nfe.le.1) then
        xpqu=(xpqs+9.*xpqn)/6.
        xpqd=(xpqs-4.5*xpqn)/6.
      elseif(nfe.eq.2) then
        xpqu=(xpqs+6.*xpqn)/8.
        xpqd=(xpqs-6.*xpqn)/8.
      else
        xpqu=(xpqs+7.5*xpqn)/10.
        xpqd=(xpqs-5.*xpqn)/10.
      endif

      return
      end


c*********************************************************************

      subroutine pyspli(kf,kflin,kflch,kflsp)
      implicit double precision (a-h,o-z)

c...in case of a hadron remnant which is more complicated than just a
c...quark or a diquark, split it into two (partons or hadron + parton).
      dimension kfl(3)

c...preliminaries. parton composition.
      kfa=iabs(kf)
      kfs=isign(1,kf)
      kfl(1)=mod(kfa/1000,10)
      kfl(2)=mod(kfa/100,10)
      kfl(3)=mod(kfa/10,10)
      if(kflin.ne.21.and.kflin.ne.22.and.kflin.ne.23) then
        kflr=kflin*kfs
      else
        kflr=kflin
      endif
      kflch=0

c...subdivide lepton.
      if(kfa.ge.11.and.kfa.le.18) then
        if(kflr.eq.kfa) then
          kflsp=kfs*22
        elseif(kflr.eq.22) then
          kflsp=kfa
        elseif(kflr.eq.-24.and.mod(kfa,2).eq.1) then
          kflsp=kfa+1
        elseif(kflr.eq.24.and.mod(kfa,2).eq.0) then
          kflsp=kfa-1
        elseif(kflr.eq.21) then
          kflsp=kfa
          kflch=kfs*21
        else
          kflsp=kfa
          kflch=-kflr
        endif

c...subdivide photon.
      elseif(kfa.eq.22) then
        if(kflr.ne.21) then
          kflsp=-kflr
        else
          ragr=0.75*rlu(0)
          kflsp=1
          if(ragr.gt.0.125) kflsp=2
          if(ragr.gt.0.625) kflsp=3
          if(rlu(0).gt.0.5) kflsp=-kflsp
          kflch=-kflsp
        endif

c...subdivide meson.
      elseif(kfl(1).eq.0) then
        kfl(2)=kfl(2)*(-1)**kfl(2)
        kfl(3)=-kfl(3)*(-1)**iabs(kfl(2))
        if(kflr.eq.kfl(2)) then
          kflsp=kfl(3)
        elseif(kflr.eq.kfl(3)) then
          kflsp=kfl(2)
        elseif(kflr.eq.21.and.rlu(0).gt.0.5) then
          kflsp=kfl(2)
          kflch=kfl(3)
        elseif(kflr.eq.21) then
          kflsp=kfl(3)
          kflch=kfl(2)
        elseif(kflr*kfl(2).gt.0) then
          call lukfdi(-kflr,kfl(2),kfdump,kflch)
          kflsp=kfl(3)
        else
          call lukfdi(-kflr,kfl(3),kfdump,kflch)
          kflsp=kfl(2)
        endif

c...subdivide baryon.
      else
        nagr=0
        do 100 j=1,3
  100   if(kflr.eq.kfl(j)) nagr=nagr+1
        if(nagr.ge.1) then
          ragr=0.00001+(nagr-0.00002)*rlu(0)
          iagr=0
          do 110 j=1,3
          if(kflr.eq.kfl(j)) ragr=ragr-1.
  110     if(iagr.eq.0.and.ragr.le.0.) iagr=j
        else
          iagr=1.00001+2.99998*rlu(0)
        endif
        id1=1
        if(iagr.eq.1) id1=2
        if(iagr.eq.1.and.kfl(3).gt.kfl(2)) id1=3
        id2=6-iagr-id1
        ksp=3
        if(mod(kfa,10).eq.2.and.kfl(1).eq.kfl(2)) then
          if(iagr.ne.3.and.rlu(0).gt.0.25) ksp=1
        elseif(mod(kfa,10).eq.2.and.kfl(2).ge.kfl(3)) then
          if(iagr.ne.1.and.rlu(0).gt.0.25) ksp=1
        elseif(mod(kfa,10).eq.2) then
          if(iagr.eq.1) ksp=1
          if(iagr.ne.1.and.rlu(0).gt.0.75) ksp=1
        endif
        kflsp=1000*kfl(id1)+100*kfl(id2)+ksp
        if(kflr.eq.21) then
          kflch=kfl(iagr)
        elseif(nagr.eq.0.and.kflr.gt.0) then
          call lukfdi(-kflr,kfl(iagr),kfdump,kflch)
        elseif(nagr.eq.0) then
          call lukfdi(10000+kflsp,-kflr,kfdump,kflch)
          kflsp=kfl(iagr)
        endif
      endif

c...add on correct sign for result.
      kflch=kflch*kfs
      kflsp=kflsp*kfs

      return
      end

c*********************************************************************

      real*8 function pygamm(x)
      implicit double precision (a-h,o-z)

c...gives ordinary gamma function gamma(x) for positive, real arguments;
c...see m. abramowitz, i. a. stegun: handbook of mathematical functions
c...(dover, 1965) 6.1.36.
      dimension b(8)
      data b/-0.577191652,0.988205891,-0.897056937,0.918206857,
     &-0.756704078,0.482199394,-0.193527818,0.035868343/

      nx=int(x)
      dx=x-nx

      pygamm=1.
      dxp=1.
      do 100 i=1,8
      dxp=dxp*dx
  100 pygamm=pygamm+b(i)*dxp
      if(x.lt.1.) then
        pygamm=pygamm/x
      else
        do 110 ix=1,nx-1
  110   pygamm=(x-ix)*pygamm
      endif

      return
      end

c***********************************************************************

      subroutine pywaux(iaux,eps,wre,wim)
      implicit double precision (a-h,o-z)

c...calculates real and imaginary parts of the auxiliary functions w1
c...and w2; see r. k. ellis, i. hinchliffe, m. soldate and j. j. van
c...der bij, nucl. phys. b297 (1988) 221.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      asinh(x)=log(x+sqrt(x**2+1.))
      acosh(x)=log(x+sqrt(x**2-1.))

      if(eps.lt.0.) then
        if(iaux.eq.1) wre=2.*sqrt(1.-eps)*asinh(sqrt(-1./eps))
        if(iaux.eq.2) wre=4.*(asinh(sqrt(-1./eps)))**2
        wim=0.
      elseif(eps.lt.1.) then
        if(iaux.eq.1) wre=2.*sqrt(1.-eps)*acosh(sqrt(1./eps))
        if(iaux.eq.2) wre=4.*(acosh(sqrt(1./eps)))**2-paru(1)**2
        if(iaux.eq.1) wim=-paru(1)*sqrt(1.-eps)
        if(iaux.eq.2) wim=-4.*paru(1)*acosh(sqrt(1./eps))
      else
        if(iaux.eq.1) wre=2.*sqrt(eps-1.)*asin(sqrt(1./eps))
        if(iaux.eq.2) wre=-4.*(asin(sqrt(1./eps)))**2
        wim=0.
      endif

      return
      end

c***********************************************************************

      subroutine pyi3au(eps,rat,y3re,y3im)
      implicit double precision (a-h,o-z)

c...calculates real and imaginary parts of the auxiliary function i3;
c...see r. k. ellis, i. hinchliffe, m. soldate and j. j. van der bij,
c...nucl. phys. b297 (1988) 221.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      be=0.5*(1.+sqrt(1.+rat*eps))
      if(eps.lt.1.) ga=0.5*(1.+sqrt(1.-eps))

      if(eps.lt.0.) then
        if(abs(eps).lt.1.e-4.and.abs(rat*eps).lt.1.e-4) then
          f3re=pyspen(-0.25*eps/(1.+0.25*(rat-1.)*eps),0.d0,1)-
     &    pyspen((1.-0.25*eps)/(1.+0.25*(rat-1.)*eps),0.d0,1)+
     &    pyspen(0.25*(rat+1.)*eps/(1.+0.25*rat*eps),0.d0,1)-
     &    pyspen((rat+1.)/rat,0.d0,1)+0.5*(log(1.+0.25*rat*eps)**2-
     &    log(0.25*rat*eps)**2)+log(1.-0.25*eps)*
     &    log((1.+0.25*(rat-1.)*eps)/(1.+0.25*rat*eps))+
     &    log(-0.25*eps)*log(0.25*rat*eps/(1.+0.25*(rat-1.)*eps))
        elseif(abs(eps).lt.1.e-4.and.abs(rat*eps).ge.1.e-4) then
          f3re=pyspen(-0.25*eps/(be-0.25*eps),0.d0,1)-
     &    pyspen((1.-0.25*eps)/(be-0.25*eps),0.d0,1)+
     &    pyspen((be-1.+0.25*eps)/be,0.d0,1)-
     &    pyspen((be-1.+0.25*eps)/(be-1.),0.d0,1)+
     &    0.5*(log(be)**2-log(be-1.)**2)+
     &    log(1.-0.25*eps)*log((be-0.25*eps)/be)+
     &    log(-0.25*eps)*log((be-1.)/(be-0.25*eps))
        elseif(abs(eps).ge.1.e-4.and.abs(rat*eps).lt.1.e-4) then
          f3re=pyspen((ga-1.)/(ga+0.25*rat*eps),0.d0,1)-
     &    pyspen(ga/(ga+0.25*rat*eps),0.d0,1)+
     &    pyspen((1.+0.25*rat*eps-ga)/(1.+0.25*rat*eps),0.d0,1)-
     &    pyspen((1.+0.25*rat*eps-ga)/(0.25*rat*eps),0.d0,1)+
     &    0.5*(log(1.+0.25*rat*eps)**2-log(0.25*rat*eps)**2)+
     &    log(ga)*log((ga+0.25*rat*eps)/(1.+0.25*rat*eps))+
     &    log(ga-1.)*log(0.25*rat*eps/(ga+0.25*rat*eps))
        else
          f3re=pyspen((ga-1.)/(ga+be-1.),0.d0,1)-
     &    pyspen(ga/(ga+be-1.),0.,1)+pyspen((be-ga)/be,0.d0,1)-
     &    pyspen((be-ga)/(be-1.),0.d0,1)+
     &    0.5*(log(be)**2-log(be-1.)**2)+
     &    log(ga)*log((ga+be-1.)/be)+log(ga-1.)*log((be-1.)/(ga+be-1.))
        endif
        f3im=0.
      elseif(eps.lt.1.) then
        if(abs(eps).lt.1.e-4.and.abs(rat*eps).lt.1.e-4) then
          f3re=pyspen(-0.25*eps/(1.+0.25*(rat-1.)*eps),0.d0,1)-
     &    pyspen((1.-0.25*eps)/(1.+0.25*(rat-1.)*eps),0.d0,1)+
     &    pyspen((1.-0.25*eps)/(-0.25*(rat+1.)*eps),0.d0,1)-
     &    pyspen(1./(rat+1.),0.d0,1)+log((1.-0.25*eps)/(0.25*eps))*
     &    log((1.+0.25*(rat-1.)*eps)/(0.25*(rat+1.)*eps))
          f3im=-paru(1)*log((1.+0.25*(rat-1.)*eps)/(0.25*(rat+1.)*eps))
        elseif(abs(eps).lt.1.e-4.and.abs(rat*eps).ge.1.e-4) then
          f3re=pyspen(-0.25*eps/(be-0.25*eps),0.d0,1)-
     &    pyspen((1.-0.25*eps)/(be-0.25*eps),0.d0,1)+
     &    pyspen((1.-0.25*eps)/(1.-0.25*eps-be),0.d0,1)-
     &    pyspen(-0.25*eps/(1.-0.25*eps-be),0.d0,1)+
     &    log((1.-0.25*eps)/(0.25*eps))*
     &    log((be-0.25*eps)/(be-1.+0.25*eps))
          f3im=-paru(1)*log((be-0.25*eps)/(be-1.+0.25*eps))
        elseif(abs(eps).ge.1.e-4.and.abs(rat*eps).lt.1.e-4) then
          f3re=pyspen((ga-1.)/(ga+0.25*rat*eps),0.d0,1)-
     &    pyspen(ga/(ga+0.25*rat*eps),0.d0,1)+
     &    pyspen(ga/(ga-1.-0.25*rat*eps),0.d0, 1)-
     &    pyspen((ga-1.)/(ga-1.-0.25*rat*eps),0.d0,1)+
     &    log(ga/(1.-ga))*log((ga+0.25*rat*eps)/(1.+0.25*rat*eps-ga))
          f3im=-paru(1)*log((ga+0.25*rat*eps)/(1.+0.25*rat*eps-ga))
        else
          f3re=pyspen((ga-1.)/(ga+be-1.),0.d0,1)-
     &    pyspen(ga/(ga+be-1.),0.,1)+pyspen(ga/(ga-be),0.d0,1)-
     &    pyspen((ga-1.)/(ga-be),0.d0,1)+log(ga/(1.-ga))*
     &    log((ga+be-1.)/(be-ga))
          f3im=-paru(1)*log((ga+be-1.)/(be-ga))
         endif
      else
        rsq=eps/(eps-1.+(2.*be-1.)**2)
        rcthe=rsq*(1.-2.*be/eps)
        rsthe=sqrt(max(0.d0,rsq-rcthe**2))
        rcphi=rsq*(1.+2.*(be-1.)/eps)
        rsphi=sqrt(max(0.d0,rsq-rcphi**2))
        r=sqrt(rsq)
        the=acos(rcthe/r)
        phi=acos(rcphi/r)
        f3re=pyspen(rcthe,rsthe,1)+pyspen(rcthe,-rsthe,1)-
     &  pyspen(rcphi,rsphi,1)-pyspen(rcphi,-rsphi,1)+
     &  (phi-the)*(phi+the-paru(1))
        f3im=pyspen(rcthe,rsthe,2)+pyspen(rcthe,-rsthe,2)-
     &  pyspen(rcphi,rsphi,2)-pyspen(rcphi,-rsphi,2)
      endif

      y3re=2./(2.*be-1.)*f3re
      y3im=2./(2.*be-1.)*f3im

      return
      end

c***********************************************************************

      real*8 function pyspen(xrein,ximin,ireim)
      implicit double precision (a-h,o-z)

c...calculates real and imaginary part of spence function; see
c...g. 't hooft and m. veltman, nucl. phys. b153 (1979) 365.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/
      dimension b(0:14)

      data b/
     & 1.000000e+00,        -5.000000e-01,         1.666667e-01,
     & 0.000000e+00,        -3.333333e-02,         0.000000e+00,
     & 2.380952e-02,         0.000000e+00,        -3.333333e-02,
     & 0.000000e+00,         7.575757e-02,         0.000000e+00,
     &-2.531135e-01,         0.000000e+00,         1.166667e+00/

      xre=xrein
      xim=ximin
      if(abs(1.-xre).lt.1.e-6.and.abs(xim).lt.1.e-6) then
        if(ireim.eq.1) pyspen=paru(1)**2/6.
        if(ireim.eq.2) pyspen=0.
        return
      endif

      xmod=sqrt(xre**2+xim**2)
      if(xmod.lt.1.e-6) then
        if(ireim.eq.1) pyspen=0.
        if(ireim.eq.2) pyspen=0.
        return
      endif

      xarg=sign(acos(xre/xmod),xim)
      sp0re=0.
      sp0im=0.
      sgn=1.
      if(xmod.gt.1.) then
        algxre=log(xmod)
        algxim=xarg-sign(paru(1),xarg)
        sp0re=-paru(1)**2/6.-(algxre**2-algxim**2)/2.
        sp0im=-algxre*algxim
        sgn=-1.
        xmod=1./xmod
        xarg=-xarg
        xre=xmod*cos(xarg)
        xim=xmod*sin(xarg)
      endif
      if(xre.gt.0.5) then
        algxre=log(xmod)
        algxim=xarg
        xre=1.-xre
        xim=-xim
        xmod=sqrt(xre**2+xim**2)
        xarg=sign(acos(xre/xmod),xim)
        algyre=log(xmod)
        algyim=xarg
        sp0re=sp0re+sgn*(paru(1)**2/6.-(algxre*algyre-algxim*algyim))
        sp0im=sp0im-sgn*(algxre*algyim+algxim*algyre)
        sgn=-sgn
      endif

      xre=1.-xre
      xim=-xim
      xmod=sqrt(xre**2+xim**2)
      xarg=sign(acos(xre/xmod),xim)
      zre=-log(xmod)
      zim=-xarg

      spre=0.
      spim=0.
      savere=1.
      saveim=0.
      do 100 i=0,14
      if(max(abs(savere),abs(saveim)).lt.1e-30) goto 110
      termre=(savere*zre-saveim*zim)/(i+1)
      termim=(savere*zim+saveim*zre)/(i+1)
      savere=termre
      saveim=termim
      spre=spre+b(i)*termre
  100 spim=spim+b(i)*termim

  110 if(ireim.eq.1) pyspen=sp0re+sgn*spre
      if(ireim.eq.2) pyspen=sp0im+sgn*spim

      return
      end

***********************************************************************

      subroutine pytest(mtest)
      implicit double precision (a-h,o-z)

c...purpose: to provide a simple program (disguised as a subroutine) to
c...run at installation as a check that the program works as intended.
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      save /lujets/,/ludat1/,/ludat2/,/ludat3/
      save /pysubs/,/pypars/

c...common initial values. loop over initiating conditions.
      mstp(122)=max(0,min(2,mtest))
      mdcy(lucomp(111),1)=0
      nerr=0
      do 130 iproc=1,8

c...reset process type, kinematics cuts, and the flags used.
      msel=0
      do 100 isub=1,200
  100 msub(isub)=0
      ckin(1)=2.
      ckin(3)=0.
      mstp(2)=1
      mstp(33)=0
      mstp(81)=1
      mstp(82)=1
      mstp(111)=1
      mstp(131)=0
      mstp(133)=0
      parp(131)=0.01

c...prompt photon production at fixed target.
      if(iproc.eq.1) then
        pzsum=300.
        pesum=sqrt(pzsum**2+ulmass(211)**2)+ulmass(2212)
        pqsum=2.
        msel=10
        ckin(3)=5.
        call pyinit('fixt','pi+','p',pzsum)

c...qcd processes at isr energies.
      elseif(iproc.eq.2) then
        pesum=63.
        pzsum=0.
        pqsum=2.
        msel=1
        ckin(3)=5.
        call pyinit('cms','p','p',pesum)

c...w production + multiple interactions at cern collider.
      elseif(iproc.eq.3) then
        pesum=630.
        pzsum=0.
        pqsum=0.
        msel=12
        ckin(1)=20.
        mstp(82)=4
        mstp(2)=2
        mstp(33)=3
        call pyinit('cms','p','pbar',pesum)

c...w/z gauge boson pairs + pileup events at the tevatron.
      elseif(iproc.eq.4) then
        pesum=1800.
        pzsum=0.
        pqsum=0.
        msub(22)=1
        msub(23)=1
        msub(25)=1
        ckin(1)=200.
        mstp(111)=0
        mstp(131)=1
        mstp(133)=2
        parp(131)=0.04
        call pyinit('cms','p','pbar',pesum)

c...higgs production at lhc.
      elseif(iproc.eq.5) then
        pesum=17000.
        pzsum=0.
        pqsum=2.
        msub(3)=1
        msub(102)=1
        msub(123)=1
        msub(124)=1
        pmas(25,1)=300.
        ckin(1)=200.
        mstp(81)=0
        mstp(111)=0
        call pyinit('cms','p','p',pesum)

c...z' production at ssc.
      elseif(iproc.eq.6) then
        pesum=40000.
        pzsum=0.
        pqsum=2.
        msel=21
        pmas(32,1)=600.
        ckin(1)=400.
        mstp(81)=0
        mstp(111)=0
        call pyinit('cms','p','p',pesum)

c...w pair production at 1 tev e+e- collider.
      elseif(iproc.eq.7) then
        pesum=1000.
        pzsum=0.
        pqsum=0.
        msub(25)=1
        msub(69)=1
        call pyinit('cms','e+','e-',pesum)

c...deep inelastic scattering at a lep+lhc ep collider.
      elseif(iproc.eq.8) then
        p(1,1)=0.
        p(1,2)=0.
        p(1,3)=8000.
        p(2,1)=0.
        p(2,2)=0.
        p(2,3)=-80.
        pesum=8080.
        pzsum=7920.
        pqsum=0.
        msub(11)=1
        ckin(3)=50.
        mstp(111)=0
        call pyinit('user','p','e-',pesum)
      endif

c...generate 20 events of each required type.
      do 120 iev=1,20
      call pyevnt
      pesumm=pesum
      if(iproc.eq.4) pesumm=msti(41)*pesum

c...check conservation of energy/momentum/flavour.
      merr=0
      deve=abs(plu(0,4)-pesumm)+abs(plu(0,3)-pzsum)
      devt=abs(plu(0,1))+abs(plu(0,2))
      devq=abs(plu(0,6)-pqsum)
      if(deve.gt.2e-3*pesum.or.devt.gt.max(0.01d0,1d-4*pesum).or.
     &devq.gt.0.1) merr=1
      if(merr.ne.0) write(mstu(11),5000) iproc,iev

c...check that all kf codes are known ones, and that partons/particles
c...satisfy energy-momentum-mass relation.
      do 110 i=1,n
      if(k(i,1).gt.20) goto 110
      if(lucomp(k(i,2)).eq.0) then
        write(mstu(11),5100) i
        merr=merr+1
      endif
      pd=p(i,4)**2-p(i,1)**2-p(i,2)**2-p(i,3)**2-p(i,5)**2*
     &sign(1.d0,p(i,5))
      if(abs(pd).gt.max(0.1d0,0.002*p(i,4)**2,0.002*p(i,5)**2).or.
     &(p(i,5).ge.0..and.p(i,4).lt.0.)) then
        write(mstu(11),5200) i
        merr=merr+1
      endif
  110 continue

c...listing of erroneous events, and first event of each type.
      if(merr.ge.1) nerr=nerr+1
      if(nerr.ge.10) then
        write(mstu(11),5300)
        call lulist(1)
        stop
      endif
      if(mtest.ge.1.and.(merr.ge.1.or.iev.eq.1)) then
        if(merr.ge.1) write(mstu(11),5400)
        call lulist(1)
      endif
  120 continue

c...list statistics for each process type.
      if(mtest.ge.1) call pystat(1)
  130 continue

c...summarize result of run.
      if(nerr.eq.0) write(mstu(11),5500)
      if(nerr.gt.0) write(mstu(11),5600) nerr
      return

c...formats for information.
 5000 format(/5x,'energy/momentum/flavour nonconservation for process',
     &i2,', event',i4)
 5100 format(/5x,'entry no.',i4,' in following event not known code')
 5200 format(/5x,'entry no.',i4,' in following event has faulty ',
     &'kinematics')
 5300 format(/5x,'this is the tenth error experienced! something is ',
     &'wrong.'/5x,'execution will be stopped after listing of event.')
 5400 format(5x,'faulty event follows:')
 5500 format(//5x,'end result of run: no errors detected.')
 5600 format(//5x,'end result of run:',i2,' errors detected.'/
     &5x,'this should not have happened!')
      end

c*********************************************************************

      block data pydata
      implicit double precision (a-h,o-z)

c...give sensible default values to all status codes and parameters.
      common/pysubs/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pyint4/widp(21:40,0:40),wide(21:40,0:40),wids(21:40,3)
      common/pyint5/ngen(0:200,3),xsec(0:200,3)
      common/pyint6/proc(0:200)
      character proc*28
      save /pysubs/,/pypars/,/pyint1/,/pyint2/,/pyint3/,/pyint4/,
     &/pyint5/,/pyint6/

c...default values for allowed processes and kinematics constraints.
      data msel/1/
      data msub/200*0/
      data ((kfin(i,j),j=-40,40),i=1,2)/40*1,0,80*1,0,40*1/
      data ckin/
     &   2.0, -1.0,  0.0, -1.0,  1.0,  1.0, -10.,  10., -10.,  10.,
     1  -10.,  10., -10.,  10., -10.,  10., -1.0,  1.0, -1.0,  1.0,
     2   0.0,  1.0,  0.0,  1.0, -1.0,  1.0, -1.0,  1.0,   0.,   0.,
     3   2.0, -1.0,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     4  12.0, -1.0, 12.0, -1.0, 12.0, -1.0, 12.0, -1.0,   0.,   0.,
     5   0.0, -1.0,  0.0, -1.0,  0.0, -1.0,   0.,   0.,   0.,   0.,
     6   140*0./

c...default values for main switches and parameters. reset information.
      data (mstp(i),i=1,100)/
     &     3,    1,    2,    0,    0,    0,    0,    0,    0,    0,
     1     0,    0,    1,    0,    0,    0,    0,    0,    0,    0,
     2     1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     3     1,    2,    0,    0,    0,    2,    1,    5,    0,    0,
     4     1,    1,    3,    7,    2,    1,    1,    0,    0,    0,
     5     1,    1,   20,    6,    0,    0,    0,    0,    0,    0,
     6     1,    2,    2,    2,    1,    0,    0,    0,    0,    0,
     7     1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8     1,    1,  100,    0,    0,    0,    0,    0,    0,    0,
     9     1,    4,    0,    0,    0,    0,    0,    0,    0,    0/
      data (mstp(i),i=101,200)/
     &     1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1     1,    1,    1,    0,    0,    0,    0,    0,    0,    0,
     2     0,    1,    2,    1,    1,   20,    1,    0,   10,    0,
     3     0,    4,    0,    1,    0,    0,    0,    0,    0,    0,
     4     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     5     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     7     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8     5,    5, 1991,   03,   08,    0,    0,    0,    0,    0,
     9     0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data (parp(i),i=1,100)/
     &  0.25,  10.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     1   0.0,-0.67, 25.0, 0.01,   0.,   0.,   0.,   0.,   0.,   0.,
     2    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     3   1.5,  2.0, 0.075,  0.,  0.2,   0.,  2.0,   0.,   0.,   0.,
     4  0.01,  2.0, 0.10, 1000., 2054., 0.,   0.,   0.,   0.,   0.,
     5   1.0, 2.26, 1.e4, 1.e-4,  0.,   0.,   0.,   0.,   0.,   0.,
     6  0.25,  1.0, 0.25,  1.0,  2.0, 1.e-3, 4.0,   0.,   0.,   0.,
     7   4.0,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     8  1.45, 1.70,  0.5,  0.2, 0.33, 0.66,  0.7,  0.5,   0.,   0.,
     9  0.44, 0.44,  2.0,  1.0,   0.,  3.0,  1.0, 0.75,   0.,   0./
      data (parp(i),i=101,200)/
     & -0.02,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     1   2.0,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     2   1.0,  0.4,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     3  0.01,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     4    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     5    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     6    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     7    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     8    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,
     9    0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0.,   0./
      data msti/200*0/
      data pari/200*0./
      data mint/400*0/
      data vint/400*0./

c...constants for the generation of the various processes.
      data (iset(i),i=1,100)/
     &    1,    1,    1,   -1,    3,   -1,   -1,    3,   -2,   -2,
     1    2,    2,    2,    2,    2,    2,   -1,    2,    2,    2,
     2   -1,    2,    2,    2,    2,    2,   -1,    2,    2,    2,
     3    2,   -1,    2,    2,    2,    2,   -1,   -1,   -1,   -1,
     4   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     5   -1,   -1,    2,    2,   -1,   -1,   -1,    2,   -1,   -1,
     6   -1,   -1,   -1,   -1,   -1,   -1,   -1,    2,    2,    2,
     7    4,    4,    4,   -1,   -1,    4,    4,   -1,   -1,   -2,
     8    2,    2,    2,    2,    2,   -2,   -2,   -2,   -2,   -2,
     9    0,    0,    0,   -1,    0,    9,   -2,   -2,   -2,   -2/
      data (iset(i),i=101,200)/
     &   -1,    1,    1,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
     1    2,    2,    2,    2,    2,   -1,   -1,   -1,   -2,   -2,
     2   -1,   -1,    5,    5,   -2,   -2,   -2,   -2,   -2,   -2,
     3    6,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
     4    1,    1,    1,    1,    1,   -2,   -2,   -2,   -2,   -2,
     5    1,    1,    1,   -2,   -2,    1,    1,    1,   -2,   -2,
     6    2,    2,    2,    2,   -2,   -2,   -2,   -2,   -2,   -2,
     7    2,    2,    5,    5,   -2,    2,    2,    5,    5,   -2,
     8   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
     9   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2/
      data ((kfpr(i,j),j=1,2),i=1,50)/
     &   23,    0,   24,    0,   25,    0,   24,    0,   25,    0,
     &   24,    0,   23,    0,   25,    0,    0,    0,    0,    0,
     1    0,    0,    0,    0,   21,   21,   21,   22,   21,   23,
     1   21,   24,   21,   25,   22,   22,   22,   23,   22,   24,
     2   22,   25,   23,   23,   23,   24,   23,   25,   24,   24,
     2   24,   25,   25,   25,    0,   21,    0,   22,    0,   23,
     3    0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     3    0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     4    0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     4    0,   24,    0,   25,    0,   21,    0,   22,    0,   23/
      data ((kfpr(i,j),j=1,2),i=51,100)/
     5    0,   24,    0,   25,    0,    0,    0,    0,    0,    0,
     5    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6    0,    0,    0,    0,   21,   21,   24,   24,   23,   24,
     7   23,   23,   24,   24,   23,   24,   23,   25,   22,   22,
     7   23,   23,   24,   24,   24,   25,   25,   25,    0,    0,
     8    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     9    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     9    0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data ((kfpr(i,j),j=1,2),i=101,150)/
     &   23,    0,   25,    0,   25,    0,    0,    0,    0,    0,
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1   21,   25,    0,   25,   21,   25,   22,   22,   21,   22,
     1   22,   23,   23,   23,   24,   24,    0,    0,    0,    0,
     2   25,    0,   25,    0,   25,    0,   25,    0,    0,    0,
     2    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     3   23,    5,    0,    0,    0,    0,    0,    0,    0,    0,
     3    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     4   32,    0,   34,    0,   37,    0,   40,    0,   39,    0,
     4    0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data ((kfpr(i,j),j=1,2),i=151,200)/
     5   35,    0,   35,    0,   35,    0,    0,    0,    0,    0,
     5   36,    0,   36,    0,   36,    0,    0,    0,    0,    0,
     6    6,   37,   39,    0,   39,   39,   39,   39,    0,    0,
     6    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     7   23,   35,   24,   35,   35,    0,   35,    0,    0,    0,
     7   23,   36,   24,   36,   36,    0,   36,    0,    0,    0,
     8    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     9    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     9    0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data coef/4000*0./
      data (((icol(i,j,k),k=1,2),j=1,4),i=1,40)/
     1 4,0,3,0,2,0,1,0,3,0,4,0,1,0,2,0,2,0,0,1,4,0,0,3,3,0,0,4,1,0,0,2,
     2 3,0,0,4,1,4,3,2,4,0,0,3,4,2,1,3,2,0,4,1,4,0,2,3,4,0,3,4,2,0,1,2,
     3 3,2,1,0,1,4,3,0,4,3,3,0,2,1,1,0,3,2,1,4,1,0,0,2,2,4,3,1,2,0,0,1,
     4 3,2,1,4,1,4,3,2,4,2,1,3,4,2,1,3,3,4,4,3,1,2,2,1,2,0,3,1,2,0,0,0,
     5 4,2,1,0,0,0,1,0,3,0,0,3,1,2,0,0,4,0,0,4,0,0,1,2,2,0,0,1,4,4,3,3,
     6 2,2,1,1,4,4,3,3,3,3,4,4,1,1,2,2,3,2,1,3,1,2,0,0,4,2,1,4,0,0,1,2,
     7 4,0,0,0,4,0,1,3,0,0,3,0,2,4,3,0,3,4,0,0,1,0,0,1,0,0,3,4,2,0,0,2,
     8 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     9 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     & 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/

c...character constants: name of processes.
      data proc(0)/                    'all included subprocesses   '/
      data (proc(i),i=1,20)/
     1'f + f~ -> gamma*/z0         ',  'f + f~'' -> w+/-             ',
     2'f + f~ -> h0                ',  'gamma + w+/- -> w+/-        ',
     3'z0 + z0 -> h0               ',  'z0 + w+/- -> w+/-           ',
     4'                            ',  'w+ + w- -> h0               ',
     5'                            ',  '                            ',
     6'f + f'' -> f + f''            ','f + f~ -> f'' + f~''          ',
     7'f + f~ -> g + g             ',  'f + f~ -> g + gamma         ',
     8'f + f~ -> g + z0            ',  'f + f~'' -> g + w+/-         ',
     9'f + f~ -> g + h0            ',  'f + f~ -> gamma + gamma     ',
     &'f + f~ -> gamma + z0        ',  'f + f~'' -> gamma + w+/-     '/
      data (proc(i),i=21,40)/
     1'f + f~ -> gamma + h0        ',  'f + f~ -> z0 + z0           ',
     2'f + f~'' -> z0 + w+/-        ', 'f + f~ -> z0 + h0           ',
     3'f + f~ -> w+ + w-           ',  'f + f~'' -> w+/- + h0        ',
     4'f + f~ -> h0 + h0           ',  'f + g -> f + g              ',
     5'f + g -> f + gamma          ',  'f + g -> f + z0             ',
     6'f + g -> f'' + w+/-          ', 'f + g -> f + h0             ',
     7'f + gamma -> f + g          ',  'f + gamma -> f + gamma      ',
     8'f + gamma -> f + z0         ',  'f + gamma -> f'' + w+/-      ',
     9'f + gamma -> f + h0         ',  'f + z0 -> f + g             ',
     &'f + z0 -> f + gamma         ',  'f + z0 -> f + z0            '/
      data (proc(i),i=41,60)/
     1'f + z0 -> f'' + w+/-         ', 'f + z0 -> f + h0            ',
     2'f + w+/- -> f'' + g          ', 'f + w+/- -> f'' + gamma      ',
     3'f + w+/- -> f'' + z0         ', 'f + w+/- -> f'' + w+/-       ',
     4'f + w+/- -> f'' + h0         ', 'f + h0 -> f + g             ',
     5'f + h0 -> f + gamma         ',  'f + h0 -> f + z0            ',
     6'f + h0 -> f'' + w+/-         ', 'f + h0 -> f + h0            ',
     7'g + g -> f + f~             ',  'g + gamma -> f + f~         ',
     8'g + z0 -> f + f~            ',  'g + w+/- -> f + f~''         ',
     9'g + h0 -> f + f~            ',  'gamma + gamma -> f + f~     ',
     &'gamma + z0 -> f + f~        ',  'gamma + w+/- -> f + f~''     '/
      data (proc(i),i=61,80)/
     1'gamma + h0 -> f + f~        ',  'z0 + z0 -> f + f~           ',
     2'z0 + w+/- -> f + f~''        ', 'z0 + h0 -> f + f~           ',
     3'w+ + w- -> f + f~           ',  'w+/- + h0 -> f + f~''        ',
     4'h0 + h0 -> f + f~           ',  'g + g -> g + g              ',
     5'gamma + gamma -> w+ + w-    ',  'gamma + w+/- -> z0 + w+/-   ',
     6'z0 + z0 -> z0 + z0          ',  'z0 + z0 -> w+ + w-          ',
     7'z0 + w+/- -> z0 + w+/-      ',  'z0 + z0 -> z0 + h0          ',
     8'w+ + w- -> gamma + gamma    ',  'w+ + w- -> z0 + z0          ',
     9'w+/- + w+/- -> w+/- + w+/-  ',  'w+/- + h0 -> w+/- + h0      ',
     &'h0 + h0 -> h0 + h0          ',  '                            '/
      data (proc(i),i=81,100)/
     1'q + q~ -> q + q~, massive   ',  'g + g -> q + q~, massive    ',
     2'f + q -> f'' + q, massive    ', 'g + gamma -> q + q~, massive',
     3'gamma + gamma -> f + f~, mas',  '                            ',
     4'                            ',  '                            ',
     5'                            ',  '                            ',
     6'elastic scattering          ',  'single diffractive          ',
     7'double diffractive          ',  'central diffractive         ',
     8'low-pt scattering           ',  'semihard qcd 2 -> 2         ',
     9'                            ',  '                            ',
     &'                            ',  '                            '/
      data (proc(i),i=101,120)/
     1'g + g -> gamma*/z0          ',  'g + g -> h0                 ',
     2'gamma + gamma -> h0         ',  '                            ',
     3'                            ',  '                            ',
     4'                            ',  '                            ',
     5'                            ',  '                            ',
     6'f + f~ -> g + h0            ',  'q + g -> q + h0             ',
     7'g + g -> g + h0             ',  'g + g -> gamma + gamma      ',
     8'g + g -> g + gamma          ',  'g + g -> gamma + z0         ',
     9'g + g -> z0 + z0            ',  'g + g -> w+ + w-            ',
     &'                            ',  '                            '/
      data (proc(i),i=121,140)/
     1'g + g -> f + f~ + h0        ',  'gamma + gamma -> f + f~ + h0',
     2'f + f'' -> f + f'' + h0       ',
     2'f + f'' -> f" + f"'' + h0     ',
     3'                            ',  '                            ',
     4'                            ',  '                            ',
     5'                            ',  '                            ',
     6'g + g -> z0 + q + q~        ',  '                            ',
     7'                            ',  '                            ',
     8'                            ',  '                            ',
     9'                            ',  '                            ',
     &'                            ',  '                            '/
      data (proc(i),i=141,160)/
     1'f + f~ -> gamma*/z0/z''0     ', 'f + f~'' -> w''+/-            ',
     2'f + f~'' -> h+/-             ', 'f + f~'' -> r                ',
     3'q + l -> lq                 ',  '                            ',
     4'                            ',  '                            ',
     5'                            ',  '                            ',
     6'f + f~ -> h''0               ', 'g + g -> h''0                ',
     7'gamma + gamma -> h''0        ', '                            ',
     8'                            ',  'f + f~ -> a0                ',
     9'g + g -> a0                 ',  'gamma + gamma -> a0         ',
     &'                            ',  '                            '/
      data (proc(i),i=161,180)/
     1'f + g -> f'' + h+/-          ', 'q + g -> lq + l~            ',
     2'g + g -> lq + lq~           ',  'q + q~ -> lq + lq~          ',
     3'                            ',  '                            ',
     4'                            ',  '                            ',
     5'                            ',  '                            ',
     6'f + f~ -> z0 + h''0          ', 'f + f~'' -> w+/- + h''0       ',
     7'f + f'' -> f + f'' + h''0      ',
     7'f + f'' -> f" + f"'' + h''0    ',
     8'                            ',  'f + f~ -> z0 + a0           ',
     9'f + f~'' -> w+/- + a0        ',
     9'f + f'' -> f + f'' + a0       ',
     &'f + f'' -> f" + f"'' + a0     ',
     &'                            '/
      data (proc(i),i=181,200)/     20*'                            '/

      end


c*********************************************************************

c...the following routines have been written by ronald kleiss,
c...to evaluate the matrix element for g + g -> z + q + qbar,
c...with massive quarks (e.g. q = b).
c...they have been modified, so that all routines and commonblocks
c...have names beginning with rk, and so that some unnecessary
c...initialization information is not printed. further, complex*16
c...has been changed to complex and real*8 to double precision
c...(in a few cases to real), so as to make the program better
c...transportable.

      subroutine rkbbv(ak1,ak2,ap1,ap2,alep1,alep2,imc,result)
      implicit double precision (a-h,o-z)
* the cross section for
* g(k1) + g(k2) ---> z(qv) + b(p1) + b_bar(p2)
*                     |
*                     +---> l(lep1) + lep_bar(lep2)
* the b quarks have to be on-shell, the leptons massless
* the option imc=0 performs the standard spin sum
* the option imc=1 performs the calculation for 'nmc' randomly
* chosen helicity states which improves the
* speed by a factor 32/nmc
c      implicit none
      save

      dimension 
     &  ak1(0:3),ak2(0:3),ap1(0:3),ap2(0:3),alep1(0:3),alep2(0:3)
      double precision k1(0:4),k2(0:4),p1(0:4),p2(0:4),lep1(0:4),
     &lep2(0:4)
c      real rmq,rmv,rgv,gstr,vb,ab,vl,al
      integer init
      integer j1,j2,j3,j4,j5
      integer k,imc,klow,kupp,nmc,oldimc
      double precision rkrand,rkdot,mult,rmb
      integer chkgl1,chkgl2
      double precision qv(0:4),r1(0:4),r2(0:4),q1(0:4),q2(0:4)
      double precision pp2(0:4)
      double precision cross
      integer lg1,lg2,lv,l1,l2,helix,heli
      complex*16 zfacv,zfac1,zfac2
      double precision zfacs,zfacb,zfacbb,zfacl
c      complex*16 rkzpr, rkzsf
      complex*16  rkzsf
      complex*16 zfac
      double precision vpa,vma
      double precision rr1(0:4),rr2(0:4)
      double precision zd12v,zd21v,zd1v2,zd2v1,zdv12,zdv21
      complex*16 rkzf,zn12v,zn21v,zn1v2,zn2v1,znv12,znv21
      complex*16 zdia1,zdia2,zdia3,zdia4,zdia5,zdia6,zdia7,zdia8
      complex*16 zc12v,zc21v,zcv12,zcv21
      double precision s,zd11,zd22
      complex*16 zabel,znabel,znabem
c      real result
c      double precision azabel,cabel,anabel,cnabel,this1
      double precision  this1
      complex*16 anss(-1:1,1:4,-1:1,1:4)
      integer dons(-1:1,1:4,-1:1,1:4)
      complex*16 ansf(-1:1,1:4,1:8,-1:1,1:4)
      integer donf(-1:1,1:4,1:8,-1:1,1:4)

      parameter(chkgl1=0,chkgl2=0,nmc=1)

      common / rkzsco / anss,dons
      common / rkzfco / ansf,donf
      common / rkbbvc / rmq,rmv,rgv,vb,ab,vl,al
      data init/0/

* check on either first call or change in imc
      if(init.eq.0.or.imc.ne.oldimc) then
        oldimc=imc
        init=1
* reproduce input data
c       write(6,*) ' ----------------------------------------'
c       write(6,*) ' bbv: g g ---> b b_bar z, z ---> l l_bar'
c       write(6,*) ' b quark mass      = ',rmb,' gev'
c       write(6,*) ' boson mass        = ',rmv,' gev'
c       write(6,*) ' boson width       = ',rgv,' gev'
c       write(6,*) ' b vector c.       = ',vb
c       write(6,*) ' b axial c.        = ',ab
c       write(6,*) ' lepton vector c.  = ',vl
c       write(6,*) ' lepton axial c.   = ',al
        rmb=rmq
* adjust strong coupling so as to give effectively alpha_s=1
        gstr=4d0*dsqrt(datan(1d0))
c       write(6,*) ' qcd coupling      = ',gstr
* see wether gauge checks are required
        if(chkgl1.eq.1) then
          write(6,*) ' gauge check on gluon 1'
        endif
        if(chkgl2.eq.1) then
          write(6,*) ' gauge check on gluon 2'
        endif
* see wether helicity monte carlo is required
        if(imc.eq.0) then
          klow=1
          kupp=32
          mult=1d0
          write(6,*) ' sum over helicities selected'
        elseif(imc.eq.1) then
          klow=1
          kupp=nmc
          mult=32d0/(1d0*nmc)
c         write(6,*) ' monte carlo over helicites selected'
c         write(6,*) ' with ',nmc,' helicity trials'
c         write(6,*) ' result then multiplied by ',mult
        else
          write(6,*) ' error: wrong option imc=',imc
        endif
c       write(6,*) ' the result is based on alpha_s=1,',
c    .  ' must be multiplied by alpha_s**2'
c       write(6,*) ' ----------------------------------------'
c       write(6,800)'no.','lg1','lg2','lv','l1','l2','amp**2'
c 800   format(' ',6a4,a10)
      endif

* initialize the arrays anss,dons
      do 130 j1=-1,1,2
        do 120 j2=1,4
          do 110 j3=-1,1,2
            do 100 j4=1,4
              anss(j1,j2,j3,j4)=(0.,0.)
              dons(j1,j2,j3,j4)=0
  100       continue
  110     continue
  120   continue
  130 continue

* initialize the arrays ansf,donf
      do 180 j1=-1,1,2
        do 170 j2=1,4
          do 160 j3=1,8
            do 150 j4=-1,1,2
              do 140 j5=1,4
                 ansf(j1,j2,j3,j4,j5)=(0.,0.)
                 donf(j1,j2,j3,j4,j5)=0
  140         continue
  150       continue
  160     continue
  170   continue
  180 continue

* equate the (0:4) internal momenta to the (0:3) arguments momenta
      do 190 k=0,3
        k1(k)=ak1(k)
        k2(k)=ak2(k)
        p1(k)=ap1(k)
        p2(k)=ap2(k)
        lep1(k)=alep1(k)
        lep2(k)=alep2(k)
  190 continue

* assign labels to the momenta for recognition
* the momenta k1,k2,lep1,lep2 (and r1,r2) can occur as the massless
* momenta in arguments no.2 and 6 in zf, and no.2 and 4 in rkzsf
* r1,r2 and q1,q2 are some of these, and can also occur
* as arguments no.2 and 6 in zf and no.2 and 4 in rkzsf
        k1(4)=1d0
        k2(4)=2d0
        lep1(4)=3d0
        lep2(4)=4d0
* the other momenta p1,p2 and the various rr1,rr2 can occur only
* as argument no.3 in zf
        p1(4)=1d0
        p2(4)=2d0

* the total boson momentum
* no need to assign 4th component label since it is not used
      do 200 k=0,3
        qv(k)=lep1(k)+lep2(k)
  200 continue


* define the auxiliary vectors: the result should be the same
* for every non-singular choice of the auxiliary vectors
* singular choices are r1=k1 or r2=k2
* these are obtained by putting chkgl1=1 or chkgl2=1

* auxiliary vector for gluon 1
* need to assign also 4th component labels here!
      if(chkgl1.eq.1) then
        do 210 k=0,4
          r1(k)=k1(k)
  210   continue
      else
        do 220 k=0,4
          r1(k)=k2(k)
  220   continue
      endif

* auxiliary vector for gluon 2
      if(chkgl2.eq.1) then
        do 230 k=0,4
          r2(k)=k2(k)
  230   continue
      else
        do 240 k=0,4
          r2(k)=k1(k)
  240   continue
      endif

* auxiliary vector for the b quark
      do 250 k=0,4
        q1(k)=lep1(k)
  250 continue

* auxiliary vector for the b_bar quark
      do 260 k=0,4
        q2(k)=lep2(k)
  260 continue

* initialize the cross section to zero
      cross=0d0

* since p2 corresponds to an antifermion we have to
* change its sign momentarily: put the old result in pp2(0:3)
* bu make sure to keep the label positive!
      do 270 k=0,3
        pp2(k)=p2(k)
        p2(k)=-p2(k)
  270 continue

* compute overall factors: for every slashed polarization there
* appears a factor of 2 in addition to the normalization
* following from the chisholm identity
* in principle the overall factors are different for each different
* helicity compbination but in this case we are only interested in
* their absolute value (no transverse gluon polarization etc.)
* so we can take this out of the loop, except for the nontrivial
* helicity dependence in 'zfacv'

* overall factor for the boson current, with breit-wigner
      zfacv=2./cmplx(rkdot(qv,qv)-rmv**2,rmv*rgv)

* overall factor for gluon 1
      if(chkgl1.eq.1) then
        zfac1=(1.,0.)
      else
* original form: zfac1=2d0*lg1/(dsqrt(2d0)*rkzpr(-lg1,k1,r1))
        zfac1=dsqrt(2d0)/rkzsf(1,k1,-1,r1)
      endif

* overall factor for gluon 2
      if(chkgl2.eq.1) then
        zfac2=1d0
      else
* original form: zfac2=2d0*lg2/(dsqrt(2d0)*rkzpr(-lg2,k2,r2))
        zfac2=dsqrt(2d0)/rkzsf(1,k2,-1,r2)
      endif

* overall factor for qcd couplings
      zfacs=gstr**2

* overall factor for the b quark
      zfacb=1/dsqrt(2d0*rkdot(p1,q1))

* overall factor for the b_bar quark
      zfacbb=1d0/dsqrt(2d0*rkdot(pp2,q2))

* final overall factor
      zfac=zfacv*zfac1*zfac2*zfacs*zfacb*zfacbb

* do a big loop over all helicities or a random choice of helicities
* nb: funny indentation here!
* also initialize counters for rkzsf and zf

      do 360 helix=klow,kupp
      if(imc.eq.0) then
        call rkhlpk(helix,lg1,lg2,lv,l1,l2)
      else
        heli=idint(32d0*rkrand(helix))+1
        call rkhlpk(heli,lg1,lg2,lv,l1,l2)
      endif

* determine the 'left-' and 'right-'handed couplings of the b to the z
      vpa=vb+lv*ab
      vma=vb-lv*ab
* and the lepton helicity factor
      zfacl=(vl-lv*al)

* first part of the result: the abelian terms
* compute the numerators (zn...) using the zf function
* and the denominators (zd...) the standard way
* the internal fermion momenta are different in each diagram
* and are denoted by rr1 and rr2
* the 4th component labels are nontrivial here: having already
* p1(4)=1 and p2(4)=2 we also define
* (p1-k1)(4)=3,
* (p1-k1-k2)(4)=(p1-k2-k1)(4)=4
* (p1-k2)(4)=5
* (p1-k1+qv)(4)=6
* (p1-k2+qv)(5)=7
* (p1+qv)(4)=8
* so that in the various diagrams we have
* in zn12v: rr1(4)=3, rr2(4)=4
* in zn21v: rr1(4)=5, rr2(4)=4
* in zn1v2: rr1(4)=3, rr2(4)=6
* in zn2v1: rr1(4)=5, rr2(4)=7
* in znv12: rr1(4)=8, rr2(4)=6
* in znv21: rr1(4)=8, rr2(4)=7

      do 280 k=0,3
        rr1(k)=p1(k)-k1(k)
        rr2(k)=rr1(k)-k2(k)
  280 continue
      rr1(4)=3d0
      rr2(4)=4d0
      zd12v=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      zn12v =
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma

      do 290 k=0,3
        rr1(k)=p1(k)-k2(k)
        rr2(k)=rr1(k)-k1(k)
  290 continue
      rr1(4)=5d0
      rr2(4)=4d0
      zd21v=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      zn21v =
     .   rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma

      do 300 k=0,3
        rr1(k)=p1(k)-k1(k)
        rr2(k)=rr1(k)+qv(k)
  300 continue
      rr1(4)=3d0
      rr2(4)=6d0
      zd1v2=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      zn1v2 =
     .   rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,lg2,r2)  *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,-lg2,k2) *rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,lg2,r2) *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg1,r1)     *rkzf(lg1,k1,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,-lg2,k2)*rkzf(-lg2,r2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,lg2,r2)  *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,-lg2,k2) *rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,lg2,r2) *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)    *rkzf(-lg1,r1,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,-lg2,k2)*rkzf(-lg2,r2,p2,rmb,l2,q2)*vma

      do 310 k=0,3
        rr1(k)=p1(k)-k2(k)
        rr2(k)=rr1(k)+qv(k)
  310 continue
      rr1(4)=5d0
      rr2(4)=7d0
      zd2v1=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      zn2v1 =
     .   rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,lg1,r1)  *rkzf(lg1,k1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,-lg1,k1) *rkzf(-lg1,r1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,lg1,r1) *rkzf(lg1,k1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg2,r2)     *rkzf(lg2,k2,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,-lg1,k1)*rkzf(-lg1,r1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,lg1,r1)  *rkzf(lg1,k1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,lv,lep2)
     .  *rkzf(lv,lep1,rr2,rmb,-lg1,k1) *rkzf(-lg1,r1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,lg1,r1) *rkzf(lg1,k1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)    *rkzf(-lg2,r2,rr1,rmb,-lv,lep1)
     .  *rkzf(-lv,lep2,rr2,rmb,-lg1,k1)*rkzf(-lg1,r1,p2,rmb,l2,q2)*vma

      do 320 k=0,3
        rr1(k)=p1(k)+qv(k)
        rr2(k)=rr1(k)-k1(k)
  320 continue
      rr1(4)=8d0
      rr2(4)=6d0
      zdv12=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      znv12 =
     .   rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,lg2,r2)  *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,-lg2,k2) *rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,lg2,r2) *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,-lg2,k2)*rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,lg2,r2)  *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,lg1,r1)
     .  *rkzf(lg1,k1,rr2,rmb,-lg2,k2) *rkzf(-lg2,r2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,lg2,r2) *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,-lg1,k1)
     .  *rkzf(-lg1,r1,rr2,rmb,-lg2,k2)*rkzf(-lg2,r2,p2,rmb,l2,q2)*vma

      do 330 k=0,3
        rr1(k)=p1(k)+qv(k)
        rr2(k)=rr1(k)-k2(k)
  330 continue
      rr1(4)=8d0
      rr2(4)=7d0
      zdv21=(rkdot(rr1,rr1)-rmb**2)*(rkdot(rr2,rr2)-rmb**2)
      znv21 =
     .   rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,lg1,r1)  *rkzf(lg1,k1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,-lg1,k1) *rkzf(-lg1,r1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,lg1,r1) *rkzf(lg1,k1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2)   *rkzf(lv,lep1,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,-lg1,k1)*rkzf(-lg1,r1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,lg1,r1)  *rkzf(lg1,k1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,lg2,r2)
     .  *rkzf(lg2,k2,rr2,rmb,-lg1,k1) *rkzf(-lg1,r1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,lg1,r1) *rkzf(lg1,k1,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)  *rkzf(-lv,lep2,rr1,rmb,-lg2,k2)
     .  *rkzf(-lg2,r2,rr2,rmb,-lg1,k1)*rkzf(-lg1,r1,p2,rmb,l2,q2)*vma

* compute the diagrams so far
      zdia1=zn12v/zd12v
      zdia2=zn21v/zd21v
      zdia3=zn1v2/zd1v2
      zdia4=zn2v1/zd2v1
      zdia5=znv12/zdv12
      zdia6=znv21/zdv21

* second part of the result: the nonabelian part.
* this is made up partly from the abelian part and partly from
* new pieces
* the assignment of the 4th component labels is now unnecessary
* for rr1 since it does not occur in any zf here

      s=2d0*rkdot(k1,k2)

      do 340 k=0,3
        rr1(k)=pp2(k)+qv(k)
  340 continue
      zd11=s*(rkdot(rr1,rr1)-rmb**2)

      zc12v =
     . + rkzf(l1,q1,p1,rmb,lg1,r1) *rkzsf(lg1,k1,lg2,r2)
     .  *rkzsf(lg2,k2,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1) *rkzsf(lg1,k1,lg2,r2)
     .  *rkzsf(lg2,k2,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg1,r1) *rkzsf(lg1,k1,-lg2,k2)
     .  *rkzsf(-lg2,r2,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg1,r1) *rkzsf(lg1,k1,-lg2,k2)
     .  *rkzsf(-lg2,r2,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)*rkzsf(-lg1,r1,lg2,r2)
     .  *rkzsf(lg2,k2,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)*rkzsf(-lg1,r1,lg2,r2)
     .  *rkzsf(lg2,k2,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)*rkzsf(-lg1,r1,-lg2,k2)
     .  *rkzsf(-lg2,r2,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg1,k1)*rkzsf(-lg1,r1,-lg2,k2)
     .  *rkzsf(-lg2,r2,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma

      zc21v =
     . + rkzf(l1,q1,p1,rmb,lg2,r2) *rkzsf(lg2,k2,lg1,r1)
     .  *rkzsf(lg1,k1,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2) *rkzsf(lg2,k2,lg1,r1)
     .  *rkzsf(lg1,k1,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,lg2,r2) *rkzsf(lg2,k2,-lg1,k1)
     .  *rkzsf(-lg1,r1,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lg2,r2) *rkzsf(lg2,k2,-lg1,k1)
     .  *rkzsf(-lg1,r1,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)*rkzsf(-lg2,r2,lg1,r1)
     .  *rkzsf(lg1,k1,lv,lep2)  *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)*rkzsf(-lg2,r2,lg1,r1)
     .  *rkzsf(lg1,k1,-lv,lep1) *rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)*rkzsf(-lg2,r2,-lg1,k1)
     .  *rkzsf(-lg1,r1,lv,lep2) *rkzf(lv,lep1,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lg2,k2)*rkzsf(-lg2,r2,-lg1,k1)
     .  *rkzsf(-lg1,r1,-lv,lep1)*rkzf(-lv,lep2,p2,rmb,l2,q2)*vma
      zdia7=(-zn12v+zn21v)/zd11-(zc12v-zc21v)/(2d0*s)

      do 350 k=0,3
        rr1(k)=p1(k)+qv(k)
  350 continue
      zd22=s*(rkdot(rr1,rr1)-rmb**2)

      zcv12 =
     . + rkzf(l1,q1,p1,rmb,lv,lep2) *rkzsf(lv,lep1,lg1,r1)
     .  *rkzsf(lg1,k1,lg2,r2)    *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2) *rkzsf(lv,lep1,lg1,r1)
     .  *rkzsf(lg1,k1,-lg2,k2)   *rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2) *rkzsf(lv,lep1,-lg1,k1)
     .  *rkzsf(-lg1,r1,lg2,r2)   *rkzf(lg2,k2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,lv,lep2) *rkzsf(lv,lep1,-lg1,k1)
     .  *rkzsf(-lg1,r1,-lg2,k2)  *rkzf(-lg2,r2,p2,rmb,l2,q2)*vpa
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)*rkzsf(-lv,lep2,lg1,r1)
     .  *rkzsf(lg1,k1,lg2,r2)    *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)*rkzsf(-lv,lep2,lg1,r1)
     .  *rkzsf(lg1,k1,-lg2,k2)   *rkzf(-lg2,r2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)*rkzsf(-lv,lep2,-lg1,k1)
     .  *rkzsf(-lg1,r1,lg2,r2)   *rkzf(lg2,k2,p2,rmb,l2,q2)*vma
     . + rkzf(l1,q1,p1,rmb,-lv,lep1)*rkzsf(-lv,lep2,-lg1,k1)
     .  *rkzsf(-lg1,r1,-lg2,k2)  *rkzf(-lg2,r2,p2,rmb,l2,q2)*vma

* the fourth combination can be gotten from
* the first three using dirac algebra:
* eps1*eps2*epvs+eps2*eps1*epsv = 2(eps1.eps2)*epsv etc.
      zcv21=zc12v+zc21v-zcv12

      zdia8=(-znv12+znv21)/zd22-(zcv12-zcv21)/(2d0*s)

* construct the abelian and nonabelian part

      zabel= zdia1+zdia2+zdia3+zdia4+zdia5+zdia6
      znabel=zdia1-zdia2+zdia3-zdia4+zdia5-zdia6
      znabem=2d0*zdia7+2d0*zdia8
      znabel=znabel-znabem
      zabel=zabel*zfac*zfacl
      znabel=znabel*zfac*zfacl

* include colour factors:
* (n**2-1)*(n**2-2)/(8*n) = 7/3 for the abelian part
* n*(n**2-1)/8 = 3 for the nonabelian part
* and add the result to the cross section
      this1=7d0/3d0*abs(zabel)**2+3d0*abs(znabel)**2
cc    write(6,801)helix,lg1,lg2,lv,l1,l2,this1
cc801 format(' ',6i4,d30.20)
      cross=cross+this1

* end of the big loop over helicities
  360 continue

* do not forget to put p2 back to its original value in pp2!
      do 370 k=0,3
        p2(k)=pp2(k)
  370 continue

* add averaging factors:
* 1/2 for each gluon spin, 1/8 for each gluon colour
      cross=cross/256d0

* take into account a possible factor for the helicity sum option
* and return the final result
      if(imc.eq.1) cross=cross*mult
      result=cross
      end

*==================================================================

      function rkzf(l1,p1,q,rmb,l2,p2)
      implicit double precision (a-h,o-z)
* computes the scalar structure
* u_bar(l1,p1)(slash(q)+rmb)u(l2,p2)
c      implicit double precision(a-h,o-z)
c      complex*16 rkzf,rkzpr,rkzsf,zfx
      complex*16 rkzf,rkzpr,rkzsf
      complex*16 ansf(-1:1,1:4,1:8,-1:1,1:4)
      integer donf(-1:1,1:4,1:8,-1:1,1:4)
c      complex*16 check
      common / rkzfco / ansf,donf
      dimension p1(0:4),p2(0:4),q(0:4),r(0:4)
* check on correct label input
      ip1=idint(p1(4))
      iq=idint(q(4))
      ip2=idint(p2(4))
      if(iabs(l1).ne.1.or.iabs(l2).ne.1.or.
     . ip1.lt.1.or.ip1.gt.4            .or.
     . iq.lt.1.or.iq.gt.8              .or.
     . ip2.lt.1.or.ip2.gt.4) then
        write(6,*) ' rkzf label error'
        write(6,*) 'l1=',l1,' ip1=',ip1,' iq=',iq,
     .             ' l2=',l2,' ip2=',ip2
        stop
      endif
* check whether this one has been calculated already
      if(donf(l1,ip1,iq,l2,ip2).eq.0) then
* this one not done yet: do it and store the result in array 'ansf'
        if(l1.eq.l2) then
          a=2d0*rkdot(q,p2)
c         if(dabs(a).lt.(1d-10*p2(0)*q(0))) then
c...the check above is extended to following.
          if(abs(a).lt.max(1d-8,abs(1d-10*p2(0)*q(0)))) then
            ansf(l1,ip1,iq,l2,ip2)=(0.,0.)
          else
            a=rkdot(q,q)/a
            do 100 k=0,3
              r(k)=q(k)-a*p2(k)
  100       continue
            if(r(0).gt.0d0) then
              c=1d0
            else
              do 110 k=0,3
                r(k)=-r(k)
  110         continue
              c=-1d0
            endif
            ansf(l1,ip1,iq,l2,ip2)=c*rkzpr(l1,p1,r)*rkzpr(-l1,r,p2)
          endif
        elseif(l1.eq.-l2) then
          ansf(l1,ip1,iq,l2,ip2)=rmb*rkzsf(l1,p1,l2,p2)
        else
          write(6,*) ' error in rkzf: l1=',l1,'  l2=',l2
          stop
        endif
        rkzf=ansf(l1,ip1,iq,l2,ip2)
        donf(l1,ip1,iq,l2,ip2)=1
      else
        rkzf=ansf(l1,ip1,iq,l2,ip2)
      endif
      end

*==================================================================

      real*8 function rkrand(idummy)
      implicit double precision (a-h,o-z)
c      implicit double precision(a-h,o-z)
      save
      data init/0/
      if(init.eq.0) then
        init=1
        x=dmod(dsqrt(2d0),1d0)
        y=dmod(dsqrt(3d0),1d0)
        z=dmod(dsqrt(5d0),1d0)
      else
        x=dmod(x+y+z,1d0)
        y=dmod(x+y+z,1d0)
        z=dmod(x+y+z,1d0)
      endif
      rkrand=x
      end

*==================================================================

      function rkdot(p,q)
      implicit double precision (a-h,o-z)
      double precision p(0:4),q(0:4),rkdot
      rkdot=p(0)*q(0)-p(1)*q(1)-p(2)*q(2)-p(3)*q(3)
      end

*==================================================================

      function rkzpr(l,q1,q2)
      implicit double precision (a-h,o-z)
c      implicit double precision(a-h,o-z)
      complex*16 rkzpr
      dimension q1(0:4),q2(0:4)
      if(iabs(l).ne.1) then
        write(6,*) ' rkzpr: error   l=',l
        stop
      endif
c...introduce cutoff to check that r1 and r2 not zero.
      r1=dsqrt(max(1d-10,q1(0)-q1(1)))
      r2=dsqrt(max(1d-10,q2(0)-q2(1)))
      rkzpr=cmplx(q1(2),q1(3))*r2/r1
     .     -cmplx(q2(2),q2(3))*r1/r2
      if(l.eq.-1) rkzpr=-conjg(rkzpr)
      end

*==================================================================

      function rkzsf(l1,p1,l2,p2)
      implicit double precision (a-h,o-z)
c      implicit double precision(a-h,o-z)
c      complex*16 rkzsf,rkzpr,rkzsfk,check
      complex*16 rkzsf,rkzpr
      complex*16 anss(-1:1,1:4,-1:1,1:4)
      integer dons(-1:1,1:4,-1:1,1:4)
      common / rkzsco / anss,dons
      dimension p1(0:4),p2(0:4)
* check on correct label input
      ip1=idint(p1(4))
      ip2=idint(p2(4))
      if(iabs(l1).ne.1.or.iabs(l2).ne.1.or.
     . ip1.lt.1.or.ip2.gt.4.or.ip2.lt.1.or.ip2.gt.4) then
       write(6,*)
     .  ' rkzsf: error l1=',l1,' l2=',l2,' ip1=',ip1,' ip2=',ip2
       stop
      endif
* check wheter this one was already computed
* dons(,,,)=0: not yet computed, dons(,,,)=1: already computed
* if not yet computed: compute it, and store in array 'anss'
* if already computed: get the result from array 'anss'
      if(dons(l1,ip1,l2,ip2).eq.0) then
        if(l1.eq.l2) then
          anss(l1,ip1,l2,ip2)=(0.,0.)
        else
          anss(l1,ip1,l2,ip2)=rkzpr(l1,p1,p2)
        endif
        dons(l1,ip1,l2,ip2)=1
      endif
      rkzsf=anss(l1,ip1,l2,ip2)
      end

*==================================================================

      subroutine rkhlpk(num,lgl1,lgl2,llv,ll1,ll2)
c      implicit double precision (a-h,o-z)
      implicit integer(a-z)
      save
      dimension config(32,6)
      data init/0/
      if(init.eq.0) then
        init=1
        mum=0
        do 140 gl1=1,-1,-2
          do 130 gl2=1,-1,-2
            do 120 lv=1,-1,-2
              do 110 l1=1,-1,-2
                do 100 l2=1,-1,-2
                  mum=mum+1
                  config(mum,1)=gl1
                  config(mum,2)=gl2
                  config(mum,3)=lv
                  config(mum,4)=l1
                  config(mum,5)=l2
  100           continue
  110         continue
  120       continue
  130     continue
  140   continue
      endif
      lgl1=config(num,1)
      lgl2=config(num,2)
      llv =config(num,3)
      ll1 =config(num,4)
      ll2 =config(num,5)
      end

c*********************************************************************

      subroutine pykcut(mcut)
      implicit double precision (a-h,o-z)

c...dummy routine, which the user can replace in order to make cuts on
c...the kinematics on the parton level before the matrix elements are
c...evaluated and the event is generated. the cross-section estimates
c...will automatically take these cuts into account, so the given
c...values are for the allowed phase space region only. mcut=0 means
c...that the event has passed the cuts, mcut=1 that it has failed.
      common/pyint1/mint(400),vint(400)
      common/pyint2/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      save /pyint1/,/pyint2/

c...set default value (accepting event) for mcut.
      mcut=0

c...read out subprocess number.
      isub=mint(1)
      istsb=iset(isub)

c...read out tau, y*, cos(theta), tau' (where defined, else =0).
      tau=vint(21)
      yst=vint(22)
      cth=0.
      if(istsb.eq.2.or.istsb.eq.4.or.istsb.eq.6) cth=vint(23)
      taup=0.
      if(istsb.ge.3.and.istsb.le.5) taup=vint(26)

c...calculate x_1, x_2, x_f.
      if(istsb.le.2.or.istsb.ge.6) then
        x1=sqrt(tau)*exp(yst)
        x2=sqrt(tau)*exp(-yst)
      else
        x1=sqrt(taup)*exp(yst)
        x2=sqrt(taup)*exp(-yst)
      endif
      xf=x1-x2

c...calculate shat, that, uhat, p_t^2.
      shat=tau*vint(2)
      sqm3=vint(63)
      sqm4=vint(64)
      rm3=sqm3/shat
      rm4=sqm4/shat
      be34=sqrt(max(0.d0,(1.-rm3-rm4)**2-4.*rm3*rm4))
      rpts=4.*vint(71)**2/shat
      be34l=sqrt(max(0.d0,(1.-rm3-rm4)**2-4.*rm3*rm4-rpts))
      rm34=2.*rm3*rm4
      rsqm=1.+rm34
      rthm=(4.*rm3*rm4+rpts)/(1.-rm3-rm4+be34l)
      that=-0.5*shat*max(rthm,1.-rm3-rm4-be34*cth)
      uhat=-0.5*shat*max(rthm,1.-rm3-rm4+be34*cth)
      pt2=max(vint(71)**2,0.25*shat*be34**2*(1.-cth**2))

c...decisions by user to be put here.

      return
      end

c*********************************************************************

      subroutine pystfe(kf,x,q2,xpq)
      implicit double precision (a-h,o-z)

c...this is a dummy routine, where the user can introduce an interface
c...to his own external structure function parametrization.
c...arguments in:
c...kf : 11 for e-, 22 for gamma, 211 for pi+, 2212 for p.
c...    isospin conjugation for n and charge conjugation for
c...    e+, pi-, pbar and nbar is performed by pystfu.
c...x : x value.
c...q2 : q^2 value.
c...arguments out:
c...xpq(-25:25) : x * f(x,q^2), with index according to kf code,
c...    except that gluon is placed in 0. thus xpq(0) = xg,
c...    xpq(1) = xd, xpq(-1) = xdbar, xpq(2) = xu, xpq(-2) = xubar,
c...    xpq(3) = xs, xpq(-3) = xsbar, xpq(4) = xc, xpq(-4) = xcbar,
c...    xpq(5) = xb, xpq(-5) = xbbar, xpq(6) = xt, xpq(-6) = xtbar,
c...    xpq(11) = xe-, xpq(-11) = xe+, xpq(22) = xgamma.
c...
c...one such interface, to the diemos, ferroni, longo, martinelli
c...proton structure functions, already comes with the package. what
c...the user needs here is external files with the three routines
c...fxg160, fxg260 and fxg360 of the authors above, plus the
c...interpolation routine fint, which is part of the cern library
c...kernlib package. to avoid problems with unresolved external
c...references, the external calls are commented in the current
c...version. to enable this option, remove the c* at the beginning
c...of the relevant lines.
c...
c...alternatively, the routine can be used as an interface to the
c...structure function evolution program of tung. this can be achieved
c...by removing c* at the beginning of some of the lines below.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/pypars/mstp(200),parp(200),msti(200),pari(200)
      save /ludat1/,/ludat2/
      save /pypars/
      dimension xpq(-25:25),xfdflm(9)
      character chdflm(9)*5,header*40
      data chdflm/'upval','doval','gluon','qbar ','ubar ','sbar ',
     &'cbar ','bbar ','tbar '/
      data header/'tung evolution package has been invoked'/
      data init/0/

c...proton structure functions from diemoz, ferroni, longo, martinelli.
c...allowed variable range 10 gev2 < q2 < 1e8 gev2, 5e-5 < x < .95.
      if(mstp(51).ge.11.and.mstp(51).le.13.and.mstp(52).le.1) then
        xdflm=max(0.51d-4,x)
        q2dflm=max(10.d0,min(1d8,q2))
        if(mstp(52).eq.0) q2dflm=10.
        do 100 j=1,9
        if(mstp(52).eq.1.and.j.eq.9) then
          q2dflm=q2dflm*(40./pmas(6,1))**2
          q2dflm=max(10.d0,min(1d8,q2))
        endif
        xfdflm(j)=0.
c...remove c* on following three lines to enable the dflm options.
c*      if(mstp(51).eq.11) call fxg160(xdflm,q2dflm,chdflm(j),xfdflm(j))
c*      if(mstp(51).eq.12) call fxg260(xdflm,q2dflm,chdflm(j),xfdflm(j))
c*      if(mstp(51).eq.13) call fxg360(xdflm,q2dflm,chdflm(j),xfdflm(j))
  100   continue
        if(x.lt.0.51e-4.and.abs(parp(51)-1.).gt.0.01) then
          cxs=(0.51e-4/x)**(parp(51)-1.)
          do 110 j=1,7
  110     xfdflm(j)=xfdflm(j)*cxs
        endif
        xpq(0)=xfdflm(3)
        xpq(1)=xfdflm(2)+xfdflm(5)
        xpq(2)=xfdflm(1)+xfdflm(5)
        xpq(3)=xfdflm(6)
        xpq(4)=xfdflm(7)
        xpq(5)=xfdflm(8)
        xpq(6)=xfdflm(9)
        xpq(-1)=xfdflm(5)
        xpq(-2)=xfdflm(5)
        xpq(-3)=xfdflm(6)
        xpq(-4)=xfdflm(7)
        xpq(-5)=xfdflm(8)
        xpq(-6)=xfdflm(9)

c...proton structure function evolution from wu-ki tung: parton
c...distribution functions incorporating heavy quark mass effects.
c...allowed variable range: parp(52) < q < parp(53); parp(54) < x < 1.
      else
        if(init.eq.0) then
          i1=0
          if(mstp(52).eq.4) i1=1
          ihdrn=1
          nu=mstp(53)
          i2=mstp(51)
          if(mstp(51).ge.11) i2=mstp(51)-3
          i3=0
          if(mstp(52).eq.3) i3=1

c...convert to lambda in cwz scheme (approximately linear relation).
          alam=0.75*parp(1)
          tpms=pmas(6,1)
          qini=parp(52)
          qmax=parp(53)
          xmin=parp(54)

c...initialize evolution (perform calculation or read results from
c...file).
c...remove c* on following two lines to enable tung initialization.
c*        call pdfset(i1,ihdrn,alam,tpms,qini,qmax,xmin,nu,header,
c*   &    i2,i3,iret,irr)
          init=1
        endif

c...put into output array.
        q=sqrt(q2)
        do 120 i=-6,6
        fixq=0.
c...remove c* on following line to enable structure function call.
c*      fixq=max(0.d0,pdf(10,1,i,x,q,ir))
  120   xpq(i)=x*fixq

c...change order of u and d quarks from tung to pythia convention.
        xps=xpq(1)
        xpq(1)=xpq(2)
        xpq(2)=xps
        xps=xpq(-1)
        xpq(-1)=xpq(-2)
        xpq(-2)=xps
      endif

      return
      end
