c        Initialize simulation.  
c
      subroutine cbeginRun
      implicit none
#include  "Zmanagerp.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zincidentp.h" 
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zcondc.h"

      character*70 msg
      character*16 temp
      integer jold
      real*8 s1

      if(Cont) then
c           restore status at the end of previous run
         call crestoreStatus
      elseif(Job .eq. 'flesh' ) then
         call cgetSkelFile 
         Job = 'flesh'    ! Job='flesh' is kept as now
      endif

c        reset parameters.
      if(BorderHeightH .eq. 0.0) then
         BorderHeightH = HeightOfInj
      endif

      if(DestEventNo(2) .le. 0) then
         DestEventNo(2) = DestEventNo(1)
      endif

c         to lower case letters.
      temp = Generate
      call c2lowerCase(temp, Generate)
      temp = Job
      call c2lowerCase(temp, Job)

      call rndsw(jold, 1)    ! specify random number generator 1.

      if(IntModel .eq. 'int1') then
c           for Lund init.  
         call haddenC
         call chanwnC
      elseif(IntModel .eq. 'int2') then
c         Gheisha; init. Gheisha cannot use hadrin/nucrin in Cosmos
         call gpart
         call gheini
      else
         write(msg, *) 'IntModel=', IntModel,' not supported'
         call cerrorMsg(msg, 0)
      endif
#if ATMOSPHERE == 1
c          read segmented atmosphere data
      call creadAtmosD
c          manipulate data
      call catmosCnst1
      call catmosCnst2
#endif
c        init for LPM effect energy sampling.
      s1 = (7.36d0**(1./3.d0)/183.d0)**2
      call csetLPMCnst(s1, log(s1), 1.d-4, X0)
c        initialize  observation  
      call cinitObs
c        init for   primary sampling
      call ciniSPrim(PrimaryFile)

      if(CutOffFile .ne. ' ') then
         call crigCut0(CutOffFile) ! read cutoff talbe and init.
      endif
c       init for muon interaction routines; specific for Air.
      call cRdmuTab        ! set various consts for mu int.
      call cSetMu(7.36d0, 14.7d0)
      FromEpics = .false.  ! muon interaction routines for Air are
                           ! inside Cosmos 

      call ciniSPrimAng    !  this is in csPrimaAgn.f in Tracking dir.
      call ciniTracking0  !  init for  tracking for all events
c           init for knockon process; Knockon is not used now.
      if(KnockOnRatio .lt. 1.d0) then
         call cdedxEleci(KEminObs*KnockOnRatio, Knockon)
      else
         call cdedxEleci(RecoilKineMinE, Knockon)
      endif

c        check job
      call cwhatJob
c         user hook
      call chookBgRun
      end
      subroutine ciniTracking0
      implicit none
#include  "Zmanagerp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zheavyv.h"

c
      integer i

      ObserveAS = index(Generate, 'as')  .gt. 0 .or.
     *            index(Generate, 'lat') .gt. 0 
      if(index(Generate, 'qas') .gt. 0) then
         SkipPtclGen = 1  ! quick as generation for heavies.
      else
         SkipPtclGen = 0
      endif

      EventsInTheRun = 0
      if(InitRN(1) .ne. 0) then
         call rnd1r(InitRN)     ! init randeom number generator
      endif
c          compute the offset point in 'xyz' system
c        the deepest detector origin + Offset is the point
c        to which the primary is directed.
c         offset in the detector system.
      Offset.r(1) = 0.
      Offset.r(2) = 0.
      Offset.r(3) = OffsetHeight
c        convert it to xyz system.
      call cdet2xyz(ObsSites(NoOfSites).pos.xyz, Offset, Offset)
c        make it offset 
      do i= 1, 3
         Offset.r(i) = Offset.r(i) -
     *    ObsSites(NoOfSites).pos.xyz.r(i)
      enddo

      end
c     ************
      subroutine  cwhatJob
c     ************
      implicit none
#include  "Zmanagerp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
c   
c
c
      character*190  msg
      integer klena, icon
      character*8  uid 

      if(Job .eq. ' ' .or. Job .eq. 'skeleton') then
c          save present conditions
         KEminObs2 = KEminObs
         Generate2 = Generate
         NoOfSites2 = NoOfSites
         EndLevel2 = EndLevel
         if(Job .eq. ' ') then
            if(SeedFile .ne. ' ') then
c                  open seed file for output
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif               
         elseif(Job .eq. 'skeleton') then
            call
     *      cerrorMsg('  ********** skeleton making **********', 1)
            write(msg, *)  '      Generate=', Generate
            call cerrorMsg(msg, 1)
c                 save skeleton inf. in skelotonFile file.
c             The file will be modified when the distjob command
c             processes Job = 'flesh' later. You need not modify
c             skeleton file if distjob is employed.
            call copenfw(TempDev, SkeletonFile, icon)
            if(icon .ne. 0) then
               call cerrorMsg(SkeletonFile, 1)
               call cerrorMsg('File shown above cannot be opened',0)
            endif
            call cwriteParam(TempDev, 1)
            close(TempDev)
c                open SeedFile 
            if(SeedFile .eq. ' ') then
c                error. you need file
               write(msg, *)
     *         ' SeedFile must not be blank for skelton making'
               call cerrorMsg(msg, 0)
            else
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif
         endif
      elseif(Job   .eq. 'flesh') then
c             don't worry about KEminObs2 etc.  They have been read
c             from &Hparam
          call cerrorMsg('  ********** fleshing job   *********', 1)
          write(msg, *)  '      Old Generate=', Generate2
          call cerrorMsg(msg, 1)
          write(msg, *)  '      New Generate=', Generate
          call cerrorMsg(msg, 1)
          if(EndLevel .gt. EndLevel2) then
c                to deeper detph than skeleton
             write(msg, *)
     *        ' fleshing will be done to deeper depth than'//
     *        ' skeleton making time'
             call cerrorMsg(msg, 1)
             write(msg, *) ' No of old levels=', EndLevel2,
     *       ' No of new levels=', EndLevel
             call cerrorMsg(msg, 1)
          elseif(EndLevel .lt. EndLevel2) then
             call cerrorMsg('EndLevel must be >= skelton time', 0)
          endif
c                open SeedFile
          if(SeedFile .eq. ' ') then
             write(*, *) ' SeedFile must not be blank for flesh job'
             call cerrorMsg(msg, 0)
          else
             write(msg, *) 'opening SeedFFile=', 
     *        SeedFile(1:klena(SeedFile))
             call cerrorMsg(msg, 1)
             call copenf(SeedFileDev, SeedFile, icon)
             if(icon .ne. 0) then
                call cerrorMsg(SeedFile, 0)
                call cerrorMsg('File shown above seems missing',0)
             endif
          endif
      else
           write(msg,*) ' Job=',Job, ' undefined'
           call cerrorMsg(msg, 0)
      endif
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. Trace .gt. 100) then
c           defalut trace.  fix the dirctor
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid)
             TraceDir = '/tmp/'//uid(1:klena(uid))
          endif
       endif
      end
c        **************************************** read cont job info
      subroutine crestoreStatus
      implicit none
#include "Zmanagerp.h"
      integer icon

      call copenf(TempDev, ContFile,icon)
      if(icon .ne. 0) then
         call cerrorMsg(ContFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
      call creadParam(TempDev)
      close(TempDev)
      end
      subroutine cgetSkelFile
      implicit none
#include "Zmanagerp.h"
      integer icon
      call copenf(TempDev, SkeletonFile, icon)
      if(icon .ne. 0 ) then
         call cerrorMsg(SkeletonFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
c          read skelton parameters for flesing
      call creadParam(TempDev)
      close(TempDev)
      end


