      subroutine cprimFlux(
     *  comp, e_or_p, rigth, cos1, cos2, fai1, fai2,
     *  flux)
#include  "Zglobalc.h"
#include  "Zptcl.h"
#include  "Zprimary.h"

      real*8 azmmin, azmmax, rig, cosx
      logical degree, cosfactor
      common /ZpirmFlux/ azmmin, azmmax, rig, cosx,
     * degree, cosfactor

      record /component/comp  ! input primary component
      real*8 e_or_p     ! input.  E or p as given in primary file
      real*8 rigth      ! input.  threshold rigidty below which geomagneic
                        !         effect appears.  make it 0 if
                        !         no rigidity cut.
      real*8 cos1, cos2 ! input.  cos zenith range (cos1 < cos2)
      real*8 fai1, fai2 ! input.  azimuthal angle range (fai1< fai2) deg.
      real*8 flux       ! output. average flux in the above range

      real*8 prob, flux0 
      call cprimAcceptance(
     *   comp, e_or_p, rigth, cos1, cos2, fai1, fai2, prob)
      call cprimFlux0(comp, e_or_p, flux0)

      flux = prob* flux0       

      end
      subroutine cprimFlux0(comp, e_or_p, flux)
      implicit none
#include "Zptcl.h"
#include "Zprimary.h"
      record /component/ comp  ! input. primary component
      real*8 e_or_p   ! input.  Energy or momemntum as given in primary file
      real*8 flux     ! output  flux vlaue at e_or_p
                      !      if e_or_p is outside of the tale, flux=0


      integer j
      real*8 beta

      call kdwhereis(e_or_p, comp.no_of_seg+1, comp.energy, 1, j)
      if(j .gt. comp.no_of_seg) then
         flux = 0.
      elseif(j .lt. 1) then
         flux  = 0
      else
         beta = comp.beta(j)
         flux = comp.flux(j)*(e_or_p/comp.energy(j))**(-beta)
      endif
      end

