#include  "BlockData/cblkGene.h"
      implicit none
#include "Zglobalc.h"
#include "Zmanagerp.h"
#include "ZrigCut.h"
#include "Zptcl.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zprimary.h"
#include "Zprimaryc.h"
#include "Zprimaryv.h"
#include "Zincidentp.h"
#ifdef NEXT486
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif
      include 'Zflux.h'

      integer  i

      real*8 cosmin, cosmax
      real*8 ans, sum

      call creadParam(5)
      call cbeginRun
      call cprintPrim(ErrorOut)
      cosmax = IMAG_P(CosZenith)
      cosmin = real(CosZenith)
      azmmax = IMAG_P(Azimuth) + XaxisFromSouth
      azmmin = real(Azimuth) + XaxisFromSouth

      if(CutOffFile .eq. ' ') then
         rigc = 0.
         call csetCosdeg(.true., .false.)
      else
         rigc = 100.
         if(ZenValue .eq. 'deg') then
            call csetCosdeg(.true., .true.)
         else
            call csetCosdeg(.true., .false.)
         endif
      endif
      zen1 = cosmin
      zen2 = cosmax

      write(*,*) ' primary  Int(cos x dI/dE*R)  sum(cumlative)'
      sum = 0.
      do i = 1, Prim.no_of_comps
         call inteflux(Prim.each(i), ans)
         sum = sum +  ans 
         write(*,*)' ', Prim.each(i).symb,'  ', sngl(ans),
     *          '  ', sngl(sum)
      enddo

      if(CutOffFile .eq. ' ') then
         rigc = 0.
         call csetCosdeg(.false., .false.)
      else
         rigc = 100.
         if(ZenValue .eq. 'deg') then
            call csetCosdeg(.false., .true.)
         else
            call csetCosdeg(.false., .false.)
         endif
      endif
c
      write(*,*) ' primary  Int(dI/dE*R)  sum(cumlative)'
      sum = 0.
      do i = 1, Prim.no_of_comps
         call inteflux(Prim.each(i), ans)
         sum = sum +  ans 
         write(*,*)' ', Prim.each(i).symb,'  ', sngl(ans),
     *          '  ', sngl(sum)
      enddo

      write(*,*)
     *  'If N primaries are generated in simulation, ST= N/sum'
      end
c     ******************
      subroutine inteflux(comp, ans)
      implicit none
#include "Zglobalc.h"
#include  "Zptcl.h"
#include  "Zprimary.h"
      record /component/ comp
      real*8 ans
      include 'Zflux.h'
      
      real*8 eps, error, ans2, Eth, e_or_p
      integer icon


      integer imax
      external primdN
      real*8 primdN
      record /ptcl/aPtcl
      integer j
      data eps/1.d-4/

c          take into account the horizontal  area.

      compx = comp
      imax = comp.no_of_seg
      if(rigc .eq. 0.) then
c         no rigidy  cut. integrate segmented power functions
         call intePrim2(comp, 1, imax, ans)
         if(cosfactor) then
            ans = ans * (zen2**2- zen1**2)/2 *
     *                   abs(azmmax - azmmin)*Torad
         else
c              fai is from 0 to 2pi; 
            ans = ans *(zen2-zen1)/2.d0* (1.d0 + (zen1 + zen2)/2.d0)
         endif   
      else
         call cmkptc(comp.code, comp.subcode, comp.charge, aPtcl)
         Eth =sqrt( (rigc*comp.charge)**2 + aPtcl.mass**2 )
         call cconv_prim_e2(comp, Eth, e_or_p)
         call kdwhereis(e_or_p, comp.no_of_seg+1, comp.energy, 1, j)
         if(j .le. imax) then
c              energy integral; 
            call kdexpIntFb(primdN, comp.energy(1), comp.energy(j+1),
     *           eps,  ans, error,  icon)
            ans = ans * Torad
c             add E> comp.energy(j+1)
         endif
         if(j+1 .lt. imax ) then
            call intePrim2(comp, j+1, imax, ans2)
            if(cosfactor) then
               ans2 = ans2 * (zen2**2- zen1**2)/2 *
     *                  abs(azmmax - azmmin)*Torad
            else
c              fai is from 0 to 2pi; 
               ans2 =
     *            ans2 *(zen2-zen1)/2.d0* (1.d0 + (zen1 + zen2)/2.d0)
            endif
         else
            ans2 = 0.
         endif
         ans = ans + ans2
      endif
      end
    
c     ****************************      
      real*8 function primdN(eorp)
      implicit none

#include "Zglobalc.h"
#include "Zptcl.h"
#include "Zprimary.h"
c          primary flux at E       
      real*8 eorp

      include 'Zflux.h'

      real*8 funczen, ans
      external funczen

      E = eorp
c         integral on  zenith 
      call k16pGaussLeg(funczen, zen1, zen2, 16, ans)
      primdN = ans
      end
c      ********************************
      real*8 function funczen(zenx)
      implicit none
#include "Zptcl.h"
#include "Zprimary.h"

      real*8 zenx

      include 'Zflux.h'

      integer icon
      real*8 eps, ans, error
      real*8 funcazim
      external funcazim
      data  eps/1.d-5/

      zen = zenx
      call kdexpIntF(funcazim, azmmin, azmmax, eps, ans, error, icon)
      funczen = ans
      end
c.......................
      real*8 function funcazim(azm)
      implicit none
#include "Zglobalc.h"
#include "Zptcl.h"
#include "Zprimary.h"
      include 'Zflux.h'

      record /ptcl/ aPtcl
      real*8 rig, azm, prob, flux, zeny

c          E= E_or_P  must be converted to rigidity
      call cconv_prim_e(compx, E, aPtcl)

      rig =sqrt( aPtcl.fm.p(4)**2  - aPtcl.mass**2)/aPtcl.charge
      if(degree) then
         zeny = zen/Torad
      else
         zeny = zen
      endif
      call crigCut(azm, zeny, rig, prob)
c/////////////
c      prob = 1.
c/////////////
      call cprimFlux0(compx, E, flux)  ! E = EorP
      if(cosfactor) then
         funcazim = flux * prob * zen
      else
         funcazim = flux * prob *(1.0d0+ zen)/2.d0
      endif
      end

      subroutine intePrim2(comp, i1, i2, ans)
      implicit none
#include "Zptcl.h"
#include "Zprimary.h"
c          primary flux at E       
      record /component/comp
      integer i1, i2
      real*8 ans

      real*8 sum, beta

      integer i
      sum = 0.

      do i = i1, i2
         beta=comp.beta(i)
         if(beta .ne. 1.) then
            sum = sum +
     *           comp.flux(i)*comp.energy(i)
     *           / (beta - 1.)
     *           *( 1. -
     *           (comp.energy(i+1)/comp.energy(i))**(1.-beta))
         else
            sum =
     *           sum +  comp.flux(i)* comp.energy(i)
     *           * log(comp.energy(i+1)/comp.energy(i))
         endif
      enddo
      ans = sum 
      end
      subroutine chookTrace
      end
      subroutine chookCeren
      end
      subroutine chookCerenS
      end
      subroutine chookCerenE
      end
      subroutine chookBgRun
      end
c     ***************************
      subroutine csetCosdeg(cosin,  degin)
      implicit none
      logical cosin, degin
#include "Zptcl.h"
#include "Zprimary.h"

      include 'Zflux.h'
      
      cosfactor = cosin
      degree = degin
      end


