c      cinitObs:  set up observation sites by reference to Zobsp.h
c        HeightList is obtained from DepthList.
c        However, if DepthList value is negative, HeightList has priority and
c        DepthList is obtained from HeightList.
c        Variables in Zobsv.h are calculated.
       subroutine cinitObs
       implicit none
c
#include  "Zglobalc.h"
#include  "Ztrackp.h"
#include  "Zcoord.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zearth.h"

c
       integer i, icon
       logical error
       character*80  msg
       record /coord/ south 
       real*8  cvh2thick, cthick2h, mu
       external cblkObs
c
       NoOfSites = 0
       do i = 1, maxNoOfSites
          if( DepthList(i) .eq. 0. ) goto 100    ! exit
          NoOfSites = NoOfSites + 1
          if( DepthList(i) .lt. 0. ) then
c                HeightList has priority
               DepthList(i) = cvh2thick(HeightList(i))
          else
               HeightList(i) = cthick2h(DepthList(i))
          endif
          call csetCoord('llh', LatitOfSite, 
     *    LongitOfSite, 
     *    HeightList(i),   ObsSites(i).pos.xyz )
       enddo
 100   continue
       if(NoOfSites .eq. 0) then
          call cerrorMsg('No of Observation sites = 0', 0)
       endif
       if(EndLevel .eq. 0) EndLevel = NoOfSites   ! 96.09.18
c               set magnetic field for the deepest level. 
c                 Magfield is 'ned' here
       if(HowGeomag .gt. 20 .and. HowGeomag .le. 30 ) then
          MagfieldNED.x = MagN
          MagfieldNED.y = MagE
          MagfieldNED.z = MagD
          MagfieldNED.sys = 'ned'
       else
c           if HowGeomag <=2, this is reset later. don't worry.
          call cgeomag(YearOfGeomag, ObsSites(NoOfSites).pos.xyz, 
     *              MagfieldNED, icon)
          if(icon .eq. 1) then
             write(msg, *) ' YearOfGeomag=',YearOfGeomag, ' is ok ?'
             call cerrorMsg(msg, 1)
          endif
       endif
c              to 'hva'
       call ctransMagTo('hva',    ObsSites(NoOfSites).pos.xyz, 
     * MagfieldNED, MagfieldHVA)
       call ctransMagTo('xyz',    ObsSites(NoOfSites).pos.xyz, 
     * MagfieldNED, MagfieldXYZ)
       if(abs(XaxisFromSouth) .gt. 360.d0) then
c           if it is > 360, use magnetic east to be the detector x-axis. 
c           angle form south to x-axis in counter closckwise.
c        Note:   'hva' system angle  + is clockwise.
c       XaxisFromSouth = 90.0 - MagfieldHVA.x
          XaxisFromSouth = 90.0 - MagfieldHVA.x
       endif

c          celestial coord. init.
       call kcelei(LatitOfSite, 
     *   LongitOfSite, DtGMT, 
     *   ObsSites(NoOfSites).pos.height)
       call kadthi(XaxisFromSouth)

 
c          site coord is made  to be in the  xyz system.       
       do i = 1, NoOfSites
          call ctransCoord2('xyz', ObsSites(i).pos.xyz,
     *        ObsSites(i).pos.xyz )  ! to xyz
c                set ObsSites(i).pos.radiallen, ..depth, height
          call csetPos2(HeightList(i), DepthList(i), ObsSites(i).pos)
       enddo
c          detector system coord. x is directed to mag. east.
c                                 z is directed to vertical.
c          get their direction cos. in 'xyz' system.
c
       CosLatitude = cos(LatitOfSite*Torad)
       SinLatitude = sin(LatitOfSite*Torad)
       CosLongitude = cos(LongitOfSite*Torad)
       SinLongitude = sin(LongitOfSite*Torad)
       DetZaxis.r(1) = CosLatitude * CosLongitude
       DetZaxis.r(2) = CosLatitude * SinLongitude
       DetZaxis.r(3) = SinLatitude
c          south direction is expressed as
       south.r(1) = SinLatitude *CosLongitude
       south.r(2) = SinLatitude *SinLongitude
       south.r(3) = -CosLatitude
c        in south-vertical system. X-axis is expressed
       DetXaxis.r(1) = cos(XaxisFromSouth * Torad)
       DetXaxis.r(2) = sin(XaxisFromSouth * Torad)
       DetXaxis.r(3) = 0.
c           convert it to 'xyz' system       
       call ctransVectZx(1, DetZaxis, south, DetXaxis, DetXaxis)
       
c        check if in the ascending order of detph
       error = .false.
       do i = 2, NoOfSites
          if(DepthList(i-1) .ge. DepthList(i)) then
             write(msg, *) 'Depth is not in ascending order ',
     *       i, '-th one=',DepthList(i), 
     *       ' is <  previous one= ',  DepthList(i-1)
             call cerrorMsg(msg, 1)
             error = .true.
          endif
       enddo
       if(error) then
          call cerrorMsg('Obsev. depth/height not in order', 0)
       endif
c         +++++++++++++++++++++++ for AS ++++++++++++++++
       NoOfASSites = 0
       do i = 1, maxNoOfASSites
          if( ASDepthList(i) .eq. 0. ) goto 200    ! exit
          NoOfASSites = NoOfASSites + 1
          if( ASDepthList(i) .lt. 0. ) then
c                HeightList has priority
               ASDepthList(i) = cvh2thick(ASHeightList(i))
          else
               ASHeightList(i) = cthick2h(ASDepthList(i))
          endif
          call csetCoord('llh', LatitOfSite, 
     *    LongitOfSite, 
     *    ASHeightList(i),   ASObsSites(i).pos.xyz )
       enddo
 200   continue
 
c          site coord is made  to be in the  xyz system.       
       do i = 1, NoOfASSites
          call ctransCoord2('xyz', ASObsSites(i).pos.xyz,
     *        ASObsSites(i).pos.xyz )  ! to xyz
c                set ASObsSites(i).pos.radiallen, ..depth, height
          call csetPos2(ASHeightList(i), ASDepthList(i), 
     *     ASObsSites(i).pos)
c             Moliere Unit should be reset depending on
c             the 1ry angle. Here is a tentative one for vertical           
          call cgetMoliereU(ASObsSites(i).pos.depth, 1.d0, mu)
          ASObsSites(i).mu = mu
       enddo

       end
