c         parameters for Elemag process.
c	(->   ----------------------------------------------

	real*8  RecoilKineMinE  !2  Recoil Kinetic Min Energy above which the recoil (=knock-on process)
                                ! is treated. Below this energy, the effect is included as continuous
                                ! energy loss.
	real*8  X0            !2  radiation length in kg/m2 for air
	real*8  Ecrit         !2  critical energy in GeV. 
                              !  employed only when calculating air shower size in the hybrid 
                              !  air shower generation.  The value would be dependent on the
                              !  experimental purpose.  The default  value, 81 MeV, is bit too
                              !  small in many applications (The air shower size is overestimated). 
                              !  Comparisons of sizes  by the hybrid method and by the  full Monte 
                              !  Carlo tell that
                              !
                              !  $N_e$(full 3-D  M.C)$ < N_e$(hybrid AS with $E_c=81$ MeV )$
                              !  < N_e$(full 1-D M.C)$ {\ \lower-1.2pt\vbox{\hbox{\rlap{$<$}
                              !  \lower5pt\vbox{\hbox{$\sim$}}}} }N_e$(hybrid AS with $E_c={76}$ MeV).
                              !
                              !  at around shower maximum.   Hybrid AS is always essentially 1-D.

	logical Knockon       !2  if T, Knockon process is considered
	real*8  AnihiE        !2  if E(positron)  < Eanihi, annihilation is  considered. 
	real*8  Es            !2  Modified scattering constant. 19.3d-3 GeV
	real*8  MaxComptonE   !2 Above this energy, Compton is neglected. 
	real*8  MaxPhotoE     !2 Above this energy, photoelectric effect is neglected.
	real*8  MinPhotoProdE !1  Below this energy, no photo-prod of hadron.  See also PhotoProd.
	logical PhotoProd     !1  Switch. if .false., no photo prod. of hadron is considered at all. 
                              !   See also MinPhotoProdE.
        integer Moliere       !2  0$\rightarrow$ use Gaussian approx always (with air density change and
			      !    energy loss effect)\newline
                              !   1$b\rightarrow$ use Moliere scattering for non-electrons (default)\newline
                              !   2$\rightarrow$ use Moliere scattering for all charged particles.\newline
                              !    If negative, angle correlated displacement is made to be 0 since Moliere
                              !    theory cannot give it. (if >0, we use Gaussian approximation for correlation). 


c	<-)	----------------------------------------------

	common /Zelemagc/  RecoilKineMinE, AnihiE, MaxComptonE,
     *  MaxPhotoE, MinPhotoProdE,   Es, X0, Ecrit, Knockon, 
     *  PhotoProd, Moliere

