c            make one incident particle, and maka a copy of it
c       in IncientCopy.
c
      subroutine cmkIncident(incident)
      implicit none
c
c     incident:  /track/.  output.   incident particl with track information.
c               copy of it is saved as 'IncidentCopy', and can be
c               inquired by call cqIncident(...)
c
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zmanagerp.h"


      record /track/ incident
      record /coord/ angle

      integer icon
c
      icon = 1

      do while (icon .ne. 0)
c          sample energy, mass, code (mometum is not given)
         call csampPrimary(incident.p)
c          fix angle at observation level. in detector system.
         call csPrimAng(angle)
         call cmkInc(incident, angle)
         if(CutOffFile .ne. ' ') then
            call cifCutOff(icon)
         else
            icon =0
         endif
      enddo
      end
c     *******************************
      subroutine cresetPrim(incidentp, angle)
      implicit none
c        reset primary.  This is typically used by the user,
c        at chookBgEvent to reset the primary which has been
c        set by the sytem so that the user can set own primray.
c
#include  "Ztrack.h"  
      record /ptcl/ incidentp ! input. must have E, mass, charge,subcode
      record /coord/ angle  ! input. direction cos at 'det' system
c
      record /track/ inc2
      
c         inc2.p = incidentp : for IBM, we must  write as follows.
      inc2.p.charge=incidentp.charge
      inc2.p.subcode=incidentp.subcode
      inc2.p.fm.p(4) = incidentp.fm.p(4)
      inc2.p.mass = incidentp.mass
      call cmkInc(inc2, angle)
      call ciniTracking
      call cinitStack
      call cpush(inc2)
      end
      
c     ********************************
      subroutine cmkInc(incident, angle)
      implicit none
c
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zincidentv.h"
#include  "Zearth.h"

      record /track/ incident ! input/outut.
c             must have E, m, code, subcode, charge
      record /coord/ angle    ! input. must have direction cos in the det. sys.
c
c
      real*8 to100km, clenbetween2h, zenithcos, len
      integer i, j

      AngleAtObsCopy = angle
      if(Reverse .ne. 0 ) then
c           to see  cut off or to see if go out of Earth
         do i = 1, 3
            AngleAtObsCopy.r(i) =  - AngleAtObsCopy.r(i) 
         enddo
c             charge conjugate
         incident.p.charge = -incident.p.charge
         incident.p.subcode = -incident.p.subcode
      endif
c           convert it to 'xyz' system
      call ctransVectZx(1, DetZaxis, DetXaxis, AngleAtObsCopy, 
     *    DcAtObsXyz)
c
      incident.pos.xyz.sys = 'xyz'  !  Exyz system 
c      --- fix injection point ---
c      get length from the deepest obs. place + OffsetHeight to 
c          HeightOfInj (=100 km); Normally OffsetHeight is 0.
c         if the primary is to be directed to different height
c         than the detector, make it non zero.
      zenithcos = - AngleAtObsCopy.r(3)
      to100km = clenbetween2h(
     *  ObsSites(NoOfSites).pos.radiallen + OffsetHeight, 
     *  Eradius + HeightOfInj,  zenithcos )  ! we need zenith angle here

c         primary is going upward even if Reverse = 0.
      Upgoing = Reverse .eq. 0 .and. zenithcos .lt. 0. 
     *   .and. HeightOfInj .lt. ObsSites(NoOfSites).pos.height

      if(( Reverse .eq. 0 .and. zenithcos .lt. 0. 
     *  .and.  HeightOfInj .gt. ObsSites(NoOfSites).pos.height)
     *  .or. ( Reverse .ne. 0 .and. zenithcos .gt. 0.)) then
c            distance to the conjugate point
         to100km = to100km -
     *    2*(ObsSites(NoOfSites).pos.radiallen + OffsetHeight)*
     *    zenithcos
c             we should go reversed direction
         to100km = - to100km
      endif
c           injection point
      do i = 1, 3
         incident.pos.xyz.r(i) = ObsSites(NoOfSites).pos.xyz.r(i) 
     *    + Offset.r(i)  + to100km * DcAtObsXyz.r(i)
      enddo

      call csetPos(incident.pos)
      call csetDirCos(DcAtObsXyz, incident)   ! set dc and coszenith in incident
c           momentum business
      call ce2p(incident)    !  px, py, pz   from direction cos

c          set time 0
      incident.t = 0.
      incident.wgt = 1.       ! weight is 1.

c           Next obs site
      if( Upgoing ) then
         incident.where = NoOfSites
      else
         incident.where = 1     
      endif

      incident.asflag = 0
      incident.pos.colheight = Infty  ! latest nuc. collision height
      IncidentCopy = incident

c           shift the origin of detectors to be on the primary track
c           if OffsetHight=0
      if(OffsetHeight .eq. 0.) then
         if(zenithcos .ge. 0. .or. Upgoing) then
            do i = 1, NoOfSites-1
               len = clenbetween2h(
     *              ObsSites(NoOfSites).pos.radiallen, 
     *              ObsSites(i).pos.radiallen,
     *              zenithcos ) 

               do j = 1, 3
                  ObsSites(i).pos.xyz.r(j) = 
     *            ObsSites(NoOfSites).pos.xyz.r(j)
     *             + len * DcAtObsXyz.r(j)

               enddo
            enddo
            do i = 1, NoOfASSites-1
               len = clenbetween2h(
     *         ASObsSites(NoOfASSites).pos.radiallen, 
     *         ASObsSites(i).pos.radiallen,
     *         zenithcos ) 
               do j =1 , 3
                  ASObsSites(i).pos.xyz.r(j) = 
     *                ASObsSites(NoOfSites).pos.xyz.r(j)
     *                + len * DcAtObsXyz.r(j)
               enddo
            enddo
         endif
      endif
c          compute min time from  the injection point to each
c         obs level.
      call csetMinTime(incident)
      end
c     *****************************
c        compute the minimum time the light needs to reach
c        each observation level from a given radial height from
c        along the primary direction
      subroutine csetMinTime(from)
      implicit none
c
c
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zincidentv.h"
c#include  "Zearth.h"
      
      record /track/from   ! input.  track to be origin
 
      real*8 clenbetween2h
      integer i

      do i = 1, NoOfSites
         ObsSites(i).minitime =
     *       clenbetween2h(from.pos.radiallen, 
     *       ObsSites(i).pos.radiallen,
     *       from.vec.coszenith)    ! actually this is in m.
      enddo
      from.t = 0.    ! reset time of incident track.
      end
c     *************************** inquire incident particle
      subroutine cqIncident(incident, AngleAtObs)
c     *************************** 
      implicit none
#include  "Ztrack.h"
#include  "Zincidentv.h"
      record /track/ incident
      record /coord/ AngleAtObs
      incident = IncidentCopy
      AngleAtObs = AngleAtObsCopy
      end
