c  cexcesLenght:
c         ************************************************************
c         *  compute exccess length by scattering of a charged ptcl
c         *  as compared to the straight pass
c         *
c                 !
c                 ! *
c                 ! *           dt given here is the excess path
c                 !   *         of * as compared with sqrt(r**2+l**2)-l
c                 !    *        it should be > sqrt(r**2+l**2)-l
c              l  !     *   
c                 !     *      i.e.  path length of * is sqrt(r**2+l**2) + dt
c                 !      *
c                     r
c               To get total time needed to run the * path, 
c             simply add dt/beta to the time in MovedTrack.
c    
      subroutine cexcessLen(dx, dy, dt)
c
      implicit none
c----      include '../Ztrack.h'
#include  "Ztrack.h"
c----      include '../Ztrackv.h'
#include  "Ztrackv.h"
c----      include 'Zelemagp.h'
#include  "Zelemagp.h"
c
      real*8  dx, dy  ! small dispalcement by scattering and geomag effect.
c          this treatment valid for only scattering displacement, but
c          for small displacement, we may add geomag. effect too.
c 
      real*8  dt   ! output in m  (not devided by beta)
      real*8 tmp, ee1, rr2, rp2, t, tang, tang1, za, za2
      real*8  dtp, en, u, g, al, tt, reall2, ge, reall
c
c           
      real*8 dtp0/.12/    !  dtp at rp2=0
      real*8  cthick2den
c
      if(dx .eq. 0. .and.  dy .eq. 0.) then
         dt = 0.
      else
          za = TrackBefMove.pos.depth
          za2 = MovedTrack.pos.depth 
          ee1 = TrackBefMove.p.fm.p(4)
          reall = IntInfArray(ProcessNo).length
          t = IntInfArray(ProcessNo).thickness/X0  ! r.l travelled

          tmp=(Es/ee1)**2*cthick2den(.6666*za+ .3333*za2  )/X0
c
          rr2 = dx**2 + dy**2
          rp2 = rr2/tmp/reall**3
c                get coefficient for straight line for rp2 vs dtp
c               (average relation)
c                get tangent

          if(ee1 .gt. 500.e-3) then
             if(t .gt. 0.3) then
                tang=(0.49/(za+.1) + .053)*t + 1.13
             else
                tang=0.33 *t + 1.05
             endif
          else
             tang1=4.37e-2/ee1 + 1.3e-2
             tang=tang1*t+ 1.05
          endif
c
c                  get <dtp>
          dtp=tang*rp2+dtp0
c               get n for
c               dtp(>tt)/dtp(all)= tt**n/( .7544+tt**n)
c               this dtp is normalized by <dtp>
          en=19.375*rp2 +3.531
c               dtp= t**en/(beta+t**en) is a first good  approximation
c               which is solved for uniform random # as
c               t=( beta*u/(1-1))**(1/en). at small u,
c               t is under estimated so that it's correction is needed.
c               sample dtp ( <> normailzed )
          call rndc(u)
          if(u .lt. .3) then
c              g= (1.35-1.15)/6.5 * (en-10.)+ 1.35 =
             g= 3.077e-2*en +1.042
             al= ((3.33- 3.33/g)*u+1./g)/en
          else
             al=1./en
          endif

          tt=( 0.7544*u/(1.-u) )** al
c           convert to dt (in m)
          reall2=reall**2
          dt=dtp*tmp*reall2/2
c             it should be > sqrt(reall**2 + r**2) -reall
c             it may happen not so due to some approximation
          ge = sqrt(reall2 + rr2) -reall
          dt = max(ge, dt)
       endif
      end
