c#include "cblkdedx.h"
c      implicit none
c      real*8 e, dedt, ek
c      integer i
c      call cdedxEleci(225.d-6,  .true.)
c      do i=1, 300
c        ek=1.e-9*10.**( (i-1) /20.) 
c        e = ek + 0.511e-3
c        call cdedxElec(e, -1, dedt)
c        write(*, *)sngl(ek), sngl(dedt)
c      enddo
c      end
     
c     ****************************************************************
c     *                                                              *
c     * cdedxElec:  gives -de/dx  (gev/(g/cm2) of e+/e-
c     *        if knock-on process is not to be included,            *
c     *        -de/dx by sternheimer is computed else                *
c     *        -de/dx by sternheimer - (-de/dx(recoil k.e > w) )     *
c     *        is computed.                                          *
c     *   ********** use precdedxElec for making const *******
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call cdedxElec(e, ic, dedt)
c          call cdedxEleci(w, Knckon)
c -- input--
c        e: total energy of electron in GeV
c       ic: charge. -1 if electron. 1 if positron
c        w: kinetic energy of recoil electron in GeV.  k.e>w is not
c           included as energy loss so that it should be treated by
c           producing the recoil electron actually.  (usually, w=.255e-3
c           will be better.
c   Knckon: if t, knock-on process is considered for energy > w
c           so that only knock-on electrons of energy < w is
c           included in energy loss.  if f, all knockon electrons
c           are considred as energy loss.
c
c -- output --
c     dedt; energy loss /(g/cm2) (GeV)
c
c  *** note ***
c      Before calling this, cdedxEleci must have been called.
c
c
c
      subroutine cdedxElec(eini, ic, dedt)
       implicit none
c
c
#include  "ZdedxAir.h"
c
      real*8 eini, dedt
      integer ic
      external cblkdedx

      real*8 emass, emassg
      real*8 ek, ein, e, gi, Beta2, x, a, b, c, cb, x0, x1
      real*8 dltx, wm, wlg
c
      data emass/.511/, emassg/.511e-3/

      real*8 peake/2.3e-7/, peak/0.858/
c
       if(jdef .eq. 0) then
          write(*, *) ' cdedxEleci must be called'
          stop 9999
       endif

       ek=eini-emassg
       ein=eini

       if( ek .lt. peake) then
              dedt=peak*sqrt(ek/peake)
       else
c                  energy in mev unit
              e=ein*1000
              gi=emass/e
              Beta2= 1. - gi**2
c                  x=log10(p/mc)
              x=log10(e**2 - .2611)/2 + .29
              a=stha
              b=sthb
              c=sthc
              cb=-c
              x0=sthx0
              x1=sthx1
              if(x .lt. x0) then
c                    4.605x - dlt
                  dltx=4.605*x
              elseif(x .lt. x1) then
                  dltx=cb - (x1-x)**3 * sthsa
              else
                  dltx=cb
              endif
              wm=e- emass
              if(Knckon) then
                   if(wm .gt. w0) then
                       wlg=wlg0
                   else
                       wlg=log(wm)
                   endif
              else
                   wlg=log(wm)
              endif
              if(ic .eq. -1) then
                  dedt=a/Beta2 * (b + 1.12+wlg-Beta2 +dltx)
              else
                  dedt=a/Beta2 *( b+.693+wlg -2*Beta2 + dltx)
              endif
c                            convert it to gev/r.l
              dedt=dedt *1.e-3
          endif
        end
c
c      ***********
       subroutine cdedxEleci(w0in,  knck)
       implicit none
c      ***********
c
#include  "ZdedxAir.h"

      logical knck

      real*8  w0in

      external cblkdedx
c
      jdef = 1

       w0=w0in
       Knckon=knck
c          log(w*1000.)
       wlg0=log(w0) + 6.907
      end

