caatjjetset 6.3.  the lund monte carlo for jet fragmentation and e+e-
c1   physics - jetset version 6.3 - an update.  t. sjostrand,
c2   m. bengtsson.
cref. in comp. phys. commun. 43 (1987) 367
c@enter  thep-ts,jets,thep,20
c@nd
cf-5
copt off
ccom jetset63 term jetset63
ccom run001 term runcom
cex
cl-l
cset-dom scratch
cload runcom
cload jetset63
cload ranf
cex
cplace scratch
copen term 6 write
crun
ctime
cexit
c
c
c...test program for the lund monte carlo - jetset 6.3
c...torbjorn sjostrand, october 1986
      common /lujets/ n,k(2000,2),p(2000,5)
      common /ludat1/ mst(40),par(80)
      common /ludate/ mste(40),pare(80)
      dimension pini(5), pfin(5)

c...loop over events to be generated
      nwrong=0
       do   ica=1,842

c...reset parameter values and total energy
      mst(5)=1
      mst(6)=0
      mste(1)=3
      mste(4)=5
      mste(5)=0
      mste(7)=1
      mste(11)=2
      mste(12)=4
      mste(14)=2
      if(ica.eq.301.or.ica.eq.351.or.ica.eq.401) mste(9)=3
       do   j=1,5
      pini(j)=0.
       enddo

      if(ica.le.50) then
c...ten events each for some single jets
        ity=(ica+9)/10
        if(ity.eq.1) call lu1jet(1,1,0,0,15.,0.,0.)
        if(ity.eq.2) call lu1jet(1,13,0,0,15.,0.,0.)
        if(ity.eq.3) call lu1jet(1,12,1,1,15.,0.,0.)
        if(ity.eq.4) call lu1jet(1,4,0,-1,15.,0.,0.)
        if(ity.eq.5) call lu1jet(1,0,0,0,15.,0.,0.)
        pini(3)=p(1,3)
        pini(4)=15.
        if(ity.eq.1) pini(5)=2./3.
        if(ity.eq.2) pini(5)=1./3.
        if(ity.eq.3) pini(5)=1.

      elseif(ica.le.130) then
c...ten events each for some simple jet systems; string fragmentation
        ity=(ica-41)/10
        if(ity.eq.1) call lu2jet(1,1,-1,40.)
        if(ity.eq.2) call lu2jet(1,4,-4,40.)
        if(ity.eq.3) call lu2jet(1,1,21,40.)
        if(ity.eq.4) call lu2jet(1,0,0,40.)
        if(ity.eq.5) call lu3jet(1,12,-32,40.,0.6,0.8)
        if(ity.eq.6) call lu3jet(1,5,-5,40.,0.9,0.8)
        if(ity.eq.7) call lu3jet(1,0,0,40.,0.7,0.5)
        if(ity.eq.8) call lu4jet(1,1,0,0,-1,40.,0.4,0.64,0.6,0.12,0.2)
        pini(4)=40.
        if(ity.eq.3.or.ity.eq.5) pini(5)=1.

      elseif(ica.le.200) then
c...ten events each for three-jet events; independent fragmentation
c...with momentum conservation
        ity=(ica-121)/10
        call lu3jet(1,3,-3,40.,0.9,0.4)
        if(ity.le.4) mst(5)=4
        if(ity.ge.5) mst(5)=6
        if(ity.le.4) mst(6)=ity
        if(ity.ge.5) mst(6)=ity-4
        pini(4)=40.

      elseif(ica.le.300) then
c...a hundred events with random jets (check invariant mass)
  110   do 120 j=1,4
  120   pini(j)=0.
        njet=2.+6.*rlu(0)
         do   i=1,njet
        ifl=0
        if(i.eq.1) ifl=1
        if(i.eq.njet) ifl=-1
        ejet=5.+20.*rlu(0)
        theta=acos(2.*rlu(0)-1.)
        phi=6.2832*rlu(0)
        if(i.lt.njet) call lu1jet(-i,ifl,0,0,ejet,theta,phi)
        if(i.eq.njet) call lu1jet(i,ifl,0,0,ejet,theta,phi)
         do   j=1,4
         enddo
        if(pini(4)**2-pini(1)**2-pini(2)**2-pini(3)**2.lt.4.) goto 110

      elseif(ica.le.350) then
c...fifty e+e- continuum events with matrix elements
        mste(1)=2
        call lueevt(0,40.)
        pini(4)=40.

      elseif(ica.le.400) then
c...fifty e+e- continuum event with conventional shower
        mste(11)=1
        mste(12)=1
        mste(14)=1
        call lueevt(0,90.)
        pini(4)=90.

      elseif(ica.le.450) then
c...fifty e+e- continuum events with coherent shower, including top
        mste(4)=6
        call lueevt(0,150.)
        pini(4)=150.

      elseif(ica.le.500) then
c...fifty upsilon decays to ggg or gammagg with coherent shower
        call luonia(5,9.46)
        pini(4)=9.46

      elseif(ica.le.550) then
c...ten events each for some low-pt configurations
        ity=(ica-491)/10
        mst(5)=0
        if(ity.eq.1) call lulopt(41,41,10.,10.)
        if(ity.eq.2) call lulopt(41,42,100.,0.)
        if(ity.eq.3) call lulopt(-41,41,10.,10.)
        if(ity.eq.4) call lulopt(-17,41,200.,0.)
        if(ity.eq.5) call lulopt(18,42,200.,0.)
        mst(5)=1
        pini(3)=p(1,3)+p(2,3)
        pini(4)=p(1,4)+p(2,4)
        if(ity.eq.1) pini(5)=2.
        if(ity.eq.2.or.ity.eq.5) pini(5)=1.

      else
c...one decay each for heavy particles
        call lupart(1,ica-450,0.,0.,0.)
        pini(4)=p(1,5)
        pini(5)=plu(1,6)
      endif

c...generate event; find total momentum, energy and charge
      call luexec
      nerr=0
       do   j=1,4
       enddo
      pfin(5)=plu(0,6)

      if(ica.le.50) then
c...check approximate conservation for single jets
        if((pfin(1)-pini(1))**2+(pfin(2)-pini(2))**2.ge.2.) nerr=nerr+1
        epzrem=pini(4)+pini(3)-pfin(4)-pfin(3)
        if(epzrem.lt.0..or.epzrem.gt.2.*par(21)) nerr=nerr+1
        if(abs(pfin(5)-pini(5)).gt.2.1) nerr=nerr+1

      else
c...check exact conservation for jet systems and single particles
         do   j=1,5
         enddo nerr=nerr+1
      endif

c...write information about nonconservation
      if(nerr.ne.0) write(6,1000) (pini(j),j=1,5), (pfin(j),j=1,5)
 1000 format(' momentum, energy and/or charge were not conserved ',
     &'in following event'/' sum of',9x,'px',11x,'py',11x,'pz',11x,
     &'e',8x,'charge'/' before',2x,4(1x,f12.5),1x,f8.2/' after',3x,
     &4(1x,f12.5),1x,f8.2)

c...check that particles and partons on mass shell
       do   i=1,n
      if(k(i,1).ge.40000) goto 160
      pd=p(i,4)**2-p(i,1)**2-p(i,2)**2-p(i,3)**2-p(i,5)**2
      if(abs(pd).gt.max(0.1,0.001*p(i,4)**2)) then
        write(6,*) ' m2 error for particle ',i,' in following event'
        nerr=nerr+1
      endif
       enddo

c...list all erroneous events and some normal ones
      if(nerr.ne.0.or.ica.eq.5.or.ica.eq.55.or.ica.eq.105.or.ica.eq.
     &205.or.ica.eq.305.or.ica.eq.405.or.ica.eq.505.or.ica.eq.805)
     &call lulist(1)

c...stop execution if too many errors, else generate new event
      if(nerr.ne.0) nwrong=nwrong+1
      if(nwrong.ge.10) then
        write(6,*) ' ten errors experienced: something is seriously ',
     &  'wrong. execution stopped.'
        stop
      endif
  200 continue

c...endresult of run
      write(6,1100) nwrong
 1100 format(/10x,'number of erroneous or suspect events in run:',i3/
     &5x,'(0 fine, 1-2 acceptable if involving single jets, ',
     &'>2 something is wrong)')

      end
