c
c       test chdahead use:
c            make chdahead
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 z, sdep, cosz, z2, sdep2, dz, cosz2
      real*8 chang2sdep, cnewcos, cnewh
      real*8 cosx, hx, rx, length
      cosx = 0.0d0
      hx =00.d3
      length = 1.d3
      rx = Eradius + hx
      cosz = cnewcos(rx, cosx, length)
c            height there
      z = cnewh(rx,cosx,length)-Eradius
      sdep = chang2sdep(z, cosz)
      dz = chang2sdep(hx, cosx)  - sdep
      call chdahead(z, cosz, sdep, dz, z2, cosz2)
      sdep2 = chang2sdep(z2, cosz2)
      write(*,*) cosz, cosz2, sdep+dz, sdep2, z, z2
      end
c
c     This gives height and  cos of angle at a point, d kg/m2 ahead
c     of the current point with a given vertical height and to
c     a direction of a given angle.   
c     *************************************************
      subroutine chdahead(h1, cosz1, dz, h2, cosz2)
c     *************************************************
c       real*8 h1. input. present vertival height m.
c       real*8 cosz1. input. present cos of zenith angle.
c       real*8 dz. input. proceed dz kg/m2 from the present pos.
c       
c       real*8 h2. output. vertical heigh at dz a head 
c       real*8 cosz2. output. cos of the zenith angle there.

c
      implicit none
#include  "Zearth.h"
      real*8 h1, cosz1, dz, h2, cosz2, r1, r2

      real*8  sinz1, sinz2
c         get height h2 wiht the same cos angle as cosz1
      if(cosz1 .gt. 0.) then
         d2 = d1 + dz
      else
         d2 = d1 - dz
      endif
      if(d2 .le. 0.) then
         h2 = Maxheight
      else
c               first approximation ; this is alw.r(2)s good
c               so we don't use iteration for getting
c               better answer except for correction of angle.
c              (iteration leads to pooper answer due to ...)
         h2 = csdepang2h(d2, cosz1)
      endif
c\\\\
      write(*,*) ' h2=', h2, ' h1=',h1
c\\\\
c      if(abs(cosz1) .lt. .55) then
         r1 = h1 + Eradius
         sinz1 = sqrt(1.d0 - cosz1**2)
c         imax = 1
c         if(abs(cosz1) .lt. .1d0) imax = 2
c         do i=1, imax   
            r2 = h2 + Eradius
            sinz2 = min(1.d0,  sinz1*r1/r2)
c\\\
            write(*,*) ' sinz2=', sinz2
c\\\\\
c                  correct angle.  
            cosz2 = sqrt(1.d0 - sinz2**2)
c            if(d2 .gt. 0.) then
c               h2 = csdepang2h(d2, cosz2)
c            endif
c
c            sdep2 = chang2sdep(h2, cosz2)
c            write(*,*) cosz1, cosz2, d2, sdep2, h1, h2
c         enddo
c             
c      else
c         cosz2 = cosz1
c      endif
      end
