c     ***********************************************************
c        To know the arrival prob. as a function of direction at a given
c        place.  
c
      subroutine crigCut(azmin, zen, rig, prob)
      implicit none
#include "ZrigCut.h"
c          Before calling this subroutine, you must have called
c       crigCut0 to get the table which contains the information
c       of cutoff rigidities.

c
      real*8 azmin  ! input. value of azimuth angle at a given location.
                   !         deg.
      real*8 zen   ! input. value of zenith angle at a given location. 
                   !     It may be deg, or cos, depending on the table.
      real*8 rig   ! input. value of particle rigidity (GV) p/Z
      real*8 prob  ! output. probability that 'r' can enter the earth.
c
c      Note: This system cannot treat multiple locations at a time.
c
c
      real*8 rigcut

      real*8 logrig, dlogrig, azm

      integer i1, i2, i3
      if(azm .lt. 0.) then
         azm = azm + 360.
      endif
      azm = mod(azmin, 360.d0)
      if(Rdatafmt .eq. 1) then
         call k4ptdi(RigCutTbl, AzmSize, ZenSize, AzmSize, MinAzm, 
     *        MinZen, DAzm,  DZen,  azm, zen, rigcut)
         if(rig .lt. rigcut) then
            prob = 0.
         else
            prob = 1.
         endif
      else
c         i3 = log10(rig/MinRig)/LogDRig + 1
c         i3 <= log10(rig)*20 < i3+1 (i3=0,1..)
         logrig = log10(rig)/LogDRig
         i3 = logrig + 1 
         dlogrig=(logrig - (i3-1))*LogDRig 
         if(i3 .lt. 1) then
            prob = 0.
            goto 100
         endif
         if(i3 .ge. RigSize) then
            prob = 1.
            goto 100
         endif
         i2 =  azm/DAzm + 1
         i2 =min(AzmSize, i2)
         i1 = (zen-1.0)/DZen +1     ! DZen < 0
         i1 = min(ZenSize, i1)
         call cgetRigProb(
     *    RigTbl2, ZenSize, AzmSize, RigSize, i1, i2, i3,
     *    dlogrig, prob ) 
         prob = min(prob, 1.d0)
      endif
 100  continue
      end
      subroutine cgetrigCut(azmin, zen, rigcut)
      implicit none
#include "ZrigCut.h"
c         get rigidity cut (for old table only)
c
      real*8 azmin  ! input. value of azimuth angle at a given location.
                   !         deg.
      real*8 zen   ! input. value of zenith angle at a given location. 
      real*8 rigcut ! output. cutoff rigidity. in GV
c

      real*8 azm

      azm = azmin

      if(azm .lt. 0.) then
         azm = azm + 360.
      endif
      azm = mod(azmin, 360.d0)
      if(Rdatafmt .eq. 1) then
         call k4ptdi(RigCutTbl, AzmSize, ZenSize, AzmSize, MinAzm, 
     *        MinZen, DAzm,  DZen,  azm, zen, rigcut)
      else
         call cerrorMsg(
     *       'only old cutoff table can be used', 0)
      endif
      end

c     *********************
      subroutine cgetRigProb(tbl, 
     * izen, iphi, irig, i1, i2, i3, dlogrig, prob)
      implicit none
#include "ZrigCut.h"

      integer izen, iphi, irig
      real tbl(izen, iphi, irig)
      integer i1, i2, i3
      real*8 prob, dlogrig

      if( i3 .lt. RigSize ) then
       prob = dlogrig/LogDRig * 
     *          (tbl(i1,i2,i3+1)-tbl(i1, i2, i3))
     *         +  tbl(i1,i2,i3)
      else
         prob = tbl(i1,i2,i3)
      endif
      end
c-------------------------        init for crigCut
      subroutine crigCut0(file)
      implicit none
#include "Zmanagerp.h"
#include "ZrigCut.h"

      character*(*) file
      character*192 msg
      integer icon

      call copenf(TempDev, file, icon)
      if(icon .ne. 0) then
         write(msg, *) ' file specification error '
         call cerrorMsg(msg, 0)
      endif
c
      read(TempDev, '(1x,i1)') Rdatafmt   ! format 1 or 2 or 3
      if(Rdatafmt .eq. 1) then
         call crigCutfmt1
      elseif(Rdatafmt .eq. 2 .or. Rdatafmt .eq. 3) then
         call crigCutfmt2
      else
         write(msg, *) 'rigidity cut data format =',Rdatafmt,
     *   ' ivalid' 
         call cerrorMsg(msg, 0)
      endif
      end
c     **********************
      subroutine crigCutfmt1
      implicit none
#include "Zmanagerp.h"
#include "ZrigCut.h"


      character*192 msg

      integer icon

      read(TempDev, *)   ! skip
      read(TempDev, *) Place,  Latit,  Longi, MagDec,  AzmValue,
     *            DAzm, AzmSize, ZenValue, DZen, ZenSize

c           skip until -------------- line
      call cskipComment(TempDev, icon)
      if(icon .ne. 0) then
          call cerrorMsg('cut-off table data has no ---- line', 0)
      endif
c          see if azimuthal angle range is from 0 to 360 or from 0 to 360-DAzm

      if(AzmValue .eq. 'deg') then
c               assume min of Azimuthal angle is  0 deg.
          MinAzm = 0.
          if( (AzmSize - 1)* DAzm  .lt. (360.d0- DAzm* 0.1d0) ) then
c                 fill the last col.  by the first col.

             call creadRigCut(TempDev, RigCutTbl, AzmSize, ZenSize, 
     *       AzmSize+1)
             AzmSize = AzmSize + 1
             call cfillRigCut(RigCutTbl, AzmSize, ZenSize)
          else
             call creadRigCut(TempDev, RigCutTbl, AzmSize, ZenSize,
     *        AzmSize)
          endif

       else

          write(msg, *)
     *    ' Azimuthal angle unit must be deg for rigidity cut table'
          call cerrorMsg(msg, 1)
          write(msg, *) ' But it is ', AzmValue
          call cerrorMsg(msg, 0)
       endif

       close(TempDev)

       if(ZenValue .eq. 'cos') then
c              DZen should be negative and min is 1.0
          MinZen = 1.0
          if(DZen .ge. 0.) then
             write(msg, *)
     *        ' step of Zenith angle for rigidity cut should be < 0'
             call cerrorMsg(msg, 1)
             write(msg, *) ' because you give it in cos value'
             call cerrorMsg(msg, 0)
          endif
       endif
c
c                                   
       write(msg,*) 'Rigidity cut-off table has been read:',
     * ' place=',Place,' latitute=',Latit, ' longitude=',Longi,
     * ' mag. dec=', MagDec
       call cerrorMsg(msg, 1)
       end
c      ****************** 
       subroutine creadRigCut(io, tbl,  azm, zen, adj)
       implicit none
       integer io,  azm, zen, adj
       real*8 tbl(adj,  zen)


       integer i, j, ios
       character*100 msg

       do   j=1,  zen
           read(io,'(13f6.2)', iostat=ios) ( tbl(i, j), i = 1, azm)
           if(ios .ne. 0) then
              write(msg, *) 'Unexpected EOF at rigicity table reading'
              call cerrorMsg(msg, 1)
              write(msg, *) ' line number=', j, ' azm=',azm, ' zen=',
     *          zen, ' adj=',adj
              call cerrorMsg(msg, 0)
           endif
       enddo
       end
c      *******************
       subroutine cfillRigCut( tbl,  azm, zen)
       implicit none
       integer  azm, zen
       real*8 tbl(azm,  zen)
       integer i

        do i = 1, zen
            tbl(azm, i) = tbl(1, i)
        enddo
       end
c      ********************************** 
       subroutine cqRigCutPlace(tlt, tlg, mdec)
       implicit none
#include "ZrigCut.h"
       real*8 tlt, tlg, mdec


c            to inform lat, long, magdec
        tlt = Latit
        tlg = Longi
        mdec = MagDec
       end

c     **********************
      subroutine crigCutfmt2
      implicit none
#include "Zmanagerp.h"
#include "ZrigCut.h"

      character*192 msg

      integer icon

      real pw

      read(TempDev, *)   ! skip
      read(TempDev, *) 
     *  Place,  Latit,  Longi, MagDec, ZenValue, ZenMax, DZen, ZenSize,
     *  AzmValue, MinAzm, DAzm, AzmSize,MinRig, pw, LogDRig, RigSize

      MinRig = MinRig ** pw
      DRig = 10.** LogDRig

c           skip until -------------- line
      call cskipComment(TempDev, icon)
      if(icon .ne. 0) then
          call cerrorMsg('cut-off table data has no ---- line', 0)
      endif
      call crdRigCut2(
     *       Rdatafmt, TempDev, RigTbl2, ZenSize, AzmSize, RigSize)
      close(TempDev)

      if(ZenValue .eq. 'cos') then
c           DZen should be negative
         if(DZen .ge. 0.) then
            write(msg, *)
     *        ' step of Zenith angle for rigidity cut should be < 0'
            call cerrorMsg(msg, 1)
            write(msg, *) ' because you give it in cos value'
            call cerrorMsg(msg, 0)
         endif
      endif
c
c                                   
       write(msg,*) 'New rigidity cut-off table has been read:',
     * ' place=',Place,' latitute=',Latit, ' longitude=',Longi,
     * ' mag. dec=', MagDec
       call cerrorMsg(msg, 1)
      end
      subroutine crdRigCut2(fmt, io, tbl, izen,  iphi, irig)
c       read cut off table for format 2
      implicit none
      integer fmt ! input.  fmt=2 or 3, if  3, data for izen, iphi, irig are
                  !          not given
      integer io  ! input. table dev. number
      integer izen ! input. table for zenith angle
      integer iphi ! input. table for azimuthal angle
      integer irig ! input. table for rigidity
      real*4  tbl(izen, iphi, irig)  ! output. 3D table which shows prob. that
                          ! given ptcl with izen, iphi, irig can enter the earth
                  !  NOTE:  this  is  real*4--------------------

      integer i1, i2, i3
      integer j1, j2, j3
      character*128 msg


      do i1= 1 , izen
         do i2 = 1, iphi
            do i3 = 1, irig
               if(fmt .eq. 2) then
                  read(io, *, end=100) j1, j2, j3, tbl(i1, i2, i3)
                  if(i1 .ne. j1+1 .or.
     *               i2 .ne. j2+1 .or.
     *                       i3 .ne. j3+1) then 
                     write(msg, *)
     *               ' data index mismatch in new rigidit cut table',
     *                 i1, j1+1, i2, j2+1, i2, j3+1      
                     call cerrorMsg(msg, 0)
                  endif
               else
                  read(io, *) tbl(i1, i2, i3)
               endif
            enddo
         enddo
      enddo
      return
 100  continue
      call cerrorMsg(
     *   'Unexpected EOF in new rigidity cut table',0)
      end



