cc           test cheavyInt.f
          implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"
#include  "Zevhnp.h"
#include  "Zheavyp.h"

          integer nmax
          parameter (nmax =1500)   ! # of max ptcls supposed to be generated
          record /ptcl/ pj, a(nmax), tg, cmsptcl, ppj
c
          integer k,  ntp, j, nevent, hvyg, icon
          real*8 x, y, eta, u
          real*8  energy
          real pt
          character*90  msg
c          integer l
c
          record /fmom/ rest
 
          rest.p(1) = 0.
          rest.p(2) = 0.
          rest.p(3) = 0.
          rest.p(4) = 0.

          
          msg = 'A-Air collisions; csm is that for p-p col. (Ep= E/A)'
          call cerrorMsg(msg, 1)
          msg =
     *    ' Enter 1) # of events, 2) Energy/nucleon(GeV)'
     *     //', 3) incident heavy group (2-7=alfa,L,CNO,H,VH,Fe)'
          call cerrorMsg(msg, 1)
          read(*, *) nevent, energy, hvyg
c
          write(*, *)
     *    '# A-Air collisons. E/nucleon(GeV)=', energy

          write(*, *)
     *    '# events=', nevent,' Incident=', HeavyG2symbol(hvyg)

          write(*, *) '# x, y, eta, pt, code, charge, multi'
c
cc             make incident heavy; charge is positive; set true one inside
          call cmkptc(HeavyG2code(hvyg), regptcl, 1,   pj)
c                make proton incident 
          call cmkptc(knuc, regptcl, 1, ppj)
cc      
c             make nuclon target (not for collision)
          call cmkptc(knuc, regptcl, 1, tg)
          tg.fm = rest
          tg.fm.p(4) = tg.mass


          pj.fm.p(1) =0.
          pj.fm.p(2) =0.
          pj.fm.p(4) = energy*HeavyG2massN(hvyg)
          pj.fm.p(3) = sqrt(pj.fm.p(4)**2-pj.mass**2)
c            proton
          call cmkptc(knuc, regptcl, 1, ppj)
          ppj.fm.p(1) = 0.
          ppj.fm.p(2) = 0.
          ppj.fm.p(4) = energy
          ppj.fm.p(3) = sqrt(ppj.fm.p(4)**2-ppj.mass**2)
c              form cms; this is for comparison with pp data
          call cgeqm(ppj, tg, cmsptcl, icon)
c
          call rndc(u)
          do k=1, nevent
             call cheavyInt(pj, 14, 7, a, ntp)
             do j=1, ntp
                x = a(j).fm.p(4) / ppj.fm.p(4)

c                      boost to cms                
                call cbst1(j, cmsptcl,  a(j), a(j))
                call cyeta(a(j), y, eta)
                pt = sqrt(a(j).fm.p(1)**2 + a(j).fm.p(2)**2)
                write(*, *) sngl(x), sngl(y), sngl(eta), sngl(pt), 
     *          a(j).code, a(j).charge,  ntp
             enddo
          enddo   
        end
c               dummy routine
        subroutine chALund(pj, ia, iz, z, ntp)
#include "Zptcl.h"
#include "Zevhnp.h"
        write(*, *) ' this test should not come here: chAlund'
        stop 9999
        end
#include "BlockData/cblkHeavy.h"
