cc                testing cbhabhaPath etc.
c      implicit none
c      real*8  epos, eele
c      real*8 ee, w, path, cose, cosp
c      integer i
c      read(*, *) ee, w
c      do i = 1, 10000
c         call cbhabhaPath(ee, w, path)
c         call cbhabhaEnergy(ee, epos, eele)
c         call cbhabhaAngle(cose, cosp)
c         write(*, *) sngl(path), sngl(epos), sngl(eele),
c     *               sngl(cose), sngl(cosp), sngl(epos+eele)
c      enddo
c      end
c     ****************************************************************
c     *
c     * cbhabhaPath: samples bhabha scattering path in r.l
c     * cbhabhaEnergy: //      energy of survival and recoil electrons
c     * bhabha: //      angle of survival and recoil electrons
c     *
c     ************************ tested 87.02.13 ***********************
c
c   /usage/  call cbhabhaPath(ee, w, path)
c
c   --input--
c   ee:  positron energy in GeV
c    w: minimum kinetic energy of recoil position to be treated.
c       (around .25e-3 gev).
c
c   -- output --
c path: sampled path in r.l
c   e1: recoil electron   energy  in GeV
c   epos: survaival positron energy in Gev
c
c coselec: cos  of recoil electron angle
c cosposi: cos of survaival positron angle
c
c  **** note ***
c            before calling cbhabhaEnergy, cbhabhaPath must be called and
c            befroe calling cbhabhaAngle, cbhabhaEnergy must be called.
c
c            constm=.03*z/a*x0inkgpm2
c
c
       subroutine cbhabhaPath(ee, w, path)
       implicit none
c     
c
        real*8 ee, epos, e1, path, w
        real*8  epi, cosposi, coselec,  cos12
c
c            equivalenced to common
        real*8 tp, ep, g, beta2, t0, em, t0n, y, tm1, 
     *         tm2, tm3, tm4, csc, u, t1, ts, eps, e2,
     *         tmp, ge
        real*8 constm/5.475/

        real*8 emass/0.511e-3/
c
        save epi, em, t0, t1, beta2, tm1, tm3, tm4
c
        real*8 gef
        gef(ep)=(1.-em)/beta2 * (1. - beta2*( ((-tm4*ep+tm3)*ep
     *  -tm2)*ep+tm1)*ep)
c


c
       g=emass/ee
       beta2=1. - g**2
       t0=ee-emass
       if(t0 .le. w) then
           tp=0.
           path=1.e50
       else
           em= w/t0
           t0n=t0/emass
           y=1./(t0n+2.)
           tm1=2.-y**2
           tm2= ((-2.*y+1.)*y-6.)*y+3.
           tm3= ((-8.*y+16.)*y-10.)*y+2.
           tm4= (1.-2*y)**3
           csc= -1. -beta2* (-tm2+tm3/2-tm4/3.) +1./em +beta2*
     *     (   ((-tm4/3.*em +tm3/2)*em-tm2)*em+tm1*log(em) )
           tp=csc/beta2/t0n *constm
           call rndc(u)
           path=-log(u) / tp
       endif
       return
c
c      ************
       entry cbhabhaEnergy(ee, epos, e1)
c      ************
c                   rejection method
c       *** until loop*** 
       do while (.true.)
            call rndc(u)
            ep=1./ (  1. - (1.-1./em)*u )
            ge=gef(ep)
            call rndc(u)
            u=u*gef(em)
            if ( u .lt. ge)  goto 100
       enddo
  100  continue
       t1=ep*t0
       e1=t1 + emass
       epos=ee-e1+emass
       if(epos .lt. emass) then
c               happen very rarely  due to energy loss.  force to
c           give energy for consistency.
           epos = emass *1.000001
       endif
c        
       epi=epos
       return
c
c      ************
       entry cbhabhaAngle(cosposi, coselec)
c      ************
c
       ts=epi-emass
       e2=emass*2
       eps=t0-ts
       if(eps/(t0+e2) .lt. 0.05) then
           cosposi=1.d0 - eps*emass/(t0*(t0+e2))
       else
           cos12=ts*(t0+e2)/( t0*(ts+e2))
           if(cos12 .lt. 0.) then
c             this is due to the change of energy by de/dx.  it may die
c             soon.
              cosposi=0.
           else
               cosposi=sqrt(cos12)
           endif
       endif
c
       tmp =t1*(t0+e2)/(t0*(t1+e2))
       if(tmp .lt. 0.) then
           coselec=0.
       else
           coselec=sqrt(tmp)
       endif
       end
