c       ****************************************************************
c       *
c       * csNeumuEMu:  sample energy of muon neutrino from mu decay
c       *
c       **************************tested 88.07.26***************k.k*****
c
c /usage/      call csNeumuEMu(f)
c   f: output. real*8.  sampled fractional energy.  f is the
c                       fraction  given by f=2*e'/m  where e' is the
c                       energy in muon rest system and m the muon mass.
c          The angle integrated energy distribution is 
c         f^2 (3-2f)df =(2f^2(1-f) + f^2)df
c                         1:           2

        subroutine csNeumuEMu(f)
          implicit none
          real*8 f
          real*8 u, u1, u2, u3
          call rndc(u)
          if(u .lt. 0.333333) then
c                 first term
             call csampNeueEMu(f)
          else
c                 second term. take max of 3 u's.
             call rndc(u1)
             call rndc(u2)
             call rndc(u3)
             f= max(u1, u2, u3)
          endif
       end

