c           Parameters used for Tracking.
c	(->	--------------------------------------------

	logical  ExactThick   !2  If T, a given length is converted into thickness with best accuracy even for very 
                              !  inclined trajectory by using numerical integration.
        logical IncMuonPolari  !1  if T, consider muon polarization
        logical Freec          !1  if F, the first interaction point is made to be the injection point else randomly
                               !    sampled.
	integer OneDim	       !1  If 0, 3 dimensional simulation. if >=1, one
                               !  dimensional simulation is performed.  For flux calculation, sometimes one 
                               !  dimensional one is better. 
                               !  1: onedim without use of table.
                               !  2: table is used for thickness <--> length conversion. if cos < .5
                               !  3: table is always used for any angle.
                               !  ( for height > 30 km, table is not used in any case). 
	real*8  Truncc         !2 coeff. for truncating path.
	real*8  Truncn         !2 coeff. for truncating path.
	real*8  Truncx         !2 coeff. for truncating path.
	real*8  KEminObs       !1  The min kinetic energy of particles for observation.
	real*8  KEminObs2      !2  Don't touch this. skeleton/flesh use.
	real*8  RatioToE0      !2 In the A.S generation,  hadronic interactions are followed down to at
                               !  least  RatioToE0 * E0/nucleon energy.
        real*8  WaitRatio      !1  Wait A.S generation until the electron energy, Ee, becomes  < WaitRatio* E0. 
                               !   This many be 1.0 for hadron origin case. But for gamma/electron primary, 
                               !   this should be as low as 0.01 to enjoy full fluctuation.
        integer EndLevel !2 Used for skeleton/flesh-out job. In a normal job, system default value 0 is reset by
            ! the system to be the max number of observation levels. (=NoOfSites).  Its real use is in such a
            ! skeleton/flesh-out job that one first follows the particles up to some high depth and later chooses
            ! events and flesh them out to deeper depths. In such a skeleton-making job, the user must give the
            ! depth list which is used flesh-out job, too.  In the skeleton job, particle tracking is terminated
            ! at the level specified by EndLevel.  In such a flesh-out job, the user must give a larger value 
            ! or 0 to EndLevel 
        integer EndLevel2 !2  Don't worry. This  is system use.
	integer Trace   !1  Flag for trace information output.
            !   0 ==> no trace information is output.
            !  <10==> x, y, z in the primary system(say, 1)
            !  <20 ==> x, y, in the primary sys. z in kg/m2.(say,11)
            !  <30 ==> x, y, z in the detector system
            !  <40 ==> x, y, in the detector system. z in kg/m2 
            !  <50 ==> x, y, z in 'xyz' system.
            !  <60 ==> x,y, in 'xyz' and z in kg/m2
            !  61-100 ==>  for Cherenkov observation. For Coord system,  subtract 60.
            !   if the value is even,  binary output is made on TraceDev.
            !  > 101  ==> subtract 100 and apply the above, but chookTrace or chookCeren["",S,E] are used.
            !  Primary system:  Origin is the deepest detector.  Z-axis is the primary direction. 
            !                   X-axis is Z x Vertical axis.  X-Y plane is orthogonal to the primary.
            !  Detector system: origin is the deepest detector. Z-axis is the vertical one.  X-axis is 
            !                   directed to the magnetic east.  X-Y plane is horizontal.
            !  z in kg/m2 :     Vertical depth in kg/m2  above the  deepest detector to the particle.
	integer TraceDev      !2  Logical dev # for TraceDir/trace1,2,.... 
        character*70  TraceDir !1 Directory.  Default Trace information is put TraceDir/trace1, 2,..
                               ! for event 1, 2, ... The directory should exist.  Default is ' ' and in this case
                               ! /tmp/YourLoginName/ is employed. The last "/" should not be given.
                               ! *** NOTE that default Cherenkov output is made only using TraceDev,
                               !    TraceDir is not used.  You have to open the disk file at chookbgRun
                               !    It can by binary or ascii file depending on Trace value.
	logical ThinSampling  !1  if F, thinsampling is not tried. if T, alla Hillas thinning. Don't use with
                              !    the  skeleton/flesh method 
        real*8  EthinRatio    !2  if ThinsSamplig != 0, thin sampling is performed if the energy of a particle is
                              !   < EthinRatio * PrimaryEnergy(/nucleon) (=Ethin)
        logical TimeStructure !1  If T,  time information is computed
	integer HowGeomag     !2  if 1, no magnetic field until first coll.
                              !      2, mag.f always exists. If Reverse not=0, use this.
                              !     11, same as 1 but mag.f is const.
                              !     12, same as 2 but mag.f is const.
                              !     21, same as 1 but mag.f is const.
                              !     22, same as 2 but mag.f is const. 
                              !  const value is the one at deepest observation plane. for 11,12  or should be given by
                              !  MagN, MagE, MagD for 21, 22. For normal applications,  11 is good.
        real*8  MagN          !2 See HowGeomag (in Tesla)
	real*8  MagE          !2 See HowGeomag (in Tesla)
        real*8  MagD          !2 See HowGeomag (in Tesla)

        real*8  MagChgDist    !2 Distance where mag. can be seen  as const.(m) at sea level
	real*8  BorderHeightH !2 If a particle goes higher than this, discard it.  This should be larger than HeightOfInj or 0.  
                              !  If 0, it is adjusted to be the same as HeightOfInj. NOTE: For upgoin primary cases, you have
                              !  to set this one explicitly. 
	real*8  BorderHeightL !2 If a particle reaches this hight, call observation routine. No further tracking is done. 
                              !  This is for neutrino observation.  See ObsPlane.
        real*8  BackAngLimit  !2 If the cosine of the angle between a particle and the primary becomes smaller than
                              !  this value, the particle is discarded. See also BorderHeighH. If you give a value 
                              !  less than -1.0, such rejection will never happen.   Default is 0.
	character*16 Generate !1 specify the system should generate 1)  EM-cascade(em), 2) one dimensional AS(as/qas) 
                              ! and/or AS Lateral distribution(lat). Generate='em,as' or 'em/as' etc (order/case/separator
                              !  insensitive) is to  generate EM-cascade and AS. Generate='as' will  generate AS with some 
                              ! adequate EM cascade (i.e.,the  EM cascade is not followed down to KEminObs).
                              ! If 'qas' is given, quick generation of AS for heavy primaries is tried. See  chookASbyH.f 

        character*16 Generate2 !2  don't touch this.  for skeleton/flesh use.

	integer MagBrem       !2 If 0, no magnetic bremsstrahlung is considered.
                              ! if 1 and Ee > MagBremEmin, energy loss due to magnetic brems is considered
                              ! if 2 and Ee > MagBremEmin, real sampling of gamma is performed.
                              ! (note, actually upsilon is referred further).
                              ! if generate='as' with really high energy primaries, WaitRatio
                              ! must be made small so that WaitRatio*E0 ~MagBremEmin 
        integer MagPair       !2 If 0, no magnetic pair creation is considered.
                              !  if 1 and Eg > MagPairEmin, real sampling is tried.
                              ! (note, actually upsilon is referred further).  To see these magnetic effects,
                              !  HowGeoMag=2 and HightOfInj ~ 5000 km are desirable.

        logical LpmEffect     !1 If t, the LPM effect is  considered when Ee > LpmBremEmin for electrons and
                              !        Eg > LpmPairEmin for gamma rays.

        real*8  MagBremEmin   !2  E > this, magnetic bremsstrahlung by electrons may be considered. However, if
                              !   MagBrem = 0, not considered at all
                              !   MagBrem = 1, total energy loss due to brems is considered.
                              !   MagBrem = 2, gamma energy is sampled actually.
                              !   If upsilon (Ee/m * B/Bcr) is small, the effective treatment will be
                              !   the same as MagBrem = 0 case.
        real*8  MagPairEmin   !2  E > this, magnetic pair creation by gamma may be considered. However, if
                              !   MagPair = 0, not considered at all.
                              !   MagPair = 1, pair creation is sampled. 
                              !   However, again, actual occurrence will be dependent on the angle between
                              !   B and photon direction.
        real*8  UpsilonMin    !2  Magnetic bremsstralhung is considered only if upsilon > UpsilonMin.
        real*8  LpmBremEmin   !2  The LPM effect is taken into account for bremsstrahlung when LpmEffect is .true. 
                              !   and the electron energy is higher than this.
        real*8  LpmPairEmin   !2  The LPM effect is taken into account for pair creation when LpmEffect is .true.
                              !    and the gamma energy is higher than this.
        integer Reverse       !2  0=> Normal tracking.
                              !   1=> incident is tracked to a direction opposite to the given one.
                              !       the incident is charge-conjugated.
                              !       All interactions are ignored. (Use when to make cut-off table or to see
                              !       a given particle (say, observed anti proton) can go out of Earth.
                              !   2=> same as 1 but energy gain (not loss) is taken into account
                              !   TimeStructure should be T if Reverse != 0.  See BackAnglLimit.

        real*8 PathLimit      !2  If the sum of (path/beta) of a particle  exceeds this, it is judged as dead.
                              !   (to avoid infinite cyclotron loop).  However, for normal applications,
                              !   this will not be effective because of BackAnglLimit. See Reverse.
                              !   TimeStructure should be T if Reverse != 0 and PathLimit is to be effective.

       integer MuNI           !2 0--> nuclear interaction of muon is completely neglected
                              !  1--> energy loss by n.i is subsumed in dE/dx of muons as a continuous energy loss.  Let v=
                              !     E_transfer/Emu,  the loss here is Int(vc:vmax) of (Emu vdsigma/dv).  (vc ~0, vmax~1).
                              !  2--> (Default value). similar to 1 but as the continuous loss only v < vmin=10^-3 of the
                              !     fractional muon energy is subsumed (Int(vc: vmin) of (Emu vdsigma/dv)).  The portion
                              !     of loss by v>vmin is treated as a stocastic  process.  However, the product from the
                              !     n.i itself is neglected 
                              !  3--> the same as 2, but the n.i is explicitly included to produce a number of particles.  
                              !     The n.i is treated as a photo-nucleus interaction.

       integer MuBr           !2  parameter similar to MuNI but for bremsstrahlung by muons.
       integer MuPr           !2  parameter similar to MuNI but for pair creation by muons.

c	 <-)	----------------------------------------------

	common /cZtracp/ Truncc, Truncn, Truncx, 
     *  KEminObs, KEminObs2, RatioToE0, PathLimit,
     *  WaitRatio,  EthinRatio, BackAngLimit,
     *  BorderHeightH,  MagN, MagE, MagD, MagChgDist,
     *  BorderHeightL,  MuNI, MuBr, MuPr,
     *  MagBremEmin, MagPairEmin, UpsilonMin, LpmBremEmin, 
     *  LpmPairEmin,
     *  ThinSampling, TimeStructure, HowGeomag, 
     *  Trace, TraceDev,  ExactThick, OneDim, Reverse,
     *  Freec,  IncMuonPolari, MagBrem, MagPair, LpmEffect,
     *  EndLevel, EndLevel2
 
        common /cZtrackpc/ Generate, Generate2, TraceDir
