c        This makes tables needed to compute geometrical
c      relations in the atmospher.
c        
c       compute the ratio of excat one/ approx one for the
c    vertical heigth of a point where
c    the slant depth to a given zenith angle direction is
c    known.  h = h(cost, sdep)
c    
c   This one is for log10 scale sdepth from 10**-9 to sdepth at 30 km level.

c  To compile this program, use: make tbl2
c
c------------------------------------------------------------
c
      program atmostbl2
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include 'Zearth.h'
#include  "Zearth.h"

      real*8 cosz
      common /catmosc/ cosz

      real*8  ans, cfunc, sdepmin, sdepmax, sdep,
     * chang2sdep,  zap, depstep, sdepx
      real*8 caheight, sdepmint, sdepmaxt, ratio
      real*8 sqcos, dsqcos, oldratio, h1, h2, pow
      integer icos, ndiv
      external cfunc

c     **************************for sdep2htbl1.d
c              height itself should be used
c      pow = .50d0
c      h1 =  Minheight
c      h2 =  26.d3
c      ndiv = 17
c      depstep = .01d0
c     **************************for sdep2htbl2.d
c      pow = .25d0
c      h1 =  4.d3
c      h2 =  50.d3
c      ndiv = 15
c      depstep = .01d0
c     **************************for sdep2htbl3.d
c      pow = .50d0
c      h1 =  29.d3
c      h2 = 100.d3
c      ndiv = 15
c      depstep = .02d0
c     **************************for sdep2htbl4.d
      pow = .50d0
      h1 =  75.d3
      h2 = Maxheight
      ndiv = 11
      depstep = .1d0
c     *****************************
      sdepmaxt =log10(chang2sdep(h1, 0.d0) )
      sdepmint =log10(chang2sdep(h2,  .6d0) )
      write(0,*) "#  sdepmint=", sdepmint, " maxt =", sdepmaxt
      write(*, *) "# h1=", h1, " h2=",h2, " power=", pow, 
     *             " ndiv=",ndiv
      write(*,*) "# cos  cos**pow  log10(slantdep/kg/m2)    ratio"
      write(*, *) "#-------------------------------------------"
      sqcos = 0.
      dsqcos = (.5999999999999d0)**pow/(ndiv-1)
      do icos = 1, ndiv
         cosz = sqcos**(1.d0/pow)
         sdepmax = log10(chang2sdep(h1, cosz))
         sdepmin = log10(chang2sdep(h2, cosz))
         write(0,*) "#  sdepmin=", sdepmin, " max =", sdepmax

         oldratio = 0.
         do sdep = sdepmint, sdepmaxt+1.d-5, depstep
            if(sdep .lt. sdepmin) then
               ans = h2
               sdepx = 10.d0**sdepmin
               zap = caheight(sdepx, cosz)  !  approx one
!               call cbichop(cfunc, zap, sdepx, ans)  ! exact one
               ratio = ans/zap
            elseif(sdep .gt. sdepmax) then
               ans = h1
               ratio = oldratio
            else
               sdepx = 10.d0**sdep
               zap = caheight(sdepx, cosz)  !  approx one
               call cbichop(cfunc, zap, sdepx, ans)  ! exact one
               ratio = ans/zap
               oldratio = ratio
            endif
            write(*, *) sngl(cosz), sngl(sqcos),  sngl(sdep), 
     *          ratio, ans
         enddo
         sqcos = sqcos + dsqcos
         write(*, *)
      enddo
      end
c     ******************************************
      subroutine cbichop(func,  zap, sdep, ans)
c     ******************************************
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
      real*8 func, zap, ans, sdep

      real*8 sdepa, sdepb, za, zb, z, sdepx
      logical ok

      za = zap
      sdepa = func(za)
c      write(*,*) ' za = ' , za, ' sdepa=', sdepa
      if(sdepa .gt. sdep) then
         zb = min(zap + max(100., abs(zap))*.2, Maxheight)
         sdepb = func(zb)
         do while(sdepb .gt. sdep)
            zb = min(zb  + max(100., abs(zap))*.2, Maxheight)
            sdepb = func(zb)
c            write(*, *) ' zb=', zb, 'sdepb=', sdepb
         enddo
      else
         zb = zap
         sdepb = sdepa
         za =max( zap - abs(zap)*.2, Minheight)
         sdepa = func(za)
         do while(sdepa .lt. sdep)
            za = max( za -max(abs(za),100.)*.2, Minheight)
            sdepa = func(za)
c            write(*, *) 'za=', za, 'sdepa=', sdepa
         enddo
      endif

      ok = .false.
      do while (.not. ok)
         z = (za + zb)/2
         sdepx = func(z)
         ok = abs(sdepx -sdep)/sdep .le. 1.d-9
         if(sdepx .gt. sdep) then
            za = z
         else
            zb = z
         endif
      enddo
      ans = z
      end
      real*8 function cfunc(z)
      implicit none
      real*8 z
      real*8 chang2sdep
      real*8   cosz
      common /catmosc/ cosz
      cfunc = chang2sdep(z, cosz)
      end
