      subroutine cghe2cos(ghecode, code, subcode, charge)
      implicit none
c         convert gheisha particle code into cosmos codes 
c  **  actually, the input code is Giant code. **
c     Giant code is first converted to gheisha code, and
c     it is converted to cosmos code.

      integer ghecode ! input.  gheisha particle code
      integer code    ! output. cosmos ptcl code
      integer subcode ! output. cosmos ptcl subcode
      integer charge  ! output. cosmos ptcl charge
#include "Zcode.h"

c
c      for particls to be neglected in cosmos, code will be  0
c     (Omega, tau lepton, DS) no neutrionos are expected  come
c      out from ghesha.
c
      integer ghe2cosCode(48), ghe2cosSubC(48), ghe2cosChg(48)

      character*80 msg

c

      	data ghe2cosCode/
     * kphoton, kelec, kelec, krare, kmuon, kmuon, kpion,
     * kpion, kpion, kkaon, kkaon, kkaon, knuc, knuc,
     * knuc, kkaon, keta, klambda, ksigma, ksigma,
     * ksigma, kgzai, kgzai, krare, knuc, klambda,
     * ksigma, ksigma, ksigma, kgzai, kgzai, krare, krare,
     * krare, kdmes, kdmes, kdmes, kdmes, krare, krare, 
     * klambdac,
     * krare, krare, krare, kdeut, ktriton, kalfa, krare/

       	data ghe2cosSubC/
     * 0, antip, regptcl, krare, 0, 0, 0, 0, 0, k0l, 0,
     * 0, regptcl, regptcl, antip, k0s, 0, regptcl, 
     * regptcl, regptcl, regptcl, regptcl, regptcl,
     * krare, antip, antip, antip, antip, antip, antip,
     * antip, krare, krare, krare, 0, 0, regptcl, antip, 
     * krare, 
     * krare, regptcl, krare, krare, krare, 0, 0, 0, krare/

	data ghe2cosChg/
     * 0, 1, -1, 0, 1, -1, 0, 1, -1, 0, 1, -1, 0, 1, -1, 
     * 0, 0, 0, 1, 0, -1, 0, -1, -1, 0, 0, -1, 0, 1, 0, 
     * 1, 1, 1, -1, 1, -1, 0, 0, 1, -1, 1, 1, -1, 0, 1, 
     * 1, 2, 0/


       if(ghecode .ge. 1 .and. ghecode .le. 48) then
          code = ghe2cosCode(ghecode)
          subcode = ghe2cosSubC(ghecode)
          charge = ghe2cosChg(ghecode)
       elseif(ghecode .eq. 200) then
c            psudo ptcl by Gheisha, I don't know this. neglect
          code = krare
       else
          write(msg, *)'ghesha (giant) code=', ghecode, 'invalid'
          call cerrorMsg(msg, 0)
       endif
       end




