c#include "cblkdedx.h"
c      implicit none
c      real*8 etemp, amass, dedt, e
c      integer i
c
c      amass=    105.659e-3
c      amass=    938.659e-3
c      amass = 500.e-3
c      do  i=1, 200
c         e=      1.e-6* 10.**((i-1)/20.0)
c         etemp=e+amass
c         call cdedx2atLE(etemp,   amass, dedt)
c         write(*, *) sngl(e), sngl(dedt)
c      enddo
c      end
c     ****************************************************************
c     *                                                              *
c     * cdedx2atLE: gives -de/dx  (gev/(g/cm2)) of non electrons          *
c     *         this gives dedx at all energy region but
c     *         with constant air density
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call cdedx2atLE(e,amass, dedt)

c -- input--
c        e: total energy of ptcl     in GeV
c    amass: mass in GeV
c -- output --
c     dedt; energy loss / (g/cm2) in gev unit.
c
c
c
c
      subroutine cdedx2atLE(eini, amassi, dedt)
       implicit none
c
c
#include  "ZdedxAir.h"

c
      real*8 eini, amassi, dedt
c
      real*8  ek,  peak2, peak2e
c
      ek=eini-amassi
      if(ek .lt. 1.e-3) then    ! < 1MeV
         peak2e = 1.4e-6* (amassi/100.e-3)**1.6
         if(ek .lt. peak2e ) then
            if(ek .gt. 0.) then
               peak2 = 0.6*(ek/1.5e-5)**(-0.15)
               dedt=peak2*sqrt(ek/peak2e)
            else
               dedt = 0.
            endif
         else
            call cdedx2atLEa(eini, amassi, dedt)
         endif
      else
         call cdedx2atLEa(eini, amassi, dedt)
      endif
      end
c
      subroutine cdedx2atLEa(eini, amassi, dedt)
       implicit none
c
c
#include  "ZdedxAir.h"

c
      real*8 eini, amassi, dedt

      real*8 emass, emass2
      parameter(emass=.511, emass2=emass**2)
      real*8  e, amass, ein, gi, Beta2, x, a, b, c, cb, x0
      real*8 dltx, p2, wm, wlg,  x1
c
           ein=eini
c
c                  energy in mev unit
          e=ein*1000.
          amass=amassi*1000.
          gi=amass/e
          if(gi .ge. 1.) then
              dedt=.01
          else
            Beta2= 1. - gi**2
c                x=log10(p/mc)
            x=log10((e/amass)**2 - 1.) / 2
            a=stha
            b=sthb
            c=sthc
            cb=-c
            x0=sthx0
            x1=sthx1
            if(x .lt. x0) then
c                  4.605x - dlt
                dltx=4.605*x
            elseif(x .lt. x1) then
                dltx=cb - (x1-x)**3 * sthsa
            else
                dltx=cb
            endif
            p2=e**2 -amass**2
            wm=2*emass*p2/( amass**2+ emass2+ emass*e*2)
            wlg=log(wm)
            dedt=a/Beta2 *( b+.693+wlg -2*Beta2 + dltx)
        endif
        dedt=dedt *1.e-3
       end




