c	real*8 x, y
c	real*8 gupsilon
c	x = 0.001
c	do while (x .lt. 500.) 
c	    y = gupsilon(x)
c	    write(*, *) sngl(x), sngl(y)
c	    x = x * 10.**0.1
c        enddo	
c	end
c    ******************************************************************
c         g(upsilon) for total energy loss function of synchrotron
c    ******************************************************************
c
	real*8 function cgUpsilon(u)
	implicit none
	real*8 u  ! input. upsilon

	real*8 z

	if(u .lt. 0.005) then
		cgUpsilon = u ** 2 * (1. -5.953*u)
	elseif(u .lt. 100.) then
c                 polynomial approx. within 5 % error. roughly
		z = log(u)
                cgUpsilon = 
     *          exp(((((-0.6305280E-04 * z -0.1159820E-03)*z 
     *           +0.9467500E-02 )*z-0.6861282E-01)*z  +1.080512)*z
     *           -1.770289)       
	else
	      cgUpsilon = 0.5563*u**0.66666666
	endif	
	end



