c                parameters for primary angle sampling
c	(->	---------------------------------------------------

           complex*16  CosZenith   !1  Range of cos(zenith angle). Say, (0.5, 1.0). Used when Za2ry is 'is' 
           complex*16  Azimuth     !1  Range of azimuthal angle in deg. Say, (0, 45). Defaulti is (0,360).
                                   !   Used when Za1ry is 'is'
           character*4 Za1ry       !1  Specify the primary angle sampling method by one of 'is', 'ps' or 'aps'.
                        !   "is" is isotropic. The range is by CosZenith.
                        !   "ps" is for point source (See also SourceDec)
                        !   "aps" is around point source (See also SourceDec and  Ddelta) 
           real*8  SourceDec    !1  Source declination of point source.(deg)
	   real*8  Ddelta       !1  SourceDec $\pm$ Ddelta is the region for 'aps' (deg).
           real*8  HeightOfInj  !1  The vertical height of primary injection point (m).
                                !   If this is $<$ deepest obs. level and zeinth angle of primary is $< 0$, 
                                !   the primary is  assumed to be upgoing even if Reverse =0.
	                        !   NOTE: BorderHeightH must be given explicitly in this case.
	   real*8  OffsetHeight !2  The vertical offset  height from  the deepest detector. 
                                ! The  primary is directed to this height above the detector.

c	<-)	----------------------------------------------------

           common /Zincident/ Azimuth, CosZenith, SourceDec, Ddelta,
     *      HeightOfInj,  OffsetHeight
           common /Zincidentc/ Za1ry
