c          change data in block data part, if needed.
c          for graphic output, you should change ****** line
c      alloc f(sysinc) da('c2g5100.cosmos.gem') shr   is needed
c          use fort command to get result.
*include flux0
c       -------------------------------------------------------------
       block data
*include $flux
c                min. of 1ry; e0cut
           data  e1/ 200./,    e2/ 100000./
c                     original spectrum
c                 p      alfa     l      m(cno)   h       vh     fe
           data
     1     beta1/ 1.7,    1.7,   1.7,   1.6,     1.6,     1.6,   1.4/,
     2     beta2/ 2.,     2.,    2.,    2.,      2.,      2.,     2./,
     3     ebenda/3000., 3000., 3000., 3000., 3000.,  3000.,   3000./
           data  gbend/.true./
c
c                     resamling spectrum
           data
     1    abeta1/ 1.7,    1.7,   1.7,   1.6,     1.6,     1.6,   1.5/,
c    1    abeta1/ 1.7,    1.7,   1.7,   1.6,     1.6,     1.6,   1.6/,
     2    abeta2/ 2.,     2.,    2.,    2.,      2.,      2.,     2./,
     4    enorm/.56, .56, .56, .56, .56, .56, .56/,
     3    aebend/ 100.,  200.,  400., 700., 1200.,  1700.,   2600./
c    3    aebend/ 200.,  400.,  800., 1400., 2400.,  3600.,   5200./
c    3    aebend/ 300.,  600., 1200., 2100., 3600.,  5100.,   7800./
c    3    aebend/ 1000., 2000., 4000., 7000., 12000., 17000., 26000./
c    3    aebend/ 7*3000./,
c             enorm is the minimum energy where the differential
c             flux value is made to be the same as the original one
c
          data agbend/.true./
c
c           aflux: integral flux value (in some unit)
c           eflux: total kinetic energy where aflux is given (tev)
      data aflux/ 42.,    20.,   .6,    14.,     10.,     4.,    10./,
     1     eflux/ .56,    .56,   .56,   .56,     .56,     .56,   .56/
      end
c     -------------------------------------------------------------
*include $flux
c
c
c
         dimension ft(61), dc(maxhg), adc(maxhg)
c
         character*5 pid(maxhg)/' p',' alfa',' l',' m',' h',' vh',' fe'/
         character*200 ttl
         character*16 capx, capy
         capx='total k_e(tev)'
c      *****************************************
         open(13,file='c2s5128.#gd.data')
c      *****************************************
       call flux0(s1,s2,s1r,s2r,s12r, scut, dc, adc)
       write(*,*) ' original spectrum '
       write(*,*) ' beta1=',beta1
       write(*,*) ' beta2=',beta2
       write(*,*) ' e_bend=',ebenda
       write(*,*) '----- p- poor(1)---frj'
       write(*,*) ' resampled spectrum e1=',e1, ' e2=',e2
       write(*,*) ' beta1=',abeta1
       write(*,*) ' beta2=',abeta2
       write(*,*) ' e_bend=',aebend
       write(*,*) ' n1(res)= n1x', s1r/s1
       write(*,*) ' n2(res)= n2x', s2r/s2
       write(*,*) ' n2"(res)= n2"x', s2r/s2
       write(*,*) ' if n1(e>e1) is not at hand, use following'
       write(*,*) ' expected n1(>e1)=n1(>e1*a)*',s1/scut
       write(*,*) ' expected n2"(>e2)=n1(>e1*a)*',s1/scut*s2/s1
       write(*,*) ' expected n2"(res;>e2)=n1(>e1*a)*',s2r/scut
       write(*,*) ' expected n2"(>e2)=n1(>e1)*',s2/s1
       write(*,*) ' expected n2"(res;>e2)=n1(>e1)*',s2r/s1
c      ---------------------------------------------
       write(*,*)
       write(*,*) ' for drawing 1ry spectrum '
       write(*,*)
     * ' enter power of e to be multiplied to the integ. flux(=1.5)'
       pw=1.5
       read(*,*) pw
       write(*,*) ' pw=',pw
       dpw=pw+1.
       write(*,*) ' to see graph, use flux command and give 4 for '
     *     ,'auto-op code'
       write(*,*)
       write(*,*) ' if the standard graph by flux command is no good,'
       write(*,*) 'use gd commad.  fmt=3,111, 2 data in a rec.'
       write(*,*) 'binary mode, curve option.   8 curves overlapping'
c
c         draw  integral flux before resampling
       call ksetrv(ft, 1, 61, 0.)
       write(capy,'(''f(>e)*e**'',f5.2)') pw
       do  300 i=1, maxhg
           if(i .eq. 1) then
               write(ttl,'(''original integral flux:'',a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f6.1)')
     *         pid(i), beta1(i), beta2(i), ebenda(i)
           else
               write(ttl,'(a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), beta1(i), beta2(i), ebenda(i)
           endif
           write(13) ttl
           write(13) capx, capy
           e=enorm(i)
           do 310 j=1, 61
              f=fi1ry(beta1(i), beta2(i), ebenda(i), gbend, e)*dc(i)
              write(13) e, f*e**pw
              e=e*10.**( 1/10.)
              ft(j)=ft(j)+f
  310      continue
           write(13) 1.e50, 1.e50
c
  300  continue
       ttl='total'
       write(13) ttl
       write(13) capx, capy
       e=enorm(1)
       do 400 j=1, 61
          write(13) e, ft(j)*e**pw
          e=e*10.**( 1/10.)
 400   continue
       write(13) 1.e50, 1.e50
c --------------------------------------------
c         draw  diff.    flux before resampling
c
       write(capy,'(''f(e)*e**'',f5.2)') dpw
       call ksetrv(ft, 1, 61, 0.)
       do  1300 i=1, maxhg
           if(i .eq. 1) then
               write(ttl,'(''original dif. flux:'',a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), beta1(i), beta2(i), ebenda(i)
           else
               write(ttl,'(a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), beta1(i), beta2(i), ebenda(i)
           endif
           write(13) ttl
           write(13) capx, capy
           e=enorm(i)
           do 1310 j=1, 61
              f=fd1ry(beta1(i), beta2(i), ebenda(i), gbend, e)*dc(i)
              write(13) e, f*e**dpw
              e=e*10.**( 1/10.)
              ft(j)=ft(j)+f
 1310      continue
           write(13) 1.e50, 1.e50
c
 1300  continue
       ttl='total'
       write(13) ttl
       write(13) capx, capy
       e=enorm(1)
       do 1400 j=1, 61
          write(13) e, ft(j)*e**dpw
          e=e*10.**( 1/10.)
 1400  continue
       write(13) 1.e50, 1.e50
c -----------------------------------------------------------
c         draw  integral flux after  resampling
c
       call ksetrv(ft, 1, 61, 0.)
       write(capy,'(''f(>e)*e**'',f5.2)') pw
       do  500 i=1, maxhg
           if(i .eq. 1) then
               write(ttl,'(''resampled integ. flux:'',a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), abeta1(i), abeta2(i), aebend(i)
           else
               write(ttl,'(a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), abeta1(i), abeta2(i), aebend(i)
           endif
           write(13) ttl
           write(13) capx, capy
           e=enorm(i)
           do 510 j=1, 61
              f=fi1ry(abeta1(i), abeta2(i), aebend(i), agbend, e)*
     *         adc(i)
              write(13) e, f*e**pw
              e=e*10.**( 1/10.)
              ft(j)=ft(j)+f
  510      continue
           write(13) 1.e50, 1.e50
c
  500  continue
       ttl='total'
       write(13) ttl
       write(13) capx, capy
       e=enorm(1)
       do 550 j=1, 61
          write(13) e, ft(j)*e**pw
          e=e*10.**( 1/10.)
 550   continue
       write(13) 1.e50, 1.e50
c
c         draw  diff.    flux after  resampling
c
       call ksetrv(ft, 1, 61, 0.)
       write(capy,'(''f(e)*e**'',f5.2)') dpw
       do 1500 i=1, maxhg
           if(i .eq. 1) then
               write(ttl,'(''resampled dif. flux:'',a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), abeta1(i), abeta2(i), aebend(i)
           else
               write(ttl,'(a,'' b1='',f4.2,
     *         '' b2='',f4.2,'' eb='',f7.1)')
     *         pid(i), abeta1(i), abeta2(i), aebend(i)
           endif
           write(13) ttl
           write(13) capx, capy
           e=enorm(i)
           do 1510 j=1, 61
              f=fd1ry(abeta1(i), abeta2(i), aebend(i), agbend, e)*
     *         adc(i)
              write(13) e, f*e**dpw
              e=e*10.**( 1/10.)
              ft(j)=ft(j)+f
 1510      continue
           write(13) 1.e50, 1.e50
c
 1500  continue
       ttl='total'
       write(13) ttl
       write(13) capx, capy
       e=enorm(1)
       do 1550 j=1, 61
          write(13) e, ft(j)*e**dpw
          e=e*10.**( 1/10.)
 1550  continue
       write(13) 1.e50, 1.e50
       end
c     ******************************************************************
c     *                                                                *
c     * fd1ry: gives differntial 1ry flux                              *
c     *                                                                *
c     ***********************  tested 83.02.28 *************************
c
c    /usage/   flux=fd1ry(b1,b2,eb, gbend, e)
c
c  -- input --
c     b1:  1ry index at e<eb
c     b2:  //            >
c     eb:  bending point of 1ry
c  gbend:  logical.   to show gradually bending 1ry or not.
c
c          if gbend=f  then
c
c                      !  e**-(b1+1) de     at e<eb
c               f(e)de=!
c                      ! eb**(b2-b1) * e**-(b2+1) de     at e>eb
c
c          else
c
c               f(e)de= e**-(b1+1) * (1+e/eb)**(b1-b2) de
c
c          is assumed
c
c    *** note ***
c          if b1 = b2  then eb and gbend are not used and single slope
c          1ry is assumed:  f(e)de= e**-(b1+1)  de
c
c
c  -- process --
c          gives f(e)
c
c  -- output --
c       this is a function program.  unit of flux is arbitray.
c
c                              =   =   =   =
c
                    function fd1ry( b1, b2, eb, gbend, e )
c
      logical gbend
c
      if( b1 .eq. b2 ) then
          fd1ry=e**(-b1-1.)
      elseif(gbend) then
          fd1ry=e**(-b1-1.) * (1. + e/eb)**(b1 - b2)
      elseif( e .lt. eb) then
          fd1ry=e**(-b1-1.)
      else
          fd1ry=eb**(b2-b1) * e**(-b2-1.)
      endif
      return
      end
c     ******************************************************************
c     *                                                                *
c     * fi1ry: gives integral of fd1ry                                 *
c     *                                                                *
c     **********************  tested 83.02.28 **************************
c
c    /usage/   flux=fi1ry(b1,b2,eb, gbend, e)
c
c  -- input --
c     b1:  1ry index at e<eb
c     b2:  //            >
c     eb:  bending point of 1ry
c  gbend:  logical.   to show gradually bending 1ry or not.
c
c          if gbend=f  then
c
c                      !  e**-(b1+1) de     at e<eb
c               f(e)de=!
c                      ! eb**(b2-b1) * e**-(b2+1) de     at e>eb
c
c          else
c
c               f(e)de= e**-(b1+1) * (1+e/eb)**(b1-b2) de
c
c          is assumed
c
c    *** note ***
c          if b1 = b2  then eb and gbend are not used and single slope
c          1ry is assumed:  f(e)de= e**-(b1+1)  de
c
c
c  -- process --
c          gives integral of f(e) de from e to infinity.
c          for gbend=t, numerical integration is done.
c
c  -- output --
c       this is a function program.  unit of flux is arbitray.
c
c                              =   =   =   =
c
                    function fi1ry( b1, b2, eb, gbend, e )
c
c
      logical gbend
c
c
      data xs/.03/, xl/30./, dx/2./
c
c
      external fdg1ry
      common /$fd1ry/  cb1,cb2
c
c
      if( b1 .eq. b2 ) then
          fi1ry=e**(-b1)/b1
      elseif(gbend) then
c
c              gradually bendibg:  divide integration region into 3.
c               x<<1    x around 1   x>>1
c
            x=e/eb
            if(x .lt. xs) then
                ans1=              ( x**(-b1) - xs**(-b1) )/b1 +
     *           (b1-b2)/(1.-b1) * ( xs**(1.-b1) - x**(1.-b1) )
            else
                ans1=0.
            endif
            ans2=0.
            if(x .lt. xl) then
                cb1=b1
                cb2=b2
                x2=amax1(xs, x)
                do 100 while (x2 .lt. xl)
                   x1=x2
                   x2=amin1(x1*dx, xl)
                   call gquad4(fdg1ry, x1, x2, tmp)
                   ans2=ans2+tmp
  100           continue
            endif
            xmin=amax1(xl, x)
            ans3= xmin**(-b2)/b2 + (b1-b2)/(1.+b2) *
     *                               xmin**(-1.-b2)
            fi1ry= (ans1 + ans2 + ans3) *eb**(-b1)
      elseif( e .ge. eb) then
          fi1ry=eb**(-b1) * (eb/e)**b2 /b2
      else
          fi1ry=eb**(-b1) * (1./b2 - 1./b1) +  e**(-b1)/b1
      endif
      return
      end
c           used when integrating bending 1ry
      function fdg1ry(x)
        common /$fd1ry/  cb1,cb2
        fdg1ry=x**(-cb1-1.) * (1.+ x)**(cb1-cb2)
        return
      end
