c     ****************************************************************
c     * cmanager: Managing Cosmos Simulation
c     ****************************************************************
      subroutine cmanager
      implicit none
#include "Zevhnp.h"
c      
      call creadParam(5)        ! read execution conditions from stdin
#ifdef NEXT486
      if(IntModel .eq. 'int1' .and. abs(Elund-500.) .lt. 1.d-5
     *     .and. abs(Elund2-500.) .lt. 1.d-5
     *     .and. abs(Elund3-500.) .lt. 1.d-5) then
         call cerrorMsg(
     *    'Elund* is invalid for Absoft Fortran;they are replaced by'//
     *    ' 4.99', 1)
         Elund = 4.99
         Elund2 = 4.99
         Elund3 = 4.99
      endif
#else
      if(IntModel .eq. 'int1' .and. abs(Elund-4.99) .lt. 1.d-5
     *     .and. abs(Elund2-4.99) .lt. 1.d-5
     *     .and. abs(Elund3-4.99) .lt. 1.d-5 ) then
         call cerrorMsg('For IntMode=int1, Elund* should be 500',1)
         call cerrorMsg('If you want really 4.99'//
     *   ' use 4.985 instead of 4.99', 0)
      endif
#endif
      call cbeginRun            ! initialize the simulation
      call ceventLoop           ! begin simulation and enter  event Loop
      call cendRun              ! close the simulation
      end
      subroutine cqUHookr(i, rv)
      implicit none
#include "Zmanagerp.h"
c           returns i-th userhook real variable value r,
      integer i  ! input.
      real*8  rv  ! output.  r
      if(i .le. 0 .or. i .gt. MAX_USERHOOKR) then
c         call cerrorMsg('out of range for cqUHookr', 0)
         rv = -1.d-60
      else
         rv = UserHookr(i)
      endif
      end
      subroutine cqUHooki(i, iv)
      implicit none
#include "Zmanagerp.h"
c           returns i-th userhook integer variable value iv
      integer i  ! input.
      real*8  iv  ! output.  integer value
      if(i .le. 0 .or. i .gt. MAX_USERHOOKI) then
c         call cerrorMsg('out of range for cqUHooki', 0)
         iv = -9999999
      else
         iv = UserHooki(i)
      endif
      end
      subroutine cqUHookc(i, cv)
      implicit none
#include "Zmanagerp.h"
c           returns i-th userhook character variable value cv
      integer i  ! input.
      character*(*) cv  ! output. blank tail of UserHookc is omitted. 

      integer klena
      if(i .le. 0 .or. i .gt. MAX_USERHOOKC) then
c         call cerrorMsg('out of range for cqUHookc', 0)
         cv = ' '
      else
         cv = UserHookc(i)(1:klena(UserHookc(i)))
      endif
      end
      

