c...test program for
c...the lund monte carlo for hadronic processes - pythia 4.8
c...hans-uno bengtsson, torbjorn sjostrand, january 1987
      common/lujets/n,k(2000,2),p(2000,5)
      common/ludat1/mst(40),par(80)
      common/ludat2/ktyp(120),pmas(120),pwid(60),kfr(80),cfr(40)
      common/ludat3/dpar(20),idb(120),cbr(400),kdp(1600)
      common/pypara/ipy(80),pypar(80),pyvar(80)
      common/pysubs/iselec,isubpr(40),ireac(2,-6:6),iprod(0:10,30)
      dimension icont(100)
      data icont/100*0/, nev/500/, npr/2/

c...test qcd processes at isr energies
      idb(23)=0
      ecm=63.
      call pyinit('cms','p','p',ecm,5.)
       do   iev=1,nev
      call pythia
      dev=abs(plu(0,4)-ecm)+abs(plu(0,1))+abs(plu(0,2))+abs(plu(0,3))+
     &abs(plu(0,6)-2.)
      if(dev.gt.5e-4*ecm) write(6,1000) iev,dev
      if(iev.le.npr) call lulist(1)
      call luedit(3)
       do   i=1,n
      pt=plu(i,10)
      ipt=max(1,min(100,int(10.*pt)))
       enddo
       enddo
      write(6,1100)
       do   ipt=1,100
      ptmin=0.1*(ipt-1)
      ptmax=0.1*ipt
      write(6,1200) ptmin,ptmax,icont(ipt)
       enddo
      call pystat(0)

c...test gauge boson pair production at tevatron i
      iselec=0
       do   i=1,40
       enddo
      isubpr(22)=1
      isubpr(23)=1
      isubpr(24)=1
      ecm=2000.
      call pyinit('cms','p','pbar',ecm,0.)
       do   iev=1,nev
      call pythia
      dev=abs(plu(0,4)-ecm)+abs(plu(0,1))+abs(plu(0,2))+abs(plu(0,3))+
     &10.*abs(plu(0,6))
      if(dev.gt.5e-4*ecm) write(6,1000) iev,dev
      if(iev.le.npr) call lulist(1)
      qt=sqrt(pyvar(19))
      iqt=max(1,min(100,1+int(0.25*qt)))
       enddo
      write(6,1300)
       do   iqt=1,100
      qtmin=4.*(iqt-1)
      qtmax=4.*iqt
      write(6,1400) qtmin,qtmax,icont(iqt)
       enddo
      call pystat(0)

c...test higgs production at ssc energies
      iselec=9
       do   i=1,40
       enddo
      ipy(12)=0
      ipy(13)=0
      ipy(14)=0
      ipy(20)=0
      pmas(4)=500.
      pypar(20)=100.
      ecm=40000.
      call pyinit('cms','p','p',ecm,0.)
       do   iev=1,nev
      call pythia
      dev=abs(plu(0,4)-ecm)+abs(plu(0,1))+abs(plu(0,2))+abs(plu(0,3))+
     &100.*abs(plu(0,6)-2.)
      if(dev.gt.5e-4*ecm) write(6,1000) iev,dev
      if(iev.le.npr) call lulist(1)
       do   i=1,n
       enddo hmass=p(i,5)
      ihm=max(1,min(100,int(0.1*hmass)))
       enddo
      write(6,1500)
       do   ihm=1,100
      hmmin=10.*(ihm-1)
      hmmax=10.*ihm
       enddo hmmin,hmmax,icont(ihm)
      call pystat(0)

c...format statements for table output
 1000 format(/5x,'warning! an error has occured in event no',i5/
     &5x,'energy+momentum+charge nonconservation =',e12.4)
 1100 format(///5x,'single charged particle pt spectrum at isr'//
     &10x,'ptmin     ptmax    number'/)
 1200 format(5x,2f10.3,i10)
 1300 format(///5x,'boson pair hard scattering qt spectrum at tev i'//
     &10x,'ptmin     ptmax    number'/)
 1400 format(5x,2f10.2,i10)
 1500 format(///5x,'higgs mass distribution at ssc'//
     &8x,'massmin   massmax    number'/)
 1600 format(5x,2f10.1,i10)
      end
