	subroutine ciP5F1S35C90(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 3.5cm
c    Cos=0.90
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 0.7e-2 GeV
c

	cs = 0.90
	e1 = 1.d-3
	e2 = 1.
	desingle = 0.85e-2
      end
      subroutine cemP5F1S35C90(e, de)
      implicit none
c           this is for e- incident
c
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=12)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f


      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101), bp065(101), bp0464(101),
     * bp0316(101), bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
      equivalence (b(1,ne-11), bp001(1))
      equivalence (b(1,ne-10), bp0021(1))
      equivalence (b(1,ne-9), bp0046(1))
      equivalence (b(1,ne-8), bp01(1))
      equivalence (b(1,ne-7), bp0215(1))
      equivalence (b(1,ne-6), bp0316(1))
      equivalence (b(1,ne-5), bp0464(1))
      equivalence (b(1,ne-4), bp065(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))

c
	data hx/0.01d0/, hy/0.333333333d0/
c
      data (b1    (i),i=   1,  72)/
     1-3.0000,-2.2432,-2.2235,-2.2129,-2.2048,-2.1963,-2.1883,-2.1819,
     2-2.1751,-2.1669,-2.1582,-2.1492,-2.1404,-2.1325,-2.1220,-2.1115,
     3-2.1011,-2.0899,-2.0789,-2.0685,-2.0544,-2.0361,-2.0185,-2.0077,
     4-1.9917,-1.9740,-1.9572,-1.9361,-1.9218,-1.9093,-1.8955,-1.8823,
     5-1.8704,-1.8586,-1.8471,-1.8362,-1.8252,-1.8140,-1.8026,-1.7903,
     6-1.7786,-1.7656,-1.7505,-1.7379,-1.7271,-1.7171,-1.7078,-1.6993,
     7-1.6918,-1.6857,-1.6790,-1.6717,-1.6646,-1.6583,-1.6523,-1.6461,
     8-1.6406,-1.6337,-1.6249,-1.6168,-1.6093,-1.6013,-1.5924,-1.5848,
     9-1.5782,-1.5711,-1.5640,-1.5569,-1.5502,-1.5429,-1.5348,-1.5267/
      data (b1    (i),i=  73, 101)/
     1-1.5185,-1.5110,-1.5041,-1.4969,-1.4897,-1.4819,-1.4736,-1.4657,
     2-1.4584,-1.4493,-1.4396,-1.4327,-1.4246,-1.4153,-1.4045,-1.3929,
     3-1.3824,-1.3713,-1.3593,-1.3466,-1.3335,-1.3205,-1.3006,-1.2808,
     4-1.2626,-1.2366,-1.2027,-1.1721,-1.0050/
c
      data (bp4640(i),i=   1,  72)/
     1-4.0000,-2.8464,-2.2595,-2.2318,-2.2206,-2.2165,-2.2097,-2.2032,
     2-2.1971,-2.1913,-2.1855,-2.1796,-2.1737,-2.1678,-2.1621,-2.1562,
     3-2.1502,-2.1440,-2.1375,-2.1307,-2.1235,-2.1161,-2.1086,-2.1012,
     4-2.0936,-2.0856,-2.0764,-2.0660,-2.0560,-2.0458,-2.0351,-2.0251,
     5-2.0144,-2.0028,-1.9909,-1.9759,-1.9617,-1.9477,-1.9349,-1.9218,
     6-1.9095,-1.8995,-1.8898,-1.8795,-1.8687,-1.8603,-1.8506,-1.8403,
     7-1.8307,-1.8209,-1.8108,-1.8004,-1.7895,-1.7784,-1.7672,-1.7558,
     8-1.7454,-1.7362,-1.7275,-1.7193,-1.7116,-1.7044,-1.6976,-1.6915,
     9-1.6838,-1.6758,-1.6683,-1.6612,-1.6548,-1.6485,-1.6418,-1.6345/
      data (bp4640(i),i=  73, 101)/
     1-1.6267,-1.6184,-1.6108,-1.6041,-1.5968,-1.5895,-1.5807,-1.5710,
     2-1.5623,-1.5538,-1.5445,-1.5352,-1.5259,-1.5174,-1.5086,-1.4999,
     3-1.4897,-1.4781,-1.4655,-1.4519,-1.4378,-1.4259,-1.4126,-1.3958,
     4-1.3752,-1.3538,-1.3217,-1.2828,-1.0000/
c
      data (bp2154(i),i=   1,  72)/
     1-4.0000,-3.3784,-2.8681,-2.5014,-2.2839,-2.2419,-2.2349,-2.2261,
     2-2.2180,-2.2109,-2.2055,-2.2005,-2.1954,-2.1907,-2.1861,-2.1816,
     3-2.1773,-2.1729,-2.1682,-2.1631,-2.1581,-2.1532,-2.1485,-2.1442,
     4-2.1397,-2.1347,-2.1295,-2.1241,-2.1183,-2.1125,-2.1065,-2.1005,
     5-2.0945,-2.0887,-2.0827,-2.0758,-2.0683,-2.0613,-2.0552,-2.0483,
     6-2.0401,-2.0325,-2.0254,-2.0181,-2.0102,-2.0019,-1.9933,-1.9839,
     7-1.9739,-1.9635,-1.9528,-1.9420,-1.9315,-1.9223,-1.9133,-1.9035,
     8-1.8940,-1.8848,-1.8754,-1.8665,-1.8582,-1.8494,-1.8400,-1.8307,
     9-1.8222,-1.8146,-1.8065,-1.7974,-1.7879,-1.7784,-1.7703,-1.7616/
      data (bp2154(i),i=  73, 101)/
     1-1.7527,-1.7436,-1.7344,-1.7257,-1.7174,-1.7096,-1.7012,-1.6920,
     2-1.6834,-1.6751,-1.6677,-1.6597,-1.6490,-1.6397,-1.6310,-1.6206,
     3-1.6106,-1.6022,-1.5901,-1.5776,-1.5644,-1.5505,-1.5359,-1.5190,
     4-1.4967,-1.4719,-1.4409,-1.3874,-1.1500/
c
      data (bp1   (i),i=   1,  72)/
     1-4.0000,-3.9256,-3.5824,-3.3173,-3.1126,-2.9572,-2.7857,-2.6558,
     2-2.5441,-2.4448,-2.3640,-2.2990,-2.2626,-2.2484,-2.2396,-2.2321,
     3-2.2255,-2.2188,-2.2129,-2.2074,-2.2022,-2.1974,-2.1928,-2.1884,
     4-2.1840,-2.1797,-2.1754,-2.1712,-2.1669,-2.1628,-2.1586,-2.1543,
     5-2.1499,-2.1453,-2.1408,-2.1365,-2.1321,-2.1278,-2.1234,-2.1189,
     6-2.1144,-2.1098,-2.1050,-2.1002,-2.0953,-2.0903,-2.0853,-2.0802,
     7-2.0748,-2.0692,-2.0637,-2.0582,-2.0528,-2.0473,-2.0419,-2.0363,
     8-2.0303,-2.0240,-2.0176,-2.0111,-2.0044,-1.9974,-1.9900,-1.9821,
     9-1.9744,-1.9671,-1.9597,-1.9518,-1.9437,-1.9357,-1.9274,-1.9189/
      data (bp1   (i),i=  73, 101)/
     1-1.9101,-1.9011,-1.8926,-1.8841,-1.8751,-1.8657,-1.8559,-1.8473,
     2-1.8392,-1.8311,-1.8215,-1.8102,-1.8003,-1.7894,-1.7773,-1.7647,
     3-1.7529,-1.7421,-1.7297,-1.7152,-1.6999,-1.6837,-1.6672,-1.6493,
     4-1.6285,-1.6043,-1.5726,-1.5282,-1.3300/
c
      data (bp065 (i),i=   1,  72)/
     1-5.0000,-4.1460,-3.8689,-3.6807,-3.5410,-3.4180,-3.2952,-3.1940,
     2-3.0900,-2.9862,-2.8956,-2.8166,-2.7440,-2.6676,-2.6122,-2.5434,
     3-2.4824,-2.4311,-2.3827,-2.3410,-2.3020,-2.2707,-2.2561,-2.2470,
     4-2.2394,-2.2325,-2.2267,-2.2206,-2.2146,-2.2090,-2.2042,-2.1999,
     5-2.1953,-2.1907,-2.1862,-2.1817,-2.1773,-2.1730,-2.1689,-2.1645,
     6-2.1599,-2.1551,-2.1504,-2.1457,-2.1410,-2.1363,-2.1315,-2.1267,
     7-2.1218,-2.1170,-2.1121,-2.1072,-2.1025,-2.0978,-2.0933,-2.0885,
     8-2.0835,-2.0783,-2.0731,-2.0676,-2.0622,-2.0568,-2.0516,-2.0461,
     9-2.0400,-2.0336,-2.0275,-2.0217,-2.0159,-2.0098,-2.0034,-1.9971/
      data (bp065 (i),i=  73, 101)/
     1-1.9910,-1.9841,-1.9759,-1.9681,-1.9607,-1.9531,-1.9455,-1.9375,
     2-1.9292,-1.9193,-1.9084,-1.8984,-1.8887,-1.8790,-1.8689,-1.8582,
     3-1.8473,-1.8375,-1.8265,-1.8122,-1.7971,-1.7817,-1.7635,-1.7429,
     4-1.7208,-1.6956,-1.6633,-1.6164,-1.4450/
c
      data (bp0464(i),i=   1,  72)/
     1-5.0000,-4.4880,-4.1443,-3.9868,-3.8380,-3.7123,-3.6362,-3.5536,
     2-3.4744,-3.4003,-3.3254,-3.2625,-3.2051,-3.1451,-3.0894,-3.0292,
     3-2.9791,-2.9234,-2.8716,-2.8260,-2.7766,-2.7343,-2.6916,-2.6487,
     4-2.6066,-2.5744,-2.5380,-2.5000,-2.4632,-2.4361,-2.4073,-2.3773,
     5-2.3475,-2.3156,-2.2918,-2.2712,-2.2577,-2.2489,-2.2409,-2.2334,
     6-2.2264,-2.2201,-2.2141,-2.2085,-2.2029,-2.1975,-2.1921,-2.1867,
     7-2.1815,-2.1763,-2.1712,-2.1662,-2.1615,-2.1567,-2.1520,-2.1470,
     8-2.1418,-2.1366,-2.1315,-2.1265,-2.1214,-2.1157,-2.1098,-2.1041,
     9-2.0984,-2.0929,-2.0876,-2.0828,-2.0777,-2.0719,-2.0655,-2.0594/
      data (bp0464(i),i=  73, 101)/
     1-2.0535,-2.0480,-2.0415,-2.0341,-2.0270,-2.0201,-2.0129,-2.0052,
     2-1.9973,-1.9895,-1.9812,-1.9727,-1.9624,-1.9522,-1.9437,-1.9343,
     3-1.9235,-1.9119,-1.9002,-1.8864,-1.8719,-1.8573,-1.8418,-1.8247,
     4-1.8015,-1.7738,-1.7436,-1.6997,-1.5050/
c
      data (bp0316(i),i=   1,  72)/
     1-5.0000,-4.6894,-4.3750,-4.1811,-4.0498,-3.9631,-3.8937,-3.8232,
     2-3.7644,-3.7144,-3.6634,-3.6094,-3.5616,-3.5186,-3.4790,-3.4420,
     3-3.4020,-3.3641,-3.3256,-3.2897,-3.2527,-3.2202,-3.1839,-3.1531,
     4-3.1201,-3.0886,-3.0574,-3.0265,-2.9974,-2.9674,-2.9377,-2.9086,
     5-2.8789,-2.8474,-2.8196,-2.7882,-2.7602,-2.7363,-2.7074,-2.6826,
     6-2.6564,-2.6283,-2.6022,-2.5780,-2.5499,-2.5237,-2.5001,-2.4752,
     7-2.4523,-2.4318,-2.4139,-2.3951,-2.3751,-2.3564,-2.3352,-2.3167,
     8-2.2969,-2.2794,-2.2646,-2.2535,-2.2419,-2.2318,-2.2231,-2.2161,
     9-2.2094,-2.2022,-2.1949,-2.1878,-2.1806,-2.1738,-2.1671,-2.1606/
      data (bp0316(i),i=  73, 101)/
     1-2.1541,-2.1475,-2.1407,-2.1339,-2.1270,-2.1201,-2.1132,-2.1061,
     2-2.0988,-2.0911,-2.0830,-2.0748,-2.0667,-2.0579,-2.0481,-2.0390,
     3-2.0304,-2.0212,-2.0106,-1.9986,-1.9861,-1.9725,-1.9581,-1.9410,
     4-1.9238,-1.9038,-1.8765,-1.8376,-1.7000/
c
      data (bp0215(i),i=   1,  72)/
     1-5.9850,-4.9673,-4.6594,-4.4983,-4.3718,-4.2674,-4.1823,-4.1159,
     2-4.0559,-4.0004,-3.9552,-3.9127,-3.8755,-3.8373,-3.7996,-3.7659,
     3-3.7304,-3.7023,-3.6715,-3.6460,-3.6185,-3.5910,-3.5635,-3.5387,
     4-3.5162,-3.4928,-3.4697,-3.4451,-3.4193,-3.3983,-3.3765,-3.3519,
     5-3.3309,-3.3086,-3.2854,-3.2631,-3.2404,-3.2201,-3.2000,-3.1808,
     6-3.1611,-3.1412,-3.1212,-3.1007,-3.0817,-3.0611,-3.0424,-3.0240,
     7-3.0048,-2.9841,-2.9637,-2.9445,-2.9242,-2.9044,-2.8854,-2.8659,
     8-2.8462,-2.8262,-2.8031,-2.7835,-2.7631,-2.7414,-2.7224,-2.7038,
     9-2.6862,-2.6646,-2.6441,-2.6251,-2.6054,-2.5839,-2.5637,-2.5431/
      data (bp0215(i),i=  73, 101)/
     1-2.5242,-2.5052,-2.4854,-2.4652,-2.4467,-2.4271,-2.4082,-2.3893,
     2-2.3712,-2.3523,-2.3337,-2.3149,-2.2979,-2.2779,-2.2614,-2.2457,
     3-2.2319,-2.2176,-2.2048,-2.1900,-2.1733,-2.1556,-2.1407,-2.1250,
     4-2.1060,-2.0866,-2.0615,-2.0253,-1.8300/
c
      data (bp01  (i),i=   1,  72)/
     1-5.9850,-5.1437,-4.9315,-4.7767,-4.6584,-4.5730,-4.4882,-4.3981,
     2-4.3299,-4.2730,-4.2261,-4.1846,-4.1443,-4.1097,-4.0767,-4.0434,
     3-4.0158,-3.9876,-3.9625,-3.9412,-3.9202,-3.8921,-3.8707,-3.8485,
     4-3.8295,-3.8097,-3.7886,-3.7731,-3.7542,-3.7366,-3.7154,-3.6987,
     5-3.6822,-3.6643,-3.6462,-3.6315,-3.6164,-3.6017,-3.5858,-3.5681,
     6-3.5532,-3.5388,-3.5244,-3.5127,-3.4992,-3.4845,-3.4707,-3.4554,
     7-3.4375,-3.4209,-3.4078,-3.3923,-3.3798,-3.3654,-3.3506,-3.3364,
     8-3.3225,-3.3082,-3.2932,-3.2789,-3.2660,-3.2527,-3.2377,-3.2213,
     9-3.2054,-3.1921,-3.1793,-3.1655,-3.1515,-3.1387,-3.1249,-3.1092/
      data (bp01  (i),i=  73, 101)/
     1-3.0933,-3.0781,-3.0654,-3.0487,-3.0351,-3.0193,-3.0037,-2.9879,
     2-2.9698,-2.9502,-2.9323,-2.9135,-2.8945,-2.8751,-2.8576,-2.8325,
     3-2.8070,-2.7850,-2.7617,-2.7376,-2.7074,-2.6712,-2.6407,-2.6042,
     4-2.5607,-2.5184,-2.4585,-2.3794,-2.1450/
c
      data (bp0046(i),i=   1,  72)/
     1-5.9550,-5.3387,-5.0484,-4.8948,-4.7732,-4.6723,-4.5831,-4.5008,
     2-4.4387,-4.4031,-4.3544,-4.3114,-4.2798,-4.2462,-4.2243,-4.1871,
     3-4.1543,-4.1268,-4.1003,-4.0695,-4.0496,-4.0266,-4.0067,-3.9844,
     4-3.9624,-3.9404,-3.9219,-3.9093,-3.8982,-3.8806,-3.8600,-3.8432,
     5-3.8292,-3.8103,-3.7899,-3.7727,-3.7607,-3.7477,-3.7379,-3.7266,
     6-3.7124,-3.6990,-3.6826,-3.6661,-3.6542,-3.6408,-3.6291,-3.6193,
     7-3.6080,-3.5961,-3.5848,-3.5756,-3.5627,-3.5497,-3.5375,-3.5221,
     8-3.5057,-3.4992,-3.4885,-3.4747,-3.4605,-3.4496,-3.4357,-3.4254,
     9-3.4151,-3.4047,-3.3942,-3.3799,-3.3655,-3.3525,-3.3407,-3.3287/
      data (bp0046(i),i=  73, 101)/
     1-3.3160,-3.3041,-3.2905,-3.2761,-3.2607,-3.2455,-3.2292,-3.2133,
     2-3.1994,-3.1851,-3.1651,-3.1541,-3.1398,-3.1234,-3.1024,-3.0789,
     3-3.0559,-3.0407,-3.0202,-3.0007,-2.9730,-2.9467,-2.9221,-2.8900,
     4-2.8499,-2.8141,-2.7739,-2.6887,-2.4750/
c
      data (bp0021(i),i=   1,  72)/
     1-5.7600,-5.4021,-5.1462,-5.1018,-4.8837,-4.7581,-4.7346,-4.6017,
     2-4.5144,-4.5211,-4.4676,-4.4092,-4.3650,-4.3137,-4.2834,-4.2456,
     3-4.2079,-4.1782,-4.1441,-4.1221,-4.0792,-4.0793,-4.0370,-4.0392,
     4-4.0234,-4.0117,-3.9830,-3.9796,-3.9639,-3.9500,-3.9366,-3.9232,
     5-3.9119,-3.8913,-3.8789,-3.8715,-3.8658,-3.8585,-3.8419,-3.8311,
     6-3.8210,-3.8074,-3.7938,-3.7775,-3.7684,-3.7465,-3.7263,-3.7186,
     7-3.7088,-3.7007,-3.6977,-3.6916,-3.6782,-3.6676,-3.6602,-3.6538,
     8-3.6529,-3.6445,-3.6339,-3.6208,-3.6082,-3.6033,-3.5977,-3.5920,
     9-3.5839,-3.5725,-3.5630,-3.5554,-3.5422,-3.5298,-3.5296,-3.5268/
      data (bp0021(i),i=  73, 101)/
     1-3.5205,-3.5109,-3.4994,-3.4776,-3.4724,-3.4470,-3.4356,-3.4284,
     2-3.4234,-3.4085,-3.3867,-3.3745,-3.3668,-3.3495,-3.3357,-3.3319,
     3-3.3229,-3.3128,-3.3016,-3.2887,-3.2725,-3.2584,-3.2482,-3.2315,
     4-3.2155,-3.1757,-3.0883,-3.0331,-3.0000/
c
      data bp001/5*-6., 6*-5.,90*-4.5/
c
       data zr/1.00, .995, .968,.875, .711, .43,
     *          .192, .078, .049, .025, .01, 0., 0./
c

         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
      subroutine cepP5F1S35C90(e, de)
	implicit none
	real*8 e, de 
c            e+
          call cemP5F1S35C90(e, de)
          if(e .lt. .021) then
c                correction;  7% increase at 10 mev
               de=de* (1. + (.021-e)* 7.)
          endif
      end
      subroutine cgP5F1S35C90(e, de)
      implicit none

c           this is for g  incident
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=11)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)

c
c
c

      real*8 b(101,ne), b1(101),
     *          bp4640(101), bp2154(101),bp1(101), bp0464(101),
     * bp0316(101), bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
      equivalence (b(1,ne-10), bp001(1))
      equivalence (b(1,ne-9), bp0021(1))
      equivalence (b(1,ne-8), bp0046(1))
      equivalence (b(1,ne-7), bp01(1))
      equivalence (b(1,ne-6), bp0215(1))
      equivalence (b(1,ne-5), bp0316(1))
      equivalence (b(1,ne-4), bp0464(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))

	data hx/0.01d0/, hy/0.3333333333d0/
c
      data (b1    (i),i=   1,  72)/
     1-4.7600,-2.5668,-2.2892,-2.1903,-2.1332,-2.0734,-2.0151,-1.9726,
     2-1.9255,-1.9192,-1.9115,-1.9076,-1.9023,-1.8980,-1.8947,-1.8909,
     3-1.8877,-1.8848,-1.8814,-1.8777,-1.8740,-1.8702,-1.8666,-1.8629,
     4-1.8594,-1.8562,-1.8527,-1.8490,-1.8450,-1.8409,-1.8367,-1.8324,
     5-1.8281,-1.8238,-1.8193,-1.8149,-1.8105,-1.8059,-1.8011,-1.7960,
     6-1.7906,-1.7846,-1.7786,-1.7729,-1.7677,-1.7626,-1.7566,-1.7503,
     7-1.7435,-1.7364,-1.7288,-1.7206,-1.7126,-1.7048,-1.6973,-1.6901,
     8-1.6828,-1.6750,-1.6667,-1.6576,-1.6479,-1.6378,-1.6290,-1.6206,
     9-1.6124,-1.6038,-1.5950,-1.5861,-1.5775,-1.5695,-1.5619,-1.5544/
      data (b1    (i),i=  73, 101)/
     1-1.5471,-1.5400,-1.5325,-1.5244,-1.5160,-1.5073,-1.4991,-1.4916,
     2-1.4821,-1.4726,-1.4632,-1.4539,-1.4446,-1.4353,-1.4249,-1.4134,
     3-1.4014,-1.3894,-1.3770,-1.3632,-1.3486,-1.3340,-1.3185,-1.3007,
     4-1.2758,-1.2545,-1.2176,-1.1731,-0.9200/
c
      data (bp4640(i),i=   1,  72)/
     1-4.7750,-2.6042,-2.3021,-2.2039,-2.1730,-2.1447,-2.1126,-2.0790,
     2-2.0449,-2.0141,-1.9837,-1.9561,-1.9335,-1.9243,-1.9157,-1.9107,
     3-1.9060,-1.9016,-1.8983,-1.8951,-1.8916,-1.8884,-1.8854,-1.8822,
     4-1.8789,-1.8756,-1.8722,-1.8689,-1.8656,-1.8624,-1.8592,-1.8561,
     5-1.8529,-1.8497,-1.8464,-1.8430,-1.8396,-1.8362,-1.8327,-1.8291,
     6-1.8257,-1.8220,-1.8181,-1.8140,-1.8098,-1.8055,-1.8011,-1.7966,
     7-1.7920,-1.7873,-1.7825,-1.7775,-1.7720,-1.7661,-1.7601,-1.7541,
     8-1.7480,-1.7417,-1.7352,-1.7288,-1.7224,-1.7159,-1.7096,-1.7036,
     9-1.6970,-1.6897,-1.6825,-1.6752,-1.6680,-1.6610,-1.6539,-1.6467/
      data (bp4640(i),i=  73, 101)/
     1-1.6389,-1.6303,-1.6212,-1.6118,-1.6026,-1.5935,-1.5851,-1.5771,
     2-1.5694,-1.5612,-1.5525,-1.5441,-1.5364,-1.5279,-1.5187,-1.5083,
     3-1.4984,-1.4886,-1.4768,-1.4630,-1.4503,-1.4363,-1.4164,-1.3999,
     4-1.3818,-1.3606,-1.3305,-1.2875,-1.0700/
c
      data (bp2154(i),i=   1,  72)/
     1-5.0000,-2.7894,-2.4564,-2.2688,-2.2216,-2.2062,-2.1914,-2.1755,
     2-2.1616,-2.1466,-2.1325,-2.1163,-2.1019,-2.0862,-2.0719,-2.0545,
     3-2.0373,-2.0203,-2.0013,-1.9850,-1.9678,-1.9515,-1.9374,-1.9278,
     4-1.9226,-1.9165,-1.9116,-1.9071,-1.9032,-1.8993,-1.8959,-1.8924,
     5-1.8890,-1.8858,-1.8825,-1.8792,-1.8759,-1.8725,-1.8692,-1.8659,
     6-1.8628,-1.8596,-1.8567,-1.8536,-1.8505,-1.8472,-1.8438,-1.8403,
     7-1.8368,-1.8333,-1.8297,-1.8260,-1.8223,-1.8186,-1.8149,-1.8112,
     8-1.8074,-1.8034,-1.7994,-1.7953,-1.7911,-1.7869,-1.7828,-1.7785,
     9-1.7740,-1.7692,-1.7643,-1.7591,-1.7536,-1.7478,-1.7419,-1.7361/
      data (bp2154(i),i=  73, 101)/
     1-1.7296,-1.7218,-1.7143,-1.7073,-1.7004,-1.6934,-1.6864,-1.6795,
     2-1.6732,-1.6652,-1.6566,-1.6476,-1.6387,-1.6300,-1.6210,-1.6118,
     3-1.6003,-1.5893,-1.5788,-1.5689,-1.5545,-1.5413,-1.5284,-1.5114,
     4-1.4945,-1.4710,-1.4341,-1.3938,-1.1900/
c
      data (bp1   (i),i=   1,  72)/
     1-5.2500,-3.5235,-3.0406,-2.7561,-2.5711,-2.4404,-2.3490,-2.2755,
     2-2.2472,-2.2285,-2.2205,-2.2114,-2.2027,-2.1937,-2.1856,-2.1783,
     3-2.1708,-2.1632,-2.1555,-2.1477,-2.1402,-2.1331,-2.1249,-2.1159,
     4-2.1074,-2.0990,-2.0908,-2.0823,-2.0734,-2.0642,-2.0548,-2.0467,
     5-2.0377,-2.0269,-2.0169,-2.0073,-1.9977,-1.9867,-1.9761,-1.9669,
     6-1.9578,-1.9487,-1.9393,-1.9304,-1.9253,-1.9206,-1.9155,-1.9107,
     7-1.9062,-1.9019,-1.8979,-1.8942,-1.8902,-1.8862,-1.8823,-1.8782,
     8-1.8743,-1.8705,-1.8668,-1.8630,-1.8593,-1.8555,-1.8520,-1.8482,
     9-1.8443,-1.8400,-1.8355,-1.8312,-1.8270,-1.8230,-1.8189,-1.8146/
      data (bp1   (i),i=  73, 101)/
     1-1.8099,-1.8051,-1.8003,-1.7956,-1.7912,-1.7865,-1.7809,-1.7749,
     2-1.7690,-1.7632,-1.7572,-1.7509,-1.7442,-1.7375,-1.7308,-1.7239,
     3-1.7166,-1.7087,-1.6998,-1.6892,-1.6776,-1.6656,-1.6520,-1.6351,
     4-1.6177,-1.5959,-1.5660,-1.5240,-1.2900/
c
      data (bp0464(i),i=   1,  72)/
     1-5.8950,-4.1592,-3.8345,-3.6276,-3.4540,-3.3358,-3.2241,-3.1321,
     2-3.0338,-2.9327,-2.8612,-2.7911,-2.7179,-2.6576,-2.5975,-2.5491,
     3-2.4924,-2.4497,-2.4092,-2.3769,-2.3475,-2.3147,-2.2837,-2.2657,
     4-2.2517,-2.2406,-2.2318,-2.2247,-2.2175,-2.2104,-2.2038,-2.1981,
     5-2.1927,-2.1869,-2.1809,-2.1750,-2.1693,-2.1636,-2.1576,-2.1511,
     6-2.1449,-2.1388,-2.1329,-2.1271,-2.1218,-2.1162,-2.1095,-2.1026,
     7-2.0965,-2.0916,-2.0858,-2.0795,-2.0727,-2.0660,-2.0590,-2.0515,
     8-2.0437,-2.0363,-2.0297,-2.0225,-2.0150,-2.0078,-2.0012,-1.9941,
     9-1.9860,-1.9778,-1.9693,-1.9616,-1.9546,-1.9471,-1.9388,-1.9310/
      data (bp0464(i),i=  73, 101)/
     1-1.9239,-1.9172,-1.9107,-1.9044,-1.8984,-1.8926,-1.8867,-1.8810,
     2-1.8750,-1.8684,-1.8617,-1.8552,-1.8489,-1.8422,-1.8351,-1.8282,
     3-1.8218,-1.8147,-1.8063,-1.7967,-1.7860,-1.7746,-1.7616,-1.7489,
     4-1.7325,-1.7146,-1.6880,-1.6491,-1.4550/
c
      data (bp0316(i),i=   1,  72)/
     1-5.8200,-4.4488,-4.1730,-3.9842,-3.8488,-3.7331,-3.6365,-3.5408,
     2-3.4700,-3.4066,-3.3397,-3.2741,-3.2154,-3.1607,-3.1125,-3.0567,
     3-3.0022,-2.9573,-2.9170,-2.8793,-2.8356,-2.7986,-2.7577,-2.7160,
     4-2.6778,-2.6366,-2.5977,-2.5614,-2.5315,-2.4979,-2.4650,-2.4337,
     5-2.4027,-2.3753,-2.3543,-2.3315,-2.3073,-2.2905,-2.2751,-2.2594,
     6-2.2513,-2.2431,-2.2358,-2.2284,-2.2211,-2.2138,-2.2064,-2.1999,
     7-2.1940,-2.1884,-2.1828,-2.1777,-2.1718,-2.1652,-2.1589,-2.1528,
     8-2.1469,-2.1406,-2.1341,-2.1274,-2.1206,-2.1137,-2.1069,-2.1000,
     9-2.0931,-2.0862,-2.0791,-2.0717,-2.0630,-2.0545,-2.0465,-2.0382/
      data (bp0316(i),i=  73, 101)/
     1-2.0297,-2.0213,-2.0133,-2.0049,-1.9960,-1.9867,-1.9775,-1.9690,
     2-1.9595,-1.9494,-1.9401,-1.9314,-1.9234,-1.9150,-1.9063,-1.8981,
     3-1.8904,-1.8810,-1.8713,-1.8616,-1.8494,-1.8370,-1.8227,-1.8090,
     4-1.7923,-1.7723,-1.7462,-1.7089,-1.5750/
c
      data (bp0215(i),i=   1,  72)/
     1-5.9550,-4.7887,-4.4445,-4.2735,-4.1250,-4.0048,-3.9154,-3.8545,
     2-3.7854,-3.7174,-3.6646,-3.6145,-3.5626,-3.5124,-3.4689,-3.4259,
     3-3.3839,-3.3395,-3.2957,-3.2543,-3.2235,-3.1799,-3.1467,-3.1139,
     4-3.0815,-3.0514,-3.0173,-2.9805,-2.9449,-2.9057,-2.8755,-2.8407,
     5-2.8097,-2.7784,-2.7445,-2.7151,-2.6805,-2.6515,-2.6236,-2.5913,
     6-2.5650,-2.5395,-2.5168,-2.4901,-2.4682,-2.4476,-2.4250,-2.4021,
     7-2.3792,-2.3630,-2.3446,-2.3297,-2.3130,-2.2966,-2.2834,-2.2713,
     8-2.2604,-2.2521,-2.2442,-2.2369,-2.2296,-2.2225,-2.2154,-2.2085,
     9-2.2011,-2.1933,-2.1861,-2.1798,-2.1728,-2.1654,-2.1580,-2.1506/
      data (bp0215(i),i=  73, 101)/
     1-2.1431,-2.1357,-2.1276,-2.1188,-2.1101,-2.1014,-2.0921,-2.0825,
     2-2.0728,-2.0630,-2.0533,-2.0438,-2.0344,-2.0240,-2.0114,-2.0000,
     3-1.9888,-1.9774,-1.9641,-1.9511,-1.9391,-1.9271,-1.9123,-1.8952,
     4-1.8734,-1.8512,-1.8294,-1.8001,-1.7100/
c
      data (bp01  (i),i=   1,  72)/
     1-5.8200,-5.0196,-4.7101,-4.4958,-4.3545,-4.2444,-4.1508,-4.0759,
     2-4.0162,-3.9432,-3.8933,-3.8524,-3.8022,-3.7648,-3.7208,-3.6826,
     3-3.6512,-3.6142,-3.5870,-3.5574,-3.5212,-3.4845,-3.4417,-3.4093,
     4-3.3740,-3.3405,-3.3107,-3.2716,-3.2446,-3.2166,-3.1928,-3.1613,
     5-3.1320,-3.1015,-3.0782,-3.0503,-3.0277,-3.0040,-2.9724,-2.9453,
     6-2.9154,-2.8889,-2.8649,-2.8382,-2.8132,-2.7902,-2.7712,-2.7452,
     7-2.7181,-2.6975,-2.6788,-2.6602,-2.6423,-2.6218,-2.6075,-2.5882,
     8-2.5706,-2.5532,-2.5390,-2.5245,-2.5082,-2.4918,-2.4781,-2.4661,
     9-2.4539,-2.4409,-2.4272,-2.4150,-2.4035,-2.3912,-2.3776,-2.3630/
      data (bp01  (i),i=  73, 101)/
     1-2.3488,-2.3372,-2.3260,-2.3159,-2.3051,-2.2935,-2.2829,-2.2719,
     2-2.2610,-2.2506,-2.2409,-2.2299,-2.2170,-2.2092,-2.2000,-2.1900,
     3-2.1783,-2.1663,-2.1537,-2.1405,-2.1276,-2.1171,-2.1054,-2.0913,
     4-2.0776,-2.0652,-2.0526,-2.0434,-2.0400/
c
      data (bp0046(i),i=   1,  72)/
     1-5.9700,-4.8039,-4.5230,-4.3390,-4.1728,-4.0761,-3.9940,-3.9357,
     2-3.8749,-3.8190,-3.7720,-3.7281,-3.6833,-3.6312,-3.5821,-3.5445,
     3-3.5110,-3.4734,-3.4367,-3.4082,-3.3703,-3.3390,-3.3036,-3.2777,
     4-3.2568,-3.2371,-3.2083,-3.1832,-3.1679,-3.1443,-3.1229,-3.1068,
     5-3.0860,-3.0654,-3.0420,-3.0221,-3.0068,-2.9907,-2.9780,-2.9576,
     6-2.9378,-2.9223,-2.8991,-2.8795,-2.8599,-2.8479,-2.8363,-2.8221,
     7-2.8075,-2.7941,-2.7798,-2.7674,-2.7558,-2.7419,-2.7272,-2.7147,
     8-2.7028,-2.6906,-2.6782,-2.6643,-2.6502,-2.6413,-2.6289,-2.6180,
     9-2.6088,-2.6001,-2.5907,-2.5806,-2.5713,-2.5620,-2.5525,-2.5439/
      data (bp0046(i),i=  73, 101)/
     1-2.5357,-2.5273,-2.5188,-2.5100,-2.5004,-2.4896,-2.4818,-2.4750,
     2-2.4675,-2.4599,-2.4528,-2.4460,-2.4395,-2.4333,-2.4277,-2.4227,
     3-2.4189,-2.4152,-2.4116,-2.4084,-2.4080,-2.4077,-2.4023,-2.3958,
     4-2.3899,-2.3837,-2.3781,-2.3740,-2.3700/
c
      data (bp0021(i),i=   1,  72)/
     1-5.9550,-4.8405,-4.5569,-4.3901,-4.2721,-4.1568,-4.0782,-4.0178,
     2-3.9505,-3.9131,-3.8579,-3.8183,-3.7771,-3.7411,-3.7102,-3.6783,
     3-3.6449,-3.6188,-3.5950,-3.5681,-3.5441,-3.5177,-3.4930,-3.4718,
     4-3.4509,-3.4317,-3.4105,-3.3904,-3.3678,-3.3505,-3.3372,-3.3197,
     5-3.3028,-3.2861,-3.2715,-3.2579,-3.2415,-3.2277,-3.2136,-3.1998,
     6-3.1834,-3.1678,-3.1552,-3.1414,-3.1270,-3.1130,-3.0999,-3.0875,
     7-3.0792,-3.0672,-3.0540,-3.0417,-3.0303,-3.0196,-3.0082,-2.9963,
     8-2.9858,-2.9764,-2.9667,-2.9566,-2.9463,-2.9363,-2.9267,-2.9171,
     9-2.9078,-2.8992,-2.8903,-2.8813,-2.8730,-2.8649,-2.8566,-2.8484/
      data (bp0021(i),i=  73, 101)/
     1-2.8405,-2.8329,-2.8267,-2.8208,-2.8147,-2.8086,-2.8030,-2.7980,
     2-2.7940,-2.7900,-2.7864,-2.7831,-2.7798,-2.7768,-2.7742,-2.7717,
     3-2.7691,-2.7685,-2.7662,-2.7642,-2.7620,-2.7596,-2.7568,-2.7531,
     4-2.7493,-2.7427,-2.7661,-2.7227,-2.7000/
c
      data (bp001 (i),i=   1,  72)/
     1-5.9850,-5.1164,-4.8602,-4.6819,-4.5468,-4.4532,-4.3795,-4.3143,
     2-4.2526,-4.2010,-4.1583,-4.1096,-4.0760,-4.0404,-4.0121,-3.9785,
     3-3.9500,-3.9187,-3.8910,-3.8667,-3.8394,-3.8149,-3.7963,-3.7774,
     4-3.7561,-3.7358,-3.7189,-3.7015,-3.6849,-3.6704,-3.6577,-3.6428,
     5-3.6262,-3.6128,-3.5984,-3.5823,-3.5679,-3.5541,-3.5402,-3.5251,
     6-3.5120,-3.5003,-3.4890,-3.4776,-3.4640,-3.4528,-3.4424,-3.4320,
     7-3.4214,-3.4105,-3.3999,-3.3896,-3.3790,-3.3685,-3.3582,-3.3469,
     8-3.3362,-3.3258,-3.3155,-3.3061,-3.2961,-3.2850,-3.2751,-3.2660,
     9-3.2576,-3.2493,-3.2413,-3.2341,-3.2273,-3.2205,-3.2139,-3.2076/
      data (bp001 (i),i=  73, 101)/
     1-3.2018,-3.1963,-3.1912,-3.1865,-3.1821,-3.1780,-3.1742,-3.1705,
     2-3.1671,-3.1639,-3.1612,-3.1586,-3.1561,-3.1535,-3.1508,-3.1479,
     3-3.1448,-3.1419,-3.1376,-3.1327,-3.1273,-3.1220,-3.1166,-3.1123,
     4-3.0974,-3.1259,-3.0873,-3.0006,-3.0450/

       data zr/.78, .80, .83, .845, .809, .725,
     *       .622, .556, .505, .48, .455, .432, .426/
c

         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
